{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":338},{"line":347,"kind":13,"name":"$GapChars","containerName":null},{"line":347,"kind":2,"containerName":"strict::Bio::Align::PairwiseStatistics::Bio::Matrix::PhylipDist::Bio::Tools","name":"IUPAC"},{"kind":13,"line":348,"name":"$GCChhars","containerName":null},{"name":"@Nucleotides","containerName":null,"line":349,"kind":13},{"line":350,"kind":13,"name":"$SeqCount","containerName":null},{"containerName":null,"name":"$Precision","kind":13,"line":351},{"kind":13,"line":354,"name":"%NucleotideIndexes","containerName":null},{"name":"$DefaultGapPenalty","containerName":null,"line":379,"kind":13},{"name":"%DNAChanges","containerName":null,"kind":13,"line":381},{"line":392,"kind":13,"containerName":null,"name":"%DistanceMethods"},{"line":402,"kind":2,"containerName":"","name":"base"},{"containerName":null,"name":"$CODONS","kind":13,"line":405},{"name":"get_codons","line":405,"kind":12},{"line":406,"kind":13,"localvar":"my","containerName":null,"name":"@t","definition":"my"},{"containerName":null,"name":"$synsites","kind":13,"line":408},{"line":408,"kind":12,"name":"get_syn_sites"},{"name":"%synchanges","containerName":null,"line":410,"kind":13},{"kind":12,"line":410,"name":"get_syn_changes"},{"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":425,"children":[{"kind":13,"line":426,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":426},{"kind":13,"line":427,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":427,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":427},{"containerName":"new","name":"$self","kind":13,"line":429},{"containerName":"new","name":"pairwise_stats","line":429,"kind":12},{"containerName":"new","name":"new","kind":12,"line":429},{"kind":13,"line":431,"containerName":"new","name":"$self"}],"kind":12,"range":{"start":{"line":425,"character":0},"end":{"line":432,"character":9999}},"name":"new"},{"line":427,"kind":12,"name":"SUPER","containerName":"new"},{"name":"Bio","containerName":"Align::PairwiseStatistics","kind":12,"line":429},{"name":"distance","range":{"end":{"character":9999,"line":466},"start":{"character":0,"line":450}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"distance($self,@args)"},"kind":12,"line":450,"children":[{"localvar":"my","containerName":"distance","name":"$self","definition":"my","line":451,"kind":13},{"line":451,"kind":13,"name":"@args","containerName":"distance"},{"localvar":"my","definition":"my","name":"$aln","containerName":"distance","line":452,"kind":13},{"containerName":"distance","name":"$method","line":452,"kind":13},{"containerName":"distance","name":"$self","line":452,"kind":13},{"line":452,"kind":12,"name":"_rearrange","containerName":"distance"},{"kind":13,"line":452,"containerName":"distance","name":"@args"},{"containerName":"distance","name":"$aln","line":453,"kind":13},{"line":453,"kind":13,"name":"$aln","containerName":"distance"},{"kind":13,"line":453,"name":"$aln","containerName":"distance"},{"containerName":"distance","name":"isa","kind":12,"line":453},{"name":"$self","containerName":"distance","line":454,"kind":13},{"containerName":"distance","name":"throw","kind":12,"line":454},{"line":456,"kind":13,"name":"$method","containerName":"distance"},{"name":"$m","definition":"my","containerName":"distance","localvar":"my","kind":13,"line":457},{"name":"%DistanceMethods","containerName":"distance","kind":13,"line":457},{"containerName":"distance","name":"$m","kind":13,"line":458},{"containerName":"distance","name":"$method","line":458,"kind":13},{"line":459,"kind":13,"localvar":"my","name":"$mtd","definition":"my","containerName":"distance"},{"line":460,"kind":13,"name":"$self","containerName":"distance"},{"containerName":"distance","name":"$mtd","kind":13,"line":460},{"containerName":"distance","name":"$aln","kind":13,"line":460},{"line":463,"kind":13,"name":"$self","containerName":"distance"},{"line":463,"kind":12,"name":"warn","containerName":"distance"},{"containerName":"distance","name":"$self","kind":13,"line":464},{"line":464,"kind":12,"name":"available_distance_methods","containerName":"distance"}]},{"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"available_distance_methods($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":480,"kind":13,"localvar":"my","containerName":"available_distance_methods","name":"$self","definition":"my"},{"kind":13,"line":480,"containerName":"available_distance_methods","name":"@args"},{"name":"%DistanceMethods","containerName":"available_distance_methods","line":481,"kind":13}],"line":479,"kind":12,"range":{"start":{"line":479,"character":0},"end":{"line":482,"character":9999}},"name":"available_distance_methods"},{"name":"D_JukesCantor","range":{"end":{"line":542,"character":9999},"start":{"character":0,"line":503}},"kind":12,"line":503,"children":[{"kind":13,"line":504,"containerName":"D_JukesCantor","definition":"my","name":"$self","localvar":"my"},{"name":"$aln","containerName":"D_JukesCantor","line":504,"kind":13},{"kind":13,"line":504,"name":"$gappenalty","containerName":"D_JukesCantor"},{"name":"$self","containerName":"D_JukesCantor","kind":13,"line":505},{"containerName":"D_JukesCantor","name":"_check_arg","kind":12,"line":505},{"kind":13,"line":505,"containerName":"D_JukesCantor","name":"$aln"},{"containerName":"D_JukesCantor","name":"$gappenalty","line":506,"kind":13},{"containerName":"D_JukesCantor","name":"$DefaultGapPenalty","line":506,"kind":13},{"name":"$gappenalty","containerName":"D_JukesCantor","line":506,"kind":13},{"localvar":"my","name":"@seqs","definition":"my","containerName":"D_JukesCantor","line":508,"kind":13},{"kind":13,"line":508,"containerName":"D_JukesCantor","name":"@names"},{"containerName":"D_JukesCantor","name":"@values","line":508,"kind":13},{"kind":13,"line":508,"name":"%dist","containerName":"D_JukesCantor"},{"line":509,"kind":13,"localvar":"my","definition":"my","name":"$seqct","containerName":"D_JukesCantor"},{"kind":13,"line":510,"containerName":"D_JukesCantor","definition":"my","name":"$seq","localvar":"my"},{"line":510,"kind":13,"name":"$aln","containerName":"D_JukesCantor"},{"line":510,"kind":12,"containerName":"D_JukesCantor","name":"each_seq"},{"line":511,"kind":13,"containerName":"D_JukesCantor","name":"@names"},{"containerName":"D_JukesCantor","name":"$seq","line":511,"kind":13},{"line":511,"kind":12,"name":"display_id","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"@seqs","line":512,"kind":13},{"containerName":"D_JukesCantor","name":"$seq","line":512,"kind":13},{"kind":12,"line":512,"containerName":"D_JukesCantor","name":"seq"},{"kind":13,"line":513,"containerName":"D_JukesCantor","name":"$seqct"},{"line":515,"kind":13,"localvar":"my","definition":"my","name":"$precisionstr","containerName":"D_JukesCantor"},{"kind":13,"line":516,"name":"$i","definition":"my","containerName":"D_JukesCantor","localvar":"my"},{"containerName":"D_JukesCantor","name":"$i","line":516,"kind":13},{"containerName":"D_JukesCantor","name":"$seqct","kind":13,"line":516},{"name":"$i","containerName":"D_JukesCantor","kind":13,"line":516},{"line":518,"kind":13,"containerName":"D_JukesCantor","name":"$dist"},{"line":518,"kind":13,"containerName":"D_JukesCantor","name":"$names"},{"name":"$i","containerName":"D_JukesCantor","line":518,"kind":13},{"name":"$names","containerName":"D_JukesCantor","line":518,"kind":13},{"kind":13,"line":518,"containerName":"D_JukesCantor","name":"$i"},{"kind":13,"line":518,"name":"$i","containerName":"D_JukesCantor"},{"name":"$i","containerName":"D_JukesCantor","line":518,"kind":13},{"kind":13,"line":519,"containerName":"D_JukesCantor","name":"$values"},{"name":"$i","containerName":"D_JukesCantor","kind":13,"line":519},{"line":519,"kind":13,"containerName":"D_JukesCantor","name":"$i"},{"line":519,"kind":13,"name":"$precisionstr","containerName":"D_JukesCantor"},{"kind":13,"line":521,"containerName":"D_JukesCantor","definition":"my","name":"$j","localvar":"my"},{"line":521,"kind":13,"name":"$i","containerName":"D_JukesCantor"},{"line":521,"kind":13,"name":"$j","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"$seqct","kind":13,"line":521},{"name":"$j","containerName":"D_JukesCantor","line":521,"kind":13},{"line":522,"kind":13,"localvar":"my","definition":"my","name":"$matrix","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"$pfreq","kind":13,"line":522},{"line":522,"kind":13,"containerName":"D_JukesCantor","name":"$gaps"},{"name":"$self","containerName":"D_JukesCantor","line":522,"kind":13},{"name":"_build_nt_matrix","containerName":"D_JukesCantor","line":522,"kind":12},{"line":522,"kind":13,"containerName":"D_JukesCantor","name":"$seqs"},{"name":"$i","containerName":"D_JukesCantor","kind":13,"line":522},{"name":"$seqs","containerName":"D_JukesCantor","kind":13,"line":523},{"line":523,"kind":13,"name":"$j","containerName":"D_JukesCantor"},{"kind":13,"line":525,"containerName":"D_JukesCantor","name":"$m","definition":"my","localvar":"my"},{"kind":13,"line":525,"containerName":"D_JukesCantor","name":"$matrix"},{"containerName":"D_JukesCantor","name":"$matrix","kind":13,"line":525},{"kind":13,"line":526,"name":"$matrix","containerName":"D_JukesCantor"},{"kind":13,"line":526,"name":"$matrix","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"$D","definition":"my","localvar":"my","kind":13,"line":527},{"line":527,"kind":13,"name":"$m","containerName":"D_JukesCantor"},{"line":527,"kind":13,"containerName":"D_JukesCantor","name":"$aln"},{"containerName":"D_JukesCantor","name":"length","line":527,"kind":12},{"kind":13,"line":527,"containerName":"D_JukesCantor","name":"$gaps"},{"containerName":"D_JukesCantor","name":"$gaps","kind":13,"line":527},{"containerName":"D_JukesCantor","name":"$gappenalty","line":527,"kind":13},{"kind":13,"line":528,"definition":"my","name":"$d","containerName":"D_JukesCantor","localvar":"my"},{"name":"$D","containerName":"D_JukesCantor","line":528,"kind":13},{"kind":13,"line":530,"name":"$dist","containerName":"D_JukesCantor"},{"line":530,"kind":13,"name":"$names","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"$i","line":530,"kind":13},{"line":530,"kind":13,"name":"$names","containerName":"D_JukesCantor"},{"name":"$j","containerName":"D_JukesCantor","line":530,"kind":13},{"line":530,"kind":13,"name":"$i","containerName":"D_JukesCantor"},{"name":"$j","containerName":"D_JukesCantor","line":530,"kind":13},{"containerName":"D_JukesCantor","name":"$dist","kind":13,"line":531},{"name":"$names","containerName":"D_JukesCantor","kind":13,"line":531},{"kind":13,"line":531,"containerName":"D_JukesCantor","name":"$j"},{"containerName":"D_JukesCantor","name":"$names","kind":13,"line":531},{"line":531,"kind":13,"containerName":"D_JukesCantor","name":"$i"},{"name":"$i","containerName":"D_JukesCantor","line":531,"kind":13},{"containerName":"D_JukesCantor","name":"$j","kind":13,"line":531},{"kind":13,"line":532,"containerName":"D_JukesCantor","name":"$values"},{"containerName":"D_JukesCantor","name":"$j","kind":13,"line":532},{"name":"$i","containerName":"D_JukesCantor","line":532,"kind":13},{"name":"$values","containerName":"D_JukesCantor","kind":13,"line":532},{"containerName":"D_JukesCantor","name":"$i","kind":13,"line":532},{"line":532,"kind":13,"name":"$j","containerName":"D_JukesCantor"},{"line":532,"kind":13,"name":"$precisionstr","containerName":"D_JukesCantor"},{"line":532,"kind":13,"containerName":"D_JukesCantor","name":"$d"},{"line":534,"kind":13,"name":"$dist","containerName":"D_JukesCantor"},{"line":534,"kind":13,"name":"$names","containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","name":"$j","kind":13,"line":534},{"kind":13,"line":534,"name":"$names","containerName":"D_JukesCantor"},{"line":534,"kind":13,"containerName":"D_JukesCantor","name":"$j"},{"line":534,"kind":13,"containerName":"D_JukesCantor","name":"$j"},{"kind":13,"line":534,"containerName":"D_JukesCantor","name":"$j"},{"kind":13,"line":535,"name":"$values","containerName":"D_JukesCantor"},{"line":535,"kind":13,"name":"$j","containerName":"D_JukesCantor"},{"name":"$j","containerName":"D_JukesCantor","line":535,"kind":13},{"name":"$precisionstr","containerName":"D_JukesCantor","line":535,"kind":13},{"name":"new","containerName":"D_JukesCantor","kind":12,"line":538},{"line":539,"kind":13,"name":"%dist","containerName":"D_JukesCantor"},{"kind":13,"line":540,"containerName":"D_JukesCantor","name":"@names"},{"line":541,"kind":13,"name":"@values","containerName":"D_JukesCantor"}],"containerName":"main::","definition":"sub","detail":"($self,$aln,$gappenalty)","signature":{"parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty","label":"D_JukesCantor($self,$aln,$gappenalty)"}},{"containerName":"Matrix::PhylipDist","name":"Bio","line":538,"kind":12},{"range":{"start":{"character":0,"line":558},"end":{"line":598,"character":9999}},"name":"D_F81","detail":"($self,$aln,$gappenalty)","signature":{"label":"D_F81($self,$aln,$gappenalty)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}]},"containerName":"main::","definition":"sub","line":558,"children":[{"line":559,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"D_F81"},{"containerName":"D_F81","name":"$aln","line":559,"kind":13},{"kind":13,"line":559,"containerName":"D_F81","name":"$gappenalty"},{"line":560,"kind":13,"containerName":"D_F81","name":"$self"},{"kind":12,"line":560,"name":"_check_arg","containerName":"D_F81"},{"name":"$aln","containerName":"D_F81","line":560,"kind":13},{"name":"$gappenalty","containerName":"D_F81","line":561,"kind":13},{"line":561,"kind":13,"name":"$DefaultGapPenalty","containerName":"D_F81"},{"line":561,"kind":13,"name":"$gappenalty","containerName":"D_F81"},{"name":"@seqs","definition":"my","containerName":"D_F81","localvar":"my","kind":13,"line":563},{"kind":13,"line":563,"name":"@names","containerName":"D_F81"},{"kind":13,"line":563,"containerName":"D_F81","name":"@values"},{"line":563,"kind":13,"name":"%dist","containerName":"D_F81"},{"kind":13,"line":564,"name":"$seqct","definition":"my","containerName":"D_F81","localvar":"my"},{"line":565,"kind":13,"localvar":"my","containerName":"D_F81","name":"$seq","definition":"my"},{"kind":13,"line":565,"containerName":"D_F81","name":"$aln"},{"kind":12,"line":565,"name":"each_seq","containerName":"D_F81"},{"kind":13,"line":566,"containerName":"D_F81","name":"@names"},{"kind":13,"line":566,"containerName":"D_F81","name":"$seq"},{"line":566,"kind":12,"containerName":"D_F81","name":"display_id"},{"kind":13,"line":567,"containerName":"D_F81","name":"@seqs"},{"kind":13,"line":567,"containerName":"D_F81","name":"$seq"},{"kind":12,"line":567,"name":"seq","containerName":"D_F81"},{"kind":13,"line":568,"containerName":"D_F81","name":"$seqct"},{"kind":13,"line":570,"name":"$precisionstr","definition":"my","containerName":"D_F81","localvar":"my"},{"line":571,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"D_F81"},{"kind":13,"line":571,"containerName":"D_F81","name":"$i"},{"kind":13,"line":571,"name":"$seqct","containerName":"D_F81"},{"containerName":"D_F81","name":"$i","line":571,"kind":13},{"kind":13,"line":573,"name":"$dist","containerName":"D_F81"},{"name":"$names","containerName":"D_F81","line":573,"kind":13},{"containerName":"D_F81","name":"$i","kind":13,"line":573},{"name":"$names","containerName":"D_F81","line":573,"kind":13},{"line":573,"kind":13,"name":"$i","containerName":"D_F81"},{"line":573,"kind":13,"containerName":"D_F81","name":"$i"},{"name":"$i","containerName":"D_F81","kind":13,"line":573},{"containerName":"D_F81","name":"$values","kind":13,"line":574},{"kind":13,"line":574,"name":"$i","containerName":"D_F81"},{"containerName":"D_F81","name":"$i","kind":13,"line":574},{"line":574,"kind":13,"name":"$precisionstr","containerName":"D_F81"},{"localvar":"my","definition":"my","name":"$j","containerName":"D_F81","line":576,"kind":13},{"line":576,"kind":13,"name":"$i","containerName":"D_F81"},{"name":"$j","containerName":"D_F81","kind":13,"line":576},{"containerName":"D_F81","name":"$seqct","kind":13,"line":576},{"line":576,"kind":13,"containerName":"D_F81","name":"$j"},{"kind":13,"line":578,"containerName":"D_F81","name":"$matrix","definition":"my","localvar":"my"},{"line":578,"kind":13,"name":"$pfreq","containerName":"D_F81"},{"kind":13,"line":578,"name":"$gaps","containerName":"D_F81"},{"kind":13,"line":578,"containerName":"D_F81","name":"$self"},{"name":"_build_nt_matrix","containerName":"D_F81","line":578,"kind":12},{"containerName":"D_F81","name":"$seqs","line":578,"kind":13},{"kind":13,"line":578,"name":"$i","containerName":"D_F81"},{"name":"$seqs","containerName":"D_F81","kind":13,"line":579},{"containerName":"D_F81","name":"$j","kind":13,"line":579},{"containerName":"D_F81","definition":"my","name":"$m","localvar":"my","kind":13,"line":581},{"name":"$matrix","containerName":"D_F81","kind":13,"line":581},{"containerName":"D_F81","name":"$matrix","kind":13,"line":581},{"name":"$matrix","containerName":"D_F81","line":582,"kind":13},{"name":"$matrix","containerName":"D_F81","kind":13,"line":582},{"line":583,"kind":13,"localvar":"my","containerName":"D_F81","definition":"my","name":"$D"},{"name":"$m","containerName":"D_F81","kind":13,"line":583},{"kind":13,"line":583,"name":"$aln","containerName":"D_F81"},{"kind":12,"line":583,"name":"length","containerName":"D_F81"},{"kind":13,"line":583,"name":"$gaps","containerName":"D_F81"},{"line":583,"kind":13,"name":"$gaps","containerName":"D_F81"},{"line":583,"kind":13,"containerName":"D_F81","name":"$gappenalty"},{"line":584,"kind":13,"localvar":"my","definition":"my","name":"$d","containerName":"D_F81"},{"name":"$D","containerName":"D_F81","kind":13,"line":584},{"kind":13,"line":586,"containerName":"D_F81","name":"$dist"},{"line":586,"kind":13,"containerName":"D_F81","name":"$names"},{"containerName":"D_F81","name":"$i","line":586,"kind":13},{"name":"$names","containerName":"D_F81","line":586,"kind":13},{"name":"$j","containerName":"D_F81","line":586,"kind":13},{"line":586,"kind":13,"name":"$i","containerName":"D_F81"},{"containerName":"D_F81","name":"$j","line":586,"kind":13},{"containerName":"D_F81","name":"$dist","kind":13,"line":587},{"name":"$names","containerName":"D_F81","line":587,"kind":13},{"kind":13,"line":587,"containerName":"D_F81","name":"$j"},{"containerName":"D_F81","name":"$names","line":587,"kind":13},{"containerName":"D_F81","name":"$i","line":587,"kind":13},{"containerName":"D_F81","name":"$i","kind":13,"line":587},{"line":587,"kind":13,"name":"$j","containerName":"D_F81"},{"line":588,"kind":13,"containerName":"D_F81","name":"$values"},{"name":"$j","containerName":"D_F81","line":588,"kind":13},{"name":"$i","containerName":"D_F81","kind":13,"line":588},{"line":588,"kind":13,"name":"$values","containerName":"D_F81"},{"name":"$i","containerName":"D_F81","line":588,"kind":13},{"line":588,"kind":13,"containerName":"D_F81","name":"$j"},{"containerName":"D_F81","name":"$precisionstr","line":588,"kind":13},{"name":"$d","containerName":"D_F81","line":588,"kind":13},{"containerName":"D_F81","name":"$dist","line":590,"kind":13},{"line":590,"kind":13,"containerName":"D_F81","name":"$names"},{"kind":13,"line":590,"name":"$j","containerName":"D_F81"},{"containerName":"D_F81","name":"$names","line":590,"kind":13},{"name":"$j","containerName":"D_F81","kind":13,"line":590},{"kind":13,"line":590,"name":"$j","containerName":"D_F81"},{"kind":13,"line":590,"name":"$j","containerName":"D_F81"},{"name":"$values","containerName":"D_F81","kind":13,"line":591},{"line":591,"kind":13,"containerName":"D_F81","name":"$j"},{"name":"$j","containerName":"D_F81","line":591,"kind":13},{"name":"$precisionstr","containerName":"D_F81","line":591,"kind":13},{"containerName":"D_F81","name":"new","kind":12,"line":594},{"kind":13,"line":595,"name":"%dist","containerName":"D_F81"},{"name":"@names","containerName":"D_F81","line":596,"kind":13},{"line":597,"kind":13,"name":"@values","containerName":"D_F81"}],"kind":12},{"line":594,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"name":"D_Uncorrected","range":{"end":{"character":9999,"line":653},"start":{"character":0,"line":612}},"kind":12,"children":[{"localvar":"my","containerName":"D_Uncorrected","definition":"my","name":"$self","line":613,"kind":13},{"name":"$aln","containerName":"D_Uncorrected","kind":13,"line":613},{"containerName":"D_Uncorrected","name":"$gappenalty","line":613,"kind":13},{"name":"$gappenalty","containerName":"D_Uncorrected","kind":13,"line":614},{"kind":13,"line":614,"containerName":"D_Uncorrected","name":"$DefaultGapPenalty"},{"containerName":"D_Uncorrected","name":"$gappenalty","kind":13,"line":614},{"kind":13,"line":615,"name":"$self","containerName":"D_Uncorrected"},{"line":615,"kind":12,"containerName":"D_Uncorrected","name":"_check_arg"},{"containerName":"D_Uncorrected","name":"$aln","line":615,"kind":13},{"kind":13,"line":617,"containerName":"D_Uncorrected","definition":"my","name":"@seqs","localvar":"my"},{"containerName":"D_Uncorrected","name":"@names","line":617,"kind":13},{"name":"@values","containerName":"D_Uncorrected","kind":13,"line":617},{"name":"%dist","containerName":"D_Uncorrected","kind":13,"line":617},{"line":618,"kind":13,"localvar":"my","name":"$seqct","definition":"my","containerName":"D_Uncorrected"},{"kind":13,"line":619,"definition":"my","name":"$seq","containerName":"D_Uncorrected","localvar":"my"},{"name":"$aln","containerName":"D_Uncorrected","kind":13,"line":619},{"line":619,"kind":12,"name":"each_seq","containerName":"D_Uncorrected"},{"line":620,"kind":13,"name":"@names","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$seq","line":620,"kind":13},{"kind":12,"line":620,"name":"display_id","containerName":"D_Uncorrected"},{"line":621,"kind":13,"name":"@seqs","containerName":"D_Uncorrected"},{"kind":13,"line":621,"containerName":"D_Uncorrected","name":"$seq"},{"containerName":"D_Uncorrected","name":"seq","kind":12,"line":621},{"name":"$seqct","containerName":"D_Uncorrected","kind":13,"line":622},{"localvar":"my","definition":"my","name":"$precisionstr","containerName":"D_Uncorrected","line":625,"kind":13},{"kind":13,"line":626,"definition":"my","name":"$len","containerName":"D_Uncorrected","localvar":"my"},{"line":626,"kind":13,"name":"$aln","containerName":"D_Uncorrected"},{"name":"length","containerName":"D_Uncorrected","kind":12,"line":626},{"localvar":"my","containerName":"D_Uncorrected","name":"$i","definition":"my","line":627,"kind":13},{"kind":13,"line":627,"name":"$i","containerName":"D_Uncorrected"},{"line":627,"kind":13,"containerName":"D_Uncorrected","name":"$seqct"},{"line":627,"kind":13,"name":"$i","containerName":"D_Uncorrected"},{"kind":13,"line":629,"containerName":"D_Uncorrected","name":"$dist"},{"kind":13,"line":629,"name":"$names","containerName":"D_Uncorrected"},{"name":"$i","containerName":"D_Uncorrected","kind":13,"line":629},{"name":"$names","containerName":"D_Uncorrected","kind":13,"line":629},{"containerName":"D_Uncorrected","name":"$i","line":629,"kind":13},{"kind":13,"line":629,"name":"$i","containerName":"D_Uncorrected"},{"line":629,"kind":13,"name":"$i","containerName":"D_Uncorrected"},{"line":630,"kind":13,"name":"$values","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$i","line":630,"kind":13},{"containerName":"D_Uncorrected","name":"$i","kind":13,"line":630},{"containerName":"D_Uncorrected","name":"$precisionstr","kind":13,"line":630},{"name":"$j","definition":"my","containerName":"D_Uncorrected","localvar":"my","kind":13,"line":632},{"containerName":"D_Uncorrected","name":"$i","kind":13,"line":632},{"name":"$j","containerName":"D_Uncorrected","line":632,"kind":13},{"name":"$seqct","containerName":"D_Uncorrected","line":632,"kind":13},{"name":"$j","containerName":"D_Uncorrected","line":632,"kind":13},{"containerName":"D_Uncorrected","definition":"my","name":"$matrix","localvar":"my","kind":13,"line":633},{"line":633,"kind":13,"name":"$pfreq","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$gaps","line":633,"kind":13},{"line":633,"kind":13,"name":"$self","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"_build_nt_matrix","line":633,"kind":12},{"line":633,"kind":13,"name":"$seqs","containerName":"D_Uncorrected"},{"line":633,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"line":634,"kind":13,"name":"$seqs","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$j","line":634,"kind":13},{"definition":"my","name":"$m","containerName":"D_Uncorrected","localvar":"my","kind":13,"line":635},{"line":635,"kind":13,"name":"$matrix","containerName":"D_Uncorrected"},{"name":"$matrix","containerName":"D_Uncorrected","kind":13,"line":636},{"line":637,"kind":13,"containerName":"D_Uncorrected","name":"$matrix"},{"containerName":"D_Uncorrected","name":"$matrix","line":638,"kind":13},{"line":639,"kind":13,"localvar":"my","definition":"my","name":"$D","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$m","kind":13,"line":639},{"containerName":"D_Uncorrected","name":"$len","kind":13,"line":639},{"kind":13,"line":639,"name":"$gaps","containerName":"D_Uncorrected"},{"name":"$gaps","containerName":"D_Uncorrected","kind":13,"line":639},{"containerName":"D_Uncorrected","name":"$gappenalty","line":639,"kind":13},{"containerName":"D_Uncorrected","name":"$dist","kind":13,"line":641},{"line":641,"kind":13,"name":"$names","containerName":"D_Uncorrected"},{"kind":13,"line":641,"name":"$i","containerName":"D_Uncorrected"},{"name":"$names","containerName":"D_Uncorrected","kind":13,"line":641},{"name":"$j","containerName":"D_Uncorrected","line":641,"kind":13},{"containerName":"D_Uncorrected","name":"$i","line":641,"kind":13},{"containerName":"D_Uncorrected","name":"$j","kind":13,"line":641},{"name":"$dist","containerName":"D_Uncorrected","line":642,"kind":13},{"name":"$names","containerName":"D_Uncorrected","line":642,"kind":13},{"kind":13,"line":642,"name":"$j","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$names","line":642,"kind":13},{"kind":13,"line":642,"name":"$i","containerName":"D_Uncorrected"},{"name":"$i","containerName":"D_Uncorrected","kind":13,"line":642},{"name":"$j","containerName":"D_Uncorrected","kind":13,"line":642},{"containerName":"D_Uncorrected","name":"$values","kind":13,"line":643},{"name":"$j","containerName":"D_Uncorrected","line":643,"kind":13},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"containerName":"D_Uncorrected","name":"$values","kind":13,"line":643},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"name":"$j","containerName":"D_Uncorrected","kind":13,"line":643},{"containerName":"D_Uncorrected","name":"$precisionstr","line":643,"kind":13},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$D"},{"name":"$dist","containerName":"D_Uncorrected","kind":13,"line":645},{"kind":13,"line":645,"name":"$names","containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","name":"$j","kind":13,"line":645},{"containerName":"D_Uncorrected","name":"$names","kind":13,"line":645},{"kind":13,"line":645,"containerName":"D_Uncorrected","name":"$j"},{"kind":13,"line":645,"containerName":"D_Uncorrected","name":"$j"},{"kind":13,"line":645,"name":"$j","containerName":"D_Uncorrected"},{"name":"$values","containerName":"D_Uncorrected","kind":13,"line":646},{"containerName":"D_Uncorrected","name":"$j","line":646,"kind":13},{"containerName":"D_Uncorrected","name":"$j","kind":13,"line":646},{"line":646,"kind":13,"name":"$precisionstr","containerName":"D_Uncorrected"},{"line":649,"kind":12,"containerName":"D_Uncorrected","name":"new"},{"containerName":"D_Uncorrected","name":"%dist","line":650,"kind":13},{"containerName":"D_Uncorrected","name":"@names","kind":13,"line":651},{"containerName":"D_Uncorrected","name":"@values","line":652,"kind":13}],"line":612,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"label":"D_Uncorrected($self,$aln,$gappenalty)"},"detail":"($self,$aln,$gappenalty)"},{"name":"Bio","containerName":"Matrix::PhylipDist","kind":12,"line":649},{"containerName":"main::","definition":"sub","detail":"($self,$aln)","signature":{"label":"D_Kimura($self,$aln)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}]},"kind":12,"line":670,"children":[{"kind":13,"line":671,"definition":"my","name":"$self","containerName":"D_Kimura","localvar":"my"},{"kind":13,"line":671,"name":"$aln","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$self","kind":13,"line":672},{"line":672,"kind":12,"containerName":"D_Kimura","name":"_check_arg"},{"kind":13,"line":672,"name":"$aln","containerName":"D_Kimura"},{"containerName":"D_Kimura","definition":"my","name":"@names","localvar":"my","kind":13,"line":674},{"name":"@values","containerName":"D_Kimura","kind":13,"line":674},{"line":674,"kind":13,"name":"%dist","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$seqct","definition":"my","localvar":"my","kind":13,"line":675},{"containerName":"D_Kimura","name":"$seq","definition":"my","localvar":"my","kind":13,"line":676},{"containerName":"D_Kimura","name":"$aln","kind":13,"line":676},{"line":676,"kind":12,"name":"each_seq","containerName":"D_Kimura"},{"name":"@names","containerName":"D_Kimura","line":677,"kind":13},{"containerName":"D_Kimura","name":"$seq","kind":13,"line":677},{"name":"display_id","containerName":"D_Kimura","kind":12,"line":677},{"name":"$seqct","containerName":"D_Kimura","kind":13,"line":678},{"definition":"my","name":"$precisionstr","containerName":"D_Kimura","localvar":"my","kind":13,"line":681},{"localvar":"my","containerName":"D_Kimura","name":"$i","definition":"my","line":683,"kind":13},{"line":683,"kind":13,"name":"$i","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$seqct","kind":13,"line":683},{"name":"$i","containerName":"D_Kimura","kind":13,"line":683},{"name":"$dist","containerName":"D_Kimura","kind":13,"line":685},{"line":685,"kind":13,"name":"$names","containerName":"D_Kimura"},{"kind":13,"line":685,"name":"$i","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$names","kind":13,"line":685},{"name":"$i","containerName":"D_Kimura","line":685,"kind":13},{"line":685,"kind":13,"name":"$i","containerName":"D_Kimura"},{"kind":13,"line":685,"containerName":"D_Kimura","name":"$i"},{"kind":13,"line":686,"name":"$values","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$i","line":686,"kind":13},{"line":686,"kind":13,"name":"$i","containerName":"D_Kimura"},{"name":"$precisionstr","containerName":"D_Kimura","line":686,"kind":13},{"line":688,"kind":13,"localvar":"my","definition":"my","name":"$j","containerName":"D_Kimura"},{"kind":13,"line":688,"name":"$i","containerName":"D_Kimura"},{"line":688,"kind":13,"containerName":"D_Kimura","name":"$j"},{"containerName":"D_Kimura","name":"$seqct","line":688,"kind":13},{"line":688,"kind":13,"containerName":"D_Kimura","name":"$j"},{"localvar":"my","containerName":"D_Kimura","definition":"my","name":"$pairwise","line":689,"kind":13},{"containerName":"D_Kimura","name":"$aln","line":689,"kind":13},{"line":689,"kind":12,"containerName":"D_Kimura","name":"select_noncont"},{"line":689,"kind":13,"name":"$i","containerName":"D_Kimura"},{"kind":13,"line":689,"containerName":"D_Kimura","name":"$j"},{"line":690,"kind":13,"localvar":"my","definition":"my","name":"$L","containerName":"D_Kimura"},{"name":"$self","containerName":"D_Kimura","line":690,"kind":13},{"line":690,"kind":12,"name":"pairwise_stats","containerName":"D_Kimura"},{"name":"number_of_comparable_bases","containerName":"D_Kimura","kind":12,"line":690},{"kind":13,"line":690,"containerName":"D_Kimura","name":"$pairwise"},{"line":691,"kind":13,"name":"$L","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$L","kind":13,"line":692},{"line":694,"kind":13,"localvar":"my","name":"$P","definition":"my","containerName":"D_Kimura"},{"kind":13,"line":694,"containerName":"D_Kimura","name":"$self"},{"name":"transitions","containerName":"D_Kimura","kind":12,"line":694},{"line":694,"kind":13,"containerName":"D_Kimura","name":"$pairwise"},{"kind":13,"line":694,"containerName":"D_Kimura","name":"$L"},{"line":695,"kind":13,"localvar":"my","definition":"my","name":"$Q","containerName":"D_Kimura"},{"name":"$self","containerName":"D_Kimura","line":695,"kind":13},{"containerName":"D_Kimura","name":"transversions","line":695,"kind":12},{"kind":13,"line":695,"name":"$pairwise","containerName":"D_Kimura"},{"line":695,"kind":13,"name":"$L","containerName":"D_Kimura"},{"line":696,"kind":13,"localvar":"my","containerName":"D_Kimura","definition":"my","name":"$K"},{"line":697,"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$denom","definition":"my"},{"line":697,"kind":13,"name":"$P","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$Q","kind":13,"line":697},{"name":"$denom","containerName":"D_Kimura","line":698,"kind":13},{"name":"$self","containerName":"D_Kimura","line":699,"kind":13},{"containerName":"D_Kimura","name":"throw","kind":12,"line":699},{"name":"$i","containerName":"D_Kimura","line":699,"kind":13},{"line":700,"kind":13,"name":"$j","containerName":"D_Kimura"},{"name":"$a","definition":"my","containerName":"D_Kimura","localvar":"my","kind":13,"line":702},{"kind":13,"line":702,"name":"$P","containerName":"D_Kimura"},{"kind":13,"line":702,"name":"$Q","containerName":"D_Kimura"},{"line":703,"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$b","definition":"my"},{"kind":13,"line":703,"name":"$Q","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$a","kind":13,"line":704},{"containerName":"D_Kimura","name":"$b","line":704,"kind":13},{"kind":13,"line":705,"containerName":"D_Kimura","name":"$K"},{"line":707,"kind":13,"name":"$K","containerName":"D_Kimura"},{"kind":13,"line":707,"containerName":"D_Kimura","name":"$a"},{"containerName":"D_Kimura","name":"$b","line":707,"kind":13},{"containerName":"D_Kimura","name":"$dist","line":710,"kind":13},{"kind":13,"line":710,"containerName":"D_Kimura","name":"$names"},{"line":710,"kind":13,"containerName":"D_Kimura","name":"$i"},{"line":710,"kind":13,"name":"$names","containerName":"D_Kimura"},{"name":"$j","containerName":"D_Kimura","kind":13,"line":710},{"name":"$i","containerName":"D_Kimura","line":710,"kind":13},{"line":710,"kind":13,"name":"$j","containerName":"D_Kimura"},{"name":"$dist","containerName":"D_Kimura","kind":13,"line":711},{"kind":13,"line":711,"name":"$names","containerName":"D_Kimura"},{"line":711,"kind":13,"name":"$j","containerName":"D_Kimura"},{"line":711,"kind":13,"containerName":"D_Kimura","name":"$names"},{"name":"$i","containerName":"D_Kimura","line":711,"kind":13},{"containerName":"D_Kimura","name":"$i","line":711,"kind":13},{"kind":13,"line":711,"containerName":"D_Kimura","name":"$j"},{"name":"$values","containerName":"D_Kimura","kind":13,"line":712},{"line":712,"kind":13,"containerName":"D_Kimura","name":"$j"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":712},{"line":712,"kind":13,"name":"$values","containerName":"D_Kimura"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":712},{"kind":13,"line":712,"containerName":"D_Kimura","name":"$j"},{"name":"$precisionstr","containerName":"D_Kimura","kind":13,"line":712},{"line":712,"kind":13,"containerName":"D_Kimura","name":"$K"},{"name":"$dist","containerName":"D_Kimura","kind":13,"line":714},{"name":"$names","containerName":"D_Kimura","kind":13,"line":714},{"name":"$j","containerName":"D_Kimura","kind":13,"line":714},{"containerName":"D_Kimura","name":"$names","line":714,"kind":13},{"containerName":"D_Kimura","name":"$j","line":714,"kind":13},{"kind":13,"line":714,"name":"$j","containerName":"D_Kimura"},{"name":"$j","containerName":"D_Kimura","line":714,"kind":13},{"name":"$values","containerName":"D_Kimura","kind":13,"line":715},{"containerName":"D_Kimura","name":"$j","line":715,"kind":13},{"containerName":"D_Kimura","name":"$j","line":715,"kind":13},{"kind":13,"line":715,"name":"$precisionstr","containerName":"D_Kimura"},{"name":"new","containerName":"D_Kimura","kind":12,"line":718},{"line":719,"kind":13,"containerName":"D_Kimura","name":"%dist"},{"kind":13,"line":720,"name":"@names","containerName":"D_Kimura"},{"name":"@values","containerName":"D_Kimura","line":721,"kind":13}],"name":"D_Kimura","range":{"end":{"line":722,"character":9999},"start":{"character":0,"line":670}}},{"line":718,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"range":{"end":{"line":804,"character":9999},"start":{"character":0,"line":739}},"name":"D_Kimura_variance","children":[{"line":740,"kind":13,"localvar":"my","containerName":"D_Kimura_variance","name":"$self","definition":"my"},{"name":"$aln","containerName":"D_Kimura_variance","kind":13,"line":740},{"containerName":"D_Kimura_variance","name":"$self","line":741,"kind":13},{"line":741,"kind":12,"containerName":"D_Kimura_variance","name":"_check_arg"},{"containerName":"D_Kimura_variance","name":"$aln","line":741,"kind":13},{"line":743,"kind":13,"localvar":"my","containerName":"D_Kimura_variance","name":"@names","definition":"my"},{"name":"@values","containerName":"D_Kimura_variance","kind":13,"line":743},{"kind":13,"line":743,"containerName":"D_Kimura_variance","name":"%dist"},{"name":"@var","containerName":"D_Kimura_variance","kind":13,"line":743},{"containerName":"D_Kimura_variance","definition":"my","name":"$seqct","localvar":"my","kind":13,"line":744},{"line":745,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$aln","kind":13,"line":745},{"line":745,"kind":12,"name":"each_seq","containerName":"D_Kimura_variance"},{"kind":13,"line":746,"containerName":"D_Kimura_variance","name":"@names"},{"line":746,"kind":13,"name":"$seq","containerName":"D_Kimura_variance"},{"line":746,"kind":12,"containerName":"D_Kimura_variance","name":"display_id"},{"line":747,"kind":13,"containerName":"D_Kimura_variance","name":"$seqct"},{"name":"$precisionstr","definition":"my","containerName":"D_Kimura_variance","localvar":"my","kind":13,"line":750},{"line":752,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"D_Kimura_variance"},{"kind":13,"line":752,"name":"$i","containerName":"D_Kimura_variance"},{"kind":13,"line":752,"containerName":"D_Kimura_variance","name":"$seqct"},{"containerName":"D_Kimura_variance","name":"$i","kind":13,"line":752},{"line":754,"kind":13,"name":"$dist","containerName":"D_Kimura_variance"},{"kind":13,"line":754,"containerName":"D_Kimura_variance","name":"$names"},{"kind":13,"line":754,"containerName":"D_Kimura_variance","name":"$i"},{"kind":13,"line":754,"name":"$names","containerName":"D_Kimura_variance"},{"kind":13,"line":754,"name":"$i","containerName":"D_Kimura_variance"},{"line":754,"kind":13,"name":"$i","containerName":"D_Kimura_variance"},{"name":"$i","containerName":"D_Kimura_variance","line":754,"kind":13},{"line":755,"kind":13,"containerName":"D_Kimura_variance","name":"$values"},{"line":755,"kind":13,"name":"$i","containerName":"D_Kimura_variance"},{"name":"$i","containerName":"D_Kimura_variance","line":755,"kind":13},{"name":"$precisionstr","containerName":"D_Kimura_variance","kind":13,"line":755},{"localvar":"my","containerName":"D_Kimura_variance","name":"$j","definition":"my","line":757,"kind":13},{"name":"$i","containerName":"D_Kimura_variance","kind":13,"line":757},{"line":757,"kind":13,"name":"$j","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$seqct","kind":13,"line":757},{"name":"$j","containerName":"D_Kimura_variance","line":757,"kind":13},{"name":"$pairwise","definition":"my","containerName":"D_Kimura_variance","localvar":"my","kind":13,"line":758},{"line":758,"kind":13,"name":"$aln","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"select_noncont","kind":12,"line":758},{"containerName":"D_Kimura_variance","name":"$i","kind":13,"line":758},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":758},{"localvar":"my","definition":"my","name":"$L","containerName":"D_Kimura_variance","line":759,"kind":13},{"name":"$self","containerName":"D_Kimura_variance","kind":13,"line":759},{"kind":12,"line":759,"name":"pairwise_stats","containerName":"D_Kimura_variance"},{"line":759,"kind":12,"containerName":"D_Kimura_variance","name":"number_of_comparable_bases"},{"kind":13,"line":759,"containerName":"D_Kimura_variance","name":"$pairwise"},{"name":"$L","containerName":"D_Kimura_variance","kind":13,"line":760},{"containerName":"D_Kimura_variance","name":"$L","line":761,"kind":13},{"localvar":"my","name":"$P","definition":"my","containerName":"D_Kimura_variance","line":763,"kind":13},{"name":"$self","containerName":"D_Kimura_variance","kind":13,"line":763},{"line":763,"kind":12,"containerName":"D_Kimura_variance","name":"transitions"},{"kind":13,"line":763,"containerName":"D_Kimura_variance","name":"$pairwise"},{"line":763,"kind":13,"name":"$L","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$Q","definition":"my","localvar":"my","kind":13,"line":764},{"name":"$self","containerName":"D_Kimura_variance","line":764,"kind":13},{"containerName":"D_Kimura_variance","name":"transversions","kind":12,"line":764},{"kind":13,"line":764,"containerName":"D_Kimura_variance","name":"$pairwise"},{"kind":13,"line":764,"name":"$L","containerName":"D_Kimura_variance"},{"line":765,"kind":13,"localvar":"my","containerName":"D_Kimura_variance","name":"$a","definition":"my"},{"kind":13,"line":765,"containerName":"D_Kimura_variance","name":"$b"},{"line":765,"kind":13,"containerName":"D_Kimura_variance","name":"$K"},{"name":"$var_k","containerName":"D_Kimura_variance","line":765,"kind":13},{"line":766,"kind":13,"localvar":"my","definition":"my","name":"$a_denom","containerName":"D_Kimura_variance"},{"name":"$P","containerName":"D_Kimura_variance","line":766,"kind":13},{"kind":13,"line":766,"containerName":"D_Kimura_variance","name":"$Q"},{"containerName":"D_Kimura_variance","name":"$b_denom","definition":"my","localvar":"my","kind":13,"line":767},{"line":767,"kind":13,"name":"$Q","containerName":"D_Kimura_variance"},{"kind":13,"line":768,"name":"$a_denom","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$b_denom","kind":13,"line":768},{"name":"$a","containerName":"D_Kimura_variance","kind":13,"line":769},{"kind":13,"line":770,"name":"$b","containerName":"D_Kimura_variance"},{"line":771,"kind":13,"containerName":"D_Kimura_variance","name":"$K"},{"line":772,"kind":13,"containerName":"D_Kimura_variance","name":"$var_k"},{"name":"$a","containerName":"D_Kimura_variance","kind":13,"line":774},{"line":774,"kind":13,"name":"$a_denom","containerName":"D_Kimura_variance"},{"kind":13,"line":775,"containerName":"D_Kimura_variance","name":"$b"},{"kind":13,"line":775,"name":"$b_denom","containerName":"D_Kimura_variance"},{"name":"$K","containerName":"D_Kimura_variance","line":776,"kind":13},{"name":"$a","containerName":"D_Kimura_variance","kind":13,"line":776},{"containerName":"D_Kimura_variance","name":"$b","kind":13,"line":776},{"containerName":"D_Kimura_variance","name":"$c","definition":"my","localvar":"my","kind":13,"line":778},{"line":778,"kind":13,"containerName":"D_Kimura_variance","name":"$a"},{"kind":13,"line":778,"name":"$b","containerName":"D_Kimura_variance"},{"line":779,"kind":13,"localvar":"my","containerName":"D_Kimura_variance","definition":"my","name":"$d"},{"line":779,"kind":13,"containerName":"D_Kimura_variance","name":"$a"},{"containerName":"D_Kimura_variance","name":"$b","kind":13,"line":779},{"name":"$var_k","containerName":"D_Kimura_variance","line":780,"kind":13},{"kind":13,"line":780,"name":"$a","containerName":"D_Kimura_variance"},{"line":780,"kind":13,"name":"$P","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$d","line":780,"kind":13},{"containerName":"D_Kimura_variance","name":"$Q","kind":13,"line":780},{"name":"$a","containerName":"D_Kimura_variance","kind":13,"line":780},{"name":"$P","containerName":"D_Kimura_variance","line":780,"kind":13},{"name":"$d","containerName":"D_Kimura_variance","line":780,"kind":13},{"kind":13,"line":780,"containerName":"D_Kimura_variance","name":"$Q"},{"name":"$L","containerName":"D_Kimura_variance","kind":13,"line":780},{"containerName":"D_Kimura_variance","name":"$dist","kind":13,"line":784},{"name":"$names","containerName":"D_Kimura_variance","kind":13,"line":784},{"kind":13,"line":784,"name":"$i","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$names","line":784,"kind":13},{"containerName":"D_Kimura_variance","name":"$j","kind":13,"line":784},{"name":"$i","containerName":"D_Kimura_variance","line":784,"kind":13},{"kind":13,"line":784,"name":"$j","containerName":"D_Kimura_variance"},{"line":785,"kind":13,"name":"$dist","containerName":"D_Kimura_variance"},{"name":"$names","containerName":"D_Kimura_variance","kind":13,"line":785},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":785},{"containerName":"D_Kimura_variance","name":"$names","kind":13,"line":785},{"line":785,"kind":13,"name":"$i","containerName":"D_Kimura_variance"},{"kind":13,"line":785,"name":"$i","containerName":"D_Kimura_variance"},{"kind":13,"line":785,"name":"$j","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$values","line":786,"kind":13},{"line":786,"kind":13,"name":"$j","containerName":"D_Kimura_variance"},{"name":"$i","containerName":"D_Kimura_variance","line":786,"kind":13},{"name":"$values","containerName":"D_Kimura_variance","kind":13,"line":786},{"containerName":"D_Kimura_variance","name":"$i","kind":13,"line":786},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":786},{"containerName":"D_Kimura_variance","name":"$precisionstr","kind":13,"line":786},{"kind":13,"line":786,"containerName":"D_Kimura_variance","name":"$K"},{"kind":13,"line":788,"name":"$dist","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$names","line":788,"kind":13},{"containerName":"D_Kimura_variance","name":"$j","line":788,"kind":13},{"kind":13,"line":788,"containerName":"D_Kimura_variance","name":"$names"},{"line":788,"kind":13,"name":"$j","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$j","kind":13,"line":788},{"line":788,"kind":13,"name":"$j","containerName":"D_Kimura_variance"},{"line":789,"kind":13,"name":"$values","containerName":"D_Kimura_variance"},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":789},{"containerName":"D_Kimura_variance","name":"$j","line":789,"kind":13},{"containerName":"D_Kimura_variance","name":"$precisionstr","line":789,"kind":13},{"line":791,"kind":13,"name":"$var","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$j","kind":13,"line":791},{"line":791,"kind":13,"name":"$i","containerName":"D_Kimura_variance"},{"line":791,"kind":13,"containerName":"D_Kimura_variance","name":"$var"},{"kind":13,"line":791,"containerName":"D_Kimura_variance","name":"$i"},{"containerName":"D_Kimura_variance","name":"$j","line":791,"kind":13},{"kind":13,"line":791,"name":"$precisionstr","containerName":"D_Kimura_variance"},{"line":791,"kind":13,"containerName":"D_Kimura_variance","name":"$var_k"},{"line":792,"kind":13,"containerName":"D_Kimura_variance","name":"$var"},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":792},{"line":792,"kind":13,"containerName":"D_Kimura_variance","name":"$j"},{"name":"$values","containerName":"D_Kimura_variance","line":792,"kind":13},{"line":792,"kind":13,"name":"$j","containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","name":"$j","line":792,"kind":13},{"line":795,"kind":12,"containerName":"D_Kimura_variance","name":"new"},{"name":"%dist","containerName":"D_Kimura_variance","kind":13,"line":796},{"line":797,"kind":13,"containerName":"D_Kimura_variance","name":"@names"},{"line":798,"kind":13,"name":"@values","containerName":"D_Kimura_variance"},{"name":"new","containerName":"D_Kimura_variance","line":799,"kind":12},{"line":800,"kind":13,"name":"%dist","containerName":"D_Kimura_variance"},{"kind":13,"line":801,"containerName":"D_Kimura_variance","name":"@names"},{"containerName":"D_Kimura_variance","name":"@var","kind":13,"line":802}],"line":739,"kind":12,"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"D_Kimura_variance($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::"},{"kind":12,"line":795,"name":"Bio","containerName":"Matrix::PhylipDist"},{"line":799,"kind":12,"name":"Bio","containerName":"Matrix::PhylipDist"},{"signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","label":"D_Tamura($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":821,"containerName":"D_Tamura","definition":"my","name":"$self","localvar":"my"},{"line":821,"kind":13,"containerName":"D_Tamura","name":"$aln"},{"name":"$self","containerName":"D_Tamura","line":822,"kind":13},{"containerName":"D_Tamura","name":"_check_arg","kind":12,"line":822},{"containerName":"D_Tamura","name":"$aln","kind":13,"line":822},{"line":824,"kind":13,"localvar":"my","containerName":"D_Tamura","name":"@seqs","definition":"my"},{"name":"@names","containerName":"D_Tamura","kind":13,"line":824},{"kind":13,"line":824,"containerName":"D_Tamura","name":"@values"},{"kind":13,"line":824,"name":"%dist","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$i","line":824,"kind":13},{"name":"$j","containerName":"D_Tamura","kind":13,"line":824},{"containerName":"D_Tamura","definition":"my","name":"$seqct","localvar":"my","kind":13,"line":825},{"kind":13,"line":826,"containerName":"D_Tamura","definition":"my","name":"$length","localvar":"my"},{"kind":13,"line":826,"name":"$aln","containerName":"D_Tamura"},{"line":826,"kind":12,"name":"length","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$seq","definition":"my","localvar":"my","kind":13,"line":827},{"line":827,"kind":13,"name":"$aln","containerName":"D_Tamura"},{"kind":12,"line":827,"containerName":"D_Tamura","name":"each_seq"},{"name":"@names","containerName":"D_Tamura","kind":13,"line":828},{"containerName":"D_Tamura","name":"$seq","line":828,"kind":13},{"kind":12,"line":828,"name":"display_id","containerName":"D_Tamura"},{"line":829,"kind":13,"name":"@seqs","containerName":"D_Tamura"},{"kind":13,"line":829,"containerName":"D_Tamura","name":"$seq"},{"name":"seq","containerName":"D_Tamura","line":829,"kind":12},{"containerName":"D_Tamura","name":"$seqct","line":830,"kind":13},{"localvar":"my","definition":"my","name":"$precisionstr","containerName":"D_Tamura","line":833,"kind":13},{"line":834,"kind":13,"localvar":"my","containerName":"D_Tamura","name":"@gap","definition":"my"},{"name":"@gc","containerName":"D_Tamura","line":834,"kind":13},{"containerName":"D_Tamura","name":"@trans","line":834,"kind":13},{"containerName":"D_Tamura","name":"@tranv","kind":13,"line":834},{"name":"@score","containerName":"D_Tamura","kind":13,"line":834},{"name":"$i","containerName":"D_Tamura","kind":13,"line":835},{"kind":13,"line":836,"name":"$t1","definition":"my","containerName":"D_Tamura","localvar":"my"},{"containerName":"D_Tamura","name":"@seqs","line":836,"kind":13},{"line":837,"kind":13,"containerName":"D_Tamura","name":"$j"},{"kind":13,"line":838,"definition":"my","name":"$t2","containerName":"D_Tamura","localvar":"my"},{"line":838,"kind":13,"name":"@seqs","containerName":"D_Tamura"},{"name":"$gap","containerName":"D_Tamura","line":839,"kind":13},{"name":"$i","containerName":"D_Tamura","line":839,"kind":13},{"line":839,"kind":13,"containerName":"D_Tamura","name":"$j"},{"definition":"my","name":"$k","containerName":"D_Tamura","localvar":"my","kind":13,"line":840},{"name":"$k","containerName":"D_Tamura","kind":13,"line":840},{"kind":13,"line":840,"containerName":"D_Tamura","name":"$length"},{"containerName":"D_Tamura","name":"$k","line":840,"kind":13},{"name":"$c1","definition":"my","containerName":"D_Tamura","localvar":"my","kind":13,"line":841},{"containerName":"D_Tamura","name":"$c2","line":841,"kind":13},{"containerName":"D_Tamura","name":"$seqs","kind":13,"line":841},{"line":841,"kind":13,"name":"$i","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$k","line":841,"kind":13},{"kind":13,"line":842,"containerName":"D_Tamura","name":"$seqs"},{"line":842,"kind":13,"name":"$j","containerName":"D_Tamura"},{"kind":13,"line":842,"name":"$k","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$c1","kind":13,"line":843},{"name":"$c2","containerName":"D_Tamura","line":844,"kind":13},{"kind":13,"line":845,"containerName":"D_Tamura","name":"$gap"},{"containerName":"D_Tamura","name":"$i","line":845,"kind":13},{"kind":13,"line":845,"name":"$j","containerName":"D_Tamura"},{"kind":13,"line":846,"name":"$c2","containerName":"D_Tamura"},{"name":"$gc","containerName":"D_Tamura","kind":13,"line":847},{"name":"$i","containerName":"D_Tamura","kind":13,"line":847},{"kind":13,"line":847,"containerName":"D_Tamura","name":"$j"},{"kind":13,"line":850,"name":"$gc","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$i","kind":13,"line":850},{"name":"$j","containerName":"D_Tamura","line":850,"kind":13},{"line":850,"kind":13,"containerName":"D_Tamura","name":"$gc"},{"kind":13,"line":850,"name":"$i","containerName":"D_Tamura"},{"name":"$j","containerName":"D_Tamura","line":850,"kind":13},{"kind":13,"line":851,"name":"$length","containerName":"D_Tamura"},{"line":851,"kind":13,"name":"$gap","containerName":"D_Tamura"},{"line":851,"kind":13,"containerName":"D_Tamura","name":"$i"},{"kind":13,"line":851,"name":"$j","containerName":"D_Tamura"},{"name":"$j","containerName":"D_Tamura","line":852,"kind":13},{"line":854,"kind":13,"name":"$i","containerName":"D_Tamura"},{"kind":13,"line":857,"containerName":"D_Tamura","name":"$i"},{"name":"$i","containerName":"D_Tamura","line":857,"kind":13},{"name":"$seqct","containerName":"D_Tamura","line":857,"kind":13},{"line":857,"kind":13,"name":"$i","containerName":"D_Tamura"},{"line":859,"kind":13,"name":"$dist","containerName":"D_Tamura"},{"name":"$names","containerName":"D_Tamura","line":859,"kind":13},{"containerName":"D_Tamura","name":"$i","kind":13,"line":859},{"kind":13,"line":859,"containerName":"D_Tamura","name":"$names"},{"kind":13,"line":859,"containerName":"D_Tamura","name":"$i"},{"name":"$i","containerName":"D_Tamura","line":859,"kind":13},{"name":"$i","containerName":"D_Tamura","line":859,"kind":13},{"name":"$values","containerName":"D_Tamura","line":860,"kind":13},{"kind":13,"line":860,"name":"$i","containerName":"D_Tamura"},{"kind":13,"line":860,"name":"$i","containerName":"D_Tamura"},{"kind":13,"line":860,"containerName":"D_Tamura","name":"$precisionstr"},{"kind":13,"line":862,"name":"$j","containerName":"D_Tamura"},{"kind":13,"line":862,"containerName":"D_Tamura","name":"$i"},{"containerName":"D_Tamura","name":"$j","line":862,"kind":13},{"name":"$seqct","containerName":"D_Tamura","kind":13,"line":862},{"containerName":"D_Tamura","name":"$j","kind":13,"line":862},{"localvar":"my","containerName":"D_Tamura","definition":"my","name":"$pairwise","line":864,"kind":13},{"containerName":"D_Tamura","name":"$aln","line":864,"kind":13},{"line":864,"kind":12,"containerName":"D_Tamura","name":"select_noncont"},{"kind":13,"line":864,"containerName":"D_Tamura","name":"$i"},{"containerName":"D_Tamura","name":"$j","kind":13,"line":864},{"line":865,"kind":13,"localvar":"my","name":"$L","definition":"my","containerName":"D_Tamura"},{"line":865,"kind":13,"containerName":"D_Tamura","name":"$self"},{"containerName":"D_Tamura","name":"pairwise_stats","line":865,"kind":12},{"kind":12,"line":865,"name":"number_of_comparable_bases","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$pairwise","kind":13,"line":865},{"localvar":"my","definition":"my","name":"$P","containerName":"D_Tamura","line":866,"kind":13},{"line":866,"kind":13,"containerName":"D_Tamura","name":"$self"},{"name":"transitions","containerName":"D_Tamura","line":866,"kind":12},{"kind":13,"line":866,"containerName":"D_Tamura","name":"$pairwise"},{"kind":13,"line":866,"name":"$L","containerName":"D_Tamura"},{"line":867,"kind":13,"localvar":"my","name":"$Q","definition":"my","containerName":"D_Tamura"},{"kind":13,"line":867,"name":"$self","containerName":"D_Tamura"},{"kind":12,"line":867,"name":"transversions","containerName":"D_Tamura"},{"line":867,"kind":13,"containerName":"D_Tamura","name":"$pairwise"},{"containerName":"D_Tamura","name":"$L","kind":13,"line":867},{"line":868,"kind":13,"localvar":"my","containerName":"D_Tamura","name":"$C","definition":"my"},{"kind":13,"line":868,"name":"$gc","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$i","line":868,"kind":13},{"kind":13,"line":868,"name":"$j","containerName":"D_Tamura"},{"kind":13,"line":868,"containerName":"D_Tamura","name":"$gc"},{"name":"$j","containerName":"D_Tamura","line":868,"kind":13},{"name":"$i","containerName":"D_Tamura","kind":13,"line":868},{"kind":13,"line":869,"name":"$gc","containerName":"D_Tamura"},{"line":869,"kind":13,"name":"$i","containerName":"D_Tamura"},{"kind":13,"line":869,"name":"$j","containerName":"D_Tamura"},{"line":869,"kind":13,"containerName":"D_Tamura","name":"$gc"},{"kind":13,"line":869,"containerName":"D_Tamura","name":"$j"},{"name":"$i","containerName":"D_Tamura","line":869,"kind":13},{"name":"$P","containerName":"D_Tamura","kind":13,"line":870},{"name":"$P","containerName":"D_Tamura","line":871,"kind":13},{"kind":13,"line":871,"name":"$P","containerName":"D_Tamura"},{"name":"$C","containerName":"D_Tamura","kind":13,"line":871},{"line":873,"kind":13,"localvar":"my","containerName":"D_Tamura","definition":"my","name":"$d"},{"kind":13,"line":873,"name":"$C","containerName":"D_Tamura"},{"name":"$P","containerName":"D_Tamura","line":873,"kind":13},{"name":"$Q","containerName":"D_Tamura","line":873,"kind":13},{"name":"$C","containerName":"D_Tamura","kind":13,"line":873},{"line":873,"kind":13,"containerName":"D_Tamura","name":"$Q"},{"name":"$dist","containerName":"D_Tamura","line":875,"kind":13},{"containerName":"D_Tamura","name":"$names","kind":13,"line":875},{"kind":13,"line":875,"name":"$i","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$names","line":875,"kind":13},{"name":"$j","containerName":"D_Tamura","kind":13,"line":875},{"containerName":"D_Tamura","name":"$i","line":875,"kind":13},{"name":"$j","containerName":"D_Tamura","kind":13,"line":875},{"name":"$dist","containerName":"D_Tamura","kind":13,"line":876},{"containerName":"D_Tamura","name":"$names","kind":13,"line":876},{"name":"$j","containerName":"D_Tamura","kind":13,"line":876},{"kind":13,"line":876,"containerName":"D_Tamura","name":"$names"},{"kind":13,"line":876,"containerName":"D_Tamura","name":"$i"},{"kind":13,"line":876,"name":"$i","containerName":"D_Tamura"},{"name":"$j","containerName":"D_Tamura","line":876,"kind":13},{"line":877,"kind":13,"name":"$values","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"$j","kind":13,"line":877},{"containerName":"D_Tamura","name":"$i","line":877,"kind":13},{"containerName":"D_Tamura","name":"$values","kind":13,"line":877},{"containerName":"D_Tamura","name":"$i","line":877,"kind":13},{"kind":13,"line":877,"containerName":"D_Tamura","name":"$j"},{"line":877,"kind":13,"containerName":"D_Tamura","name":"$precisionstr"},{"line":877,"kind":13,"containerName":"D_Tamura","name":"$d"},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$dist"},{"name":"$names","containerName":"D_Tamura","kind":13,"line":879},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$j"},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$names"},{"containerName":"D_Tamura","name":"$j","line":879,"kind":13},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$j"},{"kind":13,"line":879,"name":"$j","containerName":"D_Tamura"},{"line":880,"kind":13,"containerName":"D_Tamura","name":"$values"},{"name":"$j","containerName":"D_Tamura","line":880,"kind":13},{"containerName":"D_Tamura","name":"$j","line":880,"kind":13},{"line":880,"kind":13,"name":"$precisionstr","containerName":"D_Tamura"},{"containerName":"D_Tamura","name":"new","kind":12,"line":883},{"kind":13,"line":884,"containerName":"D_Tamura","name":"%dist"},{"name":"@names","containerName":"D_Tamura","kind":13,"line":885},{"kind":13,"line":886,"containerName":"D_Tamura","name":"@values"}],"line":820,"kind":12,"range":{"start":{"character":0,"line":820},"end":{"character":9999,"line":888}},"name":"D_Tamura"},{"kind":12,"line":883,"containerName":"Matrix::PhylipDist","name":"Bio"},{"detail":"($self,$aln,$gappenalty)","signature":{"label":"D_F84($self,$aln,$gappenalty)","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty"},"containerName":"main::","definition":"sub","line":902,"children":[{"localvar":"my","containerName":"D_F84","definition":"my","name":"$self","line":903,"kind":13},{"line":903,"kind":13,"name":"$aln","containerName":"D_F84"},{"line":903,"kind":13,"containerName":"D_F84","name":"$gappenalty"},{"name":"$self","containerName":"D_F84","line":904,"kind":13},{"kind":12,"line":904,"containerName":"D_F84","name":"_check_arg"},{"containerName":"D_F84","name":"$aln","line":904,"kind":13},{"kind":13,"line":905,"containerName":"D_F84","name":"$self"},{"name":"throw_not_implemented","containerName":"D_F84","line":905,"kind":12},{"localvar":"my","name":"@seqs","definition":"my","containerName":"D_F84","line":907,"kind":13},{"name":"@names","containerName":"D_F84","kind":13,"line":907},{"name":"@values","containerName":"D_F84","kind":13,"line":907},{"line":907,"kind":13,"name":"%dist","containerName":"D_F84"},{"line":908,"kind":13,"localvar":"my","name":"$seqct","definition":"my","containerName":"D_F84"},{"localvar":"my","definition":"my","name":"$seq","containerName":"D_F84","line":909,"kind":13},{"line":909,"kind":13,"name":"$aln","containerName":"D_F84"},{"containerName":"D_F84","name":"each_seq","kind":12,"line":909},{"line":911,"kind":13,"localvar":"my","containerName":"D_F84","name":"$id","definition":"my"},{"kind":13,"line":911,"name":"$seq","containerName":"D_F84"},{"name":"display_id","containerName":"D_F84","kind":12,"line":911},{"containerName":"D_F84","name":"$id","kind":13,"line":912},{"name":"$id","containerName":"D_F84","kind":13,"line":913},{"kind":13,"line":914,"containerName":"D_F84","name":"$id"},{"name":"$seqct","containerName":"D_F84","kind":13,"line":914},{"line":916,"kind":13,"containerName":"D_F84","name":"@names"},{"line":916,"kind":13,"name":"$id","containerName":"D_F84"},{"kind":13,"line":917,"containerName":"D_F84","name":"@seqs"},{"containerName":"D_F84","name":"$seq","kind":13,"line":917},{"containerName":"D_F84","name":"seq","line":917,"kind":12},{"name":"$seqct","containerName":"D_F84","line":918,"kind":13},{"name":"$precisionstr","definition":"my","containerName":"D_F84","localvar":"my","kind":13,"line":921},{"containerName":"D_F84","definition":"my","name":"$i","localvar":"my","kind":13,"line":923},{"line":923,"kind":13,"containerName":"D_F84","name":"$i"},{"name":"$seqct","containerName":"D_F84","kind":13,"line":923},{"containerName":"D_F84","name":"$i","kind":13,"line":923},{"kind":13,"line":925,"containerName":"D_F84","name":"$dist"},{"containerName":"D_F84","name":"$names","line":925,"kind":13},{"line":925,"kind":13,"containerName":"D_F84","name":"$i"},{"kind":13,"line":925,"name":"$names","containerName":"D_F84"},{"containerName":"D_F84","name":"$i","line":925,"kind":13},{"line":925,"kind":13,"containerName":"D_F84","name":"$i"},{"kind":13,"line":925,"name":"$i","containerName":"D_F84"},{"kind":13,"line":926,"name":"$values","containerName":"D_F84"},{"line":926,"kind":13,"name":"$i","containerName":"D_F84"},{"name":"$i","containerName":"D_F84","line":926,"kind":13},{"containerName":"D_F84","name":"$precisionstr","line":926,"kind":13},{"definition":"my","name":"$j","containerName":"D_F84","localvar":"my","kind":13,"line":928},{"containerName":"D_F84","name":"$i","line":928,"kind":13},{"line":928,"kind":13,"name":"$j","containerName":"D_F84"},{"line":928,"kind":13,"name":"$seqct","containerName":"D_F84"},{"kind":13,"line":928,"name":"$j","containerName":"D_F84"}],"kind":12,"range":{"start":{"character":0,"line":902},"end":{"line":931,"character":9999}},"name":"D_F84"},{"range":{"start":{"line":954,"character":0},"end":{"character":9999,"line":1045}},"name":"D_TajimaNei","detail":"($self,$aln)","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"D_TajimaNei($self,$aln)"},"containerName":"main::","definition":"sub","line":954,"children":[{"line":955,"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$self","definition":"my"},{"containerName":"D_TajimaNei","name":"$aln","kind":13,"line":955},{"name":"$self","containerName":"D_TajimaNei","kind":13,"line":956},{"kind":12,"line":956,"name":"_check_arg","containerName":"D_TajimaNei"},{"name":"$aln","containerName":"D_TajimaNei","kind":13,"line":956},{"kind":13,"line":958,"name":"@seqs","definition":"my","containerName":"D_TajimaNei","localvar":"my"},{"containerName":"D_TajimaNei","name":"@names","line":958,"kind":13},{"containerName":"D_TajimaNei","name":"@values","kind":13,"line":958},{"containerName":"D_TajimaNei","name":"%dist","line":958,"kind":13},{"line":959,"kind":13,"localvar":"my","containerName":"D_TajimaNei","definition":"my","name":"$seqct"},{"containerName":"D_TajimaNei","definition":"my","name":"$seq","localvar":"my","kind":13,"line":960},{"line":960,"kind":13,"name":"$aln","containerName":"D_TajimaNei"},{"line":960,"kind":12,"name":"each_seq","containerName":"D_TajimaNei"},{"line":962,"kind":13,"name":"@names","containerName":"D_TajimaNei"},{"kind":13,"line":962,"name":"$seq","containerName":"D_TajimaNei"},{"name":"display_id","containerName":"D_TajimaNei","line":962,"kind":12},{"line":963,"kind":13,"name":"@seqs","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$seq","line":963,"kind":13},{"name":"seq","containerName":"D_TajimaNei","line":963,"kind":12},{"kind":13,"line":964,"containerName":"D_TajimaNei","name":"$seqct"},{"kind":13,"line":966,"definition":"my","name":"$precisionstr","containerName":"D_TajimaNei","localvar":"my"},{"line":967,"kind":13,"localvar":"my","containerName":"D_TajimaNei","definition":"my","name":"$i"},{"line":967,"kind":13,"name":"$j","containerName":"D_TajimaNei"},{"line":967,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"line":969,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"name":"$i","containerName":"D_TajimaNei","line":969,"kind":13},{"containerName":"D_TajimaNei","name":"$seqct","kind":13,"line":969},{"kind":13,"line":969,"name":"$i","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$dist","line":970,"kind":13},{"containerName":"D_TajimaNei","name":"$names","line":970,"kind":13},{"kind":13,"line":970,"name":"$i","containerName":"D_TajimaNei"},{"line":970,"kind":13,"containerName":"D_TajimaNei","name":"$names"},{"containerName":"D_TajimaNei","name":"$i","kind":13,"line":970},{"containerName":"D_TajimaNei","name":"$i","line":970,"kind":13},{"name":"$i","containerName":"D_TajimaNei","line":970,"kind":13},{"line":971,"kind":13,"name":"$values","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$i","kind":13,"line":971},{"containerName":"D_TajimaNei","name":"$i","kind":13,"line":971},{"containerName":"D_TajimaNei","name":"$precisionstr","kind":13,"line":971},{"containerName":"D_TajimaNei","name":"$j","kind":13,"line":973},{"containerName":"D_TajimaNei","name":"$i","line":973,"kind":13},{"line":973,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":973,"kind":13,"containerName":"D_TajimaNei","name":"$seqct"},{"name":"$j","containerName":"D_TajimaNei","kind":13,"line":973},{"localvar":"my","containerName":"D_TajimaNei","definition":"my","name":"$matrix","line":974,"kind":13},{"line":974,"kind":13,"containerName":"D_TajimaNei","name":"$pfreq"},{"line":974,"kind":13,"name":"$gaps","containerName":"D_TajimaNei"},{"kind":13,"line":974,"name":"$self","containerName":"D_TajimaNei"},{"line":974,"kind":12,"containerName":"D_TajimaNei","name":"_build_nt_matrix"},{"containerName":"D_TajimaNei","name":"$seqs","line":974,"kind":13},{"name":"$i","containerName":"D_TajimaNei","kind":13,"line":974},{"line":975,"kind":13,"containerName":"D_TajimaNei","name":"$seqs"},{"containerName":"D_TajimaNei","name":"$j","kind":13,"line":975},{"localvar":"my","containerName":"D_TajimaNei","name":"$pairwise","definition":"my","line":976,"kind":13},{"kind":13,"line":976,"containerName":"D_TajimaNei","name":"$aln"},{"line":976,"kind":12,"name":"select_noncont","containerName":"D_TajimaNei"},{"kind":13,"line":976,"containerName":"D_TajimaNei","name":"$i"},{"containerName":"D_TajimaNei","name":"$j","kind":13,"line":976},{"line":977,"kind":13,"localvar":"my","name":"$slen","definition":"my","containerName":"D_TajimaNei"},{"kind":13,"line":977,"name":"$self","containerName":"D_TajimaNei"},{"name":"pairwise_stats","containerName":"D_TajimaNei","line":977,"kind":12},{"containerName":"D_TajimaNei","name":"number_of_comparable_bases","kind":12,"line":977},{"line":977,"kind":13,"containerName":"D_TajimaNei","name":"$pairwise"},{"kind":13,"line":978,"containerName":"D_TajimaNei","name":"$fij2","definition":"my","localvar":"my"},{"containerName":"D_TajimaNei","name":"$bs","kind":13,"line":979},{"kind":13,"line":979,"name":"$bs","containerName":"D_TajimaNei"},{"line":979,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"line":980,"kind":13,"localvar":"my","containerName":"D_TajimaNei","definition":"my","name":"$fi"},{"name":"$fi","containerName":"D_TajimaNei","kind":13,"line":981},{"containerName":"D_TajimaNei","name":"$matrix","line":981,"kind":13},{"containerName":"D_TajimaNei","name":"$bs","line":981,"kind":13},{"containerName":"D_TajimaNei","name":"$fj","definition":"my","localvar":"my","kind":13,"line":982},{"containerName":"D_TajimaNei","name":"$fj","kind":13,"line":984},{"kind":13,"line":984,"containerName":"D_TajimaNei","name":"$matrix"},{"kind":13,"line":984,"containerName":"D_TajimaNei","name":"$bs"},{"line":985,"kind":13,"localvar":"my","name":"$fij","definition":"my","containerName":"D_TajimaNei"},{"kind":13,"line":985,"containerName":"D_TajimaNei","name":"$fi"},{"containerName":"D_TajimaNei","name":"$fj","kind":13,"line":985},{"kind":13,"line":985,"containerName":"D_TajimaNei","name":"$fi"},{"kind":13,"line":985,"containerName":"D_TajimaNei","name":"$fj"},{"kind":13,"line":985,"containerName":"D_TajimaNei","name":"$slen"},{"kind":13,"line":986,"name":"$fij2","containerName":"D_TajimaNei"},{"name":"$fij","containerName":"D_TajimaNei","kind":13,"line":986},{"line":989,"kind":13,"localvar":"my","name":"$pair","definition":"my","containerName":"D_TajimaNei"},{"kind":13,"line":989,"name":"$h","containerName":"D_TajimaNei"},{"name":"$bs","containerName":"D_TajimaNei","kind":13,"line":990},{"line":990,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"line":990,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"line":991,"kind":13,"localvar":"my","definition":"my","name":"$bs1","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$bs","line":991,"kind":13},{"name":"$bs1","containerName":"D_TajimaNei","line":991,"kind":13},{"containerName":"D_TajimaNei","name":"$bs1","kind":13,"line":991},{"kind":13,"line":992,"containerName":"D_TajimaNei","definition":"my","name":"$fij","localvar":"my"},{"name":"$pfreq","containerName":"D_TajimaNei","line":992,"kind":13},{"name":"$pair","containerName":"D_TajimaNei","line":992,"kind":13},{"kind":13,"line":992,"containerName":"D_TajimaNei","name":"$slen"},{"kind":13,"line":993,"name":"$fij","containerName":"D_TajimaNei"},{"line":995,"kind":13,"localvar":"my","name":"$ci1","definition":"my","containerName":"D_TajimaNei"},{"kind":13,"line":995,"containerName":"D_TajimaNei","name":"$ci2"},{"kind":13,"line":995,"name":"$cj1","containerName":"D_TajimaNei"},{"name":"$cj2","containerName":"D_TajimaNei","kind":13,"line":995},{"kind":13,"line":997,"containerName":"D_TajimaNei","name":"$ci1"},{"containerName":"D_TajimaNei","name":"$matrix","line":997,"kind":13},{"containerName":"D_TajimaNei","name":"$bs","kind":13,"line":997},{"containerName":"D_TajimaNei","name":"$cj1","line":998,"kind":13},{"kind":13,"line":998,"containerName":"D_TajimaNei","name":"$matrix"},{"name":"$bs","containerName":"D_TajimaNei","line":998,"kind":13},{"kind":13,"line":999,"containerName":"D_TajimaNei","name":"$ci2"},{"line":999,"kind":13,"containerName":"D_TajimaNei","name":"$matrix"},{"containerName":"D_TajimaNei","name":"$bs1","kind":13,"line":999},{"containerName":"D_TajimaNei","name":"$cj2","kind":13,"line":1000},{"kind":13,"line":1000,"containerName":"D_TajimaNei","name":"$matrix"},{"kind":13,"line":1000,"containerName":"D_TajimaNei","name":"$bs1"},{"name":"$fij","containerName":"D_TajimaNei","kind":13,"line":1002},{"kind":13,"line":1003,"containerName":"D_TajimaNei","name":"$h"},{"line":1003,"kind":13,"containerName":"D_TajimaNei","name":"$fij"},{"kind":13,"line":1004,"containerName":"D_TajimaNei","name":"$ci1"},{"line":1004,"kind":13,"name":"$cj1","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$slen","line":1004,"kind":13},{"line":1005,"kind":13,"containerName":"D_TajimaNei","name":"$ci2"},{"containerName":"D_TajimaNei","name":"$cj2","line":1005,"kind":13},{"containerName":"D_TajimaNei","name":"$slen","kind":13,"line":1005},{"kind":13,"line":1008,"name":"$self","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"debug","kind":12,"line":1008},{"containerName":"D_TajimaNei","name":"$m","definition":"my","localvar":"my","kind":13,"line":1014},{"line":1014,"kind":13,"containerName":"D_TajimaNei","name":"$matrix"},{"containerName":"D_TajimaNei","name":"$matrix","line":1014,"kind":13},{"containerName":"D_TajimaNei","name":"$matrix","kind":13,"line":1015},{"name":"$matrix","containerName":"D_TajimaNei","kind":13,"line":1015},{"localvar":"my","containerName":"D_TajimaNei","definition":"my","name":"$D","line":1016,"kind":13},{"containerName":"D_TajimaNei","name":"$m","line":1016,"kind":13},{"kind":13,"line":1016,"containerName":"D_TajimaNei","name":"$slen"},{"name":"$d","definition":"my","containerName":"D_TajimaNei","localvar":"my","kind":13,"line":1017},{"kind":13,"line":1018,"name":"$h","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$d","kind":13,"line":1019},{"containerName":"D_TajimaNei","definition":"my","name":"$b","localvar":"my","kind":13,"line":1021},{"line":1021,"kind":13,"name":"$fij2","containerName":"D_TajimaNei"},{"line":1021,"kind":13,"name":"$D","containerName":"D_TajimaNei"},{"line":1021,"kind":13,"containerName":"D_TajimaNei","name":"$h"},{"kind":13,"line":1022,"name":"$c","definition":"my","containerName":"D_TajimaNei","localvar":"my"},{"containerName":"D_TajimaNei","name":"$D","line":1022,"kind":13},{"containerName":"D_TajimaNei","name":"$b","line":1022,"kind":13},{"containerName":"D_TajimaNei","name":"$c","line":1024,"kind":13},{"containerName":"D_TajimaNei","name":"$d","line":1025,"kind":13},{"kind":13,"line":1027,"name":"$d","containerName":"D_TajimaNei"},{"name":"$b","containerName":"D_TajimaNei","kind":13,"line":1027},{"containerName":"D_TajimaNei","name":"$c","line":1027,"kind":13},{"kind":13,"line":1031,"name":"$dist","containerName":"D_TajimaNei"},{"line":1031,"kind":13,"name":"$names","containerName":"D_TajimaNei"},{"line":1031,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"line":1031,"kind":13,"containerName":"D_TajimaNei","name":"$names"},{"line":1031,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"kind":13,"line":1031,"name":"$i","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$j","kind":13,"line":1031},{"kind":13,"line":1032,"containerName":"D_TajimaNei","name":"$dist"},{"name":"$names","containerName":"D_TajimaNei","kind":13,"line":1032},{"name":"$j","containerName":"D_TajimaNei","kind":13,"line":1032},{"name":"$names","containerName":"D_TajimaNei","kind":13,"line":1032},{"name":"$i","containerName":"D_TajimaNei","line":1032,"kind":13},{"name":"$i","containerName":"D_TajimaNei","line":1032,"kind":13},{"kind":13,"line":1032,"name":"$j","containerName":"D_TajimaNei"},{"line":1033,"kind":13,"name":"$values","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$j","kind":13,"line":1033},{"kind":13,"line":1033,"name":"$i","containerName":"D_TajimaNei"},{"line":1033,"kind":13,"containerName":"D_TajimaNei","name":"$values"},{"kind":13,"line":1033,"name":"$i","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$j","line":1033,"kind":13},{"kind":13,"line":1033,"containerName":"D_TajimaNei","name":"$precisionstr"},{"kind":13,"line":1033,"containerName":"D_TajimaNei","name":"$d"},{"containerName":"D_TajimaNei","name":"$dist","kind":13,"line":1036},{"kind":13,"line":1036,"containerName":"D_TajimaNei","name":"$names"},{"kind":13,"line":1036,"name":"$j","containerName":"D_TajimaNei"},{"line":1036,"kind":13,"name":"$names","containerName":"D_TajimaNei"},{"containerName":"D_TajimaNei","name":"$j","line":1036,"kind":13},{"name":"$j","containerName":"D_TajimaNei","line":1036,"kind":13},{"kind":13,"line":1036,"name":"$j","containerName":"D_TajimaNei"},{"kind":13,"line":1037,"containerName":"D_TajimaNei","name":"$values"},{"line":1037,"kind":13,"name":"$j","containerName":"D_TajimaNei"},{"kind":13,"line":1037,"name":"$j","containerName":"D_TajimaNei"},{"name":"$precisionstr","containerName":"D_TajimaNei","line":1037,"kind":13},{"name":"new","containerName":"D_TajimaNei","kind":12,"line":1040},{"kind":13,"line":1041,"name":"%dist","containerName":"D_TajimaNei"},{"line":1042,"kind":13,"containerName":"D_TajimaNei","name":"@names"},{"name":"@values","containerName":"D_TajimaNei","line":1043,"kind":13}],"kind":12},{"kind":12,"line":1040,"name":"Bio","containerName":"Matrix::PhylipDist"},{"kind":12,"children":[{"containerName":"D_JinNei","name":"$self","definition":"my","localvar":"my","kind":13,"line":1062},{"line":1062,"kind":13,"name":"@args","containerName":"D_JinNei"},{"line":1063,"kind":13,"name":"$self","containerName":"D_JinNei"},{"line":1063,"kind":12,"name":"warn","containerName":"D_JinNei"}],"line":1061,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","label":"D_JinNei($self,@args)"},"detail":"($self,@args)","name":"D_JinNei","range":{"start":{"character":0,"line":1061},"end":{"character":9999,"line":1065}}},{"range":{"start":{"character":0,"line":1079},"end":{"line":1082,"character":9999}},"name":"transversions","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"transversions($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"transversions","definition":"my","name":"$self","line":1080,"kind":13},{"containerName":"transversions","name":"$aln","line":1080,"kind":13},{"name":"$self","containerName":"transversions","line":1081,"kind":13},{"containerName":"transversions","name":"_trans_count_helper","line":1081,"kind":12},{"containerName":"transversions","name":"$aln","line":1081,"kind":13},{"containerName":"transversions","name":"$DNAChanges","line":1081,"kind":13}],"line":1079,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$aln)","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"transitions($self,$aln)"},"kind":12,"line":1095,"children":[{"localvar":"my","containerName":"transitions","name":"$self","definition":"my","line":1096,"kind":13},{"containerName":"transitions","name":"$aln","line":1096,"kind":13},{"containerName":"transitions","name":"$self","kind":13,"line":1097},{"containerName":"transitions","name":"_trans_count_helper","kind":12,"line":1097},{"line":1097,"kind":13,"name":"$aln","containerName":"transitions"},{"containerName":"transitions","name":"$DNAChanges","kind":13,"line":1097}],"name":"transitions","range":{"start":{"character":0,"line":1095},"end":{"line":1098,"character":9999}}},{"kind":12,"children":[{"line":1102,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_trans_count_helper"},{"line":1102,"kind":13,"name":"$aln","containerName":"_trans_count_helper"},{"name":"$type","containerName":"_trans_count_helper","kind":13,"line":1102},{"containerName":"_trans_count_helper","name":"$self","line":1103,"kind":13},{"line":1103,"kind":12,"containerName":"_trans_count_helper","name":"_check_arg"},{"containerName":"_trans_count_helper","name":"$aln","line":1103,"kind":13},{"containerName":"_trans_count_helper","name":"$aln","kind":13,"line":1104},{"name":"is_flush","containerName":"_trans_count_helper","kind":12,"line":1104},{"name":"$self","containerName":"_trans_count_helper","line":1104,"kind":13},{"name":"throw","containerName":"_trans_count_helper","kind":12,"line":1104},{"line":1105,"kind":13,"localvar":"my","containerName":"_trans_count_helper","name":"@tcount","definition":"my"},{"line":1106,"kind":13,"localvar":"my","name":"$first","definition":"my","containerName":"_trans_count_helper"},{"containerName":"_trans_count_helper","name":"$second","line":1106,"kind":13},{"line":1106,"kind":13,"name":"$aln","containerName":"_trans_count_helper"},{"containerName":"_trans_count_helper","name":"get_seq_by_pos","line":1106,"kind":12},{"line":1106,"kind":12,"containerName":"_trans_count_helper","name":"seq"},{"containerName":"_trans_count_helper","name":"$aln","kind":13,"line":1107},{"kind":12,"line":1107,"containerName":"_trans_count_helper","name":"get_seq_by_pos"},{"kind":12,"line":1107,"name":"seq","containerName":"_trans_count_helper"},{"localvar":"my","containerName":"_trans_count_helper","name":"$alen","definition":"my","line":1108,"kind":13},{"name":"$aln","containerName":"_trans_count_helper","line":1108,"kind":13},{"containerName":"_trans_count_helper","name":"length","kind":12,"line":1108},{"definition":"my","name":"$i","containerName":"_trans_count_helper","localvar":"my","kind":13,"line":1109},{"containerName":"_trans_count_helper","name":"$i","line":1109,"kind":13},{"line":1109,"kind":13,"containerName":"_trans_count_helper","name":"$alen"},{"name":"$i","containerName":"_trans_count_helper","line":1109,"kind":13},{"definition":"my","name":"$c1","containerName":"_trans_count_helper","localvar":"my","kind":13,"line":1110},{"name":"$c2","containerName":"_trans_count_helper","line":1110,"kind":13},{"kind":13,"line":1110,"containerName":"_trans_count_helper","name":"$first"},{"name":"$i","containerName":"_trans_count_helper","line":1110,"kind":13},{"containerName":"_trans_count_helper","name":"$second","line":1111,"kind":13},{"line":1111,"kind":13,"containerName":"_trans_count_helper","name":"$i"},{"containerName":"_trans_count_helper","name":"$c1","line":1112,"kind":13},{"kind":13,"line":1112,"name":"$c2","containerName":"_trans_count_helper"},{"containerName":"_trans_count_helper","name":"$nt","definition":"my","localvar":"my","kind":13,"line":1113},{"name":"$type","containerName":"_trans_count_helper","line":1113,"kind":13},{"line":1113,"kind":13,"containerName":"_trans_count_helper","name":"$c1"},{"kind":13,"line":1114,"name":"$nt","containerName":"_trans_count_helper"},{"kind":13,"line":1114,"name":"$c2","containerName":"_trans_count_helper"},{"containerName":"_trans_count_helper","name":"$tcount","kind":13,"line":1115},{"name":"$i","containerName":"_trans_count_helper","kind":13,"line":1115}],"line":1101,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$type"}],"documentation":"","label":"_trans_count_helper($self,$aln,$type)"},"detail":"($self,$aln,$type)","name":"_trans_count_helper","range":{"end":{"character":9999,"line":1119},"start":{"character":0,"line":1101}}},{"localvar":"my","containerName":null,"name":"%sum","definition":"my","line":1120,"kind":13},{"containerName":null,"name":"$sum","line":1121,"kind":13},{"line":1121,"kind":13,"name":"@tcount","containerName":null},{"containerName":null,"name":"$sum","line":1122,"kind":13},{"kind":12,"line":1128,"children":[{"kind":13,"line":1129,"containerName":"_build_nt_matrix","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1129,"containerName":"_build_nt_matrix","name":"$seqa"},{"kind":13,"line":1129,"name":"$seqb","containerName":"_build_nt_matrix"},{"localvar":"my","definition":"my","name":"$basect_matrix","containerName":"_build_nt_matrix","line":1132,"kind":13},{"line":1136,"kind":13,"localvar":"my","containerName":"_build_nt_matrix","definition":"my","name":"$gaps"},{"localvar":"my","containerName":"_build_nt_matrix","definition":"my","name":"$pfreq","line":1137,"kind":13},{"localvar":"my","containerName":"_build_nt_matrix","definition":"my","name":"$len_a","line":1138,"kind":13},{"line":1138,"kind":13,"containerName":"_build_nt_matrix","name":"$seqa"},{"line":1139,"kind":13,"localvar":"my","containerName":"_build_nt_matrix","definition":"my","name":"$i"},{"line":1139,"kind":13,"name":"$i","containerName":"_build_nt_matrix"},{"containerName":"_build_nt_matrix","name":"$len_a","kind":13,"line":1139},{"kind":13,"line":1139,"containerName":"_build_nt_matrix","name":"$i"},{"localvar":"my","name":"$ti","definition":"my","containerName":"_build_nt_matrix","line":1140,"kind":13},{"name":"$tj","containerName":"_build_nt_matrix","kind":13,"line":1140},{"kind":13,"line":1140,"name":"$seqa","containerName":"_build_nt_matrix"},{"line":1140,"kind":13,"name":"$i","containerName":"_build_nt_matrix"},{"name":"$seqb","containerName":"_build_nt_matrix","kind":13,"line":1140},{"kind":13,"line":1140,"containerName":"_build_nt_matrix","name":"$i"},{"containerName":"_build_nt_matrix","name":"$ti","line":1141,"kind":13},{"containerName":"_build_nt_matrix","name":"$tj","kind":13,"line":1142},{"kind":13,"line":1144,"containerName":"_build_nt_matrix","name":"$ti"},{"kind":13,"line":1144,"name":"$gaps","containerName":"_build_nt_matrix"},{"containerName":"_build_nt_matrix","name":"$tj","line":1145,"kind":13},{"name":"$gaps","containerName":"_build_nt_matrix","line":1145,"kind":13},{"localvar":"my","containerName":"_build_nt_matrix","definition":"my","name":"$ti_index","line":1147,"kind":13},{"line":1147,"kind":13,"name":"$NucleotideIndexes","containerName":"_build_nt_matrix"},{"containerName":"_build_nt_matrix","name":"$ti","line":1147,"kind":13},{"containerName":"_build_nt_matrix","name":"$tj_index","definition":"my","localvar":"my","kind":13,"line":1148},{"containerName":"_build_nt_matrix","name":"$NucleotideIndexes","kind":13,"line":1148},{"line":1148,"kind":13,"name":"$tj","containerName":"_build_nt_matrix"},{"name":"$ti_index","containerName":"_build_nt_matrix","line":1150,"kind":13},{"name":"$self","containerName":"_build_nt_matrix","kind":13,"line":1151},{"name":"warn","containerName":"_build_nt_matrix","line":1151,"kind":12},{"containerName":"_build_nt_matrix","name":"$basect_matrix","line":1155,"kind":13},{"line":1155,"kind":13,"name":"$ti_index","containerName":"_build_nt_matrix"},{"line":1155,"kind":13,"name":"$tj_index","containerName":"_build_nt_matrix"},{"name":"$ti","containerName":"_build_nt_matrix","line":1157,"kind":13},{"name":"$tj","containerName":"_build_nt_matrix","line":1157,"kind":13},{"containerName":"_build_nt_matrix","name":"$pfreq","kind":13,"line":1158},{"line":1158,"kind":13,"containerName":"_build_nt_matrix","name":"$NucleotideIndexes"},{"containerName":"_build_nt_matrix","name":"$ti","kind":13,"line":1158},{"name":"$tj","containerName":"_build_nt_matrix","line":1158,"kind":13},{"containerName":"_build_nt_matrix","name":"$basect_matrix","kind":13,"line":1161},{"line":1161,"kind":13,"name":"$pfreq","containerName":"_build_nt_matrix"},{"kind":13,"line":1161,"containerName":"_build_nt_matrix","name":"$gaps"}],"containerName":"main::","definition":"sub","detail":"($self,$seqa,$seqb)","signature":{"parameters":[{"label":"$self"},{"label":"$seqa"},{"label":"$seqb"}],"documentation":" this will generate a matrix which records across the row, the number\n of DNA subst","label":"_build_nt_matrix($self,$seqa,$seqb)"},"name":"_build_nt_matrix","range":{"start":{"character":0,"line":1128},"end":{"character":9999,"line":1162}}},{"signature":{"parameters":[{"label":"$base1"},{"label":"$base2"}],"documentation":"","label":"_check_ambiguity_nucleotide($base1,$base2)"},"detail":"($base1,$base2)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_check_ambiguity_nucleotide","name":"$base1","definition":"my","line":1165,"kind":13},{"name":"$base2","containerName":"_check_ambiguity_nucleotide","line":1165,"kind":13},{"kind":13,"line":1166,"containerName":"_check_ambiguity_nucleotide","definition":"my","name":"%iub","localvar":"my"},{"name":"iupac_iub","containerName":"_check_ambiguity_nucleotide","line":1166,"kind":12},{"name":"@amb1","definition":"my","containerName":"_check_ambiguity_nucleotide","localvar":"my","kind":13,"line":1167},{"line":1167,"kind":13,"name":"$iub","containerName":"_check_ambiguity_nucleotide"},{"line":1167,"kind":13,"containerName":"_check_ambiguity_nucleotide","name":"$base1"}],"line":1164,"kind":12,"range":{"end":{"character":9999,"line":1167},"start":{"character":0,"line":1164}},"name":"_check_ambiguity_nucleotide"},{"line":1166,"kind":12,"containerName":"Tools::IUPAC","name":"Bio"},{"containerName":null,"definition":"my","name":"@amb2","localvar":"my","kind":13,"line":1168},{"containerName":null,"name":"%iub","kind":13,"line":1168},{"line":1168,"kind":13,"containerName":null,"name":"$base2"},{"localvar":"my","definition":"my","name":"$pmatch","containerName":null,"line":1169,"kind":13},{"kind":13,"line":1170,"name":"$amb","definition":"my","containerName":null,"localvar":"my"},{"name":"@amb1","containerName":null,"kind":13,"line":1170},{"containerName":null,"name":"$amb","kind":13,"line":1171},{"containerName":null,"name":"@amb2","kind":13,"line":1171},{"line":1172,"kind":13,"containerName":null,"name":"$pmatch"},{"line":1176,"kind":13,"name":"%pmatch","containerName":null},{"containerName":null,"name":"@amb1","line":1177,"kind":13},{"kind":13,"line":1177,"containerName":null,"name":"@amb2"},{"name":"_check_arg","range":{"end":{"line":1194,"character":9999},"start":{"character":0,"line":1184}},"kind":12,"line":1184,"children":[{"kind":13,"line":1185,"containerName":"_check_arg","definition":"my","name":"$self","localvar":"my"},{"name":"$aln","containerName":"_check_arg","kind":13,"line":1185},{"kind":13,"line":1186,"name":"$aln","containerName":"_check_arg"},{"kind":13,"line":1186,"name":"$aln","containerName":"_check_arg"},{"line":1186,"kind":12,"containerName":"_check_arg","name":"isa"},{"containerName":"_check_arg","name":"$self","line":1187,"kind":13},{"name":"warn","containerName":"_check_arg","line":1187,"kind":12},{"name":"$aln","containerName":"_check_arg","kind":13,"line":1189},{"name":"get_seq_by_pos","containerName":"_check_arg","line":1189,"kind":12},{"name":"alphabet","containerName":"_check_arg","kind":12,"line":1189},{"name":"$self","containerName":"_check_arg","line":1190,"kind":13},{"containerName":"_check_arg","name":"warn","kind":12,"line":1190},{"name":"$aln","containerName":"_check_arg","line":1190,"kind":13},{"line":1190,"kind":12,"name":"get_seq_by_pos","containerName":"_check_arg"},{"name":"alphabet","containerName":"_check_arg","kind":12,"line":1190}],"containerName":"main::","definition":"sub","detail":"($self,$aln)","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"","label":"_check_arg($self,$aln)"}},{"name":"pairwise_stats","range":{"start":{"line":1211,"character":0},"end":{"character":9999,"line":1218}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"pairwise_stats","localvar":"my","kind":13,"line":1212},{"kind":13,"line":1212,"name":"$value","containerName":"pairwise_stats"},{"kind":13,"line":1213,"name":"$value","containerName":"pairwise_stats"},{"kind":13,"line":1214,"containerName":"pairwise_stats","name":"$self"},{"line":1214,"kind":13,"containerName":"pairwise_stats","name":"$value"},{"kind":13,"line":1216,"name":"$self","containerName":"pairwise_stats"}],"line":1211,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)","label":"pairwise_stats($self,$value)"},"detail":"($self,$value)"},{"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$seq1_id"},{"label":"$seq2_id"}],"label":"calc_KaKs_pair($self,$aln,$seq1_id,$seq2_id)"},"detail":"($self,$aln,$seq1_id,$seq2_id)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"calc_KaKs_pair","definition":"my","name":"$self","line":1235,"kind":13},{"name":"$aln","containerName":"calc_KaKs_pair","kind":13,"line":1235},{"line":1235,"kind":13,"containerName":"calc_KaKs_pair","name":"$seq1_id"},{"line":1235,"kind":13,"containerName":"calc_KaKs_pair","name":"$seq2_id"},{"name":"$self","containerName":"calc_KaKs_pair","kind":13,"line":1236},{"name":"throw","containerName":"calc_KaKs_pair","kind":12,"line":1236},{"line":1238,"kind":13,"containerName":"calc_KaKs_pair","name":"$self"},{"containerName":"calc_KaKs_pair","name":"throw","line":1238,"kind":12},{"kind":13,"line":1238,"name":"$aln","containerName":"calc_KaKs_pair"},{"name":"$aln","containerName":"calc_KaKs_pair","line":1238,"kind":13},{"name":"isa","containerName":"calc_KaKs_pair","line":1238,"kind":12},{"localvar":"my","definition":"my","name":"@seqs","containerName":"calc_KaKs_pair","line":1239,"kind":13},{"line":1242,"kind":13,"name":"$seq1_id","containerName":"calc_KaKs_pair"},{"kind":13,"line":1242,"containerName":"calc_KaKs_pair","name":"$aln"},{"kind":12,"line":1242,"containerName":"calc_KaKs_pair","name":"each_seq_with_id"},{"name":"$seq1_id","containerName":"calc_KaKs_pair","line":1242,"kind":13},{"containerName":"calc_KaKs_pair","name":"seq","line":1242,"kind":12},{"name":"$seq2_id","containerName":"calc_KaKs_pair","kind":13,"line":1243},{"line":1243,"kind":13,"name":"$aln","containerName":"calc_KaKs_pair"},{"line":1243,"kind":12,"name":"each_seq_with_id","containerName":"calc_KaKs_pair"},{"containerName":"calc_KaKs_pair","name":"$seq2_id","line":1243,"kind":13},{"name":"seq","containerName":"calc_KaKs_pair","kind":12,"line":1243},{"containerName":"calc_KaKs_pair","name":"$seqs","kind":13,"line":1245},{"name":"$seqs","containerName":"calc_KaKs_pair","kind":13,"line":1245},{"containerName":"calc_KaKs_pair","name":"$self","line":1246,"kind":13},{"containerName":"calc_KaKs_pair","name":"throw","kind":12,"line":1246},{"line":1248,"kind":13,"localvar":"my","containerName":"calc_KaKs_pair","definition":"my","name":"$results"},{"containerName":"calc_KaKs_pair","name":"$self","line":1249,"kind":13},{"line":1249,"kind":12,"containerName":"calc_KaKs_pair","name":"_get_av_ds_dn"},{"name":"@seqs","containerName":"calc_KaKs_pair","kind":13,"line":1249},{"containerName":"calc_KaKs_pair","name":"$results","kind":13,"line":1249},{"kind":13,"line":1250,"containerName":"calc_KaKs_pair","name":"$results"}],"line":1234,"kind":12,"range":{"end":{"line":1252,"character":9999},"start":{"character":0,"line":1234}},"name":"calc_KaKs_pair"},{"name":"id","line":1242,"kind":12},{"name":"seq","line":1242,"kind":12},{"line":1243,"kind":12,"name":"id"},{"line":1243,"kind":12,"name":"seq"},{"range":{"start":{"line":1269,"character":0},"end":{"character":9999,"line":1280}},"name":"calc_all_KaKs_pairs","line":1269,"children":[{"containerName":"calc_all_KaKs_pairs","name":"$self","definition":"my","localvar":"my","kind":13,"line":1271},{"line":1271,"kind":13,"name":"$aln","containerName":"calc_all_KaKs_pairs"},{"kind":13,"line":1272,"name":"$self","containerName":"calc_all_KaKs_pairs"},{"name":"throw","containerName":"calc_all_KaKs_pairs","kind":12,"line":1272},{"name":"$aln","containerName":"calc_all_KaKs_pairs","kind":13,"line":1272},{"line":1272,"kind":13,"name":"$aln","containerName":"calc_all_KaKs_pairs"},{"line":1272,"kind":12,"name":"isa","containerName":"calc_all_KaKs_pairs"},{"localvar":"my","definition":"my","name":"@seqs","containerName":"calc_all_KaKs_pairs","line":1273,"kind":13},{"name":"$seq","definition":"my","containerName":"calc_all_KaKs_pairs","localvar":"my","kind":13,"line":1274},{"containerName":"calc_all_KaKs_pairs","name":"$aln","line":1274,"kind":13},{"kind":12,"line":1274,"containerName":"calc_all_KaKs_pairs","name":"each_seq"},{"line":1275,"kind":13,"name":"@seqs","containerName":"calc_all_KaKs_pairs"},{"line":1275,"kind":13,"name":"$seq","containerName":"calc_all_KaKs_pairs"},{"containerName":"calc_all_KaKs_pairs","name":"display_id","kind":12,"line":1275},{"containerName":"calc_all_KaKs_pairs","name":"$seq","kind":13,"line":1275},{"name":"seq","containerName":"calc_all_KaKs_pairs","kind":12,"line":1275},{"kind":13,"line":1277,"containerName":"calc_all_KaKs_pairs","definition":"my","name":"$results","localvar":"my"},{"containerName":"calc_all_KaKs_pairs","name":"$results","line":1278,"kind":13},{"containerName":"calc_all_KaKs_pairs","name":"$self","kind":13,"line":1278},{"kind":12,"line":1278,"containerName":"calc_all_KaKs_pairs","name":"_get_av_ds_dn"},{"kind":13,"line":1278,"name":"@seqs","containerName":"calc_all_KaKs_pairs"},{"kind":13,"line":1278,"name":"$results","containerName":"calc_all_KaKs_pairs"},{"line":1279,"kind":13,"containerName":"calc_all_KaKs_pairs","name":"$results"}],"kind":12,"detail":"($self,$aln)","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.","label":"calc_all_KaKs_pairs($self,$aln)"},"containerName":"main::","definition":"sub"},{"name":"id","kind":12,"line":1275},{"name":"seq","kind":12,"line":1275},{"line":1295,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"calc_average_KaKs","line":1298,"kind":13},{"kind":13,"line":1298,"name":"$aln","containerName":"calc_average_KaKs"},{"kind":13,"line":1298,"name":"$bootstrap_rpt","containerName":"calc_average_KaKs"},{"line":1299,"kind":13,"containerName":"calc_average_KaKs","name":"$bootstrap_rpt"},{"containerName":"calc_average_KaKs","name":"$self","kind":13,"line":1300},{"name":"throw","containerName":"calc_average_KaKs","kind":12,"line":1300},{"line":1300,"kind":13,"name":"$aln","containerName":"calc_average_KaKs"},{"line":1300,"kind":13,"name":"$aln","containerName":"calc_average_KaKs"},{"line":1300,"kind":12,"containerName":"calc_average_KaKs","name":"isa"},{"line":1301,"kind":13,"localvar":"my","name":"@seqs","definition":"my","containerName":"calc_average_KaKs"},{"name":"$seq","definition":"my","containerName":"calc_average_KaKs","localvar":"my","kind":13,"line":1302},{"name":"$aln","containerName":"calc_average_KaKs","line":1302,"kind":13},{"line":1302,"kind":12,"containerName":"calc_average_KaKs","name":"each_seq"},{"line":1303,"kind":13,"containerName":"calc_average_KaKs","name":"@seqs"},{"line":1303,"kind":13,"name":"$seq","containerName":"calc_average_KaKs"},{"line":1303,"kind":12,"containerName":"calc_average_KaKs","name":"display_id"},{"line":1303,"kind":13,"name":"$seq","containerName":"calc_average_KaKs"},{"name":"seq","containerName":"calc_average_KaKs","kind":12,"line":1303},{"localvar":"my","containerName":"calc_average_KaKs","name":"$results","definition":"my","line":1305,"kind":13},{"localvar":"my","containerName":"calc_average_KaKs","definition":"my","name":"$ds_orig","line":1306,"kind":13},{"name":"$dn_orig","containerName":"calc_average_KaKs","line":1306,"kind":13},{"kind":13,"line":1306,"name":"$self","containerName":"calc_average_KaKs"},{"kind":12,"line":1306,"containerName":"calc_average_KaKs","name":"_get_av_ds_dn"},{"line":1306,"kind":13,"name":"@seqs","containerName":"calc_average_KaKs"},{"name":"$results","containerName":"calc_average_KaKs","kind":13,"line":1308},{"containerName":"calc_average_KaKs","name":"$ds_orig","kind":13,"line":1308},{"name":"$dn_orig","containerName":"calc_average_KaKs","line":1308,"kind":13},{"kind":13,"line":1309,"containerName":"calc_average_KaKs","name":"$self"},{"kind":12,"line":1309,"name":"_run_bootstrap","containerName":"calc_average_KaKs"},{"containerName":"calc_average_KaKs","name":"@seqs","kind":13,"line":1309},{"line":1309,"kind":13,"name":"$results","containerName":"calc_average_KaKs"},{"line":1309,"kind":13,"name":"$bootstrap_rpt","containerName":"calc_average_KaKs"},{"name":"$results","containerName":"calc_average_KaKs","kind":13,"line":1310}],"kind":12,"detail":"($self,$aln,$bootstrap_rpt)","signature":{"label":"calc_average_KaKs($self,$aln,$bootstrap_rpt)","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$bootstrap_rpt"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.\n\n\n\n\nsub calc_all_KaKs_pairs {\n#returns a multi_element_array with all pairwise comparisons\n\tmy ($self,$aln) = @_;\n\t$self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n\tmy @seqs;\n\tfor my $seq ($aln->each_seq) {\n\t\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n\t\t}\n\tmy $results ;\n\t$results = $self->_get_av_ds_dn(\\@seqs, $results);\n\treturn $results;\n}\n\n=head2 calc_average_KaKs\n\n Title    : calc_average_KaKs.  \n Useage   : my $res= $stats->calc_average_KaKs($alnobj, 1000).\n Function : calculates Nei_Gojobori stats for average of all \n            sequences in the alignment.\n Args     : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object, number of bootstrap iterations\n            (default 1000).\n Returns  : A reference to a hash of statistics as listed in Description."},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1295},"end":{"character":9999,"line":1311}},"name":"calc_average_KaKs"},{"name":"id","kind":12,"line":1303},{"name":"seq","line":1303,"kind":12},{"kind":12,"line":1308,"name":"D_s"},{"name":"D_n","kind":12,"line":1308},{"children":[{"line":1319,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_run_bootstrap"},{"containerName":"_run_bootstrap","name":"$seq_ref","line":1319,"kind":13},{"name":"$results","containerName":"_run_bootstrap","line":1319,"kind":13},{"kind":13,"line":1319,"containerName":"_run_bootstrap","name":"$bootstrap_rpt"},{"localvar":"my","definition":"my","name":"@seqs","containerName":"_run_bootstrap","line":1320,"kind":13},{"name":"$seq_ref","containerName":"_run_bootstrap","line":1320,"kind":13},{"kind":13,"line":1321,"name":"@btstrp_aoa","definition":"my","containerName":"_run_bootstrap","localvar":"my"},{"localvar":"my","containerName":"_run_bootstrap","definition":"my","name":"%bootstrap_values","line":1322,"kind":13},{"kind":13,"line":1325,"containerName":"_run_bootstrap","definition":"my","name":"$c","localvar":"my"},{"line":1326,"kind":13,"containerName":"_run_bootstrap","name":"$c"},{"kind":13,"line":1326,"containerName":"_run_bootstrap","name":"$seqs"},{"kind":13,"line":1328,"name":"$btstrp_aoa","containerName":"_run_bootstrap"},{"name":"$seqs","containerName":"_run_bootstrap","line":1328,"kind":13},{"line":1328,"kind":13,"name":"$c","containerName":"_run_bootstrap"},{"name":"$c","containerName":"_run_bootstrap","line":1330,"kind":13}],"line":1315,"kind":12,"signature":{"label":"_run_bootstrap($self,$seq_ref,$results,$bootstrap_rpt)","documentation":"############# primary internal subs for alignment comparisons ########################","parameters":[{"label":"$self"},{"label":"$seq_ref"},{"label":"$results"},{"label":"$bootstrap_rpt"}]},"detail":"($self,$seq_ref,$results,$bootstrap_rpt)","definition":"sub","containerName":"main::","range":{"start":{"line":1315,"character":0},"end":{"line":1331,"character":9999}},"name":"_run_bootstrap"},{"name":"ds","line":1322,"kind":12},{"name":"dn","line":1322,"kind":12},{"line":1327,"kind":12,"name":"seqs"},{"containerName":null,"name":"%bootstrap_rpt","line":1333,"kind":13},{"kind":13,"line":1334,"containerName":null,"definition":"my","name":"$sampled","localvar":"my"},{"kind":12,"line":1334,"name":"_resample"},{"containerName":null,"name":"@btstrp_aoa","kind":13,"line":1334},{"kind":13,"line":1335,"name":"$ds","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":1335,"containerName":null,"name":"$dn"},{"kind":13,"line":1335,"containerName":null,"name":"$self"},{"name":"_get_av_ds_dn","containerName":"main::","kind":12,"line":1335},{"line":1335,"kind":13,"containerName":null,"name":"$sampled"},{"line":1336,"kind":13,"containerName":null,"name":"%bootstrap_values"},{"kind":13,"line":1336,"name":"$ds","containerName":null},{"line":1337,"kind":13,"name":"%bootstrap_values","containerName":null},{"containerName":null,"name":"$dn","kind":13,"line":1337},{"name":"%results","containerName":null,"line":1340,"kind":13},{"kind":12,"line":1340,"name":"sampling_variance"},{"containerName":null,"name":"%bootstrap_values","kind":13,"line":1340},{"kind":13,"line":1341,"containerName":null,"name":"%results"},{"line":1341,"kind":12,"name":"sampling_variance"},{"kind":13,"line":1341,"name":"%bootstrap_values","containerName":null},{"line":1342,"kind":13,"name":"%results","containerName":null},{"kind":13,"line":1342,"name":"%results","containerName":null},{"kind":13,"line":1342,"name":"%results","containerName":null},{"kind":13,"line":1343,"name":"%results","containerName":null},{"kind":13,"line":1343,"name":"%results","containerName":null},{"range":{"start":{"character":0,"line":1349},"end":{"character":9999,"line":1351}},"containerName":"main::","definition":"sub","name":"_resample","line":1349,"children":[{"localvar":"my","containerName":"_resample","name":"$ref","definition":"my","line":1350,"kind":13},{"localvar":"my","containerName":"_resample","definition":"my","name":"$codon_num","line":1351,"kind":13},{"kind":13,"line":1351,"containerName":"_resample","name":"$ref"}],"kind":12},{"definition":"my","name":"@altered","containerName":null,"localvar":"my","kind":13,"line":1352},{"line":1353,"kind":13,"name":"%codon_num","containerName":null},{"localvar":"my","containerName":null,"name":"$rand","definition":"my","line":1354,"kind":13},{"name":"$codon_num","containerName":null,"kind":13,"line":1354},{"containerName":null,"name":"%ref","line":1355,"kind":13},{"name":"@altered","containerName":null,"kind":13,"line":1356},{"kind":13,"line":1356,"containerName":null,"name":"@ref"},{"kind":13,"line":1356,"containerName":null,"name":"$rand"},{"kind":13,"line":1359,"containerName":null,"definition":"my","name":"@stringed","localvar":"my"},{"line":1359,"kind":13,"containerName":null,"name":"$_"},{"containerName":null,"name":"@altered","kind":13,"line":1359},{"localvar":"my","containerName":null,"definition":"my","name":"@return","line":1360,"kind":13},{"kind":13,"line":1362,"name":"@stringed","containerName":null},{"line":1363,"kind":13,"name":"@return","containerName":null},{"name":"id","kind":12,"line":1363},{"kind":12,"line":1363,"name":"seq"},{"containerName":null,"name":"@return","line":1365,"kind":13},{"definition":"sub","name":"_get_av_ds_dn","containerName":"main::","range":{"end":{"character":9999,"line":1430},"start":{"line":1368,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"line":1370},{"kind":13,"line":1371,"name":"$seq_ref","definition":"my","containerName":"_get_av_ds_dn","localvar":"my"},{"kind":13,"line":1372,"containerName":"_get_av_ds_dn","name":"$result","definition":"my","localvar":"my"},{"definition":"my","name":"@caller","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"line":1373},{"localvar":"my","name":"@seqarray","definition":"my","containerName":"_get_av_ds_dn","line":1374,"kind":13},{"containerName":"_get_av_ds_dn","name":"$seq_ref","kind":13,"line":1374},{"containerName":"_get_av_ds_dn","name":"$bootstrap_score_list","definition":"my","localvar":"my","kind":13,"line":1375},{"kind":13,"line":1377,"containerName":"_get_av_ds_dn","definition":"my","name":"%dsfor_average","localvar":"my"},{"localvar":"my","name":"$i","definition":"my","containerName":"_get_av_ds_dn","line":1378,"kind":13},{"line":1378,"kind":13,"name":"$i","containerName":"_get_av_ds_dn"},{"line":1378,"kind":13,"containerName":"_get_av_ds_dn","name":"@seqarray"},{"name":"$i","containerName":"_get_av_ds_dn","kind":13,"line":1378},{"line":1379,"kind":13,"localvar":"my","definition":"my","name":"$j","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$i","line":1379,"kind":13},{"line":1379,"kind":13,"name":"$j","containerName":"_get_av_ds_dn"},{"name":"@seqarray","containerName":"_get_av_ds_dn","kind":13,"line":1379},{"name":"$j","containerName":"_get_av_ds_dn","line":1379,"kind":13},{"kind":13,"line":1381,"name":"$seqarray","containerName":"_get_av_ds_dn"},{"line":1381,"kind":13,"name":"$i","containerName":"_get_av_ds_dn"},{"kind":13,"line":1381,"name":"$seqarray","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$j","kind":13,"line":1381},{"name":"$self","containerName":"_get_av_ds_dn","line":1382,"kind":13},{"name":"warn","containerName":"_get_av_ds_dn","kind":12,"line":1382},{"line":1386,"kind":13,"localvar":"my","definition":"my","name":"$syn_site_count","containerName":"_get_av_ds_dn"},{"name":"$seqarray","containerName":"_get_av_ds_dn","line":1386,"kind":13},{"kind":13,"line":1386,"name":"$i","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$synsites","kind":13,"line":1386},{"kind":13,"line":1387,"containerName":"_get_av_ds_dn","definition":"my","name":"$syn_site_count2","localvar":"my"},{"name":"$seqarray","containerName":"_get_av_ds_dn","line":1387,"kind":13},{"kind":13,"line":1387,"name":"$j","containerName":"_get_av_ds_dn"},{"kind":13,"line":1387,"containerName":"_get_av_ds_dn","name":"$synsites"},{"containerName":"_get_av_ds_dn","name":"$syn_count","definition":"my","localvar":"my","kind":13,"line":1389},{"name":"$non_syn_count","containerName":"_get_av_ds_dn","line":1389,"kind":13},{"containerName":"_get_av_ds_dn","name":"$gap_cnt","kind":13,"line":1389},{"containerName":"_get_av_ds_dn","name":"$seqarray","line":1389,"kind":13},{"kind":13,"line":1389,"name":"$i","containerName":"_get_av_ds_dn"},{"kind":13,"line":1389,"containerName":"_get_av_ds_dn","name":"$seqarray"},{"containerName":"_get_av_ds_dn","name":"$j","line":1389,"kind":13},{"line":1391,"kind":13,"localvar":"my","definition":"my","name":"$av_s_site","containerName":"_get_av_ds_dn"},{"name":"$syn_site_count","containerName":"_get_av_ds_dn","kind":13,"line":1391},{"containerName":"_get_av_ds_dn","name":"$syn_site_count2","kind":13,"line":1391},{"localvar":"my","name":"$av_ns_syn_site","definition":"my","containerName":"_get_av_ds_dn","line":1392,"kind":13},{"name":"$seqarray","containerName":"_get_av_ds_dn","kind":13,"line":1392},{"name":"$i","containerName":"_get_av_ds_dn","kind":13,"line":1392},{"containerName":"_get_av_ds_dn","name":"$gap_cnt","line":1392,"kind":13},{"kind":13,"line":1392,"name":"$av_s_site","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$syn_prop","definition":"my","localvar":"my","kind":13,"line":1395},{"containerName":"_get_av_ds_dn","name":"$syn_count","line":1395,"kind":13},{"containerName":"_get_av_ds_dn","name":"$av_s_site","line":1395,"kind":13},{"containerName":"_get_av_ds_dn","definition":"my","name":"$nc_prop","localvar":"my","kind":13,"line":1396},{"name":"$non_syn_count","containerName":"_get_av_ds_dn","kind":13,"line":1396},{"kind":13,"line":1396,"containerName":"_get_av_ds_dn","name":"$av_ns_syn_site"},{"localvar":"my","containerName":"_get_av_ds_dn","name":"$d_syn","definition":"my","line":1399,"kind":13},{"name":"$self","containerName":"_get_av_ds_dn","kind":13,"line":1399},{"line":1399,"kind":12,"containerName":"_get_av_ds_dn","name":"jk"},{"kind":13,"line":1399,"containerName":"_get_av_ds_dn","name":"$syn_prop"},{"localvar":"my","containerName":"_get_av_ds_dn","name":"$d_nc","definition":"my","line":1400,"kind":13},{"kind":13,"line":1400,"name":"$self","containerName":"_get_av_ds_dn"},{"line":1400,"kind":12,"containerName":"_get_av_ds_dn","name":"jk"},{"name":"$nc_prop","containerName":"_get_av_ds_dn","kind":13,"line":1400},{"containerName":"_get_av_ds_dn","name":"$d_nc","line":1404,"kind":13},{"name":"$d_syn","containerName":"_get_av_ds_dn","line":1404,"kind":13},{"name":"$dsfor_average","containerName":"_get_av_ds_dn","line":1407,"kind":13},{"line":1407,"kind":13,"containerName":"_get_av_ds_dn","name":"$d_syn"},{"line":1408,"kind":13,"containerName":"_get_av_ds_dn","name":"$dsfor_average"},{"containerName":"_get_av_ds_dn","name":"$d_nc","kind":13,"line":1408},{"line":1411,"kind":13,"containerName":"_get_av_ds_dn","name":"$caller"},{"line":1411,"kind":13,"containerName":"_get_av_ds_dn","name":"$caller"},{"localvar":"my","name":"$d_syn_var","definition":"my","containerName":"_get_av_ds_dn","line":1413,"kind":13},{"kind":13,"line":1413,"name":"$syn_prop","containerName":"_get_av_ds_dn"},{"kind":13,"line":1413,"name":"$seqarray","containerName":"_get_av_ds_dn"},{"name":"$i","containerName":"_get_av_ds_dn","line":1413,"kind":13},{"kind":13,"line":1413,"containerName":"_get_av_ds_dn","name":"$gap_cnt"},{"line":1414,"kind":13,"localvar":"my","definition":"my","name":"$d_nc_var","containerName":"_get_av_ds_dn"},{"name":"$nc_prop","containerName":"_get_av_ds_dn","line":1414,"kind":13},{"name":"$seqarray","containerName":"_get_av_ds_dn","line":1414,"kind":13},{"kind":13,"line":1414,"name":"$i","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$gap_cnt","kind":13,"line":1414},{"kind":13,"line":1418,"name":"$z","definition":"my","containerName":"_get_av_ds_dn","localvar":"my"},{"kind":13,"line":1418,"containerName":"_get_av_ds_dn","name":"$d_syn_var"},{"containerName":"_get_av_ds_dn","name":"$d_nc_var","line":1418,"kind":13},{"name":"$d_nc","containerName":"_get_av_ds_dn","kind":13,"line":1419},{"line":1419,"kind":13,"containerName":"_get_av_ds_dn","name":"$d_syn"},{"name":"$d_syn_var","containerName":"_get_av_ds_dn","line":1419,"kind":13},{"name":"$d_nc_var","containerName":"_get_av_ds_dn","kind":13,"line":1419},{"line":1421,"kind":13,"containerName":"_get_av_ds_dn","name":"$result"},{"line":1421,"kind":13,"name":"$av_s_site","containerName":"_get_av_ds_dn"},{"line":1421,"kind":13,"containerName":"_get_av_ds_dn","name":"$av_ns_syn_site"},{"line":1422,"kind":13,"containerName":"_get_av_ds_dn","name":"$syn_count"},{"line":1422,"kind":13,"name":"$non_syn_count","containerName":"_get_av_ds_dn"},{"name":"$syn_prop","containerName":"_get_av_ds_dn","kind":13,"line":1423},{"name":"$nc_prop","containerName":"_get_av_ds_dn","kind":13,"line":1423},{"containerName":"_get_av_ds_dn","name":"$dsfor_average","line":1424,"kind":13},{"line":1425,"kind":13,"name":"$dsfor_average","containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","name":"$d_nc_var","kind":13,"line":1426},{"containerName":"_get_av_ds_dn","name":"$d_syn_var","kind":13,"line":1426},{"kind":13,"line":1427,"name":"$seqarray","containerName":"_get_av_ds_dn"},{"line":1427,"kind":13,"containerName":"_get_av_ds_dn","name":"$i"},{"line":1428,"kind":13,"name":"$seqarray","containerName":"_get_av_ds_dn"},{"name":"$j","containerName":"_get_av_ds_dn","line":1428,"kind":13},{"containerName":"_get_av_ds_dn","name":"$z","line":1429,"kind":13}],"line":1368},{"kind":12,"line":1377,"name":"ds"},{"name":"dn","line":1377,"kind":12},{"name":"count_syn_sites","line":1386,"kind":12},{"kind":12,"line":1387,"name":"count_syn_sites"},{"kind":12,"line":1389,"name":"analyse_mutations"},{"kind":12,"line":1413,"name":"jk_var"},{"name":"jk_var","kind":12,"line":1414},{"kind":12,"line":1422,"name":"S_d"},{"name":"N_d","line":1422,"kind":12},{"kind":12,"line":1423,"name":"P_s"},{"name":"P_n","line":1423,"kind":12},{"kind":12,"line":1424,"name":"D_s"},{"name":"D_n","line":1425,"kind":12},{"line":1426,"kind":12,"name":"D_n_var"},{"kind":12,"line":1426,"name":"D_s_var"},{"line":1427,"kind":12,"name":"Seq1"},{"kind":12,"line":1428,"name":"Seq2"},{"name":"z_score","line":1429,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":1431},{"line":1431,"kind":12,"containerName":"main::","name":"warn"},{"name":"$syn_count","containerName":null,"kind":13,"line":1432},{"containerName":null,"name":"$non_syn_count","line":1432,"kind":13},{"containerName":null,"name":"$self","line":1432,"kind":13},{"name":"verbose","containerName":"main::","line":1432,"kind":12},{"line":1442,"kind":13,"name":"$result","containerName":null},{"line":1442,"kind":13,"containerName":null,"name":"@caller"},{"line":1442,"kind":13,"name":"@caller","containerName":null},{"name":"mean","kind":12,"line":1444},{"line":1444,"kind":13,"containerName":null,"name":"%dsfor_average"},{"kind":12,"line":1444,"name":"mean"},{"kind":13,"line":1444,"containerName":null,"name":"%dsfor_average"},{"containerName":"main::","definition":"sub","detail":"($self,$p)","signature":{"parameters":[{"label":"$self"},{"label":"$p"}],"documentation":"","label":"jk($self,$p)"},"kind":12,"line":1448,"children":[{"kind":13,"line":1449,"containerName":"jk","definition":"my","name":"$self","localvar":"my"},{"line":1449,"kind":13,"name":"$p","containerName":"jk"},{"kind":13,"line":1450,"name":"$p","containerName":"jk"},{"kind":13,"line":1451,"containerName":"jk","name":"$self"},{"kind":12,"line":1451,"containerName":"jk","name":"warn"},{"kind":13,"line":1454,"containerName":"jk","name":"$p"}],"name":"jk","range":{"start":{"line":1448,"character":0},"end":{"character":9999,"line":1455}}},{"name":"jk_var","range":{"start":{"character":0,"line":1458},"end":{"character":9999,"line":1461}},"containerName":"main::","definition":"sub","detail":"($p,$n)","signature":{"parameters":[{"label":"$p"},{"label":"$n"}],"documentation":"works for large value of n (50?100?)","label":"jk_var($p,$n)"},"kind":12,"line":1458,"children":[{"kind":13,"line":1459,"containerName":"jk_var","name":"$p","definition":"my","localvar":"my"},{"containerName":"jk_var","name":"$n","line":1459,"kind":13},{"name":"$p","containerName":"jk_var","kind":13,"line":1460},{"kind":13,"line":1460,"containerName":"jk_var","name":"$p"},{"line":1460,"kind":13,"containerName":"jk_var","name":"$p"},{"containerName":"jk_var","name":"$n","line":1460,"kind":13}]},{"range":{"end":{"character":9999,"line":1569},"start":{"line":1467,"character":0}},"name":"analyse_mutations","children":[{"localvar":"my","name":"$seq1","definition":"my","containerName":"analyse_mutations","line":1468,"kind":13},{"name":"$seq2","containerName":"analyse_mutations","line":1468,"kind":13},{"definition":"my","name":"%mutator","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1469},{"kind":13,"line":1483,"name":"$TOTAL","definition":"my","containerName":"analyse_mutations","localvar":"my"},{"kind":13,"line":1484,"containerName":"analyse_mutations","definition":"my","name":"$TOTAL_n","localvar":"my"},{"line":1485,"kind":13,"localvar":"my","name":"$gap_cnt","definition":"my","containerName":"analyse_mutations"},{"name":"%input","definition":"my","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1487},{"kind":13,"line":1488,"containerName":"analyse_mutations","definition":"my","name":"$seqlen","localvar":"my"},{"name":"$seq1","containerName":"analyse_mutations","kind":13,"line":1488},{"line":1489,"kind":13,"localvar":"my","containerName":"analyse_mutations","definition":"my","name":"$j"},{"line":1489,"kind":13,"name":"$j","containerName":"analyse_mutations"},{"name":"$seqlen","containerName":"analyse_mutations","line":1489,"kind":13},{"line":1489,"kind":13,"name":"$j","containerName":"analyse_mutations"},{"kind":13,"line":1490,"name":"$input","containerName":"analyse_mutations"},{"line":1490,"kind":13,"name":"$seq1","containerName":"analyse_mutations"},{"name":"$j","containerName":"analyse_mutations","line":1490,"kind":13},{"line":1491,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"containerName":"analyse_mutations","name":"$seq2","line":1491,"kind":13},{"containerName":"analyse_mutations","name":"$j","kind":13,"line":1491},{"containerName":"analyse_mutations","name":"$input","line":1494,"kind":13},{"name":"$input","containerName":"analyse_mutations","line":1494,"kind":13},{"line":1495,"kind":13,"containerName":"analyse_mutations","name":"$gap_cnt"},{"definition":"my","name":"$diff_cnt","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1499},{"name":"$same","containerName":"analyse_mutations","kind":13,"line":1499},{"containerName":"analyse_mutations","name":"%input","kind":13,"line":1499},{"line":1502,"kind":13,"containerName":"analyse_mutations","name":"$diff_cnt"},{"containerName":"analyse_mutations","name":"$diff_cnt","line":1503,"kind":13},{"kind":13,"line":1504,"name":"$TOTAL","containerName":"analyse_mutations"},{"containerName":"analyse_mutations","name":"$synchanges","kind":13,"line":1504},{"line":1504,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"kind":13,"line":1504,"containerName":"analyse_mutations","name":"$input"},{"containerName":"analyse_mutations","name":"$TOTAL_n","kind":13,"line":1505},{"containerName":"analyse_mutations","name":"$synchanges","line":1505,"kind":13},{"line":1505,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"line":1505,"kind":13,"name":"$input","containerName":"analyse_mutations"},{"line":1508,"kind":13,"containerName":"analyse_mutations","name":"$diff_cnt"},{"kind":13,"line":1509,"containerName":"analyse_mutations","definition":"my","name":"$s_cnt","localvar":"my"},{"localvar":"my","containerName":"analyse_mutations","name":"$n_cnt","definition":"my","line":1510,"kind":13},{"kind":13,"line":1511,"containerName":"analyse_mutations","definition":"my","name":"$tot_muts","localvar":"my"},{"localvar":"my","definition":"my","name":"$perm","containerName":"analyse_mutations","line":1513,"kind":13},{"containerName":"analyse_mutations","name":"$mutator","line":1513,"kind":13},{"line":1513,"kind":13,"containerName":"analyse_mutations","name":"$same"},{"containerName":"analyse_mutations","definition":"my","name":"$altered","localvar":"my","kind":13,"line":1514},{"name":"$input","containerName":"analyse_mutations","line":1514,"kind":13},{"containerName":"analyse_mutations","name":"$prev","definition":"my","localvar":"my","kind":13,"line":1515},{"containerName":"analyse_mutations","name":"$altered","kind":13,"line":1515},{"localvar":"my","definition":"my","name":"$mut_i","containerName":"analyse_mutations","line":1517,"kind":13},{"containerName":"analyse_mutations","name":"$perm","line":1517,"kind":13},{"name":"$altered","containerName":"analyse_mutations","line":1518,"kind":13},{"containerName":"analyse_mutations","name":"$mut_i","kind":13,"line":1518},{"name":"$input","containerName":"analyse_mutations","kind":13,"line":1518},{"line":1518,"kind":13,"name":"$mut_i","containerName":"analyse_mutations"},{"containerName":"analyse_mutations","name":"$t","kind":13,"line":1519},{"name":"$CODONS","containerName":"analyse_mutations","kind":13,"line":1519},{"kind":13,"line":1519,"name":"$altered","containerName":"analyse_mutations"},{"kind":13,"line":1520,"name":"$tot_muts","containerName":"analyse_mutations"},{"kind":13,"line":1525,"name":"$s_cnt","containerName":"analyse_mutations"},{"name":"$synchanges","containerName":"analyse_mutations","line":1525,"kind":13},{"line":1525,"kind":13,"containerName":"analyse_mutations","name":"$prev"},{"line":1525,"kind":13,"containerName":"analyse_mutations","name":"$altered"},{"name":"$prev","containerName":"analyse_mutations","line":1528,"kind":13},{"name":"$altered","containerName":"analyse_mutations","kind":13,"line":1528},{"kind":13,"line":1532,"containerName":"analyse_mutations","name":"$tot_muts"},{"line":1533,"kind":13,"name":"$TOTAL","containerName":"analyse_mutations"},{"line":1533,"kind":13,"name":"$s_cnt","containerName":"analyse_mutations"},{"name":"$tot_muts","containerName":"analyse_mutations","kind":13,"line":1533},{"name":"$TOTAL_n","containerName":"analyse_mutations","kind":13,"line":1534},{"name":"$tot_muts","containerName":"analyse_mutations","line":1534,"kind":13},{"kind":13,"line":1534,"name":"$s_cnt","containerName":"analyse_mutations"},{"kind":13,"line":1534,"containerName":"analyse_mutations","name":"$tot_muts"},{"line":1538,"kind":13,"name":"$diff_cnt","containerName":"analyse_mutations"},{"localvar":"my","definition":"my","name":"$s_cnt","containerName":"analyse_mutations","line":1539,"kind":13},{"localvar":"my","containerName":"analyse_mutations","definition":"my","name":"$n_cnt","line":1540,"kind":13},{"line":1541,"kind":13,"localvar":"my","name":"$tot_muts","definition":"my","containerName":"analyse_mutations"},{"localvar":"my","name":"$perm","definition":"my","containerName":"analyse_mutations","line":1542,"kind":13},{"name":"$mutator","containerName":"analyse_mutations","line":1542,"kind":13},{"localvar":"my","containerName":"analyse_mutations","name":"$altered","definition":"my","line":1543,"kind":13},{"line":1543,"kind":13,"name":"$input","containerName":"analyse_mutations"},{"name":"$prev","definition":"my","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1544},{"containerName":"analyse_mutations","name":"$altered","kind":13,"line":1544},{"line":1546,"kind":13,"localvar":"my","containerName":"analyse_mutations","definition":"my","name":"$mut_i"},{"containerName":"analyse_mutations","name":"$perm","line":1546,"kind":13},{"name":"$altered","containerName":"analyse_mutations","kind":13,"line":1547},{"name":"$mut_i","containerName":"analyse_mutations","line":1547,"kind":13},{"kind":13,"line":1547,"containerName":"analyse_mutations","name":"$input"},{"line":1547,"kind":13,"containerName":"analyse_mutations","name":"$mut_i"},{"kind":13,"line":1548,"name":"$t","containerName":"analyse_mutations"},{"name":"$CODONS","containerName":"analyse_mutations","kind":13,"line":1548},{"line":1548,"kind":13,"name":"$altered","containerName":"analyse_mutations"},{"line":1549,"kind":13,"name":"$tot_muts","containerName":"analyse_mutations"},{"containerName":"analyse_mutations","name":"$s_cnt","line":1555,"kind":13},{"containerName":"analyse_mutations","name":"$synchanges","kind":13,"line":1555},{"kind":13,"line":1555,"name":"$prev","containerName":"analyse_mutations"},{"line":1555,"kind":13,"containerName":"analyse_mutations","name":"$altered"},{"name":"$prev","containerName":"analyse_mutations","kind":13,"line":1558},{"line":1558,"kind":13,"containerName":"analyse_mutations","name":"$altered"},{"containerName":"analyse_mutations","name":"$tot_muts","line":1565,"kind":13},{"containerName":"analyse_mutations","name":"$TOTAL","line":1566,"kind":13},{"kind":13,"line":1566,"containerName":"analyse_mutations","name":"$s_cnt"},{"containerName":"analyse_mutations","name":"$tot_muts","line":1566,"kind":13},{"line":1567,"kind":13,"name":"$TOTAL_n","containerName":"analyse_mutations"},{"kind":13,"line":1567,"name":"$s_cnt","containerName":"analyse_mutations"},{"containerName":"analyse_mutations","name":"$tot_muts","kind":13,"line":1567}],"line":1467,"kind":12,"signature":{"label":"analyse_mutations($seq1,$seq2)","parameters":[{"label":"$seq1"},{"label":"$seq2"}],"documentation":" compares 2 sequences to find the number of synonymous/non\n synonymous mutations between them"},"detail":"($seq1,$seq2)","definition":"sub","containerName":"main::"},{"name":"count_diffs","line":1499,"kind":12},{"kind":12,"line":1513,"name":"OUTER"},{"kind":12,"line":1522,"name":"OUTER"},{"kind":12,"line":1542,"name":"OUTER"},{"kind":12,"line":1551,"name":"OUTER"},{"name":"$TOTAL","containerName":null,"kind":13,"line":1571},{"line":1571,"kind":13,"name":"$TOTAL_n","containerName":null},{"line":1571,"kind":13,"name":"$gap_cnt","containerName":null},{"containerName":"main::","definition":"sub","name":"count_diffs","range":{"start":{"character":0,"line":1575},"end":{"character":9999,"line":1592}},"kind":12,"line":1575,"children":[{"line":1580,"kind":13,"localvar":"my","name":"$ref","definition":"my","containerName":"count_diffs"},{"definition":"my","name":"$cnt","containerName":"count_diffs","localvar":"my","kind":13,"line":1581},{"definition":"my","name":"$same","containerName":"count_diffs","localvar":"my","kind":13,"line":1582},{"name":"$ref","containerName":"count_diffs","line":1585,"kind":13},{"containerName":"count_diffs","name":"$ref","kind":13,"line":1585},{"name":"$cnt","containerName":"count_diffs","line":1586,"kind":13},{"line":1588,"kind":13,"containerName":"count_diffs","name":"$same"},{"containerName":"count_diffs","name":"$cnt","line":1591,"kind":13},{"line":1591,"kind":13,"name":"$same","containerName":"count_diffs"}]},{"kind":12,"line":1613,"children":[{"definition":"my","name":"%results","containerName":"get_syn_changes","localvar":"my","kind":13,"line":1616},{"kind":13,"line":1617,"definition":"my","name":"@codons","containerName":"get_syn_changes","localvar":"my"},{"name":"$arr_len","definition":"my","containerName":"get_syn_changes","localvar":"my","kind":13,"line":1618},{"name":"@codons","containerName":"get_syn_changes","line":1618,"kind":13},{"line":1619,"kind":13,"localvar":"my","containerName":"get_syn_changes","definition":"my","name":"$i"},{"name":"$i","containerName":"get_syn_changes","line":1619,"kind":13},{"line":1619,"kind":13,"name":"$arr_len","containerName":"get_syn_changes"},{"line":1619,"kind":13,"name":"$i","containerName":"get_syn_changes"},{"line":1620,"kind":13,"localvar":"my","name":"$cod1","definition":"my","containerName":"get_syn_changes"},{"line":1620,"kind":13,"name":"$codons","containerName":"get_syn_changes"},{"name":"$i","containerName":"get_syn_changes","line":1620,"kind":13},{"localvar":"my","name":"$j","definition":"my","containerName":"get_syn_changes","line":1621,"kind":13},{"name":"$i","containerName":"get_syn_changes","line":1621,"kind":13},{"line":1621,"kind":13,"name":"$j","containerName":"get_syn_changes"},{"line":1621,"kind":13,"containerName":"get_syn_changes","name":"$arr_len"},{"containerName":"get_syn_changes","name":"$j","line":1621,"kind":13},{"containerName":"get_syn_changes","definition":"my","name":"$diff_cnt","localvar":"my","kind":13,"line":1622},{"name":"$pos","definition":"my","containerName":"get_syn_changes","localvar":"my","kind":13,"line":1623},{"line":1624,"kind":13,"name":"$diff_cnt","containerName":"get_syn_changes"},{"name":"$cod1","containerName":"get_syn_changes","kind":13,"line":1624},{"name":"$pos","containerName":"get_syn_changes","kind":13,"line":1624},{"line":1624,"kind":13,"name":"$codons","containerName":"get_syn_changes"},{"kind":13,"line":1624,"containerName":"get_syn_changes","name":"$j"},{"name":"$pos","containerName":"get_syn_changes","kind":13,"line":1624},{"name":"$diff_cnt","containerName":"get_syn_changes","kind":13,"line":1626},{"kind":13,"line":1629,"name":"$t","containerName":"get_syn_changes"},{"line":1629,"kind":13,"name":"$CODONS","containerName":"get_syn_changes"},{"kind":13,"line":1629,"name":"$cod1","containerName":"get_syn_changes"},{"name":"$t","containerName":"get_syn_changes","kind":13,"line":1629},{"name":"$CODONS","containerName":"get_syn_changes","line":1629,"kind":13},{"containerName":"get_syn_changes","name":"$codons","line":1629,"kind":13},{"line":1629,"kind":13,"containerName":"get_syn_changes","name":"$j"},{"name":"$results","containerName":"get_syn_changes","line":1630,"kind":13},{"name":"$cod1","containerName":"get_syn_changes","kind":13,"line":1630},{"name":"$codons","containerName":"get_syn_changes","line":1630,"kind":13},{"containerName":"get_syn_changes","name":"$j","line":1630,"kind":13},{"kind":13,"line":1631,"containerName":"get_syn_changes","name":"$results"},{"line":1631,"kind":13,"containerName":"get_syn_changes","name":"$codons"},{"name":"$j","containerName":"get_syn_changes","line":1631,"kind":13},{"name":"$cod1","containerName":"get_syn_changes","kind":13,"line":1631},{"line":1634,"kind":13,"name":"$t","containerName":"get_syn_changes"},{"line":1634,"kind":13,"name":"$CODONS","containerName":"get_syn_changes"},{"name":"$cod1","containerName":"get_syn_changes","line":1634,"kind":13},{"kind":13,"line":1634,"name":"$t","containerName":"get_syn_changes"},{"name":"$CODONS","containerName":"get_syn_changes","line":1634,"kind":13},{"name":"$codons","containerName":"get_syn_changes","kind":13,"line":1634},{"containerName":"get_syn_changes","name":"$j","kind":13,"line":1634},{"containerName":"get_syn_changes","name":"$results","line":1635,"kind":13},{"kind":13,"line":1635,"name":"$cod1","containerName":"get_syn_changes"},{"name":"$codons","containerName":"get_syn_changes","line":1635,"kind":13},{"line":1635,"kind":13,"containerName":"get_syn_changes","name":"$j"},{"kind":13,"line":1636,"containerName":"get_syn_changes","name":"$results"},{"line":1636,"kind":13,"name":"$codons","containerName":"get_syn_changes"},{"name":"$j","containerName":"get_syn_changes","kind":13,"line":1636},{"kind":13,"line":1636,"name":"$cod1","containerName":"get_syn_changes"},{"line":1640,"kind":13,"name":"$results","containerName":"get_syn_changes"},{"kind":13,"line":1640,"containerName":"get_syn_changes","name":"$cod1"},{"kind":13,"line":1640,"name":"$codons","containerName":"get_syn_changes"},{"kind":13,"line":1640,"name":"$j","containerName":"get_syn_changes"},{"kind":13,"line":1641,"name":"$results","containerName":"get_syn_changes"},{"line":1641,"kind":13,"name":"$codons","containerName":"get_syn_changes"},{"containerName":"get_syn_changes","name":"$j","line":1641,"kind":13},{"line":1641,"kind":13,"name":"$cod1","containerName":"get_syn_changes"},{"line":1645,"kind":13,"containerName":"get_syn_changes","name":"%results"}],"containerName":"main::","definition":"sub","name":"get_syn_changes","range":{"start":{"line":1613,"character":0},"end":{"line":1646,"character":9999}}},{"line":1617,"kind":12,"name":"_make_codons"},{"name":"dnds_pattern_number","range":{"end":{"line":1662,"character":9999},"start":{"character":0,"line":1659}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.\n\n\n\n\nsub calc_all_KaKs_pairs {\n#returns a multi_element_array with all pairwise comparisons\n\tmy ($self,$aln) = @_;\n\t$self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n\tmy @seqs;\n\tfor my $seq ($aln->each_seq) {\n\t\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n\t\t}\n\tmy $results ;\n\t$results = $self->_get_av_ds_dn(\\@seqs, $results);\n\treturn $results;\n}\n\n=head2 calc_average_KaKs\n\n Title    : calc_average_KaKs.  \n Useage   : my $res= $stats->calc_average_KaKs($alnobj, 1000).\n Function : calculates Nei_Gojobori stats for average of all \n            sequences in the alignment.\n Args     : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object, number of bootstrap iterations\n            (default 1000).\n Returns  : A reference to a hash of statistics as listed in Description.\n\n\nsub calc_average_KaKs {\n#calculates global value for sequences in alignment using bootstrapping\n#this is quite slow (~10 seconds per  3 X 200nt seqs); \n    my ($self, $aln, $bootstrap_rpt) = @_;\n    $bootstrap_rpt ||= 1000;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs;\n    for my $seq ($aln->each_seq) {\n\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n    }\n    my $results ;\n    my ($ds_orig, $dn_orig) = $self->_get_av_ds_dn(\\@seqs);\n    #print \"ds = $ds_orig, dn = $dn_orig\\n\";\n    $results = {D_s => $ds_orig, D_n => $dn_orig};\n    $self->_run_bootstrap(\\@seqs, $results, $bootstrap_rpt);\n    return $results;\n}\n\n############## primary internal subs for alignment comparisons ########################\n\nsub _run_bootstrap {\n    ### generates sampled sequences, calculates Ds and Dn values,\n    ### then calculates variance of sampled sequences and add results to results hash\n    ### \n    my ($self,$seq_ref, $results, $bootstrap_rpt) = @_;\t\n    my @seqs = @$seq_ref;\n    my @btstrp_aoa; # to hold array of array of nucleotides for resampling\n    my %bootstrap_values = (ds => [], dn =>[]);\t# to hold list of av values \n\n    #1st make alternative array of codons;\n    my $c = 0;\n    while ($c < length $seqs[0]{'seq'}) {\n\tfor (0..$#seqs) {\n\t    push @{$btstrp_aoa[$_]}, substr ($seqs[$_]{'seq'}, $c, 3);\n\t}\n\t$c+=3;\n    }\n\n    for (1..$bootstrap_rpt) {\n\tmy $sampled = _resample (\\@btstrp_aoa);\n\tmy ($ds, $dn) = $self->_get_av_ds_dn ($sampled) ; # is array ref\n\tpush @{$bootstrap_values{'ds'}}, $ds;\n\tpush @{$bootstrap_values{'dn'}}, $dn;\n    }\t\n\n    $results->{'D_s_var'} = sampling_variance($bootstrap_values{'ds'});\n    $results->{'D_n_var'} = sampling_variance($bootstrap_values{'dn'});\n    $results->{'z_score'} = \t($results->{'D_n'} - $results->{'D_s'}) / \n\tsqrt($results->{'D_s_var'} + $results->{'D_n_var'} ); \n    #print \"bootstrapped var_syn = \t$results->{'D_s_var'} \\n\" ;\n    #print \"bootstrapped var_nc = \t$results->{'D_n_var'} \\n\"; \n    #print \"z is $results->{'z_score'}\\n\";\t### end of global set up of/perm look up data\n}\n\nsub _resample {\n    my $ref = shift;\n    my $codon_num = scalar (@{$ref->[0]});\n    my @altered;\n    for (0..$codon_num -1) {\t#for each codon\n\tmy $rand = int (rand ($codon_num));\n\tfor (0..$#$ref) {\n\t    push @{$altered[$_]}, $ref->[$_][$rand];\n\t}\n    }\n    my @stringed = map {join '', @$_}@altered;\n    my @return;\n    #now out in random name to keep other subs happy\n    for (@stringed) {\n\tpush @return, {id=>'1', seq=> $_};\n    }\n    return \\@return;\n}\n\nsub _get_av_ds_dn {\n    # takes array of hashes of sequence strings and ids   #\n    my $self = shift;\n    my $seq_ref = shift;\n    my $result = shift if @_;\n    my @caller = caller(1);\n    my @seqarray = @$seq_ref;\n    my $bootstrap_score_list;\n    #for a multiple alignment considers all pairwise combinations#\n    my %dsfor_average = (ds => [], dn => []); \n    for (my $i = 0; $i < scalar @seqarray; $i++) {\n\tfor (my $j = $i +1; $j<scalar @seqarray; $j++ ){\n#\t\t\tprint \"comparing $i and $j\\n\";\n\t    if (length($seqarray[$i]{'seq'}) != length($seqarray[$j]{'seq'})) {\n\t\t$self->warn(\" aligned sequences must be of equal length!\");\n\t\tnext;\n\t    }\n\n\t    my $syn_site_count = count_syn_sites($seqarray[$i]{'seq'}, $synsites);\n\t    my $syn_site_count2 = count_syn_sites($seqarray[$j]{'seq'}, $synsites);\n#\t\t\tprint \"syn 1 is $syn_site_count , syn2 is $syn_site_count2\\n\";\n\t    my ($syn_count, $non_syn_count, $gap_cnt) = analyse_mutations($seqarray[$i]{'seq'}, $seqarray[$j]{'seq'});\t\n\t    #get averages\n\t    my $av_s_site = ($syn_site_count + $syn_site_count2)/2;\n\t    my $av_ns_syn_site = length($seqarray[$i]{'seq'}) - $gap_cnt- $av_s_site ;\n\n\t    #calculate ps and pn  (p54)\n\t    my $syn_prop = $syn_count / $av_s_site;\n\t    my $nc_prop = $non_syn_count / $av_ns_syn_site\t;\n\n\t    #now use jukes/cantor to calculate D_s and D_n, would alter here if needed a different method\n\t    my $d_syn = $self->jk($syn_prop);\n\t    my $d_nc = $self->jk($nc_prop);\n\n\t    #JK calculation must succeed for continuation of calculation\n\t    #ret_value = -1 if error\n\t    next unless $d_nc >=0 && $d_syn >=0;\n\n\n\t    push @{$dsfor_average{'ds'}}, $d_syn;\n\t    push @{$dsfor_average{'dn'}}, $d_nc;\n\n\t    #if not doing bootstrap, calculate the pairwise comparisin stats\n\t    if ($caller[3] =~ /calc_KaKs_pair/ || $caller[3] =~ /calc_all_KaKs_pairs/) {\n\t\t\t\t#now calculate variances assuming large sample\n\t\tmy $d_syn_var =  jk_var($syn_prop, length($seqarray[$i]{'seq'})  - $gap_cnt );\n\t\tmy $d_nc_var =  jk_var($nc_prop, length ($seqarray[$i]{'seq'}) - $gap_cnt);\n\t\t#now calculate z_value\n\t\t#print \"d_syn_var is  $d_syn_var,and d_nc_var is $d_nc_var\\n\";\n\t\t#my $z = ($d_nc - $d_syn) / sqrt($d_syn_var + $d_nc_var);\n\t\tmy $z = ($d_syn_var + $d_nc_var) ? \n\t\t  ($d_nc - $d_syn) / sqrt($d_syn_var + $d_nc_var) : 0;\n\t\t#\tprint \"z is $z\\n\";\n\t\tpush @$result , {S => $av_s_site, N=>$av_ns_syn_site,\n\t\t\t\t S_d => $syn_count, N_d =>$non_syn_count,\n\t\t\t\t P_s => $syn_prop, P_n=>$nc_prop,\n\t\t\t\t D_s => @{$dsfor_average{'ds'}}[-1],\n\t\t\t\t D_n => @{$dsfor_average{'dn'}}[-1],\n\t\t\t\t D_n_var =>$d_nc_var, D_s_var => $d_syn_var,\n\t\t\t\t Seq1 => $seqarray[$i]{'id'},\n\t\t\t\t Seq2 => $seqarray[$j]{'id'},\n\t\t\t\t z_score => $z,\n\t\t\t     };\n\t\t$self->warn (\" number of mutations too small to justify normal test for  $seqarray[$i]{'id'} and $seqarray[$j]{'id'}\\n- use Fisher's exact, or bootstrap a MSA\")\n\t\t    if ($syn_count < 10 || $non_syn_count < 10 ) && $self->verbose > -1 ;\n\t    }#endif\n\t    }\n    }\n\n    #warn of failure if no results hashes are present\n    #will fail if Jukes Cantor has failed for all pairwise combinations\n    #$self->warn(\"calculation failed!\") if scalar @$result ==0;\n\n    #return results unless bootstrapping\n    return $result if $caller[3]=~ /calc_all_KaKs/ || $caller[3] =~ /calc_KaKs_pair/; \n    #else if getting average for bootstrap\n    return( mean ($dsfor_average{'ds'}),mean ($dsfor_average{'dn'})) ;\n}\n\n\nsub jk {\n    my ($self, $p) = @_;\n    if ($p > 0.75) {\n\t$self->warn( \" Jukes Cantor won't  work -too divergent!\");\n\treturn -1;\n    }\n    return -1 * (3/4) * (log(1 - (4/3) * $p));\n}\n\n#works for large value of n (50?100?)\nsub jk_var {\n    my ($p, $n) = @_;\n    return (9 * $p * (1 -$p))/(((3 - 4 *$p) **2) * $n);\n}\n\n\n# compares 2 sequences to find the number of synonymous/non\n# synonymous mutations between them\n\nsub analyse_mutations {\n    my ($seq1, $seq2) = @_;\n    my %mutator = ( 2=> {0=>[[1,2],  # codon positions to be altered \n\t\t\t     [2,1]], # depend on which is the same\n\t\t\t 1=>[[0,2],\n\t\t\t     [2,0]],\n\t\t\t 2=>[[0,1],\n\t\t\t     [1,0]],\t\n\t\t     },\n\t\t    3=> [ [0,1,2],  # all need to be altered \n\t\t\t  [1,0,2],\n\t\t\t  [0,2,1],\n\t\t\t  [1,2,0],\n\t\t\t  [2,0,1],\n\t\t\t  [2,1,0] ],\n\t\t    );\n    my $TOTAL   = 0;    # total synonymous changes\n    my $TOTAL_n = 0;\t# total non-synonymous changes\n    my $gap_cnt = 0;\n\n    my %input;\n    my $seqlen = length($seq1);\n    for (my $j=0; $j< $seqlen; $j+=3) {\n\t$input{'cod1'} = substr($seq1, $j,3);\n\t$input{'cod2'} = substr($seq2, $j,3);\n\n\t#ignore codon if beeing compared with gaps! \n\tif ($input{'cod1'} =~ /\\-/ || $input{'cod2'} =~ /\\-/){\n\t    $gap_cnt += 3; #just increments once if there is a pair of gaps\n\t    next;\n\t}\n\n\tmy ($diff_cnt, $same) = count_diffs(\\%input);\n\n\t#ignore if codons are identical\n\tnext if $diff_cnt == 0 ;\n\tif ($diff_cnt == 1) {\n\t    $TOTAL += $synchanges{$input{'cod1'}}{$input{'cod2'}};\n\t    $TOTAL_n += 1 - $synchanges{$input{'cod1'}}{$input{'cod2'}};\n\t    #print \" \\nfordiff is 1 , total now $TOTAL, total n now $TOTAL_n\\n\\n\"\n\t}\n\telsif ($diff_cnt ==2) {\n\t    my $s_cnt = 0;\n\t    my $n_cnt = 0;\n\t    my $tot_muts = 4;\n\t    #will stay 4 unless there are stop codons at intervening point\n\t  OUTER:for my $perm (@{$mutator{'2'}{$same}}) {\n\t      my $altered = $input{'cod1'};\n\t      my $prev= $altered;\n\t      #\t\tprint \"$prev -> (\", $t[$CODONS->{$altered}], \")\";\n\t      for \tmy $mut_i (@$perm) { #index of codon mutated\n\t\t  substr($altered, $mut_i,1) = substr($input{'cod2'}, $mut_i, 1);\n\t\t  if ($t[$CODONS->{$altered}] eq '*') {\n\t\t      $tot_muts -=2;\n\t\t      #print \"changes to stop codon!!\\n\";\n\t\t      next OUTER;\n\t\t  }\n\t\t  else {\n\t\t      $s_cnt += $synchanges{$prev}{$altered};\n\t\t      #\t\t\t\t\tprint \"$altered ->(\", $t[$CODONS->{$altered}], \") \";\n\t\t  }\n\t\t  $prev = $altered;\n\t      }\n\t      #\t\tprint \"\\n\";\n\t  }\n\t    if ($tot_muts != 0) {\n\t\t$TOTAL += ($s_cnt/($tot_muts/2));\n\t\t$TOTAL_n += ($tot_muts - $s_cnt)/ ($tot_muts / 2);\n\t    }\n\n\t}\n\telsif ($diff_cnt ==3 ) {\n\t    my $s_cnt = 0;\n\t    my $n_cnt = 0;\n\t    my $tot_muts = 18;\t#potential number  of mutations\n\t  OUTER: for my $perm (@{$mutator{'3'}}) {\n\t      my $altered = $input{'cod1'};\n\t      my $prev= $altered;\n\t      #\tprint \"$prev -> (\", $t[$CODONS->{$altered}], \")\";\n\t      for my $mut_i (@$perm) { #index of codon mutated\n\t\t  substr($altered, $mut_i,1) = substr($input{'cod2'}, $mut_i, 1);\n\t\t  if ($t[$CODONS->{$altered}] eq '*') {\n\t\t      $tot_muts -=3;\n\t\t      #\tprint \"changes to stop codon!!\\n\";\n\t\t      next OUTER;\n\n\t\t  }\n\t\t  else {\n\t\t      $s_cnt += $synchanges{$prev}{$altered};\n\t\t      #\t\t\tprint \"$altered ->(\", $t[$CODONS->{$altered}], \") \";\n\t\t  }\n\t\t  $prev = $altered;\n\t      }\n\t      #\tprint \"\\n\";\n\n\t  }#end OUTER loop\n\t      #calculate number of synonymous/non synonymous mutations for that codon\n\t      # and add to total\n\t      if ($tot_muts != 0) {\n\t\t  $TOTAL += ($s_cnt / ($tot_muts /3));\n\t\t  $TOTAL_n += 3 - ($s_cnt / ($tot_muts /3));\n\t      }\n\t}\t\t\t#endif $diffcnt = 3\n    }\t\t\t\t#end of sequencetraversal\n    return ($TOTAL, $TOTAL_n, $gap_cnt);\n}\n\n\nsub count_diffs {\n    #counts the number of nucleotide differences between 2 codons\n    # returns this value plus the codon index of which nucleotide is the same when 2\n    #nucleotides are different. This is so analyse_mutations() knows which nucleotides\n    # to change.\n    my $ref = shift;\n    my $cnt = 0;\n    my $same= undef;\n    #just for 2 differences\n    for (0..2) {\n\tif (substr($ref->{'cod1'}, $_,1) ne substr($ref->{'cod2'}, $_, 1)){\n\t    $cnt++;\n\t} else {\n\t    $same = $_;\n\t}\n    }\n    return ($cnt, $same);\n}\n\n=head2 get_syn_changes\n\n Title   : get_syn_changes\n Usage   : Bio::Align::DNAStatitics->get_syn_changes\n Function: Generate a hashref of all pairwise combinations of codns\n           differing by 1\n Returns : Symetic matrix using hashes\n           First key is codon\n           and each codon points to a hashref of codons\n           the values of which describe type of change.\n           my $type = $hash{$codon1}->{$codon2};\n           values are :\n             1   synonymous\n             0   non-syn\n            -1   either codon is a stop codon\n Args    : none\n\n\nsub get_syn_changes {\n#hash of all pairwise combinations of codons differing by 1\n# 1 = syn, 0 = non-syn, -1 = stop\n    my %results;\n    my @codons = _make_codons ();\n    my $arr_len = scalar @codons;\n    for (my $i = 0; $i < $arr_len -1; $i++) {\n\tmy $cod1 = $codons[$i];\n\tfor (my $j = $i +1; $j < $arr_len; $j++) {\n\t    my $diff_cnt = 0;\n\t    for my $pos(0..2) {\n\t\t$diff_cnt++ if substr($cod1, $pos, 1) ne substr($codons[$j], $pos, 1);\n\t    }\n\t    next if $diff_cnt !=1;\n\n\t    #synon change\n\t    if($t[$CODONS->{$cod1}] eq $t[$CODONS->{$codons[$j]}]) {\n\t\t$results{$cod1}{$codons[$j]} =1;\n\t\t$results{$codons[$j]}{$cod1} = 1;\n\t    }\n\t    #stop codon\n\t    elsif ($t[$CODONS->{$cod1}] eq '*' or $t[$CODONS->{$codons[$j]}] eq '*') {\n\t\t$results{$cod1}{$codons[$j]} = -1;\n\t\t$results{$codons[$j]}{$cod1} = -1;\n\t    }\n\t    # nc change\n\t    else {\n\t\t$results{$cod1}{$codons[$j]} = 0;\n\t\t$results{$codons[$j]}{$cod1} = 0;\n\t    }\n\t}\n    }\n    return %results;\n}\n\n=head2 dnds_pattern_number\n\n Title   : dnds_pattern_number\n Usage   : my $patterns = $stats->dnds_pattern_number($alnobj);\n Function: Counts the number of codons with no gaps in the MSA\n Returns : Number of codons with no gaps ('patterns' in PAML notation)\n Args    : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object.","label":"dnds_pattern_number($self,$aln)"},"detail":"($self,$aln)","kind":12,"children":[{"line":1660,"kind":13,"localvar":"my","containerName":"dnds_pattern_number","definition":"my","name":"$self"},{"line":1660,"kind":13,"name":"$aln","containerName":"dnds_pattern_number"},{"line":1661,"kind":13,"containerName":"dnds_pattern_number","name":"$aln"},{"line":1661,"kind":12,"name":"remove_gaps","containerName":"dnds_pattern_number"},{"line":1661,"kind":12,"containerName":"dnds_pattern_number","name":"length"}],"line":1659},{"name":"count_syn_sites","range":{"end":{"line":1676,"character":9999},"start":{"character":0,"line":1664}},"containerName":"main::","definition":"sub","detail":"($seq,$synsite)","signature":{"parameters":[{"label":"$seq"},{"label":"$synsite"}],"documentation":"","label":"count_syn_sites($seq,$synsite)"},"kind":12,"line":1664,"children":[{"line":1666,"kind":13,"localvar":"my","containerName":"count_syn_sites","definition":"my","name":"$seq"},{"kind":13,"line":1666,"name":"$synsite","containerName":"count_syn_sites"},{"kind":12,"line":1667,"containerName":"count_syn_sites","name":"throw"},{"line":1667,"kind":13,"containerName":"count_syn_sites","name":"$seq"},{"containerName":"count_syn_sites","name":"$S","definition":"my","localvar":"my","kind":13,"line":1668},{"kind":13,"line":1669,"definition":"my","name":"$i","containerName":"count_syn_sites","localvar":"my"},{"line":1669,"kind":13,"containerName":"count_syn_sites","name":"$i"},{"line":1669,"kind":13,"name":"$seq","containerName":"count_syn_sites"},{"name":"$i","containerName":"count_syn_sites","line":1669,"kind":13},{"kind":13,"line":1670,"name":"$cod","definition":"my","containerName":"count_syn_sites","localvar":"my"},{"line":1670,"kind":13,"containerName":"count_syn_sites","name":"$seq"},{"containerName":"count_syn_sites","name":"$i","kind":13,"line":1670},{"kind":13,"line":1671,"containerName":"count_syn_sites","name":"$cod"},{"name":"$S","containerName":"count_syn_sites","kind":13,"line":1672},{"line":1672,"kind":13,"name":"$synsite","containerName":"count_syn_sites"},{"line":1672,"kind":13,"name":"$cod","containerName":"count_syn_sites"},{"containerName":"count_syn_sites","name":"$S","kind":13,"line":1675}]},{"line":1680,"children":[{"localvar":"my","containerName":"get_syn_sites","definition":"my","name":"@nucs","line":1682,"kind":13},{"kind":13,"line":1683,"name":"%raw_results","definition":"my","containerName":"get_syn_sites","localvar":"my"},{"localvar":"my","containerName":"get_syn_sites","definition":"my","name":"$i","line":1684,"kind":13},{"containerName":"get_syn_sites","name":"@nucs","line":1684,"kind":13},{"line":1685,"kind":13,"localvar":"my","definition":"my","name":"$j","containerName":"get_syn_sites"},{"line":1685,"kind":13,"name":"@nucs","containerName":"get_syn_sites"},{"kind":13,"line":1686,"containerName":"get_syn_sites","definition":"my","name":"$k","localvar":"my"},{"name":"@nucs","containerName":"get_syn_sites","line":1686,"kind":13},{"line":1688,"kind":13,"localvar":"my","containerName":"get_syn_sites","name":"$cod","definition":"my"},{"localvar":"my","containerName":"get_syn_sites","definition":"my","name":"$aa","line":1689,"kind":13},{"kind":13,"line":1689,"containerName":"get_syn_sites","name":"$t"},{"line":1689,"kind":13,"containerName":"get_syn_sites","name":"$CODONS"},{"line":1689,"kind":13,"name":"$cod","containerName":"get_syn_sites"},{"kind":13,"line":1691,"containerName":"get_syn_sites","definition":"my","name":"$i","localvar":"my"},{"localvar":"my","definition":"my","name":"$s","containerName":"get_syn_sites","line":1692,"kind":13},{"line":1693,"kind":13,"localvar":"my","name":"$n","definition":"my","containerName":"get_syn_sites"},{"kind":13,"line":1694,"containerName":"get_syn_sites","name":"$nuc","definition":"my","localvar":"my"},{"name":"$cod","containerName":"get_syn_sites","line":1695,"kind":13},{"kind":13,"line":1695,"containerName":"get_syn_sites","name":"$i"},{"line":1695,"kind":13,"name":"$nuc","containerName":"get_syn_sites"},{"name":"$test","definition":"my","containerName":"get_syn_sites","localvar":"my","kind":13,"line":1696},{"name":"$cod","containerName":"get_syn_sites","kind":13,"line":1696},{"line":1697,"kind":13,"containerName":"get_syn_sites","name":"$test"},{"line":1697,"kind":13,"name":"$i","containerName":"get_syn_sites"},{"kind":13,"line":1697,"containerName":"get_syn_sites","name":"$nuc"},{"line":1698,"kind":13,"containerName":"get_syn_sites","name":"$t"},{"name":"$CODONS","containerName":"get_syn_sites","line":1698,"kind":13},{"line":1698,"kind":13,"containerName":"get_syn_sites","name":"$test"},{"line":1698,"kind":13,"name":"$aa","containerName":"get_syn_sites"},{"name":"$s","containerName":"get_syn_sites","line":1699,"kind":13},{"containerName":"get_syn_sites","name":"$t","kind":13,"line":1701},{"kind":13,"line":1701,"name":"$CODONS","containerName":"get_syn_sites"},{"containerName":"get_syn_sites","name":"$test","kind":13,"line":1701},{"name":"$n","containerName":"get_syn_sites","kind":13,"line":1702},{"line":1705,"kind":13,"containerName":"get_syn_sites","name":"$raw_results"},{"containerName":"get_syn_sites","name":"$cod","kind":13,"line":1705},{"line":1705,"kind":13,"name":"$i","containerName":"get_syn_sites"},{"kind":13,"line":1705,"name":"$s","containerName":"get_syn_sites"},{"line":1706,"kind":13,"name":"$n","containerName":"get_syn_sites"},{"localvar":"my","containerName":"get_syn_sites","name":"%final_results","definition":"my","line":1712,"kind":13},{"line":1714,"kind":13,"localvar":"my","name":"$cod","definition":"my","containerName":"get_syn_sites"},{"line":1714,"kind":13,"containerName":"get_syn_sites","name":"%raw_results"},{"line":1715,"kind":13,"localvar":"my","containerName":"get_syn_sites","name":"$t","definition":"my"},{"name":"$t","containerName":"get_syn_sites","kind":13,"line":1716},{"name":"$raw_results","containerName":"get_syn_sites","kind":13,"line":1716},{"kind":13,"line":1716,"name":"$cod","containerName":"get_syn_sites"},{"containerName":"get_syn_sites","name":"$final_results","kind":13,"line":1717},{"name":"$cod","containerName":"get_syn_sites","kind":13,"line":1717},{"kind":13,"line":1717,"containerName":"get_syn_sites","name":"$t"},{"line":1717,"kind":13,"containerName":"get_syn_sites","name":"$t"}],"kind":12,"range":{"end":{"character":9999,"line":1718},"start":{"line":1680,"character":0}},"containerName":"main::","name":"get_syn_sites","definition":"sub"},{"name":"%final_results","containerName":null,"line":1719,"kind":13},{"containerName":"main::","definition":"sub","name":"_make_codons","range":{"end":{"line":1734,"character":9999},"start":{"line":1722,"character":0}},"kind":12,"line":1722,"children":[{"kind":13,"line":1724,"definition":"my","name":"@nucs","containerName":"_make_codons","localvar":"my"},{"line":1725,"kind":13,"localvar":"my","definition":"my","name":"@codons","containerName":"_make_codons"},{"name":"$i","definition":"my","containerName":"_make_codons","localvar":"my","kind":13,"line":1726},{"name":"@nucs","containerName":"_make_codons","line":1726,"kind":13},{"line":1727,"kind":13,"localvar":"my","name":"$j","definition":"my","containerName":"_make_codons"},{"containerName":"_make_codons","name":"@nucs","line":1727,"kind":13},{"line":1728,"kind":13,"localvar":"my","definition":"my","name":"$k","containerName":"_make_codons"},{"line":1728,"kind":13,"containerName":"_make_codons","name":"@nucs"},{"line":1729,"kind":13,"name":"@codons","containerName":"_make_codons"},{"name":"@codons","containerName":"_make_codons","kind":13,"line":1733}]},{"containerName":"main::","name":"get_codons","definition":"sub","range":{"start":{"line":1736,"character":0},"end":{"line":1745,"character":9999}},"kind":12,"line":1736,"children":[{"kind":13,"line":1738,"definition":"my","name":"$x","containerName":"get_codons","localvar":"my"},{"localvar":"my","definition":"my","name":"$CODONS","containerName":"get_codons","line":1739,"kind":13},{"localvar":"my","definition":"my","name":"$codon","containerName":"get_codons","line":1740,"kind":13},{"kind":13,"line":1741,"containerName":"get_codons","name":"$CODONS"},{"containerName":"get_codons","name":"$codon","kind":13,"line":1741},{"kind":13,"line":1741,"containerName":"get_codons","name":"$x"},{"kind":13,"line":1742,"containerName":"get_codons","name":"$x"},{"containerName":"get_codons","name":"$CODONS","kind":13,"line":1744}]},{"range":{"start":{"character":0,"line":1748},"end":{"line":1754,"character":9999}},"definition":"sub","name":"mean","containerName":"main::","children":[{"line":1749,"kind":13,"localvar":"my","definition":"my","name":"$ref","containerName":"mean"},{"kind":13,"line":1750,"containerName":"mean","definition":"my","name":"$el_num","localvar":"my"},{"line":1751,"kind":13,"localvar":"my","containerName":"mean","name":"$tot","definition":"my"},{"line":1752,"kind":13,"name":"$tot","containerName":"mean"},{"kind":13,"line":1753,"containerName":"mean","name":"$tot"},{"line":1753,"kind":13,"name":"$el_num","containerName":"mean"}],"line":1748,"kind":12},{"kind":12,"line":1756,"children":[{"localvar":"my","definition":"my","name":"$ref","containerName":"variance","line":1757,"kind":13},{"localvar":"my","name":"$mean","definition":"my","containerName":"variance","line":1758,"kind":13},{"name":"$ref","containerName":"variance","line":1758,"kind":13},{"name":"$sum_of_squares","definition":"my","containerName":"variance","localvar":"my","kind":13,"line":1759},{"kind":13,"line":1760,"containerName":"variance","name":"$sum_of_squares"},{"name":"$mean","containerName":"variance","line":1760,"kind":13},{"name":"$sum_of_squares","containerName":"variance","kind":13,"line":1761}],"containerName":"main::","definition":"sub","name":"variance","range":{"start":{"character":0,"line":1756},"end":{"line":1762,"character":9999}}},{"children":[{"name":"$ref","definition":"my","containerName":"sampling_variance","localvar":"my","kind":13,"line":1765},{"name":"$ref","containerName":"sampling_variance","kind":13,"line":1766}],"line":1764,"kind":12,"range":{"end":{"character":9999,"line":1767},"start":{"line":1764,"character":0}},"name":"sampling_variance","definition":"sub","containerName":"main::"}]}