{"vars":[{"kind":2,"line":68,"name":"vars","containerName":""},{"name":"strict","kind":12,"line":70},{"containerName":"","name":"base","line":73,"kind":2},{"name":"%valid_type","containerName":null,"line":76,"kind":13},{"name":"_initialize","range":{"start":{"character":0,"line":103},"end":{"line":114,"character":9999}},"kind":12,"line":103,"children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":104},{"name":"@args","containerName":"_initialize","line":104,"kind":13},{"line":105,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"@args","line":105,"kind":13},{"containerName":"_initialize","name":"$show_symbols","definition":"my","localvar":"my","kind":13,"line":106},{"containerName":"_initialize","name":"$endblock","line":106,"kind":13},{"line":107,"kind":13,"containerName":"_initialize","name":"$self"},{"line":107,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"name":"@args","containerName":"_initialize","kind":13,"line":107},{"line":108,"kind":13,"localvar":"my","containerName":"_initialize","name":"@names","definition":"my"},{"containerName":"_initialize","definition":"my","name":"$v","localvar":"my","kind":13,"line":109},{"containerName":"_initialize","name":"$show_symbols","kind":13,"line":109},{"kind":13,"line":109,"name":"$endblock","containerName":"_initialize"},{"kind":13,"line":110,"containerName":"_initialize","name":"$v"},{"kind":13,"line":110,"containerName":"_initialize","name":"$v"},{"line":111,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$n"},{"kind":13,"line":111,"containerName":"_initialize","name":"@names"},{"line":112,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"flag","kind":12,"line":112},{"kind":13,"line":112,"name":"$n","containerName":"_initialize"},{"line":112,"kind":13,"containerName":"_initialize","name":"$v"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] "}},{"containerName":"_initialize","name":"SUPER","line":105,"kind":12},{"name":"next_aln","definition":"sub","containerName":"main::","range":{"end":{"line":293,"character":9999},"start":{"line":142,"character":0}},"kind":12,"children":[{"kind":13,"line":143,"containerName":"next_aln","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":144,"containerName":"next_aln","name":"$entry","definition":"my","localvar":"my"},{"containerName":"next_aln","definition":"my","name":"$aln_name","localvar":"my","kind":13,"line":145},{"kind":13,"line":145,"containerName":"next_aln","name":"$seqcount"},{"name":"$residuecount","containerName":"next_aln","kind":13,"line":145},{"line":145,"kind":13,"containerName":"next_aln","name":"%hash"},{"kind":13,"line":145,"containerName":"next_aln","name":"$alphabet"},{"kind":13,"line":146,"name":"$match","containerName":"next_aln"},{"containerName":"next_aln","name":"$gap","line":146,"kind":13},{"kind":13,"line":146,"name":"$missing","containerName":"next_aln"},{"containerName":"next_aln","name":"$equate","line":146,"kind":13},{"containerName":"next_aln","name":"$interleave","line":146,"kind":13},{"name":"$name","containerName":"next_aln","line":147,"kind":13},{"name":"$str","containerName":"next_aln","line":147,"kind":13},{"line":147,"kind":13,"name":"@names","containerName":"next_aln"},{"line":147,"kind":13,"name":"$seqname","containerName":"next_aln"},{"name":"$start","containerName":"next_aln","line":147,"kind":13},{"containerName":"next_aln","name":"$end","line":147,"kind":13},{"kind":13,"line":147,"containerName":"next_aln","name":"$count"},{"kind":13,"line":147,"containerName":"next_aln","name":"$seq"},{"containerName":"next_aln","name":"$Bio","kind":13,"line":148},{"name":"$Bio","containerName":"next_aln","line":149,"kind":13},{"line":150,"kind":13,"localvar":"my","name":"$aln","definition":"my","containerName":"next_aln"},{"name":"new","containerName":"next_aln","kind":12,"line":150},{"containerName":"next_aln","name":"$entry","kind":13,"line":153},{"line":153,"kind":13,"name":"$self","containerName":"next_aln"},{"containerName":"next_aln","name":"_readline","kind":12,"line":153},{"kind":13,"line":154,"name":"$entry","containerName":"next_aln"},{"name":"$self","containerName":"next_aln","kind":13,"line":154},{"containerName":"next_aln","name":"_readline","line":154,"kind":12},{"kind":13,"line":154,"containerName":"next_aln","name":"$entry"},{"containerName":"next_aln","name":"$entry","kind":13,"line":154},{"name":"$entry","containerName":"next_aln","kind":13,"line":156},{"containerName":"next_aln","name":"$self","line":157,"kind":13},{"containerName":"next_aln","name":"throw","kind":12,"line":157},{"name":"$entry","containerName":"next_aln","line":158,"kind":13},{"name":"$entry","containerName":"next_aln","line":158,"kind":13},{"kind":13,"line":162,"name":"$entry","containerName":"next_aln"},{"containerName":"next_aln","name":"$self","line":162,"kind":13},{"containerName":"next_aln","name":"_readline","kind":12,"line":162},{"line":163,"kind":13,"name":"$entry","containerName":"next_aln"},{"name":"$aln_name","containerName":"next_aln","kind":13,"line":164},{"kind":13,"line":167,"name":"$aln_name","containerName":"next_aln"},{"kind":13,"line":167,"containerName":"next_aln","name":"$aln"},{"name":"id","containerName":"next_aln","kind":12,"line":167},{"line":167,"kind":13,"name":"$aln_name","containerName":"next_aln"},{"name":"$aln_name","containerName":"next_aln","line":167,"kind":13},{"kind":13,"line":170,"containerName":"next_aln","name":"$incomment","definition":"my","localvar":"my"},{"name":"$entry","containerName":"next_aln","line":171,"kind":13},{"kind":13,"line":171,"containerName":"next_aln","name":"$self"},{"name":"_readline","containerName":"next_aln","kind":12,"line":171},{"line":172,"kind":13,"name":"$entry","containerName":"next_aln"},{"containerName":"next_aln","name":"$incomment","kind":13,"line":175},{"containerName":"next_aln","name":"$incomment","line":178,"kind":13},{"name":"$incomment","containerName":"next_aln","kind":13,"line":180},{"kind":13,"line":189,"name":"$seqcount","containerName":"next_aln"},{"name":"$residuecount","containerName":"next_aln","kind":13,"line":190},{"kind":13,"line":191,"containerName":"next_aln","name":"$match"},{"kind":13,"line":192,"name":"$gap","containerName":"next_aln"},{"containerName":"next_aln","name":"$missing","line":193,"kind":13},{"line":194,"kind":13,"name":"$equate","containerName":"next_aln"},{"name":"$alphabet","containerName":"next_aln","kind":13,"line":195},{"name":"$interleave","containerName":"next_aln","kind":13,"line":196},{"name":"$self","containerName":"next_aln","kind":13,"line":200},{"line":200,"kind":12,"name":"throw","containerName":"next_aln"},{"containerName":"next_aln","name":"$alphabet","line":201,"kind":13},{"kind":13,"line":202,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"throw","line":202,"kind":12},{"kind":13,"line":203,"name":"$valid_type","containerName":"next_aln"},{"name":"$alphabet","containerName":"next_aln","kind":13,"line":203},{"containerName":"next_aln","name":"$self","kind":13,"line":204},{"name":"throw","containerName":"next_aln","line":204,"kind":12},{"kind":13,"line":205,"containerName":"next_aln","name":"$gap"},{"containerName":"next_aln","name":"$gap","line":205,"kind":13},{"containerName":"next_aln","name":"$self","kind":13,"line":206},{"name":"throw","containerName":"next_aln","line":206,"kind":12},{"name":"$missing","containerName":"next_aln","kind":13,"line":207},{"kind":13,"line":207,"name":"$missing","containerName":"next_aln"},{"containerName":"next_aln","name":"$aln","line":209,"kind":13},{"name":"gap_char","containerName":"next_aln","kind":12,"line":209},{"containerName":"next_aln","name":"$gap","kind":13,"line":209},{"containerName":"next_aln","name":"$aln","line":210,"kind":13},{"line":210,"kind":12,"containerName":"next_aln","name":"missing_char"},{"containerName":"next_aln","name":"$missing","line":210,"kind":13},{"name":"$entry","containerName":"next_aln","kind":13,"line":216},{"containerName":"next_aln","name":"$self","line":216,"kind":13},{"name":"_readline","containerName":"next_aln","kind":12,"line":216},{"containerName":"next_aln","name":"$entry","line":217,"kind":13},{"containerName":"next_aln","name":"$self","line":218,"kind":13},{"line":218,"kind":12,"containerName":"next_aln","name":"_pushback"},{"line":218,"kind":13,"name":"$entry","containerName":"next_aln"},{"line":227,"kind":13,"containerName":"next_aln","name":"@names"},{"line":228,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":228,"kind":13,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"_readline","kind":12,"line":228},{"containerName":"next_aln","name":"$entry","line":229,"kind":13},{"kind":13,"line":234,"containerName":"next_aln","name":"$interleave"},{"containerName":"next_aln","name":"$count","kind":13,"line":234},{"containerName":"next_aln","name":"$count","line":234,"kind":13},{"containerName":"next_aln","name":"$seqcount","kind":13,"line":234},{"line":245,"kind":13,"containerName":"next_aln","name":"$name"},{"containerName":"next_aln","name":"$str","line":249,"kind":13},{"containerName":"next_aln","name":"$str","kind":13,"line":253},{"line":254,"kind":13,"name":"$self","containerName":"next_aln"},{"containerName":"next_aln","name":"_readline","kind":12,"line":254},{"line":255,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"$str_tmp"},{"containerName":"next_aln","name":"$str_tmp","kind":13,"line":256},{"containerName":"next_aln","name":"$str","kind":13,"line":257},{"name":"$str_tmp","containerName":"next_aln","line":257,"kind":13},{"containerName":"next_aln","name":"$str","line":258,"kind":13},{"line":258,"kind":13,"name":"$residuecount","containerName":"next_aln"},{"line":261,"kind":13,"name":"$name","containerName":"next_aln"},{"containerName":"next_aln","name":"@names","line":262,"kind":13},{"name":"$name","containerName":"next_aln","kind":13,"line":262},{"kind":13,"line":264,"containerName":"next_aln","name":"$str"},{"line":265,"kind":13,"name":"$count","containerName":"next_aln"},{"name":"@names","containerName":"next_aln","kind":13,"line":265},{"kind":13,"line":266,"name":"$hash","containerName":"next_aln"},{"containerName":"next_aln","name":"$count","line":266,"kind":13},{"containerName":"next_aln","name":"$str","kind":13,"line":266},{"kind":13,"line":268,"containerName":"next_aln","name":"$self"},{"line":268,"kind":12,"containerName":"next_aln","name":"throw"},{"kind":13,"line":268,"name":"$count","containerName":"next_aln"},{"name":"$seqcount","containerName":"next_aln","kind":13,"line":268},{"name":"$count","containerName":"next_aln","kind":13,"line":274},{"kind":13,"line":275,"containerName":"next_aln","name":"$interleave"},{"containerName":"next_aln","name":"$entry","kind":13,"line":276},{"name":"$self","containerName":"next_aln","line":276,"kind":13},{"kind":12,"line":276,"containerName":"next_aln","name":"_readline"},{"name":"$entry","containerName":"next_aln","kind":13,"line":277},{"name":"$hash","containerName":"next_aln","line":287,"kind":13},{"name":"$count","containerName":"next_aln","line":287,"kind":13},{"containerName":"next_aln","name":"$str","kind":13,"line":287},{"containerName":"next_aln","name":"$self","line":289,"kind":13},{"containerName":"next_aln","name":"throw","kind":12,"line":289},{"kind":13,"line":290,"containerName":"next_aln","name":"$count"},{"name":"$seqcount","containerName":"next_aln","kind":13,"line":290}],"line":142},{"name":"LocatableSeq","containerName":"OTHER_SYMBOLS","kind":12,"line":148},{"line":149,"kind":12,"name":"LocatableSeq","containerName":"GAP_SYMBOLS"},{"line":150,"kind":12,"name":"Bio","containerName":"SimpleAlign"},{"name":"@names","containerName":null,"kind":13,"line":295},{"line":298,"kind":13,"containerName":null,"name":"$count"},{"kind":13,"line":299,"containerName":null,"name":"$name"},{"name":"@names","containerName":null,"line":299,"kind":13},{"kind":13,"line":300,"name":"$count","containerName":null},{"name":"%name","containerName":null,"kind":13,"line":301},{"name":"$seqname","containerName":null,"line":302,"kind":13},{"name":"$start","containerName":null,"kind":13,"line":303},{"name":"%end","containerName":null,"kind":13,"line":304},{"kind":13,"line":306,"name":"$seqname","containerName":null},{"containerName":null,"name":"$name","line":306,"kind":13},{"name":"$start","containerName":null,"line":307,"kind":13},{"line":308,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"line":308,"name":"%hash","containerName":null},{"kind":13,"line":308,"containerName":null,"name":"$count"},{"name":"$str","containerName":null,"line":309,"kind":13},{"kind":13,"line":310,"containerName":null,"name":"$end"},{"containerName":null,"name":"$str","line":310,"kind":13},{"containerName":null,"name":"$self","line":314,"kind":13},{"line":314,"kind":12,"containerName":"main::","name":"throw"},{"kind":12,"line":314,"containerName":"length","name":"CORE"},{"kind":13,"line":314,"containerName":null,"name":"%hash"},{"containerName":null,"name":"$count","line":314,"kind":13},{"kind":12,"line":315,"name":"CORE","containerName":"length"},{"line":315,"kind":13,"containerName":null,"name":"%hash"},{"containerName":null,"name":"$count","kind":13,"line":315},{"name":"$residuecount","containerName":null,"line":315,"kind":13},{"name":"$seq","containerName":null,"line":317,"kind":13},{"kind":12,"line":317,"containerName":"LocatableSeq","name":"Bio"},{"line":317,"kind":12,"name":"new","containerName":"main::"},{"containerName":null,"name":"%hash","kind":13,"line":317},{"line":317,"kind":13,"containerName":null,"name":"$count"},{"name":"$seqname","containerName":null,"kind":13,"line":318},{"line":319,"kind":13,"containerName":null,"name":"$start"},{"kind":13,"line":320,"name":"$end","containerName":null},{"containerName":null,"name":"$alphabet","kind":13,"line":322},{"kind":13,"line":323,"name":"$aln","containerName":null},{"name":"add_seq","containerName":"main::","line":323,"kind":12},{"line":323,"kind":13,"containerName":null,"name":"$seq"},{"line":327,"kind":13,"name":"$aln","containerName":null},{"name":"unmatch","containerName":"main::","line":327,"kind":12},{"line":327,"kind":13,"containerName":null,"name":"$match"},{"line":327,"kind":13,"containerName":null,"name":"$match"},{"name":"%equate","containerName":null,"kind":13,"line":330},{"name":"$aln","containerName":null,"line":331,"kind":13},{"line":331,"kind":12,"containerName":"main::","name":"map_chars"},{"kind":13,"line":331,"name":"$equate","containerName":null},{"kind":13,"line":334,"name":"$entry","containerName":null},{"containerName":null,"name":"%entry","kind":13,"line":335},{"line":336,"kind":13,"containerName":null,"name":"$entry"},{"line":336,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_readline","kind":12,"line":336},{"line":339,"kind":13,"containerName":null,"name":"$aln"},{"name":"$aln","containerName":null,"line":339,"kind":13},{"line":339,"kind":12,"containerName":"main::","name":"num_sequences"},{"name":"_read_taxlabels","range":{"start":{"character":0,"line":343},"end":{"character":9999,"line":356}},"kind":12,"line":343,"children":[{"line":344,"kind":13,"localvar":"my","containerName":"_read_taxlabels","name":"$self","definition":"my"},{"line":345,"kind":13,"localvar":"my","definition":"my","name":"$name","containerName":"_read_taxlabels"},{"containerName":"_read_taxlabels","name":"@names","kind":13,"line":345},{"line":346,"kind":13,"localvar":"my","containerName":"_read_taxlabels","name":"$entry","definition":"my"},{"name":"$self","containerName":"_read_taxlabels","line":346,"kind":13},{"name":"_readline","containerName":"_read_taxlabels","line":346,"kind":12},{"containerName":"_read_taxlabels","name":"$entry","kind":13,"line":347},{"name":"$entry","containerName":"_read_taxlabels","line":348,"kind":13},{"kind":13,"line":349,"containerName":"_read_taxlabels","name":"$name"},{"name":"$name","containerName":"_read_taxlabels","line":350,"kind":13},{"line":351,"kind":13,"name":"$name","containerName":"_read_taxlabels"},{"name":"@names","containerName":"_read_taxlabels","line":352,"kind":13},{"name":"$name","containerName":"_read_taxlabels","line":352,"kind":13},{"kind":13,"line":355,"containerName":"_read_taxlabels","name":"@names"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_read_taxlabels($self)","documentation":"","parameters":[{"label":"$self"}]}},{"name":"write_aln","range":{"start":{"character":0,"line":371},"end":{"line":454,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@aln)","signature":{"label":"write_aln($self,@aln)","documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] \n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($show_symbols, $endblock) = \n\t$self->_rearrange([qw(SHOW_SYMBOLS SHOW_ENDBLOCK)], @args);\n    my @names = qw(symbols endblock);\n    for my $v ( $show_symbols, $endblock ) {\n\t$v = 1 unless defined $v; # default value is 1\n\tmy $n = shift @names;\n\t$self->flag($n, $v);\n    }\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: Returns the next alignment in the stream.\n\n           Supports the following NEXUS format features:\n           - The file has to start with '#NEXUS'\n           - Reads in the name of the alignment from a comment\n             (anything after 'TITLE: ') .\n           - Sequence names can be given in a taxa block, too.\n           - If matchchar notation is used, converts\n             them back to sequence characters.\n           - Does character conversions specified in the\n             NEXUS equate command.\n           - Sequence names of type 'Homo sapiens' and\n             Homo_sapiens are treated identically.\n\n Returns : L<Bio::Align::AlignI> object\n Args    :\n\n\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($aln_name, $seqcount, $residuecount, %hash, $alphabet,\n\t$match, $gap, $missing, $equate, $interleave,\n\t$name,$str,@names,$seqname,$start,$end,$count,$seq);\n    local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n    local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n    my $aln =  Bio::SimpleAlign->new(-source => 'nexus');\n\n    # file starts with '#NEXUS' but we allow white space only lines before it\n    $entry = $self->_readline;\n    $entry = $self->_readline while defined $entry && $entry =~ /^\\s+$/;\n\n    return unless $entry;\n    $self->throw(\"Not a valid interleaved NEXUS file! [#NEXUS] not starting the file\\n$entry\")\n\tunless ($entry && $entry =~ /^#NEXUS/i);\n\n    # skip anything before either the taxa or data block\n    # but read in the optional title in a comment\n    while (defined($entry = $self->_readline)) {\n\tlocal ($_) = $entry;\n\t/\\[TITLE. *([^\\]]+)]\\s+/i and $aln_name = $1;\n\tlast if /^begin +data/i || /^begin +taxa/i;\n    }\n    $aln_name =~ s/\\s/_/g and $aln->id($aln_name) if $aln_name;\n\n    # data and taxa blocks\n    my $incomment;\n    while (defined ($entry = $self->_readline)) {\n\tlocal ($_) =  $entry;\n\tnext if s/\\[[^\\]]+\\]//g; # remove comments\n\tif( s/\\[[^\\]]+$// ) {\n\t    $incomment = 1;\n\t\t # skip line if it is now empty or contains only whitespace\n\t    next if /^\\s*$/;\n\t} elsif($incomment) {\n\t    if( s/^[^\\]]*\\]// ) {\n\t\t\t $incomment = 0;\n\t    } else {\n\t\t\t next;\n\t    }\n\t} elsif( /taxlabels/i ) {\n\t    # doesn't deal with taxlabels adequately and can mess things up!\n\t    # @names = $self->_read_taxlabels;\n\t} else {\n\n\t    /ntax\\s*=\\s*(\\d+)/i        and $seqcount = $1;\n\t    /nchar\\s*=\\s*(\\d+)/i       and $residuecount = $1;\n\t    /matchchar\\s*=\\s*(.)/i     and $match = $1;\n\t    /gap\\s*=\\s*(.)/i           and $gap = $1;\n\t    /missing\\s*=\\s*(.)/i       and $missing = $1;\n\t    /equate\\s*=\\s*\\\"([^\\\"]+)/i and $equate = $1;  # \"e.g. equate=\"T=C G=A\";\n\t    /datatype\\s*=\\s*(\\w+)/i    and $alphabet = lc $1;\n\t    /interleave/i              and $interleave = 1 ;\n\t    last if /matrix/io;\n\t}\n    }\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype not specified.\")\n\tunless $alphabet;\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype should not be [$alphabet]\")\n\tunless $valid_type{$alphabet};\n    $self->throw(\"\\\"$gap\\\" is not a valid gap character. For compatability, gap char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $gap && $gap =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n    $self->throw(\"\\\"$missing\\\" is not a valid missing character. For compatability, missing char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $missing && $missing =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n\n    $aln->gap_char($gap);\n    $aln->missing_char($missing);\n\n    #\n    # if data is not right after the matrix line\n    #  read the empty lines out\n    #\n    while ($entry = $self->_readline) {\n\tunless ($entry =~ /^\\s+$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n    }\n\n    #\n    # matrix command\n    #\n    # first alignment section\n    if (@names == 0) {\t\t# taxa block did not exist\n\twhile ($entry = $self->_readline) {\n\t\tlocal ($_) =  $entry;\n\t\tif( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\t\tnext if /^\\s*$/; \n\t\t\t# skip line if it is now empty or contains only whitespace\n\t\t}\n\t\tif ($interleave && defined$count && ($count <= $seqcount)) {\n\t\t\t/^\\s+$/ and last;\n\t\t} else {\n\t\t\t/^\\s+$/ and next;\n\t\t}\n\t\t/^\\s*;/ and last;\t# stop if colon at end of matrix is on it's own line\n\t\t#/^\\s*;\\s*$/ and last;\n\t\tif ( /^\\s*([\\\"\\'](.+?)[\\\"\\']|(\\S+))\\s+(.*)\\s*$/ ) {\t\n\t\t\t# get single and double quoted names, or all the first \n         # nonwhite word as the name, and remained is seq\n\t\t\t#if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t\t$name = ($2 || $3);\n\t\t\tif  ($4) {\n\t\t\t\t# seq is on same line as name\n\t\t\t\t# this is the usual NEXUS format\n\t\t\t\t$str = $4;\n\t\t\t} else {\n\t\t\t\t# otherwise get seq from following lines. No comments allowed\n\t\t\t\t# a less common matrix format, usually used for very long seqs\n\t\t\t\t$str='';\n\t\t\t\twhile (local ($_) = $self->_readline) {\n\t\t\t\t\tmy $str_tmp = $_;\n\t\t\t\t\t$str_tmp =~ s/[\\s;]//g;\n\t\t\t\t\t$str .= $str_tmp;\n\t\t\t\t\tlast if length$str == $residuecount;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$name =~ s/ /_/g;\n\t\t\tpush @names, $name;\n\n\t\t\t$str =~ s/[\\s;]//g;\n\t\t\t$count =  @names;\n\t\t\t$hash{$count} = $str;\n\t\t}\n\t\t$self->throw(\"Not a valid interleaved NEXUS file! seqcount [$count] > predeclared [$seqcount] in the first section\") if $count > $seqcount;\n\t\t/;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n}\n\n    # interleaved sections\n    $count = 0;\n    if ( $interleave ) {\t# only read next section if file is interleaved\n\twhile( $entry = $self->_readline) {\n\t    local ($_) =  $entry;\n\t    if( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\tnext if /^\\s*$/; # skip line if it is now empty or contains only whitespace\n\t    }\n\t    /^\\s*;/ and last;\t\t# stop if colon at end of matrix is on it's own line\n\t    $count = 0, next if $entry =~ /^\\s*$/;\n\t    if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t$str = $4;\n\t\t$str =~ s/[\\s;]//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved NEXUS file!\n    \t\tseqcount [$count] > predeclared [$seqcount] \") if $count > $seqcount;\n\t    /;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n    }\n\n    return 0 if @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]//g;\n\t    $end = length($str);\n\t}\n\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount]; got\".CORE::length($hash{$count}))\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n\t$seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t     '-id'=>$seqname,\n\t\t\t\t     '-start'=>$start,\n\t\t\t\t     '-end'=>$end,\n\t\t\t\t     'alphabet'=>$alphabet\n\t\t\t\t     );\n\t$aln->add_seq($seq);\n    }\n\n    # if matchchar is used\n    $aln->unmatch($match) if $match;\n\n    # if equate ( e.g. equate=\"T=C G=A\") is used\n    if ($equate) {\n\t$aln->map_chars($1, $2) while $equate =~ /(\\S)=(\\S)/g;\n    }\n\n    while  (defined $entry &&\n\t    $entry !~ /endblock/i) {\n        $entry = $self->_readline;\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\nsub _read_taxlabels {\n    my ($self) = @_;\n    my ($name, @names);\n    while (my $entry = $self->_readline) {\n\tlast if $entry =~ m/^\\s*(END)?;/i;\n\tif( $entry =~ m/\\s*(\\S+)\\s+/ ) {\n\t    ($name) = ($1);\n\t    $name =~ s/\\[[^\\[]+\\]//g;\n\t    $name =~ s/\\W/_/g;\n\t    push @names, $name;\n\t}\n    }\n    return @names;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: Writes the $aln object into the stream in interleaved NEXUS\n           format. Everything is written into a data block.\n           SimpleAlign methods match_char, missing_char and gap_char must be set\n           if you want to see them in the output.\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}]},"kind":12,"line":371,"children":[{"localvar":"my","containerName":"write_aln","name":"$self","definition":"my","line":372,"kind":13},{"kind":13,"line":372,"name":"@aln","containerName":"write_aln"},{"line":373,"kind":13,"localvar":"my","definition":"my","name":"$count","containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","name":"$wrapped","definition":"my","line":374,"kind":13},{"containerName":"write_aln","name":"$maxname","definition":"my","localvar":"my","kind":13,"line":375},{"line":376,"kind":13,"localvar":"my","definition":"my","name":"$length","containerName":"write_aln"},{"containerName":"write_aln","name":"$date","line":376,"kind":13},{"kind":13,"line":376,"containerName":"write_aln","name":"$name"},{"line":376,"kind":13,"name":"$seq","containerName":"write_aln"},{"line":376,"kind":13,"name":"$miss","containerName":"write_aln"},{"line":376,"kind":13,"name":"$pad","containerName":"write_aln"},{"line":376,"kind":13,"containerName":"write_aln","name":"%hash"},{"name":"@arr","containerName":"write_aln","kind":13,"line":376},{"containerName":"write_aln","name":"$tempcount","line":376,"kind":13},{"containerName":"write_aln","name":"$index","line":376,"kind":13},{"localvar":"my","containerName":"write_aln","name":"$match","definition":"my","line":377,"kind":13},{"name":"$missing","containerName":"write_aln","line":377,"kind":13},{"name":"$gap","containerName":"write_aln","line":377,"kind":13},{"containerName":"write_aln","name":"$symbols","line":377,"kind":13},{"localvar":"my","containerName":"write_aln","name":"$aln","definition":"my","line":379,"kind":13},{"kind":13,"line":379,"name":"@aln","containerName":"write_aln"},{"line":380,"kind":13,"name":"$aln","containerName":"write_aln"},{"line":380,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"isa","line":380,"kind":12},{"containerName":"write_aln","name":"$self","line":381,"kind":13},{"name":"warn","containerName":"write_aln","line":381,"kind":12},{"kind":13,"line":384,"name":"$self","containerName":"write_aln"},{"line":384,"kind":12,"containerName":"write_aln","name":"throw"},{"line":385,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"is_flush","containerName":"write_aln","line":385,"kind":12},{"containerName":"write_aln","name":"$self","line":385,"kind":13},{"containerName":"write_aln","name":"verbose","line":385,"kind":12},{"line":387,"kind":13,"containerName":"write_aln","name":"$length"},{"name":"$aln","containerName":"write_aln","line":387,"kind":13},{"name":"length","containerName":"write_aln","kind":12,"line":387},{"line":389,"kind":13,"name":"$self","containerName":"write_aln"},{"line":389,"kind":12,"name":"_print","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","kind":13,"line":390},{"name":"id","containerName":"write_aln","kind":12,"line":390},{"name":"$aln","containerName":"write_aln","kind":13,"line":390},{"name":"num_sequences","containerName":"write_aln","line":390,"kind":12},{"containerName":"write_aln","name":"$length","line":390,"kind":13},{"kind":13,"line":391,"containerName":"write_aln","name":"$match"},{"line":391,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"match_char","containerName":"write_aln","line":391,"kind":12},{"line":391,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":391,"kind":12,"containerName":"write_aln","name":"match_char"},{"line":392,"kind":13,"name":"$missing","containerName":"write_aln"},{"name":"$aln","containerName":"write_aln","kind":13,"line":392},{"name":"missing_char","containerName":"write_aln","line":392,"kind":12},{"kind":13,"line":392,"containerName":"write_aln","name":"$aln"},{"name":"missing_char","containerName":"write_aln","line":392,"kind":12},{"kind":13,"line":393,"containerName":"write_aln","name":"$gap"},{"line":393,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"gap_char","kind":12,"line":393},{"containerName":"write_aln","name":"$aln","line":393,"kind":13},{"line":393,"kind":12,"name":"gap_char","containerName":"write_aln"},{"containerName":"write_aln","name":"$symbols","kind":13,"line":395},{"name":"$aln","containerName":"write_aln","line":395,"kind":13},{"name":"symbol_chars","containerName":"write_aln","line":395,"kind":12},{"name":"$self","containerName":"write_aln","line":396,"kind":13},{"line":396,"kind":12,"containerName":"write_aln","name":"flag"},{"containerName":"write_aln","name":"$aln","line":396,"kind":13},{"line":396,"kind":12,"name":"symbol_chars","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","line":397,"kind":13},{"containerName":"write_aln","name":"_print","kind":12,"line":397},{"line":399,"kind":13,"name":"$aln","containerName":"write_aln"},{"line":399,"kind":12,"containerName":"write_aln","name":"get_seq_by_pos"},{"containerName":"write_aln","name":"alphabet","line":399,"kind":12},{"kind":13,"line":399,"containerName":"write_aln","name":"$match"},{"containerName":"write_aln","name":"$missing","line":400,"kind":13},{"kind":13,"line":400,"containerName":"write_aln","name":"$gap"},{"containerName":"write_aln","name":"$symbols","line":400,"kind":13},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$indent","line":403,"kind":13},{"line":403,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"maxdisplayname_length","line":403,"kind":12},{"kind":13,"line":405,"containerName":"write_aln","name":"$aln"},{"containerName":"write_aln","name":"set_displayname_flat","line":405,"kind":12},{"line":406,"kind":13,"name":"$seq","containerName":"write_aln"},{"line":406,"kind":13,"name":"$aln","containerName":"write_aln"},{"name":"each_seq","containerName":"write_aln","kind":12,"line":406},{"definition":"my","name":"$nmid","containerName":"write_aln","localvar":"my","kind":13,"line":407},{"containerName":"write_aln","name":"$aln","kind":13,"line":407},{"line":407,"kind":12,"containerName":"write_aln","name":"displayname"},{"kind":13,"line":407,"name":"$seq","containerName":"write_aln"},{"kind":12,"line":407,"name":"get_nse","containerName":"write_aln"},{"line":408,"kind":13,"containerName":"write_aln","name":"$nmid"},{"line":413,"kind":13,"name":"$name","containerName":"write_aln"},{"containerName":"write_aln","name":"$nmid","kind":13,"line":413},{"containerName":"write_aln","name":"$name","line":415,"kind":13},{"line":415,"kind":13,"name":"$nmid","containerName":"write_aln"},{"containerName":"write_aln","name":"$hash","kind":13,"line":417},{"containerName":"write_aln","name":"$name","kind":13,"line":417},{"name":"$seq","containerName":"write_aln","line":417,"kind":13},{"name":"seq","containerName":"write_aln","line":417,"kind":12},{"containerName":"write_aln","name":"@arr","kind":13,"line":418},{"containerName":"write_aln","name":"$name","kind":13,"line":418},{"line":421,"kind":13,"name":"$count","containerName":"write_aln"},{"kind":13,"line":421,"containerName":"write_aln","name":"$length"},{"line":423,"kind":13,"containerName":"write_aln","name":"$name"},{"kind":13,"line":423,"containerName":"write_aln","name":"@arr"},{"kind":13,"line":424,"containerName":"write_aln","name":"$dispname","definition":"my","localvar":"my"},{"name":"$name","containerName":"write_aln","kind":13,"line":424},{"name":"$self","containerName":"write_aln","line":426,"kind":13},{"kind":12,"line":426,"containerName":"write_aln","name":"_print"},{"kind":13,"line":426,"containerName":"write_aln","name":"$dispname"},{"kind":13,"line":427,"containerName":"write_aln","name":"$tempcount"},{"kind":13,"line":427,"containerName":"write_aln","name":"$count"},{"containerName":"write_aln","name":"$index","kind":13,"line":428},{"containerName":"write_aln","name":"$tempcount","line":429,"kind":13},{"kind":13,"line":429,"name":"$length","containerName":"write_aln"},{"containerName":"write_aln","name":"$index","line":429,"kind":13},{"line":430,"kind":13,"containerName":"write_aln","name":"$self"},{"line":430,"kind":12,"name":"_print","containerName":"write_aln"},{"name":"$hash","containerName":"write_aln","line":430,"kind":13},{"containerName":"write_aln","name":"$name","line":430,"kind":13},{"containerName":"write_aln","name":"$tempcount","line":430,"kind":13},{"line":431,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"containerName":"write_aln","name":"$index","kind":13,"line":432},{"line":435,"kind":13,"containerName":"write_aln","name":"$index"},{"kind":13,"line":437,"name":"$self","containerName":"write_aln"},{"line":437,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$hash","containerName":"write_aln","kind":13,"line":437},{"kind":13,"line":437,"name":"$name","containerName":"write_aln"},{"kind":13,"line":437,"name":"$tempcount","containerName":"write_aln"},{"kind":13,"line":438,"containerName":"write_aln","name":"$tempcount"},{"containerName":"write_aln","name":"$self","kind":13,"line":440},{"line":440,"kind":12,"name":"_print","containerName":"write_aln"},{"kind":13,"line":442,"name":"$self","containerName":"write_aln"},{"kind":12,"line":442,"name":"_print","containerName":"write_aln"},{"line":443,"kind":13,"containerName":"write_aln","name":"$count"},{"containerName":"write_aln","name":"$tempcount","kind":13,"line":443},{"containerName":"write_aln","name":"$wrapped","line":444,"kind":13},{"line":446,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"flag","containerName":"write_aln","line":446,"kind":12},{"containerName":"write_aln","name":"$self","kind":13,"line":447},{"kind":12,"line":447,"containerName":"write_aln","name":"_print"},{"containerName":"write_aln","name":"$self","kind":13,"line":449},{"kind":12,"line":449,"containerName":"write_aln","name":"_print"},{"line":452,"kind":13,"containerName":"write_aln","name":"$self"},{"line":452,"kind":12,"name":"flush","containerName":"write_aln"},{"name":"$self","containerName":"write_aln","kind":13,"line":452},{"name":"_flush_on_write","containerName":"write_aln","line":452,"kind":12},{"line":452,"kind":13,"containerName":"write_aln","name":"$self"},{"line":452,"kind":12,"name":"_fh","containerName":"write_aln"}]},{"name":"flag","range":{"end":{"character":9999,"line":471},"start":{"line":467,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] \n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($show_symbols, $endblock) = \n\t$self->_rearrange([qw(SHOW_SYMBOLS SHOW_ENDBLOCK)], @args);\n    my @names = qw(symbols endblock);\n    for my $v ( $show_symbols, $endblock ) {\n\t$v = 1 unless defined $v; # default value is 1\n\tmy $n = shift @names;\n\t$self->flag($n, $v);\n    }\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: Returns the next alignment in the stream.\n\n           Supports the following NEXUS format features:\n           - The file has to start with '#NEXUS'\n           - Reads in the name of the alignment from a comment\n             (anything after 'TITLE: ') .\n           - Sequence names can be given in a taxa block, too.\n           - If matchchar notation is used, converts\n             them back to sequence characters.\n           - Does character conversions specified in the\n             NEXUS equate command.\n           - Sequence names of type 'Homo sapiens' and\n             Homo_sapiens are treated identically.\n\n Returns : L<Bio::Align::AlignI> object\n Args    :\n\n\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($aln_name, $seqcount, $residuecount, %hash, $alphabet,\n\t$match, $gap, $missing, $equate, $interleave,\n\t$name,$str,@names,$seqname,$start,$end,$count,$seq);\n    local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n    local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n    my $aln =  Bio::SimpleAlign->new(-source => 'nexus');\n\n    # file starts with '#NEXUS' but we allow white space only lines before it\n    $entry = $self->_readline;\n    $entry = $self->_readline while defined $entry && $entry =~ /^\\s+$/;\n\n    return unless $entry;\n    $self->throw(\"Not a valid interleaved NEXUS file! [#NEXUS] not starting the file\\n$entry\")\n\tunless ($entry && $entry =~ /^#NEXUS/i);\n\n    # skip anything before either the taxa or data block\n    # but read in the optional title in a comment\n    while (defined($entry = $self->_readline)) {\n\tlocal ($_) = $entry;\n\t/\\[TITLE. *([^\\]]+)]\\s+/i and $aln_name = $1;\n\tlast if /^begin +data/i || /^begin +taxa/i;\n    }\n    $aln_name =~ s/\\s/_/g and $aln->id($aln_name) if $aln_name;\n\n    # data and taxa blocks\n    my $incomment;\n    while (defined ($entry = $self->_readline)) {\n\tlocal ($_) =  $entry;\n\tnext if s/\\[[^\\]]+\\]//g; # remove comments\n\tif( s/\\[[^\\]]+$// ) {\n\t    $incomment = 1;\n\t\t # skip line if it is now empty or contains only whitespace\n\t    next if /^\\s*$/;\n\t} elsif($incomment) {\n\t    if( s/^[^\\]]*\\]// ) {\n\t\t\t $incomment = 0;\n\t    } else {\n\t\t\t next;\n\t    }\n\t} elsif( /taxlabels/i ) {\n\t    # doesn't deal with taxlabels adequately and can mess things up!\n\t    # @names = $self->_read_taxlabels;\n\t} else {\n\n\t    /ntax\\s*=\\s*(\\d+)/i        and $seqcount = $1;\n\t    /nchar\\s*=\\s*(\\d+)/i       and $residuecount = $1;\n\t    /matchchar\\s*=\\s*(.)/i     and $match = $1;\n\t    /gap\\s*=\\s*(.)/i           and $gap = $1;\n\t    /missing\\s*=\\s*(.)/i       and $missing = $1;\n\t    /equate\\s*=\\s*\\\"([^\\\"]+)/i and $equate = $1;  # \"e.g. equate=\"T=C G=A\";\n\t    /datatype\\s*=\\s*(\\w+)/i    and $alphabet = lc $1;\n\t    /interleave/i              and $interleave = 1 ;\n\t    last if /matrix/io;\n\t}\n    }\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype not specified.\")\n\tunless $alphabet;\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype should not be [$alphabet]\")\n\tunless $valid_type{$alphabet};\n    $self->throw(\"\\\"$gap\\\" is not a valid gap character. For compatability, gap char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $gap && $gap =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n    $self->throw(\"\\\"$missing\\\" is not a valid missing character. For compatability, missing char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $missing && $missing =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n\n    $aln->gap_char($gap);\n    $aln->missing_char($missing);\n\n    #\n    # if data is not right after the matrix line\n    #  read the empty lines out\n    #\n    while ($entry = $self->_readline) {\n\tunless ($entry =~ /^\\s+$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n    }\n\n    #\n    # matrix command\n    #\n    # first alignment section\n    if (@names == 0) {\t\t# taxa block did not exist\n\twhile ($entry = $self->_readline) {\n\t\tlocal ($_) =  $entry;\n\t\tif( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\t\tnext if /^\\s*$/; \n\t\t\t# skip line if it is now empty or contains only whitespace\n\t\t}\n\t\tif ($interleave && defined$count && ($count <= $seqcount)) {\n\t\t\t/^\\s+$/ and last;\n\t\t} else {\n\t\t\t/^\\s+$/ and next;\n\t\t}\n\t\t/^\\s*;/ and last;\t# stop if colon at end of matrix is on it's own line\n\t\t#/^\\s*;\\s*$/ and last;\n\t\tif ( /^\\s*([\\\"\\'](.+?)[\\\"\\']|(\\S+))\\s+(.*)\\s*$/ ) {\t\n\t\t\t# get single and double quoted names, or all the first \n         # nonwhite word as the name, and remained is seq\n\t\t\t#if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t\t$name = ($2 || $3);\n\t\t\tif  ($4) {\n\t\t\t\t# seq is on same line as name\n\t\t\t\t# this is the usual NEXUS format\n\t\t\t\t$str = $4;\n\t\t\t} else {\n\t\t\t\t# otherwise get seq from following lines. No comments allowed\n\t\t\t\t# a less common matrix format, usually used for very long seqs\n\t\t\t\t$str='';\n\t\t\t\twhile (local ($_) = $self->_readline) {\n\t\t\t\t\tmy $str_tmp = $_;\n\t\t\t\t\t$str_tmp =~ s/[\\s;]//g;\n\t\t\t\t\t$str .= $str_tmp;\n\t\t\t\t\tlast if length$str == $residuecount;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$name =~ s/ /_/g;\n\t\t\tpush @names, $name;\n\n\t\t\t$str =~ s/[\\s;]//g;\n\t\t\t$count =  @names;\n\t\t\t$hash{$count} = $str;\n\t\t}\n\t\t$self->throw(\"Not a valid interleaved NEXUS file! seqcount [$count] > predeclared [$seqcount] in the first section\") if $count > $seqcount;\n\t\t/;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n}\n\n    # interleaved sections\n    $count = 0;\n    if ( $interleave ) {\t# only read next section if file is interleaved\n\twhile( $entry = $self->_readline) {\n\t    local ($_) =  $entry;\n\t    if( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\tnext if /^\\s*$/; # skip line if it is now empty or contains only whitespace\n\t    }\n\t    /^\\s*;/ and last;\t\t# stop if colon at end of matrix is on it's own line\n\t    $count = 0, next if $entry =~ /^\\s*$/;\n\t    if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t$str = $4;\n\t\t$str =~ s/[\\s;]//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved NEXUS file!\n    \t\tseqcount [$count] > predeclared [$seqcount] \") if $count > $seqcount;\n\t    /;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n    }\n\n    return 0 if @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]//g;\n\t    $end = length($str);\n\t}\n\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount]; got\".CORE::length($hash{$count}))\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n\t$seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t     '-id'=>$seqname,\n\t\t\t\t     '-start'=>$start,\n\t\t\t\t     '-end'=>$end,\n\t\t\t\t     'alphabet'=>$alphabet\n\t\t\t\t     );\n\t$aln->add_seq($seq);\n    }\n\n    # if matchchar is used\n    $aln->unmatch($match) if $match;\n\n    # if equate ( e.g. equate=\"T=C G=A\") is used\n    if ($equate) {\n\t$aln->map_chars($1, $2) while $equate =~ /(\\S)=(\\S)/g;\n    }\n\n    while  (defined $entry &&\n\t    $entry !~ /endblock/i) {\n        $entry = $self->_readline;\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\nsub _read_taxlabels {\n    my ($self) = @_;\n    my ($name, @names);\n    while (my $entry = $self->_readline) {\n\tlast if $entry =~ m/^\\s*(END)?;/i;\n\tif( $entry =~ m/\\s*(\\S+)\\s+/ ) {\n\t    ($name) = ($1);\n\t    $name =~ s/\\[[^\\[]+\\]//g;\n\t    $name =~ s/\\W/_/g;\n\t    push @names, $name;\n\t}\n    }\n    return @names;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: Writes the $aln object into the stream in interleaved NEXUS\n           format. Everything is written into a data block.\n           SimpleAlign methods match_char, missing_char and gap_char must be set\n           if you want to see them in the output.\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my ($length,$date,$name,$seq,$miss,$pad,%hash,@arr,$tempcount,$index );\n    my ($match, $missing, $gap,$symbols) = ('', '', '','');\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush($self->verbose);\n\n\t$length  = $aln->length();\n\n\t$self->_print (sprintf(\"#NEXUS\\n[TITLE: %s]\\n\\nbegin data;\\ndimensions ntax=%s nchar=%s;\\n\",\n\t\t\t       $aln->id, $aln->num_sequences, $length));\n\t$match = \"match=\". $aln->match_char if $aln->match_char;\n\t$missing = \"missing=\". $aln->missing_char if $aln->missing_char;\n\t$gap = \"gap=\". $aln->gap_char if $aln->gap_char;\n\n\t$symbols = 'symbols=\"'.join('',$aln->symbol_chars). '\"' \n\t    if( $self->flag('symbols') && $aln->symbol_chars);\n\t$self->_print \n\t    (sprintf(\"format interleave datatype=%s %s %s %s %s;\\n\\nmatrix\\n\",\n\t\t     $aln->get_seq_by_pos(1)->alphabet, $match, \n\t\t     $missing, $gap, $symbols));\n\n                     # account for single quotes round names\n\tmy $indent = $aln->maxdisplayname_length+2;\n\n\t$aln->set_displayname_flat();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    my $nmid = $aln->displayname($seq->get_nse());\n\t    if( $nmid =~ /[^\\w\\d\\.]/ ) {\n              # put name in single quotes incase it contains any of\n              # the following chars: ()[]{}/\\,;:=*'\"`+-<> that are not\n              # allowed in PAUP* and possible other software\n\n\t\t$name = sprintf(\"%-${indent}s\", \"\\'\" . $nmid . \"\\'\");\n\t    } else { \n\t\t$name = sprintf(\"%-${indent}s\", $nmid);\n\t    }\n\t    $hash{$name} = $seq->seq;\n\t    push(@arr,$name);\n\t}\n\n\twhile( $count < $length ) {\n\t    # there is another block to go!\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n#\t\t $dispname = '' if $wrapped;\n\t\t$self->_print (sprintf(\"%${indent}s  \",$dispname));\n\t\t$tempcount = $count;\n\t\t$index = 0;\n\t\twhile( ($tempcount + 10 < $length) && ($index < 5)  ) {\n\t\t    $self->_print (sprintf(\"%s \",substr($hash{$name},$tempcount,10)));\n\t\t    $tempcount += 10;\n\t\t    $index++;\n\t\t}\n\t\t# last\n\t\tif( $index < 5) {\n\t\t    # space to print!\n\t\t    $self->_print (sprintf(\"%s \",substr($hash{$name},$tempcount)));\n\t\t    $tempcount += 10;\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t    }\n\t    $self->_print (\"\\n\\n\");\n\t    $count = $tempcount;\n\t    $wrapped = 1;\n\t}\n\tif( $self->flag('endblock') ) {\n\t    $self->_print (\";\\n\\nendblock;\\n\");\n\t} else { \n\t    $self->_print (\";\\n\\nend;\\n\");\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($name,$value)\n Function: Get/Set a flag value\n Returns : value of flag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"label":"flag($self,$name,$val)"},"detail":"($self,$name,$val)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"flag","line":468,"kind":13},{"name":"$name","containerName":"flag","kind":13,"line":468},{"kind":13,"line":468,"name":"$val","containerName":"flag"},{"line":469,"kind":13,"name":"$self","containerName":"flag"},{"line":469,"kind":13,"name":"$name","containerName":"flag"},{"containerName":"flag","name":"$val","line":469,"kind":13},{"kind":13,"line":469,"containerName":"flag","name":"$val"},{"line":470,"kind":13,"containerName":"flag","name":"$self"},{"kind":13,"line":470,"name":"$name","containerName":"flag"}],"line":467}],"version":5}