{"version":5,"vars":[{"kind":2,"line":80,"containerName":"","name":"base"},{"name":"next_aln","definition":"sub","containerName":"main::","range":{"start":{"line":95,"character":0},"end":{"character":9999,"line":147}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":96},{"line":97,"kind":13,"localvar":"my","containerName":"next_aln","name":"$entry","definition":"my"},{"localvar":"my","definition":"my","name":"$start","containerName":"next_aln","line":98,"kind":13},{"line":98,"kind":13,"containerName":"next_aln","name":"$end"},{"line":98,"kind":13,"containerName":"next_aln","name":"%align"},{"name":"$name","containerName":"next_aln","kind":13,"line":98},{"line":98,"kind":13,"name":"$seqname","containerName":"next_aln"},{"kind":13,"line":98,"containerName":"next_aln","name":"%hash"},{"name":"@c2name","containerName":"next_aln","line":98,"kind":13},{"kind":13,"line":98,"containerName":"next_aln","name":"%accession"},{"containerName":"next_aln","name":"%desc","line":98,"kind":13},{"kind":13,"line":99,"containerName":"next_aln","name":"$aln","definition":"my","localvar":"my"},{"kind":12,"line":99,"name":"new","containerName":"next_aln"},{"kind":13,"line":105,"name":"$entry","containerName":"next_aln"},{"line":105,"kind":13,"containerName":"next_aln","name":"$self"},{"kind":12,"line":105,"name":"_readline","containerName":"next_aln"},{"containerName":"next_aln","name":"$entry","kind":13,"line":106},{"kind":13,"line":107,"name":"$accession","containerName":"next_aln"},{"line":109,"kind":13,"name":"$entry","containerName":"next_aln"},{"name":"$desc","containerName":"next_aln","line":110,"kind":13},{"name":"$entry","containerName":"next_aln","kind":13,"line":111},{"localvar":"my","name":"$name","definition":"my","containerName":"next_aln","line":112,"kind":13},{"line":112,"kind":13,"name":"$seq","containerName":"next_aln"},{"kind":13,"line":114,"containerName":"next_aln","name":"$align"},{"containerName":"next_aln","name":"$name","line":114,"kind":13},{"name":"@c2name","containerName":"next_aln","line":115,"kind":13},{"name":"$name","containerName":"next_aln","kind":13,"line":115},{"name":"$align","containerName":"next_aln","kind":13,"line":117},{"line":117,"kind":13,"name":"$name","containerName":"next_aln"},{"name":"$seq","containerName":"next_aln","kind":13,"line":117},{"kind":13,"line":122,"containerName":"next_aln","definition":"my","name":"$name","localvar":"my"},{"containerName":"next_aln","name":"@c2name","line":122,"kind":13},{"name":"$name","containerName":"next_aln","kind":13,"line":124},{"name":"$seqname","containerName":"next_aln","kind":13,"line":125},{"containerName":"next_aln","name":"$start","line":126,"kind":13},{"containerName":"next_aln","name":"$end","kind":13,"line":127},{"kind":13,"line":129,"containerName":"next_aln","name":"$seqname"},{"containerName":"next_aln","name":"$name","kind":13,"line":129},{"line":130,"kind":13,"name":"$start","containerName":"next_aln"},{"line":131,"kind":13,"containerName":"next_aln","name":"$end"},{"containerName":"next_aln","name":"$align","kind":13,"line":131},{"name":"$name","containerName":"next_aln","line":131,"kind":13},{"kind":13,"line":133,"containerName":"next_aln","name":"$seq","definition":"my","localvar":"my"},{"kind":12,"line":134,"containerName":"next_aln","name":"new"},{"containerName":"next_aln","name":"$align","kind":13,"line":134},{"line":134,"kind":13,"containerName":"next_aln","name":"$name"},{"name":"$seqname","containerName":"next_aln","kind":13,"line":135},{"kind":13,"line":136,"containerName":"next_aln","name":"$start"},{"name":"$end","containerName":"next_aln","line":137,"kind":13},{"name":"$desc","containerName":"next_aln","line":138,"kind":13},{"kind":13,"line":138,"name":"$name","containerName":"next_aln"},{"line":139,"kind":13,"name":"$accession","containerName":"next_aln"},{"kind":13,"line":139,"containerName":"next_aln","name":"$name"},{"line":142,"kind":13,"name":"$aln","containerName":"next_aln"},{"kind":12,"line":142,"name":"add_seq","containerName":"next_aln"},{"kind":13,"line":142,"name":"$seq","containerName":"next_aln"},{"line":145,"kind":13,"name":"$aln","containerName":"next_aln"},{"name":"$aln","containerName":"next_aln","line":145,"kind":13},{"name":"num_sequences","containerName":"next_aln","line":145,"kind":12}],"line":95},{"containerName":"SimpleAlign","name":"Bio","kind":12,"line":99},{"name":"Bio","containerName":"LocatableSeq","line":133,"kind":12},{"kind":12,"line":161,"children":[{"localvar":"my","containerName":"write_aln","definition":"my","name":"$self","line":162,"kind":13},{"kind":13,"line":162,"name":"@aln","containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","name":"$namestr","definition":"my","line":163,"kind":13},{"kind":13,"line":163,"name":"$seq","containerName":"write_aln"},{"name":"$add","containerName":"write_aln","line":163,"kind":13},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$maxn","line":164,"kind":13},{"kind":13,"line":165,"name":"$aln","definition":"my","containerName":"write_aln","localvar":"my"},{"name":"@aln","containerName":"write_aln","kind":13,"line":165},{"containerName":"write_aln","name":"$maxn","line":166,"kind":13},{"name":"$aln","containerName":"write_aln","kind":13,"line":166},{"containerName":"write_aln","name":"maxdisplayname_length","line":166,"kind":12},{"containerName":"write_aln","name":"$seq","kind":13,"line":167},{"line":167,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"each_seq","line":167,"kind":12},{"line":168,"kind":13,"name":"$namestr","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","line":168,"kind":13},{"line":168,"kind":12,"name":"displayname","containerName":"write_aln"},{"containerName":"write_aln","name":"$seq","line":168,"kind":13},{"line":168,"kind":12,"name":"get_nse","containerName":"write_aln"},{"kind":13,"line":169,"containerName":"write_aln","name":"$add"},{"line":169,"kind":13,"containerName":"write_aln","name":"$maxn"},{"line":169,"kind":13,"name":"$namestr","containerName":"write_aln"},{"name":"$namestr","containerName":"write_aln","line":170,"kind":13},{"containerName":"write_aln","name":"$add","line":170,"kind":13},{"containerName":"write_aln","name":"$self","line":171,"kind":13},{"line":171,"kind":12,"name":"_print","containerName":"write_aln"},{"containerName":"write_aln","name":"$namestr","kind":13,"line":171},{"containerName":"write_aln","name":"$seq","line":171,"kind":13},{"containerName":"write_aln","name":"seq","kind":12,"line":171},{"containerName":"write_aln","name":"$self","line":174,"kind":13},{"name":"flush","containerName":"write_aln","line":174,"kind":12},{"kind":13,"line":174,"name":"$self","containerName":"write_aln"},{"name":"_flush_on_write","containerName":"write_aln","kind":12,"line":174},{"containerName":"write_aln","name":"$self","line":174,"kind":13},{"kind":12,"line":174,"name":"_fh","containerName":"write_aln"}],"containerName":"main::","definition":"sub","detail":"($self,@aln)","signature":{"documentation":"1;\n# $Id: selex.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::selex\n\n#   based on the Bio::SeqIO::selex module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::selex - selex sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'selex',\n                             -file   => 't/data/testaln.selex');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from selex flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::selex;\nuse strict;\n\nuse base qw(Bio::AlignIO);\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream. Tries to read *all* selex\n          It reads all non whitespace characters in the alignment\n          area. For selexs with weird gaps (eg ~~~) map them by using\n          $al->map_chars('~','-')\n Returns : L<Bio::Align::AlignI> object\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($start,$end,%align,$name,$seqname,%hash,@c2name, %accession,%desc);\n    my $aln =  Bio::SimpleAlign->new(-source => 'selex');\n\n    # in selex format, every non-blank line that does not start\n    # with '#=' is an alignment segment; the '#=' lines are mark up lines.\n    # Of particular interest are the '#=GF <name/st-ed> AC <accession>'\n    # lines, which give accession numbers for each segment\n    while( $entry = $self->_readline) {\n        if( $entry =~ /^\\#=GS\\s+(\\S+)\\s+AC\\s+(\\S+)/ ) {\n\t    $accession{ $1 } = $2;\n\t    next;\n\t} elsif( $entry =~ /^\\#=GS\\s+(\\S+)\\s+DE\\s+(.+)\\s*$/ ) {\n\t    $desc{$1} .= $2;\n\t} elsif ( $entry =~ /^([^\\#]\\S+)\\s+([A-Za-z\\.\\-\\*]+)\\s*/ ) {\n\t    my ($name,$seq) = ($1,$2);\n\n\t    if( ! defined $align{$name}  ) {\n\t\tpush @c2name, $name;\n\t    }\n\t    $align{$name} .= $seq;\n\t}\n    }\n    # ok... now we can make the sequences\n\n    foreach my $name ( @c2name ) {\n\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $end = length($align{$name});\n\t}\n\tmy $seq = Bio::LocatableSeq->new\n\t    ('-seq'              => $align{$name},\n\t     '-display_id'       => $seqname,\n\t     '-start'            => $start,\n\t     '-end'              => $end,\n\t     '-description'      => $desc{$name},\n\t     '-accession_number' => $accession{$name},\n\t     );\n\n\t$aln->add_seq($seq);\n    }\n\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in selex format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"},"name":"write_aln","range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":161}}}]}