{"vars":[{"line":81,"kind":2,"name":"base","containerName":""},{"range":{"start":{"character":0,"line":100},"end":{"line":127,"character":9999}},"name":"new","line":100,"children":[{"line":101,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","name":"@args","kind":13,"line":101},{"line":102,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":102},{"name":"@args","containerName":"new","line":102,"kind":13},{"kind":13,"line":103,"name":"$id","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$src","line":103,"kind":13},{"kind":13,"line":103,"containerName":"new","name":"$contigs"},{"line":103,"kind":13,"name":"$singlets","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":103},{"line":103,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","line":104,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":107},{"line":108,"kind":13,"containerName":"new","name":"$self"},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":110,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":111},{"name":"$self","containerName":"new","line":112,"kind":13},{"containerName":"new","name":"new","line":112,"kind":12},{"containerName":"new","name":"$self","kind":13,"line":115},{"line":115,"kind":13,"name":"$id","containerName":"new"},{"containerName":"new","name":"$id","line":115,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":116},{"containerName":"new","name":"$src","line":116,"kind":13},{"containerName":"new","name":"$src","kind":13,"line":116},{"line":119,"kind":13,"name":"$contigs","containerName":"new"},{"line":119,"kind":13,"containerName":"new","name":"$contigs"},{"line":120,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$contig"},{"containerName":"new","name":"$contigs","kind":13,"line":120},{"name":"$contig","containerName":"new","kind":13,"line":121},{"containerName":"new","name":"$contig","kind":13,"line":121},{"kind":12,"line":121,"containerName":"new","name":"isa"},{"kind":13,"line":122,"containerName":"new","name":"$self"},{"line":122,"kind":12,"containerName":"new","name":"throw"},{"containerName":"new","name":"$contig","line":123,"kind":13},{"line":125,"kind":13,"name":"$self","containerName":"new"},{"line":125,"kind":12,"containerName":"new","name":"add_contig"},{"line":125,"kind":13,"name":"$contig","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","line":102,"kind":12},{"name":"Bio","containerName":"Annotation::Collection","kind":12,"line":112},{"containerName":null,"name":"$singlets","line":128,"kind":13},{"containerName":null,"name":"%singlets","line":128,"kind":13},{"kind":13,"line":129,"containerName":null,"name":"$singlet","definition":"my","localvar":"my"},{"containerName":null,"name":"%singlets","line":129,"kind":13},{"containerName":null,"name":"$singlet","kind":13,"line":130},{"line":130,"kind":13,"name":"$singlet","containerName":null},{"containerName":"main::","name":"isa","kind":12,"line":130},{"line":131,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","line":131,"kind":12},{"name":"$singlet","containerName":null,"kind":13,"line":132},{"kind":13,"line":134,"name":"$self","containerName":null},{"containerName":"main::","name":"add_singlet","line":134,"kind":12},{"kind":13,"line":134,"containerName":null,"name":"$singlet"},{"line":138,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"children":[{"kind":13,"line":156,"containerName":"id","definition":"my","name":"$self","localvar":"my"},{"line":156,"kind":13,"name":"$id","containerName":"id"},{"line":157,"kind":13,"name":"$self","containerName":"id"},{"kind":13,"line":157,"containerName":"id","name":"$id"},{"kind":13,"line":157,"containerName":"id","name":"$id"},{"name":"$self","containerName":"id","line":158,"kind":13}],"line":155,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string","label":"id($self,$id)"},"detail":"($self,$id)","name":"id","range":{"end":{"line":159,"character":9999},"start":{"line":155,"character":0}}},{"containerName":"main::","definition":"sub","name":"annotation","range":{"start":{"character":0,"line":171},"end":{"line":175,"character":9999}},"kind":12,"line":171,"children":[{"line":172,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"annotation"},{"line":172,"kind":13,"name":"$ref","containerName":"annotation"},{"containerName":"annotation","name":"$self","line":173,"kind":13},{"containerName":"annotation","name":"$ref","kind":13,"line":173},{"kind":13,"line":173,"containerName":"annotation","name":"$ref"},{"kind":13,"line":174,"containerName":"annotation","name":"$self"}]},{"children":[{"line":188,"kind":13,"localvar":"my","containerName":"get_nof_contigs","definition":"my","name":"$self"},{"containerName":"get_nof_contigs","name":"$self","line":189,"kind":13},{"containerName":"get_nof_contigs","name":"get_contig_ids","line":189,"kind":12}],"line":187,"kind":12,"range":{"end":{"character":9999,"line":190},"start":{"line":187,"character":0}},"definition":"sub","name":"get_nof_contigs","containerName":"main::"},{"range":{"end":{"line":212,"character":9999},"start":{"character":0,"line":203}},"definition":"sub","name":"get_nof_contig_seqs","containerName":"main::","children":[{"kind":13,"line":204,"containerName":"get_nof_contig_seqs","name":"$self","definition":"my","localvar":"my"},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"$nof_seqs","containerName":"get_nof_contig_seqs"},{"kind":13,"line":207,"name":"$contig","definition":"my","containerName":"get_nof_contig_seqs","localvar":"my"},{"line":207,"kind":13,"containerName":"get_nof_contig_seqs","name":"$self"},{"containerName":"get_nof_contig_seqs","name":"all_contigs","kind":12,"line":207},{"name":"$nof_seqs","containerName":"get_nof_contig_seqs","kind":13,"line":208},{"line":208,"kind":13,"containerName":"get_nof_contig_seqs","name":"$contig"},{"kind":12,"line":208,"name":"get_seq_ids","containerName":"get_nof_contig_seqs"},{"kind":13,"line":211,"name":"$nof_seqs","containerName":"get_nof_contig_seqs"}],"line":203,"kind":12},{"range":{"end":{"character":9999,"line":230},"start":{"character":0,"line":227}},"definition":"sub","name":"get_nof_singlets","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_nof_singlets","line":228,"kind":13},{"line":229,"kind":13,"containerName":"get_nof_singlets","name":"$self"},{"name":"get_singlet_ids","containerName":"get_nof_singlets","line":229,"kind":12}],"line":227,"kind":12},{"containerName":"main::","definition":"sub","name":"get_all_seq_ids","range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":246}},"kind":12,"line":244,"children":[{"name":"$self","definition":"my","containerName":"get_all_seq_ids","localvar":"my","kind":13,"line":245},{"kind":13,"line":246,"name":"$self","containerName":"get_all_seq_ids"}]},{"name":"get_nof_seqs","definition":"sub","containerName":"main::","range":{"end":{"line":263,"character":9999},"start":{"line":260,"character":0}},"kind":12,"children":[{"containerName":"get_nof_seqs","name":"$self","definition":"my","localvar":"my","kind":13,"line":261},{"name":"$self","containerName":"get_nof_seqs","kind":13,"line":262},{"kind":12,"line":262,"containerName":"get_nof_seqs","name":"get_all_seq_ids"}],"line":260},{"range":{"end":{"character":9999,"line":282},"start":{"character":0,"line":275}},"containerName":"main::","definition":"sub","name":"get_contig_seq_ids","line":275,"children":[{"localvar":"my","containerName":"get_contig_seq_ids","definition":"my","name":"$self","line":276,"kind":13},{"line":277,"kind":13,"localvar":"my","containerName":"get_contig_seq_ids","definition":"my","name":"@ids"},{"localvar":"my","name":"$contig","definition":"my","containerName":"get_contig_seq_ids","line":278,"kind":13},{"name":"$self","containerName":"get_contig_seq_ids","kind":13,"line":278},{"containerName":"get_contig_seq_ids","name":"all_contigs","kind":12,"line":278},{"line":279,"kind":13,"name":"@ids","containerName":"get_contig_seq_ids"},{"line":279,"kind":13,"containerName":"get_contig_seq_ids","name":"$contig"},{"containerName":"get_contig_seq_ids","name":"get_seq_ids","kind":12,"line":279},{"name":"@ids","containerName":"get_contig_seq_ids","line":281,"kind":13}],"kind":12},{"range":{"end":{"line":301,"character":9999},"start":{"character":0,"line":297}},"containerName":"main::","definition":"sub","name":"get_contig_ids","line":297,"children":[{"line":298,"kind":13,"localvar":"my","containerName":"get_contig_ids","name":"$self","definition":"my"},{"containerName":"get_contig_ids","name":"$self","line":301,"kind":13}],"kind":12},{"line":302,"kind":13,"containerName":null,"name":"%self"},{"range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":320}},"containerName":"main::","definition":"sub","name":"get_singlet_ids","line":316,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_singlet_ids","line":317,"kind":13},{"line":320,"kind":13,"containerName":"get_singlet_ids","name":"$self"}],"kind":12},{"kind":13,"line":321,"name":"%self","containerName":null},{"kind":12,"line":337,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_seq_by_id","line":338,"kind":13},{"name":"$seqID","definition":"my","containerName":"get_seq_by_id","localvar":"my","kind":13,"line":339},{"containerName":"get_seq_by_id","name":"$self","line":341,"kind":13},{"containerName":"get_seq_by_id","name":"$seqID","line":341,"kind":13},{"containerName":"get_seq_by_id","name":"$self","line":343,"kind":13},{"containerName":"get_seq_by_id","name":"$seqID","kind":13,"line":343},{"line":343,"kind":12,"containerName":"get_seq_by_id","name":"get_seq_by_name"},{"name":"$seqID","containerName":"get_seq_by_id","kind":13,"line":343}],"containerName":"main::","definition":"sub","name":"get_seq_by_id","range":{"end":{"line":344,"character":9999},"start":{"line":337,"character":0}}},{"children":[{"localvar":"my","containerName":"get_contig_by_id","name":"$self","definition":"my","line":357,"kind":13},{"kind":13,"line":358,"name":"$contigID","definition":"my","containerName":"get_contig_by_id","localvar":"my"},{"name":"$self","containerName":"get_contig_by_id","kind":13,"line":360},{"containerName":"get_contig_by_id","name":"$contigID","line":360,"kind":13},{"containerName":"get_contig_by_id","name":"$self","kind":13,"line":362},{"line":362,"kind":13,"name":"$contigID","containerName":"get_contig_by_id"}],"line":356,"kind":12,"range":{"end":{"line":363,"character":9999},"start":{"character":0,"line":356}},"definition":"sub","name":"get_contig_by_id","containerName":"main::"},{"line":375,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_singlet_by_id","line":376,"kind":13},{"localvar":"my","containerName":"get_singlet_by_id","definition":"my","name":"$singletID","line":378,"kind":13},{"containerName":"get_singlet_by_id","name":"$self","kind":13,"line":380},{"name":"$singletID","containerName":"get_singlet_by_id","kind":13,"line":380},{"kind":13,"line":382,"name":"$self","containerName":"get_singlet_by_id"},{"line":382,"kind":13,"name":"$singletID","containerName":"get_singlet_by_id"}],"kind":12,"range":{"end":{"line":383,"character":9999},"start":{"line":375,"character":0}},"containerName":"main::","definition":"sub","name":"get_singlet_by_id"},{"range":{"start":{"character":0,"line":400},"end":{"line":435,"character":9999}},"name":"add_contig","signature":{"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)","parameters":[{"label":"$self"},{"label":"$contig"}],"label":"add_contig($self,$contig)"},"detail":"($self,$contig)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"add_contig","localvar":"my","kind":13,"line":401},{"containerName":"add_contig","name":"$contig","kind":13,"line":401},{"kind":13,"line":404,"name":"$contig","containerName":"add_contig"},{"line":404,"kind":13,"name":"$contig","containerName":"add_contig"},{"containerName":"add_contig","name":"isa","line":404,"kind":12},{"containerName":"add_contig","name":"$self","line":405,"kind":13},{"containerName":"add_contig","name":"throw","kind":12,"line":405},{"name":"$contig","containerName":"add_contig","kind":13,"line":406},{"name":"$contigID","definition":"my","containerName":"add_contig","localvar":"my","kind":13,"line":410},{"containerName":"add_contig","name":"$contig","kind":13,"line":410},{"line":410,"kind":12,"containerName":"add_contig","name":"id"},{"kind":13,"line":411,"name":"$contigID","containerName":"add_contig"},{"containerName":"add_contig","name":"$contigID","kind":13,"line":412},{"line":412,"kind":13,"name":"$self","containerName":"add_contig"},{"kind":12,"line":412,"containerName":"add_contig","name":"get_nof_contigs"},{"kind":13,"line":413,"containerName":"add_contig","name":"$contig"},{"containerName":"add_contig","name":"id","kind":12,"line":413},{"kind":13,"line":413,"name":"$contigID","containerName":"add_contig"},{"line":414,"kind":13,"containerName":"add_contig","name":"$self"},{"line":414,"kind":12,"containerName":"add_contig","name":"warn"},{"containerName":"add_contig","name":"$self","line":419,"kind":13},{"name":"warn","containerName":"add_contig","kind":12,"line":419},{"name":"$self","containerName":"add_contig","kind":13,"line":420},{"containerName":"add_contig","name":"$contigID","line":420,"kind":13},{"line":421,"kind":13,"containerName":"add_contig","name":"$self"},{"containerName":"add_contig","name":"$contigID","kind":13,"line":421},{"kind":13,"line":421,"containerName":"add_contig","name":"$contig"},{"kind":13,"line":422,"containerName":"add_contig","name":"$contig"},{"line":422,"kind":12,"name":"assembly","containerName":"add_contig"},{"kind":13,"line":422,"containerName":"add_contig","name":"$self"},{"localvar":"my","containerName":"add_contig","definition":"my","name":"$seqID","line":425,"kind":13},{"containerName":"add_contig","name":"$contig","kind":13,"line":425},{"containerName":"add_contig","name":"get_seq_ids","line":425,"kind":12},{"containerName":"add_contig","name":"$self","line":426,"kind":13},{"containerName":"add_contig","name":"$seqID","line":426,"kind":13},{"line":427,"kind":13,"containerName":"add_contig","name":"$self"},{"line":427,"kind":13,"containerName":"add_contig","name":"$seqID"},{"name":"$contig","containerName":"add_contig","line":427,"kind":13},{"kind":13,"line":428,"containerName":"add_contig","name":"$self"},{"line":428,"kind":12,"name":"warn","containerName":"add_contig"},{"containerName":"add_contig","name":"$self","line":429,"kind":13},{"line":429,"kind":13,"name":"$seqID","containerName":"add_contig"},{"name":"id","containerName":"add_contig","line":429,"kind":12},{"name":"$self","containerName":"add_contig","line":431,"kind":13},{"kind":13,"line":431,"name":"$seqID","containerName":"add_contig"},{"kind":13,"line":431,"name":"$contig","containerName":"add_contig"}],"line":400,"kind":12},{"line":448,"children":[{"kind":13,"line":449,"name":"$self","definition":"my","containerName":"add_singlet","localvar":"my"},{"name":"$singlet","containerName":"add_singlet","line":449,"kind":13},{"line":452,"kind":13,"name":"$singlet","containerName":"add_singlet"},{"name":"$singlet","containerName":"add_singlet","line":452,"kind":13},{"name":"isa","containerName":"add_singlet","kind":12,"line":452},{"line":453,"kind":13,"containerName":"add_singlet","name":"$self"},{"containerName":"add_singlet","name":"throw","line":453,"kind":12},{"name":"$singlet","containerName":"add_singlet","kind":13,"line":454},{"localvar":"my","definition":"my","name":"$singletID","containerName":"add_singlet","line":458,"kind":13},{"line":458,"kind":13,"name":"$singlet","containerName":"add_singlet"},{"kind":12,"line":458,"name":"id","containerName":"add_singlet"},{"containerName":"add_singlet","name":"$singletID","line":459,"kind":13},{"name":"$singletID","containerName":"add_singlet","kind":13,"line":460},{"kind":13,"line":460,"containerName":"add_singlet","name":"$self"},{"name":"get_nof_singlets","containerName":"add_singlet","kind":12,"line":460},{"name":"$singlet","containerName":"add_singlet","kind":13,"line":461},{"name":"id","containerName":"add_singlet","kind":12,"line":461},{"kind":13,"line":461,"name":"$singletID","containerName":"add_singlet"},{"line":462,"kind":13,"containerName":"add_singlet","name":"$self"},{"name":"warn","containerName":"add_singlet","line":462,"kind":12},{"line":467,"kind":13,"name":"$self","containerName":"add_singlet"},{"containerName":"add_singlet","name":"warn","kind":12,"line":467},{"line":468,"kind":13,"name":"$self","containerName":"add_singlet"},{"kind":13,"line":468,"name":"$singletID","containerName":"add_singlet"},{"containerName":"add_singlet","name":"$self","line":469,"kind":13},{"line":469,"kind":13,"containerName":"add_singlet","name":"$singletID"},{"line":469,"kind":13,"containerName":"add_singlet","name":"$singlet"},{"line":470,"kind":13,"containerName":"add_singlet","name":"$singlet"},{"kind":12,"line":470,"containerName":"add_singlet","name":"assembly"},{"line":470,"kind":13,"name":"$self","containerName":"add_singlet"},{"localvar":"my","containerName":"add_singlet","definition":"my","name":"$seqID","line":473,"kind":13},{"kind":13,"line":473,"containerName":"add_singlet","name":"$singlet"},{"line":473,"kind":12,"containerName":"add_singlet","name":"id"},{"line":474,"kind":13,"containerName":"add_singlet","name":"$self"},{"line":474,"kind":13,"containerName":"add_singlet","name":"$seqID"},{"line":475,"kind":13,"containerName":"add_singlet","name":"$self"},{"name":"$seqID","containerName":"add_singlet","line":475,"kind":13},{"kind":13,"line":475,"name":"$singlet","containerName":"add_singlet"},{"line":476,"kind":13,"containerName":"add_singlet","name":"$self"},{"line":476,"kind":12,"name":"warn","containerName":"add_singlet"},{"line":477,"kind":13,"containerName":"add_singlet","name":"$self"},{"containerName":"add_singlet","name":"$seqID","kind":13,"line":477},{"name":"id","containerName":"add_singlet","kind":12,"line":477},{"kind":13,"line":479,"name":"$self","containerName":"add_singlet"},{"line":479,"kind":13,"containerName":"add_singlet","name":"$seqID"},{"name":"$singlet","containerName":"add_singlet","kind":13,"line":479}],"kind":12,"detail":"($self,$singlet)","signature":{"label":"add_singlet($self,$singlet)","parameters":[{"label":"$self"},{"label":"$singlet"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":448}},"name":"add_singlet"},{"containerName":"main::","definition":"sub","name":"update_seq_list","range":{"end":{"character":9999,"line":530},"start":{"character":0,"line":499}},"kind":12,"line":499,"children":[{"containerName":"update_seq_list","definition":"my","name":"$self","localvar":"my","kind":13,"line":500},{"line":502,"kind":13,"containerName":"update_seq_list","name":"$self"},{"definition":"my","name":"$contig","containerName":"update_seq_list","localvar":"my","kind":13,"line":505},{"name":"$self","containerName":"update_seq_list","line":505,"kind":13},{"containerName":"update_seq_list","name":"all_contigs","line":505,"kind":12},{"kind":13,"line":506,"definition":"my","name":"$contigID","containerName":"update_seq_list","localvar":"my"},{"kind":13,"line":506,"name":"$contig","containerName":"update_seq_list"},{"name":"id","containerName":"update_seq_list","line":506,"kind":12},{"localvar":"my","containerName":"update_seq_list","definition":"my","name":"$seqID","line":507,"kind":13},{"name":"$contig","containerName":"update_seq_list","line":507,"kind":13},{"line":507,"kind":12,"containerName":"update_seq_list","name":"get_seq_ids"},{"containerName":"update_seq_list","name":"$self","kind":13,"line":508},{"kind":13,"line":508,"containerName":"update_seq_list","name":"$seqID"},{"containerName":"update_seq_list","name":"$self","kind":13,"line":509},{"containerName":"update_seq_list","name":"$seqID","kind":13,"line":509},{"containerName":"update_seq_list","name":"$contig","kind":13,"line":509},{"line":510,"kind":13,"containerName":"update_seq_list","name":"$self"},{"line":510,"kind":12,"name":"warn","containerName":"update_seq_list"},{"kind":13,"line":511,"containerName":"update_seq_list","name":"$self"},{"containerName":"update_seq_list","name":"$seqID","line":511,"kind":13},{"containerName":"update_seq_list","name":"id","line":511,"kind":12},{"kind":13,"line":513,"containerName":"update_seq_list","name":"$self"},{"containerName":"update_seq_list","name":"$seqID","kind":13,"line":513},{"line":513,"kind":13,"name":"$contig","containerName":"update_seq_list"},{"line":518,"kind":13,"localvar":"my","name":"$singlet","definition":"my","containerName":"update_seq_list"},{"name":"$self","containerName":"update_seq_list","line":518,"kind":13},{"kind":12,"line":518,"name":"all_singlets","containerName":"update_seq_list"},{"definition":"my","name":"$seqID","containerName":"update_seq_list","localvar":"my","kind":13,"line":519},{"name":"$singlet","containerName":"update_seq_list","line":519,"kind":13},{"name":"id","containerName":"update_seq_list","kind":12,"line":519},{"kind":13,"line":520,"name":"$singletID","definition":"my","containerName":"update_seq_list","localvar":"my"},{"kind":13,"line":520,"name":"$singlet","containerName":"update_seq_list"},{"kind":12,"line":520,"name":"id","containerName":"update_seq_list"},{"containerName":"update_seq_list","name":"$self","kind":13,"line":521},{"line":521,"kind":13,"containerName":"update_seq_list","name":"$seqID"},{"line":522,"kind":13,"name":"$self","containerName":"update_seq_list"},{"kind":13,"line":522,"name":"$seqID","containerName":"update_seq_list"},{"containerName":"update_seq_list","name":"$singlet","kind":13,"line":522},{"kind":13,"line":523,"name":"$self","containerName":"update_seq_list"},{"line":523,"kind":12,"containerName":"update_seq_list","name":"warn"},{"name":"$self","containerName":"update_seq_list","kind":13,"line":524},{"name":"$seqID","containerName":"update_seq_list","line":524,"kind":13},{"containerName":"update_seq_list","name":"id","kind":12,"line":524},{"containerName":"update_seq_list","name":"$self","kind":13,"line":526},{"containerName":"update_seq_list","name":"$seqID","kind":13,"line":526},{"containerName":"update_seq_list","name":"$singlet","line":526,"kind":13}]},{"range":{"end":{"character":9999,"line":558},"start":{"line":545,"character":0}},"name":"remove_contigs","line":545,"children":[{"kind":13,"line":546,"containerName":"remove_contigs","definition":"my","name":"$self","localvar":"my"},{"containerName":"remove_contigs","name":"@args","line":546,"kind":13},{"line":548,"kind":13,"localvar":"my","containerName":"remove_contigs","definition":"my","name":"@ret"},{"line":549,"kind":13,"localvar":"my","definition":"my","name":"$contigID","containerName":"remove_contigs"},{"kind":13,"line":549,"name":"@args","containerName":"remove_contigs"},{"line":550,"kind":13,"localvar":"my","definition":"my","name":"$seqID","containerName":"remove_contigs"},{"name":"$self","containerName":"remove_contigs","kind":13,"line":550},{"containerName":"remove_contigs","name":"get_contig_by_id","line":550,"kind":12},{"kind":13,"line":550,"containerName":"remove_contigs","name":"$contigID"},{"kind":12,"line":550,"containerName":"remove_contigs","name":"get_seq_ids"},{"kind":13,"line":551,"containerName":"remove_contigs","name":"$self"},{"name":"$seqID","containerName":"remove_contigs","line":551,"kind":13},{"name":"@ret","containerName":"remove_contigs","kind":13,"line":553},{"line":553,"kind":13,"name":"$self","containerName":"remove_contigs"},{"line":553,"kind":13,"name":"$contigID","containerName":"remove_contigs"},{"name":"$self","containerName":"remove_contigs","line":554,"kind":13},{"name":"$contigID","containerName":"remove_contigs","line":554,"kind":13},{"line":557,"kind":13,"containerName":"remove_contigs","name":"@ret"}],"kind":12,"detail":"($self,@args)","signature":{"label":"remove_contigs($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above"},"containerName":"main::","definition":"sub"},{"signature":{"label":"remove_singlets($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"remove_singlets","name":"$self","definition":"my","line":573,"kind":13},{"containerName":"remove_singlets","name":"@args","kind":13,"line":573},{"containerName":"remove_singlets","definition":"my","name":"@ret","localvar":"my","kind":13,"line":575},{"line":576,"kind":13,"localvar":"my","containerName":"remove_singlets","name":"$singletID","definition":"my"},{"containerName":"remove_singlets","name":"@args","line":576,"kind":13},{"kind":13,"line":577,"name":"@ret","containerName":"remove_singlets"},{"kind":13,"line":577,"containerName":"remove_singlets","name":"$self"},{"name":"$singletID","containerName":"remove_singlets","line":577,"kind":13},{"name":"$self","containerName":"remove_singlets","kind":13,"line":578},{"name":"$singletID","containerName":"remove_singlets","line":578,"kind":13},{"containerName":"remove_singlets","name":"@ret","kind":13,"line":581}],"line":572,"kind":12,"range":{"end":{"line":582,"character":9999},"start":{"character":0,"line":572}},"name":"remove_singlets"},{"detail":"($self)","signature":{"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none","parameters":[{"label":"$self"}],"label":"remove_features_collection($self)"},"containerName":"main::","definition":"sub","line":597,"children":[{"containerName":"remove_features_collection","name":"$self","definition":"my","localvar":"my","kind":13,"line":598},{"localvar":"my","name":"$obj","definition":"my","containerName":"remove_features_collection","line":599,"kind":13},{"kind":13,"line":599,"containerName":"remove_features_collection","name":"$self"},{"containerName":"remove_features_collection","name":"all_contigs","kind":12,"line":599},{"containerName":"remove_features_collection","name":"$self","kind":13,"line":599},{"containerName":"remove_features_collection","name":"all_singlets","line":599,"kind":12},{"name":"$obj","containerName":"remove_features_collection","line":600,"kind":13},{"line":600,"kind":12,"containerName":"remove_features_collection","name":"remove_features_collection"}],"kind":12,"range":{"start":{"line":597,"character":0},"end":{"line":603,"character":9999}},"name":"remove_features_collection"},{"range":{"start":{"line":622,"character":0},"end":{"line":635,"character":9999}},"name":"select_contigs","detail":"($self,@args)","signature":{"label":"select_contigs($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above"},"containerName":"main::","definition":"sub","line":622,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"select_contigs","line":623,"kind":13},{"kind":13,"line":623,"containerName":"select_contigs","name":"@args"},{"line":625,"kind":13,"localvar":"my","containerName":"select_contigs","definition":"my","name":"@contigs"},{"kind":13,"line":626,"definition":"my","name":"$contig","containerName":"select_contigs","localvar":"my"},{"kind":13,"line":626,"name":"@args","containerName":"select_contigs"},{"line":627,"kind":13,"name":"$self","containerName":"select_contigs"},{"containerName":"select_contigs","name":"$contig","line":627,"kind":13},{"line":628,"kind":13,"containerName":"select_contigs","name":"$self"},{"line":628,"kind":12,"name":"warn","containerName":"select_contigs"},{"name":"@contigs","containerName":"select_contigs","line":631,"kind":13},{"line":631,"kind":13,"name":"$self","containerName":"select_contigs"},{"line":631,"kind":13,"name":"$contig","containerName":"select_contigs"},{"kind":13,"line":634,"containerName":"select_contigs","name":"@contigs"}],"kind":12},{"range":{"start":{"character":0,"line":649},"end":{"line":662,"character":9999}},"name":"select_singlets","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above","parameters":[{"label":"$self"},{"label":"@args"}],"label":"select_singlets($self,@args)"},"containerName":"main::","definition":"sub","line":649,"children":[{"name":"$self","definition":"my","containerName":"select_singlets","localvar":"my","kind":13,"line":650},{"name":"@args","containerName":"select_singlets","kind":13,"line":650},{"localvar":"my","name":"@singlets","definition":"my","containerName":"select_singlets","line":652,"kind":13},{"kind":13,"line":653,"definition":"my","name":"$singlet","containerName":"select_singlets","localvar":"my"},{"containerName":"select_singlets","name":"@args","kind":13,"line":653},{"kind":13,"line":654,"containerName":"select_singlets","name":"$self"},{"containerName":"select_singlets","name":"$singlet","line":654,"kind":13},{"kind":13,"line":655,"name":"$self","containerName":"select_singlets"},{"name":"warn","containerName":"select_singlets","line":655,"kind":12},{"containerName":"select_singlets","name":"@singlets","kind":13,"line":658},{"kind":13,"line":658,"name":"$self","containerName":"select_singlets"},{"name":"$singlet","containerName":"select_singlets","kind":13,"line":658},{"kind":13,"line":661,"name":"@singlets","containerName":"select_singlets"}],"kind":12},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"all_contigs","localvar":"my","kind":13,"line":680},{"containerName":"all_contigs","definition":"my","name":"@contigs","localvar":"my","kind":13,"line":682},{"kind":13,"line":683,"containerName":"all_contigs","definition":"my","name":"$contig","localvar":"my"},{"kind":13,"line":683,"name":"$a","containerName":"all_contigs"},{"name":"$b","containerName":"all_contigs","kind":13,"line":683},{"kind":13,"line":683,"containerName":"all_contigs","name":"$self"}],"line":679,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above\n\n\nsub select_singlets {\n    my ($self,@args) = @_;\n\n    my @singlets = ();\n    foreach my $singlet (@args) {\n    unless (exists $self->{'_singlets'}{$singlet}) {\n        $self->warn(\"$singlet singlet not found. Ignoring...\");\n        next;\n    }\n    push(@singlets, $self->{'_singlets'}{$singlet});\n    }\n\n    return @singlets;\n}\n\n=head2 all_contigs\n\n    Title   : all_contigs\n    Usage   : my @contigs = $assembly->all_contigs\n    Function: \n\n              Returns a list of all contigs in this assembly.  Contigs\n              are both clusters and alignments of one or more reads,\n              with an associated consensus sequence.\n\n    Returns : array of Bio::Assembly::Contig (in lexical id order)\n    Args    : none","label":"all_contigs($self)"},"detail":"($self)","name":"all_contigs","range":{"start":{"line":679,"character":0},"end":{"character":9999,"line":683}}},{"name":"@contigs","containerName":null,"kind":13,"line":684},{"line":684,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$contig","line":684,"kind":13},{"name":"@contigs","containerName":null,"line":687,"kind":13},{"kind":12,"children":[{"containerName":"all_singlets","definition":"my","name":"$self","localvar":"my","kind":13,"line":706},{"localvar":"my","name":"@singlets","definition":"my","containerName":"all_singlets","line":708,"kind":13},{"line":709,"kind":13,"localvar":"my","definition":"my","name":"$singlet","containerName":"all_singlets"},{"kind":13,"line":709,"containerName":"all_singlets","name":"$a"},{"line":709,"kind":13,"containerName":"all_singlets","name":"$b"},{"containerName":"all_singlets","name":"$self","line":709,"kind":13}],"line":705,"definition":"sub","containerName":"main::","signature":{"label":"all_singlets($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above\n\n\nsub select_singlets {\n    my ($self,@args) = @_;\n\n    my @singlets = ();\n    foreach my $singlet (@args) {\n    unless (exists $self->{'_singlets'}{$singlet}) {\n        $self->warn(\"$singlet singlet not found. Ignoring...\");\n        next;\n    }\n    push(@singlets, $self->{'_singlets'}{$singlet});\n    }\n\n    return @singlets;\n}\n\n=head2 all_contigs\n\n    Title   : all_contigs\n    Usage   : my @contigs = $assembly->all_contigs\n    Function: \n\n              Returns a list of all contigs in this assembly.  Contigs\n              are both clusters and alignments of one or more reads,\n              with an associated consensus sequence.\n\n    Returns : array of Bio::Assembly::Contig (in lexical id order)\n    Args    : none\n\n\nsub all_contigs {\n    my ($self) = @_;\n\n    my @contigs = ();\n    foreach my $contig (sort { $a cmp $b } keys %{ $self->{'_contigs'} }) {\n        push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 all_singlets\n\n    Title   : all_singlets\n    Usage   : my @singlets = $assembly->all_singlets\n    Function: \n\n              Returns a list of all singlets in this assembly.\n          Singlets are isolated reads, without non-vector\n          matches to any other read in the assembly.\n\n    Returns : array of Bio::Assembly::Singlet objects (in lexical order by id)\n    Args    : none"},"detail":"($self)","name":"all_singlets","range":{"start":{"character":0,"line":705},"end":{"character":9999,"line":709}}},{"kind":13,"line":710,"containerName":null,"name":"@singlets"},{"kind":13,"line":710,"containerName":null,"name":"%self"},{"name":"$singlet","containerName":null,"line":710,"kind":13},{"kind":13,"line":713,"name":"@singlets","containerName":null}],"version":5}