{"vars":[{"name":"vars","containerName":"","line":89,"kind":2},{"line":93,"kind":2,"name":"base","containerName":""},{"kind":12,"children":[{"line":97,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":97},{"kind":13,"line":100,"name":"%param","definition":"my","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"@args","line":100,"kind":13},{"kind":13,"line":101,"containerName":"_initialize","name":"@param"},{"line":101,"kind":13,"containerName":"_initialize","name":"%param"},{"containerName":"_initialize","name":"%param","line":101,"kind":13},{"kind":13,"line":105,"definition":"my","name":"$new_key","containerName":"_initialize","localvar":"my"},{"kind":13,"line":106,"name":"$key","definition":"my","containerName":"_initialize","localvar":"my"},{"kind":13,"line":106,"containerName":"_initialize","name":"%param"},{"line":107,"kind":13,"containerName":"_initialize","name":"$new_key"},{"kind":13,"line":107,"name":"$key","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":108},{"name":"$new_key","containerName":"_initialize","kind":13,"line":108},{"kind":13,"line":108,"containerName":"_initialize","name":"$param"},{"containerName":"_initialize","name":"$key","kind":13,"line":108},{"kind":13,"line":114,"containerName":"_initialize","definition":"my","name":"$result","localvar":"my"},{"name":"$self","containerName":"_initialize","line":114,"kind":13},{"line":115,"kind":13,"containerName":"_initialize","name":"$result"},{"name":"$result","containerName":"_initialize","kind":13,"line":120},{"line":123,"kind":13,"name":"$result","containerName":"_initialize"},{"kind":13,"line":124,"name":"$Bio","containerName":"_initialize"},{"containerName":"_initialize","name":"new","line":124,"kind":12},{"containerName":"_initialize","name":"@args","kind":13,"line":124},{"line":130,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":135},{"line":144,"kind":13,"containerName":"_initialize","name":"$SUPER"},{"line":144,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"$self","line":145,"kind":13},{"name":"_parse","containerName":"_initialize","kind":12,"line":145}],"line":96,"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","name":"_initialize","range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":96}}},{"kind":12,"line":123,"name":"Bio","containerName":"Biblio::IO::_load_format_module"},{"containerName":"IO::medlinexml::Convert","name":"Biblio","line":124,"kind":12},{"name":"new","kind":12,"line":130},{"kind":12,"line":130,"containerName":"Parser","name":"XML"},{"kind":12,"line":130,"name":"Handlers"},{"line":130,"kind":12,"name":"Init"},{"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_doc_start","line":130,"kind":12},{"name":"Start","kind":12,"line":131},{"line":131,"kind":12,"name":"handle_start"},{"name":"End","line":132,"kind":12},{"name":"handle_end","line":132,"kind":12},{"kind":12,"line":133,"name":"Char"},{"kind":12,"line":133,"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_char"},{"kind":12,"line":134,"name":"Final"},{"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_doc_end","kind":12,"line":134},{"name":"Callback","containerName":"","line":144,"kind":12},{"containerName":null,"name":"%PCDATA_NAMES","line":163,"kind":13},{"kind":13,"line":171,"name":"%SIMPLE_TREATMENT","containerName":null},{"containerName":null,"name":"%POP_DATA_AND_PEEK_OBJ","kind":13,"line":179},{"kind":13,"line":191,"name":"%POP_AND_ADD_DATA_ELEMENT","containerName":null},{"signature":{"label":"handle_start($expat,$e,%attrs)","parameters":[{"label":"$expat"},{"label":"$e"},{"label":"%attrs"}],"documentation":"__END__\n# $Id: pubmedxml.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Biblio::IO::pubmedxml.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio::IO::pubmedxml - A converter of XML files with PUBMED citations\n\n=head1 SYNOPSIS\n\nDo not use this object directly, it is recommended to access it and use\nit through the I<Bio::Biblio::IO> module:\n\n  use Bio::Biblio::IO;\n  my $io = Bio::Biblio::IO->new(-format => 'pubmedxml');\n\n=head1 DESCRIPTION\n\nThis object reads bibliographic citations in XML/MEDLINE format and\nconverts them into I<Bio::Biblio::RefI> objects. It is an\nimplementation of methods defined in I<Bio::Biblio::IO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (senger@ebi.ac.uk)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe main documentation details are to be found in\nL<Bio::Biblio::IO>.\n\nHere is the rest of the object methods.  Internal methods are preceded\nwith an underscore _.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Biblio::IO::pubmedxml;\nuse vars qw(%PCDATA_NAMES %SIMPLE_TREATMENT %POP_DATA_AND_PEEK_OBJ %POP_AND_ADD_DATA_ELEMENT);\n\nuse strict;\n\nuse base qw(Bio::Biblio::IO::medlinexml);\n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    \n    # make a hashtable from @args\n    my %param = @args;\n    @param { map { lc $_ } keys %param } = values %param; # lowercase keys\n\n    # copy all @args into this object (overwriting what may already be\n    # there) - changing '-key' into '_key', and making keys lowercase\n    my $new_key;\n    foreach my $key (keys %param) {\n\t($new_key = $key) =~ s/^-/_/;\n\t$self->{ lc $new_key } = $param { $key };\n    }\n\n    # find the format for output - and put it into a global $Convert\n    # because it will be used by the event handler who knows nothing\n    # about this object\n    my $result = $self->{'_result'} || 'pubmed2ref';\n    $result = \"\\L$result\";\t# normalize capitalization to lower case\n\n    # a special case is 'raw' when no converting module is loaded\n    # and citations will be returned as a hashtable (the one which\n    # is created during parsing XML file/stream)\n    unless ($result eq 'raw') {\n\n\t# load module with output converter - as defined in $result\n\tif (defined &Bio::Biblio::IO::_load_format_module ($result)) {\n\t    $Bio::Biblio::IO::medlinexml::Convert = \"Bio::Biblio::IO::$result\"->new (@args);\n\t}\n    }\n\n    # create an instance of the XML parser\n    # (unless it is already there...)\n    $self->{'_xml_parser'} = new XML::Parser (Handlers => {Init  => \\&Bio::Biblio::IO::medlinexml::handle_doc_start,\n\t\t\t\t\t\t\t   Start => \\&handle_start,\n\t\t\t\t\t\t\t   End   => \\&handle_end,\n\t\t\t\t\t\t\t   Char  => \\&Bio::Biblio::IO::medlinexml::handle_char,\n\t\t\t\t\t\t\t   Final => \\&Bio::Biblio::IO::medlinexml::handle_doc_end})\n\tunless $self->{'_xml_parser'};\n\n    # if there is an argument '-callback' then start parsing at once -\n    # the registered event handlers will use 'callback' to report\n    # back after each citation\n    #\n    # we need to remember this situation also in a global variable\n    # because the event handler subroutines know nothing about this\n    # object (unfortunately)\n    if ($SUPER::Callback = $self->{'_callback'}) {\n\t$self->_parse;\n    }\n}\n\n# ---------------------------------------------------------------------\n#\n#   Here are the event handlers (they do the real job!)\n#\n# Note that these methods do not know anything about the object they\n# are part of - they are called as subroutines. not as methods.\n# It also means that they need to use global variables to store and\n# exchnage intermediate results.\n#\n# ---------------------------------------------------------------------\n\n#\n# This is a list of #PCDATA elements.\n#\n%PCDATA_NAMES =\n    (\n     'PublicationStatus' => 1,\n     'ProviderId' => 1,\n     'ArticleId' => 1,\n     'URL' => 1,\n     );\n\n%SIMPLE_TREATMENT =\n    (\n     'History' => 1,\n     'PubMedArticle' => 1,\n     'PubmedArticle' => 1,\n     'PubmedData' => 1,\n     );\n\n%POP_DATA_AND_PEEK_OBJ =\n    (\n     'Year' => 1,\n     'Month' => 1,\n     'Day' => 1,\n     'Hour' => 1,\n     'Minute' => 1,\n     'Second' => 1,\n     'ProviderId' => 1,\n     'PublicationStatus' => 1,\n     );\n\n%POP_AND_ADD_DATA_ELEMENT =\n    (\n     'PubMedPubDate' => 'pubDates',\n     'History' => 'histories',\n     );\n\n\n=head2 VERSION and Revision\n\n Usage   : print $Bio::Biblio::IO::pubmedxml::VERSION;\n           print $Bio::Biblio::IO::pubmedxml::Revision;"},"detail":"($expat,$e,%attrs)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":207,"name":"$expat","definition":"my","containerName":"handle_start","localvar":"my"},{"line":207,"kind":13,"name":"$e","containerName":"handle_start"},{"containerName":"handle_start","name":"%attrs","kind":13,"line":207},{"containerName":"handle_start","name":"$e","line":215,"kind":13},{"kind":13,"line":216,"name":"%p","definition":"my","containerName":"handle_start","localvar":"my"},{"line":217,"kind":13,"containerName":"handle_start","name":"$p"},{"containerName":"handle_start","name":"$attrs","kind":13,"line":217},{"containerName":"handle_start","name":"$attrs","kind":13,"line":217},{"line":218,"kind":13,"name":"@Bio","containerName":"handle_start"},{"line":218,"kind":13,"name":"%p","containerName":"handle_start"},{"containerName":"handle_start","name":"$e","line":221,"kind":13},{"line":222,"kind":13,"localvar":"my","definition":"my","name":"%p","containerName":"handle_start"},{"containerName":"handle_start","name":"$p","line":223,"kind":13},{"name":"$attrs","containerName":"handle_start","kind":13,"line":223},{"containerName":"handle_start","name":"$attrs","kind":13,"line":223},{"name":"$p","containerName":"handle_start","line":224,"kind":13},{"name":"$attrs","containerName":"handle_start","kind":13,"line":224},{"name":"$attrs","containerName":"handle_start","line":224,"kind":13},{"name":"@Bio","containerName":"handle_start","kind":13,"line":225},{"kind":13,"line":225,"name":"%p","containerName":"handle_start"},{"line":232,"kind":13,"name":"$PCDATA_NAMES","containerName":"handle_start"},{"kind":13,"line":232,"containerName":"handle_start","name":"$e"},{"name":"@Bio","containerName":"handle_start","kind":13,"line":233},{"line":238,"kind":13,"containerName":"handle_start","name":"$SIMPLE_TREATMENT"},{"kind":13,"line":238,"name":"$e","containerName":"handle_start"},{"kind":13,"line":239,"containerName":"handle_start","name":"@Bio"},{"line":241,"kind":13,"name":"$e","containerName":"handle_start"},{"kind":13,"line":244,"name":"$e","containerName":"handle_start"},{"name":"%p","definition":"my","containerName":"handle_start","localvar":"my","kind":13,"line":245},{"name":"$p","containerName":"handle_start","kind":13,"line":246},{"containerName":"handle_start","name":"$attrs","line":246,"kind":13},{"line":246,"kind":13,"containerName":"handle_start","name":"$attrs"},{"line":247,"kind":13,"containerName":"handle_start","name":"@Bio"},{"line":247,"kind":13,"name":"%p","containerName":"handle_start"},{"kind":13,"line":250,"name":"$expat","containerName":"handle_start"},{"containerName":"handle_start","name":"$e","kind":13,"line":250},{"kind":13,"line":250,"containerName":"handle_start","name":"%attrs"}],"line":206,"kind":12,"range":{"end":{"character":9999,"line":252},"start":{"line":206,"character":0}},"name":"handle_start"},{"kind":12,"line":218,"name":"Biblio","containerName":"IO::medlinexml::ObjectStack"},{"containerName":"IO::medlinexml::ObjectStack","name":"Biblio","kind":12,"line":225},{"name":"Biblio","containerName":"IO::medlinexml::PCDataStack","kind":12,"line":233},{"line":239,"kind":12,"name":"Biblio","containerName":"IO::medlinexml::ObjectStack"},{"line":247,"kind":12,"name":"Biblio","containerName":"IO::medlinexml::ObjectStack"},{"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_start","kind":12,"line":250},{"range":{"end":{"character":9999,"line":309},"start":{"line":254,"character":0}},"name":"handle_end","signature":{"label":"handle_end($expat,$e)","parameters":[{"label":"$expat"},{"label":"$e"}],"documentation":""},"detail":"($expat,$e)","definition":"sub","containerName":"main::","children":[{"line":255,"kind":13,"localvar":"my","definition":"my","name":"$expat","containerName":"handle_end"},{"line":255,"kind":13,"containerName":"handle_end","name":"$e"},{"kind":13,"line":263,"name":"$e","containerName":"handle_end"},{"containerName":"handle_end","name":"@Bio","line":265,"kind":13},{"name":"$e","containerName":"handle_end","line":270,"kind":13},{"name":"@Bio","containerName":"handle_end","line":272,"kind":13},{"name":"$POP_DATA_AND_PEEK_OBJ","containerName":"handle_end","line":282,"kind":13},{"name":"$e","containerName":"handle_end","kind":13,"line":282},{"line":285,"kind":13,"containerName":"handle_end","name":"$POP_AND_ADD_DATA_ELEMENT"},{"kind":13,"line":285,"containerName":"handle_end","name":"$e"},{"containerName":"handle_end","name":"$POP_AND_ADD_DATA_ELEMENT","kind":13,"line":286},{"name":"$e","containerName":"handle_end","kind":13,"line":286},{"line":286,"kind":13,"name":"@Bio","containerName":"handle_end"},{"name":"$e","containerName":"handle_end","kind":13,"line":288},{"name":"$e","containerName":"handle_end","kind":13,"line":289},{"kind":13,"line":292,"containerName":"handle_end","name":"$e"},{"name":"$e","containerName":"handle_end","line":295,"kind":13},{"containerName":"handle_end","name":"$e","line":296,"kind":13},{"kind":13,"line":301,"containerName":"handle_end","name":"@Bio"},{"name":"$expat","containerName":"handle_end","kind":13,"line":304},{"containerName":"handle_end","name":"$e","line":304,"kind":13}],"line":254,"kind":12},{"kind":12,"line":264,"name":"Bio","containerName":"Biblio::IO::medlinexml::_data2obj"},{"kind":12,"line":265,"containerName":"Biblio::IO::medlinexml::_add_element","name":"Bio"},{"kind":12,"line":265,"containerName":"IO::medlinexml::ObjectStack","name":"Biblio"},{"name":"Bio","containerName":"Biblio::IO::medlinexml::_data2obj","kind":12,"line":271},{"line":272,"kind":12,"containerName":"Biblio::IO::medlinexml::_add_element","name":"Bio"},{"containerName":"IO::medlinexml::ObjectStack","name":"Biblio","line":272,"kind":12},{"name":"Bio","containerName":"Biblio::IO::medlinexml::_data2obj","line":283,"kind":12},{"line":286,"kind":12,"containerName":"Biblio::IO::medlinexml::_add_element","name":"Bio"},{"containerName":"IO::medlinexml::ObjectStack","name":"Biblio","line":286,"kind":12},{"containerName":"Biblio::IO::medlinexml::_obj2obj","name":"Bio","kind":12,"line":290},{"line":293,"kind":12,"name":"Bio","containerName":"Biblio::IO::medlinexml::_obj2obj"},{"containerName":"Biblio::IO::medlinexml::_process_citation","name":"Bio","kind":12,"line":301},{"line":301,"kind":12,"name":"Biblio","containerName":"IO::medlinexml::ObjectStack"},{"name":"Bio","containerName":"Biblio::IO::medlinexml::handle_end","kind":12,"line":304}],"version":5}