{"version":5,"vars":[{"line":129,"kind":2,"name":"overload","containerName":""},{"kind":12,"line":130,"name":"eq"},{"name":"fallback","line":131,"kind":12},{"kind":2,"line":141,"containerName":"","name":"base"},{"range":{"start":{"line":154,"character":0},"end":{"character":9999,"line":154}},"definition":"sub","name":"name","containerName":"main::","children":[{"containerName":"name","name":"throw_not_implemented","line":154,"kind":12}],"line":154,"kind":12},{"kind":12,"children":[{"name":"throw_not_implemented","containerName":"accession","line":167,"kind":12}],"line":167,"name":"accession","definition":"sub","containerName":"main::","range":{"start":{"line":167,"character":0},"end":{"line":167,"character":9999}}},{"name":"definition","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":180},"end":{"line":180,"character":9999}},"kind":12,"children":[{"line":180,"kind":12,"name":"throw_not_implemented","containerName":"definition"}],"line":180},{"kind":12,"children":[{"line":199,"kind":12,"name":"throw_not_implemented","containerName":"parents"}],"line":199,"definition":"sub","name":"parents","containerName":"main::","range":{"end":{"character":9999,"line":199},"start":{"line":199,"character":0}}},{"kind":12,"line":218,"children":[{"name":"throw_not_implemented","containerName":"children","kind":12,"line":218}],"containerName":"main::","definition":"sub","name":"children","range":{"end":{"line":218,"character":9999},"start":{"character":0,"line":218}}},{"name":"relationship","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":236}},"kind":12,"children":[{"containerName":"relationship","name":"throw_not_implemented","line":236,"kind":12}],"line":236},{"containerName":"main::","name":"equals","definition":"sub","range":{"start":{"line":259,"character":0},"end":{"character":9999,"line":267}},"kind":12,"line":259,"children":[{"kind":13,"line":260,"name":"$self","definition":"my","containerName":"equals","localvar":"my"},{"name":"$term2","definition":"my","containerName":"equals","localvar":"my","kind":13,"line":261},{"line":262,"kind":13,"containerName":"equals","name":"$term2"},{"containerName":"equals","name":"isa","line":262,"kind":12},{"containerName":"equals","name":"$self","kind":13,"line":263},{"kind":12,"line":263,"name":"accession","containerName":"equals"},{"kind":13,"line":263,"name":"$term2","containerName":"equals"},{"containerName":"equals","name":"accession","line":263,"kind":12},{"containerName":"equals","name":"$self","kind":13,"line":265},{"name":"name","containerName":"equals","kind":12,"line":265},{"kind":13,"line":265,"containerName":"equals","name":"$term2"}]},{"kind":12,"children":[{"kind":13,"line":291,"name":"$self","definition":"my","containerName":"is_descendent","localvar":"my"},{"kind":13,"line":292,"containerName":"is_descendent","definition":"my","name":"$term","localvar":"my"},{"kind":13,"line":292,"containerName":"is_descendent","name":"$relationship"},{"line":293,"kind":13,"containerName":"is_descendent","name":"$self"},{"containerName":"is_descendent","name":"throw","kind":12,"line":293},{"line":294,"kind":13,"containerName":"is_descendent","name":"$term"},{"containerName":"is_descendent","name":"isa","kind":12,"line":294},{"name":"$term","containerName":"is_descendent","line":295,"kind":13},{"line":295,"kind":12,"name":"is_parent","containerName":"is_descendent"},{"line":295,"kind":13,"containerName":"is_descendent","name":"$self"},{"line":295,"kind":13,"name":"$relationship","containerName":"is_descendent"}],"line":290,"definition":"sub","containerName":"main::","signature":{"documentation":"this is somehow FUBAR, implementation classes cannot successfully inherit from Bio::Das::FeatureTypeI\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : $string = $term->name\n Function: return the term for the type\n Returns : a string\n Args    : none\n Status  : Public\n\n\nsub name { shift->throw_not_implemented }\n\n=head2 accession\n\n Title   : accession\n Usage   : $string = $term->accession\n Function: return the accession number for the term\n Returns : a string\n Args    : none\n Status  : Public\n\n\nsub accession  { shift->throw_not_implemented }\n\n=head2 definition\n\n Title   : definition\n Usage   : $string = $term->definition\n Function: return the human-readable definition for the term\n Returns : a string\n Args    : none\n Status  : Public\n\n\nsub definition  { shift->throw_not_implemented  }\n\n=head2 parents\n\n Title   : parents\n Usage   : @terms = $term->parents($relationship)\n Function: return parent terms\n Returns : list of Bio::Das::FeatureTypeI\n Args    : none\n Status  : Public\n\nReturns the parents for the current term, empty if there are none.  An\noptional relationship argument will return those parents\nthat are related via the specified relationship type.\n\nThe relationship is one of \"isa\" or \"partof\".\n\n\nsub parents { shift->throw_not_implemented; }\n\n=head2 children\n\n Title   : children\n Usage   : @terms = $term->children($relationship)\n Function: return children terms\n Returns : list of Bio::Das::FeatureTypeI\n Args    : none\n Status  : Public\n\nReturns the children for the current term, empty if there are none.  An\noptional relationship argument will return those children\nthat are related via the specified relationship type.\n\nThe relationship is one of \"isa\" or \"partof\".\n\n\nsub children { shift->throw_not_implemented; }\n\n=head2 relationship\n\n Title   : relationship\n Usage   : $relationship = $parent->relationship($child)\n Function: return the relationship between a parent and a child\n Returns : one of \"isa\" or \"partof\"\n Args    : none\n Status  : Public\n\nThis method returns the relationship between a parent and one of its\nimmediate descendents.  It can return \"isa\", \"partof\", or undef if\nthere is not a direct parent/child relationship (kissing cousins are\n*not* recognized).\n\n\nsub relationship { shift->throw_not_implemented }\n\n=head2 equals\n\n Title   : equals\n Usage   : $boolean = $term1->equals($term2)\n Function: return true if $term1 and $term2 are the same\n Returns : boolean\n Args    : second term\n Status  : Public\n\nThe two terms must be identical.  In practice, this means that if\nterm2 is a Bio::Das::FeatureI object, then its accession number must\nmatch the first term's accession number.  Otherwise, if term2 is a\nbare string, then it must equal (in a case insensitive manner)\nthe name of term1.\n\nNOTE TO IMPLEMENTORS: This method is defined in terms of other\nmethods, so does not need to be implemented.\n\n\n#'\nsub equals {\n  my $self = shift;\n  my $term2 = shift;\n  if ($term2->isa('Bio::Das::FeatureTypeI')) {\n    return $self->accession eq $term2->accession;\n  } else {\n    return lc $self->name eq lc $term2;\n  }\n}\n\n=head2 is_descendent\n\n Title   : is_descendent\n Usage   : $boolean = $term1->is_descendent($term2 [,$relationship])\n Function: return true of $term2 is a descendent of $term1\n Returns : boolean\n Args    : second term\n Status  : Public\n\nThis method returns true if $term2 descends from $term1.  The\noperation traverses the tree.  The traversal can be limited to the\nrelationship type (\"isa\" or \"partof\") if desired.  $term2 can be a\nbare string, in which case the term names will be used as the basis\nfor term matching (see equals()).\n\nNOTE TO IMPLEMENTORS: this method is defined as the inverse of\nis_parent().  Do not implement it directly, but do implement\nis_parent().","parameters":[{"label":"$term"},{"label":"$relationship"}],"label":"is_descendent($term,$relationship)"},"detail":"($term,$relationship)","name":"is_descendent","range":{"start":{"line":290,"character":0},"end":{"line":296,"character":9999}}},{"range":{"end":{"character":9999,"line":318},"start":{"line":318,"character":0}},"containerName":"main::","name":"is_parent","definition":"sub","line":318,"children":[{"line":318,"kind":12,"name":"throw_not_implemented","containerName":"is_parent"}],"kind":12},{"definition":"sub","name":"match","containerName":"main::","range":{"end":{"character":9999,"line":344},"start":{"line":339,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"match","line":340,"kind":13},{"localvar":"my","containerName":"match","name":"$term2","definition":"my","line":341,"kind":13},{"containerName":"match","name":"$self","line":342,"kind":13},{"name":"equals","containerName":"match","line":342,"kind":12},{"line":342,"kind":13,"containerName":"match","name":"$term2"},{"name":"$self","containerName":"match","line":343,"kind":13},{"containerName":"match","name":"is_descendent","kind":12,"line":343},{"containerName":"match","name":"$term2","line":343,"kind":13}],"line":339},{"range":{"start":{"line":368,"character":0},"end":{"line":368,"character":9999}},"containerName":"main::","name":"new","definition":"sub","line":368,"children":[{"name":"throw_not_implemented","containerName":"new","kind":12,"line":368}],"kind":12},{"kind":12,"line":385,"children":[{"kind":12,"line":385,"name":"throw_not_implemented","containerName":"add_child"}],"containerName":"main::","name":"add_child","definition":"sub","range":{"end":{"line":385,"character":9999},"start":{"line":385,"character":0}}},{"kind":12,"children":[{"line":403,"kind":12,"containerName":"delete_child","name":"throw_not_implemented"}],"line":403,"definition":"sub","name":"delete_child","containerName":"main::","range":{"start":{"line":403,"character":0},"end":{"character":9999,"line":403}}}]}