{"version":5,"vars":[{"name":"base","containerName":"","line":73,"kind":2},{"range":{"end":{"character":9999,"line":91},"start":{"line":85,"character":0}},"name":"new","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":85,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":86,"kind":13},{"line":86,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":88,"kind":13},{"name":"$class","containerName":"new","line":88,"kind":13},{"containerName":"new","name":"@args","line":88,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":89},{"kind":12,"line":89,"containerName":"new","name":"_initialize"},{"line":89,"kind":13,"name":"@args","containerName":"new"},{"line":90,"kind":13,"name":"$self","containerName":"new"}],"kind":12},{"line":86,"kind":2,"name":"Taxonomy","containerName":"Bio::DB"},{"containerName":"new","name":"SUPER","kind":12,"line":88},{"name":"_initialize","range":{"start":{"character":0,"line":102},"end":{"line":113,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"_initialize","definition":"my","name":"$self","line":103,"kind":13},{"name":"%arg","containerName":"_initialize","kind":13,"line":103},{"line":105,"kind":13,"localvar":"my","containerName":"_initialize","name":"$arg","definition":"my"},{"name":"%arg","containerName":"_initialize","line":105,"kind":13},{"line":106,"kind":13,"localvar":"my","definition":"my","name":"$marg","containerName":"_initialize"},{"line":106,"kind":13,"containerName":"_initialize","name":"$arg"},{"kind":13,"line":107,"name":"$marg","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":108,"kind":13},{"containerName":"_initialize","name":"$marg","kind":13,"line":108},{"line":108,"kind":13,"name":"$arg","containerName":"_initialize"},{"kind":13,"line":108,"containerName":"_initialize","name":"$arg"},{"name":"$self","containerName":"_initialize","kind":13,"line":108},{"kind":12,"line":108,"containerName":"_initialize","name":"can"},{"kind":13,"line":108,"containerName":"_initialize","name":"$marg"},{"kind":13,"line":111,"name":"$self","containerName":"_initialize"},{"line":111,"kind":12,"containerName":"_initialize","name":"taxdb"},{"name":"new","containerName":"_initialize","line":111,"kind":12}],"line":102,"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,%arg)","parameters":[{"label":"$self"},{"label":"%arg"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()"},"detail":"($self,%arg)"},{"kind":12,"line":111,"containerName":"DB::Taxonomy","name":"Bio"},{"range":{"end":{"line":134,"character":9999},"start":{"character":0,"line":127}},"name":"get_datasets","line":127,"children":[{"line":128,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_datasets"},{"line":128,"kind":13,"name":"@args","containerName":"get_datasets"},{"name":"$db","definition":"my","containerName":"get_datasets","localvar":"my","kind":13,"line":129},{"kind":13,"line":129,"containerName":"get_datasets","name":"$self"},{"containerName":"get_datasets","name":"db","kind":12,"line":129},{"line":131,"kind":13,"localvar":"my","containerName":"get_datasets","definition":"my","name":"@datasets"},{"kind":13,"line":131,"containerName":"get_datasets","name":"$db"},{"line":131,"kind":12,"containerName":"get_datasets","name":"get_datasets"},{"kind":13,"line":131,"containerName":"get_datasets","name":"$self"},{"line":133,"kind":13,"containerName":"get_datasets","name":"@datasets"}],"kind":12,"detail":"($self,@args)","signature":{"label":"get_datasets($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":151},"start":{"line":147,"character":0}},"name":"accession","signature":{"label":"accession($self,$val)","documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":148,"name":"$self","definition":"my","containerName":"accession","localvar":"my"},{"name":"$val","containerName":"accession","line":148,"kind":13},{"line":149,"kind":13,"containerName":"accession","name":"$self"},{"kind":13,"line":149,"name":"$val","containerName":"accession"},{"name":"$val","containerName":"accession","line":149,"kind":13},{"line":150,"kind":13,"name":"$self","containerName":"accession"}],"line":147,"kind":12},{"line":164,"children":[{"localvar":"my","containerName":"name","name":"$self","definition":"my","line":165,"kind":13},{"name":"$val","containerName":"name","kind":13,"line":165},{"containerName":"name","name":"$self","line":166,"kind":13},{"name":"$val","containerName":"name","kind":13,"line":166},{"containerName":"name","name":"$val","kind":13,"line":166},{"kind":13,"line":167,"name":"$self","containerName":"name"}],"kind":12,"detail":"($self,$val)","signature":{"label":"name($self,$val)","documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":164,"character":0},"end":{"line":168,"character":9999}},"name":"name"},{"name":"taxon","range":{"end":{"line":187,"character":9999},"start":{"line":181,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 taxon()\n\n Usage   : $obj->taxon()\n Function: \n Example : \n Returns : A Bio::Taxonomy::Node object\n Args    : none","label":"taxon($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"taxon","definition":"my","name":"$self","localvar":"my","kind":13,"line":182},{"line":183,"kind":13,"name":"$self","containerName":"taxon"},{"kind":13,"line":184,"containerName":"taxon","name":"$self"},{"kind":13,"line":184,"containerName":"taxon","name":"$self"},{"name":"taxdb","containerName":"taxon","kind":12,"line":184},{"line":184,"kind":12,"containerName":"taxon","name":"get_Taxonomy_Node"},{"kind":13,"line":184,"containerName":"taxon","name":"$self"},{"name":"_taxon_id","containerName":"taxon","kind":12,"line":184},{"containerName":"taxon","name":"$self","kind":13,"line":186}],"line":181},{"kind":12,"children":[{"containerName":"contact","definition":"my","name":"$self","localvar":"my","kind":13,"line":201},{"containerName":"contact","name":"$val","kind":13,"line":201},{"line":202,"kind":13,"name":"$self","containerName":"contact"},{"containerName":"contact","name":"$val","kind":13,"line":202},{"kind":13,"line":202,"containerName":"contact","name":"$val"},{"name":"$self","containerName":"contact","kind":13,"line":203}],"line":200,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 taxon()\n\n Usage   : $obj->taxon()\n Function: \n Example : \n Returns : A Bio::Taxonomy::Node object\n Args    : none\n\n\n\nsub taxon {\n  my($self) = @_;\n  if ( ! $self->{'taxon'} ) {\n    $self->{'taxon'} = $self->taxdb->get_Taxonomy_Node( $self->_taxon_id() );\n  }\n  return $self->{'taxon'};\n}\n\n=head2 contact()\n\n Usage   : $obj->contact($newval)\n Function: \n Example : \n Returns : a Bio::Expression::Contact object\n Args    : on set, new value (a scalar or undef, optional)","label":"contact($self,$val)"},"detail":"($self,$val)","name":"contact","range":{"start":{"character":0,"line":200},"end":{"line":204,"character":9999}}},{"range":{"end":{"character":9999,"line":221},"start":{"character":0,"line":217}},"name":"db","detail":"($self,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 taxon()\n\n Usage   : $obj->taxon()\n Function: \n Example : \n Returns : A Bio::Taxonomy::Node object\n Args    : none\n\n\n\nsub taxon {\n  my($self) = @_;\n  if ( ! $self->{'taxon'} ) {\n    $self->{'taxon'} = $self->taxdb->get_Taxonomy_Node( $self->_taxon_id() );\n  }\n  return $self->{'taxon'};\n}\n\n=head2 contact()\n\n Usage   : $obj->contact($newval)\n Function: \n Example : \n Returns : a Bio::Expression::Contact object\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub contact {\n  my($self,$val) = @_;\n  $self->{'contact'} = $val if defined($val);\n  return $self->{'contact'};\n}\n\n=head2 db()\n\n Usage   : $obj->db($newval)\n Function: \n Example : \n Returns : value of db (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","label":"db($self,$val)"},"containerName":"main::","definition":"sub","line":217,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"db","line":218,"kind":13},{"containerName":"db","name":"$val","line":218,"kind":13},{"line":219,"kind":13,"containerName":"db","name":"$self"},{"line":219,"kind":13,"name":"$val","containerName":"db"},{"containerName":"db","name":"$val","kind":13,"line":219},{"containerName":"db","name":"$self","line":220,"kind":13}],"kind":12},{"children":[{"kind":13,"line":235,"containerName":"_taxon_id","name":"$self","definition":"my","localvar":"my"},{"line":235,"kind":13,"name":"$val","containerName":"_taxon_id"},{"line":236,"kind":13,"containerName":"_taxon_id","name":"$self"},{"name":"$val","containerName":"_taxon_id","line":236,"kind":13},{"kind":13,"line":236,"containerName":"_taxon_id","name":"$val"},{"name":"$self","containerName":"_taxon_id","line":237,"kind":13}],"line":234,"kind":12,"signature":{"label":"_taxon_id($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 taxon()\n\n Usage   : $obj->taxon()\n Function: \n Example : \n Returns : A Bio::Taxonomy::Node object\n Args    : none\n\n\n\nsub taxon {\n  my($self) = @_;\n  if ( ! $self->{'taxon'} ) {\n    $self->{'taxon'} = $self->taxdb->get_Taxonomy_Node( $self->_taxon_id() );\n  }\n  return $self->{'taxon'};\n}\n\n=head2 contact()\n\n Usage   : $obj->contact($newval)\n Function: \n Example : \n Returns : a Bio::Expression::Contact object\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub contact {\n  my($self,$val) = @_;\n  $self->{'contact'} = $val if defined($val);\n  return $self->{'contact'};\n}\n\n=head2 db()\n\n Usage   : $obj->db($newval)\n Function: \n Example : \n Returns : value of db (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub db {\n  my($self,$val) = @_;\n  $self->{'db'} = $val if defined($val);\n  return $self->{'db'};\n}\n\n=head2 _taxon_id()\n\n Usage   : $obj->_taxon_id($newval)\n Function: \n Example : \n Returns : value of _taxon_id (a scalar)\n Args    : on set, new value (a scalar or undef, optional)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","range":{"start":{"line":234,"character":0},"end":{"character":9999,"line":238}},"name":"_taxon_id"},{"kind":12,"children":[{"line":252,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"taxdb"},{"containerName":"taxdb","name":"$val","kind":13,"line":252},{"line":253,"kind":13,"name":"$self","containerName":"taxdb"},{"name":"$val","containerName":"taxdb","line":253,"kind":13},{"kind":13,"line":253,"containerName":"taxdb","name":"$val"},{"containerName":"taxdb","name":"$self","kind":13,"line":254}],"line":251,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Platform.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Expression::Platform\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::Platform - DESCRIPTION of Object\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Expression::Platform;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Bio::DB::Taxonomy;\n\n=head2 new()\n\n Usage   : my $obj = Bio::Expression::Platform->new();\n Function: Builds a new Bio::Expression::Platform object \n Returns : an instance of Bio::Expression::Platform\n Args    :\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize()\n\n Usage   : $obj->_initialize(%arg);\n Function: Internal method to initialize a new Bio::Expression::Platform object\n Returns : true on success\n Args    : passed through to new()\n\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  foreach my $arg (keys %arg){\n    my $marg = $arg;\n    $marg =~ s/^-//;\n    $self->$marg($arg{$arg}) if $self->can($marg);\n  }\n\n  $self->taxdb( Bio::DB::Taxonomy->new(-source => 'entrez') );\n  return 1;\n}\n\n\n\n=head2 get_datasets()\n\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub get_datasets {\n  my ($self,@args) = @_;\n  my $db = $self->db();\n\n  my @datasets = $db->get_datasets( $self );\n\n  return @datasets;\n}\n\n=head2 accession()\n\n Usage   : $obj->accession($newval)\n Function: \n Example : \n Returns : value of accession (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub accession {\n  my($self,$val) = @_;\n  $self->{'accession'} = $val if defined($val);\n  return $self->{'accession'};\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: \n Example : \n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 taxon()\n\n Usage   : $obj->taxon()\n Function: \n Example : \n Returns : A Bio::Taxonomy::Node object\n Args    : none\n\n\n\nsub taxon {\n  my($self) = @_;\n  if ( ! $self->{'taxon'} ) {\n    $self->{'taxon'} = $self->taxdb->get_Taxonomy_Node( $self->_taxon_id() );\n  }\n  return $self->{'taxon'};\n}\n\n=head2 contact()\n\n Usage   : $obj->contact($newval)\n Function: \n Example : \n Returns : a Bio::Expression::Contact object\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub contact {\n  my($self,$val) = @_;\n  $self->{'contact'} = $val if defined($val);\n  return $self->{'contact'};\n}\n\n=head2 db()\n\n Usage   : $obj->db($newval)\n Function: \n Example : \n Returns : value of db (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub db {\n  my($self,$val) = @_;\n  $self->{'db'} = $val if defined($val);\n  return $self->{'db'};\n}\n\n=head2 _taxon_id()\n\n Usage   : $obj->_taxon_id($newval)\n Function: \n Example : \n Returns : value of _taxon_id (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub _taxon_id {\n  my($self,$val) = @_;\n  $self->{'_taxon_id'} = $val if defined($val);\n  return $self->{'_taxon_id'};\n}\n\n=head2 taxdb()\n\n Usage   : $obj->taxdb($newval)\n Function: \n Example : \n Returns : a Bio::DB::Taxonomy object\n Args    : on set, new value (a scalar or undef, optional)","label":"taxdb($self,$val)"},"detail":"($self,$val)","name":"taxdb","range":{"start":{"line":251,"character":0},"end":{"line":255,"character":9999}}}]}