{"version":5,"vars":[{"containerName":"","name":"vars","kind":2,"line":74},{"line":76,"kind":2,"name":"base","containerName":""},{"containerName":null,"name":"%DRIVERS","kind":13,"line":79},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"line":83,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":83},{"line":84,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"kind":13,"line":84,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","line":84,"kind":13},{"kind":13,"line":85,"containerName":"new","name":"$self"}],"line":82,"name":"new","range":{"end":{"character":9999,"line":86},"start":{"character":0,"line":82}}},{"name":"SUPER","containerName":"new","line":84,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"register_driver($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string)."},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":104,"containerName":"register_driver","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"register_driver","kind":13,"line":104},{"line":105,"kind":13,"localvar":"my","containerName":"register_driver","name":"%drivers","definition":"my"},{"containerName":"register_driver","name":"@args","line":105,"kind":13},{"line":107,"kind":13,"localvar":"my","containerName":"register_driver","name":"$drv","definition":"my"},{"name":"%drivers","containerName":"register_driver","line":107,"kind":13},{"containerName":"register_driver","name":"$self","line":109,"kind":13},{"kind":12,"line":109,"name":"driver_table","containerName":"register_driver"},{"kind":13,"line":109,"containerName":"register_driver","name":"$drv"},{"kind":13,"line":109,"containerName":"register_driver","name":"$drivers"},{"name":"$drv","containerName":"register_driver","line":109,"kind":13}],"line":103,"name":"register_driver","range":{"end":{"line":111,"character":9999},"start":{"line":103,"character":0}}},{"definition":"sub","containerName":"main::","signature":{"label":"driver_table($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : "},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":140,"name":"$self","definition":"my","containerName":"driver_table","localvar":"my"},{"name":"@args","containerName":"driver_table","line":140,"kind":13},{"name":"%DRIVERS","containerName":"driver_table","line":142,"kind":13}],"line":139,"name":"driver_table","range":{"start":{"character":0,"line":139},"end":{"line":143,"character":9999}}},{"detail":"($self,$key)","signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : \n\n\n\nsub driver_table {\n    my ($self, @args) = @_;\n\n    return \\%DRIVERS;\n}\n\n=head2 get_driver\n\n Title   : get_driver\n Usage   : $module = $factory->get_driver(\"genscan\");\n Function: Returns the module implementing a driver registered under the\n           given key.\n Example : \n Returns : A string.\n Args    : Key of the driver (string).","label":"get_driver($self,$key)"},"containerName":"main::","definition":"sub","line":157,"children":[{"line":158,"kind":13,"localvar":"my","containerName":"get_driver","definition":"my","name":"$self"},{"containerName":"get_driver","name":"$key","kind":13,"line":158},{"kind":13,"line":160,"name":"$self","containerName":"get_driver"},{"line":160,"kind":12,"containerName":"get_driver","name":"driver_table"},{"name":"$key","containerName":"get_driver","line":160,"kind":13},{"containerName":"get_driver","name":"$self","kind":13,"line":161},{"containerName":"get_driver","name":"driver_table","line":161,"kind":12},{"line":161,"kind":13,"name":"$key","containerName":"get_driver"}],"kind":12,"range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":164}},"name":"get_driver"},{"name":"_load_module","range":{"end":{"line":192,"character":9999},"start":{"character":0,"line":177}},"kind":12,"children":[{"line":178,"kind":13,"localvar":"my","containerName":"_load_module","definition":"my","name":"$self"},{"kind":13,"line":178,"name":"$name","containerName":"_load_module"},{"containerName":"_load_module","definition":"my","name":"$module","localvar":"my","kind":13,"line":179},{"name":"$load","containerName":"_load_module","kind":13,"line":179},{"containerName":"_load_module","name":"$m","kind":13,"line":179},{"containerName":"_load_module","name":"$module","kind":13,"line":180},{"kind":13,"line":181,"containerName":"_load_module","name":"$main"},{"containerName":"_load_module","name":"$module","kind":13,"line":181},{"line":182,"kind":13,"containerName":"_load_module","name":"$load"},{"name":"$load","containerName":"_load_module","line":184,"kind":13},{"kind":12,"line":184,"containerName":"_load_module","name":"catfile"},{"name":"$load","containerName":"_load_module","kind":13,"line":184},{"name":"$load","containerName":"_load_module","line":186,"kind":13},{"line":189,"kind":13,"name":"$self","containerName":"_load_module"},{"name":"throw","containerName":"_load_module","kind":12,"line":189}],"line":177,"definition":"sub","containerName":"main::","signature":{"label":"_load_module($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : \n\n\n\nsub driver_table {\n    my ($self, @args) = @_;\n\n    return \\%DRIVERS;\n}\n\n=head2 get_driver\n\n Title   : get_driver\n Usage   : $module = $factory->get_driver(\"genscan\");\n Function: Returns the module implementing a driver registered under the\n           given key.\n Example : \n Returns : A string.\n Args    : Key of the driver (string).\n\n\nsub get_driver {\n    my ($self, $key) = @_;\n\n    if(exists($self->driver_table()->{$key})) {\n\treturn $self->driver_table()->{$key};\n    }\n    return;\n}\n\n=head2 _load_module\n\n Title   : _load_module\n Usage   : $self->_load_module(\"Bio::Tools::Genscan\");\n Function: Loads up (like use) a module at run time on demand.\n Example : \n Returns : TRUE on success\n Args    :"},"detail":"($self,$name)"},{"line":184,"kind":12,"name":"File","containerName":"Spec"}]}