{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":102},{"name":"new","range":{"start":{"line":118,"character":0},"end":{"line":130,"character":9999}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: ObjectFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::ObjectFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::ObjectFactory - Instantiates a new Bio::Root::RootI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Factory::ObjectFactory;\n\n    my $factory = Bio::Factory::ObjectFactory->new(-type => 'Bio::Ontology::GOterm');\n    my $term = $factory->create_object(-name => 'peroxisome',\n                                       -ontology => 'Gene Factory',\n                                       -identifier => 'GO:0005777');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::Root::RootI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::ObjectFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::ObjectFactory->new();\n Function: Builds a new Bio::Factory::ObjectFactory object \n Returns : Bio::Factory::ObjectFactory\n Args    : -type      => string, name of a L<Bio::Root::RootI> derived class.\n                         There is no default.\n           -interface => string, name of the interface or class any type\n                         specified needs to at least implement.\n                         The default is Bio::Root::RootI.","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":118,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":119},{"name":"@args","containerName":"new","line":119,"kind":13},{"line":121,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"name":"$class","containerName":"new","line":121,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":121},{"kind":13,"line":123,"name":"$type","definition":"my","containerName":"new","localvar":"my"},{"line":123,"kind":13,"name":"$interface","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":123},{"containerName":"new","name":"_rearrange","kind":12,"line":123},{"name":"@args","containerName":"new","kind":13,"line":123},{"containerName":"new","name":"$self","kind":13,"line":125},{"line":126,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"interface","line":126,"kind":12},{"containerName":"new","name":"$interface","kind":13,"line":126},{"kind":13,"line":127,"name":"$self","containerName":"new"},{"line":127,"kind":12,"name":"type","containerName":"new"},{"containerName":"new","name":"$type","line":127,"kind":13},{"name":"$type","containerName":"new","kind":13,"line":127},{"kind":13,"line":129,"name":"$self","containerName":"new"}]},{"containerName":"new","name":"SUPER","line":121,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"create_object($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ObjectFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::ObjectFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::ObjectFactory - Instantiates a new Bio::Root::RootI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Factory::ObjectFactory;\n\n    my $factory = Bio::Factory::ObjectFactory->new(-type => 'Bio::Ontology::GOterm');\n    my $term = $factory->create_object(-name => 'peroxisome',\n                                       -ontology => 'Gene Factory',\n                                       -identifier => 'GO:0005777');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::Root::RootI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::ObjectFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::ObjectFactory->new();\n Function: Builds a new Bio::Factory::ObjectFactory object \n Returns : Bio::Factory::ObjectFactory\n Args    : -type      => string, name of a L<Bio::Root::RootI> derived class.\n                         There is no default.\n           -interface => string, name of the interface or class any type\n                         specified needs to at least implement.\n                         The default is Bio::Root::RootI.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type,$interface) = $self->_rearrange([qw(TYPE INTERFACE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->interface($interface || \"Bio::Root::RootI\");\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates a new object of the previously set type.\n\n           This object allows us to genericize the instantiation of\n           objects.\n\n           You must have provided -type at instantiation, or have\n           called type($mytype) before you can call this method.\n\n Returns : an object of the type returned by type()\n\n           The return type is configurable using new(-type =>\"...\"),\n           or by calling $self->type(\"My::Fancy::Class\").\n Args    : Initialization parameters specific to the type of\n           object we want. Check the POD of the class you set as type."},"kind":12,"line":154,"children":[{"line":155,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"create_object"},{"name":"@args","containerName":"create_object","line":155,"kind":13},{"kind":13,"line":157,"name":"$type","definition":"my","containerName":"create_object","localvar":"my"},{"name":"$self","containerName":"create_object","kind":13,"line":157},{"name":"type","containerName":"create_object","kind":12,"line":157},{"line":158,"kind":13,"containerName":"create_object","name":"$type"},{"containerName":"create_object","name":"new","line":158,"kind":12},{"name":"$self","containerName":"create_object","line":158,"kind":13},{"containerName":"create_object","name":"verbose","line":158,"kind":12},{"containerName":"create_object","name":"@args","line":158,"kind":13}],"name":"create_object","range":{"end":{"line":159,"character":9999},"start":{"line":154,"character":0}}},{"range":{"start":{"character":0,"line":176},"end":{"character":9999,"line":198}},"containerName":"main::","definition":"sub","name":"type","line":176,"children":[{"kind":13,"line":177,"containerName":"type","name":"$self","definition":"my","localvar":"my"},{"line":180,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"type"},{"name":"$type","containerName":"type","kind":13,"line":181},{"name":"$self","containerName":"type","line":181,"kind":13},{"containerName":"type","name":"$type","line":181,"kind":13},{"kind":13,"line":183,"name":"$self","containerName":"type"},{"containerName":"type","name":"_load_module","line":183,"kind":12},{"containerName":"type","name":"$type","line":183,"kind":13},{"kind":13,"line":186,"name":"$self","containerName":"type"},{"kind":12,"line":186,"containerName":"type","name":"throw"},{"line":189,"kind":13,"localvar":"my","containerName":"type","name":"$o","definition":"my"},{"name":"$type","containerName":"type","kind":13,"line":189},{"containerName":"type","name":"$self","line":190,"kind":13},{"line":190,"kind":12,"containerName":"type","name":"_validate_type"},{"kind":13,"line":190,"containerName":"type","name":"$o"},{"name":"$self","containerName":"type","line":191,"kind":13},{"kind":12,"line":191,"containerName":"type","name":"throw"},{"kind":13,"line":191,"name":"$self","containerName":"type"},{"kind":13,"line":193,"containerName":"type","name":"$self"},{"kind":13,"line":193,"containerName":"type","name":"$type"},{"line":195,"kind":13,"containerName":"type","name":"$self"},{"containerName":"type","name":"$type","line":195,"kind":13},{"line":197,"kind":13,"name":"$self","containerName":"type"}],"kind":12},{"containerName":"main::","definition":"sub","name":"interface","range":{"start":{"character":0,"line":213},"end":{"character":9999,"line":221}},"kind":12,"line":213,"children":[{"line":214,"kind":13,"localvar":"my","containerName":"interface","definition":"my","name":"$self"},{"containerName":"interface","name":"$interface","definition":"my","localvar":"my","kind":13,"line":215},{"kind":13,"line":217,"containerName":"interface","name":"$interface"},{"name":"$self","containerName":"interface","line":218,"kind":13},{"name":"$interface","containerName":"interface","kind":13,"line":218},{"kind":13,"line":220,"containerName":"interface","name":"$self"}]},{"range":{"start":{"character":0,"line":249},"end":{"character":9999,"line":257}},"name":"_validate_type","children":[{"localvar":"my","containerName":"_validate_type","name":"$self","definition":"my","line":250,"kind":13},{"kind":13,"line":250,"name":"$obj","containerName":"_validate_type"},{"name":"$obj","containerName":"_validate_type","kind":13,"line":252},{"containerName":"_validate_type","name":"isa","kind":12,"line":252},{"line":252,"kind":13,"name":"$self","containerName":"_validate_type"},{"name":"interface","containerName":"_validate_type","kind":12,"line":252},{"containerName":"_validate_type","name":"$self","kind":13,"line":253},{"containerName":"_validate_type","name":"throw","line":253,"kind":12},{"name":"$obj","containerName":"_validate_type","line":253,"kind":13},{"containerName":"_validate_type","name":"$self","kind":13,"line":254},{"kind":12,"line":254,"containerName":"_validate_type","name":"interface"}],"line":249,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$obj"}],"documentation":"1;\n# $Id: ObjectFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::ObjectFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::ObjectFactory - Instantiates a new Bio::Root::RootI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Factory::ObjectFactory;\n\n    my $factory = Bio::Factory::ObjectFactory->new(-type => 'Bio::Ontology::GOterm');\n    my $term = $factory->create_object(-name => 'peroxisome',\n                                       -ontology => 'Gene Factory',\n                                       -identifier => 'GO:0005777');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::Root::RootI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::ObjectFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::ObjectFactory->new();\n Function: Builds a new Bio::Factory::ObjectFactory object \n Returns : Bio::Factory::ObjectFactory\n Args    : -type      => string, name of a L<Bio::Root::RootI> derived class.\n                         There is no default.\n           -interface => string, name of the interface or class any type\n                         specified needs to at least implement.\n                         The default is Bio::Root::RootI.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type,$interface) = $self->_rearrange([qw(TYPE INTERFACE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->interface($interface || \"Bio::Root::RootI\");\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates a new object of the previously set type.\n\n           This object allows us to genericize the instantiation of\n           objects.\n\n           You must have provided -type at instantiation, or have\n           called type($mytype) before you can call this method.\n\n Returns : an object of the type returned by type()\n\n           The return type is configurable using new(-type =>\"...\"),\n           or by calling $self->type(\"My::Fancy::Class\").\n Args    : Initialization parameters specific to the type of\n           object we want. Check the POD of the class you set as type.\n\n\nsub create_object {\n   my ($self,@args) = @_;\n\n   my $type = $self->type(); # type has already been loaded upon set\n   return $type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $obj->type($newval)\n Function: Get/set the type of object to be created.\n\n           This may be changed at any time during the lifetime of this\n           factory.\n\n Returns : value of type (a string)\n Args    : newvalue (optional, a string)\n\n\n\nsub type{\n    my $self = shift;\n\n    if(@_) {\n\tmy $type = shift;\n\tif($type && (! $self->{'_loaded_types'}->{$type})) {\n\t    eval {\n\t\t$self->_load_module($type);\n\t    };\n\t    if( $@ ) {\n\t\t$self->throw(\"module for '$type' failed to load: \".\n\t\t\t     $@);\n\t    }\n\t    my $o = bless {},$type;\n\t    if(!$self->_validate_type($o)) { # this may throw an exception\n\t\t$self->throw(\"'$type' is not valid for factory \".ref($self));\n\t    }\n\t    $self->{'_loaded_types'}->{$type} = 1;\n\t}\n\treturn $self->{'type'} = $type;\n    }\n    return $self->{'type'};\n}\n\n=head2 interface\n\n Title   : interface\n Usage   : $obj->interface($newval)\n Function: Get/set the interface or base class that supplied types\n           must at least implement (inherit from).\n Example : \n Returns : value of interface (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub interface{\n    my $self = shift;\n    my $interface = shift;\n\n    if($interface) {\n\treturn $self->{'interface'} = $interface;\n    }\n    return $self->{'interface'};\n}\n\n=head2 _validate_type\n\n Title   : _validate_type\n Usage   : $factory->_validate_type($object)\n Function: Called to let derived factories validate the type set\n           via type().\n\n           The default implementation here checks whether the supplied\n           object skeleton implements the interface set via -interface\n           upon factory instantiation.\n\n Example :\n Returns : TRUE if the type is to be considered valid, and FALSE otherwise.\n           Instead of returning FALSE this method may also just throw\n           an informative exception.\n\n           The default implementation here will throw an exception\n           if the supplied object does not inherit from the interface\n           provided by the interface() method.\n\n Args    : A hash reference blessed into the specified type, allowing\n           queries like isa().","label":"_validate_type($self,$obj)"},"detail":"($self,$obj)","definition":"sub","containerName":"main::"}]}