{"vars":[{"containerName":"","name":"Fcntl","line":87,"kind":2},{"name":"vars","containerName":"","line":88,"kind":2},{"name":"base","containerName":"","kind":2,"line":95},{"line":99,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%func"},{"kind":12,"line":100,"name":"strict"},{"kind":13,"line":101,"name":"$field","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%func","kind":13,"line":103},{"name":"$self","definition":"my","containerName":null,"localvar":"my","kind":13,"line":104},{"containerName":null,"name":"$value","kind":13,"line":104},{"line":106,"kind":13,"name":"%value","containerName":null},{"kind":13,"line":107,"name":"%self","containerName":null},{"line":107,"kind":13,"containerName":null,"name":"$field"},{"kind":13,"line":107,"name":"$value","containerName":null},{"containerName":null,"name":"%self","line":109,"kind":13},{"containerName":null,"name":"$field","kind":13,"line":109},{"name":"new","range":{"start":{"character":0,"line":136},"end":{"line":164,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#\n# $Id: Abstract.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#          and James Gilbert <jgrg@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Abstract - Abstract interface for indexing a flat file\n\n=head1 SYNOPSIS\n\nYou should not be using this module directly\n\n=head1 USING DB_FILE\n\nTo use DB_File and not SDBM for this index, pass the value:\n\n    -dbm_package => 'DB_File'\n\nto new (see below).\n\n=head1 DESCRIPTION\n\nThis object provides the basic mechanism to associate positions\nin files with names. The position and filenames are stored in DBM\nwhich can then be accessed later on. It is the equivalent of flat\nfile indexing (eg, SRS or efetch).\n\nThis object is the guts to the mechanism, which will be used by the\nspecific objects inheriting from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, James Gilbert\n\nEmail - birney@sanger.ac.uk, jgrg@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with an \"_\" (underscore).\n\n\n\n# Let the code begin...\n\npackage Bio::Index::Abstract;\n\nuse strict;\nuse Fcntl qw( O_RDWR O_CREAT O_RDONLY );\nuse vars qw( $TYPE_AND_VERSION_KEY\n             $USE_DBM_TYPE $DB_HASH );\n\n\nuse Bio::Root::IO;\nuse Symbol;\n\nuse base qw(Bio::Root::Root);\n\n# Generate accessor methods for simple object fields\nBEGIN {\n\tforeach my $func (qw(filename write_flag)) {\n\t\tno strict 'refs';\n\t\tmy $field = \"_$func\";\n\n\t\t*$func = sub {\n\t\t\tmy( $self, $value ) = @_;\n\n\t\t\tif (defined $value) {\n\t\t\t\t$self->{$field} = $value;\n\t\t\t}\n\t\t\treturn $self->{$field};\n\t\t}\n\t}\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE."},"detail":"($class,@args)","kind":12,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":137,"kind":13},{"kind":13,"line":137,"name":"@args","containerName":"new"},{"line":138,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","line":138,"kind":13},{"kind":13,"line":138,"containerName":"new","name":"@args"},{"kind":13,"line":139,"containerName":"new","definition":"my","name":"$filename","localvar":"my"},{"name":"$write_flag","containerName":"new","line":139,"kind":13},{"name":"$dbm_package","containerName":"new","kind":13,"line":139},{"name":"$cachesize","containerName":"new","line":139,"kind":13},{"line":139,"kind":13,"name":"$ffactor","containerName":"new"},{"line":139,"kind":13,"containerName":"new","name":"$pathtype"},{"line":140,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":140,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","line":146,"kind":13},{"containerName":"new","name":"$self","line":149,"kind":13},{"name":"filename","containerName":"new","kind":12,"line":149},{"kind":13,"line":149,"containerName":"new","name":"$filename"},{"line":149,"kind":13,"name":"$filename","containerName":"new"},{"kind":13,"line":150,"name":"$self","containerName":"new"},{"containerName":"new","name":"cachesize","line":150,"kind":12},{"name":"$cachesize","containerName":"new","line":150,"kind":13},{"kind":13,"line":150,"containerName":"new","name":"$cachesize"},{"line":151,"kind":13,"containerName":"new","name":"$self"},{"line":151,"kind":12,"containerName":"new","name":"ffactor"},{"containerName":"new","name":"$ffactor","kind":13,"line":151},{"containerName":"new","name":"$ffactor","line":151,"kind":13},{"containerName":"new","name":"$self","line":152,"kind":13},{"name":"write_flag","containerName":"new","line":152,"kind":12},{"containerName":"new","name":"$write_flag","kind":13,"line":152},{"containerName":"new","name":"$write_flag","line":152,"kind":13},{"line":153,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":153,"containerName":"new","name":"dbm_package"},{"name":"$dbm_package","containerName":"new","line":153,"kind":13},{"line":153,"kind":13,"containerName":"new","name":"$dbm_package"},{"containerName":"new","name":"$pathtype","line":156,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":156},{"kind":12,"line":156,"containerName":"new","name":"pathtype"},{"line":156,"kind":13,"containerName":"new","name":"$pathtype"},{"name":"$self","containerName":"new","kind":13,"line":156},{"name":"pathtype","containerName":"new","line":156,"kind":12},{"containerName":"new","name":"$self","kind":13,"line":158},{"name":"$self","containerName":"new","line":159,"kind":13},{"containerName":"new","name":"$self","line":162,"kind":13},{"name":"open_dbm","containerName":"new","line":162,"kind":12},{"kind":13,"line":162,"containerName":"new","name":"$filename"},{"kind":13,"line":163,"name":"$self","containerName":"new"}],"line":136},{"line":138,"kind":12,"name":"SUPER","containerName":"new"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"dbm_package","line":210,"kind":13},{"line":210,"kind":13,"name":"$value","containerName":"dbm_package"},{"name":"$to_require","definition":"my","containerName":"dbm_package","localvar":"my","kind":13,"line":211},{"line":212,"kind":13,"name":"$value","containerName":"dbm_package"},{"name":"$self","containerName":"dbm_package","line":212,"kind":13},{"localvar":"my","name":"$type","definition":"my","containerName":"dbm_package","line":213,"kind":13},{"name":"$value","containerName":"dbm_package","kind":13,"line":213},{"line":213,"kind":13,"name":"$USE_DBM_TYPE","containerName":"dbm_package"},{"name":"$type","containerName":"dbm_package","kind":13,"line":214},{"containerName":"dbm_package","name":"$type","kind":13,"line":218},{"line":220,"kind":13,"containerName":"dbm_package","name":"$type"},{"line":222,"kind":13,"containerName":"dbm_package","name":"$self"},{"kind":12,"line":222,"containerName":"dbm_package","name":"throw"},{"line":224,"kind":13,"name":"$self","containerName":"dbm_package"},{"containerName":"dbm_package","name":"$type","kind":13,"line":224},{"name":"$USE_DBM_TYPE","containerName":"dbm_package","kind":13,"line":225},{"kind":13,"line":226,"name":"$USE_DBM_TYPE","containerName":"dbm_package"},{"name":"$self","containerName":"dbm_package","kind":13,"line":226},{"containerName":"dbm_package","name":"$self","line":229,"kind":13}],"line":209,"definition":"sub","containerName":"main::","signature":{"label":"dbm_package($self,$value)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","name":"dbm_package","range":{"start":{"character":0,"line":209},"end":{"character":9999,"line":230}}},{"range":{"end":{"line":249,"character":9999},"start":{"line":247,"character":0}},"containerName":"main::","name":"db","definition":"sub","line":247,"children":[],"kind":12},{"kind":12,"line":286,"children":[{"line":287,"kind":13,"localvar":"my","containerName":"get_stream","definition":"my","name":"$self"},{"containerName":"get_stream","name":"$id","kind":13,"line":287},{"kind":13,"line":289,"name":"$desc","definition":"my","containerName":"get_stream","localvar":"my"},{"kind":13,"line":289,"containerName":"get_stream","name":"$acc"},{"containerName":"get_stream","name":"$out","line":289,"kind":13},{"localvar":"my","containerName":"get_stream","definition":"my","name":"$db","line":290,"kind":13},{"kind":13,"line":290,"name":"$self","containerName":"get_stream"},{"containerName":"get_stream","name":"db","line":290,"kind":12},{"localvar":"my","containerName":"get_stream","definition":"my","name":"$rec","line":292,"kind":13},{"kind":13,"line":292,"name":"$db","containerName":"get_stream"},{"kind":13,"line":292,"name":"$id","containerName":"get_stream"},{"kind":13,"line":293,"containerName":"get_stream","definition":"my","name":"@record","localvar":"my"},{"kind":13,"line":295,"containerName":"get_stream","definition":"my","name":"$file","localvar":"my"},{"kind":13,"line":295,"name":"$begin","containerName":"get_stream"},{"name":"$end","containerName":"get_stream","kind":13,"line":295},{"line":295,"kind":13,"name":"$self","containerName":"get_stream"},{"kind":12,"line":295,"containerName":"get_stream","name":"unpack_record"},{"kind":13,"line":295,"name":"$rec","containerName":"get_stream"},{"kind":13,"line":298,"name":"$fh","definition":"my","containerName":"get_stream","localvar":"my"},{"kind":13,"line":298,"containerName":"get_stream","name":"$self"},{"containerName":"get_stream","name":"_file_handle","kind":12,"line":298},{"kind":13,"line":298,"containerName":"get_stream","name":"$file"},{"name":"$fh","containerName":"get_stream","kind":13,"line":301},{"name":"$begin","containerName":"get_stream","line":301,"kind":13},{"name":"$fh","containerName":"get_stream","kind":13,"line":303},{"line":305,"kind":13,"name":"$self","containerName":"get_stream"},{"kind":12,"line":305,"name":"throw","containerName":"get_stream"}],"containerName":"main::","definition":"sub","detail":"($self,$id)","signature":{"label":"get_stream($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n'"},"name":"get_stream","range":{"end":{"line":307,"character":9999},"start":{"character":0,"line":286}}},{"range":{"start":{"character":0,"line":320},"end":{"line":327,"character":9999}},"name":"cachesize","signature":{"parameters":[{"label":"$self"},{"label":"$size"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache","label":"cachesize($self,$size)"},"detail":"($self,$size)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":321,"containerName":"cachesize","name":"$self","definition":"my","localvar":"my"},{"containerName":"cachesize","name":"$size","line":321,"kind":13},{"line":323,"kind":13,"name":"$size","containerName":"cachesize"},{"name":"$self","containerName":"cachesize","kind":13,"line":324},{"line":324,"kind":13,"name":"$size","containerName":"cachesize"},{"kind":13,"line":326,"name":"$self","containerName":"cachesize"}],"line":320,"kind":12},{"range":{"end":{"line":348,"character":9999},"start":{"character":0,"line":341}},"name":"ffactor","signature":{"label":"ffactor($self,$size)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache","parameters":[{"label":"$self"},{"label":"$size"}]},"detail":"($self,$size)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":342,"containerName":"ffactor","name":"$self","definition":"my","localvar":"my"},{"name":"$size","containerName":"ffactor","kind":13,"line":342},{"name":"$size","containerName":"ffactor","kind":13,"line":344},{"line":345,"kind":13,"name":"$self","containerName":"ffactor"},{"name":"$size","containerName":"ffactor","line":345,"kind":13},{"containerName":"ffactor","name":"$self","kind":13,"line":347}],"line":341,"kind":12},{"name":"open_dbm","range":{"end":{"line":421,"character":9999},"start":{"line":367,"character":0}},"kind":12,"line":367,"children":[{"containerName":"open_dbm","definition":"my","name":"$self","localvar":"my","kind":13,"line":368},{"line":370,"kind":13,"localvar":"my","name":"$filename","definition":"my","containerName":"open_dbm"},{"name":"$self","containerName":"open_dbm","kind":13,"line":370},{"line":370,"kind":12,"containerName":"open_dbm","name":"filename"},{"containerName":"open_dbm","name":"$self","kind":13,"line":371},{"line":371,"kind":12,"name":"throw","containerName":"open_dbm"},{"kind":13,"line":373,"containerName":"open_dbm","definition":"my","name":"$db","localvar":"my"},{"containerName":"open_dbm","name":"$self","kind":13,"line":373},{"line":373,"kind":12,"name":"db","containerName":"open_dbm"},{"line":377,"kind":13,"containerName":"open_dbm","name":"$db"},{"name":"$db","containerName":"open_dbm","line":378,"kind":13},{"line":382,"kind":13,"localvar":"my","containerName":"open_dbm","name":"$dbm_type","definition":"my"},{"containerName":"open_dbm","name":"$self","kind":13,"line":382},{"kind":12,"line":382,"containerName":"open_dbm","name":"dbm_package"},{"line":385,"kind":13,"localvar":"my","containerName":"open_dbm","definition":"my","name":"$mode_flags"},{"name":"$self","containerName":"open_dbm","kind":13,"line":385},{"kind":12,"line":385,"name":"write_flag","containerName":"open_dbm"},{"kind":13,"line":388,"name":"$dbm_type","containerName":"open_dbm"},{"localvar":"my","containerName":"open_dbm","name":"$hash_inf","definition":"my","line":389,"kind":13},{"name":"new","containerName":"open_dbm","kind":12,"line":389},{"localvar":"my","containerName":"open_dbm","name":"$cache","definition":"my","line":390,"kind":13},{"containerName":"open_dbm","name":"$self","line":390,"kind":13},{"name":"cachesize","containerName":"open_dbm","line":390,"kind":12},{"containerName":"open_dbm","definition":"my","name":"$ffactor","localvar":"my","kind":13,"line":391},{"name":"$self","containerName":"open_dbm","kind":13,"line":391},{"line":391,"kind":12,"name":"ffactor","containerName":"open_dbm"},{"name":"$cache","containerName":"open_dbm","kind":13,"line":392},{"containerName":"open_dbm","name":"$hash_inf","line":393,"kind":13},{"line":393,"kind":13,"containerName":"open_dbm","name":"$cache"},{"line":395,"kind":13,"name":"$ffactor","containerName":"open_dbm"},{"containerName":"open_dbm","name":"$hash_inf","line":396,"kind":13},{"name":"$ffactor","containerName":"open_dbm","kind":13,"line":396},{"name":"$dbm_type","containerName":"open_dbm","line":398,"kind":13},{"line":398,"kind":13,"containerName":"open_dbm","name":"$filename"},{"kind":13,"line":398,"name":"$mode_flags","containerName":"open_dbm"},{"kind":13,"line":398,"containerName":"open_dbm","name":"$hash_inf"},{"line":399,"kind":13,"containerName":"open_dbm","name":"$self"},{"containerName":"open_dbm","name":"throw","line":399,"kind":12},{"containerName":"open_dbm","name":"$dbm_type","kind":13,"line":401},{"kind":13,"line":401,"name":"$filename","containerName":"open_dbm"},{"name":"$mode_flags","containerName":"open_dbm","kind":13,"line":401},{"containerName":"open_dbm","name":"$self","line":402,"kind":13},{"line":402,"kind":12,"containerName":"open_dbm","name":"throw"},{"containerName":"open_dbm","name":"$self","kind":13,"line":409},{"line":410,"kind":13,"localvar":"my","definition":"my","name":"$pkg","containerName":"open_dbm"},{"kind":13,"line":410,"name":"$self","containerName":"open_dbm"},{"containerName":"open_dbm","name":"_code_base","line":410,"kind":12},{"containerName":"open_dbm","name":"$self","kind":13,"line":411},{"line":411,"kind":13,"containerName":"open_dbm","name":"$pkg"},{"line":415,"kind":13,"containerName":"open_dbm","name":"$self"},{"containerName":"open_dbm","name":"_type_and_version","kind":12,"line":415},{"kind":13,"line":418,"containerName":"open_dbm","name":"$self"},{"name":"_check_file_sizes","containerName":"open_dbm","kind":12,"line":418}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success","parameters":[{"label":"$self"}],"label":"open_dbm($self)"}},{"kind":12,"line":385,"name":"O_RDWR"},{"name":"O_CREAT","kind":12,"line":385},{"kind":12,"line":385,"name":"O_RDONLY"},{"line":389,"kind":12,"containerName":"HASHINFO","name":"DB_File"},{"range":{"end":{"character":9999,"line":440},"start":{"character":0,"line":437}},"containerName":"main::","name":"_version","definition":"sub","line":437,"children":[{"containerName":"_version","name":"$self","definition":"my","localvar":"my","kind":13,"line":438},{"containerName":"_version","name":"$self","kind":13,"line":439},{"kind":12,"line":439,"containerName":"_version","name":"throw"}],"kind":12},{"name":"_code_base","range":{"start":{"character":0,"line":454},"end":{"character":9999,"line":467}},"kind":12,"children":[{"containerName":"_code_base","definition":"my","name":"$self","localvar":"my","kind":13,"line":455},{"containerName":"_code_base","definition":"my","name":"$code_key","localvar":"my","kind":13,"line":456},{"containerName":"_code_base","name":"$record","definition":"my","localvar":"my","kind":13,"line":457},{"line":459,"kind":13,"containerName":"_code_base","name":"$record"},{"kind":13,"line":459,"containerName":"_code_base","name":"$self"},{"containerName":"_code_base","name":"db","kind":12,"line":459},{"name":"$code_key","containerName":"_code_base","kind":13,"line":459},{"localvar":"my","containerName":"_code_base","name":"$code","definition":"my","line":461,"kind":13},{"name":"$version","containerName":"_code_base","line":461,"kind":13},{"containerName":"_code_base","name":"$self","kind":13,"line":461},{"kind":12,"line":461,"containerName":"_code_base","name":"unpack_record"},{"name":"$record","containerName":"_code_base","line":461,"kind":13},{"kind":13,"line":463,"name":"$code","containerName":"_code_base"},{"kind":13,"line":463,"containerName":"_code_base","name":"$version"},{"name":"$code","containerName":"_code_base","kind":13,"line":465}],"line":454,"definition":"sub","containerName":"main::","signature":{"label":"_code_base($self)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)"},{"kind":12,"children":[{"line":485,"kind":13,"localvar":"my","containerName":"_type_and_version","name":"$self","definition":"my"},{"kind":13,"line":486,"containerName":"_type_and_version","definition":"my","name":"$key","localvar":"my"},{"kind":13,"line":487,"containerName":"_type_and_version","name":"$version","definition":"my","localvar":"my"},{"kind":13,"line":487,"name":"$self","containerName":"_type_and_version"},{"line":487,"kind":12,"name":"_version","containerName":"_type_and_version"},{"kind":13,"line":488,"containerName":"_type_and_version","definition":"my","name":"$type","localvar":"my"},{"line":488,"kind":13,"name":"$self","containerName":"_type_and_version"},{"containerName":"_type_and_version","definition":"my","name":"$rec","localvar":"my","kind":13,"line":491},{"name":"$self","containerName":"_type_and_version","line":491,"kind":13},{"name":"db","containerName":"_type_and_version","kind":12,"line":491},{"containerName":"_type_and_version","name":"$key","line":491,"kind":13},{"localvar":"my","containerName":"_type_and_version","name":"$db_type","definition":"my","line":492,"kind":13},{"kind":13,"line":492,"containerName":"_type_and_version","name":"$db_version"},{"kind":13,"line":492,"containerName":"_type_and_version","name":"$self"},{"line":492,"kind":12,"name":"unpack_record","containerName":"_type_and_version"},{"line":492,"kind":13,"name":"$rec","containerName":"_type_and_version"},{"name":"$self","containerName":"_type_and_version","kind":13,"line":493},{"kind":12,"line":493,"name":"throw","containerName":"_type_and_version"},{"name":"$db_version","containerName":"_type_and_version","line":494,"kind":13},{"name":"$version","containerName":"_type_and_version","kind":13,"line":494},{"line":495,"kind":13,"name":"$self","containerName":"_type_and_version"},{"kind":12,"line":495,"containerName":"_type_and_version","name":"throw"},{"kind":13,"line":496,"name":"$db_type","containerName":"_type_and_version"},{"containerName":"_type_and_version","name":"$type","line":496,"kind":13},{"kind":13,"line":498,"containerName":"_type_and_version","name":"$self"},{"containerName":"_type_and_version","name":"add_record","kind":12,"line":498},{"containerName":"_type_and_version","name":"$key","line":498,"kind":13},{"line":498,"kind":13,"containerName":"_type_and_version","name":"$type"},{"line":498,"kind":13,"name":"$version","containerName":"_type_and_version"},{"name":"$self","containerName":"_type_and_version","line":499,"kind":13},{"name":"throw","containerName":"_type_and_version","line":499,"kind":12}],"line":484,"definition":"sub","name":"_type_and_version","containerName":"main::","range":{"end":{"character":9999,"line":502},"start":{"line":484,"character":0}}},{"range":{"end":{"line":531,"character":9999},"start":{"character":0,"line":519}},"containerName":"main::","name":"_check_file_sizes","definition":"sub","line":519,"children":[{"kind":13,"line":520,"definition":"my","name":"$self","containerName":"_check_file_sizes","localvar":"my"},{"containerName":"_check_file_sizes","definition":"my","name":"$num","localvar":"my","kind":13,"line":521},{"line":521,"kind":13,"containerName":"_check_file_sizes","name":"$self"},{"kind":12,"line":521,"name":"_file_count","containerName":"_check_file_sizes"},{"line":523,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"_check_file_sizes"},{"line":523,"kind":13,"containerName":"_check_file_sizes","name":"$i"},{"name":"$num","containerName":"_check_file_sizes","kind":13,"line":523},{"name":"$i","containerName":"_check_file_sizes","line":523,"kind":13},{"localvar":"my","definition":"my","name":"$file","containerName":"_check_file_sizes","line":524,"kind":13},{"containerName":"_check_file_sizes","name":"$stored_size","line":524,"kind":13},{"containerName":"_check_file_sizes","name":"$self","kind":13,"line":524},{"line":524,"kind":12,"name":"unpack_record","containerName":"_check_file_sizes"},{"line":524,"kind":13,"name":"$self","containerName":"_check_file_sizes"},{"containerName":"_check_file_sizes","name":"db","line":524,"kind":12},{"name":"$size","definition":"my","containerName":"_check_file_sizes","localvar":"my","kind":13,"line":525},{"name":"$file","containerName":"_check_file_sizes","kind":13,"line":525},{"line":526,"kind":13,"name":"$size","containerName":"_check_file_sizes"},{"containerName":"_check_file_sizes","name":"$stored_size","kind":13,"line":526},{"containerName":"_check_file_sizes","name":"$self","line":527,"kind":13},{"containerName":"_check_file_sizes","name":"throw","line":527,"kind":12}],"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"make_index($self,@files)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES","parameters":[{"label":"$self"},{"label":"@files"}]},"detail":"($self,@files)","kind":12,"children":[{"line":551,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"make_index"},{"line":551,"kind":13,"name":"@files","containerName":"make_index"},{"localvar":"my","definition":"my","name":"$count","containerName":"make_index","line":552,"kind":13},{"definition":"my","name":"$recs","containerName":"make_index","localvar":"my","kind":13,"line":553},{"kind":13,"line":556,"containerName":"make_index","name":"$self"},{"kind":12,"line":556,"name":"write_flag","containerName":"make_index"},{"containerName":"make_index","name":"$self","kind":13,"line":557},{"containerName":"make_index","name":"throw","line":557,"kind":12},{"name":"$self","containerName":"make_index","line":561,"kind":13},{"line":561,"kind":12,"containerName":"make_index","name":"throw"},{"kind":13,"line":561,"name":"@files","containerName":"make_index"},{"name":"$i","definition":"my","containerName":"make_index","localvar":"my","kind":13,"line":562},{"kind":13,"line":562,"name":"$i","containerName":"make_index"},{"name":"@files","containerName":"make_index","line":562,"kind":13},{"line":562,"kind":13,"containerName":"make_index","name":"$i"},{"containerName":"make_index","name":"$Bio","line":563,"kind":13},{"containerName":"make_index","name":"can","line":563,"kind":12},{"name":"file_name_is_absolute","containerName":"make_index","line":564,"kind":12},{"kind":13,"line":564,"containerName":"make_index","name":"$files"},{"kind":13,"line":564,"name":"$i","containerName":"make_index"},{"line":565,"kind":13,"containerName":"make_index","name":"$self"},{"kind":12,"line":565,"containerName":"make_index","name":"pathtype"},{"name":"$files","containerName":"make_index","line":566,"kind":13},{"name":"$i","containerName":"make_index","line":566,"kind":13},{"name":"rel2abs","containerName":"make_index","kind":12,"line":566},{"kind":13,"line":566,"name":"$files","containerName":"make_index"},{"containerName":"make_index","name":"$i","kind":13,"line":566},{"name":"$files","containerName":"make_index","line":570,"kind":13},{"line":570,"kind":13,"name":"$i","containerName":"make_index"},{"kind":13,"line":571,"name":"$self","containerName":"make_index"},{"containerName":"make_index","name":"throw","line":571,"kind":12},{"name":"$files","containerName":"make_index","kind":13,"line":573},{"name":"$i","containerName":"make_index","kind":13,"line":573},{"name":"$self","containerName":"make_index","kind":13,"line":574},{"line":574,"kind":12,"name":"throw","containerName":"make_index"},{"name":"$self","containerName":"make_index","line":577,"kind":13},{"kind":12,"line":577,"name":"throw","containerName":"make_index"},{"kind":13,"line":577,"containerName":"make_index","name":"$files"},{"containerName":"make_index","name":"$i","line":577,"kind":13},{"line":582,"kind":13,"localvar":"my","containerName":"make_index","name":"$file","definition":"my"},{"line":582,"kind":13,"containerName":"make_index","name":"@files"},{"line":584,"kind":13,"localvar":"my","containerName":"make_index","name":"$i","definition":"my"},{"line":587,"kind":13,"localvar":"my","name":"$count","definition":"my","containerName":"make_index"},{"containerName":"make_index","name":"$self","line":587,"kind":13},{"name":"_file_count","containerName":"make_index","kind":12,"line":587},{"line":588,"kind":13,"containerName":"make_index","name":"$i"},{"name":"$count","containerName":"make_index","line":588,"kind":13},{"kind":13,"line":590,"containerName":"make_index","name":"$i"},{"kind":13,"line":590,"containerName":"make_index","name":"$self"},{"name":"_file_count","containerName":"make_index","line":590,"kind":12},{"localvar":"my","name":"$record","definition":"my","containerName":"make_index","line":594,"kind":13},{"kind":13,"line":594,"name":"$number","containerName":"make_index"},{"name":"$size","containerName":"make_index","line":594,"kind":13},{"name":"$record","containerName":"make_index","line":596,"kind":13},{"containerName":"make_index","name":"$self","line":596,"kind":13},{"line":596,"kind":12,"name":"db","containerName":"make_index"},{"containerName":"make_index","name":"$number","line":597,"kind":13},{"line":597,"kind":13,"containerName":"make_index","name":"$size"},{"kind":13,"line":597,"name":"$self","containerName":"make_index"},{"name":"unpack_record","containerName":"make_index","line":597,"kind":12},{"kind":13,"line":597,"containerName":"make_index","name":"$record"},{"name":"$file","containerName":"make_index","line":600,"kind":13},{"kind":13,"line":600,"name":"$size","containerName":"make_index"},{"name":"$self","containerName":"make_index","line":601,"kind":13},{"containerName":"make_index","name":"warn","kind":12,"line":601},{"line":604,"kind":13,"containerName":"make_index","name":"$self"},{"line":604,"kind":12,"containerName":"make_index","name":"throw"},{"line":609,"kind":13,"name":"$self","containerName":"make_index"},{"containerName":"make_index","name":"debug","kind":12,"line":609},{"kind":13,"line":612,"containerName":"make_index","name":"$recs"},{"kind":13,"line":612,"containerName":"make_index","name":"$self"},{"line":612,"kind":12,"containerName":"make_index","name":"_index_file"},{"name":"$file","containerName":"make_index","line":612,"kind":13},{"kind":13,"line":612,"name":"$i","containerName":"make_index"},{"containerName":"make_index","name":"$self","line":615,"kind":13},{"containerName":"make_index","name":"add_record","kind":12,"line":615},{"containerName":"make_index","name":"$file","line":615,"kind":13},{"name":"$file","containerName":"make_index","line":615,"kind":13},{"kind":13,"line":616,"containerName":"make_index","name":"$self"},{"name":"throw","containerName":"make_index","line":616,"kind":12},{"line":617,"kind":13,"name":"$self","containerName":"make_index"},{"kind":12,"line":617,"containerName":"make_index","name":"add_record"},{"kind":13,"line":617,"name":"$i","containerName":"make_index"},{"kind":13,"line":617,"name":"$file","containerName":"make_index"},{"containerName":"make_index","name":"$self","line":618,"kind":13},{"containerName":"make_index","name":"throw","kind":12,"line":618},{"kind":13,"line":621,"containerName":"make_index","name":"$i"},{"line":621,"kind":13,"name":"$self","containerName":"make_index"},{"line":621,"kind":12,"name":"_file_count","containerName":"make_index"},{"line":621,"kind":13,"containerName":"make_index","name":"$i"},{"definition":"my","name":"$temp","containerName":"make_index","localvar":"my","kind":13,"line":622},{"name":"$temp","containerName":"make_index","kind":13,"line":623},{"name":"$self","containerName":"make_index","kind":13,"line":623},{"name":"_file_count","containerName":"make_index","kind":12,"line":623},{"name":"$count","containerName":"make_index","kind":13,"line":625},{"kind":13,"line":625,"containerName":"make_index","name":"$recs"}],"line":550,"name":"make_index","range":{"end":{"line":626,"character":9999},"start":{"line":550,"character":0}}},{"line":563,"kind":12,"containerName":"IO::FILESPECLOADED","name":"Root"},{"line":563,"kind":12,"name":"File","containerName":"Spec"},{"line":564,"kind":12,"containerName":"Spec","name":"File"},{"line":566,"kind":12,"containerName":"Spec","name":"File"},{"name":"FILE","line":581,"kind":12},{"name":"FILE","line":602,"kind":12},{"kind":12,"children":[{"kind":13,"line":649,"containerName":"pathtype","definition":"my","name":"$self","localvar":"my"},{"line":649,"kind":13,"containerName":"pathtype","name":"$type"},{"kind":13,"line":651,"name":"$type","containerName":"pathtype"},{"line":652,"kind":13,"containerName":"pathtype","name":"$type"},{"name":"$type","containerName":"pathtype","line":652,"kind":13},{"containerName":"pathtype","name":"$self","kind":13,"line":653},{"containerName":"pathtype","name":"throw","line":653,"kind":12},{"containerName":"pathtype","name":"$self","line":655,"kind":13},{"kind":13,"line":655,"containerName":"pathtype","name":"$type"},{"containerName":"pathtype","name":"$self","kind":13,"line":658}],"line":647,"definition":"sub","containerName":"main::","signature":{"label":"pathtype($self,$type)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)","parameters":[{"label":"$self"},{"label":"$type"}]},"detail":"($self,$type)","name":"pathtype","range":{"end":{"line":659,"character":9999},"start":{"character":0,"line":647}}},{"children":[{"localvar":"my","containerName":"_index_file","name":"$self","definition":"my","line":674,"kind":13},{"kind":13,"line":676,"name":"$pkg","definition":"my","containerName":"_index_file","localvar":"my"},{"line":676,"kind":13,"containerName":"_index_file","name":"$self"},{"kind":13,"line":677,"containerName":"_index_file","name":"$self"},{"name":"throw","containerName":"_index_file","line":677,"kind":12}],"line":673,"kind":12,"range":{"start":{"character":0,"line":673},"end":{"character":9999,"line":678}},"definition":"sub","name":"_index_file","containerName":"main::"},{"signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT","parameters":[{"label":"$self"},{"label":"$i"}],"label":"_file_handle($self,$i)"},"detail":"($self,$i)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_file_handle","name":"$self","definition":"my","line":698,"kind":13},{"line":698,"kind":13,"name":"$i","containerName":"_file_handle"},{"containerName":"_file_handle","name":"$self","line":700,"kind":13},{"line":700,"kind":13,"name":"$i","containerName":"_file_handle"},{"kind":13,"line":701,"definition":"my","name":"@rec","containerName":"_file_handle","localvar":"my"},{"line":701,"kind":13,"name":"$self","containerName":"_file_handle"},{"name":"unpack_record","containerName":"_file_handle","kind":12,"line":701},{"name":"$self","containerName":"_file_handle","kind":13,"line":701},{"kind":12,"line":701,"containerName":"_file_handle","name":"db"},{"line":702,"kind":13,"name":"$self","containerName":"_file_handle"},{"name":"throw","containerName":"_file_handle","kind":12,"line":702},{"line":703,"kind":13,"localvar":"my","definition":"my","name":"$file","containerName":"_file_handle"},{"kind":13,"line":703,"containerName":"_file_handle","name":"$rec"},{"kind":13,"line":706,"name":"$fh","definition":"my","containerName":"_file_handle","localvar":"my"},{"kind":13,"line":706,"containerName":"_file_handle","name":"$file"},{"name":"$self","containerName":"_file_handle","line":706,"kind":13},{"containerName":"_file_handle","name":"throw","line":706,"kind":12},{"name":"$self","containerName":"_file_handle","kind":13,"line":707},{"containerName":"_file_handle","name":"$i","line":707,"kind":13},{"name":"$fh","containerName":"_file_handle","kind":13,"line":707},{"containerName":"_file_handle","name":"$self","line":709,"kind":13},{"kind":13,"line":709,"name":"$i","containerName":"_file_handle"}],"line":697,"kind":12,"range":{"end":{"line":710,"character":9999},"start":{"line":697,"character":0}},"name":"_file_handle"},{"definition":"sub","name":"_file_count","containerName":"main::","range":{"end":{"line":733,"character":9999},"start":{"character":0,"line":727}},"kind":12,"children":[{"localvar":"my","containerName":"_file_count","name":"$self","definition":"my","line":728,"kind":13},{"kind":13,"line":730,"name":"$self","containerName":"_file_count"},{"name":"db","containerName":"_file_count","line":730,"kind":12},{"line":732,"kind":13,"name":"$self","containerName":"_file_count"},{"kind":12,"line":732,"name":"db","containerName":"_file_count"}],"line":727},{"range":{"start":{"character":0,"line":751},"end":{"line":759,"character":9999}},"name":"add_record","line":751,"children":[{"definition":"my","name":"$self","containerName":"add_record","localvar":"my","kind":13,"line":752},{"kind":13,"line":752,"name":"$id","containerName":"add_record"},{"kind":13,"line":752,"name":"@rec","containerName":"add_record"},{"line":753,"kind":13,"containerName":"add_record","name":"$self"},{"kind":12,"line":753,"name":"debug","containerName":"add_record"},{"line":754,"kind":13,"containerName":"add_record","name":"$self"},{"name":"db","containerName":"add_record","kind":12,"line":754},{"line":754,"kind":13,"containerName":"add_record","name":"$id"},{"kind":13,"line":755,"name":"$self","containerName":"add_record"},{"line":755,"kind":12,"containerName":"add_record","name":"warn"},{"kind":13,"line":757,"name":"$self","containerName":"add_record"},{"name":"db","containerName":"add_record","line":757,"kind":12},{"containerName":"add_record","name":"$id","line":757,"kind":13},{"line":757,"kind":13,"name":"$self","containerName":"add_record"},{"name":"pack_record","containerName":"add_record","kind":12,"line":757},{"name":"@rec","containerName":"add_record","line":757,"kind":13}],"kind":12,"detail":"($self,$id,@rec)","signature":{"parameters":[{"label":"$self"},{"label":"$id"},{"label":"@rec"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST","label":"add_record($self,$id,@rec)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":775,"character":0},"end":{"character":9999,"line":778}},"name":"pack_record","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST","label":"pack_record($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"pack_record","definition":"my","name":"$self","localvar":"my","kind":13,"line":776},{"line":776,"kind":13,"name":"@args","containerName":"pack_record"},{"containerName":"pack_record","name":"@args","line":777,"kind":13}],"line":775,"kind":12},{"children":[{"localvar":"my","containerName":"unpack_record","name":"$self","definition":"my","line":793,"kind":13},{"containerName":"unpack_record","name":"@args","kind":13,"line":793},{"name":"$args","containerName":"unpack_record","kind":13,"line":794}],"line":792,"kind":12,"signature":{"label":"unpack_record($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST\n\n\nsub pack_record {\n\tmy( $self, @args ) = @_;\n\treturn join \"\\034\", @args;\n}\n\n=head2 unpack_record\n\n  Title   : unpack_record\n  Usage   : $index->unpack_record( STRING )\n  Function: Splits the sting provided into an array,\n            splitting on ASCII 034.\n  Example : ( $fileNumber, $begin, $end ) = $index->unpack_record( $self->db->{$id} )\n  Returns : A 3 element ARRAY\n  Args    : STRING containing ASCII 034"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":792},"end":{"line":795,"character":9999}},"name":"unpack_record"},{"name":"count_records","range":{"start":{"character":0,"line":809},"end":{"character":9999,"line":821}},"definition":"sub","containerName":"main::","signature":{"label":"count_records($self,@args)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST\n\n\nsub pack_record {\n\tmy( $self, @args ) = @_;\n\treturn join \"\\034\", @args;\n}\n\n=head2 unpack_record\n\n  Title   : unpack_record\n  Usage   : $index->unpack_record( STRING )\n  Function: Splits the sting provided into an array,\n            splitting on ASCII 034.\n  Example : ( $fileNumber, $begin, $end ) = $index->unpack_record( $self->db->{$id} )\n  Returns : A 3 element ARRAY\n  Args    : STRING containing ASCII 034\n\n\nsub unpack_record {\n\tmy( $self, @args ) = @_;\n\treturn split /\\034/, $args[0];\n}\n\n=head2 count_records\n\n Title   : count_records\n Usage   : $recs = $seqdb->count_records()\n Function: return count of all recs in the index \n Example :\n Returns : a scalar\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"count_records","definition":"my","name":"$self","line":810,"kind":13},{"line":810,"kind":13,"containerName":"count_records","name":"@args"},{"line":811,"kind":13,"localvar":"my","name":"$db","definition":"my","containerName":"count_records"},{"containerName":"count_records","name":"$self","kind":13,"line":811},{"kind":12,"line":811,"containerName":"count_records","name":"db"},{"kind":13,"line":812,"name":"$c","definition":"my","containerName":"count_records","localvar":"my"},{"definition":"my","name":"$id","containerName":"count_records","localvar":"my","kind":13,"line":813},{"kind":13,"line":813,"name":"$rec","containerName":"count_records"},{"kind":13,"line":814,"name":"$id","containerName":"count_records"},{"line":818,"kind":13,"name":"$c","containerName":"count_records"},{"name":"$c","containerName":"count_records","kind":13,"line":820}],"line":809},{"name":"DESTROY","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":836},"end":{"character":9999,"line":839}},"kind":12,"children":[{"line":837,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"DESTROY"},{"containerName":"DESTROY","name":"$self","line":838,"kind":13}],"line":836}],"version":5}