{"version":5,"vars":[{"name":"base","containerName":"","line":120,"kind":2},{"range":{"end":{"line":124,"character":9999},"start":{"line":122,"character":0}},"containerName":"main::","name":"_type_stamp","definition":"sub","line":122,"children":[],"kind":12},{"containerName":"main::","definition":"sub","name":"_version","range":{"end":{"line":128,"character":9999},"start":{"line":126,"character":0}},"kind":12,"line":126,"children":[]},{"containerName":"main::","definition":"sub","detail":"($self,$file,$i)","signature":{"label":"_index_file($self,$file,$i)","documentation":"__END__\n# $Id: Swissprot.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Swissprot\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Swissprot - Interface for indexing one or more\nSwissprot files.\n\n=head1 SYNOPSIS\n\n  # Make an index for one or more Swissprot files:\n\n    use Bio::Index::Swissprot;\n    use strict;\n\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(\n        -filename => $index_file_name,\n        -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n  # Print out several sequences present in the index in Genbank\n  # format:\n\n    use Bio::Index::Swissprot;\n    use Bio::SeqIO;\n    use strict;\n\n    my $out = Bio::SeqIO->new( -format => 'genbank',\n                               -fh => \\*STDOUT );\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(-filename => $index_file_name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns a Bio::Seq object\n        $out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the AC and ID identifiers\nas keys. This module inherits functions for managing dbm files from \nBio::Index::Abstract.pm, and provides the basic functionality \nfor indexing Swissprot files and retrieving Sequence objects from \nthem. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($index_file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nAlso lorenz@ist.org, bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::Swissprot;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n\treturn '__Swissprot_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n\treturn 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index Swissprot format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}]},"kind":12,"line":143,"children":[{"line":145,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_index_file"},{"containerName":"_index_file","name":"$file","line":145,"kind":13},{"containerName":"_index_file","name":"$i","line":145,"kind":13},{"line":148,"kind":13,"localvar":"my","definition":"my","name":"$begin","containerName":"_index_file"},{"containerName":"_index_file","definition":"my","name":"$id_parser","localvar":"my","kind":13,"line":150},{"kind":13,"line":150,"name":"$self","containerName":"_index_file"},{"kind":12,"line":150,"name":"id_parser","containerName":"_index_file"},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$SWISSPROT","line":152,"kind":13},{"kind":13,"line":152,"name":"$file","containerName":"_index_file"},{"name":"$self","containerName":"_index_file","line":152,"kind":13},{"kind":12,"line":152,"containerName":"_index_file","name":"throw"},{"localvar":"my","containerName":"_index_file","name":"%done_ids","definition":"my","line":154,"kind":13},{"containerName":"_index_file","name":"$SWISSPROT","kind":13,"line":155},{"line":157,"kind":13,"containerName":"_index_file","name":"$begin"},{"name":"$SWISSPROT","containerName":"_index_file","line":157,"kind":13},{"kind":13,"line":159,"containerName":"_index_file","name":"$id","definition":"my","localvar":"my"},{"name":"$done_ids","containerName":"_index_file","kind":13,"line":160},{"containerName":"_index_file","name":"$id","kind":13,"line":160},{"line":161,"kind":13,"containerName":"_index_file","name":"$self"},{"line":161,"kind":12,"containerName":"_index_file","name":"add_record"},{"kind":13,"line":161,"name":"$id","containerName":"_index_file"},{"name":"$i","containerName":"_index_file","kind":13,"line":161},{"containerName":"_index_file","name":"$begin","line":161,"kind":13},{"line":161,"kind":13,"name":"$id","containerName":"_index_file"},{"kind":13,"line":162,"containerName":"_index_file","name":"$done_ids"},{"name":"$id","containerName":"_index_file","kind":13,"line":162},{"kind":13,"line":165,"name":"%done_ids","containerName":"_index_file"},{"line":168,"kind":13,"containerName":"_index_file","name":"$SWISSPROT"}],"name":"_index_file","range":{"end":{"character":9999,"line":170},"start":{"character":0,"line":143}}},{"kind":12,"line":159,"name":"id_parser"},{"range":{"start":{"character":0,"line":187},"end":{"line":194,"character":9999}},"name":"id_parser","line":187,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"id_parser","line":188,"kind":13},{"kind":13,"line":188,"name":"$code","containerName":"id_parser"},{"kind":13,"line":190,"name":"$code","containerName":"id_parser"},{"containerName":"id_parser","name":"$self","kind":13,"line":191},{"line":191,"kind":13,"name":"$code","containerName":"id_parser"},{"line":193,"kind":13,"name":"$self","containerName":"id_parser"}],"kind":12,"detail":"($self,$code)","signature":{"documentation":"__END__\n# $Id: Swissprot.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Swissprot\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Swissprot - Interface for indexing one or more\nSwissprot files.\n\n=head1 SYNOPSIS\n\n  # Make an index for one or more Swissprot files:\n\n    use Bio::Index::Swissprot;\n    use strict;\n\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(\n        -filename => $index_file_name,\n        -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n  # Print out several sequences present in the index in Genbank\n  # format:\n\n    use Bio::Index::Swissprot;\n    use Bio::SeqIO;\n    use strict;\n\n    my $out = Bio::SeqIO->new( -format => 'genbank',\n                               -fh => \\*STDOUT );\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(-filename => $index_file_name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns a Bio::Seq object\n        $out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the AC and ID identifiers\nas keys. This module inherits functions for managing dbm files from \nBio::Index::Abstract.pm, and provides the basic functionality \nfor indexing Swissprot files and retrieving Sequence objects from \nthem. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($index_file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nAlso lorenz@ist.org, bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::Swissprot;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n\treturn '__Swissprot_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n\treturn 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index Swissprot format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\t# $file is file name, $i is number of file being indexed\n\tmy( $self, $file, $i ) = @_;\n\n\t# Offset from start of file\n\tmy $begin = 0;\n\n\tmy $id_parser = $self->id_parser;\n\n\topen my $SWISSPROT,'<',$file or $self->throw(\"Can't read file: $file\");\n    \n        my %done_ids;\n\twhile (<$SWISSPROT>) {\n\t\tif (/^ID\\s+\\S+/) {\n\t\t\t$begin = tell($SWISSPROT) - length( $_ );\n\t\t}\n\t\tfor my $id (&$id_parser($_)) {\n                        next if exists $done_ids{$id};\n  \t\t\t$self->add_record($id, $i, $begin) if $id;\n                        $done_ids{$id} = 1;\n\t\t}\n        if (m{//}) {\n            %done_ids = ();\n        }\n\t}\n\tclose $SWISSPROT;\n\treturn 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"},"containerName":"main::","definition":"sub"},{"name":"default_id_parser","kind":12,"line":193},{"range":{"start":{"line":208,"character":0},"end":{"character":9999,"line":216}},"name":"default_id_parser","definition":"sub","containerName":"main::","children":[{"kind":13,"line":209,"definition":"my","name":"$line","containerName":"default_id_parser","localvar":"my"},{"containerName":"default_id_parser","name":"$line","line":210,"kind":13},{"kind":13,"line":213,"name":"$line","containerName":"default_id_parser"}],"line":208,"kind":12},{"range":{"end":{"character":9999,"line":232},"start":{"character":0,"line":230}},"containerName":"main::","definition":"sub","name":"_file_format","line":230,"children":[],"kind":12}]}