{"vars":[{"name":"base","containerName":"","line":48,"kind":2},{"name":"new","range":{"end":{"character":9999,"line":92},"start":{"character":0,"line":63}},"containerName":"main::","definition":"sub","detail":"($thing,%args)","signature":{"parameters":[{"label":"$thing"},{"label":"%args"}],"documentation":"1;\n# $Id: Translation.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Translation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Translation - Translation class for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about aminoacids translations of transcripts.\nThe implementation is that a Translation object is the translation of\na Transcript object, with different possibilities of manipulation,\ndifferent coordinate system and eventually its own ranges (protein domains).\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Translation;\n\nuse strict;\n#use Carp qw(croak carp cluck);\nuse Bio::LiveSeq::SeqI; # uses SeqI, inherits from it\nuse Bio::PrimarySeq;\nuse base qw(Bio::LiveSeq::Transcript);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $protein = Bio::LiveSeq::Translation->new(-transcript => $transcr);\n\n  Function: generates a new Bio::LiveSeq::Translation\n  Returns : reference to a new object of class Translation\n  Errorcode -1\n  Args    : reference to an object of class Transcript","label":"new($thing,%args)"},"kind":12,"line":63,"children":[{"line":64,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$thing"},{"kind":13,"line":64,"containerName":"new","name":"%args"},{"kind":13,"line":65,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"kind":13,"line":65,"name":"$thing","containerName":"new"},{"line":65,"kind":13,"containerName":"new","name":"$thing"},{"localvar":"my","definition":"my","name":"$obj","containerName":"new","line":66,"kind":13},{"containerName":"new","name":"%translation","kind":13,"line":66},{"definition":"my","name":"$transcript","containerName":"new","localvar":"my","kind":13,"line":68},{"line":68,"kind":13,"name":"$args","containerName":"new"},{"kind":13,"line":70,"containerName":"new","name":"$obj"},{"name":"%translation","containerName":"new","kind":13,"line":70},{"line":71,"kind":13,"containerName":"new","name":"$obj"},{"name":"$obj","containerName":"new","line":71,"kind":13},{"kind":13,"line":71,"name":"$class","containerName":"new"},{"line":73,"kind":13,"name":"$transcript","containerName":"new"},{"name":"$obj","containerName":"new","kind":13,"line":74},{"name":"throw","containerName":"new","kind":12,"line":74},{"line":76,"kind":13,"containerName":"new","name":"$transcript"},{"kind":13,"line":77,"containerName":"new","name":"$obj"},{"line":77,"kind":12,"containerName":"new","name":"throw"},{"definition":"my","name":"$strand","containerName":"new","localvar":"my","kind":13,"line":82},{"containerName":"new","name":"$transcript","line":82,"kind":13},{"name":"strand","containerName":"new","kind":12,"line":82},{"kind":13,"line":83,"name":"$seq","definition":"my","containerName":"new","localvar":"my"},{"line":83,"kind":13,"containerName":"new","name":"$transcript"},{"containerName":"new","name":"$obj","kind":13,"line":85},{"kind":13,"line":85,"name":"$strand","containerName":"new"},{"containerName":"new","name":"$obj","line":86,"kind":13},{"name":"$seq","containerName":"new","kind":13,"line":86},{"line":87,"kind":13,"containerName":"new","name":"$obj"},{"name":"$transcript","containerName":"new","line":87,"kind":13},{"kind":13,"line":88,"containerName":"new","name":"$obj"},{"line":90,"kind":13,"name":"$transcript","containerName":"new"},{"kind":13,"line":90,"containerName":"new","name":"$obj"},{"name":"$obj","containerName":"new","line":91,"kind":13}]},{"kind":12,"children":[{"kind":13,"line":106,"name":"$self","definition":"my","containerName":"get_Transcript","localvar":"my"},{"kind":13,"line":107,"name":"$self","containerName":"get_Transcript"}],"line":105,"name":"get_Transcript","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":108},"start":{"line":105,"character":0}}},{"range":{"start":{"line":112,"character":0},"end":{"character":9999,"line":116}},"name":"change","detail":"($self)","signature":{"label":"change($self)","documentation":" These get redefined here, overriding the SeqI ones","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":112,"children":[{"line":113,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"change"},{"containerName":"change","name":"$self","kind":13,"line":114},{"containerName":"change","name":"warn","kind":12,"line":114}],"kind":12},{"name":"positionchange","range":{"start":{"line":117,"character":0},"end":{"line":121,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"positionchange($self)"},"detail":"($self)","kind":12,"children":[{"line":118,"kind":13,"localvar":"my","containerName":"positionchange","definition":"my","name":"$self"},{"kind":13,"line":119,"containerName":"positionchange","name":"$self"},{"line":119,"kind":12,"name":"warn","containerName":"positionchange"}],"line":117},{"children":[{"line":123,"kind":13,"localvar":"my","containerName":"labelchange","name":"$self","definition":"my"},{"name":"$self","containerName":"labelchange","line":124,"kind":13},{"containerName":"labelchange","name":"warn","kind":12,"line":124}],"line":122,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"labelchange($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":122,"character":0},"end":{"character":9999,"line":126}},"name":"labelchange"},{"containerName":"main::","name":"transl_seq","definition":"sub","range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":136}},"kind":12,"line":130,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"transl_seq","line":131,"kind":13},{"containerName":"transl_seq","name":"$transcript","definition":"my","localvar":"my","kind":13,"line":132},{"kind":13,"line":132,"containerName":"transl_seq","name":"$self"},{"line":132,"kind":12,"containerName":"transl_seq","name":"get_Transcript"},{"line":133,"kind":13,"localvar":"my","definition":"my","name":"$translation","containerName":"transl_seq"},{"line":133,"kind":13,"name":"$transcript","containerName":"transl_seq"},{"kind":12,"line":133,"name":"translate","containerName":"transl_seq"},{"name":"$self","containerName":"transl_seq","kind":13,"line":134},{"name":"translation_table","containerName":"transl_seq","kind":12,"line":134},{"name":"seq","containerName":"transl_seq","line":134,"kind":12},{"containerName":"transl_seq","name":"$translation","kind":13,"line":135}]},{"definition":"sub","name":"seq","containerName":"main::","range":{"end":{"character":9999,"line":170},"start":{"line":139,"character":0}},"kind":12,"children":[{"kind":13,"line":140,"containerName":"seq","definition":"my","name":"$self","localvar":"my"},{"line":141,"kind":13,"localvar":"my","containerName":"seq","name":"$proteinseq","definition":"my"},{"line":142,"kind":13,"localvar":"my","containerName":"seq","definition":"my","name":"$transcript"},{"line":142,"kind":13,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"get_Transcript","kind":12,"line":142},{"kind":13,"line":143,"containerName":"seq","name":"$translation","definition":"my","localvar":"my"},{"line":143,"kind":13,"name":"$transcript","containerName":"seq"},{"line":143,"kind":12,"name":"translate","containerName":"seq"},{"line":144,"kind":13,"name":"$self","containerName":"seq"},{"name":"translation_table","containerName":"seq","kind":12,"line":144},{"line":144,"kind":12,"name":"seq","containerName":"seq"},{"kind":13,"line":145,"containerName":"seq","name":"$stop_pos","definition":"my","localvar":"my"},{"kind":13,"line":145,"name":"$translation","containerName":"seq"},{"containerName":"seq","name":"$stop_pos","line":146,"kind":13},{"localvar":"my","definition":"my","name":"$downstreamseq","containerName":"seq","line":147,"kind":13},{"name":"$transcript","containerName":"seq","line":147,"kind":13},{"line":147,"kind":12,"containerName":"seq","name":"downstream_seq"},{"kind":13,"line":149,"containerName":"seq","name":"$cdnaseq","definition":"my","localvar":"my"},{"containerName":"seq","name":"$transcript","kind":13,"line":149},{"kind":12,"line":149,"containerName":"seq","name":"seq"},{"kind":13,"line":150,"containerName":"seq","definition":"my","name":"$extendedseq","localvar":"my"},{"name":"new","containerName":"seq","kind":12,"line":150},{"line":154,"kind":13,"name":"$translation","containerName":"seq"},{"name":"$extendedseq","containerName":"seq","line":154,"kind":13},{"name":"translate","containerName":"seq","line":154,"kind":12},{"line":155,"kind":13,"name":"$self","containerName":"seq"},{"kind":12,"line":155,"name":"translation_table","containerName":"seq"},{"containerName":"seq","name":"seq","line":155,"kind":12},{"name":"$stop_pos","containerName":"seq","line":157,"kind":13},{"kind":13,"line":157,"name":"$translation","containerName":"seq"},{"kind":13,"line":158,"name":"$stop_pos","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":159},{"line":159,"kind":12,"name":"warn","containerName":"seq"},{"line":160,"kind":13,"containerName":"seq","name":"$stop_pos"},{"kind":13,"line":161,"name":"$proteinseq","containerName":"seq"},{"containerName":"seq","name":"$translation","line":161,"kind":13},{"name":"$proteinseq","containerName":"seq","line":163,"kind":13},{"line":163,"kind":13,"containerName":"seq","name":"$translation"},{"kind":13,"line":163,"containerName":"seq","name":"$stop_pos"},{"kind":13,"line":167,"name":"$proteinseq","containerName":"seq"},{"name":"$translation","containerName":"seq","kind":13,"line":167},{"name":"$stop_pos","containerName":"seq","line":167,"kind":13},{"containerName":"seq","name":"$proteinseq","line":169,"kind":13}],"line":139},{"kind":12,"line":150,"name":"Bio","containerName":"PrimarySeq"},{"definition":"sub","name":"length","containerName":"main::","range":{"end":{"line":177,"character":9999},"start":{"line":172,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"length","localvar":"my","kind":13,"line":173},{"line":174,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"length"},{"kind":13,"line":174,"name":"$self","containerName":"length"},{"name":"seq","containerName":"length","line":174,"kind":12},{"localvar":"my","containerName":"length","definition":"my","name":"$length","line":175,"kind":13},{"line":175,"kind":13,"name":"$seq","containerName":"length"},{"kind":13,"line":176,"containerName":"length","name":"$length"}],"line":172},{"definition":"sub","name":"all_labels","containerName":"main::","range":{"start":{"line":179,"character":0},"end":{"line":182,"character":9999}},"kind":12,"children":[{"line":180,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"all_labels"},{"containerName":"all_labels","name":"$self","kind":13,"line":181},{"containerName":"all_labels","name":"get_Transcript","kind":12,"line":181},{"kind":12,"line":181,"containerName":"all_labels","name":"all_labels"}],"line":179},{"kind":12,"children":[{"containerName":"valid","name":"$self","definition":"my","localvar":"my","kind":13,"line":188},{"containerName":"valid","name":"$label","kind":13,"line":188},{"localvar":"my","containerName":"valid","definition":"my","name":"$i","line":189,"kind":13},{"containerName":"valid","definition":"my","name":"@labels","localvar":"my","kind":13,"line":190},{"name":"$self","containerName":"valid","line":190,"kind":13},{"name":"get_Transcript","containerName":"valid","line":190,"kind":12},{"kind":12,"line":190,"containerName":"valid","name":"all_labels"},{"kind":13,"line":191,"name":"$length","definition":"my","containerName":"valid","localvar":"my"},{"line":192,"kind":13,"containerName":"valid","name":"$i"},{"line":192,"kind":13,"containerName":"valid","name":"$length"},{"name":"$label","containerName":"valid","line":193,"kind":13},{"kind":13,"line":193,"containerName":"valid","name":"$labels"},{"name":"$i","containerName":"valid","kind":13,"line":193},{"name":"$i","containerName":"valid","kind":13,"line":196},{"kind":13,"line":196,"containerName":"valid","name":"$i"}],"line":187,"definition":"sub","containerName":"main::","signature":{"documentation":" counts in triplet. Only a label matching the beginning of a triplet coding\n for an aminoacid is considered valid when setting coordinate_start\n (i.e. only in frame!)","parameters":[{"label":"$self"},{"label":"$label"}],"label":"valid($self,$label)"},"detail":"($self,$label)","name":"valid","range":{"end":{"line":199,"character":9999},"start":{"line":187,"character":0}}},{"name":"labels","line":191,"kind":12},{"name":"label","range":{"end":{"line":212,"character":9999},"start":{"character":0,"line":202}},"kind":12,"line":202,"children":[{"localvar":"my","containerName":"label","definition":"my","name":"$self","line":203,"kind":13},{"line":203,"kind":13,"containerName":"label","name":"$position"},{"localvar":"my","definition":"my","name":"$firstlabel","containerName":"label","line":204,"kind":13},{"containerName":"label","name":"$self","kind":13,"line":204},{"line":204,"kind":12,"containerName":"label","name":"coordinate_start"},{"containerName":"label","name":"$position","kind":13,"line":205},{"kind":13,"line":206,"name":"$position","containerName":"label"},{"containerName":"label","name":"$position","line":206,"kind":13},{"containerName":"label","name":"$position","kind":13,"line":208},{"name":"$position","containerName":"label","line":208,"kind":13},{"line":210,"kind":13,"name":"$self","containerName":"label"},{"kind":12,"line":210,"containerName":"label","name":"get_Transcript"},{"name":"label","containerName":"label","kind":12,"line":210},{"containerName":"label","name":"$position","kind":13,"line":210},{"containerName":"label","name":"$firstlabel","kind":13,"line":210}],"containerName":"main::","definition":"sub","detail":"($self,$position)","signature":{"label":"label($self,$position)","documentation":" returns the label to the first nucleotide of the triplet coding for $position aminoacid","parameters":[{"label":"$self"},{"label":"$position"}]}},{"children":[{"line":218,"kind":13,"localvar":"my","containerName":"position","name":"$self","definition":"my"},{"name":"$label","containerName":"position","line":218,"kind":13},{"localvar":"my","containerName":"position","definition":"my","name":"$firstlabel","line":219,"kind":13},{"containerName":"position","name":"$self","kind":13,"line":219},{"containerName":"position","name":"coordinate_start","line":219,"kind":12},{"line":220,"kind":13,"localvar":"my","containerName":"position","name":"$position","definition":"my"},{"kind":13,"line":220,"containerName":"position","name":"$self"},{"containerName":"position","name":"get_Transcript","line":220,"kind":12},{"line":220,"kind":12,"containerName":"position","name":"position"},{"kind":13,"line":220,"name":"$label","containerName":"position"},{"name":"$firstlabel","containerName":"position","line":220,"kind":13},{"localvar":"my","definition":"my","name":"$modulus","containerName":"position","line":222,"kind":13},{"containerName":"position","name":"$position","line":222,"kind":13},{"containerName":"position","name":"$position","kind":13,"line":223},{"kind":13,"line":225,"name":"$position","containerName":"position"},{"line":226,"kind":13,"name":"$modulus","containerName":"position"},{"kind":13,"line":227,"containerName":"position","name":"$self"},{"kind":12,"line":227,"name":"warn","containerName":"position"},{"name":"$self","containerName":"position","line":228,"kind":13},{"name":"verbose","containerName":"position","kind":12,"line":228},{"containerName":"position","name":"$modulus","line":229,"kind":13},{"name":"$position","containerName":"position","kind":13,"line":230},{"kind":13,"line":232,"name":"$position","containerName":"position"},{"name":"$position","containerName":"position","line":235,"kind":13},{"containerName":"position","name":"$modulus","kind":13,"line":237},{"containerName":"position","name":"$self","kind":13,"line":238},{"kind":12,"line":238,"name":"warn","containerName":"position"},{"name":"$self","containerName":"position","kind":13,"line":239},{"containerName":"position","name":"verbose","line":239,"kind":12},{"containerName":"position","name":"$position","line":240,"kind":13},{"name":"$position","containerName":"position","line":242,"kind":13},{"kind":13,"line":244,"name":"$self","containerName":"position"},{"kind":12,"line":244,"containerName":"position","name":"throw"}],"line":217,"kind":12,"signature":{"label":"position($self,$label)","parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" returns position (aminoacids numbering) of a particular label\n used to return 0 for not in frame labels\n now returns the position anyway (after version 1.66)"},"detail":"($self,$label)","definition":"sub","containerName":"main::","range":{"start":{"line":217,"character":0},"end":{"character":9999,"line":246}},"name":"position"},{"name":"integer","containerName":"","line":222,"kind":2},{"kind":12,"line":250,"children":[{"line":251,"kind":13,"localvar":"my","containerName":"start","definition":"my","name":"$self"},{"kind":13,"line":252,"name":"$self","containerName":"start"},{"name":"start","containerName":"start","line":252,"kind":12}],"containerName":"main::","definition":"sub","name":"start","range":{"start":{"character":0,"line":250},"end":{"character":9999,"line":253}}},{"name":"end","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":255},"end":{"line":258,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"end","localvar":"my","kind":13,"line":256},{"containerName":"end","name":"$self","kind":13,"line":257},{"name":"end","containerName":"end","kind":12,"line":257}],"line":255},{"line":273,"children":[{"line":274,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"aa_ranges"},{"line":275,"kind":13,"name":"$self","containerName":"aa_ranges"}],"kind":12,"range":{"start":{"character":0,"line":273},"end":{"character":9999,"line":276}},"containerName":"main::","definition":"sub","name":"aa_ranges"},{"containerName":"main::","name":"translation_table","definition":"sub","range":{"start":{"character":0,"line":278},"end":{"character":9999,"line":281}},"kind":12,"line":278,"children":[{"line":279,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"translation_table"},{"name":"$self","containerName":"translation_table","line":280,"kind":13},{"kind":12,"line":280,"containerName":"translation_table","name":"get_Transcript"},{"containerName":"translation_table","name":"translation_table","line":280,"kind":12}]},{"name":"labelsubseq","range":{"end":{"character":9999,"line":314},"start":{"character":0,"line":288}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"labelsubseq","localvar":"my","kind":13,"line":289},{"name":"$start","containerName":"labelsubseq","kind":13,"line":289},{"line":289,"kind":13,"containerName":"labelsubseq","name":"$length"},{"kind":13,"line":289,"name":"$end","containerName":"labelsubseq"},{"definition":"my","name":"$pos1","containerName":"labelsubseq","localvar":"my","kind":13,"line":290},{"line":290,"kind":13,"containerName":"labelsubseq","name":"$pos2"},{"localvar":"my","containerName":"labelsubseq","name":"$transcript","definition":"my","line":291,"kind":13},{"name":"$self","containerName":"labelsubseq","line":291,"kind":13},{"kind":12,"line":291,"name":"get_Transcript","containerName":"labelsubseq"},{"kind":13,"line":292,"name":"$start","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$transcript","line":293,"kind":13},{"kind":12,"line":293,"name":"valid","containerName":"labelsubseq"},{"kind":13,"line":293,"name":"$start","containerName":"labelsubseq"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":294},{"kind":12,"line":294,"containerName":"labelsubseq","name":"warn"},{"containerName":"labelsubseq","name":"$pos1","kind":13,"line":296},{"kind":13,"line":296,"name":"$self","containerName":"labelsubseq"},{"kind":12,"line":296,"containerName":"labelsubseq","name":"position"},{"name":"$start","containerName":"labelsubseq","line":296,"kind":13},{"line":298,"kind":13,"name":"$end","containerName":"labelsubseq"},{"line":299,"kind":13,"name":"$end","containerName":"labelsubseq"},{"name":"$start","containerName":"labelsubseq","kind":13,"line":299},{"name":"$length","containerName":"labelsubseq","line":300,"kind":13},{"containerName":"labelsubseq","name":"$transcript","kind":13,"line":302},{"containerName":"labelsubseq","name":"valid","line":302,"kind":12},{"name":"$end","containerName":"labelsubseq","kind":13,"line":302},{"name":"$self","containerName":"labelsubseq","line":303,"kind":13},{"containerName":"labelsubseq","name":"warn","kind":12,"line":303},{"name":"$transcript","containerName":"labelsubseq","kind":13,"line":305},{"kind":12,"line":305,"containerName":"labelsubseq","name":"follows"},{"kind":13,"line":305,"containerName":"labelsubseq","name":"$start"},{"name":"$end","containerName":"labelsubseq","line":305,"kind":13},{"line":306,"kind":13,"containerName":"labelsubseq","name":"$self"},{"name":"warn","containerName":"labelsubseq","line":306,"kind":12},{"kind":13,"line":308,"name":"$pos2","containerName":"labelsubseq"},{"line":308,"kind":13,"name":"$self","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"position","line":308,"kind":12},{"line":308,"kind":13,"name":"$end","containerName":"labelsubseq"},{"name":"$length","containerName":"labelsubseq","line":309,"kind":13},{"containerName":"labelsubseq","name":"$pos2","line":309,"kind":13},{"name":"$pos1","containerName":"labelsubseq","line":309,"kind":13},{"kind":13,"line":312,"name":"$sequence","definition":"my","containerName":"labelsubseq","localvar":"my"},{"containerName":"labelsubseq","name":"$self","kind":13,"line":312},{"name":"seq","containerName":"labelsubseq","line":312,"kind":12},{"line":313,"kind":13,"containerName":"labelsubseq","name":"$sequence"},{"line":313,"kind":13,"name":"$pos1","containerName":"labelsubseq"},{"name":"$length","containerName":"labelsubseq","kind":13,"line":313}],"line":288,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"}],"documentation":" returns all aminoacids \"affected\" i.e. all aminoacids coded by any codon\n \"touched\" by the range selected between the labels, even if only partially.\n it's not optimized for performance but it's useful","label":"labelsubseq($self,$start,$length,$end)"},"detail":"($self,$start,$length,$end)"},{"range":{"end":{"character":9999,"line":321},"start":{"line":318,"character":0}},"definition":"sub","name":"offset","containerName":"main::","children":[{"containerName":"offset","definition":"my","name":"$self","localvar":"my","kind":13,"line":319},{"line":320,"kind":13,"name":"$self","containerName":"offset"}],"line":318,"kind":12}],"version":5}