{"vars":[{"kind":2,"line":82,"name":"base","containerName":""},{"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":85},{"line":85,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":86},{"line":86,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":86,"kind":13},{"kind":13,"line":88,"containerName":"new","name":"$self"}],"line":84,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":89,"character":9999},"start":{"character":0,"line":84}},"name":"new"},{"kind":12,"line":86,"containerName":"new","name":"SUPER"},{"name":"start","range":{"start":{"character":0,"line":104},"end":{"character":9999,"line":113}},"kind":12,"line":104,"children":[{"kind":13,"line":105,"containerName":"start","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":105,"containerName":"start","name":"$loc"},{"containerName":"start","name":"$loc","line":107,"kind":13},{"kind":12,"line":107,"containerName":"start","name":"start_pos_type"},{"containerName":"start","name":"$loc","line":108,"kind":13},{"name":"start_pos_type","containerName":"start","kind":12,"line":108},{"kind":13,"line":109,"containerName":"start","name":"$min","definition":"my","localvar":"my"},{"containerName":"start","name":"$max","kind":13,"line":109},{"kind":13,"line":109,"containerName":"start","name":"$loc"},{"kind":12,"line":109,"name":"min_start","containerName":"start"},{"containerName":"start","name":"$loc","line":109,"kind":13},{"line":109,"kind":12,"containerName":"start","name":"max_start"},{"containerName":"start","name":"$min","kind":13,"line":110},{"kind":13,"line":110,"name":"$max","containerName":"start"},{"name":"$min","containerName":"start","line":110,"kind":13},{"line":110,"kind":13,"containerName":"start","name":"$max"},{"containerName":"start","name":"$self","kind":13,"line":112},{"line":112,"kind":13,"name":"$loc","containerName":"start"}],"containerName":"main::","definition":"sub","detail":"($self,$loc)","signature":{"documentation":"1;\n# $Id: AvWithinCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::AvWithinCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::AvWithinCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the average for WITHIN and the widest possible and reasonable range otherwise\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that for fuzzy locations\nof type WITHIN and BETWEEN the average of the two limits will be\nreturned, and for all other locations it will return the widest\npossible range, but by using some common sense. This means that\ne.g. locations like \"E<lt>5..100\" (start before position 5) will return 5\nas start (returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::AvWithinCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Location::WidestCoordPolicy);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"},{"label":"$loc"}],"label":"start($self,$loc)"}},{"containerName":"start","name":"SUPER","line":112,"kind":12},{"children":[{"name":"$self","definition":"my","containerName":"end","localvar":"my","kind":13,"line":127},{"name":"$loc","containerName":"end","line":127,"kind":13},{"kind":13,"line":129,"containerName":"end","name":"$loc"},{"kind":12,"line":129,"containerName":"end","name":"end_pos_type"},{"name":"$loc","containerName":"end","line":130,"kind":13},{"kind":12,"line":130,"containerName":"end","name":"end_pos_type"},{"localvar":"my","containerName":"end","name":"$min","definition":"my","line":131,"kind":13},{"name":"$max","containerName":"end","kind":13,"line":131},{"kind":13,"line":131,"containerName":"end","name":"$loc"},{"kind":12,"line":131,"name":"min_end","containerName":"end"},{"name":"$loc","containerName":"end","line":131,"kind":13},{"containerName":"end","name":"max_end","kind":12,"line":131},{"line":132,"kind":13,"containerName":"end","name":"$min"},{"kind":13,"line":132,"name":"$max","containerName":"end"},{"kind":13,"line":132,"containerName":"end","name":"$min"},{"containerName":"end","name":"$max","kind":13,"line":132},{"containerName":"end","name":"$self","line":134,"kind":13},{"line":134,"kind":13,"containerName":"end","name":"$loc"}],"line":126,"kind":12,"signature":{"label":"end($self,$loc)","documentation":"1;\n# $Id: AvWithinCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::AvWithinCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::AvWithinCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the average for WITHIN and the widest possible and reasonable range otherwise\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that for fuzzy locations\nof type WITHIN and BETWEEN the average of the two limits will be\nreturned, and for all other locations it will return the widest\npossible range, but by using some common sense. This means that\ne.g. locations like \"E<lt>5..100\" (start before position 5) will return 5\nas start (returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::AvWithinCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Location::WidestCoordPolicy);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self,$loc) = @_;\n\n    if(($loc->start_pos_type() eq 'WITHIN') ||\n       ($loc->start_pos_type() eq 'BETWEEN')) {\n\tmy ($min, $max) = ($loc->min_start(), $loc->max_start());\n\treturn int(($min+$max)/2) if($min && $max);\n    }\n    return $self->SUPER::start($loc);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"},{"label":"$loc"}]},"detail":"($self,$loc)","definition":"sub","containerName":"main::","range":{"start":{"line":126,"character":0},"end":{"character":9999,"line":135}},"name":"end"},{"name":"SUPER","containerName":"end","kind":12,"line":134}],"version":5}