{"version":5,"vars":[{"line":109,"kind":2,"containerName":"","name":"base"},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":138,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":138,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":139,"kind":13},{"containerName":"new","name":"$class","line":139,"kind":13},{"name":"@args","containerName":"new","line":139,"kind":13},{"line":141,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$type"},{"containerName":"new","name":"$self","kind":13,"line":141},{"name":"_rearrange","containerName":"new","line":141,"kind":12},{"containerName":"new","name":"@args","line":141,"kind":13},{"containerName":"new","name":"$type","kind":13,"line":142},{"name":"$self","containerName":"new","line":142,"kind":13},{"containerName":"new","name":"throw","line":142,"kind":12},{"kind":13,"line":143,"containerName":"new","name":"$self"},{"name":"type","containerName":"new","line":143,"kind":12},{"containerName":"new","name":"$type","line":143,"kind":13},{"kind":13,"line":145,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":147}],"line":137,"kind":12,"range":{"end":{"line":148,"character":9999},"start":{"character":0,"line":137}},"name":"new"},{"line":139,"kind":12,"containerName":"new","name":"SUPER"},{"name":"_relative_not_implicit","line":145,"kind":12},{"range":{"start":{"line":162,"character":0},"end":{"character":9999,"line":168}},"name":"map","line":162,"children":[{"definition":"my","name":"$self","containerName":"map","localvar":"my","kind":13,"line":163},{"line":163,"kind":13,"name":"$map","containerName":"map"},{"name":"$map","containerName":"map","kind":13,"line":164},{"name":"$map","containerName":"map","kind":13,"line":165},{"name":"isa","containerName":"map","kind":12,"line":165},{"name":"$self","containerName":"map","line":165,"kind":13},{"containerName":"map","name":"throw","line":165,"kind":12},{"name":"$self","containerName":"map","kind":13,"line":167},{"kind":13,"line":167,"name":"$map","containerName":"map"}],"kind":12,"detail":"($self,$map)","signature":{"parameters":[{"label":"$self"},{"label":"$map"}],"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set","label":"map($self,$map)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"map","kind":12,"line":167},{"range":{"start":{"line":182,"character":0},"end":{"line":188,"character":9999}},"name":"element","signature":{"label":"element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set"},"detail":"($self,$element)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":183,"containerName":"element","name":"$self","definition":"my","localvar":"my"},{"line":183,"kind":13,"name":"$element","containerName":"element"},{"line":184,"kind":13,"containerName":"element","name":"$element"},{"containerName":"element","name":"$element","line":185,"kind":13},{"line":185,"kind":12,"name":"isa","containerName":"element"},{"containerName":"element","name":"$self","line":185,"kind":13},{"line":185,"kind":12,"containerName":"element","name":"throw"},{"name":"$self","containerName":"element","kind":13,"line":187},{"name":"$element","containerName":"element","line":187,"kind":13}],"line":182,"kind":12},{"containerName":"element","name":"SUPER","line":187,"kind":12},{"containerName":"main::","definition":"sub","name":"type","range":{"end":{"line":212,"character":9999},"start":{"line":202,"character":0}},"kind":12,"line":202,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"type","line":203,"kind":13},{"line":205,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"type"},{"containerName":"type","name":"$type","line":206,"kind":13},{"kind":13,"line":207,"name":"$self","containerName":"type"},{"name":"throw","containerName":"type","kind":12,"line":207},{"line":209,"kind":13,"containerName":"type","name":"$self"},{"line":209,"kind":13,"name":"$type","containerName":"type"},{"name":"$self","containerName":"type","line":211,"kind":13}]},{"name":"type","line":209,"kind":12},{"kind":12,"line":211,"name":"type"},{"containerName":"main::","definition":"sub","detail":"($self,$relative)","signature":{"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $element->isa('Bio::Map::Gene') || $self->throw(\"This is [$element], not a Bio::Map::Gene\");\n    }\n    return $self->SUPER::element($element);\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $position->type();\n           $position->type($type);\n Function: Get/set the type of this position.\n Returns : string\n Args    : none to get, OR\n           string transcript|coding|exon|intron to set\n\n\nsub type {\n    my $self = shift;\n    if (@_) {\n        my $type = shift;\n        if ($type !~ /transcript|coding|exon|intron/i) {\n            $self->throw(\"type must be supplied and be one of 'transcript', 'coding', 'exon', 'intron'\");\n        }\n        $self->{type} = $type;\n    }\n    return $self->{type};\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a RelativeI object.\n  Returns : Bio::Map::GeneRelative. The default GeneRelative returned has a\n            meaning that depends on the type() of GenePosition this is:\n            'transcript'         : \"relative to the start of the gene on the\n                                    Position's map\"\n            'coding|exon|intron' : \"relative to the start of the default\n                                    transcript of the gene on the Position's map\"\n  Args    : none to get, OR\n            Bio::Map::GeneRelative to set","parameters":[{"label":"$self"},{"label":"$relative"}],"label":"relative($self,$relative)"},"kind":12,"line":232,"children":[{"definition":"my","name":"$self","containerName":"relative","localvar":"my","kind":13,"line":233},{"kind":13,"line":233,"containerName":"relative","name":"$relative"},{"line":234,"kind":13,"containerName":"relative","name":"$relative"},{"line":235,"kind":13,"containerName":"relative","name":"$self"},{"kind":12,"line":235,"name":"throw","containerName":"relative"},{"name":"$relative","containerName":"relative","kind":13,"line":235},{"containerName":"relative","name":"$self","kind":13,"line":236},{"kind":12,"line":236,"name":"throw","containerName":"relative"},{"kind":13,"line":236,"name":"$relative","containerName":"relative"},{"containerName":"relative","name":"isa","line":236,"kind":12},{"containerName":"relative","name":"$self","kind":13,"line":237},{"containerName":"relative","name":"$relative","kind":13,"line":237},{"name":"$self","containerName":"relative","kind":13,"line":239},{"kind":13,"line":239,"containerName":"relative","name":"$self"},{"kind":12,"line":239,"containerName":"relative","name":"_default_relative"}],"name":"relative","range":{"start":{"character":0,"line":232},"end":{"character":9999,"line":240}}},{"name":"_relative","line":237,"kind":12},{"name":"_relative","line":239,"kind":12},{"name":"seq","range":{"end":{"line":272,"character":9999},"start":{"character":0,"line":255}},"containerName":"main::","definition":"sub","detail":"($self,$str,$alpha,$shortcut)","signature":{"parameters":[{"label":"$self"},{"label":"$str"},{"label":"$alpha"},{"label":"$shortcut"}],"documentation":"1;\n# $Id: GenePosition.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::GenePosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GenePosition - A typed position, suitable for modelling the various\n                         regions of a gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GenePosition;\n    use Bio::Map::GeneMap;\n\n    # say that the first transcript of a particular gene on a particular map\n    # (species) is 1000bp long\n    my $map = Bio::Map:GeneMap->get(-universal_name => 'BRCA2',\n                                    -species => 'human');\n    my $gene = $map->gene;\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -length => 1000,\n                                -type => 'transcript');\n\n    # say that the coding region of the gene starts 30bp into the first\n    # transcript\n    Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 30,\n                                -length => 600,\n                                -type => 'coding');\n\n    # A GenePosition isa PositionWithSequence, so can have sequence associated\n    # with it\n    my $exon = Bio::Map::GenePosition->new(-map => $map, \n                                -element => $gene,\n                                -start => 0,\n                                -type => 'exon',\n                                -seq => 'ATGGGGTGGG');\n    my $length = $exon->length; # $length is 10\n\n=head1 DESCRIPTION\n\nDefine where various sub-regions (transcripts, exons, introns etc.) of a gene\nare. Do this so that you can then go onto to model other mappable elements as\nhaving positions 20bp upstream of transcript 2, or 10bp into intron 3 etc., all\nwithout having to know the absolute position of anything.\n\nSee Bio::Map::GeneRelative and t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GenePosition;\nuse strict;\n\nuse Bio::Map::GeneRelative;\n\nuse base qw(Bio::Map::PositionWithSequence);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GenePosition->new();\n Function: Builds a new Bio::Map::GenePosition object \n Returns : Bio::Map::GenePosition\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -type     => 'transcript|coding|exon|intron', REQUIRED\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($type) = $self->_rearrange([qw( TYPE )], @args);\n\t$type || $self->throw(\"type must be supplied\");\n    $self->type($type);\n    \n    $self->{_relative_not_implicit} = 1;\n    \n    return $self;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    if ($map) {\n        $map->isa('Bio::Map::GeneMap') || $self->throw(\"This is [$map], not a Bio::Map::GeneMap\");\n    }\n    return $self->SUPER::map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $element->isa('Bio::Map::Gene') || $self->throw(\"This is [$element], not a Bio::Map::Gene\");\n    }\n    return $self->SUPER::element($element);\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $position->type();\n           $position->type($type);\n Function: Get/set the type of this position.\n Returns : string\n Args    : none to get, OR\n           string transcript|coding|exon|intron to set\n\n\nsub type {\n    my $self = shift;\n    if (@_) {\n        my $type = shift;\n        if ($type !~ /transcript|coding|exon|intron/i) {\n            $self->throw(\"type must be supplied and be one of 'transcript', 'coding', 'exon', 'intron'\");\n        }\n        $self->{type} = $type;\n    }\n    return $self->{type};\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a RelativeI object.\n  Returns : Bio::Map::GeneRelative. The default GeneRelative returned has a\n            meaning that depends on the type() of GenePosition this is:\n            'transcript'         : \"relative to the start of the gene on the\n                                    Position's map\"\n            'coding|exon|intron' : \"relative to the start of the default\n                                    transcript of the gene on the Position's map\"\n  Args    : none to get, OR\n            Bio::Map::GeneRelative to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::GeneRelative\") unless $relative->isa('Bio::Map::GeneRelative');\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->_default_relative;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $position->seq();\n Function: Get/set the sequence as a string of letters. If no sequence is\n           manually set by you, the position's map will be asked for the\n           sequence, and if available, that will be returned.\n Returns : scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).","label":"seq($self,$str,$alpha,$shortcut)"},"kind":12,"line":255,"children":[{"line":257,"kind":13,"localvar":"my","containerName":"seq","name":"$self","definition":"my"},{"name":"$str","containerName":"seq","kind":13,"line":257},{"name":"$alpha","containerName":"seq","line":257,"kind":13},{"kind":13,"line":257,"name":"$shortcut","containerName":"seq"},{"localvar":"my","containerName":"seq","definition":"my","name":"$seq","line":259,"kind":13},{"containerName":"seq","name":"$self","line":259,"kind":13},{"containerName":"seq","name":"$str","kind":13,"line":259},{"kind":13,"line":259,"containerName":"seq","name":"$alpha"},{"line":261,"kind":13,"name":"$seq","containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":262},{"containerName":"seq","name":"length","kind":12,"line":262},{"kind":13,"line":262,"name":"$seq","containerName":"seq"},{"name":"$seq","containerName":"seq","kind":13,"line":263},{"line":265,"kind":13,"name":"$shortcut","containerName":"seq"},{"containerName":"seq","definition":"my","name":"$map","localvar":"my","kind":13,"line":265},{"name":"$self","containerName":"seq","line":265,"kind":13},{"kind":12,"line":265,"name":"map","containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":265},{"containerName":"seq","name":"$self","line":266,"kind":13},{"line":267,"kind":13,"containerName":"seq","name":"$seq"},{"line":267,"kind":13,"name":"$map","containerName":"seq"},{"kind":12,"line":267,"containerName":"seq","name":"subseq"},{"line":267,"kind":13,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":268},{"line":269,"kind":13,"containerName":"seq","name":"$seq"}]},{"name":"SUPER","containerName":"seq","kind":12,"line":259},{"line":262,"kind":12,"containerName":"length","name":"CORE"},{"kind":12,"line":265,"name":"_getting_seq"},{"kind":12,"line":266,"name":"_getting_seq"},{"name":"_getting_seq","line":268,"kind":12},{"range":{"end":{"character":9999,"line":284},"start":{"line":275,"character":0}},"containerName":"main::","definition":"sub","name":"_default_relative","line":275,"children":[{"name":"$self","definition":"my","containerName":"_default_relative","localvar":"my","kind":13,"line":276},{"kind":13,"line":277,"containerName":"_default_relative","definition":"my","name":"$type","localvar":"my"},{"kind":13,"line":277,"containerName":"_default_relative","name":"$self"},{"name":"type","containerName":"_default_relative","line":277,"kind":12},{"kind":13,"line":278,"name":"$type","containerName":"_default_relative"},{"line":279,"kind":12,"name":"new","containerName":"_default_relative"},{"line":282,"kind":12,"name":"new","containerName":"_default_relative"}],"kind":12},{"kind":12,"line":279,"containerName":"Map::GeneRelative","name":"Bio"},{"containerName":"Map::GeneRelative","name":"Bio","line":282,"kind":12}]}