{"version":5,"vars":[{"name":"base","containerName":"","line":116,"kind":2},{"range":{"start":{"character":0,"line":130},"end":{"character":9999,"line":138}},"name":"new","signature":{"documentation":"1;\n# $Id: Prediction.pm,v 1.10 2006/09/28 14:09:40 sendu Exp $\n#\n# BioPerl module for Bio::Map::Prediction\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Prediction - An object representing the predictions of something\nthat can have multiple locations in several maps.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Prediction;\n  use Bio::Map::Position;\n\n  # normally you would get predictions from a run wrapper like\n  # Bio::Tools::Run::Meme, but here we create some manually:\n  my $pred1 = Bio::Map::Prediction->new(-source => 'meme');\n  Bio::Map::Position->new(-element => $prediction1,\n\t\t\t\t\t\t  -map => Bio::Map::GeneMap->get(-gene => 'gene1',\n\t\t\t\t\t\t                                 -species => 'species1'),\n\t\t\t\t\t\t  -start => 950,\n\t\t\t\t\t\t  -end => 960);\n  Bio::Map::Position->new(-element => $prediction1,\n                          -map => Bio::Map::GeneMap->get(-gene => 'gene1',\n\t\t\t\t\t\t                                 -species => 'species2'),\n                          -start => 1950,\n                          -end => 1960);\n  Bio::Map::Position->new(-element => $prediction1,\n                          -map => Bio::Map::GeneMap->get(-gene => 'gene2',\n\t\t\t\t\t\t                                 -species => 'species1'),\n                          -start => 955,\n                          -end => 965);\n  Bio::Map::Position->new(-element => $prediction1,\n                          -map => Bio::Map::GeneMap->get(-gene => 'gene2',\n\t      \t\t\t\t                                 -species => 'species2'),\n                          -start => 1955,\n                          -end => 1965);\n\n  my $pred2 = Bio::Map::Prediction->new(-source => 'gerp');\n  Bio::Map::Position->new(-element => $prediction2,\n                          -map => Bio::Map::GeneMap->get(-gene => 'gene1',\n\t\t\t\t\t\t                                 -species => 'species1'),\n                          -start => 950,\n                          -end => 960);\n  # etc.\n\n  # find the places where predictions agree\n  use Bio::Map::GeneRelative;\n  my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n  my $di = Bio::Map::Mappable->disconnected_intersections([$pred1, $pred2],\n                                                -min_mappables_percent => 100,\n                                                -min_map_percent => 100,\n                                                -relative => $rel);\n  my @positions = $di->get_positions;\n\n=head1 DESCRIPTION\n\nFor example, used to model transcription factor binding site predictions, which\ncan have multiple locations in several maps.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Prediction;\nuse strict;\n\nuse base qw(Bio::Map::Mappable);\n\n=head2 new\n\n Title   : new\n Usage   : my $prediction = Bio::Map::Prediction->new();\n Function: Builds a new Bio::Map::Prediction object\n Returns : Bio::Map::Prediction\n Args    : -name   => string : name of the mappable element\n           -id     => string : id of the mappable element\n           -source => string : name of the prediction program","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":131,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"@args","containerName":"new","line":131,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":132,"kind":13},{"containerName":"new","name":"$class","line":132,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":132},{"kind":13,"line":134,"containerName":"new","definition":"my","name":"$source","localvar":"my"},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":134},{"containerName":"new","name":"@args","line":134,"kind":13},{"line":135,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"source","kind":12,"line":135},{"name":"$source","containerName":"new","line":135,"kind":13},{"containerName":"new","name":"$source","line":135,"kind":13},{"kind":13,"line":137,"name":"$self","containerName":"new"}],"line":130,"kind":12},{"kind":12,"line":132,"name":"SUPER","containerName":"new"},{"definition":"sub","name":"source","containerName":"main::","range":{"end":{"character":9999,"line":156},"start":{"line":152,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"source","definition":"my","name":"$self","line":153,"kind":13},{"containerName":"source","name":"$self","line":154,"kind":13},{"kind":13,"line":155,"containerName":"source","name":"$self"}],"line":152},{"name":"_source","line":154,"kind":12},{"kind":12,"line":155,"name":"_source"}]}