{"vars":[{"kind":2,"line":96,"containerName":"","name":"vars"},{"kind":2,"line":100,"containerName":"","name":"base"},{"name":"$MAPCOUNT","containerName":null,"line":101,"kind":13},{"name":"new","range":{"start":{"character":0,"line":116},"end":{"character":9999,"line":136}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":117,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"line":117,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":119,"kind":13},{"line":119,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":119,"kind":13},{"kind":13,"line":121,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":122},{"line":123,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","line":124,"kind":13},{"kind":13,"line":125,"name":"$self","containerName":"new"},{"containerName":"new","name":"$MAPCOUNT","kind":13,"line":125},{"kind":13,"line":126,"containerName":"new","definition":"my","name":"$name","localvar":"my"},{"containerName":"new","name":"$type","kind":13,"line":126},{"line":126,"kind":13,"name":"$species","containerName":"new"},{"kind":13,"line":126,"containerName":"new","name":"$units"},{"name":"$uid","containerName":"new","kind":13,"line":126},{"line":126,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":126},{"line":128,"kind":13,"containerName":"new","name":"@args"},{"line":129,"kind":13,"containerName":"new","name":"$name"},{"kind":13,"line":129,"containerName":"new","name":"$self"},{"containerName":"new","name":"name","kind":12,"line":129},{"line":129,"kind":13,"name":"$name","containerName":"new"},{"name":"$species","containerName":"new","kind":13,"line":130},{"kind":13,"line":130,"name":"$self","containerName":"new"},{"containerName":"new","name":"species","line":130,"kind":12},{"containerName":"new","name":"$species","kind":13,"line":130},{"line":131,"kind":13,"name":"$units","containerName":"new"},{"name":"$self","containerName":"new","line":131,"kind":13},{"line":131,"kind":12,"name":"units","containerName":"new"},{"line":131,"kind":13,"containerName":"new","name":"$units"},{"line":132,"kind":13,"name":"$type","containerName":"new"},{"line":132,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":132,"containerName":"new","name":"type"},{"line":132,"kind":13,"containerName":"new","name":"$type"},{"containerName":"new","name":"$uid","line":133,"kind":13},{"kind":13,"line":133,"containerName":"new","name":"$self"},{"name":"unique_id","containerName":"new","kind":12,"line":133},{"kind":13,"line":133,"name":"$uid","containerName":"new"},{"line":135,"kind":13,"name":"$self","containerName":"new"}],"line":116},{"name":"SUPER","containerName":"new","kind":12,"line":119},{"line":148,"children":[{"kind":13,"line":149,"name":"$self","definition":"my","containerName":"species","localvar":"my"},{"line":149,"kind":13,"containerName":"species","name":"$value"},{"kind":13,"line":150,"name":"$value","containerName":"species"},{"kind":13,"line":151,"name":"$self","containerName":"species"},{"containerName":"species","name":"$value","kind":13,"line":151},{"kind":13,"line":153,"name":"$self","containerName":"species"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"species($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":154,"character":9999},"start":{"line":148,"character":0}},"name":"species"},{"range":{"start":{"line":166,"character":0},"end":{"line":172,"character":9999}},"name":"units","children":[{"line":167,"kind":13,"localvar":"my","containerName":"units","name":"$self","definition":"my"},{"containerName":"units","name":"$value","line":167,"kind":13},{"line":168,"kind":13,"name":"$value","containerName":"units"},{"line":169,"kind":13,"containerName":"units","name":"$self"},{"name":"$value","containerName":"units","kind":13,"line":169},{"name":"$self","containerName":"units","line":171,"kind":13}],"line":166,"kind":12,"signature":{"label":"units($self,$value)","documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)\n\n\nsub units{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_units'} = $value;\n   }\n   return $self->{'_units'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get/Set Map type\n Returns : String coding map type\n Args    : (optional) string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"type($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"type","definition":"my","name":"$self","line":185,"kind":13},{"line":185,"kind":13,"name":"$value","containerName":"type"},{"containerName":"type","name":"$value","kind":13,"line":188},{"containerName":"type","name":"$self","kind":13,"line":189},{"kind":13,"line":189,"containerName":"type","name":"$value"},{"containerName":"type","name":"$self","line":191,"kind":13}],"line":184,"name":"type","range":{"end":{"line":192,"character":9999},"start":{"line":184,"character":0}}},{"range":{"end":{"character":9999,"line":210},"start":{"line":204,"character":0}},"name":"name","children":[{"kind":13,"line":205,"definition":"my","name":"$self","containerName":"name","localvar":"my"},{"containerName":"name","name":"$value","kind":13,"line":205},{"line":206,"kind":13,"containerName":"name","name":"$value"},{"line":207,"kind":13,"containerName":"name","name":"$self"},{"kind":13,"line":207,"name":"$value","containerName":"name"},{"kind":13,"line":209,"name":"$self","containerName":"name"}],"line":204,"kind":12,"signature":{"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)\n\n\nsub units{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_units'} = $value;\n   }\n   return $self->{'_units'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get/Set Map type\n Returns : String coding map type\n Args    : (optional) string\n\n\nsub type {\n   my ($self,$value) = @_;\n   # this may be hardcoded/overriden by subclasses\n\n   if( defined $value ) {\n       $self->{'_type'} = $value;\n   }\n   return $self->{'_type'};\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $map->name\n Function: Get/Set Map name\n Returns : Map name\n Args    : (optional) string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"name($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","containerName":"length","name":"$self","definition":"my","line":226,"kind":13},{"kind":13,"line":228,"containerName":"length","name":"$len","definition":"my","localvar":"my"},{"containerName":"length","name":"$element","definition":"my","localvar":"my","kind":13,"line":229},{"name":"$self","containerName":"length","line":229,"kind":13},{"kind":12,"line":229,"name":"get_elements","containerName":"length"},{"kind":13,"line":230,"containerName":"length","name":"$pos","definition":"my","localvar":"my"},{"name":"$element","containerName":"length","kind":13,"line":230},{"containerName":"length","name":"get_positions","line":230,"kind":12},{"name":"$self","containerName":"length","kind":13,"line":230},{"kind":13,"line":231,"containerName":"length","name":"$pos"},{"name":"value","containerName":"length","kind":12,"line":231},{"kind":13,"line":232,"containerName":"length","name":"$len"},{"kind":13,"line":232,"containerName":"length","name":"$pos"},{"line":232,"kind":12,"containerName":"length","name":"end"},{"line":232,"kind":13,"containerName":"length","name":"$pos"},{"line":232,"kind":12,"containerName":"length","name":"end"},{"kind":13,"line":232,"name":"$len","containerName":"length"},{"containerName":"length","name":"$len","line":237,"kind":13}],"line":225,"kind":12,"range":{"start":{"character":0,"line":225},"end":{"character":9999,"line":238}},"definition":"sub","name":"length","containerName":"main::"},{"name":"unique_id","range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":250}},"kind":12,"line":250,"children":[{"kind":13,"line":251,"definition":"my","name":"$self","containerName":"unique_id","localvar":"my"},{"containerName":"unique_id","name":"$id","kind":13,"line":251},{"name":"$id","containerName":"unique_id","line":252,"kind":13},{"containerName":"unique_id","name":"$self","line":253,"kind":13},{"containerName":"unique_id","name":"$id","kind":13,"line":253},{"kind":13,"line":255,"name":"$self","containerName":"unique_id"}],"containerName":"main::","definition":"sub","detail":"($self,$id)","signature":{"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)\n\n\nsub units{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_units'} = $value;\n   }\n   return $self->{'_units'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get/Set Map type\n Returns : String coding map type\n Args    : (optional) string\n\n\nsub type {\n   my ($self,$value) = @_;\n   # this may be hardcoded/overriden by subclasses\n\n   if( defined $value ) {\n       $self->{'_type'} = $value;\n   }\n   return $self->{'_type'};\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $map->name\n Function: Get/Set Map name\n Returns : Map name\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map.\n           It is possible for the length to be unknown for maps such as\n           Restriction Enzyme, will return 0 in that case.\n Returns : integer representing length of map in current units\n           will return 0 if length is not calculateable\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n    \n\tmy $len = 0;\n    foreach my $element ($self->get_elements) {\n        foreach my $pos ($element->get_positions($self)) {\n            if ($pos->value) {\n                $len = $pos->end if $pos->end > $len;\n            }\n        }\n\t}\n    \n\treturn $len;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/Set the unique ID for this map\n Returns : a unique identifier\n Args    : [optional] new identifier to set","parameters":[{"label":"$self"},{"label":"$id"}],"label":"unique_id($self,$id)"}},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"add_element","localvar":"my","kind":13,"line":274},{"name":"$element","containerName":"add_element","line":274,"kind":13},{"containerName":"add_element","name":"$element","kind":13,"line":275},{"containerName":"add_element","name":"$self","kind":13,"line":277},{"name":"throw","containerName":"add_element","line":277,"kind":12},{"containerName":"add_element","name":"$element","line":278,"kind":13},{"line":278,"kind":12,"containerName":"add_element","name":"isa"},{"kind":13,"line":280,"containerName":"add_element","name":"$element"},{"kind":12,"line":280,"name":"default_map","containerName":"add_element"},{"containerName":"add_element","name":"$self","line":280,"kind":13}],"line":273,"definition":"sub","containerName":"main::","signature":{"label":"add_element($self,$element)","documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)\n\n\nsub units{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_units'} = $value;\n   }\n   return $self->{'_units'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get/Set Map type\n Returns : String coding map type\n Args    : (optional) string\n\n\nsub type {\n   my ($self,$value) = @_;\n   # this may be hardcoded/overriden by subclasses\n\n   if( defined $value ) {\n       $self->{'_type'} = $value;\n   }\n   return $self->{'_type'};\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $map->name\n Function: Get/Set Map name\n Returns : Map name\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map.\n           It is possible for the length to be unknown for maps such as\n           Restriction Enzyme, will return 0 in that case.\n Returns : integer representing length of map in current units\n           will return 0 if length is not calculateable\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n    \n\tmy $len = 0;\n    foreach my $element ($self->get_elements) {\n        foreach my $pos ($element->get_positions($self)) {\n            if ($pos->value) {\n                $len = $pos->end if $pos->end > $len;\n            }\n        }\n\t}\n    \n\treturn $len;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/Set the unique ID for this map\n Returns : a unique identifier\n Args    : [optional] new identifier to set\n\n\nsub unique_id {\n   my ($self,$id) = @_;\n   if( defined $id ) {\n       $self->{'_uid'} = $id;\n   }\n   return $self->{'_uid'};\n}\n\n=head2 add_element\n\n Title   : add_element\n Usage   : $map->add_element($element)\n Function: Tell a Bio::Map::MappableI object its default Map is this one; same\n           as calling $element->default_map($map).\n\n\t\t   *** does not actually add the element to this map! ***\n\n Returns : none\n Args    : Bio::Map::MappableI object\n Status  : Deprecated, will be removed in next version","parameters":[{"label":"$self"},{"label":"$element"}]},"detail":"($self,$element)","name":"add_element","range":{"end":{"character":9999,"line":281},"start":{"character":0,"line":273}}},{"containerName":"main::","name":"get_elements","definition":"sub","range":{"start":{"line":294,"character":0},"end":{"line":314,"character":9999}},"kind":12,"line":294,"children":[{"kind":13,"line":295,"name":"$self","definition":"my","containerName":"get_elements","localvar":"my"},{"line":297,"kind":13,"localvar":"my","containerName":"get_elements","name":"@elements","definition":"my"},{"name":"$self","containerName":"get_elements","kind":13,"line":297},{"localvar":"my","containerName":"get_elements","definition":"my","name":"$only_1","line":302,"kind":13},{"kind":13,"line":303,"name":"$element","definition":"my","containerName":"get_elements","localvar":"my"},{"containerName":"get_elements","name":"@elements","kind":13,"line":303},{"localvar":"my","containerName":"get_elements","definition":"my","name":"@positions","line":304,"kind":13},{"containerName":"get_elements","name":"$element","line":304,"kind":13},{"containerName":"get_elements","name":"get_positions","line":304,"kind":12},{"name":"$self","containerName":"get_elements","kind":13,"line":304},{"kind":13,"line":305,"containerName":"get_elements","name":"@positions"},{"containerName":"get_elements","name":"@positions","kind":13,"line":305},{"name":"$positions","containerName":"get_elements","kind":13,"line":305},{"line":305,"kind":12,"containerName":"get_elements","name":"value"},{"containerName":"get_elements","name":"$only_1","kind":13,"line":306},{"line":309,"kind":13,"name":"$only_1","containerName":"get_elements"},{"containerName":"get_elements","name":"@elements","line":310,"kind":13},{"kind":13,"line":311,"name":"$a","containerName":"get_elements"},{"line":311,"kind":13,"name":"$b","containerName":"get_elements"},{"kind":12,"line":312,"containerName":"get_elements","name":"get_positions"},{"line":312,"kind":13,"name":"$self","containerName":"get_elements"},{"containerName":"get_elements","name":"sortable","kind":12,"line":312},{"kind":13,"line":313,"name":"@elements","containerName":"get_elements"}]},{"line":302,"kind":12,"containerName":"get_elements","name":"SUPER"},{"line":316,"kind":13,"name":"@elements","containerName":null},{"name":"purge_element","range":{"end":{"line":346,"character":9999},"start":{"character":0,"line":339}},"containerName":"main::","definition":"sub","detail":"($self,$element)","signature":{"label":"purge_element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: SimpleMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::SimpleMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::SimpleMap - A MapI implementation handling the basics of a Map \n\n=head1 SYNOPSIS\n\n    use Bio::Map::SimpleMap;\n\n    my $map = Bio::Map::SimpleMap->new(-name => 'genethon',\n\t\t\t\t      -type => 'Genetic',\n\t\t\t\t      -units=> 'cM',\n\t\t\t\t      -species => $human);\n\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t\t$map->add_element($marker);\n    }\n\n    foreach my $marker ($map->get_elements) {\n        # do something with this Bio::Map::MappableI\n    }\n\n=head1 DESCRIPTION\n\nThis is the basic implementation of a Bio::Map::MapI. It handles the\nessential storage of name, species, type, and units.\n\nIt knows which map elements (mappables) belong to it, and their\nposition.\n\nSubclasses might need to redefine or hardcode type(), length() and\nunits().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::SimpleMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Map::MapI);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::SimpleMap->new();\n Function: Builds a new Bio::Map::SimpleMap object\n Returns : Bio::Map::SimpleMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -units   => map units (string)\n           -uid     => Unique Id [defaults to a unique integer]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_name'}     = '';\n  $self->{'_species'}  = '';\n  $self->{'_units'}    = '';\n  $self->{'_type'}    = '';\n  $self->{'_uid'} = $MAPCOUNT++;\n  my ($name, $type,$species, $units,$uid) = $self->_rearrange([qw(NAME TYPE\n\t\t\t\t\t      SPECIES UNITS\n\t\t\t\t\t      UID)], @args);\n  defined $name     && $self->name($name);\n  defined $species  && $self->species($species);\n  defined $units    && $self->units($units);\n  defined $type     && $self->type($type);\n  defined $uid      && $self->unique_id($uid);\n    \n  return $self;\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/Set Species for a map\n Returns : Bio::Taxon object or string\n Args    : (optional) Bio::Taxon or string\n\n\nsub species{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_species'} = $value;\n   }\n   return $self->{'_species'};\n}\n\n=head2 units\n\n Title   : units\n Usage   : $map->units('cM');\n Function: Get/Set units for a map\n Returns : units for a map\n Args    : units for a map (string)\n\n\nsub units{\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_units'} = $value;\n   }\n   return $self->{'_units'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get/Set Map type\n Returns : String coding map type\n Args    : (optional) string\n\n\nsub type {\n   my ($self,$value) = @_;\n   # this may be hardcoded/overriden by subclasses\n\n   if( defined $value ) {\n       $self->{'_type'} = $value;\n   }\n   return $self->{'_type'};\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $map->name\n Function: Get/Set Map name\n Returns : Map name\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map.\n           It is possible for the length to be unknown for maps such as\n           Restriction Enzyme, will return 0 in that case.\n Returns : integer representing length of map in current units\n           will return 0 if length is not calculateable\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n    \n\tmy $len = 0;\n    foreach my $element ($self->get_elements) {\n        foreach my $pos ($element->get_positions($self)) {\n            if ($pos->value) {\n                $len = $pos->end if $pos->end > $len;\n            }\n        }\n\t}\n    \n\treturn $len;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/Set the unique ID for this map\n Returns : a unique identifier\n Args    : [optional] new identifier to set\n\n\nsub unique_id {\n   my ($self,$id) = @_;\n   if( defined $id ) {\n       $self->{'_uid'} = $id;\n   }\n   return $self->{'_uid'};\n}\n\n=head2 add_element\n\n Title   : add_element\n Usage   : $map->add_element($element)\n Function: Tell a Bio::Map::MappableI object its default Map is this one; same\n           as calling $element->default_map($map).\n\n\t\t   *** does not actually add the element to this map! ***\n\n Returns : none\n Args    : Bio::Map::MappableI object\n Status  : Deprecated, will be removed in next version\n\n\nsub add_element {\n    my ($self, $element) = @_;\n    return unless $element;\n\t\n    $self->throw(\"This is not a Bio::Map::MappableI object but a [$element]\")\n\tunless $element->isa('Bio::Map::MappableI');\n\t\n    $element->default_map($self);\n}\n\n=head2 get_elements\n\n Title   : get_elements\n Usage   : my @elements = $map->get_elements;\n Function: Retrieves all the elements on a map (unordered unless all elements\n           have just 1 position on the map, in which case sorted)\n Returns : Array of Map elements (L<Bio::Map::MappableI>)\n Args    : none\n\n\nsub get_elements {\n\tmy $self = shift;\n\t\n    my @elements = $self->SUPER::get_elements;\n    \n\t# for backward compatability with MapIO tests, and for 'niceness', when\n\t# there is only 1 position per element we will return the elements in\n\t# order, as long as the positions have values set\n    my $only_1 = 1;\n    foreach my $element (@elements) {\n        my @positions = $element->get_positions($self);\n        if (@positions > 1 || (@positions == 1 && ! $positions[0]->value)) {\n            $only_1 = 0;\n        }\n    }\n\tif ($only_1) {\n\t\t@elements = map { $_->[1] }\n                    sort { $a->[0] <=> $b->[0] }\n                    map { [${[$_->get_positions($self)]}[0]->sortable, $_] }\n                    @elements;\n\t}\n\t\n\treturn @elements;\n}\n\n=head2 each_element\n\n Title   : each_element\n Function: Synonym of the get_elements() method.\n Status  : deprecated, will be removed in the next version\n\n\n*each_element = \\&get_elements;\n\n=head2 purge_element\n\n Title   : purge_element\n Usage   : $map->purge_element($element)\n Function: Purge an element from the map.\n Returns : none\n Args    : Bio::Map::MappableI object"},"kind":12,"line":339,"children":[{"line":340,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"purge_element"},{"line":340,"kind":13,"containerName":"purge_element","name":"$element"},{"name":"$self","containerName":"purge_element","kind":13,"line":341},{"kind":12,"line":341,"name":"throw","containerName":"purge_element"},{"containerName":"purge_element","name":"$element","kind":13,"line":341},{"line":342,"kind":13,"name":"$self","containerName":"purge_element"},{"containerName":"purge_element","name":"throw","kind":12,"line":342},{"name":"$element","containerName":"purge_element","line":342,"kind":13},{"kind":13,"line":343,"name":"$self","containerName":"purge_element"},{"kind":12,"line":343,"containerName":"purge_element","name":"throw"},{"name":"$element","containerName":"purge_element","kind":13,"line":343},{"name":"isa","containerName":"purge_element","kind":12,"line":343},{"kind":13,"line":345,"name":"$self","containerName":"purge_element"},{"line":345,"kind":12,"name":"purge_positions","containerName":"purge_element"},{"line":345,"kind":13,"name":"$element","containerName":"purge_element"}]},{"range":{"end":{"line":365,"character":9999},"start":{"character":0,"line":361}},"name":"annotation","definition":"sub","containerName":"main::","children":[{"kind":13,"line":362,"containerName":"annotation","definition":"my","name":"$self","localvar":"my"},{"containerName":"annotation","name":"$self","line":363,"kind":13},{"name":"$self","containerName":"annotation","line":364,"kind":13}],"line":361,"kind":12},{"name":"_annotation","kind":12,"line":363},{"name":"_annotation","kind":12,"line":364}],"version":5}