{"vars":[{"kind":2,"line":87,"name":"base","containerName":""},{"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":105,"kind":13},{"kind":13,"line":105,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":107,"kind":13},{"name":"$class","containerName":"new","line":107,"kind":13},{"line":107,"kind":13,"name":"@args","containerName":"new"},{"line":108,"kind":13,"localvar":"my","name":"$values","definition":"my","containerName":"new"},{"name":"$rownames","containerName":"new","line":108,"kind":13},{"name":"$colnames","containerName":"new","line":108,"kind":13},{"containerName":"new","name":"$id","kind":13,"line":109},{"line":109,"kind":13,"containerName":"new","name":"$name"},{"name":"$init_val","containerName":"new","kind":13,"line":109},{"line":110,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":110},{"kind":13,"line":112,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":113},{"kind":12,"line":113,"name":"matrix_id","containerName":"new"},{"line":113,"kind":13,"name":"$id","containerName":"new"},{"line":113,"kind":13,"name":"$id","containerName":"new"},{"kind":13,"line":114,"name":"$self","containerName":"new"},{"containerName":"new","name":"matrix_name","kind":12,"line":114},{"kind":13,"line":114,"name":"$name","containerName":"new"},{"kind":13,"line":114,"name":"$name","containerName":"new"},{"kind":13,"line":115,"containerName":"new","name":"$rownames"},{"line":115,"kind":13,"containerName":"new","name":"$colnames"},{"name":"$rownames","containerName":"new","line":116,"kind":13},{"containerName":"new","name":"$self","line":117,"kind":13},{"name":"throw","containerName":"new","kind":12,"line":117},{"containerName":"new","name":"$self","kind":13,"line":120},{"name":"$rownames","containerName":"new","kind":13,"line":120},{"line":121,"kind":13,"localvar":"my","name":"$count","definition":"my","containerName":"new"},{"containerName":"new","name":"$self","line":122,"kind":13},{"containerName":"new","name":"$count","line":122,"kind":13},{"containerName":"new","name":"$rownames","kind":13,"line":122},{"name":"$colnames","containerName":"new","line":124,"kind":13},{"kind":13,"line":125,"containerName":"new","name":"$self"},{"line":125,"kind":12,"containerName":"new","name":"throw"},{"kind":13,"line":128,"containerName":"new","name":"$self"},{"name":"$colnames","containerName":"new","line":128,"kind":13},{"containerName":"new","name":"$count","kind":13,"line":129},{"line":130,"kind":13,"containerName":"new","name":"$self"}],"line":104,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":104}},"name":"new"},{"kind":12,"line":107,"name":"SUPER","containerName":"new"},{"kind":13,"line":130,"name":"$count","containerName":null},{"name":"$colnames","containerName":null,"line":130,"kind":13},{"line":132,"kind":13,"name":"%self","containerName":null},{"line":133,"kind":13,"containerName":null,"name":"%values"},{"name":"%values","containerName":null,"kind":13,"line":134},{"kind":13,"line":135,"name":"$self","containerName":null},{"containerName":"main::","name":"throw","line":135,"kind":12},{"line":137,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%v"},{"name":"%v","containerName":null,"line":138,"kind":13},{"kind":13,"line":139,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","line":139,"kind":12},{"name":"%self","containerName":null,"line":141,"kind":13},{"containerName":null,"name":"%v","kind":13,"line":141},{"localvar":"my","definition":"my","name":"@fill","containerName":null,"line":144,"kind":13},{"containerName":null,"name":"$init_val","line":144,"kind":13},{"line":144,"kind":13,"containerName":null,"name":"$colnames"},{"containerName":null,"name":"%rownames","line":145,"kind":13},{"containerName":null,"name":"%self","line":146,"kind":13},{"containerName":null,"name":"@fill","kind":13,"line":146},{"name":"$rownames","containerName":null,"kind":13,"line":149},{"line":149,"kind":13,"name":"$colnames","containerName":null},{"kind":13,"line":149,"containerName":null,"name":"%values"},{"name":"%self","containerName":null,"kind":13,"line":150},{"name":"%self","containerName":null,"kind":13,"line":151},{"containerName":null,"name":"%self","line":152,"kind":13},{"name":"$self","containerName":null,"line":154,"kind":13},{"name":"throw","containerName":"main::","line":154,"kind":12},{"kind":13,"line":157,"name":"$self","containerName":null},{"definition":"sub","name":"matrix_id","containerName":"main::","range":{"end":{"character":9999,"line":178},"start":{"character":0,"line":172}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"matrix_id","localvar":"my","kind":13,"line":173},{"line":174,"kind":13,"name":"$self","containerName":"matrix_id"},{"name":"$self","containerName":"matrix_id","kind":13,"line":175}],"line":172},{"definition":"sub","name":"matrix_name","containerName":"main::","range":{"start":{"line":191,"character":0},"end":{"line":195,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"matrix_name","definition":"my","name":"$self","line":192,"kind":13},{"kind":13,"line":193,"name":"$self","containerName":"matrix_name"},{"name":"$self","containerName":"matrix_name","kind":13,"line":194}],"line":191},{"name":"entry","range":{"start":{"character":0,"line":211},"end":{"character":9999,"line":220}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$column"},{"label":"$newvalue"}],"label":"entry($self,$row,$column,$newvalue)"},"detail":"($self,$row,$column,$newvalue)","kind":12,"children":[{"kind":13,"line":212,"containerName":"entry","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":212,"containerName":"entry","name":"$row"},{"name":"$column","containerName":"entry","line":212,"kind":13},{"kind":13,"line":212,"name":"$newvalue","containerName":"entry"},{"containerName":"entry","name":"$row","line":213,"kind":13},{"containerName":"entry","name":"$column","kind":13,"line":213},{"kind":13,"line":214,"containerName":"entry","name":"$self"},{"containerName":"entry","name":"throw","line":214,"kind":12},{"line":217,"kind":13,"localvar":"my","containerName":"entry","definition":"my","name":"$rownum"},{"containerName":"entry","name":"$self","line":217,"kind":13},{"containerName":"entry","name":"row_num_for_name","line":217,"kind":12},{"containerName":"entry","name":"$row","line":217,"kind":13},{"containerName":"entry","definition":"my","name":"$colnum","localvar":"my","kind":13,"line":218},{"line":218,"kind":13,"name":"$self","containerName":"entry"},{"containerName":"entry","name":"column_num_for_name","kind":12,"line":218},{"line":218,"kind":13,"containerName":"entry","name":"$column"},{"kind":13,"line":219,"name":"$self","containerName":"entry"},{"containerName":"entry","name":"entry_by_num","kind":12,"line":219},{"containerName":"entry","name":"$rownum","line":219,"kind":13},{"name":"$colnum","containerName":"entry","line":219,"kind":13},{"name":"$newvalue","containerName":"entry","line":219,"kind":13}],"line":211},{"kind":12,"line":234,"children":[{"containerName":"get_entry","name":"entry","kind":12,"line":234}],"containerName":"main::","definition":"sub","name":"get_entry","range":{"end":{"character":9999,"line":234},"start":{"character":0,"line":234}}},{"range":{"start":{"line":250,"character":0},"end":{"character":9999,"line":264}},"name":"entry_by_num","children":[{"line":251,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"entry_by_num"},{"containerName":"entry_by_num","name":"$row","kind":13,"line":251},{"containerName":"entry_by_num","name":"$col","kind":13,"line":251},{"containerName":"entry_by_num","name":"$newvalue","line":251,"kind":13},{"kind":13,"line":252,"name":"$row","containerName":"entry_by_num"},{"kind":13,"line":252,"containerName":"entry_by_num","name":"$col"},{"kind":13,"line":253,"containerName":"entry_by_num","name":"$row"},{"name":"$col","containerName":"entry_by_num","line":254,"kind":13},{"kind":13,"line":255,"name":"$self","containerName":"entry_by_num"},{"kind":12,"line":255,"containerName":"entry_by_num","name":"warn"},{"containerName":"entry_by_num","name":"$newvalue","kind":13,"line":259},{"name":"$self","containerName":"entry_by_num","kind":13,"line":260},{"name":"_values","containerName":"entry_by_num","kind":12,"line":260},{"line":260,"kind":13,"containerName":"entry_by_num","name":"$row"},{"name":"$col","containerName":"entry_by_num","line":260,"kind":13},{"containerName":"entry_by_num","name":"$newvalue","line":260,"kind":13},{"containerName":"entry_by_num","name":"$self","line":262,"kind":13},{"line":262,"kind":12,"containerName":"entry_by_num","name":"_values"},{"line":262,"kind":13,"containerName":"entry_by_num","name":"$row"},{"name":"$col","containerName":"entry_by_num","kind":13,"line":262}],"line":250,"kind":12,"signature":{"label":"entry_by_num($self,$row,$col,$newvalue)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$col"},{"label":"$newvalue"}]},"detail":"($self,$row,$col,$newvalue)","definition":"sub","containerName":"main::"},{"definition":"sub","name":"get_element","containerName":"main::","range":{"end":{"line":269,"character":9999},"start":{"line":266,"character":0}},"kind":12,"children":[{"kind":13,"line":267,"containerName":"get_element","name":"$self","definition":"my","localvar":"my"},{"containerName":"get_element","name":"$self","kind":13,"line":268},{"containerName":"get_element","name":"entry","line":268,"kind":12}],"line":266},{"signature":{"parameters":[{"label":"$self"},{"label":"$column"},{"label":"$newcol"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here ","label":"column($self,$column,$newcol)"},"detail":"($self,$column,$newcol)","definition":"sub","containerName":"main::","children":[{"containerName":"column","definition":"my","name":"$self","localvar":"my","kind":13,"line":289},{"containerName":"column","name":"$column","line":289,"kind":13},{"containerName":"column","name":"$newcol","kind":13,"line":289},{"kind":13,"line":291,"name":"$column","containerName":"column"},{"line":292,"kind":13,"containerName":"column","name":"$self"},{"line":292,"kind":12,"name":"warn","containerName":"column"},{"kind":13,"line":295,"name":"$colnum","definition":"my","containerName":"column","localvar":"my"},{"containerName":"column","name":"$self","kind":13,"line":295},{"line":295,"kind":12,"containerName":"column","name":"column_num_for_name"},{"line":295,"kind":13,"containerName":"column","name":"$column"},{"kind":13,"line":296,"containerName":"column","name":"$colnum"},{"kind":13,"line":297,"name":"$self","containerName":"column"},{"containerName":"column","name":"warn","line":297,"kind":12},{"name":"$self","containerName":"column","line":300,"kind":13},{"line":300,"kind":12,"containerName":"column","name":"column_by_num"},{"containerName":"column","name":"$colnum","kind":13,"line":300},{"containerName":"column","name":"$newcol","kind":13,"line":300}],"line":288,"kind":12,"range":{"start":{"line":288,"character":0},"end":{"line":301,"character":9999}},"name":"column"},{"name":"get_column","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":316},"start":{"character":0,"line":316}},"kind":12,"children":[{"kind":12,"line":316,"containerName":"get_column","name":"column"}],"line":316},{"range":{"end":{"line":366,"character":9999},"start":{"character":0,"line":334}},"name":"column_by_num","line":334,"children":[{"line":335,"kind":13,"localvar":"my","containerName":"column_by_num","definition":"my","name":"$self"},{"kind":13,"line":335,"name":"$colnum","containerName":"column_by_num"},{"kind":13,"line":335,"containerName":"column_by_num","name":"$newcol"},{"containerName":"column_by_num","name":"$colnum","line":336,"kind":13},{"name":"$self","containerName":"column_by_num","kind":13,"line":337},{"containerName":"column_by_num","name":"warn","kind":12,"line":337},{"line":340,"kind":13,"localvar":"my","containerName":"column_by_num","definition":"my","name":"$rowcount"},{"kind":13,"line":340,"name":"$self","containerName":"column_by_num"},{"line":340,"kind":12,"containerName":"column_by_num","name":"num_rows"},{"line":341,"kind":13,"localvar":"my","definition":"my","name":"$colcount","containerName":"column_by_num"},{"name":"$self","containerName":"column_by_num","line":341,"kind":13},{"containerName":"column_by_num","name":"num_columns","line":341,"kind":12},{"kind":13,"line":342,"name":"$ret","definition":"my","containerName":"column_by_num","localvar":"my"},{"line":344,"kind":13,"name":"$newcol","containerName":"column_by_num"},{"containerName":"column_by_num","name":"$newcol","kind":13,"line":345},{"name":"$self","containerName":"column_by_num","line":346,"kind":13},{"name":"warn","containerName":"column_by_num","line":346,"kind":12},{"line":349,"kind":13,"containerName":"column_by_num","name":"$newcol"},{"name":"$rowcount","containerName":"column_by_num","kind":13,"line":349},{"line":350,"kind":13,"containerName":"column_by_num","name":"$self"},{"containerName":"column_by_num","name":"warn","line":350,"kind":12},{"line":353,"kind":13,"localvar":"my","containerName":"column_by_num","name":"$i","definition":"my"},{"containerName":"column_by_num","name":"$i","line":353,"kind":13},{"kind":13,"line":353,"containerName":"column_by_num","name":"$rowcount"},{"line":353,"kind":13,"name":"$i","containerName":"column_by_num"},{"name":"$self","containerName":"column_by_num","kind":13,"line":354},{"name":"entry_by_num","containerName":"column_by_num","line":354,"kind":12},{"kind":13,"line":354,"name":"$i","containerName":"column_by_num"},{"kind":13,"line":354,"containerName":"column_by_num","name":"$colnum"},{"containerName":"column_by_num","name":"$newcol","kind":13,"line":354},{"name":"$i","containerName":"column_by_num","line":354,"kind":13},{"line":356,"kind":13,"containerName":"column_by_num","name":"$ret"},{"name":"$newcol","containerName":"column_by_num","kind":13,"line":356},{"kind":13,"line":358,"containerName":"column_by_num","name":"$ret"},{"line":359,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"column_by_num"},{"line":359,"kind":13,"containerName":"column_by_num","name":"$i"},{"name":"$rowcount","containerName":"column_by_num","kind":13,"line":359},{"name":"$i","containerName":"column_by_num","line":359,"kind":13},{"name":"$ret","containerName":"column_by_num","line":360,"kind":13},{"containerName":"column_by_num","name":"$self","line":360,"kind":13},{"kind":12,"line":360,"name":"entry_by_num","containerName":"column_by_num"},{"line":360,"kind":13,"name":"$i","containerName":"column_by_num"},{"line":360,"kind":13,"containerName":"column_by_num","name":"$colnum"},{"name":"$ret","containerName":"column_by_num","kind":13,"line":363},{"line":364,"kind":13,"containerName":"column_by_num","name":"$ret"}],"kind":12,"detail":"($self,$colnum,$newcol)","signature":{"label":"column_by_num($self,$colnum,$newcol)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column","parameters":[{"label":"$self"},{"label":"$colnum"},{"label":"$newcol"}]},"containerName":"main::","definition":"sub"},{"children":[{"line":383,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"row"},{"line":383,"kind":13,"containerName":"row","name":"$row"},{"name":"$newrow","containerName":"row","kind":13,"line":383},{"name":"$row","containerName":"row","kind":13,"line":384},{"name":"$self","containerName":"row","line":385,"kind":13},{"name":"warn","containerName":"row","line":385,"kind":12},{"line":388,"kind":13,"localvar":"my","name":"$rownum","definition":"my","containerName":"row"},{"name":"$self","containerName":"row","line":388,"kind":13},{"line":388,"kind":12,"name":"row_num_for_name","containerName":"row"},{"name":"$row","containerName":"row","line":388,"kind":13},{"containerName":"row","name":"$self","line":389,"kind":13},{"containerName":"row","name":"row_by_num","kind":12,"line":389},{"kind":13,"line":389,"name":"$rownum","containerName":"row"},{"kind":13,"line":389,"name":"$newrow","containerName":"row"}],"line":382,"kind":12,"signature":{"label":"row($self,$row,$newrow)","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$newrow"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store"},"detail":"($self,$row,$newrow)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":390},"start":{"line":382,"character":0}},"name":"row"},{"kind":12,"children":[{"name":"row","containerName":"get_row","line":404,"kind":12}],"line":404,"name":"get_row","definition":"sub","containerName":"main::","range":{"start":{"line":404,"character":0},"end":{"line":404,"character":9999}}},{"range":{"start":{"line":419,"character":0},"end":{"line":452,"character":9999}},"name":"row_by_num","children":[{"kind":13,"line":420,"containerName":"row_by_num","definition":"my","name":"$self","localvar":"my"},{"line":420,"kind":13,"containerName":"row_by_num","name":"$rownum"},{"name":"$newrow","containerName":"row_by_num","line":420,"kind":13},{"containerName":"row_by_num","name":"$rownum","kind":13,"line":421},{"line":422,"kind":13,"name":"$self","containerName":"row_by_num"},{"containerName":"row_by_num","name":"warn","kind":12,"line":422},{"localvar":"my","containerName":"row_by_num","definition":"my","name":"$colcount","line":425,"kind":13},{"name":"$self","containerName":"row_by_num","kind":13,"line":425},{"name":"num_columns","containerName":"row_by_num","line":425,"kind":12},{"line":426,"kind":13,"localvar":"my","name":"$ret","definition":"my","containerName":"row_by_num"},{"kind":13,"line":427,"containerName":"row_by_num","name":"$newrow"},{"line":428,"kind":13,"name":"$newrow","containerName":"row_by_num"},{"kind":13,"line":429,"name":"$self","containerName":"row_by_num"},{"kind":12,"line":429,"name":"warn","containerName":"row_by_num"},{"containerName":"row_by_num","name":"$newrow","kind":13,"line":432},{"name":"$colcount","containerName":"row_by_num","line":432,"kind":13},{"containerName":"row_by_num","name":"$self","kind":13,"line":433},{"kind":12,"line":433,"name":"warn","containerName":"row_by_num"},{"line":436,"kind":13,"localvar":"my","containerName":"row_by_num","name":"$i","definition":"my"},{"line":436,"kind":13,"containerName":"row_by_num","name":"$i"},{"containerName":"row_by_num","name":"$colcount","line":436,"kind":13},{"name":"$i","containerName":"row_by_num","line":436,"kind":13},{"line":437,"kind":13,"name":"$self","containerName":"row_by_num"},{"kind":12,"line":437,"containerName":"row_by_num","name":"entry_by_num"},{"line":437,"kind":13,"name":"$rownum","containerName":"row_by_num"},{"containerName":"row_by_num","name":"$i","kind":13,"line":437},{"name":"$newrow","containerName":"row_by_num","line":437,"kind":13},{"name":"$i","containerName":"row_by_num","kind":13,"line":437},{"kind":13,"line":439,"containerName":"row_by_num","name":"$ret"},{"name":"$newrow","containerName":"row_by_num","line":439,"kind":13},{"kind":13,"line":441,"name":"$ret","containerName":"row_by_num"},{"localvar":"my","name":"$i","definition":"my","containerName":"row_by_num","line":442,"kind":13},{"name":"$i","containerName":"row_by_num","line":442,"kind":13},{"kind":13,"line":442,"name":"$colcount","containerName":"row_by_num"},{"containerName":"row_by_num","name":"$i","line":442,"kind":13},{"line":445,"kind":13,"name":"$ret","containerName":"row_by_num"},{"line":445,"kind":13,"name":"$self","containerName":"row_by_num"},{"containerName":"row_by_num","name":"entry_by_num","line":445,"kind":12},{"name":"$rownum","containerName":"row_by_num","kind":13,"line":445},{"name":"$i","containerName":"row_by_num","kind":13,"line":445},{"containerName":"row_by_num","name":"$ret","kind":13,"line":448},{"kind":13,"line":449,"name":"$ret","containerName":"row_by_num"}],"line":419,"kind":12,"signature":{"label":"row_by_num($self,$rownum,$newrow)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store","parameters":[{"label":"$self"},{"label":"$rownum"},{"label":"$newrow"}]},"detail":"($self,$rownum,$newrow)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"get_diagonal($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none"},"detail":"($self)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"get_diagonal","localvar":"my","kind":13,"line":468},{"localvar":"my","containerName":"get_diagonal","name":"@diag","definition":"my","line":469,"kind":13},{"localvar":"my","containerName":"get_diagonal","name":"$rowcount","definition":"my","line":470,"kind":13},{"line":470,"kind":13,"name":"$self","containerName":"get_diagonal"},{"line":470,"kind":12,"name":"num_rows","containerName":"get_diagonal"},{"localvar":"my","definition":"my","name":"$colcount","containerName":"get_diagonal","line":471,"kind":13},{"name":"$self","containerName":"get_diagonal","line":471,"kind":13},{"name":"num_columns","containerName":"get_diagonal","kind":12,"line":471},{"containerName":"get_diagonal","name":"$i","definition":"my","localvar":"my","kind":13,"line":472},{"line":472,"kind":13,"containerName":"get_diagonal","name":"$i"},{"line":472,"kind":13,"containerName":"get_diagonal","name":"$rowcount"},{"containerName":"get_diagonal","name":"$i","kind":13,"line":472},{"name":"@diag","containerName":"get_diagonal","line":473,"kind":13},{"name":"$self","containerName":"get_diagonal","line":473,"kind":13},{"line":473,"kind":12,"containerName":"get_diagonal","name":"entry_by_num"},{"containerName":"get_diagonal","name":"$i","kind":13,"line":473},{"name":"$i","containerName":"get_diagonal","kind":13,"line":473},{"line":475,"kind":13,"containerName":"get_diagonal","name":"@diag"}],"line":467,"name":"get_diagonal","range":{"end":{"line":476,"character":9999},"start":{"line":467,"character":0}}},{"detail":"($self,$index,$name,$newrow)","signature":{"label":"add_row($self,$index,$name,$newrow)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef ","parameters":[{"label":"$self"},{"label":"$index"},{"label":"$name"},{"label":"$newrow"}]},"containerName":"main::","definition":"sub","line":496,"children":[{"line":497,"kind":13,"localvar":"my","containerName":"add_row","name":"$self","definition":"my"},{"line":497,"kind":13,"name":"$index","containerName":"add_row"},{"name":"$name","containerName":"add_row","line":497,"kind":13},{"line":497,"kind":13,"containerName":"add_row","name":"$newrow"},{"line":498,"kind":13,"containerName":"add_row","name":"$index"},{"line":499,"kind":13,"containerName":"add_row","name":"$index"},{"kind":13,"line":500,"containerName":"add_row","name":"$self"},{"kind":12,"line":500,"name":"warn","containerName":"add_row"},{"line":502,"kind":13,"name":"$name","containerName":"add_row"},{"containerName":"add_row","name":"$self","kind":13,"line":503},{"containerName":"add_row","name":"warn","kind":12,"line":503},{"kind":13,"line":505,"name":"$self","containerName":"add_row"},{"containerName":"add_row","name":"row_num_for_name","kind":12,"line":505},{"kind":13,"line":505,"name":"$name","containerName":"add_row"},{"name":"$self","containerName":"add_row","line":506,"kind":13},{"containerName":"add_row","name":"warn","line":506,"kind":12},{"localvar":"my","containerName":"add_row","name":"$colcount","definition":"my","line":509,"kind":13},{"line":509,"kind":13,"name":"$self","containerName":"add_row"},{"containerName":"add_row","name":"num_columns","line":509,"kind":12},{"kind":13,"line":510,"definition":"my","name":"$rowcount","containerName":"add_row","localvar":"my"},{"line":510,"kind":13,"name":"$self","containerName":"add_row"},{"line":510,"kind":12,"containerName":"add_row","name":"num_rows"},{"line":512,"kind":13,"containerName":"add_row","name":"$index"},{"containerName":"add_row","name":"$rowcount","line":512,"kind":13},{"name":"$self","containerName":"add_row","kind":13,"line":513},{"line":513,"kind":12,"name":"warn","containerName":"add_row"},{"containerName":"add_row","name":"$index","kind":13,"line":514},{"name":"$rowcount","containerName":"add_row","kind":13,"line":514},{"kind":13,"line":517,"name":"$newrow","containerName":"add_row"},{"containerName":"add_row","name":"$newrow","kind":13,"line":518},{"name":"$newrow","containerName":"add_row","line":519,"kind":13},{"containerName":"add_row","name":"$colcount","line":519,"kind":13},{"name":"$newrow","containerName":"add_row","kind":13,"line":520},{"containerName":"add_row","name":"$self","kind":13,"line":521},{"kind":12,"line":521,"name":"throw","containerName":"add_row"},{"containerName":"add_row","name":"$self","kind":13,"line":525}],"kind":12,"range":{"start":{"line":496,"character":0},"end":{"character":9999,"line":525}},"name":"add_row"},{"containerName":null,"name":"@index","kind":13,"line":525},{"kind":13,"line":526,"containerName":null,"definition":"my","name":"$i","localvar":"my"},{"line":526,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"$colcount","line":526,"kind":13},{"kind":13,"line":526,"name":"%i","containerName":null},{"name":"$self","containerName":null,"line":527,"kind":13},{"containerName":"main::","name":"entry_by_num","line":527,"kind":12},{"name":"$index","containerName":null,"kind":13,"line":527},{"kind":13,"line":527,"containerName":null,"name":"$i"},{"kind":13,"line":527,"name":"@newrow","containerName":null},{"name":"$i","containerName":null,"line":527,"kind":13},{"containerName":null,"name":"%self","line":529,"kind":13},{"line":529,"kind":13,"containerName":null,"name":"$index"},{"containerName":null,"name":"$name","kind":13,"line":529},{"containerName":null,"name":"$ct","definition":"my","localvar":"my","kind":13,"line":533},{"line":534,"kind":13,"name":"%self","containerName":null},{"line":534,"kind":13,"name":"$ct","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":534},{"containerName":null,"name":"$self","kind":13,"line":535},{"containerName":"main::","name":"num_rows","line":535,"kind":12},{"name":"remove_row","range":{"start":{"character":0,"line":550},"end":{"character":9999,"line":560}},"kind":12,"line":550,"children":[{"kind":13,"line":551,"containerName":"remove_row","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":551,"containerName":"remove_row","name":"$rowindex"},{"line":552,"kind":13,"localvar":"my","containerName":"remove_row","definition":"my","name":"$rowcount"},{"containerName":"remove_row","name":"$self","kind":13,"line":552},{"line":552,"kind":12,"name":"num_rows","containerName":"remove_row"},{"line":554,"kind":13,"name":"$rowindex","containerName":"remove_row"},{"name":"$rowcount","containerName":"remove_row","line":554,"kind":13},{"name":"$self","containerName":"remove_row","kind":13,"line":555},{"line":555,"kind":12,"name":"warn","containerName":"remove_row"},{"name":"$self","containerName":"remove_row","kind":13,"line":558},{"name":"_values","containerName":"remove_row","line":558,"kind":12},{"line":558,"kind":13,"containerName":"remove_row","name":"$rowindex"},{"name":"$self","containerName":"remove_row","kind":13,"line":559},{"kind":13,"line":559,"containerName":"remove_row","name":"$self"},{"line":559,"kind":13,"name":"$rowindex","containerName":"remove_row"},{"name":"$self","containerName":"remove_row","kind":13,"line":560}],"containerName":"main::","definition":"sub","detail":"($self,$rowindex)","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index","parameters":[{"label":"$self"},{"label":"$rowindex"}],"label":"remove_row($self,$rowindex)"}},{"containerName":null,"name":"$rowindex","line":560,"kind":13},{"localvar":"my","definition":"my","name":"$ct","containerName":null,"line":562,"kind":13},{"name":"%self","containerName":null,"line":563,"kind":13},{"containerName":null,"name":"$ct","kind":13,"line":563},{"name":"%self","containerName":null,"line":563,"kind":13},{"containerName":null,"name":"$self","line":564,"kind":13},{"kind":12,"line":564,"name":"num_rows","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self,$index,$name,$newcol)","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef ","parameters":[{"label":"$self"},{"label":"$index"},{"label":"$name"},{"label":"$newcol"}],"label":"add_column($self,$index,$name,$newcol)"},"kind":12,"line":586,"children":[{"line":587,"kind":13,"localvar":"my","containerName":"add_column","name":"$self","definition":"my"},{"line":587,"kind":13,"name":"$index","containerName":"add_column"},{"containerName":"add_column","name":"$name","line":587,"kind":13},{"line":587,"kind":13,"containerName":"add_column","name":"$newcol"},{"line":588,"kind":13,"name":"$index","containerName":"add_column"},{"name":"$index","containerName":"add_column","kind":13,"line":589},{"containerName":"add_column","name":"$self","kind":13,"line":590},{"line":590,"kind":12,"containerName":"add_column","name":"warn"},{"name":"$name","containerName":"add_column","kind":13,"line":592},{"kind":13,"line":593,"containerName":"add_column","name":"$self"},{"containerName":"add_column","name":"warn","kind":12,"line":593},{"name":"$self","containerName":"add_column","line":595,"kind":13},{"kind":12,"line":595,"name":"column_num_for_name","containerName":"add_column"},{"line":595,"kind":13,"containerName":"add_column","name":"$name"},{"line":596,"kind":13,"name":"$self","containerName":"add_column"},{"name":"warn","containerName":"add_column","line":596,"kind":12},{"localvar":"my","containerName":"add_column","name":"$colcount","definition":"my","line":599,"kind":13},{"line":599,"kind":13,"name":"$self","containerName":"add_column"},{"containerName":"add_column","name":"num_columns","kind":12,"line":599},{"localvar":"my","definition":"my","name":"$rowcount","containerName":"add_column","line":600,"kind":13},{"containerName":"add_column","name":"$self","kind":13,"line":600},{"name":"num_rows","containerName":"add_column","kind":12,"line":600},{"kind":13,"line":601,"name":"$index","containerName":"add_column"},{"line":601,"kind":13,"containerName":"add_column","name":"$colcount"},{"containerName":"add_column","name":"$self","kind":13,"line":602},{"kind":12,"line":602,"name":"warn","containerName":"add_column"},{"kind":13,"line":603,"name":"$index","containerName":"add_column"},{"line":603,"kind":13,"name":"$colcount","containerName":"add_column"},{"kind":13,"line":606,"name":"$newcol","containerName":"add_column"},{"containerName":"add_column","name":"$newcol","kind":13,"line":607},{"containerName":"add_column","name":"$newcol","line":608,"kind":13},{"kind":13,"line":608,"name":"$rowcount","containerName":"add_column"},{"line":609,"kind":13,"name":"$newcol","containerName":"add_column"},{"kind":13,"line":610,"containerName":"add_column","name":"$self"},{"kind":12,"line":610,"name":"throw","containerName":"add_column"},{"containerName":"add_column","name":"$i","definition":"my","localvar":"my","kind":13,"line":612},{"kind":13,"line":612,"name":"$i","containerName":"add_column"},{"name":"$rowcount","containerName":"add_column","line":612,"kind":13},{"name":"$i","containerName":"add_column","line":612,"kind":13},{"kind":13,"line":614,"containerName":"add_column","name":"$self"},{"kind":12,"line":614,"name":"_values","containerName":"add_column"},{"name":"$i","containerName":"add_column","kind":13,"line":614},{"line":614,"kind":13,"name":"$index","containerName":"add_column"},{"containerName":"add_column","name":"$self","line":615,"kind":13},{"name":"entry_by_num","containerName":"add_column","line":615,"kind":12},{"name":"$i","containerName":"add_column","line":615,"kind":13},{"line":615,"kind":13,"containerName":"add_column","name":"$index"},{"line":615,"kind":13,"containerName":"add_column","name":"$newcol"},{"name":"$i","containerName":"add_column","kind":13,"line":615}],"name":"add_column","range":{"start":{"character":0,"line":586},"end":{"line":616,"character":9999}}},{"name":"%self","containerName":null,"line":617,"kind":13},{"containerName":null,"name":"$index","line":617,"kind":13},{"kind":13,"line":617,"name":"$name","containerName":null},{"definition":"my","name":"$ct","containerName":null,"localvar":"my","kind":13,"line":621},{"name":"%self","containerName":null,"line":622,"kind":13},{"name":"$ct","containerName":null,"line":622,"kind":13},{"line":622,"kind":13,"containerName":null,"name":"%self"},{"line":623,"kind":13,"containerName":null,"name":"$self"},{"line":623,"kind":12,"name":"num_columns","containerName":"main::"},{"range":{"start":{"character":0,"line":637},"end":{"character":9999,"line":650}},"name":"remove_column","detail":"($self,$colindex)","signature":{"label":"remove_column($self,$colindex)","parameters":[{"label":"$self"},{"label":"$colindex"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index"},"containerName":"main::","definition":"sub","line":637,"children":[{"line":638,"kind":13,"localvar":"my","containerName":"remove_column","definition":"my","name":"$self"},{"line":638,"kind":13,"name":"$colindex","containerName":"remove_column"},{"line":640,"kind":13,"localvar":"my","name":"$colcount","definition":"my","containerName":"remove_column"},{"kind":13,"line":640,"containerName":"remove_column","name":"$self"},{"containerName":"remove_column","name":"num_columns","kind":12,"line":640},{"definition":"my","name":"$rowcount","containerName":"remove_column","localvar":"my","kind":13,"line":641},{"line":641,"kind":13,"containerName":"remove_column","name":"$self"},{"kind":12,"line":641,"containerName":"remove_column","name":"num_rows"},{"containerName":"remove_column","name":"$colindex","line":642,"kind":13},{"name":"$colcount","containerName":"remove_column","kind":13,"line":642},{"containerName":"remove_column","name":"$self","kind":13,"line":643},{"line":643,"kind":12,"containerName":"remove_column","name":"warn"},{"localvar":"my","containerName":"remove_column","definition":"my","name":"$i","line":646,"kind":13},{"kind":13,"line":646,"containerName":"remove_column","name":"$i"},{"name":"$rowcount","containerName":"remove_column","kind":13,"line":646},{"containerName":"remove_column","name":"$i","line":646,"kind":13},{"kind":13,"line":647,"containerName":"remove_column","name":"$self"},{"line":647,"kind":12,"name":"_values","containerName":"remove_column"},{"kind":13,"line":647,"name":"$i","containerName":"remove_column"},{"name":"$colindex","containerName":"remove_column","line":647,"kind":13},{"containerName":"remove_column","name":"$self","line":649,"kind":13},{"containerName":"remove_column","name":"$self","line":649,"kind":13},{"name":"$colindex","containerName":"remove_column","line":649,"kind":13},{"containerName":"remove_column","name":"$self","kind":13,"line":650}],"kind":12},{"containerName":null,"name":"$colindex","line":650,"kind":13},{"kind":13,"line":652,"definition":"my","name":"$ct","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":653},{"kind":13,"line":653,"name":"$ct","containerName":null},{"kind":13,"line":653,"containerName":null,"name":"%self"},{"kind":13,"line":654,"containerName":null,"name":"$self"},{"name":"num_columns","containerName":"main::","kind":12,"line":654},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"column_num_for_name","line":669,"kind":13},{"kind":13,"line":669,"containerName":"column_num_for_name","name":"$name"},{"line":671,"kind":13,"name":"$self","containerName":"column_num_for_name"},{"containerName":"column_num_for_name","name":"$name","kind":13,"line":671}],"line":668,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string","label":"column_num_for_name($self,$name)"},"detail":"($self,$name)","definition":"sub","containerName":"main::","range":{"end":{"line":672,"character":9999},"start":{"line":668,"character":0}},"name":"column_num_for_name"},{"range":{"start":{"character":0,"line":685},"end":{"line":688,"character":9999}},"name":"row_num_for_name","detail":"($self,$name)","signature":{"label":"row_num_for_name($self,$name)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string","parameters":[{"label":"$self"},{"label":"$name"}]},"containerName":"main::","definition":"sub","line":685,"children":[{"line":686,"kind":13,"localvar":"my","containerName":"row_num_for_name","name":"$self","definition":"my"},{"containerName":"row_num_for_name","name":"$name","kind":13,"line":686},{"kind":13,"line":687,"name":"$self","containerName":"row_num_for_name"},{"line":687,"kind":13,"name":"$name","containerName":"row_num_for_name"}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$num)","signature":{"label":"column_header($self,$num)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]},"kind":12,"line":702,"children":[{"kind":13,"line":703,"definition":"my","name":"$self","containerName":"column_header","localvar":"my"},{"name":"$num","containerName":"column_header","line":703,"kind":13},{"line":704,"kind":13,"name":"$self","containerName":"column_header"},{"containerName":"column_header","name":"$num","kind":13,"line":704}],"name":"column_header","range":{"start":{"character":0,"line":702},"end":{"line":705,"character":9999}}},{"name":"row_header","range":{"end":{"character":9999,"line":722},"start":{"character":0,"line":719}},"containerName":"main::","definition":"sub","detail":"($self,$num)","signature":{"label":"row_header($self,$num)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]},"kind":12,"line":719,"children":[{"kind":13,"line":720,"containerName":"row_header","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":720,"name":"$num","containerName":"row_header"},{"line":721,"kind":13,"name":"$self","containerName":"row_header"},{"line":721,"kind":13,"name":"$num","containerName":"row_header"}]},{"name":"num_rows","range":{"end":{"line":737,"character":9999},"start":{"line":735,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"num_rows($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none"},"kind":12,"line":735,"children":[{"line":736,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"num_rows"},{"line":737,"kind":13,"name":"$self","containerName":"num_rows"},{"kind":12,"line":737,"containerName":"num_rows","name":"_values"}]},{"line":752,"children":[{"localvar":"my","containerName":"num_columns","definition":"my","name":"$self","line":753,"kind":13},{"name":"$self","containerName":"num_columns","kind":13,"line":754},{"line":754,"kind":12,"containerName":"num_columns","name":"_values"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   return scalar @{$self->_values};\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none","parameters":[{"label":"$self"}],"label":"num_columns($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":752},"end":{"character":9999,"line":754}},"name":"num_columns"},{"line":769,"children":[],"kind":12,"range":{"end":{"line":772,"character":9999},"start":{"character":0,"line":769}},"containerName":"main::","definition":"sub","name":"row_names"},{"name":"shift","line":771,"kind":12},{"range":{"end":{"line":792,"character":9999},"start":{"character":0,"line":789}},"name":"column_names","definition":"sub","containerName":"main::","children":[],"line":789,"kind":12},{"name":"shift","line":791,"kind":12},{"name":"_values","range":{"start":{"line":813,"character":0},"end":{"character":9999,"line":819}},"kind":12,"children":[{"line":814,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_values"},{"name":"$val","containerName":"_values","kind":13,"line":814},{"name":"$val","containerName":"_values","line":815,"kind":13},{"containerName":"_values","name":"$self","line":816,"kind":13},{"containerName":"_values","name":"$val","line":816,"kind":13},{"containerName":"_values","name":"$self","kind":13,"line":818}],"line":813,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Generic - A generic matrix implementation\n\n=head1 SYNOPSIS\n\n  # A matrix has columns and rows \n  my $matrix = Bio::Matrix::Generic->new;\n  $matrix->add_column(1,$column1);\n  $matrix->add_column(2,$column2);\n\n  my $element = $matrix->entry_by_num(1,2);\n  $matrix->entry_by_num(1,2,$newval);\n\n  my $entry = $matrix->entry('human', 'mouse');\n\n  $matrix->entry('human','mouse', $newval);\n\n\n=head1 DESCRIPTION\n\nThis is a general purpose matrix object for dealing with row+column\ndata which is typical when enumerating all the pairwise combinations\nand desiring to get slices of the data.\n\nData can be accessed by column and row names or indexes.  Matrix\nindexes start at 0.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Generic;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values     => arrayref of arrayrefs of data initialization \n           -rownames   => arrayref of row names\n           -colnames   => arrayref of col names\n           -matrix_id  => id of the matrix\n           -matrix_name=> name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($values, $rownames, $colnames,\n      $id,$name,$init_val) = \n\t  $self->_rearrange([qw(VALUES ROWNAMES COLNAMES \n\t\t\t        MATRIX_ID MATRIX_NAME \n                                MATRIX_INIT_VALUE)],@args);\n  $self->matrix_id($id) if  defined $id;\n  $self->matrix_name($name) if defined $name;\n  if( defined $rownames && defined $colnames ) {\n      if( ref($rownames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -rownames option\");\n      }\n      # insure we copy the values\n      $self->{'_rownames'} = [ @$rownames ];\n      my $count = 0;\n      %{$self->{'_rownamesmap'}} = map { $_ => $count++ } @$rownames; \n\n      if( ref($colnames) !~ /ARRAY/i ) {\n\t  $self->throw(\"need an arrayref for the -colnames option\");\n      }\n      # insure we copy the values\n      $self->{'_colnames'} = [ @$colnames ];\n      $count = 0;\n      %{$self->{'_colnamesmap'}} = map { $_ => $count++ } @$colnames; \n\n      $self->{'_values'} = [];\n      if( defined $values ) {\n\t  if( ref($values) !~ /ARRAY/i ) {\n\t      $self->throw(\"Need an arrayref of arrayrefs (matrix) for -values option\");\n\t  }\t  \n\t  for my $v ( @$values ) {\n\t      if( ref($v) !~ /ARRAY/i ) {\n\t\t  $self->throw(\"Need and array of arrayrefs (matrix) for -values option\");\n\t      }\n\t      push @{$self->{'_values'}}, [@$v];\n\t  }\n      } else {\n\t  my @fill = ($init_val) x scalar @$colnames; # undef init_val will be default\n\t  for ( @$rownames ) {\n\t      push @{$self->{'_values'}}, [@fill];\n\t  }\n      }\n  } elsif( ! defined $rownames && ! defined $colnames && ! defined $values ) {\n      $self->{'_values'}   = [];\n      $self->{'_rownames'} = [];\n      $self->{'_colnames'} = [];\n  } else { \n      $self->throw(\"Must have either provided no values/colnames/rownames or provided all three\");\n  }\n\n  return $self;\n}\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n\n=head2 entry\n\n Title   : entry\n Usage   : my $entry = $matrix->entry($row,$col)\n Function: Get the value for a specific cell as specified\n           by the row and column names\n Returns : scalar value or undef if row or col does not\n           exist\n Args    : $rowname - name of the row\n           $colname - column name\n\n\nsub entry{\n   my ($self,$row,$column,$newvalue) = @_;\n   if( ! defined $row || ! defined $column ) {\n       $self->throw(\"Need at least 2 ids\");\n   }\n\n   my ($rownum) = $self->row_num_for_name($row);\n   my ($colnum) = $self->column_num_for_name($column);\n   return $self->entry_by_num($rownum,$colnum,$newvalue);\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{ $_[0]->entry($_[1],$_[2]) }\n\n=head2 entry_by_num\n\n Title   : entry_by_num\n Usage   : my $entry = $matrix->entry_by_num($rownum,$colnum)\n Function: Get an entry by row and column numbers instead of by name\n           (rows and columns start at 0)\n Returns : scalar value or undef if row or column name does not\n           exist\n Args    : $row - row number\n           $col - column number\n           [optional] $newvalue to store at this cell\n\n\nsub entry_by_num {\n    my ($self,$row,$col,$newvalue) = @_;\n    if( ! defined $row || ! defined $col || \n\t$row !~ /^\\d+$/ ||\n\t$col !~ /^\\d+$/ ) {\n\t$self->warn(\"expected to get 2 number for entry_by_num\");\n\treturn;\n    }\n    \n    if( defined $newvalue ) {\n       return $self->_values->[$row][$col] = $newvalue;\n   } else { \n       return $self->_values->[$row][$col];\n   }\n}\n\nsub get_element { \n    my $self = shift;\n    $self->entry(@_);\n}\n\n\n=head2 column\n\n Title   : column\n Usage   : my @col = $matrix->column('ALPHA');\n           OR\n           $matrix->column('ALPHA', \\@col);\n Function: Get/Set a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values.  \n           For setting will warn if the new column is of a different\n           length from the rest of the columns.\n Args    : name of the column\n           [optional] new column to store here \n\n\nsub column{\n    my ($self,$column,$newcol) = @_;\n\n    if( ! defined $column ) {\n\t$self->warn(\"Need at least a column id\");\n\treturn;\n    }\n    my $colnum  = $self->column_num_for_name($column);\n    if( ! defined $colnum ) { \n\t$self->warn(\"could not find column number for $column\");\n\treturn;\n    }\n    return $self->column_by_num($colnum,$newcol);\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column { $_[0]->column($_[1]) }\n\n\n=head2 column_by_num\n\n Title   : column_by_num\n Usage   : my @col = $matrix->column_by_num(1);\n           OR\n           $matrix->column_by_num(1,\\@newcol);\n Function: Get/Set a column by its number instead of name\n           (cols/rows start at 0)\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n           [optional] new value to store for a particular column\n\n\nsub column_by_num{\n    my ($self,$colnum,$newcol) = @_;\n    if( ! defined $colnum ) {\n\t$self->warn(\"need at least a column number\");\n\treturn;\n    }\n    my $rowcount = $self->num_rows;\n    my $colcount = $self->num_columns;\n    my $ret;\n    \n    if( defined $newcol ) {\n\tif( ref($newcol) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a column\");\n\t    return;\n\t}\n\tif( scalar @$newcol != $rowcount ) {\n\t    $self->warn(\"new column is not the correct length ($rowcount) - call add or remove row to shrink or grow the number of rows first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    $self->entry_by_num($i,$colnum,$newcol->[$i]);\n\t}\n\t$ret = $newcol;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $rowcount; $i++) {\n\t    push @$ret,$self->entry_by_num($i,$colnum);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n}\n\n=head2 row\n\n Title   : row\n Usage   : my @row = $matrix->row($rowname);\n             OR\n           $matrix->row($rowname,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\n\nsub row {\n    my ($self,$row,$newrow) = @_;\n    if( ! defined $row) {\n\t$self->warn(\"Need at least a row id\");\n\treturn;\n    }\n    my $rownum = $self->row_num_for_name($row);\n    return $self->row_by_num($rownum,$newrow);\n}\n\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row { $_[0]->row($_[1]) }\n\n=head2 row_by_num\n\n Title   : row_by_num\n Usage   : my @row = $matrix->row_by_num($rownum);\n             OR\n           $matrix->row($rownum,\\@rowvalues);\n Function: Get/Set the row of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : rowname\n           [optional] new value of row to store\n\n\nsub row_by_num{\n   my ($self,$rownum,$newrow) = @_;\n   if( ! defined $rownum ) {\n       $self->warn(\"need at least a row number\");\n       return;\n   }\n    my $colcount = $self->num_columns;\n    my $ret;\n    if( defined $newrow ) {\n\tif( ref($newrow) !~ /ARRAY/i) {\n\t    $self->warn(\"expected a valid arrayref for resetting a row\");\n\t    return;\n\t}\n\tif( scalar @$newrow != $colcount ) {\n\t    $self->warn(\"new row is not the correct length ($colcount) - call add or remove column to shrink or grow the number of columns first\");\n\t    return;\n\t}\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    $self->entry_by_num($rownum,$i, $newrow->[$i]);\n\t}\n\t$ret = $newrow;\n    } else { \n\t$ret = [];\n\tfor(my $i=0; $i < $colcount; $i++) {\n\t    # we're doing this to explicitly \n\t    # copy the entire row\n\t    push @$ret, $self->entry_by_num($rownum,$i);\n\t}\n    }\n    if( wantarray ) { return @$ret } \n    return $ret;\n\n\n}\n\n\n=head2 diagonal\n\n Title   : diagonal\n Usage   : my @diagonal = $matrix->get_diagonal()\n Function: Get the diagonal of a matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values which lie along the diagonal\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   my @diag;\n   my $rowcount = $self->num_rows;\n   my $colcount = $self->num_columns;\n   for(my $i = 0; $i < $rowcount; $i++ ) {\n       push @diag, $self->entry_by_num($i,$i);\n   }\n   return @diag;\n}\n\n\n=head2 add_row\n\n Title   : add_row\n Usage   : $matrix->add_row($index,\\@newrow);\n Function: Adds a row at particular location in the matrix.\n           If $index < the rowcount will shift all the rows down\n           by the number of new rows.\n           To add a single empty row, simply call\n           $matrix->add_row($index,undef);\n Returns : the updated number of total rows in the matrix\n Args    : index to store\n           name of the row (header)\n           newrow to add, if this is undef will add a single\n                     row with all values set to undef \n\n\nsub add_row{\n   my ($self,$index,$name,$newrow) = @_;\n   if( !defined $index || \n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid row index in add_row\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a row name or heading\");\n       return;\n   } elsif( defined $self->row_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n\n   if( $index >  $rowcount ) { \n       $self->warn(\"cannot add a row beyond 1+last row at the end ($rowcount) not $index - adding at $rowcount instead\");\n       $index = $rowcount;\n   }\n\n   if( ! defined $newrow ) {\n       $newrow = [];\n       $newrow->[$colcount] = undef;\n   } elsif( ref($newrow) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   # add this row to the matrix by carving out space for it with \n   # splice\n   splice(@{$self->{'_values'}}, $index,0,[]);\n   for( my $i = 0; $i < $colcount; $i++ ) {\n       $self->entry_by_num($index,$i,$newrow->[$i]);\n   }\n   splice(@{$self->{'_rownames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 remove_row\n\n Title   : remove_row\n Usage   : $matrix->remove_row($colnum)\n Function: remove a row from the matrix shifting all the rows\n           up by one\n Returns : Updated number of rows in the matrix\n Args    : row index\n\n\n\nsub remove_row{\n   my ($self,$rowindex) = @_;\n   my $rowcount = $self->num_rows;\n   \n   if( $rowindex > $rowcount ) {\n       $self->warn(\"rowindex $rowindex is greater than number of rows $rowcount, cannot process\");\n       return 0;\n   } else { \n       splice(@{$self->_values},$rowindex,1);\n       delete $self->{'_rownamesmap'}->{$self->{'_rownames'}->[$rowindex]};\n       splice(@{$self->{'_rownames'}},$rowindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_rownamesmap'}} = map { $_ => $ct++} @{$self->{'_rownames'}};\n   return $self->num_rows;\n}\n\n=head2 add_column\n\n Title   : add_column\n Usage   : $matrix->add_column($index,$colname,\\@newcol);\n Function: Adds a column at particular location in the matrix.\n           If $index < the colcount will shift all the columns right\n           by the number of new columns.\n           To add a single empty column, simply call\n           $matrix->add_column($index,undef);\n Returns : the updated number of total columns in the matrix\n Args    : index to store\n           name of the column (header)\n           newcolumn to add, if this is undef will add a single\n                 column with all values set to undef \n\n\n\n\nsub add_column{\n   my ($self,$index,$name,$newcol) = @_;\n   if( !defined $index ||\n       $index !~ /^\\d+$/ ) {\n       $self->warn(\"expected a valid col index in add_column\");\n       return;\n   } elsif( ! defined $name) {\n       $self->warn(\"Need a column name or heading\");\n       return;\n   } elsif( defined $self->column_num_for_name($name) ) {\n       $self->warn(\"Need a unqiue name for the column heading, $name is already used\");\n       return;\n   }\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $index > $colcount ) { \n       $self->warn(\"cannot add a column beyond 1+last column at the end ($colcount) not $index - adding at $colcount instead\");\n       $index = $colcount;\n   }\n\n   if( ! defined $newcol ) {\n       $newcol = [];\n       $newcol->[$rowcount] = undef; # make the array '$rowcount' long\n   } elsif( ref($newcol) !~ /ARRAY/i ) {\n       $self->throw(\"Expected either undef or a valid arrayref for add_row\");\n   }\n   for( my $i = 0; $i < $rowcount; $i++ ) {\n       # add this column to each row\n       splice(@{$self->_values->[$i]},$index,0,[]);\n       $self->entry_by_num($i,$index,$newcol->[$i]);\n   }\n   splice(@{$self->{'_colnames'}}, $index,0,$name);\n   # Sadly we have to remap these each time (except for the case\n   # when we're adding a new column to the end, but I don't think\n   # the speedup for that case warrants the extra code at this time.\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 remove_column\n\n Title   : remove_column\n Usage   : $matrix->remove_column($colnum)\n Function: remove a column from the matrix shifting all the columns\n           to the left by one\n Returns : Updated number of columns in the matrix\n Args    : column index\n\n\nsub remove_column{\n   my ($self,$colindex) = @_;\n\n   my $colcount = $self->num_columns;\n   my $rowcount = $self->num_rows;\n   if( $colindex > $colcount ) {\n\t\t$self->warn(\"colindex $colindex is greater than number of columns ($colcount), cannot process\");\n\t\treturn 0;\n   } else { \n\t\tfor(my $i = 0; $i < $rowcount; $i++ ) {\n\t\t\tsplice(@{$self->_values->[$i]},$colindex,1);\n\t\t}\n\t\tdelete $self->{'_colnamesmap'}->{$self->{'_colnames'}->[$colindex]};\n\t\tsplice(@{$self->{'_colnames'}},$colindex,1);\n   }\n   my $ct = 0;\n   %{$self->{'_colnamesmap'}} = map {$_ => $ct++} @{$self->{'_colnames'}};\n   return $self->num_columns;\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   \n   return $self->{'_colnamesmap'}->{$name};\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self,$name) = @_;\n   return $self->{'_rownamesmap'}->{$name}\n}\n\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n   my ($self,$num) = @_;\n   return $self->{'_colnames'}->[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n   my ($self,$num) = @_;\n   return $self->{'_rownames'}->[$num];\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   return scalar @{$self->_values};\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none\n\n\n\nsub num_columns{\n   my ($self) = @_;\n   return scalar @{$self->_values->[0] || []};\n}\n\n\n=head2 row_names\n\n Title   : row_names\n Usage   : my @rows = $matrix->row_names\n Function: The names of all the rows\n Returns : array in array context, arrayref in scalar context\n Args    : none\n\n\n\nsub row_names{\n   if( wantarray ) { \n       return @{shift->{'_rownames'}};\n   } else { \n       return shift->{'_rownames'};\n   }\n}\n\n\n=head2 column_names\n\n Title   : column_names\n Usage   : my @columns = $matrix->column_names\n Function: The names of all the columns\n Returns : array in array context, arrayref in scalar context\n Args    : none\n\n\n\nsub column_names{\n   if( wantarray ) { \n       return @{shift->{'_colnames'}};\n   } else { \n       return shift->{'_colnames'};\n   }\n}\n\n=head2 private methods\n\nPrivate methods for a Generic Matrix\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Args    : an array reference","label":"_values($self,$val)"},"detail":"($self,$val)"}],"version":5}