{"vars":[{"kind":14,"line":111,"name":"TRUE","definition":1,"containerName":"main::"},{"line":111,"kind":12,"containerName":"Bio::Ontology::Ontology::Bio::Ontology::OntologyStore::Bio::Annotation::DBLink::Data::Dumper","name":"strict"},{"containerName":"main::","definition":1,"name":"FALSE","kind":14,"line":112},{"name":"base","containerName":"","line":114,"kind":2},{"name":"new","range":{"end":{"character":9999,"line":191},"start":{"character":0,"line":145}},"kind":12,"line":145,"children":[{"line":147,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":147},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":149},{"containerName":"new","name":"$class","kind":13,"line":149},{"name":"@args","containerName":"new","line":149,"kind":13},{"line":150,"kind":13,"localvar":"my","containerName":"new","name":"$identifier","definition":"my"},{"kind":13,"line":151,"name":"$name","containerName":"new"},{"kind":13,"line":152,"name":"$definition","containerName":"new"},{"name":"$category","containerName":"new","line":153,"kind":13},{"line":154,"kind":13,"name":"$ont","containerName":"new"},{"name":"$version","containerName":"new","line":155,"kind":13},{"line":156,"kind":13,"name":"$is_obsolete","containerName":"new"},{"kind":13,"line":157,"name":"$comment","containerName":"new"},{"line":158,"kind":13,"name":"$dblinks","containerName":"new"},{"kind":13,"line":159,"containerName":"new","name":"$dbxrefs"},{"containerName":"new","name":"$references","line":160,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":161},{"line":161,"kind":12,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":173},{"kind":13,"line":175,"name":"$self","containerName":"new"},{"containerName":"new","name":"init","line":175,"kind":12},{"name":"$identifier","containerName":"new","line":177,"kind":13},{"kind":13,"line":177,"containerName":"new","name":"$self"},{"containerName":"new","name":"identifier","line":177,"kind":12},{"containerName":"new","name":"$identifier","line":177,"kind":13},{"containerName":"new","name":"$name","line":178,"kind":13},{"line":178,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":178,"name":"name","containerName":"new"},{"containerName":"new","name":"$name","kind":13,"line":178},{"name":"$definition","containerName":"new","kind":13,"line":179},{"line":179,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":179,"name":"definition","containerName":"new"},{"kind":13,"line":179,"containerName":"new","name":"$definition"},{"line":180,"kind":13,"containerName":"new","name":"$category"},{"line":180,"kind":13,"containerName":"new","name":"$self"},{"name":"category","containerName":"new","kind":12,"line":180},{"containerName":"new","name":"$category","line":180,"kind":13},{"name":"$ont","containerName":"new","line":181,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":181},{"containerName":"new","name":"ontology","line":181,"kind":12},{"containerName":"new","name":"$ont","line":181,"kind":13},{"containerName":"new","name":"$version","line":182,"kind":13},{"kind":13,"line":182,"containerName":"new","name":"$self"},{"name":"version","containerName":"new","kind":12,"line":182},{"containerName":"new","name":"$version","kind":13,"line":182},{"line":183,"kind":13,"containerName":"new","name":"$is_obsolete"},{"name":"$self","containerName":"new","kind":13,"line":183},{"line":183,"kind":12,"containerName":"new","name":"is_obsolete"},{"line":183,"kind":13,"name":"$is_obsolete","containerName":"new"},{"containerName":"new","name":"$comment","kind":13,"line":184},{"containerName":"new","name":"$self","line":184,"kind":13},{"kind":12,"line":184,"name":"comment","containerName":"new"},{"line":184,"kind":13,"name":"$comment","containerName":"new"},{"containerName":"new","name":"$dbxrefs","line":185,"kind":13},{"kind":13,"line":185,"containerName":"new","name":"$self"},{"name":"add_dbxref","containerName":"new","line":185,"kind":12},{"line":185,"kind":13,"containerName":"new","name":"$dbxrefs"},{"containerName":"new","name":"$dblinks","line":187,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":187},{"name":"add_dblink","containerName":"new","kind":12,"line":187},{"kind":13,"line":187,"containerName":"new","name":"$dblinks"},{"name":"$references","containerName":"new","line":188,"kind":13},{"name":"$self","containerName":"new","line":188,"kind":13},{"name":"add_reference","containerName":"new","kind":12,"line":188},{"line":188,"kind":13,"name":"$references","containerName":"new"},{"kind":13,"line":190,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.","label":"new($class,@args)"}},{"kind":12,"line":149,"containerName":"new","name":"SUPER"},{"definition":"sub","name":"init","containerName":"main::","range":{"start":{"line":195,"character":0},"end":{"line":210,"character":9999}},"kind":12,"children":[{"containerName":"init","name":"$self","definition":"my","localvar":"my","kind":13,"line":197},{"kind":13,"line":199,"containerName":"init","name":"$self"},{"line":199,"kind":12,"name":"identifier","containerName":"init"},{"line":200,"kind":13,"name":"$self","containerName":"init"},{"line":200,"kind":12,"name":"name","containerName":"init"},{"kind":13,"line":201,"name":"$self","containerName":"init"},{"kind":12,"line":201,"name":"comment","containerName":"init"},{"line":202,"kind":13,"containerName":"init","name":"$self"},{"line":202,"kind":12,"containerName":"init","name":"definition"},{"name":"$self","containerName":"init","kind":13,"line":203},{"line":203,"kind":12,"containerName":"init","name":"ontology"},{"line":204,"kind":13,"name":"$self","containerName":"init"},{"name":"is_obsolete","containerName":"init","kind":12,"line":204},{"name":"$self","containerName":"init","kind":13,"line":205},{"line":205,"kind":12,"name":"remove_synonyms","containerName":"init"},{"line":206,"kind":13,"containerName":"init","name":"$self"},{"line":206,"kind":12,"name":"remove_dbxrefs","containerName":"init"},{"containerName":"init","name":"$self","kind":13,"line":207},{"name":"remove_references","containerName":"init","line":207,"kind":12},{"containerName":"init","name":"$self","line":208,"kind":13},{"line":208,"kind":12,"containerName":"init","name":"remove_secondary_ids"}],"line":195},{"name":"identifier","definition":"sub","containerName":"main::","range":{"start":{"line":226,"character":0},"end":{"character":9999,"line":231}},"kind":12,"children":[{"kind":13,"line":227,"containerName":"identifier","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":229,"name":"$self","containerName":"identifier"},{"line":230,"kind":13,"containerName":"identifier","name":"$self"}],"line":226},{"containerName":"main::","definition":"sub","name":"name","range":{"start":{"line":246,"character":0},"end":{"line":251,"character":9999}},"kind":12,"line":246,"children":[{"line":247,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"name"},{"kind":13,"line":249,"containerName":"name","name":"$self"},{"line":250,"kind":13,"containerName":"name","name":"$self"}]},{"line":266,"children":[{"kind":13,"line":267,"containerName":"definition","definition":"my","name":"$self","localvar":"my"},{"line":269,"kind":13,"containerName":"definition","name":"$self"},{"containerName":"definition","name":"$self","kind":13,"line":270}],"kind":12,"range":{"end":{"character":9999,"line":271},"start":{"line":266,"character":0}},"containerName":"main::","definition":"sub","name":"definition"},{"range":{"end":{"character":9999,"line":310},"start":{"line":294,"character":0}},"definition":"sub","name":"ontology","containerName":"main::","children":[{"kind":13,"line":295,"containerName":"ontology","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","name":"$ont","definition":"my","containerName":"ontology","line":296,"kind":13},{"line":299,"kind":13,"name":"$ont","containerName":"ontology"},{"containerName":"ontology","name":"$ont","kind":13,"line":300},{"line":301,"kind":13,"containerName":"ontology","name":"$ont"},{"containerName":"ontology","name":"new","line":301,"kind":12},{"kind":13,"line":301,"name":"$ont","containerName":"ontology"},{"kind":13,"line":301,"name":"$ont","containerName":"ontology"},{"name":"$ont","containerName":"ontology","kind":13,"line":302},{"name":"isa","containerName":"ontology","kind":12,"line":302},{"kind":13,"line":303,"containerName":"ontology","name":"$self"},{"line":303,"kind":12,"name":"throw","containerName":"ontology"},{"name":"$ont","containerName":"ontology","kind":13,"line":303},{"kind":13,"line":307,"containerName":"ontology","name":"$self"},{"name":"$ont","containerName":"ontology","kind":13,"line":307},{"kind":13,"line":309,"containerName":"ontology","name":"$self"}],"line":294,"kind":12},{"kind":12,"line":301,"name":"Bio","containerName":"Ontology::Ontology"},{"kind":12,"line":324,"children":[{"localvar":"my","containerName":"version","definition":"my","name":"$self","line":325,"kind":13},{"kind":13,"line":327,"containerName":"version","name":"$self"},{"containerName":"version","name":"$self","kind":13,"line":328}],"containerName":"main::","definition":"sub","name":"version","range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":324}}},{"range":{"end":{"character":9999,"line":348},"start":{"character":0,"line":343}},"definition":"sub","name":"is_obsolete","containerName":"main::","children":[{"kind":13,"line":344,"name":"$self","definition":"my","containerName":"is_obsolete","localvar":"my"},{"line":346,"kind":13,"containerName":"is_obsolete","name":"$self"},{"name":"$self","containerName":"is_obsolete","line":347,"kind":13}],"line":343,"kind":12},{"kind":12,"line":363,"children":[{"line":364,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"comment"},{"containerName":"comment","name":"$self","kind":13,"line":366},{"containerName":"comment","name":"$self","kind":13,"line":367}],"containerName":"main::","name":"comment","definition":"sub","range":{"start":{"line":363,"character":0},"end":{"character":9999,"line":368}}},{"line":380,"children":[{"kind":13,"line":381,"name":"$self","definition":"my","containerName":"get_synonyms","localvar":"my"},{"name":"$self","containerName":"get_synonyms","kind":13,"line":383}],"kind":12,"range":{"end":{"character":9999,"line":383},"start":{"character":0,"line":380}},"containerName":"main::","name":"get_synonyms","definition":"sub"},{"containerName":null,"name":"%self","kind":13,"line":383},{"range":{"start":{"line":400,"character":0},"end":{"character":9999,"line":408}},"name":"add_synonym","children":[{"line":401,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_synonym"},{"name":"@values","containerName":"add_synonym","kind":13,"line":401},{"containerName":"add_synonym","name":"@values","line":403,"kind":13},{"localvar":"my","containerName":"add_synonym","name":"$syn","definition":"my","line":406,"kind":13},{"kind":13,"line":406,"containerName":"add_synonym","name":"@values"},{"containerName":"add_synonym","name":"$syn","line":407,"kind":13},{"kind":13,"line":407,"containerName":"add_synonym","name":"$self"},{"line":408,"kind":13,"name":"$self","containerName":"add_synonym"}],"line":400,"kind":12,"signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_synonym($self,@values)"},"detail":"($self,@values)","definition":"sub","containerName":"main::"},{"name":"$syn","containerName":null,"line":408,"kind":13},{"kind":12,"line":424,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"remove_synonyms","line":425,"kind":13},{"definition":"my","name":"@a","containerName":"remove_synonyms","localvar":"my","kind":13,"line":427},{"name":"$self","containerName":"remove_synonyms","line":427,"kind":13},{"name":"get_synonyms","containerName":"remove_synonyms","line":427,"kind":12},{"containerName":"remove_synonyms","name":"$self","kind":13,"line":428},{"line":429,"kind":13,"containerName":"remove_synonyms","name":"@a"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :","parameters":[{"label":"$self"}],"label":"remove_synonyms($self)"},"name":"remove_synonyms","range":{"end":{"line":431,"character":9999},"start":{"line":424,"character":0}}},{"children":[{"kind":13,"line":448,"containerName":"get_dblinks","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":448,"containerName":"get_dblinks","name":"$context"},{"containerName":"get_dblinks","name":"$self","line":449,"kind":13},{"kind":12,"line":449,"name":"deprecated","containerName":"get_dblinks"},{"kind":13,"line":454,"containerName":"get_dblinks","name":"$self"},{"name":"get_dbxrefs","containerName":"get_dblinks","line":454,"kind":12},{"name":"$context","containerName":"get_dblinks","line":454,"kind":13}],"line":447,"kind":12,"signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances","parameters":[{"label":"$self"},{"label":"$context"}],"label":"get_dblinks($self,$context)"},"detail":"($self,$context)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":447},"end":{"character":9999,"line":455}},"name":"get_dblinks"},{"definition":"sub","name":"get_dbxrefs","containerName":"main::","range":{"start":{"character":0,"line":473},"end":{"line":480,"character":9999}},"kind":12,"children":[{"line":474,"kind":13,"localvar":"my","containerName":"get_dbxrefs","name":"$self","definition":"my"},{"line":474,"kind":13,"containerName":"get_dbxrefs","name":"$context"},{"kind":13,"line":475,"name":"@dbxrefs","definition":"my","containerName":"get_dbxrefs","localvar":"my"},{"kind":13,"line":476,"name":"$context","containerName":"get_dbxrefs"},{"kind":13,"line":477,"name":"$self","containerName":"get_dbxrefs"},{"containerName":"get_dbxrefs","name":"$context","line":477,"kind":13},{"kind":13,"line":478,"name":"@dbxrefs","containerName":"get_dbxrefs"},{"kind":13,"line":478,"containerName":"get_dbxrefs","name":"$self"},{"kind":13,"line":478,"name":"$context","containerName":"get_dbxrefs"}],"line":473},{"name":"_dblinks","kind":12,"line":477},{"name":"_dblinks","kind":12,"line":478},{"kind":13,"line":481,"name":"@dbxrefs","containerName":null},{"line":481,"kind":13,"containerName":null,"name":"$_"},{"kind":13,"line":481,"containerName":null,"name":"%self"},{"name":"_dblinks","line":481,"kind":12},{"name":"@dbxrefs","containerName":null,"kind":13,"line":483},{"definition":"sub","name":"get_dblink_context","containerName":"main::","range":{"start":{"line":498,"character":0},"end":{"line":502,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"get_dblink_context","localvar":"my","kind":13,"line":499},{"containerName":"get_dblink_context","name":"$self","line":500,"kind":13},{"line":500,"kind":12,"containerName":"get_dblink_context","name":"deprecated"},{"line":501,"kind":13,"name":"$self","containerName":"get_dblink_context"},{"name":"get_dbxref_context","containerName":"get_dblink_context","kind":12,"line":501}],"line":498},{"range":{"start":{"line":514,"character":0},"end":{"character":9999,"line":516}},"containerName":"main::","definition":"sub","name":"get_dbxref_context","line":514,"children":[{"line":515,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_dbxref_context"},{"containerName":"get_dbxref_context","name":"$self","line":516,"kind":13}],"kind":12},{"name":"_dblinks","kind":12,"line":516},{"kind":12,"children":[{"line":535,"kind":13,"localvar":"my","containerName":"add_dblink","definition":"my","name":"$self"},{"kind":13,"line":536,"name":"$self","containerName":"add_dblink"},{"line":536,"kind":12,"name":"deprecated","containerName":"add_dblink"},{"kind":13,"line":539,"containerName":"add_dblink","name":"@dbxrefs","definition":"my","localvar":"my"},{"kind":13,"line":540,"name":"$string","definition":"my","containerName":"add_dblink","localvar":"my"},{"localvar":"my","definition":"my","name":"$db","containerName":"add_dblink","line":541,"kind":13},{"name":"$id","containerName":"add_dblink","line":541,"kind":13},{"name":"$string","containerName":"add_dblink","kind":13,"line":541},{"name":"@dbxrefs","containerName":"add_dblink","line":542,"kind":13},{"kind":12,"line":542,"name":"new","containerName":"add_dblink"},{"kind":13,"line":542,"name":"$db","containerName":"add_dblink"},{"kind":13,"line":542,"containerName":"add_dblink","name":"$id"},{"name":"$self","containerName":"add_dblink","kind":13,"line":544},{"line":544,"kind":12,"containerName":"add_dblink","name":"add_dbxref"},{"name":"@dbxrefs","containerName":"add_dblink","line":544,"kind":13}],"line":534,"definition":"sub","name":"add_dblink","containerName":"main::","range":{"start":{"character":0,"line":534},"end":{"line":545,"character":9999}}},{"name":"Bio","containerName":"Annotation::DBLink","kind":12,"line":542},{"kind":12,"line":561,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_dbxref","line":562,"kind":13},{"kind":13,"line":563,"name":"$links","definition":"my","containerName":"add_dbxref","localvar":"my"},{"name":"$context","containerName":"add_dbxref","line":563,"kind":13},{"line":563,"kind":13,"name":"$self","containerName":"add_dbxref"},{"line":563,"kind":12,"name":"_rearrange","containerName":"add_dbxref"},{"line":564,"kind":13,"name":"$links","containerName":"add_dbxref"},{"name":"$context","containerName":"add_dbxref","kind":13,"line":565},{"name":"$self","containerName":"add_dbxref","line":566,"kind":13},{"kind":12,"line":566,"name":"throw","containerName":"add_dbxref"},{"kind":13,"line":566,"name":"$links","containerName":"add_dbxref"},{"containerName":"add_dbxref","name":"$dbxref","definition":"my","localvar":"my","kind":13,"line":567},{"line":567,"kind":13,"containerName":"add_dbxref","name":"$links"}],"containerName":"main::","definition":"sub","name":"add_dbxref","range":{"start":{"character":0,"line":561},"end":{"character":9999,"line":567}}},{"name":"$self","containerName":null,"line":568,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":568},{"name":"$dbxref","containerName":null,"kind":13,"line":568},{"name":"$dbxref","containerName":null,"line":569,"kind":13},{"containerName":"main::","name":"isa","line":569,"kind":12},{"containerName":null,"name":"$self","line":570,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":570},{"name":"$context","containerName":null,"kind":13,"line":570},{"name":"%self","containerName":null,"line":571,"kind":13},{"kind":12,"line":571,"name":"_dblinks"},{"name":"%context","containerName":null,"line":571,"kind":13},{"containerName":null,"name":"%self","line":572,"kind":13},{"line":572,"kind":12,"name":"_dblinks"},{"kind":13,"line":572,"name":"@context","containerName":null},{"definition":"my","name":"$linktext","containerName":null,"localvar":"my","kind":13,"line":574},{"containerName":null,"name":"$dbxref","kind":13,"line":574},{"line":574,"kind":13,"containerName":null,"name":"$dbxref"},{"containerName":"main::","name":"display_text","line":574,"kind":12},{"name":"%dbxref","containerName":null,"line":574,"kind":13},{"line":575,"kind":12,"name":"display_text","containerName":"main::"},{"name":"$linktext","containerName":null,"line":575,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":576},{"name":"_dblinks","line":576,"kind":12},{"containerName":null,"name":"%context","kind":13,"line":576},{"kind":13,"line":578,"containerName":null,"name":"$self"},{"line":578,"kind":12,"containerName":"main::","name":"warn"},{"line":580,"kind":13,"containerName":null,"name":"%self"},{"name":"_dblinks","line":580,"kind":12},{"line":580,"kind":13,"containerName":null,"name":"$context"},{"name":"$dbxref","containerName":null,"line":580,"kind":13},{"range":{"end":{"character":9999,"line":601},"start":{"character":0,"line":597}},"name":"has_dblink","line":597,"children":[{"kind":13,"line":598,"containerName":"has_dblink","definition":"my","name":"$self","localvar":"my"},{"containerName":"has_dblink","name":"$value","kind":13,"line":598},{"kind":13,"line":599,"name":"$self","containerName":"has_dblink"},{"line":599,"kind":12,"containerName":"has_dblink","name":"deprecated"},{"containerName":"has_dblink","name":"$self","line":600,"kind":13},{"containerName":"has_dblink","name":"has_dbxref","kind":12,"line":600},{"kind":13,"line":600,"name":"$value","containerName":"has_dblink"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances","label":"has_dblink($self,$value)"},"containerName":"main::","definition":"sub"},{"name":"has_dbxref","range":{"start":{"line":615,"character":0},"end":{"line":623,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"has_dbxref($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"has_dbxref","name":"$self","definition":"my","localvar":"my","kind":13,"line":616},{"containerName":"has_dbxref","name":"$value","kind":13,"line":616},{"kind":13,"line":617,"containerName":"has_dbxref","name":"$value"},{"localvar":"my","containerName":"has_dbxref","definition":"my","name":"$context","line":618,"kind":13},{"line":619,"kind":13,"name":"$self","containerName":"has_dbxref"},{"containerName":"has_dbxref","name":"throw","kind":12,"line":619},{"line":619,"kind":13,"containerName":"has_dbxref","name":"$context"},{"name":"$context","containerName":"has_dbxref","line":620,"kind":13},{"containerName":"has_dbxref","name":"$self","line":621,"kind":13},{"kind":13,"line":621,"containerName":"has_dbxref","name":"$context"},{"kind":12,"line":622,"containerName":"has_dbxref","name":"display_text"},{"kind":13,"line":622,"name":"$value","containerName":"has_dbxref"},{"kind":13,"line":623,"containerName":"has_dbxref","name":"$self"},{"name":"$context","containerName":"has_dbxref","kind":13,"line":623}],"line":615},{"name":"_dblinks","line":621,"kind":12},{"kind":12,"line":623,"name":"_dblinks"},{"name":"TRUE","line":625,"kind":12},{"name":"FALSE","kind":12,"line":628},{"children":[{"kind":13,"line":647,"containerName":"add_dblink_context","name":"$self","definition":"my","localvar":"my"},{"containerName":"add_dblink_context","name":"$value","line":647,"kind":13},{"containerName":"add_dblink_context","name":"$context","line":647,"kind":13},{"name":"$self","containerName":"add_dblink_context","kind":13,"line":648},{"line":648,"kind":12,"containerName":"add_dblink_context","name":"deprecated"},{"name":"$self","containerName":"add_dblink_context","line":650,"kind":13},{"kind":12,"line":650,"name":"add_dbxref","containerName":"add_dblink_context"},{"kind":13,"line":650,"name":"$value","containerName":"add_dblink_context"},{"kind":13,"line":650,"containerName":"add_dblink_context","name":"$context"}],"line":646,"kind":12,"signature":{"label":"add_dblink_context($self,$value,$context)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$context"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead"},"detail":"($self,$value,$context)","definition":"sub","containerName":"main::","range":{"start":{"line":646,"character":0},"end":{"line":651,"character":9999}},"name":"add_dblink_context"},{"range":{"end":{"line":671,"character":9999},"start":{"line":667,"character":0}},"name":"remove_dblinks","detail":"($self,$context)","signature":{"label":"remove_dblinks($self,$context)","parameters":[{"label":"$self"},{"label":"$context"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances"},"containerName":"main::","definition":"sub","line":667,"children":[{"line":668,"kind":13,"localvar":"my","containerName":"remove_dblinks","definition":"my","name":"$self"},{"containerName":"remove_dblinks","name":"$context","line":668,"kind":13},{"kind":13,"line":669,"name":"$self","containerName":"remove_dblinks"},{"name":"deprecated","containerName":"remove_dblinks","line":669,"kind":12},{"line":670,"kind":13,"containerName":"remove_dblinks","name":"$self"},{"kind":12,"line":670,"containerName":"remove_dblinks","name":"remove_dbxrefs"}],"kind":12},{"children":[{"containerName":"remove_dbxrefs","name":"$self","definition":"my","localvar":"my","kind":13,"line":685},{"line":685,"kind":13,"name":"$context","containerName":"remove_dbxrefs"},{"kind":13,"line":686,"name":"$context","containerName":"remove_dbxrefs"},{"containerName":"remove_dbxrefs","name":"$context","line":686,"kind":13},{"containerName":"remove_dbxrefs","name":"$context","kind":13,"line":686},{"containerName":"remove_dbxrefs","definition":"my","name":"@old","localvar":"my","kind":13,"line":687},{"name":"$self","containerName":"remove_dbxrefs","line":687,"kind":13},{"kind":12,"line":687,"name":"get_dbxrefs","containerName":"remove_dbxrefs"},{"containerName":"remove_dbxrefs","name":"$context","line":687,"kind":13},{"kind":13,"line":688,"containerName":"remove_dbxrefs","name":"$context"},{"containerName":"remove_dbxrefs","name":"$self","kind":13,"line":689},{"line":689,"kind":13,"name":"$context","containerName":"remove_dbxrefs"},{"line":691,"kind":13,"containerName":"remove_dbxrefs","name":"$self"},{"name":"@old","containerName":"remove_dbxrefs","line":693,"kind":13}],"line":684,"kind":12,"signature":{"label":"remove_dbxrefs($self,$context)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances\n\n\nsub remove_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"use of remove_dblinks() is deprecated; use remove_dbxrefs() instead\");\n    return $self->remove_dbxrefs(@_);\n} # remove_dblinks\n\n=head2 remove_dbxrefs\n\n Title   : remove_dbxrefs()\n Usage   : $term->remove_dbxrefs();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.","parameters":[{"label":"$self"},{"label":"$context"}]},"detail":"($self,$context)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":684},"end":{"line":694,"character":9999}},"name":"remove_dbxrefs"},{"line":689,"kind":12,"name":"_dblinks"},{"line":691,"kind":12,"name":"_dblinks"},{"kind":12,"line":706,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_references","line":707,"kind":13},{"line":708,"kind":13,"containerName":"get_references","name":"$self"}],"containerName":"main::","definition":"sub","name":"get_references","range":{"start":{"line":706,"character":0},"end":{"character":9999,"line":708}}},{"name":"_references","line":708,"kind":12},{"containerName":null,"name":"%self","line":708,"kind":13},{"kind":12,"line":708,"name":"_references"},{"detail":"($self,@values)","signature":{"label":"add_reference($self,@values)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances\n\n\nsub remove_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"use of remove_dblinks() is deprecated; use remove_dbxrefs() instead\");\n    return $self->remove_dbxrefs(@_);\n} # remove_dblinks\n\n=head2 remove_dbxrefs\n\n Title   : remove_dbxrefs()\n Usage   : $term->remove_dbxrefs();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n\n\nsub remove_dbxrefs {\n    my ($self, $context) = @_;\n    $context = undef if $context && ($context eq \"all\");\n    my @old = $self->get_dbxrefs($context);\n    if (defined($context)) {\n        $self->{_dblinks}->{$context}=[];\n    } else {\n        $self->{_dblinks} = {};\n    }\n    return @old;\n} # remove_dbxrefs\n\n=head2 get_references\n\n  Title   : get_references\n  Usage   : @references = $self->get_references\n  Fuctnion: Returns a list of references\n  Return  : A list of objects\n  Args    : [none]\n\n\nsub get_references {\n    my $self=shift;\n    return @{$self->{_references}} if exists $self->{_references};\n    return ();\n}\n\n=head2 add_reference\n\n  Title   : add_reference\n  Usage   : $self->add_reference($reference);\n            $self->add_reference($reference1, $reference2);\n  Fuctnion: Add one or more references\n  Returns : [none]","parameters":[{"label":"$self"},{"label":"@values"}]},"containerName":"main::","definition":"sub","line":722,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_reference","line":723,"kind":13},{"name":"@values","containerName":"add_reference","kind":13,"line":723},{"containerName":"add_reference","name":"@values","line":724,"kind":13},{"line":726,"kind":13,"localvar":"my","definition":"my","name":"$reference","containerName":"add_reference"},{"line":726,"kind":13,"containerName":"add_reference","name":"@values"},{"kind":13,"line":727,"containerName":"add_reference","name":"$self"},{"kind":12,"line":727,"containerName":"add_reference","name":"throw"},{"kind":13,"line":727,"name":"$reference","containerName":"add_reference"},{"name":"$reference","containerName":"add_reference","line":728,"kind":13},{"kind":12,"line":728,"name":"isa","containerName":"add_reference"},{"containerName":"add_reference","name":"$reference","line":729,"kind":13},{"name":"$reference","containerName":"add_reference","kind":13,"line":730},{"containerName":"add_reference","name":"$self","kind":13,"line":730},{"kind":13,"line":731,"name":"$self","containerName":"add_reference"}],"kind":12,"range":{"end":{"character":9999,"line":731},"start":{"line":722,"character":0}},"name":"add_reference"},{"name":"_references","line":730,"kind":12},{"name":"_references","line":731,"kind":12},{"name":"$reference","containerName":null,"kind":13,"line":731},{"containerName":"main::","name":"remove_references","definition":"sub","range":{"end":{"character":9999,"line":750},"start":{"character":0,"line":745}},"kind":12,"line":745,"children":[{"kind":13,"line":746,"name":"$self","definition":"my","containerName":"remove_references","localvar":"my"},{"line":747,"kind":13,"localvar":"my","definition":"my","name":"@references","containerName":"remove_references"},{"kind":13,"line":747,"name":"$self","containerName":"remove_references"},{"name":"get_references","containerName":"remove_references","line":747,"kind":12},{"kind":13,"line":748,"containerName":"remove_references","name":"$self"},{"kind":13,"line":749,"containerName":"remove_references","name":"@references"}]},{"name":"_references","line":748,"kind":12},{"range":{"start":{"character":0,"line":766},"end":{"character":9999,"line":769}},"containerName":"main::","definition":"sub","name":"get_secondary_ids","line":766,"children":[{"localvar":"my","containerName":"get_secondary_ids","name":"$self","definition":"my","line":767,"kind":13},{"kind":13,"line":769,"containerName":"get_secondary_ids","name":"$self"}],"kind":12},{"line":769,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":786,"children":[{"name":"$self","definition":"my","containerName":"add_secondary_id","localvar":"my","kind":13,"line":787},{"line":792,"kind":13,"localvar":"my","name":"$id","definition":"my","containerName":"add_secondary_id"},{"kind":13,"line":793,"name":"$id","containerName":"add_secondary_id"},{"containerName":"add_secondary_id","name":"$self","line":793,"kind":13},{"name":"$self","containerName":"add_secondary_id","line":794,"kind":13}],"containerName":"main::","name":"add_secondary_id","definition":"sub","range":{"end":{"line":794,"character":9999},"start":{"line":786,"character":0}}},{"containerName":null,"name":"$id","kind":13,"line":794},{"children":[{"containerName":"remove_secondary_ids","definition":"my","name":"$self","localvar":"my","kind":13,"line":811},{"kind":13,"line":813,"containerName":"remove_secondary_ids","definition":"my","name":"@a","localvar":"my"},{"name":"$self","containerName":"remove_secondary_ids","line":813,"kind":13},{"containerName":"remove_secondary_ids","name":"get_secondary_ids","kind":12,"line":813},{"containerName":"remove_secondary_ids","name":"$self","kind":13,"line":814},{"line":815,"kind":13,"name":"@a","containerName":"remove_secondary_ids"}],"line":810,"kind":12,"range":{"start":{"line":810,"character":0},"end":{"line":817,"character":9999}},"name":"remove_secondary_ids","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"_is_true_or_false($self,$value)","documentation":" Title   :_is_true_or_false\n Function: Checks whether the argument is TRUE or FALSE.\n Returns :\n Args    : The value to be checked.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":824,"children":[{"kind":13,"line":825,"containerName":"_is_true_or_false","name":"$self","definition":"my","localvar":"my"},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":825},{"kind":13,"line":826,"containerName":"_is_true_or_false","name":"$value"},{"line":826,"kind":13,"name":"$value","containerName":"_is_true_or_false"},{"line":826,"kind":13,"name":"$value","containerName":"_is_true_or_false"},{"name":"$self","containerName":"_is_true_or_false","kind":13,"line":827},{"name":"throw","containerName":"_is_true_or_false","kind":12,"line":827},{"kind":13,"line":828,"name":"$value","containerName":"_is_true_or_false"}],"name":"_is_true_or_false","range":{"start":{"character":0,"line":824},"end":{"character":9999,"line":830}}},{"name":"TRUE","line":826,"kind":12},{"name":"FALSE","line":826,"kind":12},{"name":"TRUE","line":828,"kind":12},{"line":828,"kind":12,"name":"FALSE"},{"definition":"sub","name":"object_id","containerName":"main::","range":{"end":{"line":851,"character":9999},"start":{"character":0,"line":849}},"kind":12,"children":[{"name":"identifier","containerName":"object_id","kind":12,"line":850}],"line":849},{"containerName":"main::","name":"authority","definition":"sub","range":{"start":{"character":0,"line":870},"end":{"line":878,"character":9999}},"kind":12,"line":870,"children":[{"kind":13,"line":871,"containerName":"authority","definition":"my","name":"$self","localvar":"my"},{"containerName":"authority","name":"$ont","definition":"my","localvar":"my","kind":13,"line":872},{"containerName":"authority","name":"$self","line":872,"kind":13},{"containerName":"authority","name":"ontology","kind":12,"line":872},{"name":"$ont","containerName":"authority","kind":13,"line":874},{"line":874,"kind":12,"name":"authority","containerName":"authority"},{"line":874,"kind":13,"name":"$ont","containerName":"authority"},{"line":875,"kind":13,"containerName":"authority","name":"$self"},{"line":875,"kind":12,"containerName":"authority","name":"throw"}]},{"definition":"sub","name":"namespace","containerName":"main::","range":{"end":{"character":9999,"line":905},"start":{"line":899,"character":0}},"kind":12,"children":[{"line":900,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"namespace"},{"kind":13,"line":902,"containerName":"namespace","name":"$self"},{"name":"ontology","containerName":"namespace","kind":12,"line":902},{"kind":13,"line":903,"name":"$ont","definition":"my","containerName":"namespace","localvar":"my"},{"name":"$self","containerName":"namespace","kind":13,"line":903},{"kind":12,"line":903,"containerName":"namespace","name":"ontology"},{"name":"$ont","containerName":"namespace","line":904,"kind":13},{"line":904,"kind":13,"name":"$ont","containerName":"namespace"},{"name":"name","containerName":"namespace","line":904,"kind":12}],"line":899},{"kind":12,"line":923,"children":[{"kind":12,"line":924,"containerName":"display_name","name":"name"}],"containerName":"main::","name":"display_name","definition":"sub","range":{"start":{"character":0,"line":923},"end":{"line":925,"character":9999}}},{"line":947,"children":[{"line":948,"kind":12,"containerName":"description","name":"definition"}],"kind":12,"range":{"end":{"line":949,"character":9999},"start":{"character":0,"line":947}},"containerName":"main::","name":"description","definition":"sub"},{"line":961,"children":[{"kind":12,"line":961,"containerName":"each_dblink","name":"throw"}],"kind":12,"range":{"start":{"line":961,"character":0},"end":{"character":9999,"line":961}},"containerName":"main::","definition":"sub","name":"each_dblink"},{"definition":"sub","name":"add_dblinks","containerName":"main::","range":{"start":{"character":0,"line":962},"end":{"character":9999,"line":962}},"kind":12,"children":[{"containerName":"add_dblinks","name":"throw","line":962,"kind":12}],"line":962}],"version":5}