{"vars":[{"line":105,"kind":2,"name":"Balanced","containerName":"strict::Bio::Root::IO::Bio::Ontology::OBOEngine::Bio::Ontology::Ontology::Bio::Ontology::OntologyStore::Bio::Ontology::TermFactory::Bio::Annotation::Collection::Text"},{"kind":14,"line":107,"definition":1,"name":"TRUE","containerName":"main::"},{"name":"FALSE","definition":1,"containerName":"main::","kind":14,"line":108},{"name":"base","containerName":"","line":110,"kind":2},{"detail":"($self,%arg)","signature":{"label":"_initialize($self,%arg)","parameters":[{"label":"$self"},{"label":"%arg"}],"documentation":"1;\n# $Id: obo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO::obo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sohel Merchant, s-merchant at northwestern.edu\n#\n# Copyright Sohel Merchant\n#\n# You may distribute this module under the same terms as perl itself\n\n\n=head1 NAME\n\nBio::OntologyIO::obo - a parser for OBO flat-file format from Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::OntologyIO;\n\n  # do not use directly -- use via Bio::OntologyIO\n  my $parser = Bio::OntologyIO->new\n        ( -format       => \"obo\",\n          -file        =>  \"gene_ontology.obo\");\n\n  while(my $ont = $parser->next_ontology()) {\n  print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_all_terms),\" total terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage  Bio::OntologyIO::obo;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Ontology::OBOEngine;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Ontology::TermFactory;\nuse Bio::Annotation::Collection;\nuse Text::Balanced qw(extract_quotelike extract_bracketed);\n\nuse constant TRUE  => 1;\nuse constant FALSE => 0;\n\nuse base qw(Bio::OntologyIO);\n\n=head2 new\n\n Title   : new\n Usage   : $parser = Bio::OntologyIO->new(\n                             -format => \"obo\",\n                             -file => \"gene_ontology.obo\");\n Function: Creates a new dagflat parser.\n Returns : A new dagflat parser object, implementing Bio::OntologyIO.\n Args    : -file      => a single ontology flat file holding the\n                          terms, descriptions and relationships\n           -ontology_name => the name of the ontology; if not specified the\n                          parser will assign the name of the ontology as the\n                          default-namespace header value from the OBO file.\n           -engine     => the Bio::Ontology::OntologyEngineI object\n                          to be reused (will be created otherwise); note\n                          that every Bio::Ontology::OntologyI will\n                          qualify as well since that one inherits from the\n                          former.\n\nSee L<Bio::OntologyIO>.\n\n in reality, we let OntologyIO::new do the instantiation, and override\n _initialize for all initialization work"},"containerName":"main::","definition":"sub","line":137,"children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":138},{"containerName":"_initialize","name":"%arg","kind":13,"line":138},{"line":140,"kind":13,"localvar":"my","name":"$file","definition":"my","containerName":"_initialize"},{"name":"$name","containerName":"_initialize","kind":13,"line":140},{"name":"$eng","containerName":"_initialize","kind":13,"line":140},{"line":140,"kind":13,"containerName":"_initialize","name":"$self"},{"line":140,"kind":12,"name":"_rearrange","containerName":"_initialize"},{"containerName":"_initialize","name":"%arg","line":147,"kind":13},{"kind":13,"line":149,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"%arg","line":149,"kind":13},{"name":"$self","containerName":"_initialize","line":150,"kind":13},{"line":153,"kind":13,"name":"$eng","containerName":"_initialize"},{"name":"new","containerName":"_initialize","kind":12,"line":153},{"containerName":"_initialize","name":"$eng","kind":13,"line":153},{"kind":13,"line":154,"containerName":"_initialize","name":"$eng"},{"kind":12,"line":154,"containerName":"_initialize","name":"isa"},{"name":"$self","containerName":"_initialize","kind":13,"line":155},{"line":155,"kind":12,"containerName":"_initialize","name":"ontology_name"},{"kind":13,"line":155,"containerName":"_initialize","name":"$eng"},{"kind":12,"line":155,"containerName":"_initialize","name":"name"},{"kind":13,"line":156,"name":"$eng","containerName":"_initialize"},{"name":"$eng","containerName":"_initialize","kind":13,"line":156},{"line":156,"kind":12,"name":"engine","containerName":"_initialize"},{"name":"$eng","containerName":"_initialize","line":156,"kind":13},{"line":156,"kind":12,"containerName":"_initialize","name":"can"},{"kind":13,"line":158,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_ont_engine","kind":12,"line":158},{"containerName":"_initialize","name":"$eng","kind":13,"line":158},{"name":"$self","containerName":"_initialize","kind":13,"line":160},{"kind":12,"line":160,"containerName":"_initialize","name":"ontology_name"},{"line":160,"kind":13,"name":"$name","containerName":"_initialize"},{"name":"$name","containerName":"_initialize","line":160,"kind":13}],"kind":12,"range":{"end":{"line":162,"character":9999},"start":{"line":137,"character":0}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","line":149,"kind":12},{"containerName":"Ontology::OBOEngine","name":"Bio","kind":12,"line":153},{"kind":12,"children":[{"kind":13,"line":177,"containerName":"ontology_name","definition":"my","name":"$self","localvar":"my"},{"containerName":"ontology_name","name":"$self","kind":13,"line":179},{"line":180,"kind":13,"name":"$self","containerName":"ontology_name"}],"line":176,"definition":"sub","name":"ontology_name","containerName":"main::","range":{"start":{"line":176,"character":0},"end":{"line":181,"character":9999}}},{"range":{"start":{"character":0,"line":199},"end":{"character":9999,"line":321}},"definition":"sub","name":"parse","containerName":"main::","children":[{"kind":13,"line":200,"name":"$self","definition":"my","containerName":"parse","localvar":"my"},{"name":"$self","containerName":"parse","kind":13,"line":203},{"kind":12,"line":203,"containerName":"parse","name":"term_factory"},{"kind":12,"line":204,"containerName":"parse","name":"new"},{"line":205,"kind":13,"name":"$self","containerName":"parse"},{"name":"term_factory","containerName":"parse","line":205,"kind":12},{"localvar":"my","definition":"my","name":"$annotations_collection","containerName":"parse","line":208,"kind":13},{"name":"$self","containerName":"parse","line":208,"kind":13},{"kind":12,"line":208,"containerName":"parse","name":"_header"},{"name":"$ont","definition":"my","containerName":"parse","localvar":"my","kind":13,"line":211},{"containerName":"parse","name":"new","kind":12,"line":211},{"containerName":"parse","name":"$self","kind":13,"line":212},{"name":"ontology_name","containerName":"parse","kind":12,"line":212},{"name":"$self","containerName":"parse","line":213,"kind":13},{"name":"_ont_engine","containerName":"parse","kind":12,"line":213},{"line":217,"kind":13,"name":"$ont","containerName":"parse"},{"containerName":"parse","name":"annotation","line":217,"kind":12},{"containerName":"parse","name":"$annotations_collection","line":217,"kind":13},{"kind":13,"line":221,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"_part_of_relationship","line":221,"kind":12},{"line":222,"kind":13,"name":"$self","containerName":"parse"},{"kind":12,"line":222,"containerName":"parse","name":"_is_a_relationship"},{"name":"$self","containerName":"parse","line":223,"kind":13},{"line":223,"kind":12,"containerName":"parse","name":"_related_to_relationship"},{"name":"$self","containerName":"parse","kind":13,"line":224},{"line":224,"kind":12,"name":"_regulates_relationship","containerName":"parse"},{"kind":13,"line":225,"containerName":"parse","name":"$self"},{"kind":12,"line":225,"containerName":"parse","name":"_positively_regulates_relationship"},{"name":"$self","containerName":"parse","line":226,"kind":13},{"containerName":"parse","name":"_negatively_regulates_relationship","line":226,"kind":12},{"line":229,"kind":12,"name":"ontology","containerName":"parse"},{"kind":13,"line":229,"name":"$ont","containerName":"parse"},{"kind":13,"line":233,"containerName":"parse","name":"$self"},{"line":233,"kind":12,"name":"_add_ontology","containerName":"parse"},{"name":"$ont","containerName":"parse","line":233,"kind":13},{"definition":"my","name":"$term","containerName":"parse","localvar":"my","kind":13,"line":237},{"line":237,"kind":13,"name":"$self","containerName":"parse"},{"line":237,"kind":12,"containerName":"parse","name":"_next_term"},{"containerName":"parse","name":"$term","kind":13,"line":240},{"line":240,"kind":12,"name":"identifier","containerName":"parse"},{"containerName":"parse","name":"$term","line":240,"kind":13},{"kind":12,"line":240,"containerName":"parse","name":"name"},{"name":"$self","containerName":"parse","kind":13,"line":241},{"kind":12,"line":241,"name":"throw","containerName":"parse"},{"line":242,"kind":13,"containerName":"parse","name":"$self"},{"kind":13,"line":250,"definition":"my","name":"$new_ontology_flag","containerName":"parse","localvar":"my"},{"line":251,"kind":13,"localvar":"my","definition":"my","name":"$ontologies_array_ref","containerName":"parse"},{"name":"$self","containerName":"parse","line":251,"kind":13},{"line":252,"kind":13,"localvar":"my","containerName":"parse","definition":"my","name":"$ontology"},{"line":252,"kind":13,"name":"$ontologies_array_ref","containerName":"parse"},{"name":"$oname","definition":"my","containerName":"parse","localvar":"my","kind":13,"line":253},{"containerName":"parse","name":"$t_ns","line":253,"kind":13},{"line":253,"kind":13,"name":"$ontology","containerName":"parse"},{"line":253,"kind":12,"name":"name","containerName":"parse"},{"kind":13,"line":253,"name":"$term","containerName":"parse"},{"kind":12,"line":253,"name":"namespace","containerName":"parse"},{"line":254,"kind":13,"containerName":"parse","name":"$oname"},{"name":"$t_ns","containerName":"parse","line":254,"kind":13},{"containerName":"parse","name":"$oname","line":255,"kind":13},{"name":"$t_ns","containerName":"parse","kind":13,"line":255},{"containerName":"parse","name":"$new_ontology_flag","kind":13,"line":257},{"line":258,"kind":13,"containerName":"parse","name":"$ont"},{"containerName":"parse","name":"$ontology","line":258,"kind":13},{"kind":13,"line":262,"containerName":"parse","name":"$new_ontology_flag"},{"containerName":"parse","name":"$term","line":262,"kind":13},{"line":262,"kind":12,"containerName":"parse","name":"namespace"},{"kind":13,"line":263,"containerName":"parse","name":"$new_ont","definition":"my","localvar":"my"},{"line":263,"kind":12,"name":"new","containerName":"parse"},{"line":264,"kind":13,"containerName":"parse","name":"$term"},{"name":"namespace","containerName":"parse","line":264,"kind":12},{"name":"$self","containerName":"parse","line":265,"kind":13},{"containerName":"parse","name":"_ont_engine","line":265,"kind":12},{"kind":13,"line":267,"name":"$new_ont","containerName":"parse"},{"name":"annotation","containerName":"parse","kind":12,"line":267},{"kind":13,"line":267,"containerName":"parse","name":"$annotations_collection"},{"kind":13,"line":268,"name":"$self","containerName":"parse"},{"line":268,"kind":12,"name":"_add_ontology","containerName":"parse"},{"containerName":"parse","name":"$new_ont","line":268,"kind":13},{"name":"$ont","containerName":"parse","kind":13,"line":269},{"kind":13,"line":269,"containerName":"parse","name":"$new_ont"},{"line":273,"kind":13,"name":"$self","containerName":"parse"},{"containerName":"parse","name":"_add_term","line":273,"kind":12},{"name":"$term","containerName":"parse","line":273,"kind":13},{"name":"$ont","containerName":"parse","kind":13,"line":273},{"localvar":"my","containerName":"parse","name":"$isa_parents_array_ref","definition":"my","line":276,"kind":13},{"line":276,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","definition":"my","name":"$parent_term","localvar":"my","kind":13,"line":277},{"line":277,"kind":13,"name":"$isa_parents_array_ref","containerName":"parse"},{"line":279,"kind":13,"name":"$self","containerName":"parse"},{"name":"_has_term","containerName":"parse","line":279,"kind":12},{"line":279,"kind":13,"name":"$parent_term","containerName":"parse"},{"line":280,"kind":13,"name":"$self","containerName":"parse"},{"kind":12,"line":280,"name":"_add_term","containerName":"parse"},{"kind":13,"line":280,"name":"$parent_term","containerName":"parse"},{"containerName":"parse","name":"$ont","kind":13,"line":280},{"kind":13,"line":283,"name":"$self","containerName":"parse"},{"line":283,"kind":12,"containerName":"parse","name":"_add_relationship"},{"kind":13,"line":283,"name":"$parent_term","containerName":"parse"},{"name":"$term","containerName":"parse","kind":13,"line":283},{"containerName":"parse","name":"$self","kind":13,"line":284},{"line":284,"kind":12,"containerName":"parse","name":"_is_a_relationship"},{"kind":13,"line":284,"name":"$ont","containerName":"parse"},{"kind":13,"line":288,"name":"$relationship_hash_ref","definition":"my","containerName":"parse","localvar":"my"},{"name":"$self","containerName":"parse","kind":13,"line":288},{"line":289,"kind":13,"localvar":"my","definition":"my","name":"$relationship","containerName":"parse"},{"line":289,"kind":13,"containerName":"parse","name":"$relationship_hash_ref"},{"line":290,"kind":13,"localvar":"my","definition":"my","name":"$reltype","containerName":"parse"},{"containerName":"parse","name":"$self","kind":13,"line":292},{"containerName":"parse","name":"_ont_engine","kind":12,"line":292},{"kind":12,"line":292,"name":"get_relationship_type","containerName":"parse"},{"name":"$relationship","containerName":"parse","line":292,"kind":13},{"kind":13,"line":293,"containerName":"parse","name":"$reltype"},{"line":294,"kind":13,"containerName":"parse","name":"$self"},{"line":294,"kind":12,"containerName":"parse","name":"_ont_engine"},{"name":"get_relationship_type","containerName":"parse","kind":12,"line":294},{"kind":13,"line":294,"name":"$relationship","containerName":"parse"},{"line":297,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"_ont_engine","line":297,"kind":12},{"containerName":"parse","name":"add_relationship_type","line":297,"kind":12},{"kind":13,"line":297,"containerName":"parse","name":"$relationship"},{"line":298,"kind":13,"containerName":"parse","name":"$ont"},{"containerName":"parse","name":"$reltype","line":299,"kind":13},{"line":300,"kind":13,"containerName":"parse","name":"$self"},{"kind":12,"line":300,"containerName":"parse","name":"_ont_engine"},{"containerName":"parse","name":"get_relationship_type","kind":12,"line":300},{"kind":13,"line":300,"name":"$relationship","containerName":"parse"},{"line":304,"kind":13,"localvar":"my","name":"$id_array_ref","definition":"my","containerName":"parse"},{"kind":13,"line":304,"name":"$relationship","containerName":"parse"},{"localvar":"my","name":"$id","definition":"my","containerName":"parse","line":305,"kind":13},{"line":305,"kind":13,"name":"$id_array_ref","containerName":"parse"},{"line":306,"kind":13,"localvar":"my","name":"$parent_term","definition":"my","containerName":"parse"},{"line":306,"kind":13,"name":"$self","containerName":"parse"},{"containerName":"parse","name":"_create_term_object","kind":12,"line":306},{"name":"$parent_term","containerName":"parse","line":307,"kind":13},{"containerName":"parse","name":"identifier","line":307,"kind":12},{"containerName":"parse","name":"$id","kind":13,"line":307},{"line":308,"kind":13,"name":"$parent_term","containerName":"parse"},{"name":"ontology","containerName":"parse","line":308,"kind":12},{"containerName":"parse","name":"$ont","kind":13,"line":308},{"containerName":"parse","name":"$self","kind":13,"line":310},{"kind":12,"line":310,"name":"_has_term","containerName":"parse"},{"line":310,"kind":13,"name":"$parent_term","containerName":"parse"},{"containerName":"parse","name":"$self","line":311,"kind":13},{"kind":12,"line":311,"containerName":"parse","name":"_add_term"},{"containerName":"parse","name":"$parent_term","line":311,"kind":13},{"kind":13,"line":311,"containerName":"parse","name":"$ont"},{"line":314,"kind":13,"name":"$self","containerName":"parse"},{"name":"_add_relationship","containerName":"parse","kind":12,"line":314},{"kind":13,"line":314,"containerName":"parse","name":"$parent_term"},{"kind":13,"line":314,"containerName":"parse","name":"$term"},{"name":"$reltype","containerName":"parse","kind":13,"line":314},{"line":314,"kind":13,"name":"$ont","containerName":"parse"},{"kind":13,"line":320,"containerName":"parse","name":"$self"},{"name":"_ont_engine","containerName":"parse","line":320,"kind":12}],"line":199,"kind":12},{"containerName":"Ontology::TermFactory","name":"Bio","kind":12,"line":204},{"containerName":"Ontology::Ontology","name":"Bio","kind":12,"line":211},{"line":263,"kind":12,"containerName":"Ontology::Ontology","name":"Bio"},{"name":"relationship_hash_ref","kind":12,"line":304},{"children":[{"kind":13,"line":338,"definition":"my","name":"$self","containerName":"next_ontology","localvar":"my"},{"kind":13,"line":341,"name":"$self","containerName":"next_ontology"},{"kind":12,"line":341,"name":"parse","containerName":"next_ontology"},{"containerName":"next_ontology","name":"$self","line":341,"kind":13},{"name":"$self","containerName":"next_ontology","line":344,"kind":13},{"containerName":"next_ontology","definition":"my","name":"$ont","localvar":"my","kind":13,"line":345},{"name":"$self","containerName":"next_ontology","line":345,"kind":13},{"line":346,"kind":13,"name":"$ont","containerName":"next_ontology"},{"line":347,"kind":13,"localvar":"my","definition":"my","name":"$store","containerName":"next_ontology"},{"name":"new","containerName":"next_ontology","line":347,"kind":12},{"kind":13,"line":348,"containerName":"next_ontology","name":"$store"},{"name":"register_ontology","containerName":"next_ontology","line":348,"kind":12},{"containerName":"next_ontology","name":"$ont","line":348,"kind":13},{"line":350,"kind":13,"name":"$ont","containerName":"next_ontology"}],"line":337,"kind":12,"range":{"start":{"line":337,"character":0},"end":{"character":9999,"line":352}},"definition":"sub","name":"next_ontology","containerName":"main::"},{"line":347,"kind":12,"name":"Bio","containerName":"Ontology::OntologyStore"},{"line":375,"children":[{"kind":13,"line":376,"containerName":"close","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"close","line":379,"kind":13}],"kind":12,"range":{"end":{"line":380,"character":9999},"start":{"character":0,"line":375}},"containerName":"main::","definition":"sub","name":"close"},{"line":379,"kind":12,"name":"SUPER","containerName":"close"},{"containerName":"main::","name":"_add_ontology","definition":"sub","range":{"end":{"character":9999,"line":397},"start":{"character":0,"line":385}},"kind":12,"line":385,"children":[{"line":386,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_add_ontology"},{"kind":13,"line":387,"containerName":"_add_ontology","name":"$self"},{"line":387,"kind":13,"name":"$self","containerName":"_add_ontology"},{"definition":"my","name":"$ont","containerName":"_add_ontology","localvar":"my","kind":13,"line":388},{"containerName":"_add_ontology","name":"$self","kind":13,"line":389},{"line":389,"kind":12,"containerName":"_add_ontology","name":"throw"},{"containerName":"_add_ontology","name":"$ont","kind":13,"line":390},{"line":391,"kind":13,"name":"$ont","containerName":"_add_ontology"},{"line":391,"kind":13,"name":"$ont","containerName":"_add_ontology"},{"kind":12,"line":391,"name":"isa","containerName":"_add_ontology"},{"kind":13,"line":395,"name":"$ont","containerName":"_add_ontology"},{"line":395,"kind":12,"containerName":"_add_ontology","name":"name"},{"name":"$self","containerName":"_add_ontology","line":395,"kind":13},{"containerName":"_add_ontology","name":"ontology_name","line":395,"kind":12},{"line":395,"kind":13,"containerName":"_add_ontology","name":"$ont"},{"line":395,"kind":12,"name":"name","containerName":"_add_ontology"},{"name":"$self","containerName":"_add_ontology","line":396,"kind":13},{"kind":13,"line":396,"containerName":"_add_ontology","name":"$ont"}]},{"name":"_add_term","range":{"start":{"line":401,"character":0},"end":{"line":405,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$term,$ont)","signature":{"label":"_add_term($self,$term,$ont)","documentation":" This simply delegates. See OBOEngine.","parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ont"}]},"kind":12,"line":401,"children":[{"line":402,"kind":13,"localvar":"my","containerName":"_add_term","name":"$self","definition":"my"},{"line":402,"kind":13,"containerName":"_add_term","name":"$term"},{"name":"$ont","containerName":"_add_term","kind":13,"line":402},{"containerName":"_add_term","name":"$term","kind":13,"line":403},{"containerName":"_add_term","name":"ontology","kind":12,"line":403},{"line":403,"kind":13,"containerName":"_add_term","name":"$ont"},{"name":"$ont","containerName":"_add_term","kind":13,"line":403},{"kind":13,"line":403,"containerName":"_add_term","name":"$term"},{"containerName":"_add_term","name":"ontology","line":403,"kind":12},{"containerName":"_add_term","name":"$self","line":404,"kind":13},{"kind":12,"line":404,"containerName":"_add_term","name":"_ont_engine"},{"name":"add_term","containerName":"_add_term","kind":12,"line":404},{"containerName":"_add_term","name":"$term","kind":13,"line":404}]},{"name":"_part_of_relationship","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":408},"end":{"line":412,"character":9999}},"kind":12,"children":[{"containerName":"_part_of_relationship","name":"$self","definition":"my","localvar":"my","kind":13,"line":409},{"line":411,"kind":13,"containerName":"_part_of_relationship","name":"$self"},{"containerName":"_part_of_relationship","name":"_ont_engine","line":411,"kind":12},{"containerName":"_part_of_relationship","name":"part_of_relationship","kind":12,"line":411}],"line":408},{"children":[{"line":416,"kind":13,"localvar":"my","containerName":"_is_a_relationship","definition":"my","name":"$self"},{"kind":13,"line":418,"containerName":"_is_a_relationship","name":"$self"},{"line":418,"kind":12,"name":"_ont_engine","containerName":"_is_a_relationship"},{"kind":12,"line":418,"name":"is_a_relationship","containerName":"_is_a_relationship"}],"line":415,"kind":12,"range":{"end":{"character":9999,"line":419},"start":{"line":415,"character":0}},"name":"_is_a_relationship","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","containerName":"_related_to_relationship","definition":"my","name":"$self","line":423,"kind":13},{"kind":13,"line":425,"name":"$self","containerName":"_related_to_relationship"},{"containerName":"_related_to_relationship","name":"_ont_engine","line":425,"kind":12},{"line":425,"kind":12,"name":"related_to_relationship","containerName":"_related_to_relationship"}],"line":422,"name":"_related_to_relationship","definition":"sub","containerName":"main::","range":{"start":{"line":422,"character":0},"end":{"line":426,"character":9999}}},{"kind":12,"children":[{"containerName":"_regulates_relationship","definition":"my","name":"$self","localvar":"my","kind":13,"line":431},{"name":"$self","containerName":"_regulates_relationship","line":433,"kind":13},{"kind":12,"line":433,"containerName":"_regulates_relationship","name":"_ont_engine"},{"kind":12,"line":433,"name":"regulates_relationship","containerName":"_regulates_relationship"}],"line":430,"name":"_regulates_relationship","definition":"sub","containerName":"main::","range":{"start":{"line":430,"character":0},"end":{"line":434,"character":9999}}},{"range":{"end":{"line":441,"character":9999},"start":{"character":0,"line":437}},"name":"_positively_regulates_relationship","definition":"sub","containerName":"main::","children":[{"kind":13,"line":438,"name":"$self","definition":"my","containerName":"_positively_regulates_relationship","localvar":"my"},{"name":"$self","containerName":"_positively_regulates_relationship","kind":13,"line":440},{"kind":12,"line":440,"name":"_ont_engine","containerName":"_positively_regulates_relationship"},{"containerName":"_positively_regulates_relationship","name":"positively_regulates_relationship","line":440,"kind":12}],"line":437,"kind":12},{"containerName":"main::","definition":"sub","name":"_negatively_regulates_relationship","range":{"end":{"character":9999,"line":449},"start":{"line":445,"character":0}},"kind":12,"line":445,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_negatively_regulates_relationship","line":446,"kind":13},{"line":448,"kind":13,"name":"$self","containerName":"_negatively_regulates_relationship"},{"containerName":"_negatively_regulates_relationship","name":"_ont_engine","kind":12,"line":448},{"kind":12,"line":448,"name":"negatively_regulates_relationship","containerName":"_negatively_regulates_relationship"}]},{"containerName":"main::","definition":"sub","detail":"($self,$parent,$child,$type,$ont)","signature":{"parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"},{"label":"$type"},{"label":"$ont"}],"documentation":" This simply delegates. See OBOEngine","label":"_add_relationship($self,$parent,$child,$type,$ont)"},"kind":12,"line":452,"children":[{"kind":13,"line":453,"name":"$self","definition":"my","containerName":"_add_relationship","localvar":"my"},{"line":453,"kind":13,"name":"$parent","containerName":"_add_relationship"},{"line":453,"kind":13,"containerName":"_add_relationship","name":"$child"},{"containerName":"_add_relationship","name":"$type","kind":13,"line":453},{"containerName":"_add_relationship","name":"$ont","line":453,"kind":13},{"kind":13,"line":457,"name":"$self","containerName":"_add_relationship"},{"name":"_ont_engine","containerName":"_add_relationship","kind":12,"line":457},{"line":457,"kind":12,"containerName":"_add_relationship","name":"add_relationship"},{"name":"$child","containerName":"_add_relationship","line":457,"kind":13},{"line":457,"kind":13,"containerName":"_add_relationship","name":"$type"},{"line":457,"kind":13,"containerName":"_add_relationship","name":"$parent"},{"containerName":"_add_relationship","name":"$ont","kind":13,"line":457}],"name":"_add_relationship","range":{"end":{"character":9999,"line":459},"start":{"character":0,"line":452}}},{"kind":12,"children":[{"localvar":"my","containerName":"_has_term","definition":"my","name":"$self","line":463,"kind":13},{"line":465,"kind":13,"name":"$self","containerName":"_has_term"},{"containerName":"_has_term","name":"_ont_engine","kind":12,"line":465},{"kind":12,"line":465,"containerName":"_has_term","name":"has_term"}],"line":462,"definition":"sub","name":"_has_term","containerName":"main::","range":{"start":{"character":0,"line":462},"end":{"character":9999,"line":466}}},{"name":"_ont_engine","range":{"start":{"character":0,"line":469},"end":{"line":477,"character":9999}},"kind":12,"line":469,"children":[{"name":"$self","definition":"my","containerName":"_ont_engine","localvar":"my","kind":13,"line":470},{"line":470,"kind":13,"name":"$value","containerName":"_ont_engine"},{"line":472,"kind":13,"name":"$value","containerName":"_ont_engine"},{"line":473,"kind":13,"name":"$self","containerName":"_ont_engine"},{"containerName":"_ont_engine","name":"$value","kind":13,"line":473},{"containerName":"_ont_engine","name":"$self","line":476,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds the OBO engine to be parsed into","label":"_ont_engine($self,$value)"}},{"definition":"sub","containerName":"main::","signature":{"documentation":" Removes the escape chracters from the file","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_filter_line($self,$line)"},"detail":"($self,$line)","kind":12,"children":[{"line":481,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_filter_line"},{"kind":13,"line":481,"name":"$line","containerName":"_filter_line"},{"name":"$line","containerName":"_filter_line","kind":13,"line":483},{"containerName":"_filter_line","name":"$line","line":484,"kind":13},{"name":"$line","containerName":"_filter_line","line":487,"kind":13},{"name":"$line","containerName":"_filter_line","kind":13,"line":489},{"kind":13,"line":491,"name":"$line","containerName":"_filter_line"},{"kind":13,"line":492,"containerName":"_filter_line","name":"$line"},{"containerName":"_filter_line","name":"$line","kind":13,"line":494},{"name":"$line","containerName":"_filter_line","line":495,"kind":13},{"kind":13,"line":496,"name":"$line","containerName":"_filter_line"},{"kind":13,"line":497,"containerName":"_filter_line","name":"$line"},{"line":498,"kind":13,"containerName":"_filter_line","name":"$line"},{"containerName":"_filter_line","name":"$line","kind":13,"line":500}],"line":480,"name":"_filter_line","range":{"end":{"character":9999,"line":501},"start":{"line":480,"character":0}}},{"name":"_header","definition":"sub","containerName":"main::","range":{"start":{"line":504,"character":0},"end":{"character":9999,"line":566}},"kind":12,"children":[{"line":505,"kind":13,"localvar":"my","containerName":"_header","definition":"my","name":"$self"},{"line":506,"kind":13,"localvar":"my","definition":"my","name":"$annotation_collection","containerName":"_header"},{"line":506,"kind":12,"name":"new","containerName":"_header"},{"kind":13,"line":507,"containerName":"_header","name":"$tag","definition":"my","localvar":"my"},{"line":507,"kind":13,"containerName":"_header","name":"$value"},{"line":508,"kind":13,"localvar":"my","name":"$line_counter","definition":"my","containerName":"_header"},{"containerName":"_header","name":"$self","kind":13,"line":509},{"line":510,"kind":13,"localvar":"my","containerName":"_header","name":"$format_version_header_flag","definition":"my"},{"kind":13,"line":511,"name":"$default_namespace_header_flag","definition":"my","containerName":"_header","localvar":"my"},{"line":513,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_header"},{"name":"$self","containerName":"_header","line":513,"kind":13},{"name":"_readline","containerName":"_header","kind":12,"line":513},{"name":"$line_counter","containerName":"_header","kind":13,"line":514},{"line":515,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_header"},{"containerName":"_header","name":"$self","kind":13,"line":515},{"line":515,"kind":12,"name":"_filter_line","containerName":"_header"},{"containerName":"_header","name":"$line","kind":13,"line":515},{"kind":13,"line":516,"name":"$line","containerName":"_header"},{"containerName":"_header","name":"$format_version_header_flag","kind":13,"line":517},{"line":517,"kind":13,"name":"$default_namespace_header_flag","containerName":"_header"},{"name":"$self","containerName":"_header","kind":13,"line":518},{"kind":12,"line":518,"name":"throw","containerName":"_header"},{"name":"$self","containerName":"_header","line":523,"kind":13},{"containerName":"_header","name":"$line_counter","kind":13,"line":523},{"containerName":"_header","name":"$annotation_collection","line":524,"kind":13},{"line":528,"kind":13,"containerName":"_header","name":"$line"},{"containerName":"_header","name":"$self","kind":13,"line":529},{"kind":12,"line":529,"name":"throw","containerName":"_header"},{"kind":13,"line":536,"name":"$self","containerName":"_header"},{"line":536,"kind":12,"name":"_check_colon","containerName":"_header"},{"line":536,"kind":13,"containerName":"_header","name":"$line"},{"name":"$line_counter","containerName":"_header","line":536,"kind":13},{"containerName":"_header","name":"$line","kind":13,"line":539},{"name":"$line","containerName":"_header","line":543,"kind":13},{"line":544,"kind":13,"name":"$tag","containerName":"_header"},{"name":"$value","containerName":"_header","kind":13,"line":544},{"containerName":"_header","name":"$tag","line":547,"kind":13},{"containerName":"_header","name":"$format_version_header_flag","kind":13,"line":548},{"kind":13,"line":549,"containerName":"_header","name":"$tag"},{"kind":13,"line":550,"name":"$default_namespace_header_flag","containerName":"_header"},{"localvar":"my","name":"$header","definition":"my","containerName":"_header","line":553,"kind":13},{"containerName":"_header","name":"new","kind":12,"line":553},{"kind":13,"line":553,"containerName":"_header","name":"$value"},{"kind":13,"line":554,"containerName":"_header","name":"$annotation_collection"},{"line":554,"kind":12,"containerName":"_header","name":"add_Annotation"},{"kind":13,"line":554,"name":"$tag","containerName":"_header"},{"containerName":"_header","name":"$header","line":554,"kind":13},{"containerName":"_header","name":"$tag","kind":13,"line":557},{"kind":13,"line":559,"name":"$self","containerName":"_header"},{"containerName":"_header","name":"ontology_name","kind":12,"line":559},{"kind":13,"line":559,"name":"$value","containerName":"_header"}],"line":504},{"name":"Bio","containerName":"Annotation::Collection","kind":12,"line":506},{"line":553,"kind":12,"name":"Bio","containerName":"Annotation::SimpleValue"},{"definition":"sub","name":"_next_term","containerName":"main::","range":{"end":{"line":705,"character":9999},"start":{"line":569,"character":0}},"kind":12,"children":[{"kind":13,"line":570,"containerName":"_next_term","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","containerName":"_next_term","definition":"my","name":"$term","line":571,"kind":13},{"containerName":"_next_term","definition":"my","name":"$skip_stanza_flag","localvar":"my","kind":13,"line":572},{"line":573,"kind":13,"localvar":"my","definition":"my","name":"$line_counter","containerName":"_next_term"},{"containerName":"_next_term","name":"$self","kind":13,"line":573},{"kind":13,"line":575,"name":"$line","definition":"my","containerName":"_next_term","localvar":"my"},{"name":"$self","containerName":"_next_term","line":575,"kind":13},{"name":"_readline","containerName":"_next_term","line":575,"kind":12},{"line":577,"kind":13,"name":"$line_counter","containerName":"_next_term"},{"line":578,"kind":13,"localvar":"my","containerName":"_next_term","name":"$line","definition":"my"},{"containerName":"_next_term","name":"$self","kind":13,"line":578},{"name":"_filter_line","containerName":"_next_term","line":578,"kind":12},{"kind":13,"line":578,"name":"$line","containerName":"_next_term"},{"containerName":"_next_term","name":"$line","line":579,"kind":13},{"kind":13,"line":579,"name":"$term","containerName":"_next_term"},{"kind":13,"line":580,"containerName":"_next_term","name":"$self"},{"containerName":"_next_term","name":"$line_counter","line":580,"kind":13},{"line":581,"kind":13,"name":"$term","containerName":"_next_term"},{"containerName":"_next_term","name":"$line","line":584,"kind":13},{"line":588,"kind":13,"name":"$term","containerName":"_next_term"},{"line":588,"kind":13,"containerName":"_next_term","name":"$self"},{"containerName":"_next_term","name":"_create_term_object","line":588,"kind":12},{"containerName":"_next_term","name":"$skip_stanza_flag","kind":13,"line":589},{"kind":13,"line":591,"containerName":"_next_term","name":"$self"},{"name":"$self","containerName":"_next_term","kind":13,"line":592},{"name":"$skip_stanza_flag","containerName":"_next_term","kind":13,"line":595},{"line":599,"kind":13,"name":"$skip_stanza_flag","containerName":"_next_term"},{"containerName":"_next_term","name":"$self","line":600,"kind":13},{"line":600,"kind":12,"name":"warn","containerName":"_next_term"},{"name":"$self","containerName":"_next_term","kind":13,"line":608},{"name":"_check_colon","containerName":"_next_term","kind":12,"line":608},{"name":"$line","containerName":"_next_term","kind":13,"line":608},{"kind":13,"line":608,"containerName":"_next_term","name":"$line_counter"},{"containerName":"_next_term","name":"$line","kind":13,"line":614},{"line":618,"kind":13,"name":"$skip_stanza_flag","containerName":"_next_term"},{"containerName":"_next_term","name":"$line","line":620,"kind":13},{"kind":13,"line":621,"containerName":"_next_term","name":"$tag","definition":"my","localvar":"my"},{"containerName":"_next_term","name":"$val","line":621,"kind":13},{"containerName":"_next_term","name":"$val","line":624,"kind":13},{"line":625,"kind":13,"name":"$self","containerName":"_next_term"},{"line":625,"kind":12,"name":"warn","containerName":"_next_term"},{"localvar":"my","definition":"my","name":"$qh","containerName":"_next_term","line":630,"kind":13},{"name":"$val","containerName":"_next_term","kind":13,"line":631},{"name":"$qh","containerName":"_next_term","line":631,"kind":13},{"line":631,"kind":13,"name":"$self","containerName":"_next_term"},{"kind":12,"line":631,"name":"_extract_quals","containerName":"_next_term"},{"containerName":"_next_term","name":"$val","line":631,"kind":13},{"line":632,"kind":13,"localvar":"my","containerName":"_next_term","definition":"my","name":"$val2"},{"name":"$val","containerName":"_next_term","line":632,"kind":13},{"line":633,"kind":13,"containerName":"_next_term","name":"$val2"},{"name":"$tag","containerName":"_next_term","kind":13,"line":634},{"name":"$tag","containerName":"_next_term","line":634,"kind":13},{"kind":13,"line":635,"name":"$tag","containerName":"_next_term"},{"line":637,"kind":13,"containerName":"_next_term","name":"$term"},{"kind":12,"line":637,"containerName":"_next_term","name":"identifier"},{"containerName":"_next_term","name":"$val","line":637,"kind":13},{"name":"$self","containerName":"_next_term","kind":13,"line":638},{"line":638,"kind":12,"name":"_has_term","containerName":"_next_term"},{"name":"$term","containerName":"_next_term","line":638,"kind":13},{"name":"$term","containerName":"_next_term","kind":13,"line":639},{"kind":13,"line":639,"containerName":"_next_term","name":"$self"},{"line":639,"kind":12,"name":"_ont_engine","containerName":"_next_term"},{"line":639,"kind":12,"name":"get_terms","containerName":"_next_term"},{"name":"$val","containerName":"_next_term","kind":13,"line":639},{"containerName":"_next_term","name":"$tag","line":643,"kind":13},{"containerName":"_next_term","name":"$term","kind":13,"line":644},{"line":644,"kind":12,"name":"name","containerName":"_next_term"},{"line":644,"kind":13,"name":"$val","containerName":"_next_term"},{"kind":13,"line":646,"name":"$tag","containerName":"_next_term"},{"containerName":"_next_term","name":"$term","kind":13,"line":647},{"containerName":"_next_term","name":"has_dbxref","kind":12,"line":647},{"name":"$val","containerName":"_next_term","line":647,"kind":13},{"kind":13,"line":648,"containerName":"_next_term","name":"$term"},{"line":648,"kind":12,"name":"add_dbxref","containerName":"_next_term"},{"kind":13,"line":648,"name":"$self","containerName":"_next_term"},{"line":648,"kind":12,"containerName":"_next_term","name":"_to_annotation"},{"line":648,"kind":13,"name":"$val","containerName":"_next_term"},{"containerName":"_next_term","name":"$tag","kind":13,"line":651},{"kind":13,"line":652,"containerName":"_next_term","name":"$term"},{"kind":12,"line":652,"name":"add_dbxref","containerName":"_next_term"},{"kind":13,"line":652,"name":"$self","containerName":"_next_term"},{"name":"_to_annotation","containerName":"_next_term","kind":12,"line":652},{"name":"$val","containerName":"_next_term","kind":13,"line":652},{"name":"$tag","containerName":"_next_term","kind":13,"line":654},{"line":655,"kind":13,"containerName":"_next_term","name":"$term"},{"kind":12,"line":655,"containerName":"_next_term","name":"namespace"},{"line":655,"kind":13,"containerName":"_next_term","name":"$val"},{"containerName":"_next_term","name":"$tag","kind":13,"line":657},{"line":658,"kind":13,"localvar":"my","containerName":"_next_term","name":"$defstr","definition":"my"},{"containerName":"_next_term","name":"$parts","kind":13,"line":658},{"name":"$self","containerName":"_next_term","kind":13,"line":658},{"containerName":"_next_term","name":"_extract_qstr","line":658,"kind":12},{"kind":13,"line":658,"name":"$val","containerName":"_next_term"},{"containerName":"_next_term","name":"$term","line":659,"kind":13},{"name":"definition","containerName":"_next_term","kind":12,"line":659},{"kind":13,"line":659,"containerName":"_next_term","name":"$defstr"},{"line":660,"kind":13,"localvar":"my","containerName":"_next_term","definition":"my","name":"$ann"},{"line":660,"kind":13,"name":"$self","containerName":"_next_term"},{"line":660,"kind":12,"name":"_to_annotation","containerName":"_next_term"},{"containerName":"_next_term","name":"$parts","line":660,"kind":13},{"line":661,"kind":13,"containerName":"_next_term","name":"$term"},{"name":"add_dbxref","containerName":"_next_term","line":661,"kind":12},{"containerName":"_next_term","name":"$ann","kind":13,"line":661},{"kind":13,"line":663,"name":"$tag","containerName":"_next_term"},{"kind":13,"line":664,"containerName":"_next_term","name":"$val"},{"containerName":"_next_term","name":"$term","line":665,"kind":13},{"line":665,"kind":12,"containerName":"_next_term","name":"add_synonym"},{"name":"$val","containerName":"_next_term","line":665,"kind":13},{"line":667,"kind":13,"containerName":"_next_term","name":"$tag"},{"containerName":"_next_term","name":"$term","kind":13,"line":668},{"line":668,"kind":12,"containerName":"_next_term","name":"add_secondary_id"},{"kind":13,"line":668,"name":"$val","containerName":"_next_term"},{"line":670,"kind":13,"containerName":"_next_term","name":"$tag"},{"kind":13,"line":672,"containerName":"_next_term","name":"$val"},{"line":673,"kind":13,"name":"$val","containerName":"_next_term"},{"kind":13,"line":675,"name":"$val","containerName":"_next_term"},{"line":676,"kind":13,"name":"$val","containerName":"_next_term"},{"kind":13,"line":678,"name":"$term","containerName":"_next_term"},{"containerName":"_next_term","name":"is_obsolete","kind":12,"line":678},{"line":678,"kind":13,"containerName":"_next_term","name":"$val"},{"containerName":"_next_term","name":"$tag","line":680,"kind":13},{"kind":13,"line":681,"name":"$term","containerName":"_next_term"},{"name":"comment","containerName":"_next_term","kind":12,"line":681},{"containerName":"_next_term","name":"$val","line":681,"kind":13},{"name":"$tag","containerName":"_next_term","kind":13,"line":683},{"name":"$self","containerName":"_next_term","line":684,"kind":13},{"line":684,"kind":12,"containerName":"_next_term","name":"_handle_relationship_tag"},{"line":684,"kind":13,"name":"$val","containerName":"_next_term"},{"containerName":"_next_term","name":"$tag","line":686,"kind":13},{"kind":13,"line":688,"name":"$val","containerName":"_next_term"},{"localvar":"my","definition":"my","name":"$parent_term","containerName":"_next_term","line":689,"kind":13},{"containerName":"_next_term","name":"$self","line":689,"kind":13},{"containerName":"_next_term","name":"_create_term_object","kind":12,"line":689},{"line":690,"kind":13,"name":"$parent_term","containerName":"_next_term"},{"kind":12,"line":690,"name":"identifier","containerName":"_next_term"},{"line":690,"kind":13,"name":"$val","containerName":"_next_term"},{"containerName":"_next_term","name":"$self","kind":13,"line":692},{"containerName":"_next_term","definition":"my","name":"$isa_parents_array_ref","localvar":"my","kind":13,"line":693},{"containerName":"_next_term","name":"$self","kind":13,"line":693},{"containerName":"_next_term","name":"$isa_parents_array_ref","kind":13,"line":694},{"containerName":"_next_term","name":"$parent_term","line":694,"kind":13},{"localvar":"my","name":"@terms_array","definition":"my","containerName":"_next_term","line":697,"kind":13},{"containerName":"_next_term","name":"@terms_array","line":698,"kind":13},{"containerName":"_next_term","name":"$parent_term","line":698,"kind":13},{"containerName":"_next_term","name":"$self","kind":13,"line":699},{"kind":13,"line":699,"containerName":"_next_term","name":"@terms_array"},{"containerName":"_next_term","name":"$term","line":704,"kind":13}],"line":569},{"range":{"end":{"line":714,"character":9999},"start":{"line":708,"character":0}},"name":"_create_term_object","children":[{"localvar":"my","containerName":"_create_term_object","definition":"my","name":"$self","line":710,"kind":13},{"localvar":"my","name":"$term","definition":"my","containerName":"_create_term_object","line":711,"kind":13},{"kind":13,"line":711,"name":"$self","containerName":"_create_term_object"},{"kind":12,"line":711,"name":"term_factory","containerName":"_create_term_object"},{"containerName":"_create_term_object","name":"create_object","kind":12,"line":711},{"kind":13,"line":712,"containerName":"_create_term_object","name":"$term"}],"line":708,"kind":12,"signature":{"label":"_create_term_object($self)","documentation":" Creates a Bio::Ontology::OBOterm object","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"_extract_quals","range":{"end":{"character":9999,"line":743},"start":{"line":717,"character":0}},"kind":12,"line":717,"children":[{"definition":"my","name":"$self","containerName":"_extract_quals","localvar":"my","kind":13,"line":718},{"name":"$str","containerName":"_extract_quals","kind":13,"line":718},{"kind":13,"line":720,"containerName":"_extract_quals","definition":"my","name":"%q","localvar":"my"},{"line":721,"kind":13,"containerName":"_extract_quals","name":"$str"},{"containerName":"_extract_quals","name":"$return_str","definition":"my","localvar":"my","kind":13,"line":722},{"definition":"my","name":"$extr","containerName":"_extract_quals","localvar":"my","kind":13,"line":723},{"containerName":"_extract_quals","name":"$extr","line":724,"kind":13},{"kind":13,"line":725,"name":"@qparts","definition":"my","containerName":"_extract_quals","localvar":"my"},{"containerName":"_extract_quals","name":"$self","kind":13,"line":725},{"containerName":"_extract_quals","name":"_split_on_comma","line":725,"kind":12},{"kind":13,"line":725,"containerName":"_extract_quals","name":"$extr"},{"line":726,"kind":13,"containerName":"_extract_quals","name":"@qparts"},{"kind":13,"line":728,"containerName":"_extract_quals","name":"$q"},{"name":"$q","containerName":"_extract_quals","line":731,"kind":13},{"kind":13,"line":738,"name":"$return_str","containerName":"_extract_quals"},{"name":"%q","containerName":"_extract_quals","kind":13,"line":738},{"line":741,"kind":13,"containerName":"_extract_quals","name":"$str"}],"containerName":"main::","definition":"sub","detail":"($self,$str)","signature":{"label":"_extract_quals($self,$str)","documentation":"","parameters":[{"label":"$self"},{"label":"$str"}]}},{"signature":{"parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"","label":"_extract_qstr($self,$str)"},"detail":"($self,$str)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_extract_qstr","localvar":"my","kind":13,"line":746},{"line":746,"kind":13,"name":"$str","containerName":"_extract_qstr"},{"line":748,"kind":13,"localvar":"my","definition":"my","name":"$extr","containerName":"_extract_qstr"},{"line":748,"kind":13,"name":"$rem","containerName":"_extract_qstr"},{"line":748,"kind":13,"name":"$prefix","containerName":"_extract_qstr"},{"kind":13,"line":748,"containerName":"_extract_qstr","name":"$str"},{"containerName":"_extract_qstr","name":"$txt","definition":"my","localvar":"my","kind":13,"line":749},{"name":"$extr","containerName":"_extract_qstr","kind":13,"line":749},{"line":750,"kind":13,"name":"$txt","containerName":"_extract_qstr"},{"kind":13,"line":751,"name":"$txt","containerName":"_extract_qstr"},{"line":752,"kind":13,"name":"$prefix","containerName":"_extract_qstr"},{"localvar":"my","containerName":"_extract_qstr","definition":"my","name":"@extra","line":756,"kind":13},{"line":759,"kind":13,"containerName":"_extract_qstr","name":"$rem"},{"kind":13,"line":760,"containerName":"_extract_qstr","name":"$rem"},{"line":761,"kind":13,"containerName":"_extract_qstr","name":"@extra"},{"kind":13,"line":764,"containerName":"_extract_qstr","definition":"my","name":"@parts","localvar":"my"},{"name":"$extr","containerName":"_extract_qstr","kind":13,"line":765},{"name":"$rem","containerName":"_extract_qstr","kind":13,"line":765},{"containerName":"_extract_qstr","name":"$prefix","line":765,"kind":13},{"name":"$rem","containerName":"_extract_qstr","kind":13,"line":765},{"kind":13,"line":766,"name":"$extr","containerName":"_extract_qstr"},{"kind":13,"line":767,"containerName":"_extract_qstr","name":"$extr"},{"containerName":"_extract_qstr","name":"$extr","line":768,"kind":13},{"line":769,"kind":13,"containerName":"_extract_qstr","name":"@parts"},{"name":"$extr","containerName":"_extract_qstr","line":769,"kind":13},{"containerName":"_extract_qstr","name":"$extr","line":769,"kind":13},{"name":"@parts","containerName":"_extract_qstr","line":771,"kind":13},{"kind":13,"line":772,"containerName":"_extract_qstr","name":"$self"},{"name":"_split_on_comma","containerName":"_extract_qstr","kind":12,"line":772},{"line":772,"kind":13,"containerName":"_extract_qstr","name":"@parts"},{"kind":13,"line":774,"name":"$txt","containerName":"_extract_qstr"},{"name":"$txt","containerName":"_extract_qstr","line":775,"kind":13},{"kind":13,"line":775,"name":"@parts","containerName":"_extract_qstr"},{"name":"@extra","containerName":"_extract_qstr","line":775,"kind":13}],"line":745,"kind":12,"range":{"end":{"character":9999,"line":776},"start":{"line":745,"character":0}},"name":"_extract_qstr"},{"line":748,"kind":12,"name":"extract_quotelike"},{"name":"extract_bracketed","kind":12,"line":765},{"line":778,"children":[{"containerName":"_split_on_comma","name":"$self","definition":"my","localvar":"my","kind":13,"line":779},{"name":"$str","containerName":"_split_on_comma","kind":13,"line":779},{"containerName":"_split_on_comma","definition":"my","name":"@parts","localvar":"my","kind":13,"line":780},{"line":781,"kind":13,"containerName":"_split_on_comma","name":"$str"},{"containerName":"_split_on_comma","name":"$str","kind":13,"line":782},{"line":783,"kind":13,"localvar":"my","definition":"my","name":"$part","containerName":"_split_on_comma"},{"line":784,"kind":13,"containerName":"_split_on_comma","name":"@parts"},{"containerName":"_split_on_comma","name":"$part","line":784,"kind":13},{"name":"$str","containerName":"_split_on_comma","line":785,"kind":13},{"name":"@parts","containerName":"_split_on_comma","kind":13,"line":787},{"name":"$str","containerName":"_split_on_comma","kind":13,"line":787},{"containerName":"_split_on_comma","name":"@parts","line":788,"kind":13}],"kind":12,"detail":"($self,$str)","signature":{"label":"_split_on_comma($self,$str)","parameters":[{"label":"$self"},{"label":"$str"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":789},"start":{"character":0,"line":778}},"name":"_split_on_comma"},{"signature":{"documentation":" This method checks for an existing colon in a line","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$line_no"}],"label":"_check_colon($self,$line,$line_no)"},"detail":"($self,$line,$line_no)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_check_colon","definition":"my","name":"$self","line":793,"kind":13},{"name":"$line","containerName":"_check_colon","kind":13,"line":793},{"kind":13,"line":793,"name":"$line_no","containerName":"_check_colon"},{"kind":13,"line":794,"containerName":"_check_colon","name":"$line"},{"containerName":"_check_colon","name":"$line","line":794,"kind":13},{"line":795,"kind":13,"containerName":"_check_colon","name":"$self"},{"containerName":"_check_colon","name":"throw","kind":12,"line":795}],"line":792,"kind":12,"range":{"end":{"line":799,"character":9999},"start":{"line":792,"character":0}},"name":"_check_colon"},{"detail":"($self,$val)","signature":{"label":"_handle_relationship_tag($self,$val)","documentation":" This method handles relationship tags","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","line":802,"children":[{"containerName":"_handle_relationship_tag","definition":"my","name":"$self","localvar":"my","kind":13,"line":803},{"containerName":"_handle_relationship_tag","name":"$val","kind":13,"line":803},{"line":804,"kind":13,"localvar":"my","containerName":"_handle_relationship_tag","definition":"my","name":"@parts"},{"containerName":"_handle_relationship_tag","name":"$val","kind":13,"line":804},{"kind":13,"line":805,"containerName":"_handle_relationship_tag","definition":"my","name":"$relationship","localvar":"my"},{"line":805,"kind":13,"containerName":"_handle_relationship_tag","name":"$parts"},{"line":806,"kind":13,"localvar":"my","containerName":"_handle_relationship_tag","definition":"my","name":"$id"},{"line":806,"kind":13,"name":"$parts","containerName":"_handle_relationship_tag"},{"kind":13,"line":806,"name":"$parts","containerName":"_handle_relationship_tag"},{"kind":13,"line":807,"containerName":"_handle_relationship_tag","name":"$parent_term","definition":"my","localvar":"my"},{"containerName":"_handle_relationship_tag","name":"$self","kind":13,"line":807},{"line":807,"kind":12,"containerName":"_handle_relationship_tag","name":"_create_term_object"},{"kind":13,"line":808,"name":"$parent_term","containerName":"_handle_relationship_tag"},{"name":"identifier","containerName":"_handle_relationship_tag","kind":12,"line":808},{"containerName":"_handle_relationship_tag","name":"$id","line":808,"kind":13},{"name":"$realtionships_hash","definition":"my","containerName":"_handle_relationship_tag","localvar":"my","kind":13,"line":810},{"kind":13,"line":810,"name":"$self","containerName":"_handle_relationship_tag"},{"kind":13,"line":811,"definition":"my","name":"$id_array_ref","containerName":"_handle_relationship_tag","localvar":"my"},{"line":811,"kind":13,"containerName":"_handle_relationship_tag","name":"$relationship"},{"kind":13,"line":812,"name":"$id_array_ref","containerName":"_handle_relationship_tag"},{"line":813,"kind":13,"localvar":"my","definition":"my","name":"@ids","containerName":"_handle_relationship_tag"},{"name":"@ids","containerName":"_handle_relationship_tag","line":814,"kind":13},{"containerName":"_handle_relationship_tag","name":"$id","line":814,"kind":13},{"name":"$relationship","containerName":"_handle_relationship_tag","kind":13,"line":815},{"name":"@ids","containerName":"_handle_relationship_tag","line":815,"kind":13},{"containerName":"_handle_relationship_tag","name":"$id_array_ref","line":819,"kind":13},{"kind":13,"line":819,"containerName":"_handle_relationship_tag","name":"$id"}],"kind":12,"range":{"end":{"character":9999,"line":824},"start":{"character":0,"line":802}},"name":"_handle_relationship_tag"},{"name":"realtionships_hash","kind":12,"line":811},{"name":"realtionships_hash","line":815,"kind":12},{"definition":"sub","containerName":"main::","signature":{"documentation":" convert simple strings to Bio::Annotation::DBLinks","parameters":[{"label":"$self"},{"label":"$links"}],"label":"_to_annotation($self,$links)"},"detail":"($self,$links)","kind":12,"children":[{"line":828,"kind":13,"localvar":"my","containerName":"_to_annotation","name":"$self","definition":"my"},{"name":"$links","containerName":"_to_annotation","kind":13,"line":828},{"line":829,"kind":13,"containerName":"_to_annotation","name":"$links"},{"line":830,"kind":13,"localvar":"my","name":"@dbxrefs","definition":"my","containerName":"_to_annotation"},{"line":831,"kind":13,"localvar":"my","containerName":"_to_annotation","name":"$string","definition":"my"},{"containerName":"_to_annotation","name":"$links","kind":13,"line":831}],"line":827,"name":"_to_annotation","range":{"end":{"character":9999,"line":831},"start":{"character":0,"line":827}}},{"localvar":"my","containerName":null,"definition":"my","name":"$db","line":832,"kind":13},{"line":832,"kind":13,"containerName":null,"name":"$id"},{"name":"$string","containerName":null,"line":832,"kind":13},{"line":833,"kind":13,"containerName":null,"name":"@dbxrefs"},{"kind":12,"line":833,"name":"Bio","containerName":"Annotation::DBLink"},{"kind":12,"line":833,"containerName":"main::","name":"new"},{"kind":13,"line":833,"containerName":null,"name":"$db"},{"name":"$id","containerName":null,"line":833,"kind":13},{"containerName":null,"name":"@dbxrefs","kind":13,"line":835}],"version":5}