{"vars":[{"containerName":"","name":"base","kind":2,"line":63},{"containerName":"main::","definition":"sub","detail":"($pkg,@args)","signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: Factory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::Factory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::Factory - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::Factory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.","parameters":[{"label":"$pkg"},{"label":"@args"}]},"kind":12,"line":98,"children":[{"containerName":"new","definition":"my","name":"$pkg","localvar":"my","kind":13,"line":99},{"kind":13,"line":99,"name":"@args","containerName":"new"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":101},{"line":101,"kind":13,"name":"$pkg","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":101},{"line":103,"kind":13,"localvar":"my","name":"$leavesR","definition":"my","containerName":"new"},{"containerName":"new","name":"$numleaves","kind":13,"line":103},{"containerName":"new","name":"$numhybrids","line":103,"kind":13},{"line":103,"kind":13,"name":"$recurse","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":104},{"name":"_rearrange","containerName":"new","line":104,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":107},{"line":108,"kind":13,"localvar":"my","containerName":"new","name":"@leaves","definition":"my"},{"line":109,"kind":13,"containerName":"new","name":"$leavesR"},{"kind":13,"line":109,"name":"$numleaves","containerName":"new"},{"line":110,"kind":13,"name":"@leaves","containerName":"new"},{"line":110,"kind":13,"containerName":"new","name":"$numleaves"},{"name":"$leavesR","containerName":"new","line":111,"kind":13},{"line":111,"kind":13,"containerName":"new","name":"@leaves"},{"kind":13,"line":113,"containerName":"new","name":"$leavesR"},{"containerName":"new","name":"$self","kind":13,"line":114},{"line":114,"kind":12,"containerName":"new","name":"throw"},{"line":116,"kind":13,"name":"@leaves","containerName":"new"},{"containerName":"new","name":"$leavesR","kind":13,"line":116},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$leavesR","line":117,"kind":13},{"name":"$numleaves","containerName":"new","line":118,"kind":13},{"line":118,"kind":13,"name":"@leaves","containerName":"new"},{"containerName":"new","name":"$self","line":119,"kind":13},{"kind":13,"line":119,"containerName":"new","name":"$numleaves"},{"line":121,"kind":13,"containerName":"new","name":"$recurse"},{"containerName":"new","name":"$numhybrids","kind":13,"line":122},{"kind":13,"line":123,"containerName":"new","name":"$numhybrids"},{"name":"$numleaves","containerName":"new","kind":13,"line":123},{"kind":13,"line":124,"name":"$recurse","containerName":"new"},{"name":"$self","containerName":"new","line":126,"kind":13},{"name":"$recurse","containerName":"new","line":126,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":127},{"containerName":"new","name":"$numhybrids","line":127,"kind":13},{"name":"$numhybrids","containerName":"new","kind":13,"line":128},{"kind":12,"line":129,"containerName":"new","name":"new"},{"name":"@leaves","containerName":"new","kind":13,"line":129},{"kind":13,"line":131,"definition":"my","name":"$parent","containerName":"new","localvar":"my"},{"line":132,"kind":13,"name":"$numhybrids","containerName":"new"},{"kind":13,"line":133,"name":"$parent","containerName":"new"},{"name":"$pkg","containerName":"new","kind":13,"line":133},{"kind":13,"line":133,"name":"@leaves","containerName":"new"},{"line":134,"kind":13,"name":"$numhybrids","containerName":"new"},{"line":135,"kind":13,"containerName":"new","name":"$recurse"},{"name":"$parent","containerName":"new","line":138,"kind":13},{"line":138,"kind":12,"name":"new","containerName":"new"},{"kind":13,"line":138,"name":"@leaves","containerName":"new"},{"name":"$self","containerName":"new","line":140,"kind":13},{"name":"$parent","containerName":"new","kind":13,"line":140},{"kind":13,"line":141,"containerName":"new","definition":"my","name":"$oldnet","localvar":"my"},{"containerName":"new","name":"$parent","line":141,"kind":13},{"containerName":"new","name":"next_network","line":141,"kind":12},{"name":"$self","containerName":"new","kind":13,"line":142},{"name":"$oldnet","containerName":"new","line":142,"kind":13},{"containerName":"new","name":"$self","line":143,"kind":13},{"line":143,"kind":12,"name":"update","containerName":"new"},{"line":144,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":145,"kind":13},{"containerName":"new","name":"$pkg","line":145,"kind":13}],"name":"new","range":{"end":{"character":9999,"line":146},"start":{"line":98,"character":0}}},{"line":99,"kind":2,"name":"TreeFactory","containerName":"Bio::PhyloNetwork::Bio::PhyloNetwork"},{"containerName":"new","name":"SUPER","line":101,"kind":12},{"name":"leaves","line":117,"kind":12},{"line":119,"kind":12,"name":"numleaves"},{"line":126,"kind":12,"name":"recurse"},{"kind":12,"line":127,"name":"numhybrids"},{"line":129,"kind":12,"name":"Bio","containerName":"PhyloNetwork::TreeFactory"},{"name":"Bio","containerName":"PhyloNetwork::TreeFactory","kind":12,"line":138},{"name":"parent","kind":12,"line":140},{"name":"oldnet","kind":12,"line":142},{"kind":12,"line":144,"name":"found"},{"children":[{"kind":13,"line":149,"containerName":"update","name":"$self","definition":"my","localvar":"my"},{"name":"@candidates","definition":"my","containerName":"update","localvar":"my","kind":13,"line":151},{"name":"$self","containerName":"update","kind":13,"line":151},{"containerName":"update","name":"edges","kind":12,"line":151},{"line":152,"kind":13,"name":"$self","containerName":"update"},{"line":152,"kind":13,"containerName":"update","name":"@candidates"},{"kind":13,"line":153,"name":"$self","containerName":"update"},{"name":"@candidates","containerName":"update","kind":13,"line":153},{"kind":13,"line":154,"name":"$self","containerName":"update"},{"name":"$self","containerName":"update","line":154,"kind":13},{"name":"$self","containerName":"update","line":155,"kind":13}],"line":148,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"update($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":156},"start":{"line":148,"character":0}},"name":"update"},{"name":"oldnet","line":151,"kind":12},{"name":"candidates","kind":12,"line":152},{"name":"numcandidates","line":153,"kind":12},{"name":"index1","line":154,"kind":12},{"kind":12,"line":154,"name":"recurse"},{"name":"index2","line":155,"kind":12},{"children":[{"line":169,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_network"},{"name":"$numleaves","definition":"my","containerName":"next_network","localvar":"my","kind":13,"line":170},{"name":"$self","containerName":"next_network","line":170,"kind":13},{"definition":"my","name":"$numhybrids","containerName":"next_network","localvar":"my","kind":13,"line":171},{"name":"$self","containerName":"next_network","kind":13,"line":171},{"line":173,"kind":13,"name":"$self","containerName":"next_network"},{"name":"$self","containerName":"next_network","kind":13,"line":174},{"containerName":"next_network","name":"$self","kind":13,"line":175},{"line":177,"kind":13,"containerName":"next_network","name":"$self"},{"kind":13,"line":177,"containerName":"next_network","name":"$self"},{"name":"$self","containerName":"next_network","line":178,"kind":13},{"kind":13,"line":179,"containerName":"next_network","name":"$self"},{"name":"$self","containerName":"next_network","kind":13,"line":181},{"kind":13,"line":181,"containerName":"next_network","name":"$self"},{"kind":13,"line":182,"containerName":"next_network","name":"$oldnet","definition":"my","localvar":"my"},{"name":"$self","containerName":"next_network","line":182,"kind":13},{"containerName":"next_network","name":"next_network","kind":12,"line":182},{"name":"$oldnet","containerName":"next_network","line":183,"kind":13},{"name":"$self","containerName":"next_network","kind":13,"line":186},{"kind":13,"line":186,"name":"$oldnet","containerName":"next_network"},{"line":187,"kind":13,"containerName":"next_network","name":"$self"},{"line":187,"kind":12,"name":"update","containerName":"next_network"},{"kind":13,"line":190,"containerName":"next_network","name":"$self"},{"line":190,"kind":12,"name":"hybrid_nodes","containerName":"next_network"},{"kind":13,"line":190,"name":"$self","containerName":"next_network"},{"name":"$self","containerName":"next_network","kind":13,"line":191},{"line":192,"kind":13,"name":"$self","containerName":"next_network"},{"line":195,"kind":13,"localvar":"my","containerName":"next_network","definition":"my","name":"$u1"},{"kind":13,"line":195,"containerName":"next_network","name":"$self"},{"name":"$self","containerName":"next_network","line":195,"kind":13},{"line":196,"kind":13,"localvar":"my","containerName":"next_network","name":"$v1","definition":"my"},{"line":196,"kind":13,"containerName":"next_network","name":"$self"},{"name":"$self","containerName":"next_network","kind":13,"line":196},{"line":197,"kind":13,"localvar":"my","containerName":"next_network","definition":"my","name":"$u2"},{"line":197,"kind":13,"name":"$self","containerName":"next_network"},{"containerName":"next_network","name":"$self","kind":13,"line":197},{"kind":13,"line":198,"containerName":"next_network","name":"$v2","definition":"my","localvar":"my"},{"kind":13,"line":198,"name":"$self","containerName":"next_network"},{"line":198,"kind":13,"containerName":"next_network","name":"$self"},{"kind":13,"line":199,"definition":"my","name":"$lbl","containerName":"next_network","localvar":"my"},{"kind":13,"line":199,"name":"$self","containerName":"next_network"},{"containerName":"next_network","name":"$self","line":200,"kind":13},{"name":"is_attackable","containerName":"next_network","line":200,"kind":12},{"containerName":"next_network","name":"$u1","kind":13,"line":200},{"name":"$v1","containerName":"next_network","line":200,"kind":13},{"containerName":"next_network","name":"$u2","kind":13,"line":200},{"name":"$v2","containerName":"next_network","line":200,"kind":13},{"kind":13,"line":201,"definition":"my","name":"$net","containerName":"next_network","localvar":"my"},{"line":201,"kind":12,"containerName":"next_network","name":"new"},{"name":"$self","containerName":"next_network","line":201,"kind":13},{"line":201,"kind":12,"name":"graph","containerName":"next_network"},{"name":"$net","containerName":"next_network","line":202,"kind":13},{"line":202,"kind":12,"containerName":"next_network","name":"do_attack"},{"kind":13,"line":202,"name":"$u1","containerName":"next_network"},{"name":"$v1","containerName":"next_network","kind":13,"line":202},{"containerName":"next_network","name":"$u2","line":202,"kind":13},{"containerName":"next_network","name":"$v2","line":202,"kind":13},{"line":202,"kind":13,"containerName":"next_network","name":"$lbl"},{"name":"$self","containerName":"next_network","line":203,"kind":13},{"kind":13,"line":204,"containerName":"next_network","definition":"my","name":"@found","localvar":"my"},{"line":204,"kind":13,"name":"$self","containerName":"next_network"},{"kind":13,"line":205,"name":"$netant","definition":"my","containerName":"next_network","localvar":"my"},{"kind":13,"line":205,"containerName":"next_network","name":"@found"},{"name":"$net","containerName":"next_network","kind":13,"line":206},{"containerName":"next_network","name":"is_mu_isomorphic","line":206,"kind":12},{"containerName":"next_network","name":"$netant","kind":13,"line":206},{"line":210,"kind":13,"name":"@found","containerName":"next_network"},{"kind":13,"line":210,"containerName":"next_network","name":"$net"},{"name":"$self","containerName":"next_network","kind":13,"line":211},{"containerName":"next_network","name":"@found","line":211,"kind":13},{"containerName":"next_network","name":"$net","line":212,"kind":13}],"line":168,"kind":12,"signature":{"documentation":"1;\n# $Id: Factory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::Factory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::Factory - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::Factory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids,$recurse)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS\n\t\t\t  RECURSE)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n\n  $recurse ||= 0;\n  if (! defined $numhybrids) {\n    $numhybrids=$numleaves-1;\n    $recurse=1;\n  }\n  $self->{recurse}=$recurse;\n  $self->{numhybrids}=$numhybrids;\n  if ($numhybrids ==0) {\n    return Bio::PhyloNetwork::TreeFactory->new(-leaves=>\\@leaves);\n  }\n  my $parent;\n  if ($numhybrids > 1) {\n    $parent=new($pkg,'-leaves'=>\\@leaves,\n\t\t'-numhybrids'=>($numhybrids-1),\n\t\t'-recurse'=>($recurse));\n  }\n  else {\n    $parent=Bio::PhyloNetwork::TreeFactory->new(-leaves=>\\@leaves);\n  }\n  $self->{parent}=$parent;\n  my $oldnet=$parent->next_network();\n  $self->{oldnet}=$oldnet;\n  $self->update();\n  $self->{found}=[];\n  bless($self,$pkg);\n}\n\nsub update {\n  my ($self)=@_;\n\n  my @candidates=$self->{oldnet}->edges();\n  $self->{candidates}=\\@candidates;\n  $self->{numcandidates}=(scalar @candidates);\n  $self->{index1}=-$self->{recurse};\n  $self->{index2}=0;\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a network\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}],"label":"next_network($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":168,"character":0},"end":{"line":213,"character":9999}},"name":"next_network"},{"kind":12,"line":170,"name":"numleaves"},{"name":"numhybrids","line":171,"kind":12},{"line":172,"kind":12,"name":"START"},{"line":173,"kind":12,"name":"index1"},{"kind":12,"line":174,"name":"index1"},{"line":175,"kind":12,"name":"oldnet"},{"name":"index1","line":177,"kind":12},{"name":"numcandidates","line":177,"kind":12},{"line":178,"kind":12,"name":"index2"},{"name":"index1","kind":12,"line":179},{"name":"index2","line":181,"kind":12},{"name":"numcandidates","line":181,"kind":12},{"line":182,"kind":12,"name":"parent"},{"line":186,"kind":12,"name":"oldnet"},{"name":"START","kind":12,"line":188},{"kind":12,"line":190,"name":"oldnet"},{"kind":12,"line":190,"name":"numhybrids"},{"line":191,"kind":12,"name":"candidates"},{"name":"numcandidates","kind":12,"line":192},{"name":"START","kind":12,"line":193},{"kind":12,"line":195,"name":"candidates"},{"kind":12,"line":195,"name":"index1"},{"name":"candidates","kind":12,"line":196},{"line":196,"kind":12,"name":"index1"},{"kind":12,"line":197,"name":"candidates"},{"name":"index2","kind":12,"line":197},{"name":"candidates","kind":12,"line":198},{"kind":12,"line":198,"name":"index2"},{"name":"numhybrids","kind":12,"line":199},{"name":"oldnet","line":200,"kind":12},{"containerName":"PhyloNetwork","name":"Bio","kind":12,"line":201},{"name":"oldnet","line":201,"kind":12},{"line":203,"kind":12,"name":"index1"},{"name":"found","kind":12,"line":204},{"name":"START","line":207,"kind":12},{"name":"found","kind":12,"line":211},{"kind":13,"line":215,"containerName":null,"name":"%self"},{"name":"index1","kind":12,"line":215},{"name":"START","kind":12,"line":216}],"version":5}