{"version":5,"vars":[{"containerName":"","name":"vars","line":80,"kind":2},{"line":82,"kind":13,"name":"$UIDCOUNTER","containerName":null},{"containerName":"","name":"strict","line":82,"kind":2},{"line":87,"kind":2,"name":"base","containerName":""},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes"},"kind":12,"line":101,"children":[{"kind":13,"line":102,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":102,"kind":13},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":104},{"containerName":"new","name":"$class","line":104,"kind":13},{"name":"@args","containerName":"new","line":104,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":105},{"localvar":"my","containerName":"new","definition":"my","name":"$uid","line":106,"kind":13},{"name":"$genotypes","containerName":"new","kind":13,"line":106},{"containerName":"new","name":"$self","line":106,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":106},{"line":107,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$uid","line":108,"kind":13},{"line":109,"kind":13,"containerName":"new","name":"$uid"},{"line":109,"kind":13,"containerName":"new","name":"$UIDCOUNTER"},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":111,"containerName":"new","name":"unique_id"},{"line":111,"kind":13,"name":"$uid","containerName":"new"},{"kind":13,"line":112,"name":"$genotypes","containerName":"new"},{"kind":13,"line":113,"containerName":"new","name":"$genotypes"},{"line":114,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":114,"name":"add_Genotype","containerName":"new"},{"kind":13,"line":114,"name":"$genotypes","containerName":"new"},{"name":"$self","containerName":"new","line":116,"kind":13},{"name":"warn","containerName":"new","kind":12,"line":116},{"kind":13,"line":119,"containerName":"new","name":"$self"}],"name":"new","range":{"start":{"line":101,"character":0},"end":{"character":9999,"line":120}}},{"line":104,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":133}},"definition":"sub","name":"unique_id","containerName":"main::","children":[{"line":134,"kind":13,"localvar":"my","containerName":"unique_id","definition":"my","name":"$self"},{"kind":13,"line":135,"containerName":"unique_id","name":"$self"},{"containerName":"unique_id","name":"$self","line":136,"kind":13}],"line":133,"kind":12},{"kind":12,"children":[],"line":149,"definition":"sub","name":"num_of_results","containerName":"main::","range":{"end":{"line":150,"character":9999},"start":{"line":149,"character":0}}},{"name":"shift","line":150,"kind":12},{"range":{"end":{"line":169,"character":9999},"start":{"character":0,"line":163}},"name":"annotation","detail":"($self,$arg)","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object","label":"annotation($self,$arg)"},"containerName":"main::","definition":"sub","line":163,"children":[{"containerName":"annotation","definition":"my","name":"$self","localvar":"my","kind":13,"line":164},{"name":"$arg","containerName":"annotation","kind":13,"line":164},{"kind":13,"line":165,"name":"$self","containerName":"annotation"},{"line":165,"kind":13,"name":"$arg","containerName":"annotation"},{"kind":13,"line":166,"name":"$self","containerName":"annotation"},{"name":"throw","containerName":"annotation","line":166,"kind":12},{"kind":13,"line":167,"name":"$arg","containerName":"annotation"},{"containerName":"annotation","name":"$arg","line":167,"kind":13},{"kind":12,"line":167,"name":"isa","containerName":"annotation"},{"kind":13,"line":168,"name":"$self","containerName":"annotation"},{"containerName":"annotation","name":"$arg","kind":13,"line":168}],"kind":12},{"name":"_annotation","line":165,"kind":12},{"name":"_annotation","kind":12,"line":168},{"signature":{"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name","parameters":[{"label":"$self"},{"label":"@genotypes"}],"label":"add_Genotype($self,@genotypes)"},"detail":"($self,@genotypes)","definition":"sub","containerName":"main::","children":[{"line":183,"kind":13,"localvar":"my","containerName":"add_Genotype","definition":"my","name":"$self"},{"kind":13,"line":183,"name":"@genotypes","containerName":"add_Genotype"},{"localvar":"my","containerName":"add_Genotype","definition":"my","name":"$g","line":185,"kind":13},{"line":185,"kind":13,"containerName":"add_Genotype","name":"@genotypes"},{"line":186,"kind":13,"containerName":"add_Genotype","name":"$g"},{"kind":13,"line":186,"name":"$g","containerName":"add_Genotype"},{"containerName":"add_Genotype","name":"isa","line":186,"kind":12},{"containerName":"add_Genotype","name":"$self","kind":13,"line":187},{"kind":12,"line":187,"containerName":"add_Genotype","name":"warn"},{"containerName":"add_Genotype","name":"$mname","definition":"my","localvar":"my","kind":13,"line":190},{"line":190,"kind":13,"name":"$g","containerName":"add_Genotype"},{"kind":12,"line":190,"containerName":"add_Genotype","name":"marker_name"},{"name":"$mname","containerName":"add_Genotype","line":191,"kind":13},{"line":191,"kind":13,"containerName":"add_Genotype","name":"$mname"},{"kind":13,"line":193,"containerName":"add_Genotype","name":"$self"},{"name":"warn","containerName":"add_Genotype","line":193,"kind":12},{"line":196,"kind":13,"name":"$self","containerName":"add_Genotype"},{"kind":12,"line":196,"name":"verbose","containerName":"add_Genotype"},{"kind":13,"line":197,"name":"$self","containerName":"add_Genotype"},{"containerName":"add_Genotype","name":"$mname","line":197,"kind":13},{"kind":13,"line":199,"name":"$self","containerName":"add_Genotype"},{"kind":12,"line":199,"name":"debug","containerName":"add_Genotype"},{"name":"$g","containerName":"add_Genotype","line":203,"kind":13},{"containerName":"add_Genotype","name":"individual_id","kind":12,"line":203},{"kind":13,"line":203,"name":"$self","containerName":"add_Genotype"},{"kind":12,"line":203,"containerName":"add_Genotype","name":"unique_id"},{"name":"$self","containerName":"add_Genotype","kind":13,"line":204},{"line":204,"kind":13,"name":"$mname","containerName":"add_Genotype"},{"name":"$g","containerName":"add_Genotype","kind":13,"line":204},{"kind":13,"line":206,"name":"$self","containerName":"add_Genotype"}],"line":182,"kind":12,"range":{"end":{"character":9999,"line":206},"start":{"character":0,"line":182}},"name":"add_Genotype"},{"range":{"start":{"character":0,"line":220},"end":{"line":222,"character":9999}},"name":"reset_Genotypes","definition":"sub","containerName":"main::","children":[],"line":220,"kind":12},{"range":{"start":{"character":0,"line":235},"end":{"line":240,"character":9999}},"name":"remove_Genotype","signature":{"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers ","parameters":[{"label":"$self"},{"label":"@mkrs"}],"label":"remove_Genotype($self,@mkrs)"},"detail":"($self,@mkrs)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"remove_Genotype","definition":"my","name":"$self","line":236,"kind":13},{"containerName":"remove_Genotype","name":"@mkrs","kind":13,"line":236},{"localvar":"my","name":"$m","definition":"my","containerName":"remove_Genotype","line":237,"kind":13},{"name":"@mkrs","containerName":"remove_Genotype","line":237,"kind":13},{"containerName":"remove_Genotype","name":"$self","line":238,"kind":13},{"containerName":"remove_Genotype","name":"$m","line":238,"kind":13}],"line":235,"kind":12},{"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)","label":"get_Genotypes($self,@args)"},"containerName":"main::","definition":"sub","line":254,"children":[{"line":255,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_Genotypes"},{"containerName":"get_Genotypes","name":"@args","kind":13,"line":255},{"line":256,"kind":13,"name":"@args","containerName":"get_Genotypes"},{"containerName":"get_Genotypes","name":"@args","line":257,"kind":13},{"kind":13,"line":257,"containerName":"get_Genotypes","name":"@args"},{"localvar":"my","containerName":"get_Genotypes","definition":"my","name":"$name","line":259,"kind":13},{"containerName":"get_Genotypes","name":"$self","line":259,"kind":13},{"line":259,"kind":12,"name":"_rearrange","containerName":"get_Genotypes"},{"name":"@args","containerName":"get_Genotypes","line":259,"kind":13},{"name":"$name","containerName":"get_Genotypes","kind":13,"line":260},{"kind":13,"line":261,"name":"$self","containerName":"get_Genotypes"},{"line":261,"kind":12,"containerName":"get_Genotypes","name":"warn"},{"name":"$v","definition":"my","containerName":"get_Genotypes","localvar":"my","kind":13,"line":264},{"containerName":"get_Genotypes","name":"$self","kind":13,"line":264},{"line":264,"kind":13,"containerName":"get_Genotypes","name":"$name"},{"name":"$v","containerName":"get_Genotypes","kind":13,"line":265},{"kind":13,"line":267,"name":"$self","containerName":"get_Genotypes"}],"kind":12,"range":{"end":{"line":267,"character":9999},"start":{"character":0,"line":254}},"name":"get_Genotypes"},{"range":{"end":{"line":292,"character":9999},"start":{"line":282,"character":0}},"name":"has_Marker","detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   if( @args ) {\n       unshift @args, '-marker' if( @args == 1 );  # deal with single args\n       \n       my ($name) = $self->_rearrange([qw(MARKER)], @args);\n       if( ! $name ) {\n\t   $self->warn(\"Only know how to process the -marker field currently\");\n\t   return();\n       }\n       my $v = $self->{'_genotypes'}->{$name};\n       return $v;\n   }\n   return values %{$self->{'_genotypes'} || {}};\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name","label":"has_Marker($self,$name)"},"containerName":"main::","definition":"sub","line":282,"children":[{"definition":"my","name":"$self","containerName":"has_Marker","localvar":"my","kind":13,"line":283},{"line":283,"kind":13,"name":"$name","containerName":"has_Marker"},{"containerName":"has_Marker","name":"$name","kind":13,"line":284},{"line":286,"kind":13,"containerName":"has_Marker","name":"$name"},{"name":"$name","containerName":"has_Marker","line":286,"kind":13},{"name":"name","containerName":"has_Marker","kind":12,"line":286},{"kind":13,"line":286,"containerName":"has_Marker","name":"$name"},{"kind":13,"line":286,"name":"$name","containerName":"has_Marker"},{"containerName":"has_Marker","name":"isa","line":286,"kind":12},{"kind":13,"line":287,"containerName":"has_Marker","name":"$name"},{"kind":13,"line":288,"containerName":"has_Marker","name":"$self"},{"line":288,"kind":12,"name":"warn","containerName":"has_Marker"},{"line":288,"kind":13,"containerName":"has_Marker","name":"$name"},{"kind":13,"line":291,"containerName":"has_Marker","name":"$self"},{"name":"$name","containerName":"has_Marker","kind":13,"line":291}],"kind":12},{"children":[{"line":306,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_marker_names"},{"containerName":"get_marker_names","name":"$self","line":307,"kind":13}],"line":305,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   if( @args ) {\n       unshift @args, '-marker' if( @args == 1 );  # deal with single args\n       \n       my ($name) = $self->_rearrange([qw(MARKER)], @args);\n       if( ! $name ) {\n\t   $self->warn(\"Only know how to process the -marker field currently\");\n\t   return();\n       }\n       my $v = $self->{'_genotypes'}->{$name};\n       return $v;\n   }\n   return values %{$self->{'_genotypes'} || {}};\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name\n\n\n\nsub has_Marker{\n   my ($self,$name) = @_;\n   return 0 if ! defined $name;\n\n   $name = $name->name if ref($name) && $name->isa('Bio::PopGen::MarkerI');\n   if( ref($name) ) { \n       $self->warn(\"Passed in a \".ref($name). \" to has_Marker, expecting either a string or a Bio::PopGen::MarkerI\");\n       return 0;\n   }\n   return defined $self->{'_genotypes'}->{$name};\n}\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $individual->get_marker_names;\n Function: Returns the list of known marker names\n Returns : List of strings\n Args    : none","label":"get_marker_names($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":307,"character":9999},"start":{"line":305,"character":0}},"name":"get_marker_names"}]}