{"version":5,"vars":[{"containerName":"","name":"base","line":97,"kind":2},{"kind":14,"line":98,"definition":1,"name":"CodonLen","containerName":"main::"},{"signature":{"label":"aln_to_population($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Utilities - Utilities for working with PopGen data and objects\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n  # get the synonymous sites from the alignemt only as the 'genotypes'\n  # for the population\n  my $synpop = Bio::PopGen::Utilities->aln_to_population(-site_model => 'cod',\n                                                         -alignment  => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object provides some convience function to turn sequence\nalignments into usable objects for the Population genetics modules\n(Bio::PopGen).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Utilities;\nuse strict;\n\nuse Bio::Align::DNAStatistics;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Individual;\n\nuse base qw(Bio::Root::Root);\nuse constant CodonLen => 3;\n\n\n=head2 aln_to_population\n\n Title   : aln_to_population\n Usage   : my $pop = Bio::PopGen::Utilities->aln_to_population($aln);\n Function: Turn and alignment into a set of L<Bio::PopGen::Individual>\n           objects grouped in a L<Bio::PopGen::Population> object\n\n           Sites are treated as 'Markers' in the Bioperl PopGen object\n           model in the sense that a site is a unique location for which\n           an individual will have a genotype (a set of alleles). \n           In this implementation we are assuming that each individual \n           has a single entry in the alignment file.\n\n           Specify a site model as one of those listed\n           'all' -- every base in the alignment is considered a site\n           'cod' -- codons \n\n           The option -site_model\n                for All sites          : 'all' \n                    Codon sites        : 'cod' or 'codon'\n\n          To see all sites, including those which are fixed in the population\n          add -include_monomorphic => 1\n          to the arguments\n Returns : \n Args    : -include_monomorphic => 1   to specify all sites, \n                                       even those which are monomorphic\n                                       in the population \n                                  (useful for HKA test mostly) \n                            [default is false]\n           -phase          => specify a phase for the data, this is only\n                              used if the site_mode is codon\n                            [default is 0]\n           -site_model     => one-of 'all', 'codon'\n                             to specify a site model for the data extraction\n                             from the alignment\n                            [default is all]\n           -alignment      => provide a L<Bio::SimpleAlign> object [required]"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":143,"name":"$self","definition":"my","containerName":"aln_to_population","localvar":"my"},{"kind":13,"line":143,"name":"@args","containerName":"aln_to_population"},{"kind":13,"line":144,"definition":"my","name":"$aln","containerName":"aln_to_population","localvar":"my"},{"line":145,"kind":13,"containerName":"aln_to_population","name":"$sitemodel"},{"containerName":"aln_to_population","name":"$phase","kind":13,"line":145},{"kind":13,"line":146,"containerName":"aln_to_population","name":"$includefixed"},{"line":146,"kind":13,"name":"$checkisa","containerName":"aln_to_population"},{"line":146,"kind":13,"containerName":"aln_to_population","name":"$self"},{"containerName":"aln_to_population","name":"_rearrange","line":146,"kind":12},{"kind":13,"line":151,"containerName":"aln_to_population","name":"@args"},{"containerName":"aln_to_population","name":"$aln","kind":13,"line":152},{"name":"$self","containerName":"aln_to_population","line":153,"kind":13},{"line":153,"kind":12,"containerName":"aln_to_population","name":"warn"},{"name":"$aln","containerName":"aln_to_population","line":157,"kind":13},{"line":157,"kind":12,"name":"is_flush","containerName":"aln_to_population"},{"name":"$self","containerName":"aln_to_population","kind":13,"line":158},{"line":158,"kind":12,"name":"warn","containerName":"aln_to_population"},{"kind":13,"line":161,"containerName":"aln_to_population","name":"$phase"},{"containerName":"aln_to_population","name":"$phase","line":161,"kind":13},{"name":"$phase","containerName":"aln_to_population","line":162,"kind":13},{"line":162,"kind":13,"name":"$phase","containerName":"aln_to_population"},{"line":162,"kind":13,"name":"$phase","containerName":"aln_to_population"},{"localvar":"my","definition":"my","name":"$alength","containerName":"aln_to_population","line":166,"kind":13},{"line":166,"kind":13,"containerName":"aln_to_population","name":"$aln"},{"line":166,"kind":12,"containerName":"aln_to_population","name":"length"},{"line":167,"kind":13,"localvar":"my","name":"@inds","definition":"my","containerName":"aln_to_population"},{"kind":13,"line":168,"name":"$sitemodel","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"$sitemodel","kind":13,"line":168},{"localvar":"my","definition":"my","name":"$ct","containerName":"aln_to_population","line":169,"kind":13},{"kind":13,"line":170,"name":"@seqs","definition":"my","containerName":"aln_to_population","localvar":"my"},{"line":171,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"aln_to_population"},{"kind":13,"line":171,"name":"$aln","containerName":"aln_to_population"},{"line":171,"kind":12,"containerName":"aln_to_population","name":"each_seq"},{"name":"@seqs","containerName":"aln_to_population","kind":13,"line":172},{"name":"$seq","containerName":"aln_to_population","line":172,"kind":13},{"line":172,"kind":12,"name":"seq","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"@inds","line":173,"kind":13},{"line":173,"kind":12,"name":"new","containerName":"aln_to_population"},{"kind":13,"line":173,"containerName":"aln_to_population","name":"$seq"},{"name":"display_id","containerName":"aln_to_population","kind":12,"line":173},{"kind":13,"line":176,"containerName":"aln_to_population","name":"$i","definition":"my","localvar":"my"},{"containerName":"aln_to_population","name":"$i","line":176,"kind":13},{"line":176,"kind":13,"name":"$alength","containerName":"aln_to_population"},{"line":176,"kind":13,"name":"$i","containerName":"aln_to_population"},{"definition":"my","name":"$nm","containerName":"aln_to_population","localvar":"my","kind":13,"line":177},{"line":178,"kind":13,"localvar":"my","name":"@genotypes","definition":"my","containerName":"aln_to_population"},{"name":"%set","containerName":"aln_to_population","line":178,"kind":13},{"line":182,"kind":13,"localvar":"my","containerName":"aln_to_population","name":"$seq","definition":"my"},{"name":"@seqs","containerName":"aln_to_population","line":182,"kind":13},{"containerName":"aln_to_population","definition":"my","name":"$site","localvar":"my","kind":13,"line":183},{"name":"$seq","containerName":"aln_to_population","kind":13,"line":183},{"line":183,"kind":13,"containerName":"aln_to_population","name":"$i"},{"containerName":"aln_to_population","name":"$set","line":184,"kind":13},{"containerName":"aln_to_population","name":"$site","kind":13,"line":184},{"kind":13,"line":185,"containerName":"aln_to_population","name":"@genotypes"},{"name":"$site","containerName":"aln_to_population","kind":13,"line":185},{"kind":13,"line":187,"name":"%set","containerName":"aln_to_population"},{"kind":13,"line":187,"name":"$includefixed","containerName":"aln_to_population"},{"kind":13,"line":188,"name":"$genoct","definition":"my","containerName":"aln_to_population","localvar":"my"},{"kind":13,"line":188,"containerName":"aln_to_population","name":"@genotypes"},{"localvar":"my","definition":"my","name":"$j","containerName":"aln_to_population","line":189,"kind":13},{"kind":13,"line":189,"containerName":"aln_to_population","name":"$j"},{"line":189,"kind":13,"containerName":"aln_to_population","name":"$genoct"},{"kind":13,"line":189,"containerName":"aln_to_population","name":"$j"},{"kind":13,"line":190,"name":"$inds","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"$j","line":190,"kind":13},{"line":190,"kind":12,"name":"add_Genotype","containerName":"aln_to_population"},{"line":191,"kind":12,"containerName":"aln_to_population","name":"new"},{"line":191,"kind":13,"containerName":"aln_to_population","name":"$nm"},{"line":192,"kind":13,"containerName":"aln_to_population","name":"$inds"},{"name":"$j","containerName":"aln_to_population","line":192,"kind":13},{"name":"unique_id","containerName":"aln_to_population","kind":12,"line":192},{"line":193,"kind":13,"name":"$genotypes","containerName":"aln_to_population"},{"kind":13,"line":193,"name":"$j","containerName":"aln_to_population"},{"line":197,"kind":13,"name":"$sitemodel","containerName":"aln_to_population"},{"name":"$ct","definition":"my","containerName":"aln_to_population","localvar":"my","kind":13,"line":198},{"line":199,"kind":13,"localvar":"my","definition":"my","name":"@seqs","containerName":"aln_to_population"},{"localvar":"my","name":"$seq","definition":"my","containerName":"aln_to_population","line":200,"kind":13},{"name":"$aln","containerName":"aln_to_population","line":200,"kind":13},{"kind":12,"line":200,"name":"each_seq","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"@seqs","kind":13,"line":201},{"containerName":"aln_to_population","name":"$seq","kind":13,"line":201},{"kind":12,"line":201,"name":"seq","containerName":"aln_to_population"},{"name":"@inds","containerName":"aln_to_population","line":202,"kind":13},{"containerName":"aln_to_population","name":"new","line":202,"kind":12},{"containerName":"aln_to_population","name":"$seq","kind":13,"line":202},{"kind":12,"line":202,"containerName":"aln_to_population","name":"display_id"},{"line":204,"kind":13,"localvar":"my","containerName":"aln_to_population","definition":"my","name":"$codonct"},{"name":"$i","definition":"my","containerName":"aln_to_population","localvar":"my","kind":13,"line":205},{"line":205,"kind":13,"name":"$phase","containerName":"aln_to_population"},{"name":"$i","containerName":"aln_to_population","kind":13,"line":205},{"kind":13,"line":205,"name":"$alength","containerName":"aln_to_population"},{"line":205,"kind":13,"name":"$i","containerName":"aln_to_population"},{"kind":13,"line":206,"definition":"my","name":"$nm","containerName":"aln_to_population","localvar":"my"},{"kind":13,"line":207,"definition":"my","name":"@genotypes","containerName":"aln_to_population","localvar":"my"},{"line":207,"kind":13,"name":"%set","containerName":"aln_to_population"},{"line":207,"kind":13,"containerName":"aln_to_population","name":"$genoct"},{"localvar":"my","containerName":"aln_to_population","name":"$seq","definition":"my","line":209,"kind":13},{"kind":13,"line":209,"name":"@seqs","containerName":"aln_to_population"},{"localvar":"my","containerName":"aln_to_population","name":"$site","definition":"my","line":210,"kind":13},{"line":210,"kind":13,"name":"$seq","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"$i","kind":13,"line":210},{"line":211,"kind":13,"name":"$site","containerName":"aln_to_population"},{"name":"$self","containerName":"aln_to_population","line":213,"kind":13},{"containerName":"aln_to_population","name":"debug","line":213,"kind":12},{"name":"$set","containerName":"aln_to_population","line":217,"kind":13},{"containerName":"aln_to_population","name":"$site","line":217,"kind":13},{"containerName":"aln_to_population","name":"@genotypes","kind":13,"line":218},{"containerName":"aln_to_population","name":"$site","line":218,"kind":13},{"containerName":"aln_to_population","name":"$genoct","kind":13,"line":220},{"line":220,"kind":13,"containerName":"aln_to_population","name":"@genotypes"},{"localvar":"my","name":"$j","definition":"my","containerName":"aln_to_population","line":224,"kind":13},{"line":224,"kind":13,"containerName":"aln_to_population","name":"$j"},{"containerName":"aln_to_population","name":"$genoct","line":224,"kind":13},{"name":"$j","containerName":"aln_to_population","kind":13,"line":224},{"containerName":"aln_to_population","name":"$inds","line":225,"kind":13},{"kind":13,"line":225,"containerName":"aln_to_population","name":"$j"},{"line":225,"kind":12,"name":"add_Genotype","containerName":"aln_to_population"},{"containerName":"aln_to_population","name":"new","kind":12,"line":226},{"name":"$nm","containerName":"aln_to_population","kind":13,"line":226},{"line":227,"kind":13,"containerName":"aln_to_population","name":"$inds"},{"name":"$j","containerName":"aln_to_population","kind":13,"line":227},{"line":227,"kind":12,"containerName":"aln_to_population","name":"unique_id"},{"containerName":"aln_to_population","name":"$genotypes","kind":13,"line":228},{"kind":13,"line":228,"containerName":"aln_to_population","name":"$j"},{"containerName":"aln_to_population","name":"$codonct","kind":13,"line":230},{"line":233,"kind":13,"containerName":"aln_to_population","name":"$self"},{"kind":12,"line":233,"name":"throw","containerName":"aln_to_population"},{"kind":12,"line":235,"containerName":"aln_to_population","name":"new"},{"line":237,"kind":13,"name":"@inds","containerName":"aln_to_population"}],"line":142,"kind":12,"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":238}},"name":"aln_to_population"},{"containerName":"PopGen::Individual","name":"Bio","line":173,"kind":12},{"containerName":"PopGen::Genotype","name":"Bio","kind":12,"line":190},{"name":"Bio","containerName":"PopGen::Individual","line":202,"kind":12},{"kind":12,"line":205,"name":"CodonLen"},{"kind":12,"line":210,"name":"CodonLen"},{"line":211,"kind":12,"name":"CodonLen"},{"line":225,"kind":12,"name":"Bio","containerName":"PopGen::Genotype"},{"containerName":"PopGen::Population","name":"Bio","kind":12,"line":235}]}