{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":125},{"name":"$MATCHPATTERN","containerName":null,"line":128,"kind":13},{"line":128,"kind":2,"containerName":"","name":"strict"},{"name":"$GAP_SYMBOLS","containerName":null,"kind":13,"line":129},{"containerName":"","name":"base","line":131,"kind":2},{"containerName":null,"name":"%valid_type","definition":"my","localvar":"my","kind":13,"line":138},{"name":"new","range":{"end":{"line":249,"character":9999},"start":{"line":176,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"line":177,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"kind":13,"line":177,"name":"@args","containerName":"new"},{"kind":13,"line":178,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"name":"$class","containerName":"new","line":178,"kind":13},{"line":178,"kind":13,"name":"@args","containerName":"new"},{"line":180,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"new"},{"line":180,"kind":13,"name":"$id","containerName":"new"},{"line":180,"kind":13,"containerName":"new","name":"$acc"},{"name":"$pid","containerName":"new","line":180,"kind":13},{"kind":13,"line":180,"containerName":"new","name":"$ns"},{"kind":13,"line":180,"containerName":"new","name":"$auth"},{"kind":13,"line":180,"containerName":"new","name":"$v"},{"name":"$oid","containerName":"new","kind":13,"line":180},{"name":"$desc","containerName":"new","line":181,"kind":13},{"line":181,"kind":13,"containerName":"new","name":"$description"},{"containerName":"new","name":"$alphabet","kind":13,"line":182},{"containerName":"new","name":"$given_id","kind":13,"line":182},{"name":"$is_circular","containerName":"new","kind":13,"line":182},{"name":"$direct","containerName":"new","line":182,"kind":13},{"line":182,"kind":13,"containerName":"new","name":"$ref_to_seq"},{"line":182,"kind":13,"name":"$len","containerName":"new"},{"line":182,"kind":13,"containerName":"new","name":"$nowarnonempty"},{"kind":13,"line":183,"name":"$self","containerName":"new"},{"line":183,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":201},{"line":204,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":204,"containerName":"new","name":"$nowarnonempty"},{"name":"$id","containerName":"new","line":206,"kind":13},{"name":"$given_id","containerName":"new","kind":13,"line":206},{"containerName":"new","name":"$id","kind":13,"line":207},{"name":"$given_id","containerName":"new","line":207,"kind":13},{"kind":13,"line":208,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":208},{"line":212,"kind":13,"name":"$given_id","containerName":"new"},{"kind":13,"line":212,"name":"$id","containerName":"new"},{"kind":13,"line":212,"name":"$given_id","containerName":"new"},{"kind":13,"line":216,"containerName":"new","name":"$len"},{"name":"$self","containerName":"new","kind":13,"line":216},{"kind":12,"line":216,"containerName":"new","name":"length"},{"containerName":"new","name":"$len","line":216,"kind":13},{"line":220,"kind":13,"containerName":"new","name":"$alphabet"},{"containerName":"new","name":"$self","kind":13,"line":220},{"name":"alphabet","containerName":"new","kind":12,"line":220},{"kind":13,"line":220,"containerName":"new","name":"$alphabet"},{"name":"$direct","containerName":"new","kind":13,"line":225},{"containerName":"new","name":"$ref_to_seq","line":225,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":226},{"line":227,"kind":13,"containerName":"new","name":"$alphabet"},{"line":228,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_guess_alphabet","kind":12,"line":228},{"line":233,"kind":13,"containerName":"new","name":"$self"},{"line":233,"kind":12,"containerName":"new","name":"seq"},{"kind":13,"line":233,"name":"$seq","containerName":"new"},{"line":233,"kind":13,"name":"$seq","containerName":"new"},{"containerName":"new","name":"$id","line":236,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":236},{"name":"display_id","containerName":"new","kind":12,"line":236},{"name":"$id","containerName":"new","line":236,"kind":13},{"name":"$acc","containerName":"new","line":237,"kind":13},{"line":237,"kind":13,"containerName":"new","name":"$self"},{"name":"accession_number","containerName":"new","line":237,"kind":12},{"containerName":"new","name":"$acc","line":237,"kind":13},{"kind":13,"line":238,"containerName":"new","name":"$pid"},{"line":238,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":238,"containerName":"new","name":"primary_id"},{"kind":13,"line":238,"containerName":"new","name":"$pid"},{"kind":13,"line":239,"name":"$desc","containerName":"new"},{"line":239,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":239,"containerName":"new","name":"desc"},{"line":239,"kind":13,"containerName":"new","name":"$desc"},{"name":"$description","containerName":"new","kind":13,"line":240},{"name":"$self","containerName":"new","kind":13,"line":240},{"containerName":"new","name":"description","line":240,"kind":12},{"containerName":"new","name":"$description","kind":13,"line":240},{"kind":13,"line":241,"name":"$is_circular","containerName":"new"},{"containerName":"new","name":"$self","line":241,"kind":13},{"name":"is_circular","containerName":"new","kind":12,"line":241},{"containerName":"new","name":"$is_circular","kind":13,"line":241},{"kind":13,"line":242,"name":"$ns","containerName":"new"},{"line":242,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"namespace","kind":12,"line":242},{"containerName":"new","name":"$ns","line":242,"kind":13},{"containerName":"new","name":"$auth","line":243,"kind":13},{"containerName":"new","name":"$self","line":243,"kind":13},{"kind":12,"line":243,"containerName":"new","name":"authority"},{"kind":13,"line":243,"name":"$auth","containerName":"new"},{"name":"$v","containerName":"new","kind":13,"line":244},{"containerName":"new","name":"$self","line":244,"kind":13},{"containerName":"new","name":"version","kind":12,"line":244},{"containerName":"new","name":"$v","kind":13,"line":244},{"name":"$oid","containerName":"new","line":245,"kind":13},{"containerName":"new","name":"$self","line":245,"kind":13},{"kind":12,"line":245,"name":"object_id","containerName":"new"},{"line":245,"kind":13,"containerName":"new","name":"$oid"},{"containerName":"new","name":"$self","kind":13,"line":248}],"line":176},{"kind":12,"line":178,"containerName":"new","name":"SUPER"},{"name":"ref_to_seq","line":226,"kind":12},{"kind":12,"line":251,"children":[{"localvar":"my","containerName":"direct_seq_set","name":"$obj","definition":"my","line":252,"kind":13},{"kind":13,"line":253,"containerName":"direct_seq_set","name":"$obj"}],"containerName":"main::","definition":"sub","name":"direct_seq_set","range":{"start":{"line":251,"character":0},"end":{"line":255,"character":9999}}},{"children":[{"kind":13,"line":273,"containerName":"seq","name":"$obj","definition":"my","localvar":"my"},{"kind":13,"line":273,"containerName":"seq","name":"@args"},{"kind":13,"line":275,"name":"@args","containerName":"seq"},{"line":276,"kind":13,"name":"$obj","containerName":"seq"},{"localvar":"my","name":"$value","definition":"my","containerName":"seq","line":279,"kind":13},{"containerName":"seq","name":"$alphabet","line":279,"kind":13},{"name":"@args","containerName":"seq","kind":13,"line":279},{"line":281,"kind":13,"name":"@args","containerName":"seq"},{"kind":13,"line":282,"containerName":"seq","name":"$value"},{"name":"$obj","containerName":"seq","kind":13,"line":282},{"kind":12,"line":282,"name":"validate_seq","containerName":"seq"},{"containerName":"seq","name":"$value","kind":13,"line":282},{"line":283,"kind":13,"name":"$obj","containerName":"seq"},{"containerName":"seq","name":"throw","kind":12,"line":283},{"localvar":"my","containerName":"seq","name":"$is_changed_seq","definition":"my","line":290,"kind":13},{"kind":13,"line":291,"name":"$obj","containerName":"seq"},{"kind":13,"line":291,"name":"$value","containerName":"seq"},{"containerName":"seq","name":"$obj","line":292,"kind":13},{"kind":13,"line":292,"containerName":"seq","name":"$value"},{"name":"$alphabet","containerName":"seq","kind":13,"line":294},{"containerName":"seq","name":"$obj","line":296,"kind":13},{"line":296,"kind":12,"name":"alphabet","containerName":"seq"},{"line":296,"kind":13,"containerName":"seq","name":"$alphabet"},{"containerName":"seq","name":"$is_changed_seq","line":298,"kind":13},{"line":300,"kind":13,"containerName":"seq","name":"$obj"},{"name":"alphabet","containerName":"seq","line":300,"kind":12},{"containerName":"seq","name":"$obj","line":302,"kind":13},{"line":302,"kind":12,"name":"_guess_alphabet","containerName":"seq"},{"containerName":"seq","name":"$obj","line":305,"kind":13},{"line":305,"kind":12,"name":"length","containerName":"seq"},{"name":"$is_changed_seq","containerName":"seq","kind":13,"line":305},{"line":305,"kind":13,"containerName":"seq","name":"$obj"},{"kind":13,"line":307,"name":"$obj","containerName":"seq"}],"line":272,"kind":12,"signature":{"label":"seq($obj,@args)","documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).","parameters":[{"label":"$obj"},{"label":"@args"}]},"detail":"($obj,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":308,"character":9999},"start":{"line":272,"character":0}},"name":"seq"},{"name":"CORE","containerName":"length","kind":12,"line":291},{"name":"validate_seq","range":{"start":{"character":0,"line":333},"end":{"character":9999,"line":344}},"containerName":"main::","definition":"sub","detail":"($self,$seqstr)","signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.","parameters":[{"label":"$self"},{"label":"$seqstr"}],"label":"validate_seq($self,$seqstr)"},"kind":12,"line":333,"children":[{"line":334,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"validate_seq"},{"name":"$seqstr","containerName":"validate_seq","line":334,"kind":13},{"kind":13,"line":335,"name":"$seqstr","containerName":"validate_seq"},{"name":"$seqstr","containerName":"validate_seq","line":335,"kind":13},{"containerName":"validate_seq","name":"$self","kind":13,"line":335},{"name":"seq","containerName":"validate_seq","line":335,"kind":12},{"line":336,"kind":13,"containerName":"validate_seq","name":"$seqstr"},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":337},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":338},{"containerName":"validate_seq","name":"$self","line":339,"kind":13},{"containerName":"validate_seq","name":"warn","line":339,"kind":12},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":340}]},{"line":337,"kind":12,"name":"CORE","containerName":"length"},{"kind":12,"children":[{"kind":13,"line":367,"containerName":"subseq","name":"$self","definition":"my","localvar":"my"},{"line":368,"kind":13,"localvar":"my","containerName":"subseq","definition":"my","name":"@args"},{"line":369,"kind":13,"localvar":"my","containerName":"subseq","definition":"my","name":"$start"},{"kind":13,"line":369,"containerName":"subseq","name":"$end"},{"line":369,"kind":13,"containerName":"subseq","name":"$nogap"},{"kind":13,"line":369,"containerName":"subseq","name":"$replace"},{"kind":13,"line":369,"containerName":"subseq","name":"$self"},{"kind":12,"line":369,"containerName":"subseq","name":"_rearrange"},{"name":"@args","containerName":"subseq","kind":13,"line":372},{"line":375,"kind":13,"localvar":"my","name":"$dummy","definition":"my","containerName":"subseq"},{"kind":13,"line":375,"containerName":"subseq","name":"$replace"},{"kind":13,"line":375,"containerName":"subseq","name":"$self"},{"kind":12,"line":375,"name":"alphabet","containerName":"subseq"},{"line":375,"kind":13,"containerName":"subseq","name":"$replace"},{"containerName":"subseq","name":"$start","kind":13,"line":377},{"line":377,"kind":13,"containerName":"subseq","name":"$start"},{"line":377,"kind":12,"name":"isa","containerName":"subseq"},{"name":"$loc","definition":"my","containerName":"subseq","localvar":"my","kind":13,"line":378},{"containerName":"subseq","name":"$start","kind":13,"line":378},{"kind":13,"line":379,"definition":"my","name":"$seq","containerName":"subseq","localvar":"my"},{"localvar":"my","name":"$subloc","definition":"my","containerName":"subseq","line":380,"kind":13},{"kind":13,"line":380,"containerName":"subseq","name":"$loc"},{"containerName":"subseq","name":"each_Location","kind":12,"line":380},{"line":381,"kind":13,"localvar":"my","name":"$piece","definition":"my","containerName":"subseq"},{"kind":13,"line":381,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"subseq","kind":12,"line":381},{"name":"$subloc","containerName":"subseq","kind":13,"line":381},{"containerName":"subseq","name":"start","kind":12,"line":381},{"line":382,"kind":13,"containerName":"subseq","name":"$subloc"},{"name":"end","containerName":"subseq","line":382,"kind":12},{"name":"$replace","containerName":"subseq","kind":13,"line":383},{"name":"$nogap","containerName":"subseq","kind":13,"line":384},{"containerName":"subseq","name":"$piece","line":385,"kind":13},{"containerName":"subseq","name":"$nogap","kind":13,"line":385},{"line":386,"kind":13,"name":"$subloc","containerName":"subseq"},{"name":"strand","containerName":"subseq","kind":12,"line":386},{"line":387,"kind":13,"containerName":"subseq","name":"$piece"},{"containerName":"subseq","name":"new","kind":12,"line":387},{"kind":13,"line":387,"name":"$piece","containerName":"subseq"},{"line":387,"kind":12,"name":"revcom","containerName":"subseq"},{"line":387,"kind":12,"name":"seq","containerName":"subseq"},{"kind":13,"line":389,"containerName":"subseq","name":"$seq"},{"line":389,"kind":13,"name":"$piece","containerName":"subseq"},{"containerName":"subseq","name":"$seq","kind":13,"line":391},{"line":392,"kind":13,"containerName":"subseq","name":"$start"},{"kind":13,"line":392,"name":"$end","containerName":"subseq"},{"name":"$start","containerName":"subseq","line":393,"kind":13},{"kind":13,"line":393,"name":"$end","containerName":"subseq"},{"kind":13,"line":394,"containerName":"subseq","name":"$self"},{"line":394,"kind":12,"name":"throw","containerName":"subseq"},{"line":397,"kind":13,"name":"$start","containerName":"subseq"},{"name":"$self","containerName":"subseq","kind":13,"line":398},{"containerName":"subseq","name":"throw","line":398,"kind":12},{"kind":13,"line":400,"name":"$end","containerName":"subseq"},{"kind":13,"line":400,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"length","kind":12,"line":400},{"containerName":"subseq","name":"$self","kind":13,"line":401},{"name":"throw","containerName":"subseq","line":401,"kind":12},{"kind":13,"line":401,"containerName":"subseq","name":"$self"},{"line":401,"kind":12,"containerName":"subseq","name":"length"},{"kind":13,"line":405,"name":"$start","containerName":"subseq"},{"line":406,"kind":13,"localvar":"my","containerName":"subseq","definition":"my","name":"@ss_args"},{"line":407,"kind":13,"localvar":"my","definition":"my","name":"$seqstr","containerName":"subseq"},{"line":407,"kind":13,"name":"@ss_args","containerName":"subseq"},{"containerName":"subseq","name":"$seqstr","line":408,"kind":13},{"line":408,"kind":13,"containerName":"subseq","name":"$nogap"},{"line":409,"kind":13,"containerName":"subseq","name":"$seqstr"},{"name":"$self","containerName":"subseq","kind":13,"line":412},{"kind":12,"line":412,"containerName":"subseq","name":"warn"},{"name":"$self","containerName":"subseq","line":412,"kind":13},{"name":"$start","containerName":"subseq","line":412,"kind":13},{"line":412,"kind":13,"containerName":"subseq","name":"$end"},{"containerName":"subseq","name":"$replace","line":412,"kind":13},{"line":412,"kind":13,"containerName":"subseq","name":"$nogap"}],"line":366,"name":"subseq","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":415},"start":{"character":0,"line":366}}},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":375},{"kind":12,"line":387,"containerName":"PrimarySeq","name":"Bio"},{"range":{"end":{"line":459,"character":9999},"start":{"character":0,"line":444}},"containerName":"main::","name":"length","definition":"sub","line":444,"children":[{"containerName":"length","name":"$self","definition":"my","localvar":"my","kind":13,"line":445},{"kind":13,"line":446,"containerName":"length","definition":"my","name":"$len","localvar":"my"},{"containerName":"length","name":"$self","kind":13,"line":446},{"kind":12,"line":446,"name":"seq","containerName":"length"},{"kind":13,"line":449,"containerName":"length","definition":"my","name":"$val","localvar":"my"},{"containerName":"length","name":"$val","kind":13,"line":450},{"kind":13,"line":450,"name":"$len","containerName":"length"},{"containerName":"length","name":"$len","line":450,"kind":13},{"name":"$val","containerName":"length","line":450,"kind":13},{"containerName":"length","name":"$self","line":451,"kind":13},{"name":"throw","containerName":"length","line":451,"kind":12},{"kind":13,"line":452,"containerName":"length","name":"$val"},{"kind":13,"line":454,"name":"$self","containerName":"length"},{"line":454,"kind":13,"containerName":"length","name":"$val"},{"containerName":"length","name":"$self","line":455,"kind":13},{"line":456,"kind":13,"containerName":"length","name":"$self"},{"name":"$len","containerName":"length","kind":13,"line":458}],"kind":12},{"containerName":"length","name":"CORE","kind":12,"line":446},{"name":"display_id","range":{"end":{"character":9999,"line":493},"start":{"line":487,"character":0}},"kind":12,"line":487,"children":[{"localvar":"my","containerName":"display_id","name":"$obj","definition":"my","line":488,"kind":13},{"line":488,"kind":13,"containerName":"display_id","name":"$value"},{"containerName":"display_id","name":"$value","kind":13,"line":489},{"name":"$obj","containerName":"display_id","line":490,"kind":13},{"name":"$value","containerName":"display_id","kind":13,"line":490},{"containerName":"display_id","name":"$obj","kind":13,"line":492}],"containerName":"main::","definition":"sub","detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None","label":"display_id($obj,$value)"}},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting","parameters":[{"label":"$obj"},{"label":"$acc"}],"label":"accession_number($obj,$acc)"},"detail":"($obj,$acc)","kind":12,"children":[{"containerName":"accession_number","name":"$obj","definition":"my","localvar":"my","kind":13,"line":520},{"line":520,"kind":13,"name":"$acc","containerName":"accession_number"},{"line":522,"kind":13,"name":"$acc","containerName":"accession_number"},{"containerName":"accession_number","name":"$obj","line":523,"kind":13},{"name":"$acc","containerName":"accession_number","kind":13,"line":523},{"name":"$acc","containerName":"accession_number","kind":13,"line":525},{"containerName":"accession_number","name":"$obj","line":525,"kind":13},{"line":526,"kind":13,"containerName":"accession_number","name":"$acc"},{"kind":13,"line":526,"name":"$acc","containerName":"accession_number"},{"containerName":"accession_number","name":"$acc","line":528,"kind":13}],"line":519,"name":"accession_number","range":{"start":{"character":0,"line":519},"end":{"character":9999,"line":529}}},{"kind":12,"children":[{"line":549,"kind":13,"localvar":"my","containerName":"primary_id","name":"$obj","definition":"my"},{"line":552,"kind":13,"name":"$obj","containerName":"primary_id"},{"kind":13,"line":554,"containerName":"primary_id","name":"$obj"},{"kind":13,"line":557,"containerName":"primary_id","name":"$obj"}],"line":548,"name":"primary_id","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":548},"end":{"character":9999,"line":558}}},{"range":{"end":{"character":9999,"line":591},"start":{"character":0,"line":579}},"name":"alphabet","line":579,"children":[{"localvar":"my","name":"$obj","definition":"my","containerName":"alphabet","line":580,"kind":13},{"kind":13,"line":580,"containerName":"alphabet","name":"$value"},{"name":"$value","containerName":"alphabet","kind":13,"line":581},{"containerName":"alphabet","name":"$value","kind":13,"line":582},{"kind":13,"line":582,"name":"$value","containerName":"alphabet"},{"name":"$valid_type","containerName":"alphabet","line":583,"kind":13},{"kind":13,"line":583,"name":"$value","containerName":"alphabet"},{"name":"$obj","containerName":"alphabet","kind":13,"line":584},{"name":"throw","containerName":"alphabet","kind":12,"line":584},{"containerName":"alphabet","name":"%valid_type","kind":13,"line":585},{"kind":13,"line":588,"name":"$obj","containerName":"alphabet"},{"name":"$value","containerName":"alphabet","line":588,"kind":13},{"name":"$obj","containerName":"alphabet","line":590,"kind":13}],"kind":12,"detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'","label":"alphabet($obj,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","name":"desc","containerName":"main::","range":{"end":{"character":9999,"line":614},"start":{"character":0,"line":609}},"kind":12,"children":[{"containerName":"desc","definition":"my","name":"$self","localvar":"my","kind":13,"line":610},{"kind":13,"line":612,"containerName":"desc","name":"$self"},{"line":613,"kind":13,"name":"$self","containerName":"desc"}],"line":609},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"can_call_new($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :"},"kind":12,"line":628,"children":[{"name":"$self","definition":"my","containerName":"can_call_new","localvar":"my","kind":13,"line":629}],"name":"can_call_new","range":{"end":{"character":9999,"line":632},"start":{"character":0,"line":628}}},{"line":646,"children":[{"name":"display_id","containerName":"id","kind":12,"line":647}],"kind":12,"range":{"start":{"line":646,"character":0},"end":{"line":648,"character":9999}},"containerName":"main::","name":"id","definition":"sub"},{"children":[{"kind":13,"line":661,"definition":"my","name":"$self","containerName":"is_circular","localvar":"my"},{"line":663,"kind":13,"containerName":"is_circular","name":"$self"},{"containerName":"is_circular","name":"$self","line":664,"kind":13}],"line":660,"kind":12,"range":{"end":{"character":9999,"line":665},"start":{"character":0,"line":660}},"name":"is_circular","definition":"sub","containerName":"main::"},{"name":"object_id","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":686},"end":{"character":9999,"line":688}},"kind":12,"children":[{"kind":12,"line":687,"name":"accession_number","containerName":"object_id"}],"line":686},{"range":{"start":{"line":703,"character":0},"end":{"character":9999,"line":709}},"name":"version","children":[{"kind":13,"line":704,"containerName":"version","definition":"my","name":"$self","localvar":"my"},{"line":704,"kind":13,"containerName":"version","name":"$value"},{"line":705,"kind":13,"name":"$value","containerName":"version"},{"kind":13,"line":706,"name":"$self","containerName":"version"},{"line":706,"kind":13,"name":"$value","containerName":"version"},{"line":708,"kind":13,"name":"$self","containerName":"version"}],"line":703,"kind":12,"signature":{"label":"version($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"authority","range":{"start":{"line":724,"character":0},"end":{"character":9999,"line":730}},"definition":"sub","containerName":"main::","signature":{"label":"authority($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar"},"detail":"($obj,$value)","kind":12,"children":[{"line":725,"kind":13,"localvar":"my","definition":"my","name":"$obj","containerName":"authority"},{"kind":13,"line":725,"containerName":"authority","name":"$value"},{"name":"$value","containerName":"authority","kind":13,"line":726},{"line":727,"kind":13,"name":"$obj","containerName":"authority"},{"name":"$value","containerName":"authority","line":727,"kind":13},{"containerName":"authority","name":"$obj","kind":13,"line":729}],"line":724},{"signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t\t $obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection.\n\n Returns : A scalar","parameters":[{"label":"$self"},{"label":"$value"}],"label":"namespace($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":746,"kind":13,"localvar":"my","containerName":"namespace","name":"$self","definition":"my"},{"kind":13,"line":746,"containerName":"namespace","name":"$value"},{"name":"$value","containerName":"namespace","line":747,"kind":13},{"name":"$self","containerName":"namespace","line":748,"kind":13},{"kind":13,"line":748,"name":"$value","containerName":"namespace"},{"name":"$self","containerName":"namespace","kind":13,"line":750}],"line":745,"kind":12,"range":{"start":{"line":745,"character":0},"end":{"character":9999,"line":751}},"name":"namespace"},{"children":[{"name":"display_id","containerName":"display_name","kind":12,"line":775}],"line":774,"kind":12,"range":{"start":{"character":0,"line":774},"end":{"character":9999,"line":776}},"definition":"sub","name":"display_name","containerName":"main::"},{"name":"description","definition":"sub","containerName":"main::","range":{"end":{"line":796,"character":9999},"start":{"character":0,"line":794}},"kind":12,"children":[{"kind":12,"line":795,"containerName":"description","name":"desc"}],"line":794},{"kind":12,"line":861,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_guess_alphabet","line":862,"kind":13},{"localvar":"my","containerName":"_guess_alphabet","name":"$type","definition":"my","line":863,"kind":13},{"kind":13,"line":867,"definition":"my","name":"$str","containerName":"_guess_alphabet","localvar":"my"},{"line":867,"kind":13,"containerName":"_guess_alphabet","name":"$self"},{"name":"seq","containerName":"_guess_alphabet","line":867,"kind":12},{"name":"$str","containerName":"_guess_alphabet","kind":13,"line":869},{"line":871,"kind":13,"localvar":"my","containerName":"_guess_alphabet","name":"$total","definition":"my"},{"name":"$str","containerName":"_guess_alphabet","kind":13,"line":871},{"kind":13,"line":872,"containerName":"_guess_alphabet","name":"$total"},{"kind":13,"line":873,"containerName":"_guess_alphabet","name":"$self"},{"name":"$self","containerName":"_guess_alphabet","kind":13,"line":874},{"containerName":"_guess_alphabet","name":"warn","line":874,"kind":12},{"containerName":"_guess_alphabet","name":"$u","definition":"my","localvar":"my","kind":13,"line":880},{"name":"$str","containerName":"_guess_alphabet","kind":13,"line":880},{"containerName":"_guess_alphabet","definition":"my","name":"$atgc","localvar":"my","kind":13,"line":884},{"name":"$str","containerName":"_guess_alphabet","kind":13,"line":884},{"line":886,"kind":13,"name":"$atgc","containerName":"_guess_alphabet"},{"name":"$total","containerName":"_guess_alphabet","line":886,"kind":13},{"line":887,"kind":13,"name":"$type","containerName":"_guess_alphabet"},{"containerName":"_guess_alphabet","name":"$atgc","line":888,"kind":13},{"containerName":"_guess_alphabet","name":"$u","line":888,"kind":13},{"name":"$total","containerName":"_guess_alphabet","line":888,"kind":13},{"containerName":"_guess_alphabet","name":"$type","kind":13,"line":889},{"name":"$type","containerName":"_guess_alphabet","kind":13,"line":891},{"name":"$self","containerName":"_guess_alphabet","line":894,"kind":13},{"containerName":"_guess_alphabet","name":"alphabet","line":894,"kind":12},{"name":"$type","containerName":"_guess_alphabet","line":894,"kind":13},{"containerName":"_guess_alphabet","name":"$type","line":895,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t\t $obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection.\n\n Returns : A scalar\n\n\n\nsub namespace{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'namespace'} = $value;\n    }\n    return $self->{'namespace'} || \"\";\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\nThis comprises of display_name and description.\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user.\n           The string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea).\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display.\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods Inherited from Bio::PrimarySeqI\n\nThese methods are available on Bio::PrimarySeq, although they are\nactually implemented on Bio::PrimarySeqI\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::SeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of\n           \"Sequence is a protein. Cannot revcom\".\n\n           The id is the same id as the orginal sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions.\n\n           To do an inplace edit of an object you can go:\n\n           $seqobj = $seqobj->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::SeqI object\n Args    : none\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : A fresh Bio::SeqI implementing object.\n Args    :\n\n\n\n=head1 Internal methods\n\nThese are internal methods to PrimarySeq\n\n\n=head2 _guess_alphabet\n\n Title   : _guess_alphabet\n Usage   :\n Function: Determines (and sets) the type of sequence: dna, rna, protein\n Example :\n Returns : one of strings 'dna', 'rna' or 'protein'.\n Args    : none","label":"_guess_alphabet($self)"},"name":"_guess_alphabet","range":{"end":{"line":896,"character":9999},"start":{"character":0,"line":861}}},{"line":871,"kind":12,"containerName":"length","name":"CORE"},{"containerName":"main::","name":"accession","definition":"sub","range":{"start":{"character":0,"line":902},"end":{"line":908,"character":9999}},"kind":12,"line":902,"children":[{"kind":13,"line":903,"name":"$self","definition":"my","containerName":"accession","localvar":"my"},{"line":905,"kind":13,"containerName":"accession","name":"$self"},{"containerName":"accession","name":"warn","kind":12,"line":905},{"name":"$self","containerName":"accession","line":905,"kind":13},{"containerName":"accession","name":"$self","line":907,"kind":13},{"name":"accession_number","containerName":"accession","line":907,"kind":12}]}]}