{"version":5,"vars":[{"name":"vars","containerName":"","line":113,"kind":2},{"line":114,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":139,"character":9999},"start":{"character":0,"line":127}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: MultiCut.pm 16123 2009-09-17 12:57:27Z cjfields $\n#------------------------------------------------------------------\n#\n# BioPerl module Bio::Restriction::Enzyme::MultiCut\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n#------------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Restriction::Enzyme::MultiCut - A single restriction endonuclease\n\n=head1 SYNOPSIS\n\n  # set up a single restriction enzyme. This contains lots of\n  # information about the enzyme that is generally parsed from a\n  # rebase file and can then be read back\n\n  use Bio::Restriction::Enzyme;\n\n\n=head1 DESCRIPTION\n\nThis module defines a restriction endonuclease class where one object\nrepresents one of the distinct recognition sites for that enzyme. The\nmethod L<others|others> stores references to other objects with\nalternative sites.\n\nIn this schema each object within an EnzymeCollection can be checked\nfor matching a sequence.\n\n\nREBASE report notation C<Bsp24I (8/13)GACNNNNNNTGG(12/7)> means:\n\n\n   Bsp24I\n             5'      ^NNNNNNNNGACNNNNNNTGGNNNNNNNNNNNN^   3'\n             3' ^NNNNNNNNNNNNNCTGNNNNNNACCNNNNNNN^        5'\n\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRob Edwards, redwards@utmem.edu\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Rob Edwards.\n\nSome of this work is Copyright (c) 1997-2002 Steve A. Chervitz. All\nRights Reserved.  This module is free software; you can redistribute\nit and/or modify it under the same terms as Perl itself.\n\n=head1 SEE ALSO\n\nL<Bio::Restriction::Enzyme>, L<Bio::Restriction::Analysis>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 APPENDIX\n\nMethods beginning with a leading underscore are considered private and\nare intended for internal use by this module. They are not considered\npart of the public interface and are described here for documentation\npurposes only.\n\n\npackage Bio::Restriction::Enzyme::MultiCut;\nuse strict;\n\nuse Data::Dumper;\n\nuse vars qw ();\nuse base qw(Bio::Restriction::Enzyme);\n\n\n=head2 new\n\n Title     : new\n Function\n Function  : Initializes the enzyme object\n Returns   : The Restriction::Enzyme::MultiCut object\n Argument  : ","label":"new($class,@args)"},"kind":12,"line":127,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":128,"kind":13},{"line":128,"kind":13,"containerName":"new","name":"@args"},{"line":129,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","line":129,"kind":13},{"kind":13,"line":129,"containerName":"new","name":"@args"},{"kind":13,"line":131,"definition":"my","name":"$others","containerName":"new","localvar":"my"},{"kind":13,"line":132,"name":"$self","containerName":"new"},{"kind":12,"line":132,"containerName":"new","name":"_rearrange"},{"kind":13,"line":135,"name":"@args","containerName":"new"},{"line":137,"kind":13,"name":"$others","containerName":"new"},{"kind":13,"line":137,"containerName":"new","name":"$self"},{"containerName":"new","name":"others","line":137,"kind":12},{"kind":13,"line":137,"name":"$others","containerName":"new"},{"containerName":"new","name":"$self","line":138,"kind":13}]},{"line":129,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"line":154,"children":[{"kind":13,"line":155,"containerName":"others","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"others","kind":13,"line":156}],"containerName":"main::","definition":"sub","name":"others","range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":154}}},{"name":"_others","line":156,"kind":12},{"kind":13,"line":157,"containerName":null,"name":"%self"},{"name":"_others","line":157,"kind":12},{"kind":13,"line":158,"name":"%self","containerName":null},{"line":172,"children":[{"containerName":"purge_others","name":"$self","definition":"my","localvar":"my","kind":13,"line":173},{"containerName":"purge_others","name":"$self","line":174,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":172},"end":{"character":9999,"line":176}},"containerName":"main::","definition":"sub","name":"purge_others"},{"name":"_others","kind":12,"line":174}]}