{"vars":[{"name":"vars","containerName":"","line":177,"kind":2},{"containerName":"","name":"base","line":181,"kind":2},{"line":185,"kind":13,"containerName":null,"name":"$ID"},{"kind":13,"line":186,"containerName":null,"name":"$DEBUG"},{"name":"$VERBOSITY","containerName":null,"kind":13,"line":187},{"line":188,"kind":13,"name":"$ERRORLOADED","containerName":null},{"containerName":null,"name":"$main","line":195,"kind":13},{"line":195,"kind":12,"name":"DONT_USE_ERROR","containerName":""},{"name":"Error","kind":12,"line":197},{"name":"$ERRORLOADED","containerName":null,"line":199,"kind":13},{"kind":12,"line":199,"name":"Bio","containerName":"Root::Exception"},{"line":200,"kind":13,"containerName":null,"name":"$Error"},{"line":200,"kind":12,"containerName":"","name":"Debug"},{"kind":13,"line":203,"name":"%ERRORLOADED","containerName":null},{"line":204,"kind":12,"name":"Carp"},{"kind":13,"line":206,"containerName":null,"name":"$main"},{"range":{"start":{"character":0,"line":219},"end":{"line":234,"character":9999}},"containerName":"main::","name":"new","definition":"sub","line":219,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":221,"kind":13},{"line":222,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"containerName":"new","name":"$self","line":223,"kind":13},{"kind":13,"line":223,"name":"$class","containerName":"new"},{"line":223,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":229,"name":"%param","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$self","kind":13,"line":231},{"line":231,"kind":12,"name":"verbose","containerName":"new"},{"line":231,"kind":13,"name":"$param","containerName":"new"},{"line":231,"kind":13,"name":"$param","containerName":"new"},{"containerName":"new","name":"$self","line":233,"kind":13}],"kind":12},{"line":221,"kind":12,"name":"DONT_USE_ERROR","containerName":""},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\npackage Bio::Root::Root;\nuse strict;\n\n# $Id: Root.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Root::Root - Hash-based implementation of Bio::Root::RootI\n\n=head1 SYNOPSIS\n\n  # Any Bioperl-compliant object is a RootI compliant object\n\n  # Here's how to throw and catch an exception using the eval-based syntax.\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Alternatively, using the new typed exception syntax in the throw() call:\n\n  $obj->throw( -class => 'Bio::Root::BadParameter',\n               -text  => \"Can not open file $file\",\n               -value  => $file );\n\n  # Want to see debug() outputs for this object\n\n  my $obj = Bio::Object->new(-verbose=>1);\n\n  my $obj = Bio::Object->new(%args);\n  $obj->verbose(2);\n\n  # Print debug messages which honour current verbosity setting\n\n  $obj->debug(\"Boring output only to be seen if verbose > 0\\n\");\n\n=head1 DESCRIPTION\n\nThis is a hashref-based implementation of the Bio::Root::RootI\ninterface.  Most Bioperl objects should inherit from this.\n\nSee the documentation for L<Bio::Root::RootI> for most of the methods\nimplemented by this module.  Only overridden methods are described\nhere.\n\n=head2 Throwing Exceptions\n\nOne of the functionalities that L<Bio::Root::RootI> provides is the\nability to L<throw>() exceptions with pretty stack traces. Bio::Root::Root\nenhances this with the ability to use L<Error> (available from CPAN)\nif it has also been installed. \n\nIf L<Error> has been installed, L<throw>() will use it. This causes an\nError.pm-derived object to be thrown. This can be caught within a\nC<catch{}> block, from wich you can extract useful bits of\ninformation. If L<Error> is not installed, it will use the \nL<Bio::Root::RootI>-based exception throwing facilty.\n\n=head2 Typed Exception Syntax \n\nThe typed exception syntax of L<throw>() has the advantage of plainly\nindicating the nature of the trouble, since the name of the class\nis included in the title of the exception output.\n\nTo take advantage of this capability, you must specify arguments\nas named parameters in the L<throw>() call. Here are the parameters:\n\n=over 4\n\n* -class\n\nname of the class of the exception.\nThis should be one of the classes defined in L<Bio::Root::Exception>,\nor a custom error of yours that extends one of the exceptions\ndefined in L<Bio::Root::Exception>.\n\n* -text\n\na sensible message for the exception\n\n* -value\n\nthe value causing the exception or $!, if appropriate.\n\n\nNote that Bio::Root::Exception does not need to be imported into\nyour module (or script) namespace in order to throw exceptions\nvia Bio::Root::Root::throw(), since Bio::Root::Root imports it.\n\n=head2 Try-Catch-Finally Support\n\nIn addition to using an eval{} block to handle exceptions, you can\nalso use a try-catch-finally block structure if L<Error> has been\ninstalled in your system (available from CPAN).  See the documentation\nfor Error for more details.\n\nHere's an example. See the L<Bio::Root::Exception> module for \nother pre-defined exception types:\n\n   try {\n    open( IN, $file) || $obj->throw( -class => 'Bio::Root::FileOpenException',\n                                     -text => \"Cannot open file $file for reading\",\n                                     -value => $!);\n   }\n   catch Bio::Root::BadParameter with {\n       my $err = shift;   # get the Error object\n       # Perform specific exception handling code for the FileOpenException\n   }\n   catch Bio::Root::Exception with {\n       my $err = shift;   # get the Error object\n       # Perform general exception handling code for any Bioperl exception.\n   }\n   otherwise {\n       # A catch-all for any other type of exception\n   }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nFunctions originally from Steve Chervitz. \nRefactored by Ewan Birney.\nRe-refactored by Lincoln Stein.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n\nuse vars qw($DEBUG $ID $VERBOSITY $ERRORLOADED);\nuse strict;\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN { \n\n    $ID        = 'Bio::Root::Root';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n    $ERRORLOADED = 0;\n\n    # Check whether or not Error.pm is available.\n\n    # $main::DONT_USE_ERROR is intended for testing purposes and also\n    # when you don't want to use the Error module, even if it is installed.\n    # Just put a INIT { $DONT_USE_ERROR = 1; } at the top of your script.\n    if( not $main::DONT_USE_ERROR ) {\n        if ( eval \"require Error\"  ) {\n            import Error qw(:try);\n            require Bio::Root::Exception;\n            $ERRORLOADED = 1;\n            $Error::Debug = 1; # enable verbose stack trace \n        }\n    } \n    if( !$ERRORLOADED ) {\n        require Carp; import Carp qw( confess );\n    }    \n    $main::DONT_USE_ERROR;  # so that perl -w won't warn \"used only once\"\n\n}\n\n\n\n=head2 new\n\n Purpose   : generic instantiation function can be overridden if \n             special needs of a module cannot be done in _initialize\n\n\nsub new {\n#    my ($class, %param) = @_;\n    my $class = shift;\n    my $self = {};\n    bless $self, ref($class) || $class;\n\n    if(@_ > 1) {\n\t# if the number of arguments is odd but at least 3, we'll give\n\t# it a try to find -verbose\n\tshift if @_ % 2;\n\tmy %param = @_;\n\t## See \"Comments\" above regarding use of _rearrange().\n\t$self->verbose($param{'-VERBOSE'} || $param{'-verbose'});\n    }\n    return $self;\n}\n\n\n=head2 verbose\n\n Title   : verbose\n Usage   : $self->verbose(1)\n Function: Sets verbose level for how ->warn behaves\n           -1 = no warning\n            0 = standard, small warning\n            1 = warning with stack trace\n            2 = warning becomes throw\n Returns : The current verbosity setting (integer between -1 to 2)\n Args    : -1,0,1 or 2","parameters":[{"label":"$self"},{"label":"$value"}],"label":"verbose($self,$value)"},"kind":12,"line":252,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"verbose","line":253,"kind":13},{"name":"$value","containerName":"verbose","kind":13,"line":253},{"kind":13,"line":255,"name":"$DEBUG","containerName":"verbose"},{"kind":13,"line":255,"containerName":"verbose","name":"$DEBUG"},{"name":"$VERBOSITY","containerName":"verbose","kind":13,"line":256},{"name":"$self","containerName":"verbose","line":256,"kind":13},{"containerName":"verbose","name":"$value","line":258,"kind":13},{"line":258,"kind":13,"containerName":"verbose","name":"$self"},{"containerName":"verbose","name":"$self","line":259,"kind":13},{"containerName":"verbose","name":"$value","line":259,"kind":13},{"line":261,"kind":13,"name":"$self","containerName":"verbose"}],"name":"verbose","range":{"end":{"character":9999,"line":262},"start":{"character":0,"line":252}}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"","label":"_register_for_cleanup($self,$method)"},"detail":"($self,$method)","kind":12,"children":[{"kind":13,"line":265,"containerName":"_register_for_cleanup","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":265,"name":"$method","containerName":"_register_for_cleanup"},{"name":"$method","containerName":"_register_for_cleanup","line":266,"kind":13},{"containerName":"_register_for_cleanup","name":"$self","line":267,"kind":13},{"kind":13,"line":268,"name":"$self","containerName":"_register_for_cleanup"},{"containerName":"_register_for_cleanup","name":"$self","line":270,"kind":13},{"line":270,"kind":13,"name":"$method","containerName":"_register_for_cleanup"}],"line":264,"name":"_register_for_cleanup","range":{"end":{"character":9999,"line":271},"start":{"line":264,"character":0}}},{"name":"_unregister_for_cleanup","range":{"end":{"character":9999,"line":278},"start":{"character":0,"line":274}},"containerName":"main::","definition":"sub","detail":"($self,$method)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$method"}],"label":"_unregister_for_cleanup($self,$method)"},"kind":12,"line":274,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_unregister_for_cleanup","line":275,"kind":13},{"containerName":"_unregister_for_cleanup","name":"$method","kind":13,"line":275},{"kind":13,"line":276,"containerName":"_unregister_for_cleanup","definition":"my","name":"@methods","localvar":"my"},{"name":"$method","containerName":"_unregister_for_cleanup","kind":13,"line":276},{"line":276,"kind":13,"containerName":"_unregister_for_cleanup","name":"$self"},{"containerName":"_unregister_for_cleanup","name":"_cleanup_methods","kind":12,"line":276},{"kind":13,"line":277,"name":"$self","containerName":"_unregister_for_cleanup"},{"name":"@methods","containerName":"_unregister_for_cleanup","line":277,"kind":13}]},{"name":"_cleanup_methods","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":281},"end":{"character":9999,"line":287}},"kind":12,"children":[{"kind":13,"line":282,"containerName":"_cleanup_methods","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"_cleanup_methods","line":283,"kind":13},{"containerName":"_cleanup_methods","name":"$self","line":283,"kind":13},{"kind":12,"line":283,"containerName":"_cleanup_methods","name":"isa"},{"localvar":"my","containerName":"_cleanup_methods","definition":"my","name":"$methods","line":284,"kind":13},{"line":284,"kind":13,"containerName":"_cleanup_methods","name":"$self"},{"containerName":"_cleanup_methods","name":"$methods","line":285,"kind":13}],"line":281},{"kind":12,"line":329,"children":[{"containerName":"throw","definition":"my","name":"$self","localvar":"my","kind":13,"line":330},{"name":"@args","containerName":"throw","kind":13,"line":330},{"localvar":"my","containerName":"throw","definition":"my","name":"$text","line":332,"kind":13},{"line":332,"kind":13,"name":"$class","containerName":"throw"},{"containerName":"throw","name":"$value","kind":13,"line":332},{"line":332,"kind":13,"containerName":"throw","name":"$self"},{"name":"_rearrange","containerName":"throw","kind":12,"line":332},{"containerName":"throw","name":"@args","kind":13,"line":334},{"kind":13,"line":335,"containerName":"throw","name":"$text"},{"kind":13,"line":335,"containerName":"throw","name":"$args"},{"name":"@args","containerName":"throw","line":335,"kind":13},{"name":"$ERRORLOADED","containerName":"throw","line":337,"kind":13},{"containerName":"throw","name":"$args","line":346,"kind":13},{"containerName":"throw","name":"$args","line":347,"kind":13},{"kind":12,"line":347,"name":"isa","containerName":"throw"},{"localvar":"my","containerName":"throw","name":"$class","definition":"my","line":348,"kind":13},{"kind":13,"line":348,"containerName":"throw","name":"$args"},{"containerName":"throw","name":"$class","line":349,"kind":13},{"line":349,"kind":12,"name":"throw","containerName":"throw"},{"kind":13,"line":349,"name":"@args","containerName":"throw"},{"line":352,"kind":13,"localvar":"my","containerName":"throw","name":"$text","definition":"my"},{"line":352,"kind":13,"containerName":"throw","name":"$args"},{"localvar":"my","definition":"my","name":"$class","containerName":"throw","line":353,"kind":13},{"kind":13,"line":354,"name":"$class","containerName":"throw"},{"containerName":"throw","name":"throw","line":354,"kind":12},{"containerName":"throw","name":"$text","kind":13,"line":354},{"name":"$args","containerName":"throw","line":354,"kind":13},{"kind":13,"line":358,"name":"$class","containerName":"throw"},{"localvar":"my","containerName":"throw","name":"%args","definition":"my","line":360,"kind":13},{"line":361,"kind":13,"name":"@args","containerName":"throw"},{"line":361,"kind":13,"containerName":"throw","name":"$args"},{"kind":13,"line":362,"containerName":"throw","name":"%args"},{"name":"@args","containerName":"throw","kind":13,"line":362},{"containerName":"throw","name":"$args","line":363,"kind":13},{"containerName":"throw","name":"$text","kind":13,"line":363},{"containerName":"throw","name":"$args","kind":13,"line":364},{"kind":13,"line":364,"name":"$self","containerName":"throw"},{"kind":13,"line":367,"name":"$class","containerName":"throw"},{"kind":12,"line":367,"name":"throw","containerName":"throw"},{"line":367,"kind":13,"containerName":"throw","name":"%args"},{"containerName":"throw","name":"%args","kind":13,"line":367},{"kind":13,"line":367,"name":"@args","containerName":"throw"},{"kind":13,"line":371,"containerName":"throw","name":"$class"},{"kind":13,"line":372,"name":"$class","containerName":"throw"},{"line":372,"kind":13,"name":"$class","containerName":"throw"},{"line":372,"kind":13,"containerName":"throw","name":"$class"},{"kind":13,"line":373,"definition":"my","name":"$std","containerName":"throw","localvar":"my"},{"line":373,"kind":13,"containerName":"throw","name":"$self"},{"line":373,"kind":12,"name":"stack_trace_dump","containerName":"throw"},{"localvar":"my","name":"$title","definition":"my","containerName":"throw","line":374,"kind":13},{"line":375,"kind":13,"localvar":"my","containerName":"throw","definition":"my","name":"$footer"},{"name":"$title","containerName":"throw","kind":13,"line":375},{"kind":13,"line":376,"name":"$text","containerName":"throw"},{"containerName":"throw","name":"$std","kind":13,"line":378},{"line":378,"kind":13,"name":"$footer","containerName":"throw"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\npackage Bio::Root::Root;\nuse strict;\n\n# $Id: Root.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Root::Root - Hash-based implementation of Bio::Root::RootI\n\n=head1 SYNOPSIS\n\n  # Any Bioperl-compliant object is a RootI compliant object\n\n  # Here's how to throw and catch an exception using the eval-based syntax.\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Alternatively, using the new typed exception syntax in the throw() call:\n\n  $obj->throw( -class => 'Bio::Root::BadParameter',\n               -text  => \"Can not open file $file\",\n               -value  => $file );\n\n  # Want to see debug() outputs for this object\n\n  my $obj = Bio::Object->new(-verbose=>1);\n\n  my $obj = Bio::Object->new(%args);\n  $obj->verbose(2);\n\n  # Print debug messages which honour current verbosity setting\n\n  $obj->debug(\"Boring output only to be seen if verbose > 0\\n\");\n\n=head1 DESCRIPTION\n\nThis is a hashref-based implementation of the Bio::Root::RootI\ninterface.  Most Bioperl objects should inherit from this.\n\nSee the documentation for L<Bio::Root::RootI> for most of the methods\nimplemented by this module.  Only overridden methods are described\nhere.\n\n=head2 Throwing Exceptions\n\nOne of the functionalities that L<Bio::Root::RootI> provides is the\nability to L<throw>() exceptions with pretty stack traces. Bio::Root::Root\nenhances this with the ability to use L<Error> (available from CPAN)\nif it has also been installed. \n\nIf L<Error> has been installed, L<throw>() will use it. This causes an\nError.pm-derived object to be thrown. This can be caught within a\nC<catch{}> block, from wich you can extract useful bits of\ninformation. If L<Error> is not installed, it will use the \nL<Bio::Root::RootI>-based exception throwing facilty.\n\n=head2 Typed Exception Syntax \n\nThe typed exception syntax of L<throw>() has the advantage of plainly\nindicating the nature of the trouble, since the name of the class\nis included in the title of the exception output.\n\nTo take advantage of this capability, you must specify arguments\nas named parameters in the L<throw>() call. Here are the parameters:\n\n=over 4\n\n* -class\n\nname of the class of the exception.\nThis should be one of the classes defined in L<Bio::Root::Exception>,\nor a custom error of yours that extends one of the exceptions\ndefined in L<Bio::Root::Exception>.\n\n* -text\n\na sensible message for the exception\n\n* -value\n\nthe value causing the exception or $!, if appropriate.\n\n\nNote that Bio::Root::Exception does not need to be imported into\nyour module (or script) namespace in order to throw exceptions\nvia Bio::Root::Root::throw(), since Bio::Root::Root imports it.\n\n=head2 Try-Catch-Finally Support\n\nIn addition to using an eval{} block to handle exceptions, you can\nalso use a try-catch-finally block structure if L<Error> has been\ninstalled in your system (available from CPAN).  See the documentation\nfor Error for more details.\n\nHere's an example. See the L<Bio::Root::Exception> module for \nother pre-defined exception types:\n\n   try {\n    open( IN, $file) || $obj->throw( -class => 'Bio::Root::FileOpenException',\n                                     -text => \"Cannot open file $file for reading\",\n                                     -value => $!);\n   }\n   catch Bio::Root::BadParameter with {\n       my $err = shift;   # get the Error object\n       # Perform specific exception handling code for the FileOpenException\n   }\n   catch Bio::Root::Exception with {\n       my $err = shift;   # get the Error object\n       # Perform general exception handling code for any Bioperl exception.\n   }\n   otherwise {\n       # A catch-all for any other type of exception\n   }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nFunctions originally from Steve Chervitz. \nRefactored by Ewan Birney.\nRe-refactored by Lincoln Stein.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n\nuse vars qw($DEBUG $ID $VERBOSITY $ERRORLOADED);\nuse strict;\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN { \n\n    $ID        = 'Bio::Root::Root';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n    $ERRORLOADED = 0;\n\n    # Check whether or not Error.pm is available.\n\n    # $main::DONT_USE_ERROR is intended for testing purposes and also\n    # when you don't want to use the Error module, even if it is installed.\n    # Just put a INIT { $DONT_USE_ERROR = 1; } at the top of your script.\n    if( not $main::DONT_USE_ERROR ) {\n        if ( eval \"require Error\"  ) {\n            import Error qw(:try);\n            require Bio::Root::Exception;\n            $ERRORLOADED = 1;\n            $Error::Debug = 1; # enable verbose stack trace \n        }\n    } \n    if( !$ERRORLOADED ) {\n        require Carp; import Carp qw( confess );\n    }    \n    $main::DONT_USE_ERROR;  # so that perl -w won't warn \"used only once\"\n\n}\n\n\n\n=head2 new\n\n Purpose   : generic instantiation function can be overridden if \n             special needs of a module cannot be done in _initialize\n\n\nsub new {\n#    my ($class, %param) = @_;\n    my $class = shift;\n    my $self = {};\n    bless $self, ref($class) || $class;\n\n    if(@_ > 1) {\n\t# if the number of arguments is odd but at least 3, we'll give\n\t# it a try to find -verbose\n\tshift if @_ % 2;\n\tmy %param = @_;\n\t## See \"Comments\" above regarding use of _rearrange().\n\t$self->verbose($param{'-VERBOSE'} || $param{'-verbose'});\n    }\n    return $self;\n}\n\n\n=head2 verbose\n\n Title   : verbose\n Usage   : $self->verbose(1)\n Function: Sets verbose level for how ->warn behaves\n           -1 = no warning\n            0 = standard, small warning\n            1 = warning with stack trace\n            2 = warning becomes throw\n Returns : The current verbosity setting (integer between -1 to 2)\n Args    : -1,0,1 or 2\n\n\n\nsub verbose {\n   my ($self,$value) = @_;\n   # allow one to set global verbosity flag\n   return $DEBUG  if $DEBUG;\n   return $VERBOSITY unless ref $self;\n   \n    if (defined $value || ! defined $self->{'_root_verbose'}) {\n       $self->{'_root_verbose'} = $value || 0;\n    }\n    return $self->{'_root_verbose'};\n}\n\nsub _register_for_cleanup {\n  my ($self,$method) = @_;\n  if($method) {\n    if(! exists($self->{'_root_cleanup_methods'})) {\n      $self->{'_root_cleanup_methods'} = [];\n    }\n    push(@{$self->{'_root_cleanup_methods'}},$method);\n  }\n}\n\nsub _unregister_for_cleanup {\n  my ($self,$method) = @_;\n  my @methods = grep {$_ ne $method} $self->_cleanup_methods;\n  $self->{'_root_cleanup_methods'} = \\@methods;\n}\n\n\nsub _cleanup_methods {\n  my $self = shift;\n  return unless ref $self && $self->isa('HASH');\n  my $methods = $self->{'_root_cleanup_methods'} or return;\n  @$methods;\n\n}\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\");\n           or\n           $obj->throw( -class => 'Bio::Root::Exception',\n                        -text  => \"throwing exception message\",\n                        -value => $bad_value  );\n Function: Throws an exception, which, if not caught with an eval or\n           a try block will provide a nice stack trace to STDERR \n           with the message.\n           If Error.pm is installed, and if a -class parameter is\n           provided, Error::throw will be used, throwing an error \n           of the type specified by -class.\n           If Error.pm is installed and no -class parameter is provided\n           (i.e., a simple string is given), A Bio::Root::Exception \n           is thrown.\n Returns : n/a\n Args    : A string giving a descriptive error message, optional\n           Named parameters:\n           '-class'  a string for the name of a class that derives \n                     from Error.pm, such as any of the exceptions \n                     defined in Bio::Root::Exception.\n                     Default class: Bio::Root::Exception\n           '-text'   a string giving a descriptive error message\n           '-value'  the value causing the exception, or $! (optional)\n\n           Thus, if only a string argument is given, and Error.pm is available,\n           this is equivalent to the arguments:\n                 -text  => \"message\",\n                 -class => Bio::Root::Exception\n Comments : If Error.pm is installed, and you don't want to use it\n            for some reason, you can block the use of Error.pm by\n            Bio::Root::Root::throw() by defining a scalar named\n            $main::DONT_USE_ERROR (define it in your main script\n            and you don't need the main:: part) and setting it to \n            a true value; you must do this within a BEGIN subroutine.","label":"throw($self,@args)"},"name":"throw","range":{"end":{"line":380,"character":9999},"start":{"line":329,"character":0}}},{"containerName":"length","name":"CORE","kind":12,"line":375},{"range":{"start":{"character":0,"line":392},"end":{"line":405,"character":9999}},"name":"debug","children":[{"localvar":"my","containerName":"debug","definition":"my","name":"$self","line":393,"kind":13},{"kind":13,"line":393,"containerName":"debug","name":"@msgs"},{"kind":13,"line":399,"containerName":"debug","name":"$self"},{"kind":12,"line":399,"containerName":"debug","name":"verbose"},{"containerName":"debug","name":"$self","kind":13,"line":399},{"line":399,"kind":12,"name":"verbose","containerName":"debug"},{"containerName":"debug","name":"@msgs","kind":13,"line":400},{"containerName":"debug","name":"$msgs","kind":13,"line":400},{"name":"@msgs","containerName":"debug","line":401,"kind":13},{"containerName":"debug","name":"@msgs","kind":13,"line":401},{"kind":13,"line":402,"name":"@msgs","containerName":"debug"},{"containerName":"debug","name":"$self","kind":13,"line":402},{"kind":12,"line":402,"containerName":"debug","name":"stack_trace"},{"containerName":"debug","name":"@msgs","line":404,"kind":13}],"line":392,"kind":12,"signature":{"label":"debug($self,@msgs)","parameters":[{"label":"$self"},{"label":"@msgs"}],"documentation":"1;\npackage Bio::Root::Root;\nuse strict;\n\n# $Id: Root.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Root::Root - Hash-based implementation of Bio::Root::RootI\n\n=head1 SYNOPSIS\n\n  # Any Bioperl-compliant object is a RootI compliant object\n\n  # Here's how to throw and catch an exception using the eval-based syntax.\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Alternatively, using the new typed exception syntax in the throw() call:\n\n  $obj->throw( -class => 'Bio::Root::BadParameter',\n               -text  => \"Can not open file $file\",\n               -value  => $file );\n\n  # Want to see debug() outputs for this object\n\n  my $obj = Bio::Object->new(-verbose=>1);\n\n  my $obj = Bio::Object->new(%args);\n  $obj->verbose(2);\n\n  # Print debug messages which honour current verbosity setting\n\n  $obj->debug(\"Boring output only to be seen if verbose > 0\\n\");\n\n=head1 DESCRIPTION\n\nThis is a hashref-based implementation of the Bio::Root::RootI\ninterface.  Most Bioperl objects should inherit from this.\n\nSee the documentation for L<Bio::Root::RootI> for most of the methods\nimplemented by this module.  Only overridden methods are described\nhere.\n\n=head2 Throwing Exceptions\n\nOne of the functionalities that L<Bio::Root::RootI> provides is the\nability to L<throw>() exceptions with pretty stack traces. Bio::Root::Root\nenhances this with the ability to use L<Error> (available from CPAN)\nif it has also been installed. \n\nIf L<Error> has been installed, L<throw>() will use it. This causes an\nError.pm-derived object to be thrown. This can be caught within a\nC<catch{}> block, from wich you can extract useful bits of\ninformation. If L<Error> is not installed, it will use the \nL<Bio::Root::RootI>-based exception throwing facilty.\n\n=head2 Typed Exception Syntax \n\nThe typed exception syntax of L<throw>() has the advantage of plainly\nindicating the nature of the trouble, since the name of the class\nis included in the title of the exception output.\n\nTo take advantage of this capability, you must specify arguments\nas named parameters in the L<throw>() call. Here are the parameters:\n\n=over 4\n\n* -class\n\nname of the class of the exception.\nThis should be one of the classes defined in L<Bio::Root::Exception>,\nor a custom error of yours that extends one of the exceptions\ndefined in L<Bio::Root::Exception>.\n\n* -text\n\na sensible message for the exception\n\n* -value\n\nthe value causing the exception or $!, if appropriate.\n\n\nNote that Bio::Root::Exception does not need to be imported into\nyour module (or script) namespace in order to throw exceptions\nvia Bio::Root::Root::throw(), since Bio::Root::Root imports it.\n\n=head2 Try-Catch-Finally Support\n\nIn addition to using an eval{} block to handle exceptions, you can\nalso use a try-catch-finally block structure if L<Error> has been\ninstalled in your system (available from CPAN).  See the documentation\nfor Error for more details.\n\nHere's an example. See the L<Bio::Root::Exception> module for \nother pre-defined exception types:\n\n   try {\n    open( IN, $file) || $obj->throw( -class => 'Bio::Root::FileOpenException',\n                                     -text => \"Cannot open file $file for reading\",\n                                     -value => $!);\n   }\n   catch Bio::Root::BadParameter with {\n       my $err = shift;   # get the Error object\n       # Perform specific exception handling code for the FileOpenException\n   }\n   catch Bio::Root::Exception with {\n       my $err = shift;   # get the Error object\n       # Perform general exception handling code for any Bioperl exception.\n   }\n   otherwise {\n       # A catch-all for any other type of exception\n   }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nFunctions originally from Steve Chervitz. \nRefactored by Ewan Birney.\nRe-refactored by Lincoln Stein.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n\nuse vars qw($DEBUG $ID $VERBOSITY $ERRORLOADED);\nuse strict;\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN { \n\n    $ID        = 'Bio::Root::Root';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n    $ERRORLOADED = 0;\n\n    # Check whether or not Error.pm is available.\n\n    # $main::DONT_USE_ERROR is intended for testing purposes and also\n    # when you don't want to use the Error module, even if it is installed.\n    # Just put a INIT { $DONT_USE_ERROR = 1; } at the top of your script.\n    if( not $main::DONT_USE_ERROR ) {\n        if ( eval \"require Error\"  ) {\n            import Error qw(:try);\n            require Bio::Root::Exception;\n            $ERRORLOADED = 1;\n            $Error::Debug = 1; # enable verbose stack trace \n        }\n    } \n    if( !$ERRORLOADED ) {\n        require Carp; import Carp qw( confess );\n    }    \n    $main::DONT_USE_ERROR;  # so that perl -w won't warn \"used only once\"\n\n}\n\n\n\n=head2 new\n\n Purpose   : generic instantiation function can be overridden if \n             special needs of a module cannot be done in _initialize\n\n\nsub new {\n#    my ($class, %param) = @_;\n    my $class = shift;\n    my $self = {};\n    bless $self, ref($class) || $class;\n\n    if(@_ > 1) {\n\t# if the number of arguments is odd but at least 3, we'll give\n\t# it a try to find -verbose\n\tshift if @_ % 2;\n\tmy %param = @_;\n\t## See \"Comments\" above regarding use of _rearrange().\n\t$self->verbose($param{'-VERBOSE'} || $param{'-verbose'});\n    }\n    return $self;\n}\n\n\n=head2 verbose\n\n Title   : verbose\n Usage   : $self->verbose(1)\n Function: Sets verbose level for how ->warn behaves\n           -1 = no warning\n            0 = standard, small warning\n            1 = warning with stack trace\n            2 = warning becomes throw\n Returns : The current verbosity setting (integer between -1 to 2)\n Args    : -1,0,1 or 2\n\n\n\nsub verbose {\n   my ($self,$value) = @_;\n   # allow one to set global verbosity flag\n   return $DEBUG  if $DEBUG;\n   return $VERBOSITY unless ref $self;\n   \n    if (defined $value || ! defined $self->{'_root_verbose'}) {\n       $self->{'_root_verbose'} = $value || 0;\n    }\n    return $self->{'_root_verbose'};\n}\n\nsub _register_for_cleanup {\n  my ($self,$method) = @_;\n  if($method) {\n    if(! exists($self->{'_root_cleanup_methods'})) {\n      $self->{'_root_cleanup_methods'} = [];\n    }\n    push(@{$self->{'_root_cleanup_methods'}},$method);\n  }\n}\n\nsub _unregister_for_cleanup {\n  my ($self,$method) = @_;\n  my @methods = grep {$_ ne $method} $self->_cleanup_methods;\n  $self->{'_root_cleanup_methods'} = \\@methods;\n}\n\n\nsub _cleanup_methods {\n  my $self = shift;\n  return unless ref $self && $self->isa('HASH');\n  my $methods = $self->{'_root_cleanup_methods'} or return;\n  @$methods;\n\n}\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\");\n           or\n           $obj->throw( -class => 'Bio::Root::Exception',\n                        -text  => \"throwing exception message\",\n                        -value => $bad_value  );\n Function: Throws an exception, which, if not caught with an eval or\n           a try block will provide a nice stack trace to STDERR \n           with the message.\n           If Error.pm is installed, and if a -class parameter is\n           provided, Error::throw will be used, throwing an error \n           of the type specified by -class.\n           If Error.pm is installed and no -class parameter is provided\n           (i.e., a simple string is given), A Bio::Root::Exception \n           is thrown.\n Returns : n/a\n Args    : A string giving a descriptive error message, optional\n           Named parameters:\n           '-class'  a string for the name of a class that derives \n                     from Error.pm, such as any of the exceptions \n                     defined in Bio::Root::Exception.\n                     Default class: Bio::Root::Exception\n           '-text'   a string giving a descriptive error message\n           '-value'  the value causing the exception, or $! (optional)\n\n           Thus, if only a string argument is given, and Error.pm is available,\n           this is equivalent to the arguments:\n                 -text  => \"message\",\n                 -class => Bio::Root::Exception\n Comments : If Error.pm is installed, and you don't want to use it\n            for some reason, you can block the use of Error.pm by\n            Bio::Root::Root::throw() by defining a scalar named\n            $main::DONT_USE_ERROR (define it in your main script\n            and you don't need the main:: part) and setting it to \n            a true value; you must do this within a BEGIN subroutine.\n\n\nsub throw {\n    my ($self, @args) = @_;\n    \n    my ($text, $class, $value) = $self->_rearrange( [qw(TEXT\n                                                        CLASS\n                                                        VALUE)], @args);\n    $text ||= $args[0] if @args == 1;\n    \n    if ($ERRORLOADED) {\n        # Enable re-throwing of Error objects.\n        # If the error is not derived from Bio::Root::Exception, \n        # we can't guarantee that the Error's value was set properly\n        # and, ipso facto, that it will be catchable from an eval{}.\n        # But chances are, if you're re-throwing non-Bio::Root::Exceptions,\n        # you're probably using Error::try(), not eval{}.\n        # TODO: Fix the MSG: line of the re-thrown error. Has an extra line\n        # containing the '----- EXCEPTION -----' banner.\n        if (ref($args[0])) {\n            if( $args[0]->isa('Error')) {\n                my $class = ref $args[0];\n                $class->throw( @args );\n            }\n            else {\n                my $text .= \"\\nWARNING: Attempt to throw a non-Error.pm object: \" . ref$args[0];\n                my $class = \"Bio::Root::Exception\";\n                $class->throw( '-text' => $text, '-value' => $args[0] ); \n            }\n        }\n        else {\n            $class ||= \"Bio::Root::Exception\";\n            \n            my %args;\n            if( @args % 2 == 0 && $args[0] =~ /^-/ ) {\n                %args = @args;\n                $args{-text} = $text;\n                $args{-object} = $self;\n            }\n            \n            $class->throw( scalar keys %args > 0 ? %args : @args ); # (%args || @args) puts %args in scalar context!\n        }\n    }\n    else {\n        $class ||= '';\n        $class = ' '.$class if $class;\n        my $std = $self->stack_trace_dump();\n        my $title = \"------------- EXCEPTION$class -------------\";\n        my $footer = ('-' x CORE::length($title)).\"\\n\";\n        $text ||= '';\n        \n        die \"\\n$title\\n\", \"MSG: $text\\n\", $std, $footer, \"\\n\";\n    }\n}\n\n=head2 debug\n\n Title   : debug\n Usage   : $obj->debug(\"This is debugging output\");\n Function: Prints a debugging message when verbose is > 0\n Returns : none\n Args    : message string(s) to print to STDERR"},"detail":"($self,@msgs)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":419,"character":0},"end":{"character":9999,"line":444}},"name":"_load_module","line":419,"children":[{"line":420,"kind":13,"localvar":"my","containerName":"_load_module","name":"$self","definition":"my"},{"line":420,"kind":13,"name":"$name","containerName":"_load_module"},{"localvar":"my","definition":"my","name":"$module","containerName":"_load_module","line":421,"kind":13},{"line":421,"kind":13,"name":"$load","containerName":"_load_module"},{"containerName":"_load_module","name":"$m","kind":13,"line":421},{"kind":13,"line":422,"name":"$module","containerName":"_load_module"},{"name":"$main","containerName":"_load_module","line":423,"kind":13},{"line":423,"kind":13,"name":"$module","containerName":"_load_module"},{"containerName":"_load_module","name":"$name","line":427,"kind":13},{"kind":13,"line":428,"containerName":"_load_module","name":"$self"},{"name":"throw","containerName":"_load_module","line":428,"kind":12},{"name":"$name","containerName":"_load_module","kind":13,"line":430},{"line":433,"kind":13,"containerName":"_load_module","name":"$load"},{"line":434,"kind":13,"localvar":"my","containerName":"_load_module","definition":"my","name":"$io"},{"name":"new","containerName":"_load_module","line":434,"kind":12},{"containerName":"_load_module","name":"$load","kind":13,"line":436},{"containerName":"_load_module","name":"$io","line":436,"kind":13},{"kind":12,"line":436,"name":"catfile","containerName":"_load_module"},{"line":436,"kind":13,"containerName":"_load_module","name":"$load"},{"containerName":"_load_module","name":"$load","line":438,"kind":13},{"line":441,"kind":13,"containerName":"_load_module","name":"$self"},{"kind":12,"line":441,"containerName":"_load_module","name":"throw"}],"kind":12,"detail":"($self,$name)","signature":{"documentation":"1;\npackage Bio::Root::Root;\nuse strict;\n\n# $Id: Root.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Root::Root - Hash-based implementation of Bio::Root::RootI\n\n=head1 SYNOPSIS\n\n  # Any Bioperl-compliant object is a RootI compliant object\n\n  # Here's how to throw and catch an exception using the eval-based syntax.\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Alternatively, using the new typed exception syntax in the throw() call:\n\n  $obj->throw( -class => 'Bio::Root::BadParameter',\n               -text  => \"Can not open file $file\",\n               -value  => $file );\n\n  # Want to see debug() outputs for this object\n\n  my $obj = Bio::Object->new(-verbose=>1);\n\n  my $obj = Bio::Object->new(%args);\n  $obj->verbose(2);\n\n  # Print debug messages which honour current verbosity setting\n\n  $obj->debug(\"Boring output only to be seen if verbose > 0\\n\");\n\n=head1 DESCRIPTION\n\nThis is a hashref-based implementation of the Bio::Root::RootI\ninterface.  Most Bioperl objects should inherit from this.\n\nSee the documentation for L<Bio::Root::RootI> for most of the methods\nimplemented by this module.  Only overridden methods are described\nhere.\n\n=head2 Throwing Exceptions\n\nOne of the functionalities that L<Bio::Root::RootI> provides is the\nability to L<throw>() exceptions with pretty stack traces. Bio::Root::Root\nenhances this with the ability to use L<Error> (available from CPAN)\nif it has also been installed. \n\nIf L<Error> has been installed, L<throw>() will use it. This causes an\nError.pm-derived object to be thrown. This can be caught within a\nC<catch{}> block, from wich you can extract useful bits of\ninformation. If L<Error> is not installed, it will use the \nL<Bio::Root::RootI>-based exception throwing facilty.\n\n=head2 Typed Exception Syntax \n\nThe typed exception syntax of L<throw>() has the advantage of plainly\nindicating the nature of the trouble, since the name of the class\nis included in the title of the exception output.\n\nTo take advantage of this capability, you must specify arguments\nas named parameters in the L<throw>() call. Here are the parameters:\n\n=over 4\n\n* -class\n\nname of the class of the exception.\nThis should be one of the classes defined in L<Bio::Root::Exception>,\nor a custom error of yours that extends one of the exceptions\ndefined in L<Bio::Root::Exception>.\n\n* -text\n\na sensible message for the exception\n\n* -value\n\nthe value causing the exception or $!, if appropriate.\n\n\nNote that Bio::Root::Exception does not need to be imported into\nyour module (or script) namespace in order to throw exceptions\nvia Bio::Root::Root::throw(), since Bio::Root::Root imports it.\n\n=head2 Try-Catch-Finally Support\n\nIn addition to using an eval{} block to handle exceptions, you can\nalso use a try-catch-finally block structure if L<Error> has been\ninstalled in your system (available from CPAN).  See the documentation\nfor Error for more details.\n\nHere's an example. See the L<Bio::Root::Exception> module for \nother pre-defined exception types:\n\n   try {\n    open( IN, $file) || $obj->throw( -class => 'Bio::Root::FileOpenException',\n                                     -text => \"Cannot open file $file for reading\",\n                                     -value => $!);\n   }\n   catch Bio::Root::BadParameter with {\n       my $err = shift;   # get the Error object\n       # Perform specific exception handling code for the FileOpenException\n   }\n   catch Bio::Root::Exception with {\n       my $err = shift;   # get the Error object\n       # Perform general exception handling code for any Bioperl exception.\n   }\n   otherwise {\n       # A catch-all for any other type of exception\n   }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nFunctions originally from Steve Chervitz. \nRefactored by Ewan Birney.\nRe-refactored by Lincoln Stein.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n\nuse vars qw($DEBUG $ID $VERBOSITY $ERRORLOADED);\nuse strict;\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN { \n\n    $ID        = 'Bio::Root::Root';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n    $ERRORLOADED = 0;\n\n    # Check whether or not Error.pm is available.\n\n    # $main::DONT_USE_ERROR is intended for testing purposes and also\n    # when you don't want to use the Error module, even if it is installed.\n    # Just put a INIT { $DONT_USE_ERROR = 1; } at the top of your script.\n    if( not $main::DONT_USE_ERROR ) {\n        if ( eval \"require Error\"  ) {\n            import Error qw(:try);\n            require Bio::Root::Exception;\n            $ERRORLOADED = 1;\n            $Error::Debug = 1; # enable verbose stack trace \n        }\n    } \n    if( !$ERRORLOADED ) {\n        require Carp; import Carp qw( confess );\n    }    \n    $main::DONT_USE_ERROR;  # so that perl -w won't warn \"used only once\"\n\n}\n\n\n\n=head2 new\n\n Purpose   : generic instantiation function can be overridden if \n             special needs of a module cannot be done in _initialize\n\n\nsub new {\n#    my ($class, %param) = @_;\n    my $class = shift;\n    my $self = {};\n    bless $self, ref($class) || $class;\n\n    if(@_ > 1) {\n\t# if the number of arguments is odd but at least 3, we'll give\n\t# it a try to find -verbose\n\tshift if @_ % 2;\n\tmy %param = @_;\n\t## See \"Comments\" above regarding use of _rearrange().\n\t$self->verbose($param{'-VERBOSE'} || $param{'-verbose'});\n    }\n    return $self;\n}\n\n\n=head2 verbose\n\n Title   : verbose\n Usage   : $self->verbose(1)\n Function: Sets verbose level for how ->warn behaves\n           -1 = no warning\n            0 = standard, small warning\n            1 = warning with stack trace\n            2 = warning becomes throw\n Returns : The current verbosity setting (integer between -1 to 2)\n Args    : -1,0,1 or 2\n\n\n\nsub verbose {\n   my ($self,$value) = @_;\n   # allow one to set global verbosity flag\n   return $DEBUG  if $DEBUG;\n   return $VERBOSITY unless ref $self;\n   \n    if (defined $value || ! defined $self->{'_root_verbose'}) {\n       $self->{'_root_verbose'} = $value || 0;\n    }\n    return $self->{'_root_verbose'};\n}\n\nsub _register_for_cleanup {\n  my ($self,$method) = @_;\n  if($method) {\n    if(! exists($self->{'_root_cleanup_methods'})) {\n      $self->{'_root_cleanup_methods'} = [];\n    }\n    push(@{$self->{'_root_cleanup_methods'}},$method);\n  }\n}\n\nsub _unregister_for_cleanup {\n  my ($self,$method) = @_;\n  my @methods = grep {$_ ne $method} $self->_cleanup_methods;\n  $self->{'_root_cleanup_methods'} = \\@methods;\n}\n\n\nsub _cleanup_methods {\n  my $self = shift;\n  return unless ref $self && $self->isa('HASH');\n  my $methods = $self->{'_root_cleanup_methods'} or return;\n  @$methods;\n\n}\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\");\n           or\n           $obj->throw( -class => 'Bio::Root::Exception',\n                        -text  => \"throwing exception message\",\n                        -value => $bad_value  );\n Function: Throws an exception, which, if not caught with an eval or\n           a try block will provide a nice stack trace to STDERR \n           with the message.\n           If Error.pm is installed, and if a -class parameter is\n           provided, Error::throw will be used, throwing an error \n           of the type specified by -class.\n           If Error.pm is installed and no -class parameter is provided\n           (i.e., a simple string is given), A Bio::Root::Exception \n           is thrown.\n Returns : n/a\n Args    : A string giving a descriptive error message, optional\n           Named parameters:\n           '-class'  a string for the name of a class that derives \n                     from Error.pm, such as any of the exceptions \n                     defined in Bio::Root::Exception.\n                     Default class: Bio::Root::Exception\n           '-text'   a string giving a descriptive error message\n           '-value'  the value causing the exception, or $! (optional)\n\n           Thus, if only a string argument is given, and Error.pm is available,\n           this is equivalent to the arguments:\n                 -text  => \"message\",\n                 -class => Bio::Root::Exception\n Comments : If Error.pm is installed, and you don't want to use it\n            for some reason, you can block the use of Error.pm by\n            Bio::Root::Root::throw() by defining a scalar named\n            $main::DONT_USE_ERROR (define it in your main script\n            and you don't need the main:: part) and setting it to \n            a true value; you must do this within a BEGIN subroutine.\n\n\nsub throw {\n    my ($self, @args) = @_;\n    \n    my ($text, $class, $value) = $self->_rearrange( [qw(TEXT\n                                                        CLASS\n                                                        VALUE)], @args);\n    $text ||= $args[0] if @args == 1;\n    \n    if ($ERRORLOADED) {\n        # Enable re-throwing of Error objects.\n        # If the error is not derived from Bio::Root::Exception, \n        # we can't guarantee that the Error's value was set properly\n        # and, ipso facto, that it will be catchable from an eval{}.\n        # But chances are, if you're re-throwing non-Bio::Root::Exceptions,\n        # you're probably using Error::try(), not eval{}.\n        # TODO: Fix the MSG: line of the re-thrown error. Has an extra line\n        # containing the '----- EXCEPTION -----' banner.\n        if (ref($args[0])) {\n            if( $args[0]->isa('Error')) {\n                my $class = ref $args[0];\n                $class->throw( @args );\n            }\n            else {\n                my $text .= \"\\nWARNING: Attempt to throw a non-Error.pm object: \" . ref$args[0];\n                my $class = \"Bio::Root::Exception\";\n                $class->throw( '-text' => $text, '-value' => $args[0] ); \n            }\n        }\n        else {\n            $class ||= \"Bio::Root::Exception\";\n            \n            my %args;\n            if( @args % 2 == 0 && $args[0] =~ /^-/ ) {\n                %args = @args;\n                $args{-text} = $text;\n                $args{-object} = $self;\n            }\n            \n            $class->throw( scalar keys %args > 0 ? %args : @args ); # (%args || @args) puts %args in scalar context!\n        }\n    }\n    else {\n        $class ||= '';\n        $class = ' '.$class if $class;\n        my $std = $self->stack_trace_dump();\n        my $title = \"------------- EXCEPTION$class -------------\";\n        my $footer = ('-' x CORE::length($title)).\"\\n\";\n        $text ||= '';\n        \n        die \"\\n$title\\n\", \"MSG: $text\\n\", $std, $footer, \"\\n\";\n    }\n}\n\n=head2 debug\n\n Title   : debug\n Usage   : $obj->debug(\"This is debugging output\");\n Function: Prints a debugging message when verbose is > 0\n Returns : none\n Args    : message string(s) to print to STDERR\n\n\nsub debug {\n    my ($self, @msgs) = @_;\n    \n\t# using CORE::warn doesn't give correct backtrace information; we want the\n\t# line from the previous call in the call stack, not this call (similar to\n\t# cluck).  For now, just add a stack trace dump and simple comment under the\n\t# correct conditions.\n    if (defined $self->verbose && $self->verbose > 0) {\n\t\tif (!@msgs || $msgs[-1] !~ /\\n$/) {\n\t\t\tpush @msgs, \"Debugging comment:\" if !@msgs;\n\t\t\tpush @msgs, sprintf(\"%s %s:%s\", @{($self->stack_trace)[2]}[3,1,2]).\"\\n\";\n\t\t}\n        CORE::warn @msgs;\n    }\n}\n\n=head2 _load_module\n\n Title   : _load_module\n Usage   : $self->_load_module(\"Bio::SeqIO::genbank\");\n Function: Loads up (like use) the specified module at run time on demand.\n Example : \n Returns : TRUE on success. Throws an exception upon failure.\n Args    : The module to load (_without_ the trailing .pm).","parameters":[{"label":"$self"},{"label":"$name"}],"label":"_load_module($self,$name)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":420,"name":"CORE","containerName":"warn"},{"kind":12,"line":434,"name":"Bio","containerName":"Root::IO"},{"children":[{"line":447,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","definition":"my"},{"containerName":"DESTROY","definition":"my","name":"@cleanup_methods","localvar":"my","kind":13,"line":448},{"name":"$self","containerName":"DESTROY","line":448,"kind":13},{"kind":12,"line":448,"name":"_cleanup_methods","containerName":"DESTROY"},{"line":449,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$method","definition":"my"},{"line":449,"kind":13,"containerName":"DESTROY","name":"@cleanup_methods"},{"line":450,"kind":13,"containerName":"DESTROY","name":"$method"},{"containerName":"DESTROY","name":"$self","kind":13,"line":450}],"line":446,"kind":12,"range":{"start":{"line":446,"character":0},"end":{"character":9999,"line":452}},"definition":"sub","name":"DESTROY","containerName":"main::"}],"version":5}