{"version":5,"vars":[{"name":"base","containerName":"","line":108,"kind":2},{"line":144,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":145},{"containerName":"new","name":"@args","line":145,"kind":13},{"line":147,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":147},{"kind":13,"line":147,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$number","containerName":"new","line":148,"kind":13},{"containerName":"new","name":"$newhits_unclassified","kind":13,"line":148},{"name":"$newhits_below","containerName":"new","line":148,"kind":13},{"kind":13,"line":148,"containerName":"new","name":"$newhits_not_below"},{"kind":13,"line":149,"name":"$oldhits_below","containerName":"new"},{"containerName":"new","name":"$oldhits_newly_below","kind":13,"line":149},{"kind":13,"line":149,"name":"$oldhits_not_below","containerName":"new"},{"line":149,"kind":13,"containerName":"new","name":"$converged"},{"containerName":"new","name":"$h_f","kind":13,"line":150},{"kind":13,"line":151,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":151},{"line":160,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$number","line":162,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":163},{"containerName":"new","name":"throw","kind":12,"line":163},{"kind":13,"line":166,"containerName":"new","name":"$self"},{"name":"number","containerName":"new","kind":12,"line":166},{"name":"$number","containerName":"new","kind":13,"line":166},{"line":169,"kind":13,"containerName":"new","name":"$converged"},{"kind":13,"line":169,"name":"$self","containerName":"new"},{"kind":12,"line":169,"containerName":"new","name":"converged"},{"containerName":"new","name":"$converged","line":169,"kind":13},{"line":176,"kind":13,"name":"$newhits_unclassified","containerName":"new"},{"kind":13,"line":177,"name":"$newhits_unclassified","containerName":"new"},{"line":178,"kind":13,"containerName":"new","name":"$self"},{"line":178,"kind":13,"name":"$newhits_unclassified","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects","label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"line":144,"character":0},"end":{"line":179,"character":9999}},"name":"new"},{"kind":12,"line":147,"containerName":"new","name":"SUPER"},{"line":180,"kind":13,"containerName":null,"name":"$self"},{"line":180,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"name":"%self","kind":13,"line":184},{"kind":13,"line":187,"name":"%newhits_below","containerName":null},{"name":"%newhits_below","containerName":null,"line":188,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":189},{"containerName":null,"name":"%newhits_below","kind":13,"line":189},{"name":"$self","containerName":null,"line":191,"kind":13},{"line":191,"kind":12,"containerName":"main::","name":"throw"},{"kind":13,"line":195,"name":"%self","containerName":null},{"line":198,"kind":13,"name":"%newhits_not_below","containerName":null},{"kind":13,"line":199,"containerName":null,"name":"%newhits_not_below"},{"name":"%self","containerName":null,"kind":13,"line":200},{"line":200,"kind":13,"containerName":null,"name":"%newhits_not_below"},{"containerName":null,"name":"$self","line":202,"kind":13},{"name":"throw","containerName":"main::","line":202,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":206},{"name":"%oldhits_below","containerName":null,"kind":13,"line":209},{"line":210,"kind":13,"containerName":null,"name":"%oldhits_below"},{"containerName":null,"name":"%self","kind":13,"line":211},{"line":211,"kind":13,"containerName":null,"name":"%oldhits_below"},{"containerName":null,"name":"$self","line":213,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":213},{"line":217,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%oldhits_newly_below","line":220,"kind":13},{"line":221,"kind":13,"name":"%oldhits_newly_below","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":222},{"kind":13,"line":222,"name":"%oldhits_newly_below","containerName":null},{"name":"$self","containerName":null,"line":224,"kind":13},{"containerName":"main::","name":"throw","line":224,"kind":12},{"line":228,"kind":13,"name":"%self","containerName":null},{"name":"%oldhits_not_below","containerName":null,"kind":13,"line":231},{"containerName":null,"name":"%oldhits_not_below","kind":13,"line":232},{"containerName":null,"name":"%self","kind":13,"line":233},{"name":"%oldhits_not_below","containerName":null,"line":233,"kind":13},{"name":"$self","containerName":null,"line":235,"kind":13},{"containerName":"main::","name":"throw","line":235,"kind":12},{"line":239,"kind":13,"containerName":null,"name":"%self"},{"line":242,"kind":13,"name":"$self","containerName":null},{"line":242,"kind":12,"name":"hit_factory","containerName":"main::"},{"name":"$h_f","containerName":null,"line":242,"kind":13},{"containerName":null,"name":"$h_f","kind":13,"line":242},{"name":"$self","containerName":null,"line":244,"kind":13},{"signature":{"label":"number($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":255,"name":"$self","definition":"my","containerName":"number","localvar":"my"},{"line":255,"kind":13,"containerName":"number","name":"$value"},{"localvar":"my","containerName":"number","name":"$previous","definition":"my","line":256,"kind":13},{"containerName":"number","name":"$self","line":256,"kind":13},{"kind":13,"line":257,"containerName":"number","name":"$value"},{"name":"$previous","containerName":"number","line":257,"kind":13},{"kind":13,"line":258,"containerName":"number","name":"$value"},{"name":"$previous","containerName":"number","kind":13,"line":258},{"kind":13,"line":258,"containerName":"number","name":"$value"},{"line":259,"kind":13,"name":"$self","containerName":"number"},{"line":259,"kind":13,"containerName":"number","name":"$value"},{"kind":13,"line":261,"containerName":"number","name":"$previous"}],"line":254,"kind":12,"range":{"end":{"character":9999,"line":262},"start":{"character":0,"line":254}},"name":"number"},{"range":{"end":{"line":278,"character":9999},"start":{"character":0,"line":270}},"name":"converged","children":[{"kind":13,"line":271,"containerName":"converged","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":271,"name":"$value","containerName":"converged"},{"localvar":"my","containerName":"converged","definition":"my","name":"$previous","line":272,"kind":13},{"name":"$self","containerName":"converged","kind":13,"line":272},{"kind":13,"line":273,"name":"$value","containerName":"converged"},{"line":273,"kind":13,"name":"$previous","containerName":"converged"},{"line":274,"kind":13,"containerName":"converged","name":"$value"},{"kind":13,"line":274,"containerName":"converged","name":"$previous"},{"line":274,"kind":13,"name":"$value","containerName":"converged"},{"containerName":"converged","name":"$self","kind":13,"line":275},{"kind":13,"line":275,"name":"$value","containerName":"converged"},{"line":277,"kind":13,"name":"$previous","containerName":"converged"}],"line":270,"kind":12,"signature":{"label":"converged($self,$value)","documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"line":291,"children":[{"line":292,"kind":13,"localvar":"my","containerName":"hit_factory","name":"$self","definition":"my"},{"name":"$self","containerName":"hit_factory","kind":13,"line":293},{"containerName":"hit_factory","name":"$self","kind":13,"line":294}],"kind":12,"range":{"end":{"character":9999,"line":295},"start":{"line":291,"character":0}},"containerName":"main::","name":"hit_factory","definition":"sub"},{"kind":12,"line":293,"name":"_hit_factory"},{"kind":12,"line":294,"name":"_hit_factory"},{"name":"next_hit","range":{"start":{"line":306,"character":0},"end":{"character":9999,"line":313}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.","label":"next_hit($self)"},"kind":12,"line":306,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_hit","line":307,"kind":13},{"containerName":"next_hit","name":"$self","line":309,"kind":13},{"line":310,"kind":13,"name":"$self","containerName":"next_hit"},{"kind":13,"line":310,"name":"$self","containerName":"next_hit"},{"name":"oldhits","containerName":"next_hit","kind":12,"line":310},{"containerName":"next_hit","name":"$self","line":310,"kind":13},{"kind":12,"line":310,"name":"newhits","containerName":"next_hit"},{"name":"$self","containerName":"next_hit","kind":13,"line":311},{"line":313,"kind":13,"name":"$self","containerName":"next_hit"}]},{"line":322,"children":[{"line":323,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_hit_new"},{"kind":13,"line":325,"name":"$self","containerName":"next_hit_new"},{"containerName":"next_hit_new","name":"$self","kind":13,"line":326},{"kind":13,"line":326,"containerName":"next_hit_new","name":"$self"},{"line":326,"kind":12,"name":"newhits","containerName":"next_hit_new"},{"name":"$self","containerName":"next_hit_new","kind":13,"line":327},{"kind":13,"line":329,"containerName":"next_hit_new","name":"$self"}],"kind":12,"detail":"($self)","signature":{"label":"next_hit_new($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>."},"containerName":"main::","definition":"sub","range":{"start":{"line":322,"character":0},"end":{"line":329,"character":9999}},"name":"next_hit_new"},{"line":338,"children":[{"containerName":"next_hit_old","name":"$self","definition":"my","localvar":"my","kind":13,"line":339},{"kind":13,"line":339,"name":"$found_again","containerName":"next_hit_old"},{"containerName":"next_hit_old","name":"$self","line":341,"kind":13},{"kind":13,"line":342,"name":"$self","containerName":"next_hit_old"},{"name":"$self","containerName":"next_hit_old","line":342,"kind":13},{"containerName":"next_hit_old","name":"oldhits","line":342,"kind":12},{"containerName":"next_hit_old","name":"$self","kind":13,"line":343},{"name":"$self","containerName":"next_hit_old","line":345,"kind":13}],"kind":12,"detail":"($self,$found_again)","signature":{"label":"next_hit_old($self,$found_again)","parameters":[{"label":"$self"},{"label":"$found_again"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>."},"containerName":"main::","definition":"sub","range":{"start":{"line":338,"character":0},"end":{"character":9999,"line":345}},"name":"next_hit_old"},{"kind":12,"children":[{"line":360,"kind":13,"localvar":"my","containerName":"rewind","definition":"my","name":"$self"},{"containerName":"rewind","name":"$self","kind":13,"line":361},{"containerName":"rewind","name":"$self","line":362,"kind":13},{"containerName":"rewind","name":"$self","kind":13,"line":363},{"containerName":"rewind","name":"$self","line":364,"kind":13},{"name":"hits","containerName":"rewind","line":364,"kind":12},{"line":365,"kind":12,"name":"rewind","containerName":"rewind"}],"line":359,"definition":"sub","name":"rewind","containerName":"main::","range":{"end":{"character":9999,"line":367},"start":{"character":0,"line":359}}},{"name":"num_hits","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":376},"end":{"character":9999,"line":380}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"num_hits","line":377,"kind":13},{"containerName":"num_hits","name":"$self","kind":13,"line":379},{"line":379,"kind":12,"name":"num_hits_old","containerName":"num_hits"},{"kind":13,"line":379,"containerName":"num_hits","name":"$self"},{"kind":12,"line":379,"name":"num_hits_new","containerName":"num_hits"}],"line":376},{"children":[{"kind":13,"line":389,"containerName":"num_hits_new","name":"$self","definition":"my","localvar":"my"},{"containerName":"num_hits_new","name":"$self","line":391,"kind":13},{"containerName":"num_hits_new","name":"newhits","line":391,"kind":12}],"line":388,"kind":12,"range":{"start":{"line":388,"character":0},"end":{"line":392,"character":9999}},"name":"num_hits_new","definition":"sub","containerName":"main::"},{"name":"num_hits_old","range":{"start":{"character":0,"line":400},"end":{"line":404,"character":9999}},"kind":12,"line":400,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"num_hits_old","line":401,"kind":13},{"kind":13,"line":401,"containerName":"num_hits_old","name":"$found_again"},{"containerName":"num_hits_old","name":"$self","kind":13,"line":403},{"line":403,"kind":12,"containerName":"num_hits_old","name":"oldhits"}],"containerName":"main::","definition":"sub","detail":"($self,$found_again)","signature":{"parameters":[{"label":"$self"},{"label":"$found_again"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>.","label":"num_hits_old($self,$found_again)"}},{"range":{"end":{"line":432,"character":9999},"start":{"character":0,"line":412}},"name":"add_hit","signature":{"label":"add_hit($self,@args)","documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_old {\n   my ($self,$found_again) = @_;\n\n   return scalar $self->oldhits();\n}\n\n=head2 add_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::add_hit()|Bio::Search::Iteration::IterationI>.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_hit","line":413,"kind":13},{"line":413,"kind":13,"name":"@args","containerName":"add_hit"},{"kind":13,"line":414,"name":"$hit","definition":"my","containerName":"add_hit","localvar":"my"},{"kind":13,"line":414,"containerName":"add_hit","name":"$old"},{"containerName":"add_hit","name":"$below","line":414,"kind":13},{"kind":13,"line":414,"containerName":"add_hit","name":"$newly_below"},{"containerName":"add_hit","name":"$self","kind":13,"line":415},{"line":415,"kind":12,"name":"_rearrange","containerName":"add_hit"},{"line":419,"kind":13,"containerName":"add_hit","name":"@args"},{"line":420,"kind":13,"localvar":"my","definition":"my","name":"$count","containerName":"add_hit"},{"kind":13,"line":422,"name":"$hit","containerName":"add_hit"},{"kind":13,"line":422,"name":"$hit","containerName":"add_hit"},{"kind":12,"line":422,"containerName":"add_hit","name":"isa"},{"kind":13,"line":423,"containerName":"add_hit","name":"$self"},{"kind":12,"line":423,"containerName":"add_hit","name":"throw"},{"containerName":"add_hit","name":"$hit","kind":13,"line":424},{"line":428,"kind":13,"containerName":"add_hit","name":"$old"},{"name":"$newly_below","containerName":"add_hit","kind":13,"line":429},{"containerName":"add_hit","name":"$self","line":430,"kind":13},{"containerName":"add_hit","name":"$hit","line":430,"kind":13},{"kind":13,"line":431,"containerName":"add_hit","name":"$count"},{"name":"$self","containerName":"add_hit","line":431,"kind":13}],"line":412,"kind":12},{"name":"%below","containerName":null,"kind":13,"line":432},{"line":433,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":433,"name":"$hit","containerName":null},{"name":"$count","containerName":null,"kind":13,"line":434},{"line":434,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":436},{"name":"$hit","containerName":null,"line":436,"kind":13},{"containerName":null,"name":"$count","line":437,"kind":13},{"name":"%self","containerName":null,"line":437,"kind":13},{"line":439,"kind":13,"name":"%old","containerName":null},{"line":441,"kind":13,"name":"%below","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":442},{"line":442,"kind":13,"containerName":null,"name":"$hit"},{"kind":13,"line":443,"name":"$count","containerName":null},{"line":443,"kind":13,"name":"%self","containerName":null},{"name":"%below","containerName":null,"kind":13,"line":444},{"containerName":null,"name":"%self","kind":13,"line":445},{"kind":13,"line":445,"containerName":null,"name":"$hit"},{"name":"$count","containerName":null,"kind":13,"line":446},{"kind":13,"line":446,"containerName":null,"name":"%self"},{"line":449,"kind":13,"containerName":null,"name":"%self"},{"name":"$hit","containerName":null,"line":449,"kind":13},{"name":"$count","containerName":null,"line":450,"kind":13},{"kind":13,"line":450,"containerName":null,"name":"%self"},{"line":454,"kind":13,"containerName":null,"name":"%self"},{"name":"$hit","containerName":null,"line":454,"kind":13},{"kind":13,"line":455,"containerName":null,"name":"$count"},{"name":"%self","containerName":null,"kind":13,"line":455},{"line":457,"kind":13,"name":"$count","containerName":null},{"range":{"end":{"character":9999,"line":472},"start":{"line":466,"character":0}},"name":"hits","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hits","line":467,"kind":13},{"line":469,"kind":13,"localvar":"my","containerName":"hits","definition":"my","name":"@new"},{"kind":13,"line":469,"name":"$self","containerName":"hits"},{"name":"newhits","containerName":"hits","line":469,"kind":12},{"definition":"my","name":"@old","containerName":"hits","localvar":"my","kind":13,"line":470},{"line":470,"kind":13,"name":"$self","containerName":"hits"},{"containerName":"hits","name":"oldhits","line":470,"kind":12},{"containerName":"hits","name":"@new","kind":13,"line":471},{"containerName":"hits","name":"@old","kind":13,"line":471}],"line":466,"kind":12},{"containerName":"main::","definition":"sub","name":"newhits","range":{"start":{"character":0,"line":486},"end":{"character":9999,"line":492}},"kind":12,"line":486,"children":[{"kind":13,"line":487,"containerName":"newhits","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","containerName":"newhits","definition":"my","name":"@hits","line":488,"kind":13},{"name":"$self","containerName":"newhits","line":488,"kind":13},{"kind":12,"line":488,"containerName":"newhits","name":"newhits_below_threshold"},{"name":"@hits","containerName":"newhits","line":489,"kind":13},{"name":"$self","containerName":"newhits","kind":13,"line":489},{"kind":12,"line":489,"name":"newhits_not_below_threshold","containerName":"newhits"},{"line":490,"kind":13,"name":"@hits","containerName":"newhits"},{"name":"$self","containerName":"newhits","line":490,"kind":13},{"name":"newhits_unclassified","containerName":"newhits","line":490,"kind":12},{"kind":13,"line":491,"containerName":"newhits","name":"@hits"}]},{"definition":"sub","name":"newhits_below_threshold","containerName":"main::","range":{"end":{"character":9999,"line":504},"start":{"character":0,"line":500}},"kind":12,"children":[{"kind":13,"line":501,"containerName":"newhits_below_threshold","definition":"my","name":"$self","localvar":"my"},{"containerName":"newhits_below_threshold","name":"$self","line":502,"kind":13},{"name":"$factory","definition":"my","containerName":"newhits_below_threshold","localvar":"my","kind":13,"line":503},{"kind":13,"line":503,"name":"$self","containerName":"newhits_below_threshold"},{"containerName":"newhits_below_threshold","name":"hit_factory","kind":12,"line":503},{"kind":13,"line":503,"name":"$self","containerName":"newhits_below_threshold"},{"line":504,"kind":13,"name":"$self","containerName":"newhits_below_threshold"}],"line":500},{"containerName":null,"name":"%self","line":505,"kind":13},{"line":506,"kind":13,"containerName":null,"name":"%self"},{"line":506,"kind":13,"containerName":null,"name":"$factory"},{"kind":12,"line":506,"name":"create_object","containerName":"main::"},{"line":506,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":508,"name":"%self","containerName":null},{"kind":12,"line":519,"children":[{"name":"$self","definition":"my","containerName":"newhits_not_below_threshold","localvar":"my","kind":13,"line":520},{"line":521,"kind":13,"name":"$self","containerName":"newhits_not_below_threshold"},{"localvar":"my","containerName":"newhits_not_below_threshold","name":"$factory","definition":"my","line":522,"kind":13},{"containerName":"newhits_not_below_threshold","name":"$self","kind":13,"line":522},{"kind":12,"line":522,"containerName":"newhits_not_below_threshold","name":"hit_factory"},{"containerName":"newhits_not_below_threshold","name":"$self","kind":13,"line":522},{"kind":13,"line":523,"name":"$self","containerName":"newhits_not_below_threshold"}],"containerName":"main::","definition":"sub","name":"newhits_not_below_threshold","range":{"end":{"character":9999,"line":523},"start":{"character":0,"line":519}}},{"name":"%self","containerName":null,"kind":13,"line":524},{"containerName":null,"name":"%self","kind":13,"line":525},{"containerName":null,"name":"$factory","kind":13,"line":525},{"line":525,"kind":12,"containerName":"main::","name":"create_object"},{"containerName":null,"name":"%self","kind":13,"line":525},{"line":527,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":543,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"newhits_unclassified","line":544,"kind":13},{"name":"$self","containerName":"newhits_unclassified","line":545,"kind":13},{"line":546,"kind":13,"localvar":"my","containerName":"newhits_unclassified","definition":"my","name":"$factory"},{"name":"$self","containerName":"newhits_unclassified","line":546,"kind":13},{"kind":12,"line":546,"name":"hit_factory","containerName":"newhits_unclassified"},{"name":"$self","containerName":"newhits_unclassified","line":546,"kind":13},{"line":547,"kind":13,"containerName":"newhits_unclassified","name":"$self"}],"containerName":"main::","definition":"sub","name":"newhits_unclassified","range":{"start":{"line":543,"character":0},"end":{"character":9999,"line":547}}},{"containerName":null,"name":"%self","kind":13,"line":548},{"kind":13,"line":549,"name":"%self","containerName":null},{"containerName":null,"name":"$factory","kind":13,"line":549},{"line":549,"kind":12,"containerName":"main::","name":"create_object"},{"containerName":null,"name":"%self","kind":13,"line":549},{"name":"%self","containerName":null,"line":551,"kind":13},{"definition":"sub","name":"oldhits","containerName":"main::","range":{"end":{"line":574,"character":9999},"start":{"character":0,"line":568}},"kind":12,"children":[{"localvar":"my","containerName":"oldhits","name":"$self","definition":"my","line":569,"kind":13},{"line":570,"kind":13,"localvar":"my","containerName":"oldhits","name":"@hits","definition":"my"},{"name":"$self","containerName":"oldhits","line":570,"kind":13},{"line":570,"kind":12,"containerName":"oldhits","name":"oldhits_below_threshold"},{"name":"@hits","containerName":"oldhits","line":571,"kind":13},{"name":"$self","containerName":"oldhits","line":571,"kind":13},{"kind":12,"line":571,"containerName":"oldhits","name":"oldhits_newly_below_threshold"},{"containerName":"oldhits","name":"@hits","kind":13,"line":572},{"line":572,"kind":13,"name":"$self","containerName":"oldhits"},{"line":572,"kind":12,"name":"oldhits_not_below_threshold","containerName":"oldhits"},{"containerName":"oldhits","name":"@hits","kind":13,"line":573}],"line":568},{"line":582,"children":[{"line":583,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"oldhits_below_threshold"},{"kind":13,"line":584,"containerName":"oldhits_below_threshold","name":"$self"},{"localvar":"my","containerName":"oldhits_below_threshold","name":"$factory","definition":"my","line":585,"kind":13},{"kind":13,"line":585,"name":"$self","containerName":"oldhits_below_threshold"},{"kind":12,"line":585,"containerName":"oldhits_below_threshold","name":"hit_factory"},{"name":"$self","containerName":"oldhits_below_threshold","kind":13,"line":585},{"containerName":"oldhits_below_threshold","name":"$self","kind":13,"line":586}],"kind":12,"range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":586}},"containerName":"main::","definition":"sub","name":"oldhits_below_threshold"},{"name":"%self","containerName":null,"line":587,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":588},{"containerName":null,"name":"$factory","line":588,"kind":13},{"kind":12,"line":588,"containerName":"main::","name":"create_object"},{"kind":13,"line":588,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":590,"kind":13},{"containerName":"main::","definition":"sub","name":"oldhits_newly_below_threshold","range":{"end":{"line":605,"character":9999},"start":{"line":601,"character":0}},"kind":12,"line":601,"children":[{"localvar":"my","containerName":"oldhits_newly_below_threshold","definition":"my","name":"$self","line":602,"kind":13},{"kind":13,"line":603,"containerName":"oldhits_newly_below_threshold","name":"$self"},{"kind":13,"line":604,"containerName":"oldhits_newly_below_threshold","definition":"my","name":"$factory","localvar":"my"},{"containerName":"oldhits_newly_below_threshold","name":"$self","line":604,"kind":13},{"containerName":"oldhits_newly_below_threshold","name":"hit_factory","line":604,"kind":12},{"containerName":"oldhits_newly_below_threshold","name":"$self","kind":13,"line":604},{"name":"$self","containerName":"oldhits_newly_below_threshold","line":605,"kind":13}]},{"containerName":null,"name":"%self","line":606,"kind":13},{"containerName":null,"name":"%self","line":607,"kind":13},{"line":607,"kind":13,"name":"$factory","containerName":null},{"kind":12,"line":607,"containerName":"main::","name":"create_object"},{"containerName":null,"name":"%self","kind":13,"line":607},{"line":609,"kind":13,"containerName":null,"name":"%self"},{"range":{"start":{"line":620,"character":0},"end":{"character":9999,"line":624}},"containerName":"main::","name":"oldhits_not_below_threshold","definition":"sub","line":620,"children":[{"kind":13,"line":621,"definition":"my","name":"$self","containerName":"oldhits_not_below_threshold","localvar":"my"},{"kind":13,"line":622,"containerName":"oldhits_not_below_threshold","name":"$self"},{"kind":13,"line":623,"definition":"my","name":"$factory","containerName":"oldhits_not_below_threshold","localvar":"my"},{"kind":13,"line":623,"containerName":"oldhits_not_below_threshold","name":"$self"},{"name":"hit_factory","containerName":"oldhits_not_below_threshold","kind":12,"line":623},{"name":"$self","containerName":"oldhits_not_below_threshold","line":623,"kind":13},{"containerName":"oldhits_not_below_threshold","name":"$self","kind":13,"line":624}],"kind":12},{"kind":13,"line":625,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":626,"kind":13},{"kind":13,"line":626,"name":"$factory","containerName":null},{"line":626,"kind":12,"name":"create_object","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":626},{"line":628,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"children":[{"line":640,"kind":13,"localvar":"my","containerName":"hits_below_threshold","name":"$self","definition":"my"},{"containerName":"hits_below_threshold","definition":"my","name":"@hits","localvar":"my","kind":13,"line":641},{"kind":13,"line":641,"name":"$self","containerName":"hits_below_threshold"},{"name":"newhits_below_threshold","containerName":"hits_below_threshold","line":641,"kind":12},{"kind":13,"line":642,"name":"@hits","containerName":"hits_below_threshold"},{"kind":13,"line":642,"name":"$self","containerName":"hits_below_threshold"},{"containerName":"hits_below_threshold","name":"oldhits_newly_below_threshold","kind":12,"line":642},{"containerName":"hits_below_threshold","name":"@hits","line":643,"kind":13}],"line":639,"definition":"sub","name":"hits_below_threshold","containerName":"main::","range":{"end":{"character":9999,"line":644},"start":{"character":0,"line":639}}},{"line":658,"children":[{"containerName":"get_hit","definition":"my","name":"$self","localvar":"my","kind":13,"line":659},{"name":"$name","containerName":"get_hit","line":659,"kind":13},{"kind":13,"line":660,"containerName":"get_hit","name":"$self"},{"containerName":"get_hit","name":"_create_hit_lookup","line":660,"kind":12},{"containerName":"get_hit","name":"$self","line":660,"kind":13},{"line":662,"kind":13,"containerName":"get_hit","name":"$self"}],"kind":12,"detail":"($self,$name)","signature":{"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_old {\n   my ($self,$found_again) = @_;\n\n   return scalar $self->oldhits();\n}\n\n=head2 add_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::add_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub add_hit { \n    my ($self,@args) = @_;\n    my( $hit, $old, $below, $newly_below ) = \n        $self->_rearrange([qw(HIT\n                              OLD\n                              BELOW_THRESHOLD\n                              NEWLY_BELOW\n                             )], @args);\n    my $count = 0;\n\n    unless( ref($hit) eq 'HASH' || $hit->isa('Bio::Search::Hit::HitI') ) { \n        $self->throw(-class=>'Bio::Root::BadParameter',\n                     -text=>\"Passed in \" .ref($hit). \n                    \" as a Hit which is not a Bio::Search::Hit::HitI.\");\n    }\n\n    if($old) {\n        if ($newly_below) {\n            push @{$self->{'_oldhits_newly_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_newly_below_threshold'}};\n        } elsif ($below) {\n            push @{$self->{'_oldhits_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_below_threshold'}};\n        } else {\n            push @{$self->{'_oldhits_not_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_not_below_threshold'}};\n        }\n    } elsif (defined $old) {\n        # -old is defined but false, so this is a new PSI-BLAST hit\n        if ($below) {\n            push @{$self->{'_newhits_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_newhits_below_threshold'}};\n        } elsif (defined $below) {\n            push @{$self->{'_newhits_not_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_newhits_not_below_threshold'}};\n        } else {\n            # -below not defined, PSI-BLAST threshold may not be known\n            push @{$self->{'_newhits_unclassified'}}, $hit;\n            $count = scalar @{$self->{'_newhits_unclassified'}};\n        }\n    } else {\n        # -old not defined, so it's non-PSI-BLAST\n        push @{$self->{'_newhits_unclassified'}}, $hit;\n        $count = scalar @{$self->{'_newhits_unclassified'}};\n    }\n    return $count;\n}\n\n=head2 hits\n\nSee Documentation in InterfaceI.\n\n\nsub hits  { \n    my $self = shift;\n#    print STDERR \"Called GenericIteration::hits()\\n\";\n    my @new = $self->newhits;\n    my @old = $self->oldhits;\n    return ( @new, @old );\n}\n\n=head2 newhits\n\nReturns a list containing all newhits in this order:\n\nnewhits_below_threshold\nnewhits_not_below_threshold\nnewhits_unclassified\n\nSee more documentation in InterfaceI.\n\n\nsub newhits  { \n    my $self = shift;\n    my @hits = $self->newhits_below_threshold;\n    push @hits, $self->newhits_not_below_threshold;\n    push @hits, $self->newhits_unclassified;\n    return @hits;\n}\n\n=head2 newhits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::newhits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub newhits_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_newhits_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_below_threshold'}};\n        for (0..$#{$self->{'_newhits_below_threshold'}}) {\n            ref(${$self->{'_newhits_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_newhits_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_newhits_below_threshold'}};\n    }\n    return;\n}\n\n=head2 newhits_not_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::newhits_not_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub newhits_not_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_newhits_not_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_not_below_threshold'}};\n        for (0..$#{$self->{'_newhits_not_below_threshold'}}) {\n            ref(${$self->{'_newhits_not_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_not_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_newhits_not_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_newhits_not_below_threshold'}};\n    }\n    return;\n}\n\n=head2 newhits_unclassified\n\n Title   : newhits_unclassified\n Usage   : foreach( $iteration->hits_unclassified ) {...}\n Function: Gets all newhits that have not been partitioned into\n           sets relative to the inclusion threshold.\n Returns : Array of Bio::Search::Hit::HitI objects.\n Args    : none\n\n\nsub newhits_unclassified  { \n    my $self = shift;\n    if (ref $self->{'_newhits_unclassified'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_unclassified'}};\n        for (0..$#{$self->{'_newhits_unclassified'}}) {\n            ref(${$self->{'_newhits_unclassified'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_unclassified'}}[$_] = $factory->create_object(%{${$self->{'_newhits_unclassified'}}[$_]});\n        }\n        return @{$self->{'_newhits_unclassified'}};\n    }\n    return;\n}\n\n=head2 oldhits\n\nReturns a list containing all oldhits in this order:\n\noldhits_below_threshold\noldhits_newly_below_threshold\noldhits_not_below_threshold\n\nSee more documentation in InterfaceI.\n\n\nsub oldhits  { \n    my $self = shift;\n    my @hits = $self->oldhits_below_threshold;\n    push @hits, $self->oldhits_newly_below_threshold;\n    push @hits, $self->oldhits_not_below_threshold;\n    return @hits;\n}\n\n=head2 oldhits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_below_threshold'}}) {\n            ref(${$self->{'_oldhits_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_below_threshold'}};\n    }\n    return;\n}\n\n=head2 oldhits_newly_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_newly_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_newly_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_newly_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_newly_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_newly_below_threshold'}}) {\n            ref(${$self->{'_oldhits_newly_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_newly_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_newly_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_newly_below_threshold'}};\n    }\n    return;\n}\n\n=head2 oldhits_not_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_not_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_not_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_not_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_not_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_not_below_threshold'}}) {\n            ref(${$self->{'_oldhits_not_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_not_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_not_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_not_below_threshold'}};\n    }\n    return;\n}\n\n=head2 hits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::hits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub hits_below_threshold  {\n    my $self = shift;\n    my @hits = $self->newhits_below_threshold;\n    push @hits, $self->oldhits_newly_below_threshold;\n    return @hits;\n}\n\n=head2 get_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::get_hit()|Bio::Search::Iteration::IterationI>.\n\nTo free up the memory used by the get_hit() functionality, call free_hit_lookup().\n\nThis functionality might be useful at the Result level, too.\nBlastResult::get_hit() would return a list of HitI objects for hits \nthat occur in multiple iterations.","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_hit($self,$name)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":663},"start":{"character":0,"line":658}},"name":"get_hit"},{"containerName":"main::","name":"_create_hit_lookup","definition":"sub","range":{"start":{"character":0,"line":666},"end":{"character":9999,"line":672}},"kind":12,"line":666,"children":[{"kind":13,"line":667,"name":"$self","definition":"my","containerName":"_create_hit_lookup","localvar":"my"},{"kind":13,"line":668,"containerName":"_create_hit_lookup","name":"$self"},{"containerName":"_create_hit_lookup","name":"hits","kind":12,"line":668},{"kind":13,"line":669,"definition":"my","name":"$hname","containerName":"_create_hit_lookup","localvar":"my"},{"name":"name","containerName":"_create_hit_lookup","line":669,"kind":12},{"name":"$self","containerName":"_create_hit_lookup","line":670,"kind":13}]},{"containerName":"main::","definition":"sub","name":"free_hit_lookup","range":{"start":{"line":681,"character":0},"end":{"character":9999,"line":684}},"kind":12,"line":681,"children":[{"kind":13,"line":682,"definition":"my","name":"$self","containerName":"free_hit_lookup","localvar":"my"},{"containerName":"free_hit_lookup","name":"$self","line":683,"kind":13}]}]}