{"version":5,"vars":[{"line":101,"kind":2,"containerName":"","name":"base"},{"signature":{"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":118,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":118},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":120},{"line":120,"kind":13,"containerName":"new","name":"$class"},{"line":120,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","line":122,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":123},{"line":124,"kind":13,"containerName":"new","name":"$self"},{"line":126,"kind":13,"localvar":"my","name":"$iters","definition":"my","containerName":"new"},{"kind":13,"line":126,"containerName":"new","name":"$ithresh"},{"containerName":"new","name":"$self","line":126,"kind":13},{"kind":12,"line":126,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":127},{"line":129,"kind":13,"name":"$self","containerName":"new"},{"line":129,"kind":13,"containerName":"new","name":"$ithresh"},{"containerName":"new","name":"$iters","line":131,"kind":13},{"line":132,"kind":13,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","kind":12,"line":132},{"kind":13,"line":132,"name":"$iters","containerName":"new"},{"kind":13,"line":134,"containerName":"new","definition":"my","name":"$i","localvar":"my"},{"line":134,"kind":13,"containerName":"new","name":"$iters"},{"containerName":"new","name":"$self","line":135,"kind":13},{"line":135,"kind":12,"containerName":"new","name":"add_iteration"},{"name":"$i","containerName":"new","line":135,"kind":13}],"line":117,"kind":12,"range":{"start":{"character":0,"line":117},"end":{"character":9999,"line":137}},"name":"new"},{"kind":12,"line":120,"containerName":"new","name":"SUPER"},{"name":"%self","containerName":null,"kind":13,"line":141},{"name":"$self","containerName":null,"kind":13,"line":145},{"kind":12,"line":161,"children":[{"name":"$self","definition":"my","containerName":"hits","localvar":"my","kind":13,"line":162},{"kind":13,"line":163,"name":"$self","containerName":"hits"},{"name":"$self","containerName":"hits","line":164,"kind":13},{"kind":13,"line":166,"name":"@hits","definition":"my","containerName":"hits","localvar":"my"},{"line":167,"kind":13,"localvar":"my","definition":"my","name":"$it","containerName":"hits"},{"line":167,"kind":13,"containerName":"hits","name":"$self"},{"kind":12,"line":167,"containerName":"hits","name":"iterations"},{"name":"@hits","containerName":"hits","line":168,"kind":13},{"containerName":"hits","name":"$it","kind":13,"line":168},{"containerName":"hits","name":"hits","line":168,"kind":12},{"name":"@hits","containerName":"hits","line":170,"kind":13}],"containerName":"main::","name":"hits","definition":"sub","range":{"end":{"line":171,"character":9999},"start":{"character":0,"line":161}}},{"containerName":"hits","name":"SUPER","line":166,"kind":12},{"name":"next_hit","range":{"start":{"character":0,"line":185},"end":{"character":9999,"line":198}},"definition":"sub","containerName":"main::","signature":{"label":"next_hit($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_hit","line":186,"kind":13},{"kind":13,"line":186,"name":"@args","containerName":"next_hit"},{"line":187,"kind":13,"containerName":"next_hit","name":"$self"},{"containerName":"next_hit","name":"$self","line":188,"kind":13},{"containerName":"next_hit","name":"@args","line":188,"kind":13},{"kind":13,"line":191,"name":"$iter_index","definition":"my","containerName":"next_hit","localvar":"my"},{"kind":13,"line":192,"containerName":"next_hit","name":"$self"},{"containerName":"next_hit","name":"$iter_index","line":193,"kind":13},{"containerName":"next_hit","name":"$self","line":193,"kind":13},{"name":"$self","containerName":"next_hit","line":193,"kind":13},{"line":193,"kind":12,"name":"_next_iteration_index","containerName":"next_hit"},{"containerName":"next_hit","name":"$iter_index","line":195,"kind":13},{"name":"$self","containerName":"next_hit","line":195,"kind":13},{"kind":13,"line":198,"containerName":"next_hit","name":"$iter_index"},{"name":"$self","containerName":"next_hit","kind":13,"line":198}],"line":185},{"line":188,"kind":12,"containerName":"next_hit","name":"SUPER"},{"line":200,"kind":13,"localvar":"my","name":"$it","definition":"my","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":200},{"name":"$iter_index","containerName":null,"kind":13,"line":200},{"line":201,"kind":13,"localvar":"my","containerName":null,"name":"$hit","definition":"my"},{"kind":13,"line":201,"containerName":null,"name":"%self"},{"kind":13,"line":201,"containerName":null,"name":"$it"},{"line":201,"kind":12,"name":"next_hit","containerName":"main::"},{"containerName":null,"name":"$hit","line":203,"kind":13},{"name":"$hit","containerName":null,"line":203,"kind":13},{"kind":13,"line":203,"containerName":null,"name":"$self"},{"line":203,"kind":12,"containerName":"main::","name":"next_hit"},{"containerName":"main::","definition":"sub","name":"num_hits","range":{"end":{"character":9999,"line":229},"start":{"line":220,"character":0}},"kind":12,"line":220,"children":[{"kind":13,"line":221,"definition":"my","name":"$self","containerName":"num_hits","localvar":"my"},{"name":"$self","containerName":"num_hits","kind":13,"line":222},{"name":"$self","containerName":"num_hits","kind":13,"line":223},{"name":"$self","containerName":"num_hits","kind":13,"line":225},{"containerName":"num_hits","name":"$self","line":226,"kind":13},{"line":226,"kind":12,"containerName":"num_hits","name":"throw"},{"name":"$self","containerName":"num_hits","line":228,"kind":13},{"name":"hits","containerName":"num_hits","kind":12,"line":228}]},{"name":"SUPER","containerName":"num_hits","line":225,"kind":12},{"signature":{"label":"add_iteration($self,$i)","parameters":[{"label":"$self"},{"label":"$i"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI"},"detail":"($self,$i)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_iteration","line":242,"kind":13},{"line":242,"kind":13,"name":"$i","containerName":"add_iteration"},{"containerName":"add_iteration","name":"$i","line":243,"kind":13},{"containerName":"add_iteration","name":"isa","line":243,"kind":12},{"name":"$self","containerName":"add_iteration","line":244,"kind":13},{"containerName":"add_iteration","name":"$i","line":244,"kind":13},{"kind":13,"line":245,"name":"$self","containerName":"add_iteration"}],"line":241,"kind":12,"range":{"end":{"line":246,"character":9999},"start":{"line":241,"character":0}},"name":"add_iteration"},{"name":"$self","containerName":null,"kind":13,"line":247},{"kind":12,"line":247,"name":"throw","containerName":"main::"},{"name":"$i","containerName":null,"kind":13,"line":247},{"containerName":null,"name":"%self","line":250,"kind":13},{"kind":12,"children":[{"localvar":"my","containerName":"next_iteration","definition":"my","name":"$self","line":266,"kind":13},{"containerName":"next_iteration","name":"$self","line":268,"kind":13},{"kind":13,"line":269,"name":"$self","containerName":"next_iteration"},{"name":"$self","containerName":"next_iteration","line":269,"kind":13},{"containerName":"next_iteration","name":"iterations","kind":12,"line":269},{"line":270,"kind":13,"name":"$self","containerName":"next_iteration"},{"line":272,"kind":13,"containerName":"next_iteration","name":"$self"}],"line":265,"definition":"sub","containerName":"main::","signature":{"label":"next_iteration($self)","documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","name":"next_iteration","range":{"end":{"character":9999,"line":272},"start":{"character":0,"line":265}}},{"kind":12,"line":288,"children":[{"kind":13,"line":289,"containerName":"iteration","name":"$self","definition":"my","localvar":"my"},{"line":289,"kind":13,"name":"$num","containerName":"iteration"},{"line":290,"kind":13,"name":"$num","containerName":"iteration"},{"kind":13,"line":290,"name":"$self","containerName":"iteration"}],"containerName":"main::","definition":"sub","detail":"($self,$num)","signature":{"parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1","label":"iteration($self,$num)"},"name":"iteration","range":{"start":{"line":288,"character":0},"end":{"line":290,"character":9999}}},{"line":290,"kind":13,"containerName":null,"name":"$num"},{"kind":13,"line":291,"containerName":null,"name":"$num"},{"line":291,"kind":13,"name":"$num","containerName":null},{"line":291,"kind":13,"containerName":null,"name":"%self"},{"name":"$self","containerName":null,"kind":13,"line":292},{"kind":12,"line":292,"containerName":"main::","name":"throw"},{"kind":13,"line":294,"containerName":null,"name":"$num"},{"containerName":null,"name":"%self","kind":13,"line":296},{"containerName":null,"name":"$num","line":296,"kind":13},{"kind":12,"children":[],"line":308,"definition":"sub","name":"num_iterations","containerName":"main::","range":{"start":{"character":0,"line":308},"end":{"character":9999,"line":308}}},{"definition":"sub","name":"number_of_iterations","containerName":"main::","range":{"start":{"line":319,"character":0},"end":{"line":319,"character":9999}},"kind":12,"children":[{"name":"num_iterations","containerName":"number_of_iterations","kind":12,"line":319}],"line":319},{"containerName":"main::","definition":"sub","name":"round","range":{"start":{"line":327,"character":0},"end":{"character":9999,"line":327}},"kind":12,"line":327,"children":[{"name":"iteration","containerName":"round","kind":12,"line":327}]},{"line":340,"children":[{"containerName":"iterations","name":"$self","definition":"my","localvar":"my","kind":13,"line":341},{"localvar":"my","containerName":"iterations","definition":"my","name":"@its","line":342,"kind":13},{"line":343,"kind":13,"name":"$self","containerName":"iterations"},{"line":344,"kind":13,"containerName":"iterations","name":"@its"},{"line":344,"kind":13,"containerName":"iterations","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":340},"end":{"line":345,"character":9999}},"containerName":"main::","name":"iterations","definition":"sub"},{"name":"@its","containerName":null,"line":346,"kind":13},{"signature":{"label":"no_hits_found($self,$round)","parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found."},"detail":"($self,$round)","definition":"sub","containerName":"main::","children":[{"line":371,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"no_hits_found"},{"line":371,"kind":13,"name":"$round","containerName":"no_hits_found"},{"line":373,"kind":13,"localvar":"my","definition":"my","name":"$result","containerName":"no_hits_found"},{"kind":13,"line":380,"containerName":"no_hits_found","name":"$round"},{"name":"$self","containerName":"no_hits_found","line":381,"kind":13},{"line":382,"kind":13,"name":"$result","containerName":"no_hits_found"},{"line":383,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"no_hits_found"},{"name":"$self","containerName":"no_hits_found","line":383,"kind":13},{"containerName":"no_hits_found","name":"$self","kind":13,"line":384},{"name":"$result","containerName":"no_hits_found","line":385,"kind":13},{"containerName":"no_hits_found","name":"$result","kind":13,"line":391},{"containerName":"no_hits_found","name":"$self","line":391,"kind":13},{"kind":13,"line":395,"containerName":"no_hits_found","name":"$result"},{"containerName":"no_hits_found","name":"$self","line":395,"kind":13},{"line":398,"kind":13,"name":"$result","containerName":"no_hits_found"}],"line":370,"kind":12,"range":{"start":{"line":370,"character":0},"end":{"line":399,"character":9999}},"name":"no_hits_found"},{"kind":12,"line":412,"children":[{"line":413,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"set_no_hits_found"},{"line":413,"kind":13,"containerName":"set_no_hits_found","name":"$round"},{"containerName":"set_no_hits_found","name":"$round","line":414,"kind":13},{"line":415,"kind":13,"name":"$self","containerName":"set_no_hits_found"}],"containerName":"main::","definition":"sub","detail":"($self,$round)","signature":{"label":"set_no_hits_found($self,$round)","parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (CrossMatch)"},"name":"set_no_hits_found","range":{"end":{"character":9999,"line":416},"start":{"character":0,"line":412}}},{"kind":12,"line":425,"children":[{"line":426,"kind":13,"localvar":"my","containerName":"_next_iteration_index","name":"$self","definition":"my"},{"name":"@args","containerName":"_next_iteration_index","line":426,"kind":13},{"containerName":"_next_iteration_index","name":"$self","line":427,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_next_iteration_index($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n\n\nsub set_no_hits_found {\n    my ($self, $round) = @_;\n    $round ||= 1;\n    $self->{\"_iteration_$round\"}->{'_no_hits_found'} = 1;\n}\n\n=head2 _next_iteration_index\n\n Title   : _next_iteration_index\n Usage   : private"},"name":"_next_iteration_index","range":{"start":{"character":0,"line":425},"end":{"character":9999,"line":428}}},{"children":[{"kind":13,"line":443,"name":"$self","definition":"my","containerName":"rewind","localvar":"my"},{"kind":13,"line":444,"name":"$self","containerName":"rewind"},{"containerName":"rewind","name":"$self","kind":13,"line":445},{"kind":13,"line":446,"containerName":"rewind","name":"$self"},{"line":446,"kind":12,"name":"iterations","containerName":"rewind"},{"name":"rewind","containerName":"rewind","line":447,"kind":12}],"line":442,"kind":12,"range":{"end":{"line":449,"character":9999},"start":{"character":0,"line":442}},"definition":"sub","name":"rewind","containerName":"main::"},{"name":"SUPER","containerName":"rewind","kind":12,"line":444},{"kind":12,"line":464,"children":[{"name":"$self","definition":"my","containerName":"inclusion_threshold","localvar":"my","kind":13,"line":465},{"line":466,"kind":13,"name":"$self","containerName":"inclusion_threshold"}],"containerName":"main::","name":"inclusion_threshold","definition":"sub","range":{"start":{"character":0,"line":464},"end":{"line":467,"character":9999}}},{"range":{"start":{"character":0,"line":470},"end":{"line":479,"character":9999}},"name":"algorithm_old","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"algorithm_old","line":471,"kind":13},{"localvar":"my","definition":"my","name":"$value","containerName":"algorithm_old","line":472,"kind":13},{"name":"$value","containerName":"algorithm_old","line":473,"kind":13},{"kind":13,"line":475,"containerName":"algorithm_old","name":"$self"},{"kind":13,"line":477,"name":"$self","containerName":"algorithm_old"}],"line":470,"kind":12},{"kind":12,"line":477,"name":"SUPER","containerName":"algorithm"}]}