{"version":5,"vars":[{"line":117,"kind":2,"name":"base","containerName":""},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().","label":"_setup($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"line":131,"kind":13,"localvar":"my","containerName":"_setup","definition":"my","name":"$self"},{"containerName":"_setup","name":"@args","kind":13,"line":131},{"name":"$self","containerName":"_setup","line":134,"kind":13},{"line":134,"kind":12,"name":"_fields","containerName":"_setup"},{"kind":13,"line":143,"name":"$parent","definition":"my","containerName":"_setup","localvar":"my"},{"line":143,"kind":13,"name":"$chunk","containerName":"_setup"},{"name":"$params","containerName":"_setup","line":143,"kind":13},{"kind":13,"line":143,"containerName":"_setup","name":"$stats"},{"containerName":"_setup","name":"$self","kind":13,"line":143},{"kind":12,"line":143,"name":"_rearrange","containerName":"_setup"},{"line":147,"kind":13,"name":"@args","containerName":"_setup"},{"name":"$self","containerName":"_setup","kind":13,"line":148},{"name":"throw","containerName":"_setup","line":148,"kind":12},{"name":"$parent","containerName":"_setup","line":148,"kind":13},{"containerName":"_setup","name":"$chunk","kind":13,"line":148},{"kind":13,"line":150,"name":"$self","containerName":"_setup"},{"kind":12,"line":150,"containerName":"_setup","name":"parent"},{"kind":13,"line":150,"containerName":"_setup","name":"$parent"},{"line":150,"kind":13,"containerName":"_setup","name":"$parent"},{"containerName":"_setup","name":"$chunk","kind":13,"line":152},{"containerName":"_setup","name":"$io","definition":"my","localvar":"my","kind":13,"line":153},{"line":153,"kind":13,"containerName":"_setup","name":"$start"},{"name":"$end","containerName":"_setup","kind":13,"line":153},{"kind":13,"line":154,"name":"$chunk","containerName":"_setup"},{"kind":13,"line":155,"containerName":"_setup","name":"$io"},{"line":155,"kind":13,"containerName":"_setup","name":"$start"},{"containerName":"_setup","name":"$end","line":155,"kind":13},{"name":"$chunk","containerName":"_setup","kind":13,"line":155},{"containerName":"_setup","name":"$io","line":158,"kind":13},{"kind":13,"line":158,"name":"$chunk","containerName":"_setup"},{"name":"$self","containerName":"_setup","line":160,"kind":13},{"containerName":"_setup","name":"chunk","kind":12,"line":160},{"containerName":"_setup","name":"$io","kind":13,"line":160},{"name":"$start","containerName":"_setup","line":160,"kind":13},{"name":"$end","containerName":"_setup","kind":13,"line":160}],"line":130,"name":"_setup","range":{"start":{"character":0,"line":130},"end":{"character":9999,"line":161}}},{"name":"next_hit","line":134,"kind":12},{"name":"num_hits","line":135,"kind":12},{"name":"hits","line":136,"kind":12},{"kind":12,"line":137,"name":"no_hits_found"},{"name":"query_name","kind":12,"line":138},{"name":"query_accession","kind":12,"line":139},{"name":"query_length","line":140,"kind":12},{"kind":12,"line":141,"name":"query_description"},{"name":"%params","containerName":null,"kind":13,"line":163},{"name":"%params","containerName":null,"kind":13,"line":164},{"containerName":null,"name":"$self","kind":13,"line":165},{"line":165,"kind":12,"containerName":"main::","name":"throw"},{"line":167,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":null},{"name":"$value","containerName":null,"line":167,"kind":13},{"line":167,"kind":13,"name":"%params","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":168},{"kind":12,"line":168,"containerName":"main::","name":"add_parameter"},{"line":168,"kind":13,"name":"$key","containerName":null},{"kind":13,"line":168,"containerName":null,"name":"$value"},{"containerName":null,"name":"%stats","kind":13,"line":171},{"containerName":null,"name":"%stats","kind":13,"line":172},{"name":"$self","containerName":null,"line":173,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":173},{"line":175,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":null},{"line":175,"kind":13,"containerName":null,"name":"$value"},{"name":"%stats","containerName":null,"line":175,"kind":13},{"kind":13,"line":176,"name":"$self","containerName":null},{"line":176,"kind":12,"containerName":"main::","name":"add_statistic"},{"containerName":null,"name":"$key","line":176,"kind":13},{"line":176,"kind":13,"containerName":null,"name":"$value"},{"kind":12,"line":198,"children":[{"containerName":"next_hit","name":"get_field","kind":12,"line":199}],"containerName":"main::","definition":"sub","name":"next_hit","range":{"start":{"line":198,"character":0},"end":{"line":200,"character":9999}}},{"range":{"start":{"character":0,"line":234},"end":{"line":236,"character":9999}},"containerName":"main::","name":"query_name","definition":"sub","line":234,"children":[{"name":"get_field","containerName":"query_name","kind":12,"line":235}],"kind":12},{"kind":12,"children":[{"line":249,"kind":12,"containerName":"query_accession","name":"get_field"}],"line":248,"name":"query_accession","definition":"sub","containerName":"main::","range":{"end":{"line":250,"character":9999},"start":{"line":248,"character":0}}},{"name":"query_length","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":264},"start":{"character":0,"line":262}},"kind":12,"children":[{"name":"get_field","containerName":"query_length","kind":12,"line":263}],"line":262},{"definition":"sub","name":"query_description","containerName":"main::","range":{"start":{"line":277,"character":0},"end":{"character":9999,"line":279}},"kind":12,"children":[{"name":"get_field","containerName":"query_description","line":278,"kind":12}],"line":277},{"line":292,"children":[{"name":"get_field","containerName":"database_name","kind":12,"line":293}],"kind":12,"range":{"end":{"line":294,"character":9999},"start":{"character":0,"line":292}},"containerName":"main::","definition":"sub","name":"database_name"},{"name":"database_letters","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":308},"end":{"line":310,"character":9999}},"kind":12,"children":[{"kind":12,"line":309,"name":"get_field","containerName":"database_letters"}],"line":308},{"kind":12,"children":[{"kind":12,"line":324,"containerName":"database_entries","name":"get_field"}],"line":323,"name":"database_entries","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":323},"end":{"line":325,"character":9999}}},{"range":{"end":{"line":339,"character":9999},"start":{"line":337,"character":0}},"definition":"sub","name":"algorithm","containerName":"main::","children":[{"containerName":"algorithm","name":"get_field","line":338,"kind":12}],"line":337,"kind":12},{"definition":"sub","name":"algorithm_version","containerName":"main::","range":{"end":{"line":353,"character":9999},"start":{"line":351,"character":0}},"kind":12,"children":[{"name":"get_field","containerName":"algorithm_version","kind":12,"line":352}],"line":351},{"children":[{"definition":"my","name":"$self","containerName":"algorithm_reference","localvar":"my","kind":13,"line":369}],"line":368,"kind":12,"signature":{"label":"algorithm_reference($self)","documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":368},"end":{"line":371,"character":9999}},"name":"algorithm_reference"},{"name":"num_hits","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":385},"start":{"character":0,"line":383}},"kind":12,"children":[{"containerName":"num_hits","name":"get_field","kind":12,"line":384}],"line":383},{"line":399,"children":[{"containerName":"hits","name":"get_field","kind":12,"line":400}],"kind":12,"range":{"start":{"line":399,"character":0},"end":{"line":401,"character":9999}},"containerName":"main::","name":"hits","definition":"sub"},{"line":422,"children":[{"kind":12,"line":423,"name":"get_field","containerName":"no_hits_found"}],"kind":12,"range":{"start":{"line":422,"character":0},"end":{"character":9999,"line":424}},"containerName":"main::","name":"no_hits_found","definition":"sub"},{"kind":12,"line":437,"children":[{"line":438,"kind":12,"containerName":"rewind","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","name":"rewind","range":{"end":{"line":439,"character":9999},"start":{"character":0,"line":437}}},{"name":"get_parameter","range":{"end":{"character":9999,"line":457},"start":{"line":452,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"get_parameter($self,$param)","documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)","parameters":[{"label":"$self"},{"label":"$param"}]},"detail":"($self,$param)","kind":12,"children":[{"localvar":"my","containerName":"get_parameter","name":"$self","definition":"my","line":453,"kind":13},{"kind":13,"line":453,"containerName":"get_parameter","name":"$param"},{"kind":13,"line":454,"containerName":"get_parameter","name":"$param"},{"name":"$self","containerName":"get_parameter","kind":13,"line":455},{"kind":13,"line":456,"containerName":"get_parameter","name":"$self"},{"containerName":"get_parameter","name":"get_parameter","kind":12,"line":456},{"line":456,"kind":13,"name":"$param","containerName":"get_parameter"}],"line":452},{"kind":12,"line":455,"name":"_parameters"},{"line":456,"kind":12,"name":"_parameters"},{"range":{"end":{"line":473,"character":9999},"start":{"line":469,"character":0}},"name":"available_parameters","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"available_parameters","line":470,"kind":13},{"containerName":"available_parameters","name":"$self","line":471,"kind":13},{"name":"$self","containerName":"available_parameters","line":472,"kind":13},{"kind":12,"line":472,"name":"available_parameters","containerName":"available_parameters"}],"line":469,"kind":12},{"name":"_parameters","kind":12,"line":471},{"name":"_parameters","kind":12,"line":472},{"line":486,"children":[{"containerName":"add_parameter","definition":"my","name":"$self","localvar":"my","kind":13,"line":487},{"line":487,"kind":13,"containerName":"add_parameter","name":"$key"},{"containerName":"add_parameter","name":"$value","line":487,"kind":13},{"line":488,"kind":13,"containerName":"add_parameter","name":"$self"},{"containerName":"add_parameter","name":"$self","line":489,"kind":13},{"line":489,"kind":12,"containerName":"add_parameter","name":"new"},{"name":"$self","containerName":"add_parameter","line":491,"kind":13},{"containerName":"add_parameter","name":"set_parameter","kind":12,"line":491},{"name":"$key","containerName":"add_parameter","line":491,"kind":13},{"containerName":"add_parameter","name":"$value","line":491,"kind":13}],"kind":12,"detail":"($self,$key,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter","label":"add_parameter($self,$key,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":492},"start":{"line":486,"character":0}},"name":"add_parameter"},{"line":488,"kind":12,"name":"_parameters"},{"name":"_parameters","kind":12,"line":489},{"kind":12,"line":489,"name":"Bio","containerName":"Tools::Run::GenericParameters"},{"kind":12,"line":491,"name":"_parameters"},{"name":"get_statistic","range":{"end":{"character":9999,"line":510},"start":{"character":0,"line":505}},"definition":"sub","containerName":"main::","signature":{"label":"get_statistic($self,$stat)","parameters":[{"label":"$self"},{"label":"$stat"}],"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n    my ($self, $key, $value) = @_;\n    unless (exists $self->{_parameters}) {\n        $self->{_parameters} = Bio::Tools::Run::GenericParameters->new();\n    }\n    $self->{_parameters}->set_parameter($key => $value);\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)"},"detail":"($self,$stat)","kind":12,"children":[{"kind":13,"line":506,"containerName":"get_statistic","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":506,"name":"$stat","containerName":"get_statistic"},{"containerName":"get_statistic","name":"$stat","kind":13,"line":507},{"containerName":"get_statistic","name":"$self","kind":13,"line":508},{"name":"$self","containerName":"get_statistic","line":509,"kind":13},{"line":509,"kind":12,"containerName":"get_statistic","name":"get_statistic"},{"name":"$stat","containerName":"get_statistic","kind":13,"line":509}],"line":505},{"name":"_statistics","line":508,"kind":12},{"kind":12,"line":509,"name":"_statistics"},{"definition":"sub","name":"available_statistics","containerName":"main::","range":{"start":{"line":522,"character":0},"end":{"character":9999,"line":526}},"kind":12,"children":[{"containerName":"available_statistics","definition":"my","name":"$self","localvar":"my","kind":13,"line":523},{"kind":13,"line":524,"containerName":"available_statistics","name":"$self"},{"line":525,"kind":13,"containerName":"available_statistics","name":"$self"},{"name":"available_statistics","containerName":"available_statistics","line":525,"kind":12}],"line":522},{"kind":12,"line":524,"name":"_statistics"},{"name":"_statistics","kind":12,"line":525},{"name":"add_statistic","range":{"end":{"character":9999,"line":545},"start":{"character":0,"line":539}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n    my ($self, $key, $value) = @_;\n    unless (exists $self->{_parameters}) {\n        $self->{_parameters} = Bio::Tools::Run::GenericParameters->new();\n    }\n    $self->{_parameters}->set_parameter($key => $value);\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic {\n    my ($self, $stat) = @_;\n    $stat || return;\n    return unless defined $self->{_statistics};\n    return $self->{_statistics}->get_statistic($stat);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics {\n    my $self = shift;\n    return () unless defined $self->{_statistics};\n    return $self->{_statistics}->available_statistics;\n}\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $result->add_statistic('lambda', 2.3);\n Function: Adds a statistic\n Returns : none\n Args    : key  - key value name for this statistic\n           value - value for this statistic","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"label":"add_statistic($self,$key,$value)"},"detail":"($self,$key,$value)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_statistic","line":540,"kind":13},{"kind":13,"line":540,"containerName":"add_statistic","name":"$key"},{"kind":13,"line":540,"name":"$value","containerName":"add_statistic"},{"containerName":"add_statistic","name":"$self","kind":13,"line":541},{"name":"$self","containerName":"add_statistic","kind":13,"line":542},{"line":542,"kind":12,"name":"new","containerName":"add_statistic"},{"kind":13,"line":544,"containerName":"add_statistic","name":"$self"},{"line":544,"kind":12,"name":"set_statistic","containerName":"add_statistic"},{"line":544,"kind":13,"name":"$key","containerName":"add_statistic"},{"kind":13,"line":544,"containerName":"add_statistic","name":"$value"}],"line":539},{"name":"_statistics","line":541,"kind":12},{"name":"_statistics","line":542,"kind":12},{"line":542,"kind":12,"name":"Bio","containerName":"Search::GenericStatistics"},{"name":"_statistics","kind":12,"line":544}]}