{"vars":[{"line":124,"kind":2,"containerName":"","name":"base"},{"name":"next_hit","range":{"start":{"character":0,"line":139},"end":{"line":142,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"next_hit($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":140,"containerName":"next_hit","name":"$self","definition":"my","localvar":"my"},{"containerName":"next_hit","name":"@args","kind":13,"line":140},{"kind":13,"line":141,"name":"$self","containerName":"next_hit"},{"line":141,"kind":12,"containerName":"next_hit","name":"throw_not_implemented"}],"line":139},{"line":162,"children":[{"localvar":"my","containerName":"sort_hits","name":"$self","definition":"my","line":163,"kind":13},{"containerName":"sort_hits","name":"$coderef","line":163,"kind":13},{"kind":13,"line":164,"name":"@sorted_hits","definition":"my","containerName":"sort_hits","localvar":"my"},{"line":166,"kind":13,"containerName":"sort_hits","name":"$coderef"},{"name":"$self","containerName":"sort_hits","line":167,"kind":13},{"containerName":"sort_hits","name":"throw","line":167,"kind":12},{"kind":13,"line":168,"name":"$coderef","containerName":"sort_hits"},{"line":171,"kind":13,"containerName":"sort_hits","name":"$coderef"},{"line":175,"kind":13,"localvar":"my","containerName":"sort_hits","definition":"my","name":"@hits"},{"kind":13,"line":175,"name":"$self","containerName":"sort_hits"},{"name":"hits","containerName":"sort_hits","line":175,"kind":12},{"name":"@sorted_hits","containerName":"sort_hits","kind":13,"line":177},{"kind":13,"line":177,"name":"$coderef","containerName":"sort_hits"},{"line":177,"kind":13,"containerName":"sort_hits","name":"@hits"},{"containerName":"sort_hits","name":"$self","kind":13,"line":180},{"name":"throw","containerName":"sort_hits","kind":12,"line":180},{"containerName":"sort_hits","name":"$self","line":183,"kind":13},{"name":"@sorted_hits","containerName":"sort_hits","kind":13,"line":183},{"kind":13,"line":184,"name":"$self","containerName":"sort_hits"}],"kind":12,"detail":"($self,$coderef)","signature":{"parameters":[{"label":"$self"},{"label":"$coderef"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);","label":"sort_hits($self,$coderef)"},"containerName":"main::","definition":"sub","range":{"end":{"line":187,"character":9999},"start":{"character":0,"line":162}},"name":"sort_hits"},{"name":"_default_sort_hits","line":171,"kind":12},{"line":200,"children":[{"name":"$Bio","containerName":"_default_sort_hits","line":201,"kind":13},{"containerName":"_default_sort_hits","name":"score","kind":12,"line":201},{"name":"$Bio","containerName":"_default_sort_hits","line":202,"kind":13},{"containerName":"_default_sort_hits","name":"score","kind":12,"line":202}],"kind":12,"range":{"end":{"character":9999,"line":204},"start":{"character":0,"line":200}},"containerName":"main::","definition":"sub","name":"_default_sort_hits"},{"name":"Search","containerName":"Result::ResultI::b","line":201,"kind":12},{"line":202,"kind":12,"name":"Search","containerName":"Result::ResultI::a"},{"name":"query_name","range":{"end":{"character":9999,"line":220},"start":{"character":0,"line":217}},"kind":12,"line":217,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"query_name","line":218,"kind":13},{"containerName":"query_name","name":"@args","kind":13,"line":218},{"line":219,"kind":13,"name":"$self","containerName":"query_name"},{"containerName":"query_name","name":"throw_not_implemented","line":219,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"query_name($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"query_accession","range":{"start":{"line":232,"character":0},"end":{"character":9999,"line":235}},"kind":12,"children":[{"line":233,"kind":13,"localvar":"my","containerName":"query_accession","definition":"my","name":"$self"},{"name":"@args","containerName":"query_accession","line":233,"kind":13},{"kind":13,"line":234,"containerName":"query_accession","name":"$self"},{"containerName":"query_accession","name":"throw_not_implemented","line":234,"kind":12}],"line":232,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"query_accession($self,@args)"},"detail":"($self,@args)"},{"range":{"start":{"line":249,"character":0},"end":{"character":9999,"line":252}},"name":"query_length","children":[{"kind":13,"line":250,"containerName":"query_length","definition":"my","name":"$self","localvar":"my"},{"line":250,"kind":13,"containerName":"query_length","name":"@args"},{"name":"$self","containerName":"query_length","line":251,"kind":13},{"name":"throw_not_implemented","containerName":"query_length","line":251,"kind":12}],"line":249,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none","label":"query_length($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"name":"query_description","range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":268}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"query_description($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":265,"children":[{"kind":13,"line":266,"containerName":"query_description","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":266,"name":"@args","containerName":"query_description"},{"kind":13,"line":267,"containerName":"query_description","name":"$self"},{"name":"throw_not_implemented","containerName":"query_description","kind":12,"line":267}]},{"children":[{"kind":13,"line":283,"definition":"my","name":"$self","containerName":"database_name","localvar":"my"},{"name":"@args","containerName":"database_name","kind":13,"line":283},{"containerName":"database_name","name":"$self","kind":13,"line":285},{"containerName":"database_name","name":"throw_not_implemented","line":285,"kind":12}],"line":282,"kind":12,"signature":{"label":"database_name($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":286},"start":{"character":0,"line":282}},"name":"database_name"},{"line":301,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"database_letters","line":302,"kind":13},{"containerName":"database_letters","name":"@args","line":302,"kind":13},{"kind":13,"line":303,"containerName":"database_letters","name":"$self"},{"containerName":"database_letters","name":"throw_not_implemented","kind":12,"line":303}],"kind":12,"detail":"($self,@args)","signature":{"label":"database_letters($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":304},"start":{"line":301,"character":0}},"name":"database_letters"},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"database_entries($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":319,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"database_entries"},{"kind":13,"line":319,"containerName":"database_entries","name":"@args"},{"kind":13,"line":321,"name":"$self","containerName":"database_entries"},{"name":"throw_not_implemented","containerName":"database_entries","line":321,"kind":12}],"line":318,"kind":12,"range":{"end":{"character":9999,"line":322},"start":{"line":318,"character":0}},"name":"database_entries"},{"name":"get_parameter","range":{"end":{"character":9999,"line":338},"start":{"line":335,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)","label":"get_parameter($self,@args)"},"kind":12,"line":335,"children":[{"line":336,"kind":13,"localvar":"my","containerName":"get_parameter","name":"$self","definition":"my"},{"kind":13,"line":336,"containerName":"get_parameter","name":"@args"},{"containerName":"get_parameter","name":"$self","kind":13,"line":337},{"kind":12,"line":337,"containerName":"get_parameter","name":"throw_not_implemented"}]},{"range":{"end":{"line":353,"character":9999},"start":{"line":350,"character":0}},"name":"available_parameters","children":[{"kind":13,"line":351,"definition":"my","name":"$self","containerName":"available_parameters","localvar":"my"},{"name":"$self","containerName":"available_parameters","line":352,"kind":13},{"kind":12,"line":352,"containerName":"available_parameters","name":"throw_not_implemented"}],"line":350,"kind":12,"signature":{"label":"available_parameters($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":366,"character":0},"end":{"line":369,"character":9999}},"name":"get_statistic","children":[{"name":"$self","definition":"my","containerName":"get_statistic","localvar":"my","kind":13,"line":367},{"kind":13,"line":367,"containerName":"get_statistic","name":"@args"},{"name":"$self","containerName":"get_statistic","line":368,"kind":13},{"containerName":"get_statistic","name":"throw_not_implemented","kind":12,"line":368}],"line":366,"kind":12,"signature":{"label":"get_statistic($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"children":[{"line":382,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"available_statistics"},{"containerName":"available_statistics","name":"$self","line":383,"kind":13},{"containerName":"available_statistics","name":"throw_not_implemented","line":383,"kind":12}],"line":381,"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none","parameters":[{"label":"$self"}],"label":"available_statistics($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":384},"start":{"line":381,"character":0}},"name":"available_statistics"},{"name":"algorithm","range":{"start":{"line":396,"character":0},"end":{"line":399,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value","label":"algorithm($self)"},"kind":12,"line":396,"children":[{"kind":13,"line":397,"containerName":"algorithm","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"algorithm","line":398,"kind":13},{"line":398,"kind":12,"containerName":"algorithm","name":"throw_not_implemented"}]},{"kind":12,"children":[{"line":412,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"algorithm_version"},{"name":"$self","containerName":"algorithm_version","line":413,"kind":13},{"kind":12,"line":413,"name":"throw_not_implemented","containerName":"algorithm_version"}],"line":411,"definition":"sub","containerName":"main::","signature":{"label":"algorithm_version($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value","parameters":[{"label":"$self"}]},"detail":"($self)","name":"algorithm_version","range":{"end":{"character":9999,"line":414},"start":{"character":0,"line":411}}},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.","parameters":[{"label":"$self"}],"label":"algorithm_reference($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":431,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"algorithm_reference"}],"line":430,"kind":12,"range":{"start":{"line":430,"character":0},"end":{"character":9999,"line":433}},"name":"algorithm_reference"},{"name":"num_hits","range":{"start":{"line":446,"character":0},"end":{"line":449,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference{\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none","label":"num_hits($self,@args)"},"kind":12,"line":446,"children":[{"line":447,"kind":13,"localvar":"my","containerName":"num_hits","name":"$self","definition":"my"},{"line":447,"kind":13,"containerName":"num_hits","name":"@args"},{"kind":13,"line":448,"name":"$self","containerName":"num_hits"},{"containerName":"num_hits","name":"throw_not_implemented","line":448,"kind":12}]},{"range":{"end":{"line":466,"character":9999},"start":{"character":0,"line":463}},"name":"hits","line":463,"children":[{"line":464,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"hits"},{"kind":13,"line":464,"containerName":"hits","name":"@args"},{"kind":13,"line":465,"name":"$self","containerName":"hits"},{"name":"throw_not_implemented","containerName":"hits","line":465,"kind":12}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: ResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::ResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::ResultI - Abstract interface to Search Result objects\n\n=head1 SYNOPSIS\n\n# Bio::Search::Result::ResultI objects cannot be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Result::ResultI  interface,\n# you can do the following things with it:\n\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    my $result = $io->next_result;\n    while( $hit = $result->next_hit()) { # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $dbname = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('gapext');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>  (original author)\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Result::ResultI;\n\nuse strict;\n\n\nuse base qw(Bio::AnalysisResultI);\n\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort() \n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Result::ResultI namespace. \n                  For example, use : \n                  $result->sort_hits( sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t      $Bio::Search::Result::ResultI::b->length});\n                   NOT $result->sort_hits($a->length <=>$b->length);\n\n\nsub sort_hits {\n    my ($self, $coderef) = @_;\n    my @sorted_hits;\n\n    if ($coderef)  {\n\t$self->throw('sort_hits requires a sort function passed as a subroutine reference')\n\t    unless (ref($coderef) eq 'CODE');\n    }\n    else {\n\t$coderef = \\&_default_sort_hits;\n\t# throw a warning?\n    }\n\n    my @hits = $self->hits();\n    \n    eval {@sorted_hits = sort $coderef @hits };\n\n   if ($@) {\n       $self->throw(\"Unable to sort hits: $@\");\n   }\n   else {\n       $self->{'_hits'} = \\@sorted_hits;\n       $self->{'_no_iterations'} = 1; # to bypass iteration checking in hits() method\n       1;\n   }\n}\n\n=head2 _default sort_hits\n\n  Title\t: _default_sort_hits\n  Usage\t: Do not call directly.\n  Function: Sort hits in descending order by score\n  Args\t: None\n  Returns: 1 on success\n  Note\t: Used by $result->sort_hits()\n\n\nsub _default_sort_hits {\n    $Bio::Search::Result::ResultI::b->score <=> \n\t    $Bio::Search::Result::ResultI::a->score;\n\n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\n\nsub database_letters {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\n\nsub database_entries {\n    my ($self,@args) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference{\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\n\nsub num_hits{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>","label":"hits($self,@args)"},"containerName":"main::","definition":"sub"},{"containerName":"main::","name":"no_hits_found","definition":"sub","range":{"end":{"character":9999,"line":488},"start":{"character":0,"line":488}},"kind":12,"line":488,"children":[{"kind":12,"line":488,"containerName":"no_hits_found","name":"throw_not_implemented"}]},{"line":502,"children":[{"kind":12,"line":502,"containerName":"set_no_hits_found","name":"throw_not_implemented"}],"kind":12,"range":{"end":{"character":9999,"line":502},"start":{"character":0,"line":502}},"containerName":"main::","definition":"sub","name":"set_no_hits_found"}],"version":5}