{"vars":[{"name":"vars","containerName":"","kind":2,"line":84},{"line":96,"kind":13,"containerName":null,"name":"%MODEMAP"},{"kind":2,"line":96,"containerName":"","name":"POSIX"},{"containerName":null,"name":"@STATES","kind":13,"line":100},{"line":101,"kind":13,"name":"%MAPPING","containerName":null},{"kind":2,"line":125,"name":"base","containerName":""},{"detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"containerName":"main::","definition":"sub","line":137,"children":[{"containerName":"_initialize","definition":"my","name":"$self","localvar":"my","kind":13,"line":138},{"containerName":"_initialize","name":"@args","kind":13,"line":138},{"line":139,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"@args","line":139,"kind":13},{"line":140,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":140,"containerName":"_initialize","name":"_eventHandler"},{"name":"register_factory","containerName":"_initialize","kind":12,"line":140},{"kind":12,"line":140,"name":"new","containerName":"_initialize"},{"kind":13,"line":142,"name":"$self","containerName":"_initialize"},{"kind":12,"line":142,"name":"_eventHandler","containerName":"_initialize"},{"containerName":"_initialize","name":"register_factory","kind":12,"line":142},{"line":142,"kind":12,"containerName":"_initialize","name":"new"}],"kind":12,"range":{"end":{"line":143,"character":9999},"start":{"line":137,"character":0}},"name":"_initialize"},{"kind":12,"line":139,"containerName":"_initialize","name":"SUPER"},{"kind":12,"line":140,"name":"Bio","containerName":"Search::Result::ResultFactory"},{"kind":12,"line":142,"containerName":"Search::HSP::HSPFactory","name":"Bio"},{"kind":12,"line":156,"children":[{"definition":"my","name":"$self","containerName":"next_result","localvar":"my","kind":13,"line":157},{"kind":13,"line":161,"containerName":"next_result","name":"$curquery","definition":"my","localvar":"my"},{"kind":13,"line":161,"containerName":"next_result","name":"$curhit"},{"line":162,"kind":13,"localvar":"my","name":"$state","definition":"my","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":163,"kind":13},{"line":163,"kind":12,"containerName":"next_result","name":"start_document"},{"line":164,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@hit_signifs"},{"kind":13,"line":165,"name":"$self","containerName":"next_result"},{"line":165,"kind":12,"containerName":"next_result","name":"_readline"},{"name":"$state","containerName":"next_result","line":167,"kind":13},{"line":168,"kind":13,"localvar":"my","name":"$qid","definition":"my","containerName":"next_result"},{"kind":13,"line":168,"name":"$qhspid","containerName":"next_result"},{"containerName":"next_result","name":"$qpercent","kind":13,"line":168},{"name":"$junk","containerName":"next_result","kind":13,"line":168},{"containerName":"next_result","name":"$alnlen","kind":13,"line":169},{"line":169,"kind":13,"name":"$qdb","containerName":"next_result"},{"kind":13,"line":169,"name":"$qacc","containerName":"next_result"},{"name":"$qstart","containerName":"next_result","kind":13,"line":169},{"line":169,"kind":13,"name":"$qend","containerName":"next_result"},{"name":"$qstrand","containerName":"next_result","kind":13,"line":169},{"containerName":"next_result","name":"$hitdb","kind":13,"line":170},{"containerName":"next_result","name":"$hacc","kind":13,"line":170},{"line":170,"kind":13,"name":"$hstart","containerName":"next_result"},{"line":170,"kind":13,"name":"$hend","containerName":"next_result"},{"containerName":"next_result","name":"$hstrand","line":171,"kind":13},{"containerName":"next_result","name":"$hstart","line":184,"kind":13},{"name":"$hstart","containerName":"next_result","kind":13,"line":184},{"containerName":"next_result","name":"$hend","kind":13,"line":185},{"name":"$hend","containerName":"next_result","kind":13,"line":185},{"line":186,"kind":13,"containerName":"next_result","name":"$qstart"},{"containerName":"next_result","name":"$qstart","kind":13,"line":186},{"name":"$qend","containerName":"next_result","kind":13,"line":187},{"containerName":"next_result","name":"$qend","kind":13,"line":187},{"line":188,"kind":13,"name":"$hstart","containerName":"next_result"},{"containerName":"next_result","name":"$hend","kind":13,"line":188},{"name":"$qstart","containerName":"next_result","line":188,"kind":13},{"kind":13,"line":188,"containerName":"next_result","name":"$qend"},{"kind":13,"line":189,"name":"$alnlen","containerName":"next_result"},{"kind":13,"line":190,"containerName":"next_result","name":"$self"},{"name":"warn","containerName":"next_result","kind":12,"line":190},{"kind":13,"line":193,"containerName":"next_result","name":"$self"},{"line":195,"kind":13,"name":"$curquery","containerName":"next_result"},{"kind":13,"line":196,"containerName":"next_result","name":"$curquery"},{"name":"$qid","containerName":"next_result","kind":13,"line":196},{"kind":13,"line":197,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"end_element","kind":12,"line":197},{"name":"$self","containerName":"next_result","line":198,"kind":13},{"kind":12,"line":198,"containerName":"next_result","name":"_pushback"},{"name":"$self","containerName":"next_result","line":199,"kind":13},{"kind":12,"line":199,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","kind":13,"line":200},{"name":"end_document","containerName":"next_result","line":200,"kind":12},{"line":203,"kind":13,"containerName":"next_result","name":"$curhit"},{"line":204,"kind":13,"name":"$curhit","containerName":"next_result"},{"name":"$hacc","containerName":"next_result","line":204,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":206},{"containerName":"next_result","name":"end_element","line":206,"kind":12},{"containerName":"next_result","name":"$self","line":207,"kind":13},{"line":207,"kind":12,"containerName":"next_result","name":"start_element"},{"kind":13,"line":208,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","line":208,"kind":12},{"line":209,"kind":13,"name":"$hacc","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":210},{"containerName":"next_result","name":"element","kind":12,"line":210},{"name":"$hacc","containerName":"next_result","line":211,"kind":13},{"line":213,"kind":13,"containerName":"next_result","name":"$curquery"},{"line":214,"kind":13,"name":"$self","containerName":"next_result"},{"name":"start_element","containerName":"next_result","kind":12,"line":214},{"name":"$self","containerName":"next_result","kind":13,"line":215},{"kind":13,"line":216,"containerName":"next_result","name":"$self"},{"kind":12,"line":216,"name":"element","containerName":"next_result"},{"name":"$qid","containerName":"next_result","kind":13,"line":217},{"containerName":"next_result","name":"$self","line":218,"kind":13},{"kind":12,"line":218,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":220},{"line":220,"kind":12,"containerName":"next_result","name":"element"},{"name":"$qdb","containerName":"next_result","kind":13,"line":221},{"kind":13,"line":222,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":222},{"containerName":"next_result","name":"$hitdb","kind":13,"line":223},{"name":"$self","containerName":"next_result","line":226,"kind":13},{"name":"start_element","containerName":"next_result","line":226,"kind":12},{"containerName":"next_result","name":"$self","line":227,"kind":13},{"kind":12,"line":227,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$hacc","kind":13,"line":228},{"kind":13,"line":229,"containerName":"next_result","name":"$self"},{"kind":12,"line":229,"name":"element","containerName":"next_result"},{"kind":13,"line":230,"containerName":"next_result","name":"$hacc"},{"kind":13,"line":236,"name":"$qstrand","containerName":"next_result"},{"name":"$qstart","containerName":"next_result","line":237,"kind":13},{"kind":13,"line":237,"containerName":"next_result","name":"$qend"},{"name":"$qend","containerName":"next_result","kind":13,"line":237},{"name":"$qstart","containerName":"next_result","line":237,"kind":13},{"kind":13,"line":239,"containerName":"next_result","name":"$hstrand"},{"name":"$hstart","containerName":"next_result","kind":13,"line":240},{"kind":13,"line":240,"containerName":"next_result","name":"$hend"},{"line":240,"kind":13,"containerName":"next_result","name":"$hend"},{"containerName":"next_result","name":"$hstart","kind":13,"line":240},{"kind":13,"line":243,"containerName":"next_result","name":"$self"},{"name":"start_element","containerName":"next_result","line":243,"kind":12},{"containerName":"next_result","name":"$self","line":244,"kind":13},{"line":244,"kind":12,"name":"element","containerName":"next_result"},{"name":"$qstart","containerName":"next_result","line":245,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":246},{"containerName":"next_result","name":"element","line":246,"kind":12},{"line":247,"kind":13,"name":"$qend","containerName":"next_result"},{"line":248,"kind":13,"containerName":"next_result","name":"$self"},{"line":248,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$hstart","line":249,"kind":13},{"line":250,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":250,"kind":12},{"name":"$hend","containerName":"next_result","line":251,"kind":13},{"kind":13,"line":252,"containerName":"next_result","name":"$self"},{"line":252,"kind":12,"containerName":"next_result","name":"element"},{"line":253,"kind":13,"name":"$alnlen","containerName":"next_result"},{"containerName":"next_result","name":"$curquery","line":255,"kind":13},{"kind":13,"line":255,"name":"$qid","containerName":"next_result"},{"line":256,"kind":13,"name":"$curhit","containerName":"next_result"},{"line":256,"kind":13,"name":"$hacc","containerName":"next_result"},{"line":257,"kind":13,"containerName":"next_result","name":"$state"},{"name":"$curquery","containerName":"next_result","line":258,"kind":13},{"name":"$self","containerName":"next_result","line":259,"kind":13},{"line":259,"kind":12,"name":"warn","containerName":"next_result"},{"kind":13,"line":263,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":263,"kind":12},{"name":"$STATES","containerName":"next_result","line":263,"kind":13},{"name":"$state","containerName":"next_result","kind":13,"line":263},{"name":"$state","containerName":"next_result","line":265,"kind":13},{"name":"@STATES","containerName":"next_result","line":265,"kind":13},{"containerName":"next_result","name":"$state","kind":13,"line":266},{"line":267,"kind":13,"containerName":"next_result","name":"$self"},{"line":267,"kind":12,"containerName":"next_result","name":"end_element"},{"line":271,"kind":13,"name":"$curquery","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":272},{"line":272,"kind":12,"name":"end_element","containerName":"next_result"},{"line":273,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":273,"containerName":"next_result","name":"end_element"},{"line":274,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"end_document","kind":12,"line":274}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"name":"next_result","range":{"start":{"character":0,"line":156},"end":{"line":277,"character":9999}}},{"range":{"end":{"line":301,"character":9999},"start":{"line":290,"character":0}},"name":"start_element","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"line":291,"kind":13,"localvar":"my","containerName":"start_element","name":"$self","definition":"my"},{"kind":13,"line":291,"containerName":"start_element","name":"$data"},{"localvar":"my","containerName":"start_element","definition":"my","name":"$nm","line":293,"kind":13},{"kind":13,"line":293,"containerName":"start_element","name":"$data"},{"containerName":"start_element","name":"$type","definition":"my","localvar":"my","kind":13,"line":294},{"line":294,"kind":13,"name":"$MODEMAP","containerName":"start_element"},{"name":"$nm","containerName":"start_element","kind":13,"line":294},{"kind":13,"line":295,"containerName":"start_element","name":"$self"},{"name":"_mode","containerName":"start_element","line":295,"kind":12},{"name":"$type","containerName":"start_element","kind":13,"line":295},{"name":"$self","containerName":"start_element","line":296,"kind":13},{"line":296,"kind":12,"name":"_eventHandler","containerName":"start_element"},{"name":"will_handle","containerName":"start_element","line":296,"kind":12},{"line":296,"kind":13,"name":"$type","containerName":"start_element"},{"containerName":"start_element","definition":"my","name":"$func","localvar":"my","kind":13,"line":297},{"line":297,"kind":13,"containerName":"start_element","name":"$type"},{"line":298,"kind":13,"name":"$self","containerName":"start_element"},{"line":298,"kind":12,"name":"_eventHandler","containerName":"start_element"},{"line":298,"kind":13,"name":"$func","containerName":"start_element"},{"line":298,"kind":13,"name":"$data","containerName":"start_element"},{"kind":13,"line":300,"containerName":"start_element","name":"$self"},{"name":"$type","containerName":"start_element","line":300,"kind":13}],"line":290,"kind":12},{"name":"%nm","containerName":null,"kind":13,"line":302},{"name":"%self","containerName":null,"kind":13,"line":303},{"line":304,"kind":13,"name":"%self","containerName":null},{"line":305,"kind":13,"containerName":null,"name":"%self"},{"name":"end_element","range":{"start":{"character":0,"line":321},"end":{"character":9999,"line":343}},"kind":12,"children":[{"kind":13,"line":322,"definition":"my","name":"$self","containerName":"end_element","localvar":"my"},{"name":"$data","containerName":"end_element","line":322,"kind":13},{"line":323,"kind":13,"localvar":"my","name":"$nm","definition":"my","containerName":"end_element"},{"line":323,"kind":13,"containerName":"end_element","name":"$data"},{"kind":13,"line":324,"containerName":"end_element","definition":"my","name":"$rc","localvar":"my"},{"name":"$nm","containerName":"end_element","kind":13,"line":327},{"kind":13,"line":329,"name":"$self","containerName":"end_element"},{"kind":12,"line":329,"containerName":"end_element","name":"element"},{"name":"$self","containerName":"end_element","line":330,"kind":13},{"name":"$self","containerName":"end_element","kind":13,"line":332},{"name":"$type","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":335},{"line":335,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"kind":13,"line":335,"name":"$nm","containerName":"end_element"},{"kind":13,"line":336,"containerName":"end_element","name":"$self"},{"kind":12,"line":336,"name":"_eventHandler","containerName":"end_element"},{"name":"will_handle","containerName":"end_element","kind":12,"line":336},{"name":"$type","containerName":"end_element","line":336,"kind":13},{"kind":13,"line":337,"name":"$func","definition":"my","containerName":"end_element","localvar":"my"},{"containerName":"end_element","name":"$type","kind":13,"line":337},{"kind":13,"line":338,"name":"$rc","containerName":"end_element"},{"kind":13,"line":338,"containerName":"end_element","name":"$self"},{"containerName":"end_element","name":"_eventHandler","kind":12,"line":338},{"containerName":"end_element","name":"$func","kind":13,"line":338},{"name":"$self","containerName":"end_element","line":338,"kind":13},{"name":"$self","containerName":"end_element","line":339,"kind":13},{"kind":13,"line":341,"name":"$self","containerName":"end_element"}],"line":321,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"end_element($self,$data)"},"detail":"($self,$data)"},{"name":"%MAPPING","containerName":null,"kind":13,"line":343},{"containerName":null,"name":"%nm","line":343,"kind":13},{"name":"%MAPPING","containerName":null,"kind":13,"line":344},{"containerName":null,"name":"%nm","kind":13,"line":344},{"localvar":"my","definition":"my","name":"$key","containerName":null,"line":345,"kind":13},{"line":345,"kind":13,"containerName":null,"name":"%MAPPING"},{"containerName":null,"name":"@nm","line":345,"kind":13},{"containerName":null,"name":"%self","line":346,"kind":13},{"name":"%key","containerName":null,"line":346,"kind":13},{"kind":13,"line":346,"containerName":null,"name":"%MAPPING"},{"line":346,"kind":13,"containerName":null,"name":"%nm"},{"containerName":null,"name":"$key","kind":13,"line":346},{"containerName":null,"name":"%self","line":346,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":348},{"containerName":null,"name":"%MAPPING","line":348,"kind":13},{"name":"$nm","containerName":null,"kind":13,"line":348},{"containerName":null,"name":"%self","line":348,"kind":13},{"kind":13,"line":351,"containerName":null,"name":"$self"},{"line":351,"kind":12,"containerName":"main::","name":"warn"},{"kind":13,"line":353,"name":"%self","containerName":null},{"kind":13,"line":355,"name":"%self","containerName":null},{"containerName":null,"name":"$rc","line":355,"kind":13},{"name":"$nm","containerName":null,"kind":13,"line":355},{"containerName":null,"name":"$rc","kind":13,"line":356},{"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"},"kind":12,"line":371,"children":[{"name":"$self","definition":"my","containerName":"element","localvar":"my","kind":13,"line":372},{"name":"$data","containerName":"element","kind":13,"line":372},{"line":373,"kind":13,"containerName":"element","name":"$self"},{"containerName":"element","name":"start_element","kind":12,"line":373},{"name":"$data","containerName":"element","line":373,"kind":13},{"kind":13,"line":374,"name":"$self","containerName":"element"},{"line":374,"kind":12,"containerName":"element","name":"characters"},{"containerName":"element","name":"$data","line":374,"kind":13},{"name":"$self","containerName":"element","line":375,"kind":13},{"kind":12,"line":375,"containerName":"element","name":"end_element"},{"line":375,"kind":13,"name":"$data","containerName":"element"}],"name":"element","range":{"start":{"character":0,"line":371},"end":{"line":376,"character":9999}}},{"range":{"end":{"character":9999,"line":405},"start":{"character":0,"line":390}},"name":"characters","children":[{"kind":13,"line":391,"definition":"my","name":"$self","containerName":"characters","localvar":"my"},{"name":"$data","containerName":"characters","kind":13,"line":391},{"containerName":"characters","name":"$data","line":393,"kind":13},{"kind":13,"line":394,"name":"$data","containerName":"characters"},{"line":395,"kind":13,"name":"$data","containerName":"characters"},{"name":"$self","containerName":"characters","line":398,"kind":13},{"name":"in_element","containerName":"characters","kind":12,"line":398},{"containerName":"characters","name":"$data","kind":13,"line":399},{"containerName":"characters","name":"$self","line":401,"kind":13},{"line":401,"kind":13,"containerName":"characters","name":"$data"},{"containerName":"characters","name":"$data","line":401,"kind":13},{"line":404,"kind":13,"name":"$self","containerName":"characters"},{"line":404,"kind":13,"containerName":"characters","name":"$data"}],"line":390,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","label":"characters($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":419},"end":{"line":425,"character":9999}},"name":"_mode","line":419,"children":[{"line":420,"kind":13,"localvar":"my","containerName":"_mode","definition":"my","name":"$self"},{"line":420,"kind":13,"name":"$value","containerName":"_mode"},{"line":421,"kind":13,"containerName":"_mode","name":"$value"},{"containerName":"_mode","name":"$self","kind":13,"line":422},{"line":422,"kind":13,"containerName":"_mode","name":"$value"},{"kind":13,"line":424,"containerName":"_mode","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_mode($self,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"within_element($self,$name)"},"detail":"($self,$name)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"within_element","localvar":"my","kind":13,"line":441},{"kind":13,"line":441,"name":"$name","containerName":"within_element"},{"kind":13,"line":442,"name":"$name","containerName":"within_element"},{"containerName":"within_element","name":"$self","line":443,"kind":13},{"name":"$self","containerName":"within_element","kind":13,"line":444}],"line":440,"name":"within_element","range":{"start":{"character":0,"line":440},"end":{"character":9999,"line":444}}},{"name":"%self","containerName":null,"line":445,"kind":13},{"kind":13,"line":446,"containerName":null,"name":"%name"},{"name":"in_element","range":{"end":{"line":470,"character":9999},"start":{"line":466,"character":0}},"kind":12,"children":[{"line":467,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"in_element"},{"name":"$name","containerName":"in_element","line":467,"kind":13},{"name":"$self","containerName":"in_element","kind":13,"line":468},{"line":469,"kind":13,"name":"$self","containerName":"in_element"},{"name":"$name","containerName":"in_element","kind":13,"line":469}],"line":466,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"detail":"($self,$name)"},{"name":"start_document","range":{"end":{"character":9999,"line":491},"start":{"line":484,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none"},"kind":12,"line":484,"children":[{"containerName":"start_document","definition":"my","name":"$self","localvar":"my","kind":13,"line":485},{"line":486,"kind":13,"containerName":"start_document","name":"$self"},{"kind":13,"line":487,"name":"$self","containerName":"start_document"},{"line":488,"kind":13,"name":"$self","containerName":"start_document"},{"line":489,"kind":13,"name":"$self","containerName":"start_document"},{"kind":13,"line":490,"name":"$self","containerName":"start_document"}]},{"name":"end_document","range":{"start":{"line":505,"character":0},"end":{"line":508,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"kind":12,"line":505,"children":[{"kind":13,"line":506,"containerName":"end_document","definition":"my","name":"$self","localvar":"my"},{"line":506,"kind":13,"containerName":"end_document","name":"@args"},{"kind":13,"line":507,"containerName":"end_document","name":"$self"}]},{"name":"result_count","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":524},"start":{"character":0,"line":521}},"kind":12,"children":[{"containerName":"result_count","definition":"my","name":"$self","localvar":"my","kind":13,"line":522},{"name":"$self","containerName":"result_count","line":523,"kind":13}],"line":521},{"range":{"end":{"line":526,"character":9999},"start":{"character":0,"line":526}},"containerName":"main::","name":"report_count","definition":"sub","line":526,"children":[{"containerName":"report_count","name":"result_count","kind":12,"line":526}],"kind":12}],"version":5}