{"version":5,"vars":[{"kind":2,"line":97,"name":"base","containerName":""},{"range":{"start":{"character":0,"line":113},"end":{"line":126,"character":9999}},"name":"new","line":113,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":114,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":114},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":116},{"containerName":"new","name":"$class","line":116,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":116},{"name":"$stream","definition":"my","containerName":"new","localvar":"my","kind":13,"line":118},{"kind":13,"line":118,"containerName":"new","name":"$fact"},{"containerName":"new","name":"$self","line":119,"kind":13},{"line":119,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":119},{"kind":13,"line":121,"containerName":"new","name":"$self"},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":122,"name":"sequence_factory","containerName":"new"},{"line":122,"kind":13,"containerName":"new","name":"$fact"},{"containerName":"new","name":"$fact","line":122,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":123},{"name":"source_stream","containerName":"new","line":123,"kind":12},{"kind":13,"line":123,"containerName":"new","name":"$stream"},{"line":123,"kind":13,"name":"$stream","containerName":"new"},{"kind":13,"line":125,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BaseSeqProcessor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::BaseSeqProcessor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::BaseSeqProcessor - Base implementation for a SequenceProcessor\n\n=head1 SYNOPSIS\n\n    # you need to derive your own processor from this one\n\n=head1 DESCRIPTION\n\nThis provides just a basic framework for implementations of\nL<Bio::Factory::SequenceProcessorI>.\n\nEssentially what it does is support a parameter to new() to set\nsequence factory and source stream, and a next_seq() implementation\nthat will use a queue to be filled by a class overriding\nprocess_seq().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::BaseSeqProcessor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceProcessorI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::BaseSeqProcessor->new();\n Function: Builds a new Bio::Seq::BaseSeqProcessor object \n Returns : an instance of Bio::Seq::BaseSeqProcessor\n Args    : Named parameters. Currently supported are\n             -seqfactory  the Bio::Factory::SequenceFactoryI object to use\n             -source_stream the Bio::Factory::SequenceStreamI object to\n                          which we are chained"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":116},{"children":[{"containerName":"source_stream","name":"$self","definition":"my","localvar":"my","kind":13,"line":148},{"line":151,"kind":13,"localvar":"my","containerName":"source_stream","definition":"my","name":"$stream"},{"localvar":"my","containerName":"source_stream","name":"$fact","definition":"my","line":152,"kind":13},{"kind":13,"line":152,"name":"$stream","containerName":"source_stream"},{"kind":12,"line":152,"containerName":"source_stream","name":"sequence_factory"},{"name":"$self","containerName":"source_stream","line":153,"kind":13},{"kind":12,"line":153,"name":"sequence_factory","containerName":"source_stream"},{"kind":13,"line":153,"containerName":"source_stream","name":"$fact"},{"containerName":"source_stream","name":"$self","line":154,"kind":13},{"name":"sequence_factory","containerName":"source_stream","line":154,"kind":12},{"name":"$fact","containerName":"source_stream","line":154,"kind":13},{"name":"$self","containerName":"source_stream","kind":13,"line":155},{"containerName":"source_stream","name":"$stream","line":155,"kind":13},{"containerName":"source_stream","name":"$self","line":157,"kind":13}],"line":147,"kind":12,"range":{"end":{"line":158,"character":9999},"start":{"line":147,"character":0}},"definition":"sub","name":"source_stream","containerName":"main::"},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"next_seq","localvar":"my","kind":13,"line":183},{"line":184,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","line":187,"kind":13}],"line":182,"name":"next_seq","definition":"sub","containerName":"main::","range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":187}}},{"containerName":null,"definition":"my","name":"@seqs","localvar":"my","kind":13,"line":188},{"containerName":null,"name":"$seq","line":189,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":189},{"containerName":"main::","name":"source_stream","line":189,"kind":12},{"line":189,"kind":12,"name":"next_seq","containerName":"main::"},{"name":"@seqs","containerName":null,"kind":13,"line":190},{"kind":13,"line":190,"containerName":null,"name":"$self"},{"containerName":"main::","name":"process_seq","kind":12,"line":190},{"kind":13,"line":190,"containerName":null,"name":"$seq"},{"containerName":null,"name":"@seqs","line":192,"kind":13},{"line":194,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"@seqs","line":194,"kind":13},{"name":"@seqs","containerName":null,"line":194,"kind":13},{"name":"$seq","containerName":null,"kind":13,"line":197},{"name":"%self","containerName":null,"kind":13,"line":197},{"line":198,"kind":13,"containerName":null,"name":"$seq"},{"name":"write_seq","range":{"start":{"line":222,"character":0},"end":{"character":9999,"line":232}},"kind":12,"line":222,"children":[{"localvar":"my","containerName":"write_seq","name":"$self","definition":"my","line":223,"kind":13},{"name":"@seqs","containerName":"write_seq","line":223,"kind":13},{"kind":13,"line":224,"definition":"my","name":"$ret","containerName":"write_seq","localvar":"my"},{"name":"$seq","definition":"my","containerName":"write_seq","localvar":"my","kind":13,"line":225},{"line":225,"kind":13,"containerName":"write_seq","name":"@seqs"},{"name":"$processed","definition":"my","containerName":"write_seq","localvar":"my","kind":13,"line":226},{"kind":13,"line":226,"name":"$self","containerName":"write_seq"},{"line":226,"kind":12,"name":"process_seq","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":226},{"line":227,"kind":13,"name":"$ret","containerName":"write_seq"},{"line":227,"kind":13,"name":"$self","containerName":"write_seq"},{"line":227,"kind":12,"containerName":"write_seq","name":"source_stream"},{"containerName":"write_seq","name":"write_seq","kind":12,"line":227},{"name":"$seq","containerName":"write_seq","line":227,"kind":13},{"line":228,"kind":13,"containerName":"write_seq","name":"$ret"},{"containerName":"write_seq","name":"$ret","line":231,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@seqs)","signature":{"documentation":"1;\n# $Id: BaseSeqProcessor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::BaseSeqProcessor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::BaseSeqProcessor - Base implementation for a SequenceProcessor\n\n=head1 SYNOPSIS\n\n    # you need to derive your own processor from this one\n\n=head1 DESCRIPTION\n\nThis provides just a basic framework for implementations of\nL<Bio::Factory::SequenceProcessorI>.\n\nEssentially what it does is support a parameter to new() to set\nsequence factory and source stream, and a next_seq() implementation\nthat will use a queue to be filled by a class overriding\nprocess_seq().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::BaseSeqProcessor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceProcessorI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::BaseSeqProcessor->new();\n Function: Builds a new Bio::Seq::BaseSeqProcessor object \n Returns : an instance of Bio::Seq::BaseSeqProcessor\n Args    : Named parameters. Currently supported are\n             -seqfactory  the Bio::Factory::SequenceFactoryI object to use\n             -source_stream the Bio::Factory::SequenceStreamI object to\n                          which we are chained\n\n\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    my ($stream,$fact) =\n\t$self->_rearrange([qw(SOURCE_STREAM SEQFACTORY)], @args);\n\n    $self->{'_queue'} = [];\n    $self->sequence_factory($fact) if $fact;\n    $self->source_stream($stream) if $stream;\n    \n    return $self;\n}\n\n=head1 L<Bio::Factory::SequenceProcessorI> methods\n\n\n=head2 source_stream\n\n Title   : source_stream\n Usage   : $obj->source_stream($newval)\n Function: Get/set the source sequence stream for this sequence\n           processor.\n\n Example : \n Returns : A Bio::Factory::SequenceStreamI compliant object\n Args    : on set, new value (a Bio::Factory::SequenceStreamI compliant\n           object)\n\n\n\nsub source_stream{\n    my $self = shift;\n\n    if(@_) {\n\tmy $stream = shift;\n\tmy $fact = $stream->sequence_factory();\n\t$self->sequence_factory($fact)\n\t    unless $self->sequence_factory() || (! $fact);\n\treturn $self->{'source_stream'} = $stream;\n    }\n    return $self->{'source_stream'};\n}\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = stream->next_seq\n Function: Reads the next sequence object from the stream and returns it.\n\n           This implementation will obtain objects from the source\n           stream as necessary and pass them to process_seq() for\n           processing. This method will return the objects one at a\n           time that process_seq() returns.\n\n Returns : a Bio::Seq sequence object\n Args    : none\n\nSee L<Bio::Factory::SequenceStreamI::next_seq>\n\n\nsub next_seq{\n    my $self = shift;\n    my $seq;\n\n    # if the queue is empty, fetch next from source and process it\n    if(@{$self->{'_queue'}} == 0) {\n\tmy @seqs = ();\n\twhile($seq = $self->source_stream->next_seq()) {\n\t    @seqs = $self->process_seq($seq);\n\t    # we may get zero seqs returned\n\t    last if @seqs;\n\t}\n\tpush(@{$self->{'_queue'}}, @seqs) if @seqs;\n    }\n    # take next from the queue of seqs\n    $seq = shift(@{$self->{'_queue'}});\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: Writes the result(s) of processing the sequence object into\n           the stream.\n\n           You need to override this method in order not to alter\n           (process) sequence objects before output.\n\n Returns : 1 for success and 0 for error. The method stops attempting\n           to write objects after the first error returned from the\n           source stream. Otherwise the return value is the value\n           returned from the source stream from writing the last\n           object resulting from processing the last sequence object\n           given as argument.\n\n Args    : Bio::SeqI object, or an array of such objects","parameters":[{"label":"$self"},{"label":"@seqs"}],"label":"write_seq($self,@seqs)"}},{"containerName":"main::","definition":"sub","name":"sequence_factory","range":{"start":{"line":245,"character":0},"end":{"line":250,"character":9999}},"kind":12,"line":245,"children":[{"line":246,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"sequence_factory"},{"containerName":"sequence_factory","name":"$self","line":248,"kind":13},{"line":249,"kind":13,"containerName":"sequence_factory","name":"$self"}]},{"line":265,"children":[{"line":266,"kind":12,"name":"sequence_factory","containerName":"object_factory"}],"kind":12,"range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":267}},"containerName":"main::","definition":"sub","name":"object_factory"},{"containerName":"main::","name":"close","definition":"sub","range":{"end":{"line":285,"character":9999},"start":{"character":0,"line":282}},"kind":12,"line":282,"children":[{"line":283,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"close"},{"kind":13,"line":284,"containerName":"close","name":"$self"},{"kind":12,"line":284,"name":"source_stream","containerName":"close"},{"kind":13,"line":284,"containerName":"close","name":"$self"},{"name":"source_stream","containerName":"close","kind":12,"line":284},{"containerName":"close","name":"close","line":284,"kind":12}]},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"process_seq","line":317,"kind":13},{"name":"$seq","containerName":"process_seq","line":317,"kind":13},{"line":319,"kind":13,"containerName":"process_seq","name":"$seq"}],"line":316,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: BaseSeqProcessor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::BaseSeqProcessor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::BaseSeqProcessor - Base implementation for a SequenceProcessor\n\n=head1 SYNOPSIS\n\n    # you need to derive your own processor from this one\n\n=head1 DESCRIPTION\n\nThis provides just a basic framework for implementations of\nL<Bio::Factory::SequenceProcessorI>.\n\nEssentially what it does is support a parameter to new() to set\nsequence factory and source stream, and a next_seq() implementation\nthat will use a queue to be filled by a class overriding\nprocess_seq().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::BaseSeqProcessor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceProcessorI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::BaseSeqProcessor->new();\n Function: Builds a new Bio::Seq::BaseSeqProcessor object \n Returns : an instance of Bio::Seq::BaseSeqProcessor\n Args    : Named parameters. Currently supported are\n             -seqfactory  the Bio::Factory::SequenceFactoryI object to use\n             -source_stream the Bio::Factory::SequenceStreamI object to\n                          which we are chained\n\n\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    my ($stream,$fact) =\n\t$self->_rearrange([qw(SOURCE_STREAM SEQFACTORY)], @args);\n\n    $self->{'_queue'} = [];\n    $self->sequence_factory($fact) if $fact;\n    $self->source_stream($stream) if $stream;\n    \n    return $self;\n}\n\n=head1 L<Bio::Factory::SequenceProcessorI> methods\n\n\n=head2 source_stream\n\n Title   : source_stream\n Usage   : $obj->source_stream($newval)\n Function: Get/set the source sequence stream for this sequence\n           processor.\n\n Example : \n Returns : A Bio::Factory::SequenceStreamI compliant object\n Args    : on set, new value (a Bio::Factory::SequenceStreamI compliant\n           object)\n\n\n\nsub source_stream{\n    my $self = shift;\n\n    if(@_) {\n\tmy $stream = shift;\n\tmy $fact = $stream->sequence_factory();\n\t$self->sequence_factory($fact)\n\t    unless $self->sequence_factory() || (! $fact);\n\treturn $self->{'source_stream'} = $stream;\n    }\n    return $self->{'source_stream'};\n}\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = stream->next_seq\n Function: Reads the next sequence object from the stream and returns it.\n\n           This implementation will obtain objects from the source\n           stream as necessary and pass them to process_seq() for\n           processing. This method will return the objects one at a\n           time that process_seq() returns.\n\n Returns : a Bio::Seq sequence object\n Args    : none\n\nSee L<Bio::Factory::SequenceStreamI::next_seq>\n\n\nsub next_seq{\n    my $self = shift;\n    my $seq;\n\n    # if the queue is empty, fetch next from source and process it\n    if(@{$self->{'_queue'}} == 0) {\n\tmy @seqs = ();\n\twhile($seq = $self->source_stream->next_seq()) {\n\t    @seqs = $self->process_seq($seq);\n\t    # we may get zero seqs returned\n\t    last if @seqs;\n\t}\n\tpush(@{$self->{'_queue'}}, @seqs) if @seqs;\n    }\n    # take next from the queue of seqs\n    $seq = shift(@{$self->{'_queue'}});\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: Writes the result(s) of processing the sequence object into\n           the stream.\n\n           You need to override this method in order not to alter\n           (process) sequence objects before output.\n\n Returns : 1 for success and 0 for error. The method stops attempting\n           to write objects after the first error returned from the\n           source stream. Otherwise the return value is the value\n           returned from the source stream from writing the last\n           object resulting from processing the last sequence object\n           given as argument.\n\n Args    : Bio::SeqI object, or an array of such objects\n\n\nsub write_seq{\n    my ($self, @seqs) = @_;\n    my $ret;\n    foreach my $seq (@seqs) {\n        foreach my $processed ($self->process_seq($seq)) {\n            $ret = $self->source_stream->write_seq($seq);\n            return unless $ret;\n        }\n    }\n    return $ret;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : none\n\n\n\nsub sequence_factory{\n    my $self = shift;\n\n    return $self->{'sequence_factory'} = shift if @_;\n    return $self->{'sequence_factory'};\n}\n\n=head2 object_factory\n\n Title   : object_factory\n Usage   : $obj->object_factory($newval)\n Function: This is an alias to sequence_factory with a more generic name.\n Example : \n Returns : a L<Bio::Factory::ObjectFactoryI> compliant object\n Args    : on set, new value (a L<Bio::Factory::ObjectFactoryI> \n           compliant object or undef, optional)\n\n\n\nsub object_factory{\n    return shift->sequence_factory(@_);\n}\n\n=head2 close\n\n Title   : close\n Usage   :\n Function: Closes the stream. We override this here in order to cascade\n           to the source stream.\n Example :\n Returns : \n Args    : none\n\n\n\nsub close{\n    my $self = shift;\n    return $self->source_stream() ? $self->source_stream->close(@_) : 1;\n}\n\n=head1 To be overridden by a derived class\n\n\n=head2 process_seq\n\n Title   : process_seq\n Usage   :\n Function: This is the method that is supposed to do the actual\n           processing. It needs to be overridden to do what you want\n           it to do.\n\n           Generally, you do not have to override or implement any other\n           method to derive your own sequence processor.\n\n           The implementation provided here just returns the unaltered\n           input sequence and hence is not very useful other than\n           serving as a neutral default processor.\n\n Example :\n Returns : An array of zero or more Bio::PrimarySeqI (or derived\n           interface) compliant object as the result of processing the\n           input sequence.\n Args    : A Bio::PrimarySeqI (or derived interface) compliant object\n           to be processed.","label":"process_seq($self,$seq)"},"detail":"($self,$seq)","definition":"sub","containerName":"main::","range":{"start":{"line":316,"character":0},"end":{"character":9999,"line":320}},"name":"process_seq"}]}