{"version":5,"vars":[{"kind":2,"line":149,"containerName":"","name":"Storable"},{"kind":2,"line":151,"name":"base","containerName":""},{"kind":14,"line":159,"name":"MAX_BIN","definition":1,"containerName":"main::"},{"containerName":"main::","name":"MIN_BIN","definition":1,"line":162,"kind":14},{"kind":12,"line":185,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":186,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":186},{"line":188,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","line":188,"kind":13},{"name":"@args","containerName":"new","line":188,"kind":13},{"name":"$maxbin","definition":"my","containerName":"new","localvar":"my","kind":13,"line":189},{"kind":13,"line":189,"name":"$minbin","containerName":"new"},{"kind":13,"line":189,"containerName":"new","name":"$file"},{"containerName":"new","name":"$keep","kind":13,"line":189},{"containerName":"new","name":"$features","line":190,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":190},{"line":190,"kind":12,"containerName":"new","name":"_rearrange"},{"kind":13,"line":191,"containerName":"new","name":"@args"},{"name":"$maxbin","containerName":"new","line":193,"kind":13},{"line":193,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"max_bin","line":193,"kind":12},{"containerName":"new","name":"$maxbin","line":193,"kind":13},{"line":194,"kind":13,"name":"$minbin","containerName":"new"},{"kind":13,"line":194,"containerName":"new","name":"$self"},{"containerName":"new","name":"min_bin","line":194,"kind":12},{"kind":13,"line":194,"name":"$minbin","containerName":"new"},{"kind":13,"line":196,"containerName":"new","name":"$features"},{"kind":13,"line":196,"name":"$self","containerName":"new"},{"line":196,"kind":12,"containerName":"new","name":"add_features"},{"name":"$features","containerName":"new","line":196,"kind":13},{"containerName":"new","name":"$DB_BTREE","line":197,"kind":13},{"line":198,"kind":13,"containerName":"new","name":"$DB_BTREE"},{"kind":13,"line":199,"containerName":"new","name":"$self"},{"name":"$file","containerName":"new","line":200,"kind":13},{"line":201,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":201,"containerName":"new","name":"debug"},{"kind":13,"line":202,"name":"$self","containerName":"new"},{"kind":12,"line":202,"name":"indexfile","containerName":"new"},{"line":202,"kind":13,"name":"$file","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":204},{"kind":12,"line":204,"containerName":"new","name":"keep"},{"kind":13,"line":204,"name":"$keep","containerName":"new"},{"name":"$self","containerName":"new","line":205,"kind":13},{"line":205,"kind":13,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially"},"name":"new","range":{"start":{"character":0,"line":185},"end":{"line":205,"character":9999}}},{"name":"SUPER","containerName":"new","kind":12,"line":188},{"line":197,"kind":12,"name":"R_DUP"},{"name":"_compare","kind":12,"line":198},{"line":206,"kind":13,"containerName":null,"name":"$self"},{"line":206,"kind":12,"containerName":"main::","name":"indexfile"},{"name":"O_RDWR","line":206,"kind":12},{"name":"O_CREAT","kind":12,"line":206},{"kind":13,"line":206,"name":"$DB_BTREE","containerName":null},{"kind":13,"line":207,"containerName":null,"name":"%self"},{"line":207,"kind":13,"name":"$self","containerName":null},{"line":207,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":208},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$feats"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index","label":"add_features($self,$feats)"},"detail":"($self,$feats)","kind":12,"children":[{"kind":13,"line":224,"containerName":"add_features","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":224,"name":"$feats","containerName":"add_features"},{"kind":13,"line":225,"name":"$feats","containerName":"add_features"},{"containerName":"add_features","name":"$self","kind":13,"line":226},{"kind":12,"line":226,"name":"warn","containerName":"add_features"},{"kind":13,"line":229,"name":"$count","definition":"my","containerName":"add_features","localvar":"my"},{"localvar":"my","definition":"my","name":"$f","containerName":"add_features","line":230,"kind":13},{"kind":13,"line":230,"name":"$feats","containerName":"add_features"},{"kind":13,"line":231,"containerName":"add_features","name":"$f"},{"containerName":"add_features","name":"$f","kind":13,"line":231},{"containerName":"add_features","name":"$f","kind":13,"line":231},{"kind":12,"line":231,"name":"isa","containerName":"add_features"},{"line":232,"kind":13,"containerName":"add_features","name":"$self"},{"name":"warn","containerName":"add_features","line":232,"kind":12},{"localvar":"my","containerName":"add_features","definition":"my","name":"$bin","line":235,"kind":13},{"kind":13,"line":235,"name":"$f","containerName":"add_features"},{"kind":12,"line":235,"containerName":"add_features","name":"start"},{"name":"$f","containerName":"add_features","kind":13,"line":235},{"line":235,"kind":12,"name":"end","containerName":"add_features"},{"name":"$self","containerName":"add_features","kind":13,"line":235},{"containerName":"add_features","name":"min_bin","kind":12,"line":235},{"kind":13,"line":236,"containerName":"add_features","definition":"my","name":"$serialized","localvar":"my"},{"name":"$f","containerName":"add_features","line":236,"kind":13},{"kind":13,"line":237,"name":"$self","containerName":"add_features"},{"line":237,"kind":12,"name":"put","containerName":"add_features"},{"name":"$bin","containerName":"add_features","line":237,"kind":13},{"line":237,"kind":13,"containerName":"add_features","name":"$serialized"},{"name":"$f","containerName":"add_features","kind":13,"line":238},{"name":"isa","containerName":"add_features","kind":12,"line":238},{"containerName":"add_features","name":"$self","line":239,"kind":13},{"name":"debug","containerName":"add_features","line":239,"kind":12},{"line":239,"kind":13,"name":"$f","containerName":"add_features"},{"kind":12,"line":239,"name":"location","containerName":"add_features"},{"containerName":"add_features","name":"to_FTstring","line":239,"kind":12},{"containerName":"add_features","name":"$self","kind":13,"line":239},{"containerName":"add_features","name":"$count","line":241,"kind":13}],"line":223,"name":"add_features","range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":242}}},{"name":"bin","line":235,"kind":12},{"name":"feature_freeze","line":236,"kind":12},{"name":"$count","containerName":null,"kind":13,"line":243},{"range":{"end":{"character":9999,"line":346},"start":{"character":0,"line":273}},"name":"features_in_range","detail":"(@args)","signature":{"label":"features_in_range(@args)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.","parameters":[{"label":"@args"}]},"containerName":"main::","definition":"sub","line":273,"children":[{"kind":13,"line":274,"containerName":"features_in_range","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"@args","containerName":"features_in_range","line":275,"kind":13},{"line":276,"kind":13,"localvar":"my","name":"$range","definition":"my","containerName":"features_in_range"},{"line":276,"kind":13,"containerName":"features_in_range","name":"$contain"},{"name":"$strandmatch","containerName":"features_in_range","line":276,"kind":13},{"containerName":"features_in_range","name":"$start","kind":13,"line":276},{"name":"$end","containerName":"features_in_range","kind":13,"line":276},{"name":"$strand","containerName":"features_in_range","line":276,"kind":13},{"line":277,"kind":13,"name":"@args","containerName":"features_in_range"},{"name":"$range","containerName":"features_in_range","line":278,"kind":13},{"line":278,"kind":13,"name":"@args","containerName":"features_in_range"},{"containerName":"features_in_range","name":"$start","kind":13,"line":280},{"containerName":"features_in_range","name":"$end","kind":13,"line":280},{"name":"$strand","containerName":"features_in_range","line":280,"kind":13},{"kind":13,"line":280,"containerName":"features_in_range","name":"$range"},{"line":281,"kind":13,"containerName":"features_in_range","name":"$contain"},{"kind":13,"line":281,"name":"$strandmatch","containerName":"features_in_range"},{"line":281,"kind":13,"containerName":"features_in_range","name":"$self"},{"line":281,"kind":12,"containerName":"features_in_range","name":"_rearrange"},{"kind":13,"line":285,"containerName":"features_in_range","name":"@args"},{"name":"$contain","containerName":"features_in_range","line":286,"kind":13},{"line":286,"kind":13,"containerName":"features_in_range","name":"$contain"},{"containerName":"features_in_range","name":"$strand","kind":13,"line":288},{"line":288,"kind":13,"name":"$strand","containerName":"features_in_range"},{"containerName":"features_in_range","name":"$strand","line":289,"kind":13},{"name":"$strand","containerName":"features_in_range","line":290,"kind":13},{"kind":13,"line":291,"containerName":"features_in_range","name":"$self"},{"kind":12,"line":291,"name":"warn","containerName":"features_in_range"},{"kind":13,"line":294,"containerName":"features_in_range","name":"$strand"},{"containerName":"features_in_range","name":"$start","line":296,"kind":13},{"name":"$end","containerName":"features_in_range","kind":13,"line":296},{"kind":13,"line":297,"name":"$range","containerName":"features_in_range"},{"line":297,"kind":13,"containerName":"features_in_range","name":"$range"},{"kind":13,"line":297,"name":"$range","containerName":"features_in_range"},{"containerName":"features_in_range","name":"isa","kind":12,"line":297},{"containerName":"features_in_range","name":"$self","line":299,"kind":13},{"line":299,"kind":12,"name":"warn","containerName":"features_in_range"},{"name":"$start","containerName":"features_in_range","kind":13,"line":302},{"name":"$end","containerName":"features_in_range","line":302,"kind":13},{"containerName":"features_in_range","name":"$strand","line":302,"kind":13},{"kind":13,"line":302,"name":"$range","containerName":"features_in_range"},{"containerName":"features_in_range","name":"start","kind":12,"line":302},{"name":"$range","containerName":"features_in_range","kind":13,"line":302},{"containerName":"features_in_range","name":"end","kind":12,"line":302},{"containerName":"features_in_range","name":"$range","line":302,"kind":13},{"kind":12,"line":302,"containerName":"features_in_range","name":"strand"},{"line":304,"kind":13,"localvar":"my","definition":"my","name":"$r","containerName":"features_in_range"},{"line":304,"kind":12,"name":"new","containerName":"features_in_range"},{"containerName":"features_in_range","name":"$start","line":304,"kind":13},{"kind":13,"line":305,"name":"$end","containerName":"features_in_range"},{"line":306,"kind":13,"containerName":"features_in_range","name":"$strand"},{"kind":13,"line":308,"containerName":"features_in_range","name":"@features","definition":"my","localvar":"my"},{"line":309,"kind":13,"localvar":"my","containerName":"features_in_range","definition":"my","name":"$maxbin"},{"line":309,"kind":13,"name":"$self","containerName":"features_in_range"},{"line":309,"kind":12,"name":"max_bin","containerName":"features_in_range"},{"localvar":"my","containerName":"features_in_range","name":"$minbin","definition":"my","line":310,"kind":13},{"name":"$self","containerName":"features_in_range","line":310,"kind":13},{"name":"min_bin","containerName":"features_in_range","kind":12,"line":310},{"line":311,"kind":13,"localvar":"my","containerName":"features_in_range","name":"$tier","definition":"my"},{"kind":13,"line":311,"containerName":"features_in_range","name":"$maxbin"},{"line":312,"kind":13,"localvar":"my","definition":"my","name":"$k","containerName":"features_in_range"},{"containerName":"features_in_range","name":"$v","kind":13,"line":312},{"containerName":"features_in_range","name":"@bins","kind":13,"line":312},{"name":"$tier","containerName":"features_in_range","kind":13,"line":313},{"name":"$minbin","containerName":"features_in_range","kind":13,"line":313},{"localvar":"my","containerName":"features_in_range","definition":"my","name":"$tier_start","line":314,"kind":13},{"name":"$tier_stop","containerName":"features_in_range","kind":13,"line":314},{"line":314,"kind":13,"containerName":"features_in_range","name":"$tier"},{"containerName":"features_in_range","name":"$start","kind":13,"line":314},{"name":"$tier","containerName":"features_in_range","line":315,"kind":13},{"name":"$end","containerName":"features_in_range","line":315,"kind":13},{"containerName":"features_in_range","name":"$tier_start","kind":13,"line":316},{"name":"$tier_stop","containerName":"features_in_range","kind":13,"line":316},{"kind":13,"line":317,"name":"@vals","definition":"my","containerName":"features_in_range","localvar":"my"},{"kind":13,"line":317,"containerName":"features_in_range","name":"$self"},{"containerName":"features_in_range","name":"get_dup","line":317,"kind":12},{"kind":13,"line":317,"containerName":"features_in_range","name":"$tier_start"},{"containerName":"features_in_range","name":"@vals","line":318,"kind":13},{"containerName":"features_in_range","name":"@bins","kind":13,"line":319},{"name":"@vals","containerName":"features_in_range","line":319,"kind":13},{"kind":13,"line":322,"name":"$k","containerName":"features_in_range"},{"line":322,"kind":13,"containerName":"features_in_range","name":"$tier_start"},{"line":323,"kind":13,"localvar":"my","containerName":"features_in_range","definition":"my","name":"@vals"},{"kind":13,"line":324,"containerName":"features_in_range","name":"$rc","definition":"my","localvar":"my"},{"name":"$self","containerName":"features_in_range","line":324,"kind":13},{"line":324,"kind":12,"containerName":"features_in_range","name":"seq"},{"line":324,"kind":13,"name":"$k","containerName":"features_in_range"},{"line":324,"kind":13,"name":"$v","containerName":"features_in_range"},{"kind":13,"line":325,"name":"$rc","containerName":"features_in_range"},{"name":"$rc","containerName":"features_in_range","kind":13,"line":326},{"containerName":"features_in_range","name":"$self","kind":13,"line":326},{"containerName":"features_in_range","name":"seq","kind":12,"line":326},{"name":"$k","containerName":"features_in_range","line":326,"kind":13},{"line":326,"kind":13,"name":"$v","containerName":"features_in_range"},{"containerName":"features_in_range","name":"$k","kind":13,"line":327},{"kind":13,"line":327,"containerName":"features_in_range","name":"$tier_stop"},{"line":327,"kind":13,"containerName":"features_in_range","name":"$k"},{"containerName":"features_in_range","name":"$tier_start","line":327,"kind":13},{"name":"@bins","containerName":"features_in_range","kind":13,"line":328},{"kind":13,"line":328,"containerName":"features_in_range","name":"$v"},{"containerName":"features_in_range","name":"$tier","line":331,"kind":13},{"containerName":"features_in_range","name":"%seen","definition":"my","localvar":"my","kind":13,"line":333},{"localvar":"my","definition":"my","name":"$t","containerName":"features_in_range","line":334,"kind":13},{"containerName":"features_in_range","name":"@bins","line":334,"kind":13},{"containerName":"features_in_range","name":"$seen","line":335,"kind":13},{"containerName":"features_in_range","name":"$t","line":335,"kind":13},{"kind":13,"line":339,"containerName":"features_in_range","name":"$self"},{"kind":12,"line":339,"name":"warn","containerName":"features_in_range"},{"line":343,"kind":13,"containerName":"features_in_range","name":"$strandmatch"},{"containerName":"features_in_range","name":"$strandmatch","kind":13,"line":343},{"line":344,"kind":13,"containerName":"features_in_range","name":"$contain"},{"containerName":"features_in_range","name":"$r","line":344,"kind":13},{"line":344,"kind":12,"name":"contains","containerName":"features_in_range"},{"line":344,"kind":13,"containerName":"features_in_range","name":"$strandmatch"},{"containerName":"features_in_range","name":"@bins","line":344,"kind":13},{"name":"$r","containerName":"features_in_range","line":345,"kind":13},{"line":345,"kind":12,"containerName":"features_in_range","name":"overlaps"},{"name":"$strandmatch","containerName":"features_in_range","line":345,"kind":13},{"line":345,"kind":13,"containerName":"features_in_range","name":"@bins"}],"kind":12},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":304},{"kind":12,"line":314,"name":"bin_bot"},{"kind":12,"line":315,"name":"bin_top"},{"name":"thaw","line":319,"kind":12},{"name":"R_CURSOR","kind":12,"line":324},{"name":"R_NEXT","kind":12,"line":326},{"name":"thaw","line":328,"kind":12},{"name":"remove_features","range":{"start":{"character":0,"line":360},"end":{"character":9999,"line":389}},"containerName":"main::","definition":"sub","detail":"($self,$feats)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects","parameters":[{"label":"$self"},{"label":"$feats"}],"label":"remove_features($self,$feats)"},"kind":12,"line":360,"children":[{"line":361,"kind":13,"localvar":"my","containerName":"remove_features","definition":"my","name":"$self"},{"containerName":"remove_features","name":"$feats","line":361,"kind":13},{"kind":13,"line":362,"name":"$feats","containerName":"remove_features"},{"line":363,"kind":13,"name":"$self","containerName":"remove_features"},{"kind":12,"line":363,"containerName":"remove_features","name":"warn"},{"containerName":"remove_features","name":"$countprocessed","definition":"my","localvar":"my","kind":13,"line":366},{"localvar":"my","containerName":"remove_features","definition":"my","name":"$f","line":368,"kind":13},{"kind":13,"line":368,"containerName":"remove_features","name":"$feats"},{"name":"$f","containerName":"remove_features","line":369,"kind":13},{"containerName":"remove_features","name":"$f","kind":13,"line":369},{"name":"isa","containerName":"remove_features","kind":12,"line":369},{"line":370,"kind":13,"localvar":"my","definition":"my","name":"$bin","containerName":"remove_features"},{"containerName":"remove_features","name":"$f","line":370,"kind":13},{"name":"start","containerName":"remove_features","kind":12,"line":370},{"name":"$f","containerName":"remove_features","kind":13,"line":370},{"kind":12,"line":370,"containerName":"remove_features","name":"end"},{"line":370,"kind":13,"name":"$self","containerName":"remove_features"},{"name":"min_bin","containerName":"remove_features","kind":12,"line":370},{"localvar":"my","name":"@vals","definition":"my","containerName":"remove_features","line":371,"kind":13},{"name":"$self","containerName":"remove_features","kind":13,"line":371},{"containerName":"remove_features","name":"get_dup","kind":12,"line":371},{"line":371,"kind":13,"name":"$bin","containerName":"remove_features"},{"containerName":"remove_features","definition":"my","name":"$vcount","localvar":"my","kind":13,"line":372},{"kind":13,"line":372,"containerName":"remove_features","name":"@vals"},{"kind":13,"line":374,"name":"$v","definition":"my","containerName":"remove_features","localvar":"my"},{"name":"@vals","containerName":"remove_features","line":374,"kind":13},{"name":"$v","containerName":"remove_features","kind":13,"line":377},{"containerName":"remove_features","name":"$f","kind":13,"line":377},{"kind":13,"line":378,"containerName":"remove_features","name":"$self"},{"containerName":"remove_features","name":"del_dup","line":378,"kind":12},{"containerName":"remove_features","name":"$bin","line":378,"kind":13},{"name":"$v","containerName":"remove_features","line":378,"kind":13},{"kind":13,"line":379,"name":"$vcount","containerName":"remove_features"},{"name":"$countprocessed","containerName":"remove_features","line":380,"kind":13},{"containerName":"remove_features","name":"$vcount","line":383,"kind":13},{"line":384,"kind":13,"containerName":"remove_features","name":"$self"},{"line":384,"kind":12,"name":"del","containerName":"remove_features"},{"line":384,"kind":13,"containerName":"remove_features","name":"$bin"},{"kind":13,"line":387,"name":"$countprocessed","containerName":"remove_features"}]},{"name":"bin","kind":12,"line":370},{"kind":12,"line":377,"name":"feature_freeze"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_all_features","line":403,"kind":13},{"name":"@features","definition":"my","containerName":"get_all_features","localvar":"my","kind":13,"line":404},{"name":"$key","definition":"my","containerName":"get_all_features","localvar":"my","kind":13,"line":405},{"containerName":"get_all_features","name":"$value","kind":13,"line":405},{"localvar":"my","containerName":"get_all_features","definition":"my","name":"$status","line":406,"kind":13},{"line":406,"kind":13,"name":"$self","containerName":"get_all_features"},{"name":"seq","containerName":"get_all_features","line":406,"kind":12},{"kind":13,"line":406,"name":"$key","containerName":"get_all_features"},{"line":406,"kind":13,"containerName":"get_all_features","name":"$value"},{"line":407,"kind":13,"name":"$status","containerName":"get_all_features"},{"name":"$status","containerName":"get_all_features","kind":13,"line":408},{"kind":13,"line":408,"containerName":"get_all_features","name":"$self"},{"line":408,"kind":12,"name":"seq","containerName":"get_all_features"},{"containerName":"get_all_features","name":"$key","kind":13,"line":408},{"containerName":"get_all_features","name":"$value","kind":13,"line":408},{"line":409,"kind":13,"containerName":"get_all_features","name":"$value"},{"kind":13,"line":410,"containerName":"get_all_features","name":"@features"},{"kind":13,"line":410,"containerName":"get_all_features","name":"$value"},{"kind":13,"line":412,"containerName":"get_all_features","name":"@features"},{"containerName":"get_all_features","name":"$self","kind":13,"line":412},{"kind":12,"line":412,"name":"feature_count","containerName":"get_all_features"},{"kind":13,"line":413,"name":"$self","containerName":"get_all_features"},{"kind":12,"line":413,"containerName":"get_all_features","name":"warn"},{"kind":13,"line":415,"name":"@features","containerName":"get_all_features"}],"line":402,"definition":"sub","containerName":"main::","signature":{"label":"get_all_features($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None"},"detail":"($self)","name":"get_all_features","range":{"end":{"line":416,"character":9999},"start":{"line":402,"character":0}}},{"line":406,"kind":12,"name":"R_FIRST"},{"kind":12,"line":408,"name":"R_NEXT"},{"line":410,"kind":12,"name":"thaw"},{"range":{"start":{"line":430,"character":0},"end":{"line":436,"character":9999}},"name":"min_bin","children":[{"localvar":"my","containerName":"min_bin","definition":"my","name":"$self","line":431,"kind":13},{"line":431,"kind":13,"containerName":"min_bin","name":"$min"},{"containerName":"min_bin","name":"$min","kind":13,"line":432},{"containerName":"min_bin","name":"$self","kind":13,"line":433},{"kind":13,"line":433,"name":"$min","containerName":"min_bin"},{"name":"$self","containerName":"min_bin","kind":13,"line":435}],"line":430,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$min"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None\n\n\n\nsub get_all_features{\n   my ($self) = @_;\n   my @features;\n   my ($key,$value);\n   for (my $status = $self->{'_btree'}->seq($key, $value, R_FIRST) ;\n\t$status == 0 ;\n\t$status = $self->{'_btree'}->seq($key, $value, R_NEXT) )\n   {   next unless defined $value;\n       push @features, &thaw($value);\n   }\n   if( scalar @features !=  $self->feature_count() ) {\n       $self->warn(\"feature count does not match actual count\\n\");\n   }\n   return @features;\n}\n\n\n=head2 min_bin\n\n Title   : min_bin\n Usage   : my $minbin= $self->min_bin;\n Function: Get/Set the minimum value to use for binning\n Returns : integer\n Args    : [optional] minimum bin value","label":"min_bin($self,$min)"},"detail":"($self,$min)","definition":"sub","containerName":"main::"},{"name":"MIN_BIN","kind":12,"line":435},{"name":"max_bin","range":{"end":{"character":9999,"line":455},"start":{"character":0,"line":449}},"containerName":"main::","definition":"sub","detail":"($self,$max)","signature":{"parameters":[{"label":"$self"},{"label":"$max"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None\n\n\n\nsub get_all_features{\n   my ($self) = @_;\n   my @features;\n   my ($key,$value);\n   for (my $status = $self->{'_btree'}->seq($key, $value, R_FIRST) ;\n\t$status == 0 ;\n\t$status = $self->{'_btree'}->seq($key, $value, R_NEXT) )\n   {   next unless defined $value;\n       push @features, &thaw($value);\n   }\n   if( scalar @features !=  $self->feature_count() ) {\n       $self->warn(\"feature count does not match actual count\\n\");\n   }\n   return @features;\n}\n\n\n=head2 min_bin\n\n Title   : min_bin\n Usage   : my $minbin= $self->min_bin;\n Function: Get/Set the minimum value to use for binning\n Returns : integer\n Args    : [optional] minimum bin value\n\n\n\nsub min_bin {\n  my ($self,$min) = @_;\n  if( defined $min ) {\n      $self->{'_min_bin'} = $min;\n  }\n  return $self->{'_min_bin'}  || MIN_BIN;\n}\n\n=head2 max_bin\n\n Title   : max_bin\n Usage   : my $maxbin= $self->max_bin;\n Function: Get/Set the maximum value to use for binning\n Returns : integer\n Args    : [optional] maximum bin value","label":"max_bin($self,$max)"},"kind":12,"line":449,"children":[{"kind":13,"line":450,"name":"$self","definition":"my","containerName":"max_bin","localvar":"my"},{"name":"$max","containerName":"max_bin","kind":13,"line":450},{"line":451,"kind":13,"name":"$max","containerName":"max_bin"},{"containerName":"max_bin","name":"$self","line":452,"kind":13},{"containerName":"max_bin","name":"$max","line":452,"kind":13},{"name":"$self","containerName":"max_bin","kind":13,"line":454}]},{"name":"MAX_BIN","kind":12,"line":454},{"containerName":"main::","name":"feature_count","definition":"sub","range":{"end":{"character":9999,"line":471},"start":{"character":0,"line":468}},"kind":12,"line":468,"children":[{"line":469,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"feature_count"},{"line":470,"kind":13,"localvar":"my","name":"$count","definition":"my","containerName":"feature_count"},{"name":"$self","containerName":"feature_count","kind":13,"line":471}]},{"kind":13,"line":472,"containerName":null,"name":"$v","definition":"my","localvar":"my"},{"line":472,"kind":13,"name":"%self","containerName":null},{"name":"$v","containerName":null,"kind":13,"line":473},{"containerName":null,"name":"$count","kind":13,"line":474},{"kind":13,"line":476,"name":"$count","containerName":null},{"name":"indexfile","definition":"sub","containerName":"main::","range":{"start":{"line":490,"character":0},"end":{"character":9999,"line":495}},"kind":12,"children":[{"kind":13,"line":491,"definition":"my","name":"$self","containerName":"indexfile","localvar":"my"},{"name":"$self","containerName":"indexfile","kind":13,"line":493},{"kind":13,"line":494,"name":"$self","containerName":"indexfile"}],"line":490},{"range":{"end":{"line":515,"character":9999},"start":{"line":510,"character":0}},"name":"keep","definition":"sub","containerName":"main::","children":[{"line":511,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"keep"},{"line":513,"kind":13,"name":"$self","containerName":"keep"},{"name":"$self","containerName":"keep","kind":13,"line":514}],"line":510,"kind":12},{"kind":12,"children":[],"line":517,"name":"_compare","definition":"sub","containerName":"main::","range":{"start":{"line":517,"character":0},"end":{"line":524,"character":9999}}},{"containerName":"main::","name":"feature_freeze","definition":"sub","range":{"start":{"character":0,"line":526},"end":{"character":9999,"line":532}},"kind":12,"line":526,"children":[{"line":527,"kind":13,"localvar":"my","name":"$obj","definition":"my","containerName":"feature_freeze"},{"line":528,"kind":13,"localvar":"my","name":"$funcref","definition":"my","containerName":"feature_freeze"},{"kind":13,"line":528,"name":"$obj","containerName":"feature_freeze"},{"containerName":"feature_freeze","name":"_cleanup_methods","kind":12,"line":528},{"line":529,"kind":13,"name":"$obj","containerName":"feature_freeze"},{"containerName":"feature_freeze","name":"_unregister_for_cleanup","kind":12,"line":529},{"containerName":"feature_freeze","name":"$funcref","kind":13,"line":529},{"name":"$obj","containerName":"feature_freeze","line":531,"kind":13}]},{"name":"freeze","line":531,"kind":12},{"containerName":"main::","definition":"sub","name":"feature_thaw","range":{"end":{"line":536,"character":9999},"start":{"line":534,"character":0}},"kind":12,"line":534,"children":[]},{"name":"thaw","line":535,"kind":12},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"start":{"line":538,"character":0},"end":{"line":541,"character":9999}},"kind":12,"children":[{"line":539,"kind":13,"localvar":"my","containerName":"DESTROY","definition":"my","name":"$self"},{"containerName":"DESTROY","name":"$self","line":540,"kind":13},{"name":"$self","containerName":"DESTROY","line":541,"kind":13}],"line":538},{"kind":13,"line":542,"containerName":null,"name":"$self"},{"containerName":"main::","name":"keep","kind":12,"line":542},{"containerName":null,"name":"$self","line":542,"kind":13},{"kind":12,"line":542,"name":"indexfile","containerName":"main::"},{"localvar":"my","containerName":null,"name":"$f","definition":"my","line":543,"kind":13},{"line":543,"kind":13,"containerName":null,"name":"$self"},{"name":"indexfile","containerName":"main::","kind":12,"line":543},{"kind":13,"line":544,"name":"$self","containerName":null},{"line":544,"kind":12,"containerName":"main::","name":"debug"},{"line":544,"kind":13,"containerName":null,"name":"$f"},{"containerName":null,"name":"$f","line":545,"kind":13},{"containerName":null,"name":"$f","line":546,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":548},{"name":"SUPER","containerName":"DESTROY","line":548,"kind":12}]}