{"vars":[{"kind":2,"line":104,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":107,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","line":107,"kind":13},{"kind":13,"line":109,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":109,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":109},{"localvar":"my","containerName":"new","definition":"my","name":"$computation_id","line":112,"kind":13},{"line":113,"kind":13,"name":"$program_name","containerName":"new"},{"containerName":"new","name":"$program_date","kind":13,"line":113},{"containerName":"new","name":"$program_version","line":113,"kind":13},{"name":"$database_name","containerName":"new","line":114,"kind":13},{"name":"$database_date","containerName":"new","kind":13,"line":114},{"line":114,"kind":13,"containerName":"new","name":"$database_version"},{"containerName":"new","name":"$self","kind":13,"line":115},{"name":"_rearrange","containerName":"new","kind":12,"line":115},{"containerName":"new","name":"@args","line":122,"kind":13},{"kind":13,"line":124,"name":"$program_name","containerName":"new"},{"name":"$self","containerName":"new","line":124,"kind":13},{"name":"program_name","containerName":"new","line":124,"kind":12},{"containerName":"new","name":"$program_name","line":124,"kind":13},{"line":125,"kind":13,"name":"$program_date","containerName":"new"},{"line":125,"kind":13,"name":"$self","containerName":"new"},{"name":"program_date","containerName":"new","line":125,"kind":12},{"kind":13,"line":125,"name":"$program_date","containerName":"new"},{"kind":13,"line":126,"name":"$program_version","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":126},{"name":"program_version","containerName":"new","kind":12,"line":126},{"name":"$program_version","containerName":"new","kind":13,"line":126},{"containerName":"new","name":"$database_name","line":127,"kind":13},{"kind":13,"line":127,"name":"$self","containerName":"new"},{"containerName":"new","name":"database_name","kind":12,"line":127},{"name":"$database_name","containerName":"new","kind":13,"line":127},{"line":128,"kind":13,"containerName":"new","name":"$database_date"},{"name":"$self","containerName":"new","line":128,"kind":13},{"containerName":"new","name":"database_date","kind":12,"line":128},{"name":"$database_date","containerName":"new","line":128,"kind":13},{"line":129,"kind":13,"name":"$database_version","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":129},{"name":"database_version","containerName":"new","kind":12,"line":129},{"kind":13,"line":129,"name":"$database_version","containerName":"new"},{"kind":13,"line":130,"containerName":"new","name":"$computation_id"},{"line":130,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":130,"name":"computation_id","containerName":"new"},{"line":130,"kind":13,"containerName":"new","name":"$computation_id"},{"name":"$self","containerName":"new","line":132,"kind":13}],"line":106,"name":"new","range":{"start":{"line":106,"character":0},"end":{"character":9999,"line":133}}},{"kind":12,"line":109,"containerName":"new","name":"SUPER"},{"signature":{"label":"has_score($self,$score)","parameters":[{"label":"$self"},{"label":"$score"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score"},"detail":"($self,$score)","definition":"sub","containerName":"main::","children":[{"line":147,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"has_score"},{"kind":13,"line":147,"containerName":"has_score","name":"$score"},{"kind":13,"line":148,"name":"$score","containerName":"has_score"},{"name":"$self","containerName":"has_score","kind":13,"line":149},{"containerName":"has_score","name":"$score","kind":13,"line":149}],"line":146,"kind":12,"range":{"start":{"line":146,"character":0},"end":{"character":9999,"line":150}},"name":"has_score"},{"signature":{"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)","parameters":[{"label":"$self"},{"label":"$score"},{"label":"$value"}],"label":"add_score_value($self,$score,$value)"},"detail":"($self,$score,$value)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"add_score_value","localvar":"my","kind":13,"line":162},{"line":162,"kind":13,"containerName":"add_score_value","name":"$score"},{"name":"$value","containerName":"add_score_value","kind":13,"line":162},{"line":163,"kind":13,"containerName":"add_score_value","name":"$score"},{"line":163,"kind":13,"name":"$value","containerName":"add_score_value"},{"name":"$self","containerName":"add_score_value","line":164,"kind":13},{"containerName":"add_score_value","name":"warn","kind":12,"line":164},{"line":168,"kind":13,"name":"$self","containerName":"add_score_value"},{"name":"$score","containerName":"add_score_value","kind":13,"line":168},{"name":"$self","containerName":"add_score_value","kind":13,"line":169},{"kind":13,"line":169,"containerName":"add_score_value","name":"$score"},{"kind":13,"line":172,"containerName":"add_score_value","name":"$self"},{"kind":13,"line":172,"containerName":"add_score_value","name":"$score"}],"line":161,"kind":12,"range":{"end":{"line":172,"character":9999},"start":{"line":161,"character":0}},"name":"add_score_value"},{"line":172,"kind":13,"name":"$value","containerName":null},{"range":{"end":{"line":202,"character":9999},"start":{"line":188,"character":0}},"name":"score","signature":{"label":"score($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score "},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":189,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"score"},{"name":"$value","containerName":"score","line":189,"kind":13},{"name":"@v","definition":"my","containerName":"score","localvar":"my","kind":13,"line":190},{"kind":13,"line":191,"name":"$value","containerName":"score"},{"containerName":"score","name":"$value","kind":13,"line":193},{"kind":13,"line":194,"name":"$t","definition":"my","containerName":"score","localvar":"my"},{"name":"$val","containerName":"score","kind":13,"line":194},{"line":194,"kind":13,"name":"$value","containerName":"score"},{"name":"$self","containerName":"score","kind":13,"line":195},{"kind":12,"line":195,"name":"add_score_value","containerName":"score"},{"line":195,"kind":13,"containerName":"score","name":"$t"},{"line":195,"kind":13,"name":"$val","containerName":"score"},{"name":"@v","containerName":"score","line":198,"kind":13},{"kind":13,"line":198,"containerName":"score","name":"$value"},{"line":199,"kind":13,"containerName":"score","name":"$self"},{"name":"add_score_value","containerName":"score","line":199,"kind":12},{"containerName":"score","name":"$value","line":199,"kind":13}],"line":188,"kind":12},{"containerName":null,"name":"@v","line":203,"kind":13},{"line":203,"kind":13,"name":"$self","containerName":null},{"line":203,"kind":12,"containerName":"main::","name":"each_score_value"},{"line":205,"kind":13,"containerName":null,"name":"@v"},{"name":"each_score_value","range":{"start":{"line":219,"character":0},"end":{"line":225,"character":9999}},"kind":12,"line":219,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"each_score_value","line":220,"kind":13},{"kind":13,"line":220,"name":"$score","containerName":"each_score_value"},{"line":221,"kind":13,"containerName":"each_score_value","name":"$self"},{"line":221,"kind":13,"name":"$score","containerName":"each_score_value"},{"name":"$self","containerName":"each_score_value","line":222,"kind":13},{"line":222,"kind":12,"containerName":"each_score_value","name":"warn"},{"containerName":"each_score_value","name":"$self","line":225,"kind":13},{"containerName":"each_score_value","name":"$score","line":225,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$score)","signature":{"label":"each_score_value($self,$score)","documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score","parameters":[{"label":"$self"},{"label":"$score"}]}},{"children":[{"kind":13,"line":241,"containerName":"all_scores","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":241,"containerName":"all_scores","name":"@args"},{"kind":13,"line":243,"containerName":"all_scores","name":"$self"}],"line":240,"kind":12,"signature":{"label":"all_scores($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":240},"end":{"line":243,"character":9999}},"name":"all_scores"},{"line":258,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"remove_score","line":259,"kind":13},{"containerName":"remove_score","name":"$score","kind":13,"line":259},{"line":261,"kind":13,"containerName":"remove_score","name":"$self"},{"containerName":"remove_score","name":"$score","kind":13,"line":261},{"name":"$self","containerName":"remove_score","kind":13,"line":262},{"kind":12,"line":262,"containerName":"remove_score","name":"warn"},{"containerName":"remove_score","name":"$self","line":265,"kind":13},{"name":"$score","containerName":"remove_score","line":265,"kind":13}],"kind":12,"detail":"($self,$score)","signature":{"label":"remove_score($self,$score)","parameters":[{"label":"$self"},{"label":"$score"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":266}},"name":"remove_score"},{"kind":12,"line":280,"children":[{"localvar":"my","containerName":"computation_id","name":"$self","definition":"my","line":281,"kind":13},{"kind":13,"line":281,"name":"$value","containerName":"computation_id"},{"name":"$value","containerName":"computation_id","kind":13,"line":283},{"name":"$self","containerName":"computation_id","kind":13,"line":284},{"containerName":"computation_id","name":"$value","kind":13,"line":284},{"name":"$self","containerName":"computation_id","line":287,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"computation_id($self,$value)"},"name":"computation_id","range":{"end":{"character":9999,"line":288},"start":{"character":0,"line":280}}},{"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set","label":"program_name($self,$value)"},"containerName":"main::","definition":"sub","line":305,"children":[{"localvar":"my","containerName":"program_name","name":"$self","definition":"my","line":306,"kind":13},{"line":306,"kind":13,"containerName":"program_name","name":"$value"},{"containerName":"program_name","name":"$value","line":308,"kind":13},{"line":309,"kind":13,"containerName":"program_name","name":"$self"},{"name":"$value","containerName":"program_name","line":309,"kind":13},{"kind":13,"line":312,"containerName":"program_name","name":"$self"}],"kind":12,"range":{"start":{"line":305,"character":0},"end":{"character":9999,"line":313}},"name":"program_name"},{"range":{"start":{"character":0,"line":327},"end":{"line":335,"character":9999}},"name":"program_date","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set","label":"program_date($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"program_date","name":"$self","definition":"my","line":328,"kind":13},{"kind":13,"line":328,"name":"$value","containerName":"program_date"},{"name":"$value","containerName":"program_date","kind":13,"line":330},{"name":"$self","containerName":"program_date","kind":13,"line":331},{"name":"$value","containerName":"program_date","kind":13,"line":331},{"line":334,"kind":13,"containerName":"program_date","name":"$self"}],"line":327,"kind":12},{"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"program_version($self,$value)"},"containerName":"main::","definition":"sub","line":350,"children":[{"localvar":"my","containerName":"program_version","name":"$self","definition":"my","line":351,"kind":13},{"line":351,"kind":13,"name":"$value","containerName":"program_version"},{"containerName":"program_version","name":"$value","line":353,"kind":13},{"kind":13,"line":354,"name":"$self","containerName":"program_version"},{"name":"$value","containerName":"program_version","kind":13,"line":354},{"kind":13,"line":357,"name":"$self","containerName":"program_version"}],"kind":12,"range":{"start":{"character":0,"line":350},"end":{"line":358,"character":9999}},"name":"program_version"},{"range":{"start":{"line":371,"character":0},"end":{"character":9999,"line":379}},"name":"database_name","detail":"($self,$value)","signature":{"label":"database_name($self,$value)","documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":371,"children":[{"line":372,"kind":13,"localvar":"my","containerName":"database_name","definition":"my","name":"$self"},{"kind":13,"line":372,"name":"$value","containerName":"database_name"},{"containerName":"database_name","name":"$value","line":374,"kind":13},{"line":375,"kind":13,"containerName":"database_name","name":"$self"},{"containerName":"database_name","name":"$value","kind":13,"line":375},{"containerName":"database_name","name":"$self","kind":13,"line":378}],"kind":12},{"name":"database_date","range":{"end":{"line":401,"character":9999},"start":{"character":0,"line":393}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"database_date","line":394,"kind":13},{"containerName":"database_date","name":"$value","line":394,"kind":13},{"kind":13,"line":396,"containerName":"database_date","name":"$value"},{"name":"$self","containerName":"database_date","kind":13,"line":397},{"name":"$value","containerName":"database_date","line":397,"kind":13},{"name":"$self","containerName":"database_date","line":400,"kind":13}],"line":393,"definition":"sub","containerName":"main::","signature":{"label":"database_date($self,$value)","documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"name":"database_version","range":{"end":{"character":9999,"line":425},"start":{"character":0,"line":416}},"definition":"sub","containerName":"main::","signature":{"label":"database_version($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"database_version","line":417,"kind":13},{"name":"$value","containerName":"database_version","kind":13,"line":417},{"kind":13,"line":419,"containerName":"database_version","name":"$value"},{"line":420,"kind":13,"containerName":"database_version","name":"$self"},{"line":420,"kind":13,"containerName":"database_version","name":"$value"},{"kind":13,"line":423,"name":"$self","containerName":"database_version"}],"line":416},{"range":{"start":{"character":0,"line":439},"end":{"line":446,"character":9999}},"name":"sub_SeqFeature_type","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_version'} = $value;\n  }\n\n  return $self->{'_gsf_database_version'};\n\n}\n\n=head2 sub_SeqFeature_type\n\n Title   : sub_SeqFeature_type\n Usage   : $sub_SeqFeature_type = $feat->sub_SeqFeature_type()\n           $feat->sub_SeqFeature_type($sub_SeqFeature_type)\n Function: sub_SeqFeature_type is automatically set when adding\n           a sub_computation (sub_SeqFeature) to a computation object\n Returns : sub_SeqFeature_type (string)\n Args    : none if get, the new value if set","label":"sub_SeqFeature_type($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"sub_SeqFeature_type","line":440,"kind":13},{"kind":13,"line":440,"containerName":"sub_SeqFeature_type","name":"$value"},{"kind":13,"line":442,"name":"$value","containerName":"sub_SeqFeature_type"},{"line":443,"kind":13,"containerName":"sub_SeqFeature_type","name":"$self"},{"kind":13,"line":443,"name":"$value","containerName":"sub_SeqFeature_type"},{"kind":13,"line":445,"containerName":"sub_SeqFeature_type","name":"$self"}],"line":439,"kind":12},{"name":"all_sub_SeqFeature_types","range":{"end":{"character":9999,"line":460},"start":{"character":0,"line":458}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_version'} = $value;\n  }\n\n  return $self->{'_gsf_database_version'};\n\n}\n\n=head2 sub_SeqFeature_type\n\n Title   : sub_SeqFeature_type\n Usage   : $sub_SeqFeature_type = $feat->sub_SeqFeature_type()\n           $feat->sub_SeqFeature_type($sub_SeqFeature_type)\n Function: sub_SeqFeature_type is automatically set when adding\n           a sub_computation (sub_SeqFeature) to a computation object\n Returns : sub_SeqFeature_type (string)\n Args    : none if get, the new value if set\n\n\nsub sub_SeqFeature_type {\n  my ($self, $value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_sub_SeqFeature_type'} = $value;\n  }\n  return $self->{'_gsf_sub_SeqFeature_type'};\n}\n\n=head2 all_sub_SeqFeature_types\n\n Title   : all_Sub_SeqFeature_types\n Usage   : @all_sub_seqfeature_types = $comp->all_Sub_SeqFeature_types();\n Function: Returns an array with all subseqfeature types\n Returns : An array\n Args    : none","label":"all_sub_SeqFeature_types($self)"},"kind":12,"line":458,"children":[{"kind":13,"line":459,"name":"$self","definition":"my","containerName":"all_sub_SeqFeature_types","localvar":"my"},{"name":"$self","containerName":"all_sub_SeqFeature_types","line":460,"kind":13}]},{"kind":12,"line":475,"children":[{"line":476,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"sub_SeqFeature"},{"line":476,"kind":13,"containerName":"sub_SeqFeature","name":"$ssf_type"},{"kind":13,"line":477,"name":"@return_array","definition":"my","containerName":"sub_SeqFeature","localvar":"my"},{"name":"$ssf_type","containerName":"sub_SeqFeature","kind":13,"line":478},{"name":"$self","containerName":"sub_SeqFeature","kind":13,"line":480},{"kind":13,"line":481,"containerName":"sub_SeqFeature","name":"@return_array"},{"kind":13,"line":481,"name":"$self","containerName":"sub_SeqFeature"}],"containerName":"main::","definition":"sub","detail":"($self,$ssf_type)","signature":{"label":"sub_SeqFeature($self,$ssf_type)","parameters":[{"label":"$self"},{"label":"$ssf_type"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_version'} = $value;\n  }\n\n  return $self->{'_gsf_database_version'};\n\n}\n\n=head2 sub_SeqFeature_type\n\n Title   : sub_SeqFeature_type\n Usage   : $sub_SeqFeature_type = $feat->sub_SeqFeature_type()\n           $feat->sub_SeqFeature_type($sub_SeqFeature_type)\n Function: sub_SeqFeature_type is automatically set when adding\n           a sub_computation (sub_SeqFeature) to a computation object\n Returns : sub_SeqFeature_type (string)\n Args    : none if get, the new value if set\n\n\nsub sub_SeqFeature_type {\n  my ($self, $value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_sub_SeqFeature_type'} = $value;\n  }\n  return $self->{'_gsf_sub_SeqFeature_type'};\n}\n\n=head2 all_sub_SeqFeature_types\n\n Title   : all_Sub_SeqFeature_types\n Usage   : @all_sub_seqfeature_types = $comp->all_Sub_SeqFeature_types();\n Function: Returns an array with all subseqfeature types\n Returns : An array\n Args    : none\n\n\nsub all_sub_SeqFeature_types {\n   my ($self) = @_;\n   return keys ( %{$self->{'gsf_sub_hash'}} );\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature('sub_feature_type')\n Usage   : @feats = $feat->sub_SeqFeature();\n           @feats = $feat->sub_SeqFeature('sub_feature_type');           \n Function: Returns an array of sub Sequence Features of a specific\n           type or, if the type is ommited, all sub Sequence Features\n Returns : An array\n Args    : (optional) a sub_SeqFeature type (ie exon, pattern)"},"name":"sub_SeqFeature","range":{"end":{"character":9999,"line":482},"start":{"line":475,"character":0}}},{"line":483,"kind":13,"containerName":null,"name":"@return_array"},{"name":"%self","containerName":null,"kind":13,"line":485},{"kind":13,"line":485,"containerName":null,"name":"%ssf_type"},{"kind":13,"line":486,"containerName":null,"name":"%self"},{"kind":13,"line":486,"containerName":null,"name":"%ssf_type"},{"line":488,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":488,"containerName":"main::","name":"warn"},{"range":{"start":{"character":0,"line":515},"end":{"character":9999,"line":538}},"name":"add_sub_SeqFeature","signature":{"label":"add_sub_SeqFeature($self,$feat,$var1,$var2)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$var1"},{"label":"$var2"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_version'} = $value;\n  }\n\n  return $self->{'_gsf_database_version'};\n\n}\n\n=head2 sub_SeqFeature_type\n\n Title   : sub_SeqFeature_type\n Usage   : $sub_SeqFeature_type = $feat->sub_SeqFeature_type()\n           $feat->sub_SeqFeature_type($sub_SeqFeature_type)\n Function: sub_SeqFeature_type is automatically set when adding\n           a sub_computation (sub_SeqFeature) to a computation object\n Returns : sub_SeqFeature_type (string)\n Args    : none if get, the new value if set\n\n\nsub sub_SeqFeature_type {\n  my ($self, $value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_sub_SeqFeature_type'} = $value;\n  }\n  return $self->{'_gsf_sub_SeqFeature_type'};\n}\n\n=head2 all_sub_SeqFeature_types\n\n Title   : all_Sub_SeqFeature_types\n Usage   : @all_sub_seqfeature_types = $comp->all_Sub_SeqFeature_types();\n Function: Returns an array with all subseqfeature types\n Returns : An array\n Args    : none\n\n\nsub all_sub_SeqFeature_types {\n   my ($self) = @_;\n   return keys ( %{$self->{'gsf_sub_hash'}} );\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature('sub_feature_type')\n Usage   : @feats = $feat->sub_SeqFeature();\n           @feats = $feat->sub_SeqFeature('sub_feature_type');           \n Function: Returns an array of sub Sequence Features of a specific\n           type or, if the type is ommited, all sub Sequence Features\n Returns : An array\n Args    : (optional) a sub_SeqFeature type (ie exon, pattern)\n\n\nsub sub_SeqFeature {\n   my ($self, $ssf_type) = @_;\n   my (@return_array) = ();\n   if ($ssf_type eq '') {\n       #return all sub_SeqFeatures\n       foreach (keys ( %{$self->{'gsf_sub_hash'}} )){\n\t  push @return_array, @{$self->{'gsf_sub_hash'}->{$_}};\t            \n       }\n       return @return_array;\n   } else {\n       if (defined ($self->{'gsf_sub_hash'}->{$ssf_type})) {\n           return @{$self->{'gsf_sub_hash'}->{$ssf_type}};\t\n       } else {\n           $self->warn(\"$ssf_type is not a valid sub SeqFeature type\");\n       }\n   }\n}\n\n=head2 add_sub_SeqFeature\n\n Title   : add_sub_SeqFeature\n Usage   : $feat->add_sub_SeqFeature($subfeat);\n           $feat->add_sub_SeqFeature($subfeat,'sub_seqfeature_type')\n           $feat->add_sub_SeqFeature($subfeat,'EXPAND')\n           $feat->add_sub_SeqFeature($subfeat,'EXPAND','sub_seqfeature_type')\n Function: adds a SeqFeature into a specific subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n           If EXPAND is used, the parents start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature,\n\t   optionally a sub_seqfeature type can be defined.\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n         : (optional) 'EXPAND'\n\t : (optional) 'sub_SeqFeature_type'"},"detail":"($self,$feat,$var1,$var2)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":516,"definition":"my","name":"$self","containerName":"add_sub_SeqFeature","localvar":"my"},{"kind":13,"line":516,"name":"$feat","containerName":"add_sub_SeqFeature"},{"kind":13,"line":516,"containerName":"add_sub_SeqFeature","name":"$var1"},{"containerName":"add_sub_SeqFeature","name":"$var2","kind":13,"line":516},{"kind":13,"line":517,"name":"$var1","containerName":"add_sub_SeqFeature"},{"name":"$var1","containerName":"add_sub_SeqFeature","kind":13,"line":517},{"kind":13,"line":518,"containerName":"add_sub_SeqFeature","name":"$var2"},{"kind":13,"line":518,"name":"$var2","containerName":"add_sub_SeqFeature"},{"localvar":"my","containerName":"add_sub_SeqFeature","name":"$expand","definition":"my","line":519,"kind":13},{"containerName":"add_sub_SeqFeature","name":"$ssf_type","kind":13,"line":519},{"kind":13,"line":519,"name":"$var1","containerName":"add_sub_SeqFeature"},{"name":"$var2","containerName":"add_sub_SeqFeature","kind":13,"line":519},{"name":"$expand","containerName":"add_sub_SeqFeature","line":520,"kind":13},{"containerName":"add_sub_SeqFeature","name":"$ssf_type","line":520,"kind":13},{"kind":13,"line":522,"containerName":"add_sub_SeqFeature","name":"$feat"},{"containerName":"add_sub_SeqFeature","name":"isa","line":522,"kind":12},{"line":523,"kind":13,"containerName":"add_sub_SeqFeature","name":"$self"},{"containerName":"add_sub_SeqFeature","name":"warn","kind":12,"line":523},{"name":"$expand","containerName":"add_sub_SeqFeature","line":526,"kind":13},{"kind":13,"line":527,"containerName":"add_sub_SeqFeature","name":"$self"},{"containerName":"add_sub_SeqFeature","name":"_expand_region","line":527,"kind":12},{"containerName":"add_sub_SeqFeature","name":"$feat","kind":13,"line":527},{"name":"$self","containerName":"add_sub_SeqFeature","line":529,"kind":13},{"containerName":"add_sub_SeqFeature","name":"contains","kind":12,"line":529},{"name":"$feat","containerName":"add_sub_SeqFeature","line":529,"kind":13},{"kind":13,"line":530,"name":"$self","containerName":"add_sub_SeqFeature"},{"kind":12,"line":530,"name":"throw","containerName":"add_sub_SeqFeature"},{"containerName":"add_sub_SeqFeature","name":"$ssf_type","line":534,"kind":13},{"kind":13,"line":534,"containerName":"add_sub_SeqFeature","name":"$ssf_type"},{"containerName":"add_sub_SeqFeature","name":"$self","line":536,"kind":13},{"name":"$ssf_type","containerName":"add_sub_SeqFeature","line":536,"kind":13},{"containerName":"add_sub_SeqFeature","name":"$self","kind":13,"line":537},{"containerName":"add_sub_SeqFeature","name":"$ssf_type","line":537,"kind":13}],"line":515,"kind":12},{"containerName":null,"name":"$feat","line":539,"kind":13},{"kind":12,"line":539,"name":"sub_SeqFeature_type","containerName":"main::"},{"containerName":null,"name":"$ssf_type","kind":13,"line":539},{"kind":13,"line":540,"containerName":null,"name":"%self"},{"kind":13,"line":540,"containerName":null,"name":"$ssf_type"},{"kind":13,"line":540,"containerName":null,"name":"$feat"},{"definition":"sub","containerName":"main::","signature":{"label":"flush_sub_SeqFeature($self,$ssf_type)","parameters":[{"label":"$self"},{"label":"$ssf_type"}],"documentation":"1;\n# $Id: Computation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by mark Fiers <m.w.e.j.fiers@plant.wag-ur.nl>\n#\n# Copyright Ewan Birney, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Computation - Computation SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Computation->new(\n                                -start => 10, -end => 100,\n\t\t\t\t-strand => -1, -primary => 'repeat',\n\t\t\t\t-program_name => 'GeneMark',\n\t\t\t\t-program_date => '12-5-2000',\n\t\t\t\t-program_version => 'x.y',\n\t\t\t\t-database_name => 'Arabidopsis',\n\t\t\t\t-database_date => '12-dec-2000',\n\t\t\t\t-computation_id => 2231,\n\t\t\t\t-score    => { no_score => 334 } );\n\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Computation extends the Generic seqfeature object with\na set of computation related fields and a more flexible set of storing\nmore types of score and subseqfeatures. It is compatible with the Generic\nSeqFeature object.\n\nThe new way of storing score values is similar to the tag structure in the \nGeneric object. For storing sets of subseqfeatures the array containg the\nsubseqfeatures is now a hash which contains arrays of seqfeatures\nBoth the score and subSeqfeature methods can be called in exactly the same\nway, the value's will be stored as a 'default' score or subseqfeature.\n\n\n#'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Mark Fiers\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\nMark Fiers E<lt>m.w.e.j.fiers@plant.wag-ur.nlE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritance. The fields\nthe actual object hash are:\n\n   _gsf_sub_hash  = reference to a hash containing sets of sub arrays\n   _gsf_score_hash= reference to a hash for the score values\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Computation;\nuse strict;\n\nuse base qw(Bio::SeqFeature::Generic);\n\t\t\t\t\t\t     \nsub new {\n    my ( $class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n\n    my ( $computation_id, \n\t$program_name, $program_date, $program_version,\n\t$database_name, $database_date, $database_version) =\n\t    $self->_rearrange([qw(COMPUTATION_ID\n\t\t\t\t  PROGRAM_NAME\n\t\t\t\t  PROGRAM_DATE\n\t\t\t\t  PROGRAM_VERSION\n\t\t\t\t  DATABASE_NAME\n\t\t\t\t  DATABASE_DATE\n\t\t\t\t  DATABASE_VERSION\n\t\t\t\t  )],@args);\n\n    $program_name\t    && $self->program_name($program_name);\n    $program_date\t    && $self->program_date($program_date);\n    $program_version  && $self->program_version($program_version);\n    $database_name    && $self->database_name($database_name);\n    $database_date    && $self->database_date($database_date);\n    $database_version && $self->database_version($database_version);\n    $computation_id   && $self->computation_id($computation_id);\n    \n    return $self;\n}  \n\n=head2 has_score\n\n Title   : has_score\n Usage   : $value = $self->has_score('some_score')\n Function: Tests wether a feature contains a score\n Returns : TRUE if the SeqFeature has the score,\n           and FALSE otherwise.\n Args    : The name of a score\n\n\nsub has_score {\n    my ($self, $score) = @_;\n    return unless defined $score;\n    return exists $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 add_score_value\n\n Title   : add_score_value\n Usage   : $self->add_score_value('P_value',224);\n Returns : TRUE on success\n Args    : score (string) and value (any scalar)\n\n\nsub add_score_value {\n   my ($self, $score, $value) = @_;\n   if( ! defined $score || ! defined $value ) { \n       $self->warn(\"must specify a valid $score and $value to add_score_value\");\n       return 0;\n   }\n\n   if ( !defined $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->{'_gsf_score_hash'}->{$score} = [];\n   }\n\n   push(@{$self->{'_gsf_score_hash'}->{$score}},$value);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $value = $comp_obj->score()\n           $comp_obj->score($value)\n Function: Returns the 'default' score or sets the 'default' score\n           This method exist for compatibility options           \n\t   It would equal ($comp_obj->each_score_value('default'))[0];\n Returns : A value\n Args    : (optional) a new value for the 'default' score \n\n\nsub score {\n    my ($self, $value) = @_;\n    my @v;\n    if (defined $value) {\n\n\tif( ref($value) =~ /HASH/i ) {\n\t    while( my ($t,$val) = each %{ $value } ) {\n\t\t$self->add_score_value($t,$val);\n\t    }\n\t} else {\n\t    @v = $value;\n\t    $self->add_score_value('default', $value);\n\t}\n\t\n    } else {       \n\t@v = $self->each_score_value('default');\n    }\n    return $v[0];\n}\n\n=head2 each_score_value\n\n Title   : each_score_value\n Usage   : @values = $gsf->each_score_value('note');\n Function: Returns a list of all the values stored\n           under a particular score.\n Returns : A list of scalars\n Args    : The name of the score\n\n\nsub each_score_value {\n   my ($self, $score) = @_;\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"asking for score value that does not exist $score\");\n       return;\n   }\n   return @{$self->{'_gsf_score_hash'}->{$score}};\n}\n\n\n=head2 all_scores\n\n Title   : all_scores\n Usage   : @scores = $feat->all_scores()\n Function: Get a list of all the scores in a feature\n Returns : An array of score names\n Args    : none\n\n\n\nsub all_scores {\n   my ($self, @args) = @_;\n\n   return keys %{$self->{'_gsf_score_hash'}};\n}\n\n\n=head2 remove_score\n\n Title   : remove_score\n Usage   : $feat->remove_score('some_score')\n Function: removes a score from this feature\n Returns : nothing\n Args    : score (string)\n\n\n\nsub remove_score {\n   my ($self, $score) = @_;\n\n   if ( ! exists $self->{'_gsf_score_hash'}->{$score} ) {\n       $self->warn(\"trying to remove a score that does not exist: $score\");\n   }\n\n   delete $self->{'_gsf_score_hash'}->{$score};\n}\n\n=head2 computation_id\n\n Title   : computation_id\n Usage   : $computation_id = $feat->computation_id()\n           $feat->computation_id($computation_id)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub computation_id {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_computation_id'} = $value;\n  }\n\n  return $self->{'_gsf_computation_id'};\n}\n\n\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $program_name = $feat->program_name()\n           $feat->program_name($program_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\n\nsub program_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_name'} = $value;\n  }\n\n  return $self->{'_gsf_program_name'};\n}\n\n=head2 program_date\n\n Title   : program_date\n Usage   : $program_date = $feat->program_date()\n           $feat->program_date($program_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_date'} = $value;\n  }\n\n  return $self->{'_gsf_program_date'};\n}\n\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $program_version = $feat->program_version()\n           $feat->program_version($program_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub program_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_program_version'} = $value;\n  }\n\n  return $self->{'_gsf_program_version'};\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $database_name = $feat->database_name()\n           $feat->database_name($database_name)\n Function: get/set on program name information\n Returns : string\n Args    : none if get, the new value if set\n\n\nsub database_name {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_name'} = $value;\n  }\n\n  return $self->{'_gsf_database_name'};\n}\n\n=head2 database_date\n\n Title   : database_date\n Usage   : $database_date = $feat->database_date()\n           $feat->database_date($database_date)\n Function: get/set on program date information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_date {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_date'} = $value;\n  }\n\n  return $self->{'_gsf_database_date'};\n}\n\n\n=head2 database_version\n\n Title   : database_version\n Usage   : $database_version = $feat->database_version()\n           $feat->database_version($database_version)\n Function: get/set on program version information\n Returns : date (string)\n Args    : none if get, the new value if set\n\n\n\nsub database_version {\n  my ($self,$value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_database_version'} = $value;\n  }\n\n  return $self->{'_gsf_database_version'};\n\n}\n\n=head2 sub_SeqFeature_type\n\n Title   : sub_SeqFeature_type\n Usage   : $sub_SeqFeature_type = $feat->sub_SeqFeature_type()\n           $feat->sub_SeqFeature_type($sub_SeqFeature_type)\n Function: sub_SeqFeature_type is automatically set when adding\n           a sub_computation (sub_SeqFeature) to a computation object\n Returns : sub_SeqFeature_type (string)\n Args    : none if get, the new value if set\n\n\nsub sub_SeqFeature_type {\n  my ($self, $value) = @_;\n\n  if (defined($value)) {\n      $self->{'_gsf_sub_SeqFeature_type'} = $value;\n  }\n  return $self->{'_gsf_sub_SeqFeature_type'};\n}\n\n=head2 all_sub_SeqFeature_types\n\n Title   : all_Sub_SeqFeature_types\n Usage   : @all_sub_seqfeature_types = $comp->all_Sub_SeqFeature_types();\n Function: Returns an array with all subseqfeature types\n Returns : An array\n Args    : none\n\n\nsub all_sub_SeqFeature_types {\n   my ($self) = @_;\n   return keys ( %{$self->{'gsf_sub_hash'}} );\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature('sub_feature_type')\n Usage   : @feats = $feat->sub_SeqFeature();\n           @feats = $feat->sub_SeqFeature('sub_feature_type');           \n Function: Returns an array of sub Sequence Features of a specific\n           type or, if the type is ommited, all sub Sequence Features\n Returns : An array\n Args    : (optional) a sub_SeqFeature type (ie exon, pattern)\n\n\nsub sub_SeqFeature {\n   my ($self, $ssf_type) = @_;\n   my (@return_array) = ();\n   if ($ssf_type eq '') {\n       #return all sub_SeqFeatures\n       foreach (keys ( %{$self->{'gsf_sub_hash'}} )){\n\t  push @return_array, @{$self->{'gsf_sub_hash'}->{$_}};\t            \n       }\n       return @return_array;\n   } else {\n       if (defined ($self->{'gsf_sub_hash'}->{$ssf_type})) {\n           return @{$self->{'gsf_sub_hash'}->{$ssf_type}};\t\n       } else {\n           $self->warn(\"$ssf_type is not a valid sub SeqFeature type\");\n       }\n   }\n}\n\n=head2 add_sub_SeqFeature\n\n Title   : add_sub_SeqFeature\n Usage   : $feat->add_sub_SeqFeature($subfeat);\n           $feat->add_sub_SeqFeature($subfeat,'sub_seqfeature_type')\n           $feat->add_sub_SeqFeature($subfeat,'EXPAND')\n           $feat->add_sub_SeqFeature($subfeat,'EXPAND','sub_seqfeature_type')\n Function: adds a SeqFeature into a specific subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n           If EXPAND is used, the parents start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature,\n\t   optionally a sub_seqfeature type can be defined.\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n         : (optional) 'EXPAND'\n\t : (optional) 'sub_SeqFeature_type'\n\n\nsub add_sub_SeqFeature{\n   my ($self,$feat,$var1, $var2) = @_;\n   $var1 = '' unless( defined $var1);\n   $var2 = '' unless( defined $var2);   \n   my ($expand, $ssf_type) = ('', $var1 . $var2);\t\n   $expand = 'EXPAND' if ($ssf_type =~ s/EXPAND//);\n\n   if ( !$feat->isa('Bio::SeqFeatureI') ) {\n       $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n   }\n\n   if($expand eq 'EXPAND') {\n       $self->_expand_region($feat);\n   } else {\n       if ( !$self->contains($feat) ) {\n\t   $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n       }\n   }\n\n   $ssf_type = 'default' if ($ssf_type eq '');\n  \n   if (!(defined ($self->{'gsf_sub_hash'}->{$ssf_type}))) {     \n      @{$self->{'gsf_sub_hash'}->{$ssf_type}} = ();\n   } \n   $feat->sub_SeqFeature_type($ssf_type);\n   push @{$self->{'gsf_sub_hash'}->{$ssf_type}}, $feat;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $sf->flush_sub_SeqFeature\n           $sf->flush_sub_SeqFeature('sub_SeqFeature_type');\t\n Function: Removes all sub SeqFeature or all sub SeqFeatures\n \t   of a specified type \n           (if you want to remove a more specific subset, take\n\t    an array of them all, flush them, and add\n            back only the guys you want)\n Example :\n Returns : none\n Args    : none"},"detail":"($self,$ssf_type)","kind":12,"children":[{"line":561,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"flush_sub_SeqFeature"},{"containerName":"flush_sub_SeqFeature","name":"$ssf_type","kind":13,"line":561},{"line":562,"kind":13,"name":"$ssf_type","containerName":"flush_sub_SeqFeature"},{"name":"$self","containerName":"flush_sub_SeqFeature","line":563,"kind":13},{"containerName":"flush_sub_SeqFeature","name":"$ssf_type","kind":13,"line":563},{"name":"$self","containerName":"flush_sub_SeqFeature","line":564,"kind":13},{"line":564,"kind":13,"name":"$ssf_type","containerName":"flush_sub_SeqFeature"},{"containerName":"flush_sub_SeqFeature","name":"$self","kind":13,"line":566},{"line":566,"kind":12,"containerName":"flush_sub_SeqFeature","name":"warn"},{"name":"$self","containerName":"flush_sub_SeqFeature","kind":13,"line":569}],"line":560,"name":"flush_sub_SeqFeature","range":{"start":{"character":0,"line":560},"end":{"character":9999,"line":571}}}],"version":5}