{"version":5,"vars":[{"containerName":"","name":"base","line":113,"kind":2},{"name":"_initialize","range":{"start":{"character":0,"line":133},"end":{"line":145,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: excel.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::excel\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2005.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2005.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::excel - sequence input/output stream from a\n                    MSExcel-formatted table\n\n=head1 SYNOPSIS\n\n  #It is probably best not to use this object directly, but\n  #rather go through the SeqIO handler system. Go:\n\n  $stream = Bio::SeqIO->new(-file => $filename, -format => 'excel');\n\n  while ( my $seq = $stream->next_seq() ) {\n\t# do something with $seq\n  }\n\n=head1 DESCRIPTION\n\nThis class transforms records in a MS Excel workbook file into\nBio::Seq objects. It is derived from the table format module and\nmerely defines additional properties and overrides the way to get data\nfrom the file and advance to the next record.\n\nThe module permits specifying which columns hold which type of\nannotation. The semantics of certain attributes, if present, are\npre-defined, e.g., accession number and sequence. Additional\nattributes may be added to the annotation bundle. See\nL<Bio::SeqIO::table> for a complete list of parameters and\ncapabilities.\n\nYou may also specify the worksheet from which to obtain the data, and\nafter finishing one worksheet you may change the name to keep reading\nfrom another worksheet (in the same file).\n\nThis module depends on Spreadsheet::ParseExcel to parse the underlying\nExcel file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\n\nBug reports can be submitted via email or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::excel;\nuse strict;\n\nuse Bio::SeqIO;\nuse Spreadsheet::ParseExcel;\n#use Spreadsheet::ParseExcel::Workbook;\n\nuse base qw(Bio::SeqIO::table);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::SeqIO->new(-file => $filename, -format => 'excel')\n Function: Returns a new seqstream\n Returns : A Bio::SeqIO stream for a MS Excel format\n\n Args    : Supports the same named parameters as Bio::SeqIO::table,\n           except -delim, which obviously does not apply to a binary\n           format. In addition, the following parameters are supported.\n\n             -worksheet the name of the worksheet holding the table;\n                        if unspecified the first worksheet will be\n                        used","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"kind":12,"line":133,"children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":134},{"kind":13,"line":134,"name":"@args","containerName":"_initialize"},{"line":137,"kind":13,"name":"$self","containerName":"_initialize"},{"line":137,"kind":13,"name":"@args","containerName":"_initialize"},{"localvar":"my","definition":"my","name":"$worksheet","containerName":"_initialize","line":140,"kind":13},{"line":140,"kind":13,"name":"$self","containerName":"_initialize"},{"line":140,"kind":12,"name":"_rearrange","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","line":140,"kind":13},{"line":143,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":143,"containerName":"_initialize","name":"worksheet"},{"kind":13,"line":143,"name":"$worksheet","containerName":"_initialize"}]},{"line":137,"kind":12,"containerName":"_initialize","name":"SUPER"},{"range":{"end":{"character":9999,"line":176},"start":{"line":165,"character":0}},"definition":"sub","name":"worksheet","containerName":"main::","children":[{"kind":13,"line":166,"containerName":"worksheet","definition":"my","name":"$self","localvar":"my"},{"line":169,"kind":13,"localvar":"my","definition":"my","name":"$sheetname","containerName":"worksheet"},{"containerName":"worksheet","name":"$self","kind":13,"line":172},{"line":172,"kind":12,"containerName":"worksheet","name":"_worksheet"},{"name":"$sheetname","containerName":"worksheet","kind":13,"line":172},{"line":173,"kind":13,"name":"$self","containerName":"worksheet"},{"line":173,"kind":13,"name":"$sheetname","containerName":"worksheet"},{"name":"$self","containerName":"worksheet","kind":13,"line":175}],"line":165,"kind":12},{"line":194,"children":[{"name":"$self","definition":"my","containerName":"close","localvar":"my","kind":13,"line":195},{"kind":13,"line":197,"containerName":"close","name":"$self"},{"kind":12,"line":197,"name":"_worksheet","containerName":"close"},{"kind":13,"line":199,"containerName":"close","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":194},"end":{"line":200,"character":9999}},"containerName":"main::","name":"close","definition":"sub"},{"name":"SUPER","containerName":"close","line":199,"kind":12},{"name":"_worksheet","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":228}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_worksheet","line":224,"kind":13},{"name":"$self","containerName":"_worksheet","kind":13,"line":226},{"kind":13,"line":227,"containerName":"_worksheet","name":"$self"}],"line":223},{"kind":12,"line":248,"children":[{"kind":13,"line":249,"containerName":"_next_record","definition":"my","name":"$self","localvar":"my"},{"line":251,"kind":13,"localvar":"my","containerName":"_next_record","definition":"my","name":"$wsheet"},{"containerName":"_next_record","name":"$self","line":251,"kind":13},{"line":251,"kind":12,"name":"_worksheet","containerName":"_next_record"},{"kind":13,"line":252,"containerName":"_next_record","name":"$wsheet"},{"line":254,"kind":13,"localvar":"my","containerName":"_next_record","name":"$wbook","definition":"my"},{"kind":12,"line":254,"name":"Parse","containerName":"_next_record"},{"line":254,"kind":13,"name":"$self","containerName":"_next_record"},{"kind":12,"line":254,"containerName":"_next_record","name":"_fh"},{"kind":13,"line":255,"containerName":"_next_record","name":"$wsheet"},{"name":"$wbook","containerName":"_next_record","kind":13,"line":255},{"line":255,"kind":12,"name":"Worksheet","containerName":"_next_record"},{"containerName":"_next_record","name":"$self","line":255,"kind":13},{"kind":12,"line":255,"containerName":"_next_record","name":"worksheet"},{"kind":13,"line":257,"containerName":"_next_record","name":"$self"},{"name":"_worksheet","containerName":"_next_record","kind":12,"line":257},{"containerName":"_next_record","name":"$wsheet","line":257,"kind":13},{"name":"$self","containerName":"_next_record","kind":13,"line":259},{"kind":13,"line":263,"containerName":"_next_record","name":"$wsheet"},{"kind":13,"line":266,"containerName":"_next_record","name":"$minrow","definition":"my","localvar":"my"},{"kind":13,"line":266,"containerName":"_next_record","name":"$maxrow"},{"name":"$wsheet","containerName":"_next_record","kind":13,"line":266},{"containerName":"_next_record","name":"RowRange","line":266,"kind":12},{"name":"$self","containerName":"_next_record","kind":13,"line":267},{"containerName":"_next_record","name":"$maxrow","kind":13,"line":267},{"name":"$self","containerName":"_next_record","kind":13,"line":272}],"containerName":"main::","definition":"sub","name":"_next_record","range":{"end":{"line":276,"character":9999},"start":{"line":248,"character":0}}},{"name":"Spreadsheet","containerName":"ParseExcel::Workbook","kind":12,"line":254},{"kind":12,"line":295,"children":[{"containerName":"_get_row_values","name":"$self","definition":"my","localvar":"my","kind":13,"line":296},{"kind":13,"line":299,"name":"$wsheet","definition":"my","containerName":"_get_row_values","localvar":"my"},{"containerName":"_get_row_values","name":"$self","line":299,"kind":13},{"name":"_worksheet","containerName":"_get_row_values","kind":12,"line":299},{"localvar":"my","containerName":"_get_row_values","definition":"my","name":"$colmin","line":300,"kind":13},{"kind":13,"line":300,"containerName":"_get_row_values","name":"$colmax"},{"line":300,"kind":13,"name":"$wsheet","containerName":"_get_row_values"},{"kind":12,"line":300,"name":"ColRange","containerName":"_get_row_values"},{"containerName":"_get_row_values","definition":"my","name":"@cols","localvar":"my","kind":13,"line":303},{"line":304,"kind":13,"localvar":"my","containerName":"_get_row_values","name":"$row","definition":"my"},{"containerName":"_get_row_values","name":"$self","line":304,"kind":13},{"line":305,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"_get_row_values"},{"kind":13,"line":305,"name":"$colmin","containerName":"_get_row_values"},{"kind":13,"line":305,"containerName":"_get_row_values","name":"$i"},{"kind":13,"line":305,"name":"$colmax","containerName":"_get_row_values"},{"line":305,"kind":13,"name":"$i","containerName":"_get_row_values"},{"definition":"my","name":"$cell","containerName":"_get_row_values","localvar":"my","kind":13,"line":306},{"kind":13,"line":306,"name":"$wsheet","containerName":"_get_row_values"},{"line":306,"kind":12,"name":"Cell","containerName":"_get_row_values"},{"name":"$row","containerName":"_get_row_values","kind":13,"line":306},{"name":"$i","containerName":"_get_row_values","line":306,"kind":13},{"name":"@cols","containerName":"_get_row_values","kind":13,"line":307},{"containerName":"_get_row_values","name":"$cell","line":307,"kind":13},{"line":307,"kind":13,"name":"$cell","containerName":"_get_row_values"},{"name":"Value","containerName":"_get_row_values","line":307,"kind":12},{"kind":13,"line":307,"name":"$cell","containerName":"_get_row_values"},{"containerName":"_get_row_values","name":"@cols","kind":13,"line":310}],"containerName":"main::","definition":"sub","name":"_get_row_values","range":{"end":{"character":9999,"line":311},"start":{"character":0,"line":295}}}]}