{"version":5,"vars":[{"kind":2,"line":78,"name":"vars","containerName":""},{"line":80,"kind":2,"name":"base","containerName":""},{"range":{"start":{"line":95,"character":0},"end":{"line":108,"character":9999}},"name":"new","detail":"($caller,$seq,$seq_h,$ann_l)","signature":{"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations","parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"$seq_h"},{"label":"$ann_l"}],"label":"new($caller,$seq,$seq_h,$ann_l)"},"containerName":"main::","definition":"sub","line":95,"children":[{"definition":"my","name":"$caller","containerName":"new","localvar":"my","kind":13,"line":96},{"line":96,"kind":13,"name":"$seq","containerName":"new"},{"line":96,"kind":13,"containerName":"new","name":"$seq_h"},{"containerName":"new","name":"$ann_l","line":96,"kind":13},{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":97,"kind":13},{"kind":13,"line":97,"name":"$caller","containerName":"new"},{"name":"$caller","containerName":"new","line":97,"kind":13},{"line":99,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"kind":13,"line":100,"name":"$seq","containerName":"new"},{"containerName":"new","name":"$seq_h","kind":13,"line":103},{"kind":13,"line":104,"containerName":"new","name":"$ann_l"},{"name":"$class","containerName":"new","line":105,"kind":13},{"kind":13,"line":107,"name":"$self","containerName":"new"}],"kind":12},{"name":"seq","kind":12,"line":100},{"kind":12,"line":101,"name":"curr_feats"},{"name":"curr_coords","kind":12,"line":102},{"kind":12,"line":103,"name":"seq_h"},{"name":"ann_l","kind":12,"line":104},{"containerName":"main::","definition":"sub","detail":"($self,$length,$tags)","signature":{"parameters":[{"label":"$self"},{"label":"$length"},{"label":"$tags"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes","label":"add_source($self,$length,$tags)"},"kind":12,"line":120,"children":[{"line":121,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_source"},{"kind":13,"line":121,"name":"$length","containerName":"add_source"},{"line":121,"kind":13,"name":"$tags","containerName":"add_source"},{"containerName":"add_source","name":"$feat","definition":"my","localvar":"my","kind":13,"line":122},{"line":122,"kind":12,"name":"new","containerName":"add_source"},{"containerName":"add_source","name":"$length","kind":13,"line":124},{"name":"$tags","containerName":"add_source","line":126,"kind":13}],"name":"add_source","range":{"end":{"line":126,"character":9999},"start":{"line":120,"character":0}}},{"line":122,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"$val","definition":"my","containerName":null,"localvar":"my","kind":13,"line":127},{"name":"%tags","containerName":null,"kind":13,"line":127},{"kind":13,"line":128,"containerName":null,"name":"$feat"},{"name":"add_tag_value","containerName":"main::","line":128,"kind":12},{"kind":13,"line":128,"containerName":null,"name":"$val"},{"containerName":null,"name":"$feat","kind":13,"line":132},{"name":"has_gene","range":{"start":{"character":0,"line":148},"end":{"character":9999,"line":185}},"kind":12,"line":148,"children":[{"kind":13,"line":149,"name":"$self","definition":"my","containerName":"has_gene","localvar":"my"},{"containerName":"has_gene","name":"$gene","line":149,"kind":13},{"line":149,"kind":13,"containerName":"has_gene","name":"$gname"},{"containerName":"has_gene","name":"$id","line":149,"kind":13},{"name":"$gene","containerName":"has_gene","kind":13,"line":156},{"kind":13,"line":157,"containerName":"has_gene","name":"$self"},{"kind":13,"line":158,"name":"$self","containerName":"has_gene"},{"name":"$id","containerName":"has_gene","kind":13,"line":165},{"line":165,"kind":13,"name":"$self","containerName":"has_gene"},{"containerName":"has_gene","name":"$self","line":166,"kind":13},{"containerName":"has_gene","name":"$id","line":166,"kind":13},{"name":"$gname","containerName":"has_gene","kind":13,"line":168},{"line":168,"kind":13,"containerName":"has_gene","name":"$self"},{"line":169,"kind":13,"name":"$self","containerName":"has_gene"},{"name":"$gname","containerName":"has_gene","line":169,"kind":13},{"definition":"my","name":"$tags","containerName":"has_gene","localvar":"my","kind":13,"line":172},{"containerName":"has_gene","name":"$child","definition":"my","localvar":"my","kind":13,"line":174},{"kind":13,"line":174,"containerName":"has_gene","name":"$gene"},{"containerName":"has_gene","definition":"my","name":"$name","localvar":"my","kind":13,"line":175},{"line":175,"kind":13,"containerName":"has_gene","name":"$child"},{"name":"$name","containerName":"has_gene","line":177,"kind":13},{"line":178,"kind":13,"name":"$tags","containerName":"has_gene"},{"line":179,"kind":13,"name":"$tags","containerName":"has_gene"},{"containerName":"has_gene","name":"$self","kind":13,"line":179},{"kind":12,"line":179,"name":"dbxref","containerName":"has_gene"},{"name":"$child","containerName":"has_gene","kind":13,"line":179},{"containerName":"has_gene","name":"$name","kind":13,"line":181},{"name":"$self","containerName":"has_gene","line":182,"kind":13},{"name":"complain","containerName":"has_gene","kind":12,"line":182}],"containerName":"main::","definition":"sub","detail":"($self,$gene,$gname,$id)","signature":{"label":"has_gene($self,$gene,$gname,$id)","documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)","parameters":[{"label":"$self"},{"label":"$gene"},{"label":"$gname"},{"label":"$id"}]}},{"line":157,"kind":12,"name":"curr_gene"},{"kind":12,"line":158,"name":"curr_gene"},{"name":"curr_ltag","line":165,"kind":12},{"line":166,"kind":12,"name":"curr_ltag"},{"line":168,"kind":12,"name":"curr_gname"},{"line":169,"kind":12,"name":"curr_gname"},{"name":"Children","kind":12,"line":174},{"line":175,"kind":12,"name":"Name"},{"name":"dbxref","kind":12,"line":178},{"name":"dbxref","kind":12,"line":179},{"localvar":"my","definition":"my","name":"$feat","containerName":null,"line":187,"kind":13},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":187},{"containerName":"main::","name":"new","kind":12,"line":187},{"containerName":null,"definition":"my","name":"%seen","localvar":"my","kind":13,"line":190},{"kind":13,"line":191,"containerName":null,"name":"%tags"},{"line":192,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$val"},{"containerName":null,"name":"%tags","line":192,"kind":13},{"line":193,"kind":13,"name":"$feat","containerName":null},{"line":193,"kind":12,"name":"add_tag_value","containerName":"main::"},{"name":"$val","containerName":null,"kind":13,"line":193},{"containerName":null,"name":"%seen","line":193,"kind":13},{"name":"$val","containerName":null,"line":193,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":197},{"name":"curr_gene","line":197,"kind":12},{"line":197,"kind":13,"containerName":null,"name":"$feat"},{"line":198,"kind":13,"name":"$feat","containerName":null},{"children":[{"localvar":"my","containerName":"_has_CDS","definition":"my","name":"$self","line":213,"kind":13},{"line":213,"kind":13,"containerName":"_has_CDS","name":"$transcript"},{"name":"$transcript","containerName":"_has_CDS","kind":13,"line":215},{"line":216,"kind":13,"containerName":"_has_CDS","name":"$self"},{"name":"$self","containerName":"_has_CDS","kind":13,"line":217},{"localvar":"my","containerName":"_has_CDS","definition":"my","name":"$tags","line":224,"kind":13},{"name":"$self","containerName":"_has_CDS","kind":13,"line":224},{"line":225,"kind":13,"name":"$self","containerName":"_has_CDS"},{"line":225,"kind":13,"containerName":"_has_CDS","name":"$self"},{"line":225,"kind":12,"containerName":"_has_CDS","name":"_add_CDS"},{"name":"$transcript","containerName":"_has_CDS","kind":13,"line":225},{"name":"$tags","containerName":"_has_CDS","line":225,"kind":13}],"line":212,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$transcript"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature","label":"_has_CDS($self,$transcript)"},"detail":"($self,$transcript)","definition":"sub","containerName":"main::","range":{"start":{"line":212,"character":0},"end":{"line":227,"character":9999}},"name":"_has_CDS"},{"name":"curr_cds","kind":12,"line":216},{"line":217,"kind":12,"name":"curr_cds"},{"name":"curr_tags","line":224,"kind":12},{"name":"curr_cds","line":225,"kind":12},{"signature":{"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$type"},{"label":"$id"},{"label":"$tags"},{"label":"$feats"}],"label":"add_annotation($self,$seq,$type,$id,$tags,$feats)"},"detail":"($self,$seq,$type,$id,$tags,$feats)","definition":"sub","containerName":"main::","children":[{"line":244,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_annotation"},{"name":"$seq","containerName":"add_annotation","kind":13,"line":244},{"name":"$type","containerName":"add_annotation","line":244,"kind":13},{"containerName":"add_annotation","name":"$id","kind":13,"line":244},{"line":244,"kind":13,"name":"$tags","containerName":"add_annotation"},{"containerName":"add_annotation","name":"$feats","kind":13,"line":244},{"containerName":"add_annotation","name":"$self","line":247,"kind":13},{"line":247,"kind":12,"containerName":"add_annotation","name":"has_gene"},{"containerName":"add_annotation","name":"$self","kind":13,"line":249},{"line":249,"kind":12,"containerName":"add_annotation","name":"_add_generic_annotation"},{"kind":13,"line":253,"containerName":"add_annotation","definition":"my","name":"$feat","localvar":"my"},{"name":"$type","containerName":"add_annotation","kind":13,"line":255},{"kind":13,"line":256,"name":"$feat","containerName":"add_annotation"},{"kind":13,"line":256,"name":"$self","containerName":"add_annotation"},{"kind":12,"line":256,"containerName":"add_annotation","name":"has_gene"},{"name":"$feat","containerName":"add_annotation","kind":13,"line":257},{"kind":12,"line":257,"containerName":"add_annotation","name":"add_tag_value"},{"containerName":"add_annotation","name":"$self","line":257,"kind":13},{"containerName":"add_annotation","name":"$id","line":257,"kind":13},{"name":"$feat","containerName":"add_annotation","line":258,"kind":13},{"containerName":"add_annotation","name":"has_tag","line":258,"kind":12},{"line":261,"kind":13,"name":"$feat","containerName":"add_annotation"},{"containerName":"add_annotation","name":"new","line":261,"kind":12},{"line":262,"kind":13,"containerName":"add_annotation","name":"$feat"},{"line":262,"kind":12,"name":"primary_tag","containerName":"add_annotation"},{"containerName":"add_annotation","name":"$type","line":262,"kind":13},{"name":"$gene","definition":"my","containerName":"add_annotation","localvar":"my","kind":13,"line":263},{"line":263,"kind":13,"containerName":"add_annotation","name":"$self"},{"name":"has_gene","containerName":"add_annotation","kind":12,"line":263},{"line":264,"kind":13,"containerName":"add_annotation","name":"$gene"},{"containerName":"add_annotation","name":"add_tag_value","kind":12,"line":264},{"name":"$self","containerName":"add_annotation","line":264,"kind":13},{"kind":13,"line":264,"containerName":"add_annotation","name":"$id"},{"line":265,"kind":13,"containerName":"add_annotation","name":"$gene"},{"line":265,"kind":12,"containerName":"add_annotation","name":"has_tag"},{"name":"$feat","containerName":"add_annotation","kind":13,"line":266},{"kind":12,"line":266,"containerName":"add_annotation","name":"add_tag_value"},{"line":266,"kind":13,"containerName":"add_annotation","name":"$self"},{"containerName":"add_annotation","name":"$id","kind":13,"line":266},{"containerName":"add_annotation","name":"$feat","line":267,"kind":13},{"kind":12,"line":267,"containerName":"add_annotation","name":"has_tag"},{"containerName":"add_annotation","name":"$tags","line":269,"kind":13}],"line":243,"kind":12,"range":{"start":{"line":243,"character":0},"end":{"line":269,"character":9999}},"name":"add_annotation"},{"kind":12,"line":257,"name":"gene"},{"kind":12,"line":257,"name":"curr_gname"},{"name":"Bio","containerName":"SeqFeature::Generic","line":261,"kind":12},{"name":"gene","line":264,"kind":12},{"line":264,"kind":12,"name":"curr_gname"},{"kind":12,"line":266,"name":"gene"},{"kind":12,"line":266,"name":"curr_gname"},{"line":271,"kind":13,"containerName":null,"name":"%tags"},{"kind":12,"line":271,"name":"type"},{"containerName":null,"name":"$feat","kind":13,"line":272},{"line":272,"kind":12,"name":"add_tag_value","containerName":"main::"},{"line":272,"kind":12,"name":"gene"},{"kind":13,"line":272,"name":"%tags","containerName":null},{"name":"name","line":272,"kind":12},{"containerName":null,"name":"$feat","line":273,"kind":13},{"kind":12,"line":273,"name":"has_tag","containerName":"main::"},{"line":274,"kind":13,"name":"%tags","containerName":null},{"name":"name","kind":12,"line":274},{"containerName":null,"name":"%tags","kind":13,"line":277},{"line":278,"kind":13,"name":"$feat","containerName":null},{"name":"has_tag","containerName":"main::","kind":12,"line":278},{"line":279,"kind":13,"localvar":"my","containerName":null,"name":"$val","definition":"my"},{"line":279,"kind":13,"containerName":null,"name":"%tags"},{"line":280,"kind":13,"containerName":null,"name":"$feat"},{"line":280,"kind":12,"name":"add_tag_value","containerName":"main::"},{"kind":13,"line":280,"containerName":null,"name":"$val"},{"containerName":null,"name":"$feat","kind":13,"line":286},{"name":"strand","containerName":"main::","kind":12,"line":286},{"kind":13,"line":286,"name":"%self","containerName":null},{"name":"curr_strand","kind":12,"line":286},{"kind":13,"line":287,"name":"$feat","containerName":null},{"name":"start","containerName":"main::","kind":12,"line":287},{"kind":13,"line":287,"name":"%self","containerName":null},{"kind":12,"line":287,"name":"curr_coords"},{"name":"$feat","containerName":null,"line":288,"kind":13},{"name":"end","containerName":"main::","line":288,"kind":12},{"kind":13,"line":288,"containerName":null,"name":"%self"},{"name":"curr_coords","kind":12,"line":288},{"containerName":null,"definition":"my","name":"@annotations","localvar":"my","kind":13,"line":291},{"line":291,"kind":13,"containerName":null,"name":"$feat"},{"line":294,"kind":13,"name":"$self","containerName":null},{"name":"has_gene","containerName":"main::","kind":12,"line":294},{"containerName":null,"name":"%type","line":294,"kind":13},{"localvar":"my","containerName":null,"name":"$gene","definition":"my","line":295,"kind":13},{"containerName":null,"name":"$self","line":295,"kind":13},{"containerName":"main::","name":"has_gene","kind":12,"line":295},{"kind":13,"line":296,"containerName":null,"name":"$gene"},{"line":296,"kind":12,"containerName":"main::","name":"strand"},{"kind":13,"line":296,"containerName":null,"name":"%self"},{"name":"curr_strand","kind":12,"line":296},{"kind":13,"line":297,"name":"$gene","containerName":null},{"line":297,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"name":"%self","kind":13,"line":297},{"line":297,"kind":12,"name":"curr_coords"},{"containerName":null,"name":"$gene","line":298,"kind":13},{"kind":12,"line":298,"containerName":"main::","name":"end"},{"name":"%self","containerName":null,"line":298,"kind":13},{"name":"curr_coords","line":298,"kind":12},{"containerName":null,"name":"@annotations","line":299,"kind":13},{"line":299,"kind":13,"name":"$gene","containerName":null},{"line":300,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_gene","kind":12,"line":300},{"name":"%feats","containerName":null,"line":304,"kind":13},{"kind":13,"line":305,"containerName":null,"name":"$self"},{"containerName":"main::","name":"complain","kind":12,"line":305},{"kind":13,"line":306,"name":"@annotations","containerName":null},{"localvar":"my","containerName":null,"name":"$seqid","definition":"my","line":310,"kind":13},{"kind":13,"line":310,"containerName":null,"name":"$seq"},{"line":310,"kind":12,"name":"id","containerName":"main::"},{"localvar":"my","name":"$list","definition":"my","containerName":null,"line":311,"kind":13},{"line":311,"kind":13,"name":"%self","containerName":null},{"name":"ann_l","kind":12,"line":311},{"name":"@list","containerName":null,"kind":13,"line":314},{"kind":13,"line":314,"containerName":null,"name":"@annotations"},{"line":314,"kind":12,"containerName":"main::","name":"start"},{"kind":13,"line":314,"name":"@list","containerName":null},{"line":314,"kind":12,"containerName":"main::","name":"start"},{"name":"$list","containerName":null,"kind":13,"line":315},{"containerName":null,"name":"@annotations","line":315,"kind":13},{"containerName":null,"name":"$list","kind":13,"line":318},{"name":"@annotations","containerName":null,"kind":13,"line":318},{"containerName":null,"name":"%self","line":322,"kind":13},{"line":322,"kind":12,"name":"curr_gene"},{"kind":13,"line":323,"name":"%self","containerName":null},{"name":"curr_ltag","line":323,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":324},{"kind":12,"line":324,"name":"curr_gname"},{"kind":13,"line":325,"name":"%self","containerName":null},{"name":"curr_coords","kind":12,"line":325},{"kind":13,"line":326,"containerName":null,"name":"%self"},{"kind":12,"line":326,"name":"curr_feats"},{"kind":13,"line":327,"name":"%self","containerName":null},{"kind":12,"line":327,"name":"curr_strand"},{"name":"%self","containerName":null,"kind":13,"line":328},{"kind":12,"line":328,"name":"ann_seq"},{"name":"$seq","containerName":null,"kind":13,"line":328},{"containerName":null,"name":"$self","kind":13,"line":329},{"kind":12,"line":329,"containerName":"main::","name":"flush"},{"detail":"($self,$seq,$type,$id,$tags,$feats)","signature":{"label":"_add_generic_annotation($self,$seq,$type,$id,$tags,$feats)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$type"},{"label":"$id"},{"label":"$tags"},{"label":"$feats"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects"},"containerName":"main::","definition":"sub","line":347,"children":[{"containerName":"_add_generic_annotation","name":"$self","definition":"my","localvar":"my","kind":13,"line":348},{"kind":13,"line":348,"name":"$seq","containerName":"_add_generic_annotation"},{"line":348,"kind":13,"name":"$type","containerName":"_add_generic_annotation"},{"line":348,"kind":13,"containerName":"_add_generic_annotation","name":"$id"},{"kind":13,"line":348,"containerName":"_add_generic_annotation","name":"$tags"},{"line":348,"kind":13,"name":"$feats","containerName":"_add_generic_annotation"},{"line":350,"kind":13,"containerName":"_add_generic_annotation","name":"$feats"},{"name":"primary_tag","containerName":"_add_generic_annotation","kind":12,"line":351},{"line":351,"kind":13,"name":"$type","containerName":"_add_generic_annotation"},{"line":354,"kind":13,"containerName":"_add_generic_annotation","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":354},"start":{"line":347,"character":0}},"name":"_add_generic_annotation"},{"kind":12,"line":354,"name":"ann_l"},{"containerName":null,"name":"$feats","line":354,"kind":13},{"line":356,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_coords","kind":12,"line":356},{"containerName":null,"name":"%self","kind":13,"line":357},{"kind":12,"line":357,"name":"curr_feats"},{"kind":13,"line":358,"name":"%self","containerName":null},{"kind":12,"line":358,"name":"curr_strand"},{"line":359,"kind":13,"name":"%self","containerName":null},{"name":"ann_seq","line":359,"kind":12},{"name":"$seq","containerName":null,"line":359,"kind":13},{"kind":13,"line":360,"name":"$self","containerName":null},{"name":"flush","containerName":"main::","kind":12,"line":360},{"line":379,"children":[{"containerName":"feature_set","definition":"my","name":"$self","localvar":"my","kind":13,"line":380},{"line":380,"kind":13,"name":"$id","containerName":"feature_set"},{"kind":13,"line":380,"name":"$gname","containerName":"feature_set"},{"line":380,"kind":13,"containerName":"feature_set","name":"$set"},{"line":380,"kind":13,"name":"$anntype","containerName":"feature_set"},{"line":381,"kind":13,"localvar":"my","name":"$stype","definition":"my","containerName":"feature_set"},{"name":"$set","containerName":"feature_set","kind":13,"line":381},{"line":382,"kind":13,"containerName":"feature_set","name":"$self"},{"containerName":"feature_set","name":"$self","line":383,"kind":13},{"kind":13,"line":384,"containerName":"feature_set","name":"$self"},{"line":385,"kind":13,"containerName":"feature_set","name":"$self"},{"line":386,"kind":13,"localvar":"my","containerName":"feature_set","definition":"my","name":"@feats"},{"kind":13,"line":387,"definition":"my","name":"$tags","containerName":"feature_set","localvar":"my"},{"kind":13,"line":387,"name":"$self","containerName":"feature_set"},{"localvar":"my","definition":"my","name":"$sname","containerName":"feature_set","line":388,"kind":13},{"containerName":"feature_set","name":"$set","kind":13,"line":388},{"name":"$set","containerName":"feature_set","kind":13,"line":389},{"kind":13,"line":391,"containerName":"feature_set","name":"$set"},{"line":392,"kind":13,"containerName":"feature_set","name":"$tags"},{"line":392,"kind":13,"name":"$set","containerName":"feature_set"},{"localvar":"my","definition":"my","name":"@fcount","containerName":"feature_set","line":395,"kind":13},{"containerName":"feature_set","name":"$set","line":395,"kind":13}],"kind":12,"detail":"($self,$id,$gname,$set,$anntype)","signature":{"parameters":[{"label":"$self"},{"label":"$id"},{"label":"$gname"},{"label":"$set"},{"label":"$anntype"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation","label":"feature_set($self,$id,$gname,$set,$anntype)"},"containerName":"main::","definition":"sub","range":{"end":{"line":395,"character":9999},"start":{"character":0,"line":379}},"name":"feature_set"},{"name":"_type","line":381,"kind":12},{"kind":12,"line":381,"name":"Characters"},{"name":"curr_loc","kind":12,"line":382},{"kind":12,"line":383,"name":"curr_tags"},{"line":384,"kind":12,"name":"curr_subfeats"},{"name":"curr_strand","kind":12,"line":385},{"line":387,"kind":12,"name":"curr_tags"},{"name":"_name","line":388,"kind":12},{"name":"Characters","kind":12,"line":388},{"name":"Attributes","kind":12,"line":389},{"line":389,"kind":12,"name":"id"},{"line":391,"kind":12,"name":"Attributes"},{"name":"problem","line":391,"kind":12},{"line":392,"kind":12,"name":"problem"},{"line":392,"kind":12,"name":"Attributes"},{"kind":12,"line":392,"name":"problem"},{"kind":12,"line":395,"name":"Name"},{"kind":12,"line":395,"name":"Children"},{"line":397,"kind":13,"name":"@fcount","containerName":null},{"kind":13,"line":398,"containerName":null,"name":"$self"},{"line":398,"kind":12,"containerName":"main::","name":"_build_feature_set"},{"name":"$set","containerName":null,"line":398,"kind":13},{"localvar":"my","name":"$feat","definition":"my","containerName":null,"line":399,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":399},{"name":"curr_subfeats","line":399,"kind":12},{"containerName":null,"name":"$feat","kind":13,"line":400},{"kind":12,"line":400,"name":"primary_tag","containerName":"main::"},{"name":"$feat","containerName":null,"kind":13,"line":400},{"kind":12,"line":400,"containerName":"main::","name":"primary_tag"},{"kind":13,"line":401,"containerName":null,"name":"$feat"},{"containerName":"main::","name":"primary_tag","line":401,"kind":12},{"line":402,"kind":13,"name":"$feat","containerName":null},{"name":"add_tag_value","containerName":"main::","kind":12,"line":402},{"name":"gene","kind":12,"line":402},{"name":"$gname","containerName":null,"kind":13,"line":402},{"kind":13,"line":402,"containerName":null,"name":"$id"},{"name":"$feat","containerName":null,"line":403,"kind":13},{"line":403,"kind":12,"name":"has_tag","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"%seen_tag","line":406,"kind":13},{"definition":"my","name":"$tag","containerName":null,"localvar":"my","kind":13,"line":407},{"line":407,"kind":13,"containerName":null,"name":"%tags"},{"line":408,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$val"},{"line":408,"kind":13,"name":"%tags","containerName":null},{"containerName":null,"name":"%tag","line":408,"kind":13},{"name":"$feat","containerName":null,"kind":13,"line":409},{"kind":12,"line":409,"name":"add_tag_value","containerName":"main::"},{"name":"$tag","containerName":null,"kind":13,"line":409},{"name":"$val","containerName":null,"line":409,"kind":13},{"kind":13,"line":410,"containerName":null,"name":"$val"},{"kind":13,"line":410,"containerName":null,"name":"%seen_tag"},{"name":"$tag","containerName":null,"line":410,"kind":13},{"containerName":null,"name":"$val","kind":13,"line":410},{"containerName":null,"name":"@feats","line":413,"kind":13},{"kind":13,"line":413,"name":"%feat","containerName":null},{"name":"%self","containerName":null,"line":416,"kind":13},{"name":"curr_ltag","kind":12,"line":416},{"containerName":null,"name":"$id","kind":13,"line":416},{"name":"%self","containerName":null,"line":417,"kind":13},{"kind":12,"line":417,"name":"curr_cds"},{"name":"$gname","containerName":null,"kind":13,"line":418},{"name":"$id","containerName":null,"line":418,"kind":13},{"containerName":null,"name":"$gname","line":418,"kind":13},{"line":419,"kind":13,"name":"%self","containerName":null},{"name":"curr_gname","line":419,"kind":12},{"line":419,"kind":13,"name":"$gname","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":421},{"containerName":"main::","name":"has_gene","line":421,"kind":12},{"line":422,"kind":13,"name":"%anntype","containerName":null},{"kind":13,"line":423,"containerName":null,"name":"$stype"},{"containerName":null,"name":"%self","line":427,"kind":13},{"line":427,"kind":12,"name":"curr_feat"},{"kind":12,"line":427,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":427},{"line":428,"kind":13,"name":"$stype","containerName":null},{"containerName":null,"name":"$id","line":429,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$feat","line":431,"kind":13},{"name":"%self","containerName":null,"line":431,"kind":13},{"name":"curr_feat","kind":12,"line":431},{"containerName":null,"name":"$self","kind":13,"line":432},{"line":432,"kind":12,"name":"_build_feature_set","containerName":"main::"},{"containerName":null,"name":"$set","kind":13,"line":432},{"containerName":null,"definition":"my","name":"$gene","localvar":"my","kind":13,"line":434},{"kind":13,"line":434,"name":"$gname","containerName":null},{"containerName":null,"name":"%self","line":434,"kind":13},{"name":"curr_ltag","line":434,"kind":12},{"name":"$feat","containerName":null,"line":436,"kind":13},{"line":436,"kind":12,"name":"add_tag_value","containerName":"main::"},{"name":"gene","kind":12,"line":436},{"name":"$gene","containerName":null,"line":436,"kind":13},{"name":"$feat","containerName":null,"line":437,"kind":13},{"kind":12,"line":437,"name":"has_tag","containerName":"main::"},{"line":440,"kind":13,"localvar":"my","definition":"my","name":"$cds","containerName":null},{"containerName":null,"name":"$self","line":440,"kind":13},{"containerName":"main::","name":"_has_CDS","kind":12,"line":440},{"containerName":null,"name":"$feat","line":440,"kind":13},{"name":"%cds","containerName":null,"line":442,"kind":13},{"line":443,"kind":13,"name":"$feat","containerName":null},{"name":"primary_tag","containerName":"main::","line":443,"kind":12},{"containerName":null,"name":"$cds","kind":13,"line":446},{"name":"remove_tag","containerName":"main::","kind":12,"line":446},{"containerName":null,"name":"$cds","line":446,"kind":13},{"kind":12,"line":446,"name":"has_tag","containerName":"main::"},{"name":"$cds","containerName":null,"kind":13,"line":447},{"line":447,"kind":12,"containerName":"main::","name":"add_tag_value"},{"line":447,"kind":12,"name":"standard_name"},{"containerName":null,"name":"$sname","kind":13,"line":447},{"name":"$cds","containerName":null,"kind":13,"line":448},{"containerName":"main::","name":"remove_tag","kind":12,"line":448},{"line":448,"kind":13,"containerName":null,"name":"$cds"},{"line":448,"kind":12,"containerName":"main::","name":"has_tag"},{"kind":13,"line":449,"name":"$cds","containerName":null},{"containerName":"main::","name":"add_tag_value","kind":12,"line":449},{"kind":12,"line":449,"name":"gene"},{"kind":13,"line":449,"name":"$gene","containerName":null},{"kind":13,"line":452,"name":"$cds","containerName":null},{"line":452,"kind":12,"name":"has_tag","containerName":"main::"},{"line":452,"kind":13,"containerName":null,"name":"$cds"},{"kind":12,"line":452,"name":"get_tag_values","containerName":"main::"},{"line":453,"kind":13,"localvar":"my","name":"$pid","definition":"my","containerName":null},{"line":453,"kind":13,"containerName":null,"name":"$self"},{"name":"protein_id","containerName":"main::","line":453,"kind":12},{"containerName":null,"name":"$cds","kind":13,"line":453},{"containerName":null,"name":"$sname","line":453,"kind":13},{"containerName":null,"name":"$cds","kind":13,"line":454},{"containerName":"main::","name":"remove_tag","kind":12,"line":454},{"name":"$cds","containerName":null,"line":455,"kind":13},{"kind":12,"line":455,"name":"add_tag_value","containerName":"main::"},{"name":"protein_id","kind":12,"line":455},{"kind":13,"line":455,"name":"$pid","containerName":null},{"line":460,"kind":13,"localvar":"my","containerName":null,"name":"@subfeats","definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":460},{"name":"curr_subfeats","kind":12,"line":460},{"localvar":"my","containerName":null,"definition":"my","name":"$sf","line":461,"kind":13},{"line":461,"kind":13,"name":"@","containerName":null},{"line":461,"kind":12,"name":"subfeats"},{"line":462,"kind":13,"containerName":null,"name":"$sf"},{"kind":12,"line":462,"containerName":"main::","name":"add_tag_value"},{"name":"standard_name","kind":12,"line":462},{"kind":13,"line":462,"name":"$sname","containerName":null},{"kind":13,"line":463,"name":"$sf","containerName":null},{"line":463,"kind":12,"name":"has_tag","containerName":"main::"},{"containerName":null,"name":"$sf","line":464,"kind":13},{"kind":12,"line":464,"name":"add_tag_value","containerName":"main::"},{"kind":12,"line":464,"name":"gene"},{"name":"$gene","containerName":null,"line":464,"kind":13},{"kind":13,"line":465,"name":"$sf","containerName":null},{"line":465,"kind":12,"name":"has_tag","containerName":"main::"},{"containerName":null,"name":"$feat","line":468,"kind":13},{"kind":12,"line":468,"name":"add_tag_value","containerName":"main::"},{"line":468,"kind":12,"name":"standard_name"},{"line":468,"kind":13,"containerName":null,"name":"$sname"},{"kind":13,"line":469,"containerName":null,"name":"$feat"},{"kind":12,"line":469,"containerName":"main::","name":"has_tag"},{"containerName":null,"name":"$feat","kind":13,"line":470},{"containerName":"main::","name":"add_tag_value","kind":12,"line":470},{"name":"gene","line":470,"kind":12},{"name":"$gene","containerName":null,"line":470,"kind":13},{"name":"$feat","containerName":null,"line":471,"kind":13},{"line":471,"kind":12,"containerName":"main::","name":"has_tag"},{"localvar":"my","name":"%seen","definition":"my","containerName":null,"line":475,"kind":13},{"line":476,"kind":13,"name":"$feat","containerName":null},{"containerName":"main::","name":"length","line":476,"kind":12},{"name":"$cds","containerName":null,"kind":13,"line":476},{"name":"length","containerName":"main::","line":476,"kind":12},{"localvar":"my","name":"$t","definition":"my","containerName":null,"line":477,"kind":13},{"kind":13,"line":477,"containerName":null,"name":"$feat"},{"containerName":"main::","name":"all_tags","line":477,"kind":12},{"containerName":null,"name":"$t","line":478,"kind":13},{"line":479,"kind":13,"name":"$cds","containerName":null},{"line":479,"kind":12,"name":"add_tag_value","containerName":"main::"},{"containerName":null,"name":"$t","kind":13,"line":479},{"line":479,"kind":13,"name":"$feat","containerName":null},{"containerName":"main::","name":"get_tag_values","kind":12,"line":479},{"name":"$t","containerName":null,"kind":13,"line":479},{"kind":13,"line":481,"containerName":null,"name":"$feat"},{"kind":13,"line":484,"containerName":null,"name":"@feats"},{"name":"$a","containerName":null,"line":484,"kind":13},{"kind":12,"line":484,"containerName":"main::","name":"start"},{"kind":13,"line":484,"containerName":null,"name":"$b"},{"containerName":"main::","name":"start","kind":12,"line":484},{"containerName":null,"name":"$cds","kind":13,"line":484},{"kind":13,"line":484,"containerName":null,"name":"@subfeats"},{"line":485,"kind":13,"name":"@feats","containerName":null},{"line":485,"kind":13,"name":"$feat","containerName":null},{"kind":13,"line":485,"name":"%feat","containerName":null},{"kind":13,"line":488,"containerName":null,"name":"%self"},{"kind":12,"line":488,"name":"curr_loc"},{"line":489,"kind":13,"localvar":"my","definition":"my","name":"$loc","containerName":null},{"kind":12,"line":489,"name":"Bio","containerName":"Location::Split"},{"kind":12,"line":489,"name":"new","containerName":"main::"},{"containerName":null,"definition":"my","name":"@loc","localvar":"my","kind":13,"line":492},{"containerName":null,"name":"$a","line":492,"kind":13},{"containerName":"main::","name":"start","line":492,"kind":12},{"line":492,"kind":13,"name":"$b","containerName":null},{"kind":12,"line":492,"name":"start","containerName":"main::"},{"containerName":null,"name":"%self","line":492,"kind":13},{"name":"curr_loc","line":492,"kind":12},{"containerName":null,"name":"@loc","kind":13,"line":495},{"name":"$loc","containerName":null,"kind":13,"line":496},{"line":496,"kind":12,"containerName":"main::","name":"add_sub_Location"},{"line":498,"kind":13,"containerName":null,"name":"$feat"},{"name":"location","containerName":"main::","kind":12,"line":498},{"name":"%loc","containerName":null,"line":498,"kind":13},{"name":"$feat","containerName":null,"line":501,"kind":13},{"containerName":"main::","name":"location","line":501,"kind":12},{"line":501,"kind":13,"name":"%self","containerName":null},{"line":501,"kind":12,"name":"curr_loc"},{"name":"%tags","containerName":null,"kind":13,"line":504},{"kind":13,"line":506,"containerName":null,"name":"$feat"},{"containerName":"main::","name":"has_tag","kind":12,"line":506},{"kind":13,"line":507,"containerName":null,"name":"$v","definition":"my","localvar":"my"},{"containerName":null,"name":"%tags","kind":13,"line":507},{"name":"$feat","containerName":null,"kind":13,"line":508},{"containerName":"main::","name":"add_tag_value","kind":12,"line":508},{"kind":13,"line":508,"containerName":null,"name":"$v"},{"kind":13,"line":513,"name":"@subfeats","definition":"my","containerName":null,"localvar":"my"},{"line":513,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_subfeats","line":513,"kind":12},{"localvar":"my","containerName":null,"definition":"my","name":"$sf","line":514,"kind":13},{"name":"@","containerName":null,"kind":13,"line":514},{"name":"subfeats","line":514,"kind":12},{"line":515,"kind":13,"name":"$sf","containerName":null},{"name":"add_tag_value","containerName":"main::","kind":12,"line":515},{"name":"standard_name","kind":12,"line":515},{"kind":13,"line":515,"containerName":null,"name":"$sname"},{"containerName":null,"name":"$sf","kind":13,"line":516},{"containerName":"main::","name":"has_tag","line":516,"kind":12},{"containerName":null,"name":"$sf","line":517,"kind":13},{"containerName":"main::","name":"add_tag_value","kind":12,"line":517},{"line":517,"kind":12,"name":"gene"},{"kind":13,"line":517,"containerName":null,"name":"$gene"},{"containerName":null,"name":"$sf","kind":13,"line":518},{"line":518,"kind":12,"containerName":"main::","name":"has_tag"},{"line":521,"kind":13,"containerName":null,"name":"@feats"},{"name":"$feat","containerName":null,"line":521,"kind":13},{"containerName":null,"name":"@subfeats","line":521,"kind":13},{"containerName":null,"name":"%self","line":527,"kind":13},{"name":"curr_coords","line":527,"kind":12},{"name":"%self","containerName":null,"kind":13,"line":528},{"name":"curr_coords","kind":12,"line":528},{"containerName":null,"name":"@feats","line":529,"kind":13},{"kind":13,"line":530,"name":"%self","containerName":null},{"kind":12,"line":530,"name":"curr_coords"},{"containerName":"main::","name":"start","kind":12,"line":530},{"line":531,"kind":13,"name":"%self","containerName":null},{"name":"curr_coords","line":531,"kind":12},{"containerName":"main::","name":"start","line":531,"kind":12},{"name":"%self","containerName":null,"line":533,"kind":13},{"line":533,"kind":12,"name":"curr_coords"},{"containerName":"main::","name":"end","line":533,"kind":12},{"line":534,"kind":13,"name":"%self","containerName":null},{"name":"curr_coords","kind":12,"line":534},{"line":534,"kind":12,"name":"end","containerName":"main::"},{"line":538,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"flush","kind":12,"line":538},{"name":"$set","containerName":null,"kind":13,"line":538},{"line":540,"kind":13,"name":"@feats","containerName":null},{"range":{"start":{"character":0,"line":557},"end":{"character":9999,"line":560}},"name":"_build_feature_set","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_build_feature_set","line":558,"kind":13},{"name":"$set","containerName":"_build_feature_set","kind":13,"line":558},{"name":"$keep_subfeat","containerName":"_build_feature_set","line":558,"kind":13},{"localvar":"my","containerName":"_build_feature_set","name":"$child","definition":"my","line":560,"kind":13},{"containerName":"_build_feature_set","name":"$set","line":560,"kind":13}],"line":557,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$set"},{"label":"$keep_subfeat"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature","label":"_build_feature_set($self,$set,$keep_subfeat)"},"detail":"($self,$set,$keep_subfeat)","definition":"sub","containerName":"main::"},{"kind":12,"line":560,"name":"Children"},{"definition":"my","name":"$name","containerName":null,"localvar":"my","kind":13,"line":561},{"line":561,"kind":13,"name":"%child","containerName":null},{"name":"Name","line":561,"kind":12},{"name":"%name","containerName":null,"kind":13,"line":564},{"kind":13,"line":565,"containerName":null,"name":"$self"},{"kind":12,"line":565,"name":"date","containerName":"main::"},{"name":"$child","containerName":null,"line":565,"kind":13},{"kind":13,"line":567,"name":"%name","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":568},{"containerName":"main::","name":"comment","kind":12,"line":568},{"name":"$child","containerName":null,"kind":13,"line":568},{"line":570,"kind":13,"containerName":null,"name":"%name"},{"containerName":null,"name":"$self","line":571,"kind":13},{"kind":12,"line":571,"containerName":"main::","name":"evidence"},{"line":571,"kind":13,"containerName":null,"name":"$child"},{"kind":13,"line":573,"containerName":null,"name":"%name"},{"line":574,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_add_feature_span","line":574,"kind":12},{"name":"$child","containerName":null,"line":574,"kind":13},{"containerName":null,"name":"$keep_subfeat","kind":13,"line":574},{"line":576,"kind":13,"containerName":null,"name":"%name"},{"line":577,"kind":13,"name":"$self","containerName":null},{"name":"property","containerName":"main::","kind":12,"line":577},{"name":"$child","containerName":null,"kind":13,"line":577},{"line":582,"kind":13,"name":"%name","containerName":null},{"line":583,"kind":13,"containerName":null,"name":"%self"},{"line":583,"kind":12,"name":"curr_tags"},{"containerName":null,"name":"@name","kind":13,"line":583},{"line":583,"kind":13,"containerName":null,"name":"%child"},{"kind":12,"line":583,"name":"Characters"},{"kind":13,"line":585,"containerName":null,"name":"%name"},{"containerName":null,"name":"$self","kind":13,"line":586},{"line":586,"kind":12,"containerName":"main::","name":"complain"},{"signature":{"parameters":[{"label":"$self"},{"label":"$el"},{"label":"$keep_subfeat"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature\n\n\n\nsub _build_feature_set {\n    my ($self, $set, $keep_subfeat) = @_;\n\n    for my $child ( @{$set->{Children}} ) {\n        my $name = $child->{Name};\n\n        # these elements require special handling\n        if ( $name eq 'date' ) {\n            $self->date( $child );\n        }\n        elsif ( $name eq 'comment' ) {\n            $self->comment( $child );\n        }\n        elsif ( $name eq 'evidence' ) {\n            $self->evidence( $child );\n        }\n        elsif ( $name eq 'feature_span' ) {\n            $self->_add_feature_span( $child, $keep_subfeat );\n\t}\n        elsif ( $name eq 'property' ) {\n            $self->property( $child );\n        }\n\n        # need to add the db_xref tags to the gene?\n        # otherwise, simple tag/value pairs\n        elsif ( $name =~ /synonym|author|description/) {\n            $self->{curr_tags}->{$name} = [$child->{Characters}];\n        }\n        elsif ( $name !~ /name|type|seq/ ){\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements\");\n\n        }\n    }\n}\n\n=head2 _add_feature_span\n\n Title   : _add_feature_span\n Usage   : $self->_add_feature_span($el, 1)\n Function: an internal method to process <feature_span> elements\n Returns : nothing\n Args    : $el -- a <feature_span> element\n           1   -- an optional flag to retain exons as subfeatures","label":"_add_feature_span($self,$el,$keep_subfeat)"},"detail":"($self,$el,$keep_subfeat)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_add_feature_span","line":607,"kind":13},{"name":"$el","containerName":"_add_feature_span","kind":13,"line":607},{"kind":13,"line":607,"name":"$keep_subfeat","containerName":"_add_feature_span"},{"containerName":"_add_feature_span","name":"$tags","definition":"my","localvar":"my","kind":13,"line":609},{"kind":13,"line":609,"containerName":"_add_feature_span","name":"$self"},{"localvar":"my","name":"$feat","definition":"my","containerName":"_add_feature_span","line":610,"kind":13},{"containerName":"_add_feature_span","name":"$self","kind":13,"line":610},{"line":611,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"_add_feature_span"},{"line":611,"kind":13,"containerName":"_add_feature_span","name":"$el"},{"containerName":"_add_feature_span","name":"$el","line":611,"kind":13},{"line":612,"kind":13,"localvar":"my","containerName":"_add_feature_span","definition":"my","name":"$id"},{"line":612,"kind":13,"containerName":"_add_feature_span","name":"$el"},{"name":"$el","containerName":"_add_feature_span","line":612,"kind":13},{"containerName":"_add_feature_span","name":"$seqr","definition":"my","localvar":"my","kind":13,"line":613},{"kind":13,"line":613,"name":"$el","containerName":"_add_feature_span"},{"kind":13,"line":614,"name":"$start","definition":"my","containerName":"_add_feature_span","localvar":"my"},{"kind":13,"line":614,"name":"$seqr","containerName":"_add_feature_span"},{"definition":"my","name":"$end","containerName":"_add_feature_span","localvar":"my","kind":13,"line":615},{"name":"$seqr","containerName":"_add_feature_span","kind":13,"line":615},{"name":"$stype","definition":"my","containerName":"_add_feature_span","localvar":"my","kind":13,"line":616},{"containerName":"_add_feature_span","name":"$seqr","kind":13,"line":616},{"kind":13,"line":617,"containerName":"_add_feature_span","name":"$seqid","definition":"my","localvar":"my"},{"containerName":"_add_feature_span","name":"$seqr","kind":13,"line":617},{"containerName":"_add_feature_span","name":"$self","kind":13,"line":619}],"line":606,"kind":12,"range":{"start":{"line":606,"character":0},"end":{"line":619,"character":9999}},"name":"_add_feature_span"},{"line":609,"kind":12,"name":"curr_tags"},{"line":610,"kind":12,"name":"curr_feat"},{"kind":12,"line":611,"name":"_type"},{"name":"Characters","line":611,"kind":12},{"name":"Name","line":611,"kind":12},{"line":612,"kind":12,"name":"Attributes"},{"name":"id","kind":12,"line":612},{"name":"_name","kind":12,"line":612},{"line":612,"kind":12,"name":"Characters"},{"name":"_seq_relationship","kind":12,"line":613},{"name":"_span","kind":12,"line":614},{"name":"_start","kind":12,"line":614},{"kind":12,"line":614,"name":"Characters"},{"kind":12,"line":615,"name":"_span"},{"line":615,"kind":12,"name":"_end"},{"name":"Characters","line":615,"kind":12},{"name":"Attributes","line":616,"kind":12},{"name":"type","kind":12,"line":616},{"name":"Attributes","line":617,"kind":12},{"line":617,"kind":12,"name":"seq"},{"line":619,"kind":12,"name":"seq_l"},{"line":619,"kind":13,"containerName":null,"name":"%self"},{"line":619,"kind":12,"name":"seq_h"},{"name":"$seqid","containerName":null,"kind":13,"line":619},{"name":"$start","containerName":null,"kind":13,"line":621},{"kind":13,"line":621,"containerName":null,"name":"%end"},{"containerName":null,"name":"%self","line":622,"kind":13},{"kind":12,"line":622,"name":"curr_strand"},{"kind":13,"line":623,"containerName":null,"name":"$start"},{"kind":13,"line":623,"name":"$end","containerName":null},{"kind":13,"line":623,"containerName":null,"name":"$end"},{"name":"%start","containerName":null,"line":623,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":626},{"name":"curr_strand","line":626,"kind":12},{"containerName":null,"name":"%type","kind":13,"line":630},{"kind":13,"line":631,"name":"$sl","definition":"my","containerName":null,"localvar":"my"},{"name":"Bio","containerName":"Location::Simple","line":631,"kind":12},{"line":631,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"line":631,"name":"$start","containerName":null},{"name":"$end","containerName":null,"kind":13,"line":632},{"name":"%self","containerName":null,"line":633,"kind":13},{"line":633,"kind":12,"name":"curr_strand"},{"kind":13,"line":634,"containerName":null,"name":"%self"},{"line":634,"kind":12,"name":"curr_loc"},{"kind":13,"line":634,"name":"$sl","containerName":null},{"containerName":null,"name":"%type","kind":13,"line":638},{"containerName":null,"name":"%self","line":639,"kind":13},{"name":"curr_tags","kind":12,"line":639},{"line":639,"kind":12,"name":"codon_start"},{"line":639,"kind":13,"name":"%start","containerName":null},{"kind":13,"line":642,"containerName":null,"name":"%type"},{"kind":13,"line":643,"containerName":null,"name":"$keep_subfeat"},{"containerName":null,"name":"%self","kind":13,"line":645},{"kind":12,"line":645,"name":"curr_subfeats"},{"name":"Bio","containerName":"SeqFeature::Generic","line":646,"kind":12},{"line":646,"kind":12,"name":"new","containerName":"main::"},{"line":646,"kind":13,"name":"$start","containerName":null},{"kind":13,"line":647,"containerName":null,"name":"$end"},{"containerName":null,"name":"%self","kind":13,"line":648},{"line":648,"kind":12,"name":"curr_strand"},{"kind":13,"line":649,"name":"$type","containerName":null},{"line":653,"kind":13,"localvar":"my","containerName":null,"name":"$tscript","definition":"my"},{"containerName":null,"name":"%el","line":653,"kind":13},{"name":"Attributes","kind":12,"line":653},{"name":"produces_seq","line":653,"kind":12},{"name":"$tscript","containerName":null,"line":654,"kind":13},{"name":"%tscript","containerName":null,"line":654,"kind":13},{"definition":"my","name":"$subseq","containerName":null,"localvar":"my","kind":13,"line":655},{"line":655,"kind":13,"name":"%self","containerName":null},{"line":655,"kind":12,"name":"seq_h"},{"containerName":null,"name":"%el","line":655,"kind":13},{"kind":12,"line":655,"name":"Attributes"},{"name":"produces_seq","line":655,"kind":12},{"line":656,"kind":13,"containerName":null,"name":"%self"},{"line":656,"kind":12,"name":"curr_tags"},{"name":"product","kind":12,"line":656},{"name":"%el","containerName":null,"line":656,"kind":13},{"line":656,"kind":12,"name":"Attributes"},{"line":656,"kind":12,"name":"produces_seq"},{"name":"%self","containerName":null,"kind":13,"line":657},{"name":"curr_tags","kind":12,"line":657},{"kind":12,"line":657,"name":"translation"},{"kind":13,"line":657,"name":"$subseq","containerName":null},{"line":657,"kind":12,"containerName":"main::","name":"seq"},{"line":657,"kind":13,"name":"$subseq","containerName":null},{"kind":13,"line":660,"containerName":null,"name":"$self"},{"line":660,"kind":12,"containerName":"main::","name":"flush"},{"kind":13,"line":660,"containerName":null,"name":"$el"},{"range":{"start":{"line":674,"character":0},"end":{"character":9999,"line":679}},"name":"_add_CDS","line":674,"children":[{"line":675,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_add_CDS"},{"kind":13,"line":675,"containerName":"_add_CDS","name":"$feat"},{"containerName":"_add_CDS","name":"$tags","kind":13,"line":675},{"kind":13,"line":676,"definition":"my","name":"$loc","containerName":"_add_CDS","localvar":"my"},{"kind":13,"line":677,"containerName":"_add_CDS","name":"$single","definition":"my","localvar":"my"},{"name":"$self","containerName":"_add_CDS","kind":13,"line":679}],"kind":12,"detail":"($self,$feat,$tags)","signature":{"label":"_add_CDS($self,$feat,$tags)","documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature\n\n\n\nsub _build_feature_set {\n    my ($self, $set, $keep_subfeat) = @_;\n\n    for my $child ( @{$set->{Children}} ) {\n        my $name = $child->{Name};\n\n        # these elements require special handling\n        if ( $name eq 'date' ) {\n            $self->date( $child );\n        }\n        elsif ( $name eq 'comment' ) {\n            $self->comment( $child );\n        }\n        elsif ( $name eq 'evidence' ) {\n            $self->evidence( $child );\n        }\n        elsif ( $name eq 'feature_span' ) {\n            $self->_add_feature_span( $child, $keep_subfeat );\n\t}\n        elsif ( $name eq 'property' ) {\n            $self->property( $child );\n        }\n\n        # need to add the db_xref tags to the gene?\n        # otherwise, simple tag/value pairs\n        elsif ( $name =~ /synonym|author|description/) {\n            $self->{curr_tags}->{$name} = [$child->{Characters}];\n        }\n        elsif ( $name !~ /name|type|seq/ ){\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements\");\n\n        }\n    }\n}\n\n=head2 _add_feature_span\n\n Title   : _add_feature_span\n Usage   : $self->_add_feature_span($el, 1)\n Function: an internal method to process <feature_span> elements\n Returns : nothing\n Args    : $el -- a <feature_span> element\n           1   -- an optional flag to retain exons as subfeatures\n\n\n\n\nsub _add_feature_span {\n    my ($self, $el, $keep_subfeat) = @_;\n\n    my $tags  = $self->{curr_tags};\n    my $feat  = $self->{curr_feat};\n    my $type  = $el->{_type}->{Characters} || $el->{Name};\n    my $id    = $el->{Attributes}->{id} || $el->{_name}->{Characters};\n    my $seqr  = $el->{_seq_relationship};\n    my $start = int $seqr->{_span}->{_start}->{Characters};\n    my $end   = int $seqr->{_span}->{_end}->{Characters};\n    my $stype = $seqr->{Attributes}->{type}; \n    my $seqid = $seqr->{Attributes}->{seq};\n\n    push @{$self->{seq_l}}, $self->{seq_h}->{$seqid};\n\n    if ( $start > $end ) {\n\t$self->{curr_strand} = -1;\n\t($start, $end) = ($end, $start);\n    }\n    else {\n\t$self->{curr_strand} = 1;\n    }\n\n    # add exons to the transcript\n    if ( $type eq 'exon' ) {\n\tmy $sl = Bio::Location::Simple->new( -start  => $start,\n                                             -end    => $end,\n                                             -strand => $self->{curr_strand} );\n        push @{$self->{curr_loc}}, $sl;\n    }\n    \n    # apollo and gadfly use different tags for the same thing \n    if ( $type =~ /start_codon|translate offset/ ) {\n        $self->{curr_tags}->{codon_start} = [$start];\n    }\n    else { \n\tif ( $type eq 'exon' ) {\n\t    return unless $keep_subfeat;\n\t}\n\tpush @{$self->{curr_subfeats}}, \n\tBio::SeqFeature::Generic->new( -start   => $start,\n\t\t\t\t       -end     => $end,\n\t\t\t\t       -strand  => $self->{curr_strand},\n\t\t\t\t       -primary => $type );\n    }\n\n    # identify the translation product     \n    my $tscript = $el->{Attributes}->{produces_seq};\n    if ( $tscript && $tscript ne 'null') {\n\tmy $subseq = $self->{seq_h}->{$el->{Attributes}->{produces_seq}};\n        $self->{curr_tags}->{product} = [$el->{Attributes}->{produces_seq}];\n\t$self->{curr_tags}->{translation} = [$subseq->seq] if $subseq;\n    }      \n\n    $self->flush( $el );\n}\n\n=head2 _add_CDS\n\n Title   : _add_CDS\n Usage   : my $cds = $self->_add_CDS($transcript, $tags)\n Function: an internal method to create a CDS feature from a transcript feature\n Returns : a Bio::SeqFeature::Generic object\n Args    : $transcript -- a Bio::SeqFeature::Generic object for a transcript\n           $tags       -- ref. to a hash of tag/value attributes","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$tags"}]},"containerName":"main::","definition":"sub"},{"name":"curr_loc","kind":12,"line":679},{"kind":13,"line":680,"containerName":null,"name":"$loc"},{"name":"Bio","containerName":"Location::Split","kind":12,"line":680},{"kind":12,"line":680,"containerName":"main::","name":"new"},{"definition":"my","name":"@loc","containerName":null,"localvar":"my","kind":13,"line":683},{"containerName":null,"name":"$a","line":683,"kind":13},{"containerName":"main::","name":"start","kind":12,"line":683},{"name":"$b","containerName":null,"kind":13,"line":683},{"kind":12,"line":683,"containerName":"main::","name":"start"},{"containerName":null,"name":"%self","line":683,"kind":13},{"kind":12,"line":683,"name":"curr_loc"},{"containerName":null,"name":"@loc","line":686,"kind":13},{"line":687,"kind":13,"containerName":null,"name":"$loc"},{"line":687,"kind":12,"containerName":"main::","name":"add_sub_Location"},{"line":691,"kind":13,"containerName":null,"name":"$loc"},{"containerName":null,"name":"%self","line":691,"kind":13},{"name":"curr_loc","kind":12,"line":691},{"line":692,"kind":13,"containerName":null,"name":"$single"},{"line":696,"kind":13,"localvar":"my","containerName":null,"name":"@exons","definition":"my"},{"line":696,"kind":13,"containerName":null,"name":"$single"},{"kind":13,"line":696,"name":"$loc","containerName":null},{"kind":13,"line":696,"containerName":null,"name":"$loc"},{"containerName":"main::","name":"sub_Location","line":696,"kind":12},{"kind":13,"line":698,"containerName":null,"name":"$feat"},{"kind":12,"line":698,"containerName":"main::","name":"location"},{"containerName":null,"name":"$loc","kind":13,"line":698},{"line":700,"kind":13,"localvar":"my","containerName":null,"name":"$seq","definition":"my"},{"line":700,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":700,"name":"seq_h"},{"containerName":null,"name":"%tags","line":700,"kind":13},{"name":"protein_id","line":700,"kind":12},{"containerName":null,"name":"$seq","kind":13,"line":701},{"kind":13,"line":701,"containerName":null,"name":"%self"},{"line":701,"kind":12,"name":"seq_h"},{"line":701,"kind":13,"name":"%tags","containerName":null},{"line":701,"kind":12,"name":"product"},{"kind":13,"line":702,"containerName":null,"name":"%self"},{"name":"seq_h","kind":12,"line":702},{"containerName":null,"name":"%tags","kind":13,"line":702},{"name":"gene","kind":12,"line":702},{"line":703,"kind":13,"containerName":null,"name":"%self"},{"name":"seq_h","line":703,"kind":12},{"name":"%tags","containerName":null,"line":703,"kind":13},{"line":703,"kind":12,"name":"standard_name"},{"localvar":"my","containerName":null,"definition":"my","name":"$start","line":710,"kind":13},{"containerName":null,"name":"$stop","line":710,"kind":13},{"name":"$peptide","containerName":null,"line":710,"kind":13},{"name":"%seq","containerName":null,"line":711,"kind":13},{"kind":13,"line":712,"name":"$peptide","containerName":null},{"containerName":null,"name":"$seq","line":712,"kind":13},{"containerName":"main::","name":"display_id","line":712,"kind":12},{"localvar":"my","name":"$desc","definition":"my","containerName":null,"line":713,"kind":13},{"name":"$seq","containerName":null,"kind":13,"line":713},{"containerName":"main::","name":"description","kind":12,"line":713},{"kind":13,"line":714,"name":"$desc","containerName":null},{"line":715,"kind":13,"name":"$desc","containerName":null},{"kind":13,"line":717,"containerName":null,"name":"%desc"},{"kind":13,"line":718,"containerName":null,"name":"$start"},{"kind":13,"line":718,"name":"$stop","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":718},{"kind":12,"line":718,"name":"offset"},{"kind":13,"line":718,"containerName":null,"name":"%self"},{"name":"offset","line":718,"kind":12},{"containerName":null,"name":"$start","kind":13,"line":722},{"line":722,"kind":13,"containerName":null,"name":"$loc"},{"kind":12,"line":722,"containerName":"main::","name":"start"},{"kind":13,"line":723,"containerName":null,"name":"$stop"},{"name":"$loc","containerName":null,"line":723,"kind":13},{"name":"end","containerName":"main::","kind":12,"line":723},{"kind":13,"line":727,"containerName":null,"name":"$self"},{"kind":12,"line":727,"name":"warn","containerName":"main::"},{"containerName":null,"name":"$feat","kind":13,"line":727},{"name":"display_name","containerName":"main::","kind":12,"line":727},{"kind":13,"line":730,"containerName":null,"name":"%tags"},{"name":"transcript","line":730,"kind":12},{"localvar":"my","containerName":null,"name":"@exons_to_add","definition":"my","line":733,"kind":13},{"name":"@exons","containerName":null,"kind":13,"line":735},{"localvar":"my","definition":"my","name":"$exon","containerName":null,"line":736,"kind":13},{"name":"Bio","containerName":"Location::Simple","line":736,"kind":12},{"containerName":"main::","name":"new","line":736,"kind":12},{"line":738,"kind":12,"containerName":"main::","name":"end"},{"containerName":null,"name":"$start","line":738,"kind":13},{"name":"start","containerName":"main::","kind":12,"line":738},{"kind":13,"line":738,"name":"%stop","containerName":null},{"kind":12,"line":742,"name":"start","containerName":"main::"},{"containerName":null,"name":"$start","line":742,"kind":13},{"kind":12,"line":742,"name":"end","containerName":"main::"},{"name":"%start","containerName":null,"kind":13,"line":742},{"name":"$exon","containerName":null,"line":744,"kind":13},{"kind":12,"line":744,"name":"start","containerName":"main::"},{"containerName":null,"name":"$start","line":744,"kind":13},{"kind":12,"line":746,"name":"end","containerName":"main::"},{"line":746,"kind":13,"name":"$stop","containerName":null},{"kind":12,"line":746,"containerName":"main::","name":"start"},{"line":746,"kind":13,"containerName":null,"name":"%stop"},{"line":748,"kind":13,"containerName":null,"name":"$exon"},{"kind":12,"line":748,"containerName":"main::","name":"end"},{"containerName":null,"name":"$stop","kind":13,"line":748},{"name":"$exon","containerName":null,"kind":13,"line":751},{"containerName":"main::","name":"valid_Location","line":751,"kind":12},{"containerName":null,"name":"$exon","kind":13,"line":752},{"name":"start","containerName":"main::","line":752,"kind":12},{"containerName":"main::","name":"start","kind":12,"line":752},{"name":"$exon","containerName":null,"kind":13,"line":753},{"name":"end","containerName":"main::","kind":12,"line":753},{"name":"end","containerName":"main::","kind":12,"line":753},{"kind":13,"line":755,"containerName":null,"name":"$exon"},{"containerName":"main::","name":"strand","line":755,"kind":12},{"name":"%self","containerName":null,"line":755,"kind":13},{"name":"curr_strand","kind":12,"line":755},{"kind":13,"line":756,"name":"@exons_to_add","containerName":null},{"line":756,"kind":13,"containerName":null,"name":"$exon"},{"containerName":null,"definition":"my","name":"$cds_loc","localvar":"my","kind":13,"line":759},{"line":760,"kind":13,"containerName":null,"name":"@exons_to_add"},{"name":"$cds_loc","containerName":null,"line":761,"kind":13},{"kind":12,"line":761,"containerName":"Location::Split","name":"Bio"},{"containerName":"main::","name":"new","kind":12,"line":761},{"containerName":null,"name":"@exons_to_add","kind":13,"line":762},{"kind":13,"line":763,"name":"$cds_loc","containerName":null},{"containerName":"main::","name":"add_sub_Location","line":763,"kind":12},{"containerName":null,"name":"$cds_loc","line":767,"kind":13},{"line":767,"kind":13,"containerName":null,"name":"@exons_to_add"},{"localvar":"my","definition":"my","name":"$parent","containerName":null,"line":770,"kind":13},{"kind":13,"line":770,"containerName":null,"name":"%self"},{"name":"curr_gname","kind":12,"line":770},{"line":770,"kind":13,"containerName":null,"name":"%self"},{"line":770,"kind":12,"name":"curr_ltag"},{"kind":13,"line":773,"definition":"my","name":"%cds_tags","containerName":null,"localvar":"my"},{"containerName":null,"name":"$k","definition":"my","localvar":"my","kind":13,"line":774},{"containerName":null,"name":"%tags","kind":13,"line":774},{"name":"%k","containerName":null,"kind":13,"line":775},{"line":776,"kind":13,"containerName":null,"name":"%cds_tags"},{"kind":13,"line":776,"name":"$k","containerName":null},{"containerName":null,"name":"%tags","kind":13,"line":776},{"containerName":null,"name":"$k","line":776,"kind":13},{"kind":13,"line":777,"name":"%tags","containerName":null},{"containerName":null,"name":"$k","line":777,"kind":13},{"kind":13,"line":781,"containerName":null,"name":"%tags"},{"line":782,"kind":13,"localvar":"my","definition":"my","name":"$v","containerName":null},{"name":"%tags","containerName":null,"kind":13,"line":782},{"containerName":null,"name":"$feat","kind":13,"line":783},{"kind":12,"line":783,"containerName":"main::","name":"add_tag_value"},{"name":"$v","containerName":null,"line":783,"kind":13},{"line":784,"kind":13,"name":"$feat","containerName":null},{"line":784,"kind":12,"name":"has_tag","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":788},{"line":788,"kind":12,"name":"curr_gname"},{"name":"%cds_tags","containerName":null,"kind":13,"line":789},{"name":"gene","kind":12,"line":789},{"name":"%self","containerName":null,"line":789,"kind":13},{"name":"curr_gname","line":789,"kind":12},{"localvar":"my","containerName":null,"definition":"my","name":"$gene","line":792,"kind":13},{"containerName":null,"name":"$self","line":792,"kind":13},{"name":"has_gene","containerName":"main::","line":792,"kind":12},{"line":794,"kind":13,"localvar":"my","definition":"my","name":"$cds","containerName":null},{"kind":12,"line":794,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":794},{"containerName":null,"name":"$cds_loc","line":796,"kind":13},{"line":799,"kind":13,"name":"%cds_tags","containerName":null},{"kind":12,"line":799,"name":"translation"},{"name":"$seq","containerName":null,"kind":13,"line":799},{"name":"seq","containerName":"main::","line":799,"kind":12},{"line":801,"kind":13,"containerName":null,"name":"%cds_tags"},{"kind":13,"line":802,"name":"%seen","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","name":"$val","definition":"my","containerName":null,"line":803,"kind":13},{"kind":13,"line":803,"containerName":null,"name":"%cds_tags"},{"name":"%seen","containerName":null,"kind":13,"line":804},{"name":"$val","containerName":null,"kind":13,"line":804},{"kind":13,"line":805,"containerName":null,"name":"$cds"},{"kind":12,"line":805,"containerName":"main::","name":"add_tag_value"},{"kind":13,"line":805,"name":"$val","containerName":null},{"containerName":null,"name":"$cds","line":809,"kind":13}]}