{"version":5,"vars":[{"line":89,"kind":2,"name":"base","containerName":""},{"range":{"start":{"line":108,"character":0},"end":{"character":9999,"line":117}},"name":"new","detail":"($caller,$seq,%arg)","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file","parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"%arg"}],"label":"new($caller,$seq,%arg)"},"containerName":"main::","definition":"sub","line":108,"children":[{"line":109,"kind":13,"localvar":"my","definition":"my","name":"$caller","containerName":"new"},{"name":"$seq","containerName":"new","kind":13,"line":109},{"line":109,"kind":13,"containerName":"new","name":"%arg"},{"kind":13,"line":110,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"containerName":"new","name":"$caller","kind":13,"line":110},{"containerName":"new","name":"$caller","line":110,"kind":13},{"line":111,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":111,"kind":13,"name":"$seq","containerName":"new"},{"line":111,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"$self","line":114,"kind":13},{"line":114,"kind":13,"containerName":"new","name":"$arg"},{"containerName":"new","name":"$self","line":115,"kind":13},{"kind":13,"line":116,"name":"$self","containerName":"new"}],"kind":12},{"line":111,"kind":12,"name":"seq"},{"name":"map","line":114,"kind":12},{"line":114,"kind":12,"name":"map"},{"name":"anon_set_counters","kind":12,"line":115},{"children":[{"line":130,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_to_game"},{"kind":13,"line":131,"containerName":"write_to_game","name":"$seq","definition":"my","localvar":"my"},{"containerName":"write_to_game","name":"$self","line":131,"kind":13},{"definition":"my","name":"@feats","containerName":"write_to_game","localvar":"my","kind":13,"line":132},{"line":132,"kind":13,"name":"$seq","containerName":"write_to_game"},{"containerName":"write_to_game","name":"remove_SeqFeatures","line":132,"kind":12},{"line":135,"kind":13,"localvar":"my","definition":"my","name":"@nested_feats","containerName":"write_to_game"},{"name":"get_SeqFeatures","containerName":"write_to_game","kind":12,"line":135},{"line":135,"kind":13,"name":"@feats","containerName":"write_to_game"},{"name":"@feats","containerName":"write_to_game","kind":13,"line":136},{"kind":12,"line":136,"containerName":"write_to_game","name":"get_SeqFeatures"},{"kind":13,"line":136,"name":"@feats","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$seq","line":137,"kind":13},{"line":137,"kind":12,"name":"add_SeqFeature","containerName":"write_to_game"},{"line":137,"kind":13,"name":"@feats","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$uf","definition":"my","localvar":"my","kind":13,"line":173},{"line":173,"kind":12,"name":"new","containerName":"write_to_game"},{"name":"$uf","containerName":"write_to_game","kind":13,"line":174},{"containerName":"write_to_game","name":"unflatten_seq","kind":12,"line":174},{"line":174,"kind":13,"containerName":"write_to_game","name":"$seq"},{"name":"$seq","containerName":"write_to_game","line":180,"kind":13},{"kind":12,"line":180,"containerName":"write_to_game","name":"add_SeqFeature"},{"line":180,"kind":13,"containerName":"write_to_game","name":"@nested_feats"},{"localvar":"my","containerName":"write_to_game","definition":"my","name":"$atts","line":182,"kind":13},{"line":183,"kind":13,"localvar":"my","name":"$xml","definition":"my","containerName":"write_to_game"},{"line":186,"kind":13,"localvar":"my","containerName":"write_to_game","definition":"my","name":"$xml_handle"},{"containerName":"write_to_game","name":"new","line":186,"kind":12},{"name":"$xml","containerName":"write_to_game","kind":13,"line":186},{"containerName":"write_to_game","definition":"my","name":"$writer","localvar":"my","kind":13,"line":187},{"kind":12,"line":187,"name":"new","containerName":"write_to_game"},{"name":"$xml_handle","containerName":"write_to_game","kind":13,"line":187},{"line":192,"kind":13,"name":"$self","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$writer","kind":13,"line":192},{"containerName":"write_to_game","name":"$writer","kind":13,"line":195},{"line":195,"kind":12,"name":"comment","containerName":"write_to_game"},{"name":"$writer","containerName":"write_to_game","line":196,"kind":13},{"line":196,"kind":12,"name":"comment","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$writer","kind":13,"line":197},{"line":197,"kind":12,"name":"comment","containerName":"write_to_game"},{"kind":13,"line":198,"name":"$writer","containerName":"write_to_game"},{"line":198,"kind":12,"containerName":"write_to_game","name":"startTag"},{"localvar":"my","definition":"my","name":"@sources","containerName":"write_to_game","line":200,"kind":13},{"line":200,"kind":12,"name":"primary_tag","containerName":"write_to_game"},{"name":"$seq","containerName":"write_to_game","line":200,"kind":13},{"line":200,"kind":12,"name":"get_SeqFeatures","containerName":"write_to_game"},{"localvar":"my","containerName":"write_to_game","definition":"my","name":"$source","line":202,"kind":13},{"name":"@sources","containerName":"write_to_game","line":202,"kind":13},{"name":"$source","containerName":"write_to_game","kind":13,"line":203},{"line":203,"kind":12,"containerName":"write_to_game","name":"length"},{"line":203,"kind":13,"name":"$seq","containerName":"write_to_game"},{"kind":12,"line":203,"name":"length","containerName":"write_to_game"},{"kind":13,"line":205,"containerName":"write_to_game","name":"$source"},{"containerName":"write_to_game","name":"has_tag","line":205,"kind":12},{"line":206,"kind":13,"name":"$self","containerName":"write_to_game"},{"name":"$atts","containerName":"write_to_game","kind":13,"line":207},{"line":207,"kind":13,"containerName":"write_to_game","name":"$source"},{"containerName":"write_to_game","name":"get_tag_values","kind":12,"line":207},{"name":"$atts","containerName":"write_to_game","line":214,"kind":13},{"line":214,"kind":13,"name":"$seq","containerName":"write_to_game"},{"name":"accession_number","containerName":"write_to_game","line":214,"kind":12},{"kind":13,"line":215,"containerName":"write_to_game","name":"$seq"},{"line":215,"kind":12,"name":"accession_number","containerName":"write_to_game"},{"name":"$seq","containerName":"write_to_game","kind":13,"line":215},{"kind":12,"line":215,"name":"display_name","containerName":"write_to_game"},{"name":"$self","containerName":"write_to_game","kind":13,"line":217},{"containerName":"write_to_game","name":"_seq","line":217,"kind":12},{"kind":13,"line":217,"containerName":"write_to_game","name":"$seq"},{"containerName":"write_to_game","name":"$atts","kind":13,"line":217},{"line":220,"kind":13,"containerName":"write_to_game","name":"$self"},{"containerName":"write_to_game","name":"$seqtype","definition":"my","localvar":"my","kind":13,"line":221},{"kind":13,"line":222,"containerName":"write_to_game","name":"$atts"},{"line":222,"kind":13,"name":"$seq","containerName":"write_to_game"},{"kind":12,"line":222,"containerName":"write_to_game","name":"alphabet"},{"containerName":"write_to_game","name":"$seqtype","kind":13,"line":223},{"line":223,"kind":13,"name":"$atts","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$seq","line":223,"kind":13},{"name":"alphabet","containerName":"write_to_game","line":223,"kind":12},{"containerName":"write_to_game","name":"$seqtype","line":226,"kind":13},{"line":229,"kind":13,"containerName":"write_to_game","name":"$writer"},{"containerName":"write_to_game","name":"startTag","line":229,"kind":12},{"kind":13,"line":231,"name":"$atts","containerName":"write_to_game"},{"kind":13,"line":233,"name":"$seqtype","containerName":"write_to_game"},{"line":235,"kind":13,"localvar":"my","name":"$arm","definition":"my","containerName":"write_to_game"},{"name":"$start","containerName":"write_to_game","line":235,"kind":13},{"kind":13,"line":235,"name":"$end","containerName":"write_to_game"},{"line":235,"kind":13,"containerName":"write_to_game","name":"$atts"},{"kind":13,"line":236,"containerName":"write_to_game","name":"$self"},{"line":236,"kind":12,"containerName":"write_to_game","name":"_element"},{"name":"$arm","containerName":"write_to_game","kind":13,"line":236},{"name":"$arm","containerName":"write_to_game","line":236,"kind":13},{"name":"$self","containerName":"write_to_game","kind":13,"line":237},{"line":237,"kind":12,"containerName":"write_to_game","name":"_span"},{"line":237,"kind":13,"containerName":"write_to_game","name":"$start"},{"kind":13,"line":237,"containerName":"write_to_game","name":"$end"},{"line":238,"kind":13,"containerName":"write_to_game","name":"$writer"},{"line":238,"kind":12,"containerName":"write_to_game","name":"endTag"},{"kind":13,"line":241,"name":"$seq","containerName":"write_to_game"},{"kind":12,"line":241,"containerName":"write_to_game","name":"top_SeqFeatures"},{"line":243,"kind":12,"name":"isa","containerName":"write_to_game"},{"kind":13,"line":244,"name":"$self","containerName":"write_to_game"},{"kind":12,"line":244,"name":"_comp_analysis","containerName":"write_to_game"},{"line":249,"kind":12,"name":"get_SeqFeatures","containerName":"write_to_game"},{"containerName":"write_to_game","name":"$self","kind":13,"line":250},{"name":"_write_gene","containerName":"write_to_game","line":250,"kind":12},{"name":"primary_tag","containerName":"write_to_game","line":253,"kind":12},{"containerName":"write_to_game","name":"$self","kind":13,"line":254},{"containerName":"write_to_game","name":"_write_feature","line":254,"kind":12},{"containerName":"write_to_game","name":"$writer","line":259,"kind":13},{"name":"endTag","containerName":"write_to_game","kind":12,"line":259},{"kind":13,"line":260,"containerName":"write_to_game","name":"$writer"},{"kind":12,"line":260,"containerName":"write_to_game","name":"end"},{"kind":13,"line":261,"name":"$xml","containerName":"write_to_game"}],"line":129,"kind":12,"range":{"start":{"line":129,"character":0},"end":{"character":9999,"line":262}},"name":"write_to_game","definition":"sub","containerName":"main::"},{"name":"seq","kind":12,"line":131},{"containerName":"SeqFeature::Tools::Unflattener","name":"Bio","line":173,"kind":12},{"line":174,"kind":12,"name":"use_magic"},{"name":"IO","containerName":"String","kind":12,"line":186},{"name":"XML","containerName":"Writer","kind":12,"line":187},{"kind":12,"line":187,"name":"OUTPUT"},{"kind":12,"line":188,"name":"DATA_MODE"},{"kind":12,"line":189,"name":"DATA_INDENT"},{"name":"NEWLINE","kind":12,"line":190},{"line":192,"kind":12,"name":"writer"},{"name":"version","line":198,"kind":12},{"name":"has_organism","line":206,"kind":12},{"name":"name","line":214,"kind":12},{"name":"map","kind":12,"line":220},{"name":"mol_type","kind":12,"line":222},{"name":"mol_type","kind":12,"line":223},{"name":"seq","line":231,"kind":12},{"name":"name","kind":12,"line":231},{"kind":12,"line":232,"name":"type"},{"name":"name","line":235,"kind":12},{"range":{"end":{"character":9999,"line":299},"start":{"line":277,"character":0}},"name":"_rearrange_hierarchies","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@containers"}],"label":"_rearrange_hierarchies($self,$seq,@containers)"},"detail":"($self,$seq,@containers)","definition":"sub","containerName":"main::","children":[{"line":278,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_rearrange_hierarchies"},{"containerName":"_rearrange_hierarchies","name":"$seq","kind":13,"line":278},{"name":"@containers","containerName":"_rearrange_hierarchies","line":278,"kind":13},{"line":279,"kind":13,"localvar":"my","definition":"my","name":"@feats","containerName":"_rearrange_hierarchies"},{"line":279,"kind":13,"name":"$seq","containerName":"_rearrange_hierarchies"},{"line":279,"kind":12,"containerName":"_rearrange_hierarchies","name":"remove_SeqFeatures"},{"line":280,"kind":13,"localvar":"my","containerName":"_rearrange_hierarchies","definition":"my","name":"@genes"},{"name":"primary_tag","containerName":"_rearrange_hierarchies","kind":12,"line":280},{"containerName":"_rearrange_hierarchies","name":"@feats","line":280,"kind":13},{"localvar":"my","containerName":"_rearrange_hierarchies","definition":"my","name":"@addback","line":281,"kind":13},{"line":281,"kind":12,"name":"primary_tag","containerName":"_rearrange_hierarchies"},{"line":281,"kind":13,"containerName":"_rearrange_hierarchies","name":"@feats"},{"kind":13,"line":283,"name":"@containers","containerName":"_rearrange_hierarchies"},{"containerName":"_rearrange_hierarchies","name":"@has_genes","definition":"my","localvar":"my","kind":13,"line":284},{"line":284,"kind":12,"containerName":"_rearrange_hierarchies","name":"get_tag_values"},{"containerName":"_rearrange_hierarchies","definition":"my","name":"$has_gene","localvar":"my","kind":13,"line":285},{"line":285,"kind":13,"name":"@has_genes","containerName":"_rearrange_hierarchies"},{"localvar":"my","name":"$gene","definition":"my","containerName":"_rearrange_hierarchies","line":286,"kind":13},{"name":"@genes","containerName":"_rearrange_hierarchies","kind":13,"line":286},{"kind":13,"line":287,"containerName":"_rearrange_hierarchies","name":"$gene"},{"line":288,"kind":13,"localvar":"my","containerName":"_rearrange_hierarchies","definition":"my","name":"$gname"},{"name":"$gene","containerName":"_rearrange_hierarchies","kind":13,"line":288},{"kind":12,"line":288,"containerName":"_rearrange_hierarchies","name":"get_tag_values"},{"name":"$gname","containerName":"_rearrange_hierarchies","kind":13,"line":289},{"kind":13,"line":289,"containerName":"_rearrange_hierarchies","name":"$has_gene"},{"line":290,"kind":12,"name":"add_SeqFeature","containerName":"_rearrange_hierarchies"},{"kind":13,"line":290,"containerName":"_rearrange_hierarchies","name":"$gene"},{"name":"$gene","containerName":"_rearrange_hierarchies","kind":13,"line":291},{"name":"@addback","containerName":"_rearrange_hierarchies","line":297,"kind":13},{"line":297,"kind":13,"name":"@containers","containerName":"_rearrange_hierarchies"},{"line":297,"kind":13,"containerName":"_rearrange_hierarchies","name":"@genes"},{"name":"$seq","containerName":"_rearrange_hierarchies","line":298,"kind":13},{"containerName":"_rearrange_hierarchies","name":"add_SeqFeature","kind":12,"line":298},{"containerName":"_rearrange_hierarchies","name":"@addback","line":298,"kind":13}],"line":277,"kind":12},{"signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$bare"}],"label":"_write_feature($self,$feat,$bare)"},"detail":"($self,$feat,$bare)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_write_feature","line":314,"kind":13},{"line":314,"kind":13,"name":"$feat","containerName":"_write_feature"},{"containerName":"_write_feature","name":"$bare","line":314,"kind":13},{"localvar":"my","name":"$writer","definition":"my","containerName":"_write_feature","line":315,"kind":13},{"containerName":"_write_feature","name":"$self","kind":13,"line":315},{"kind":13,"line":316,"containerName":"_write_feature","definition":"my","name":"$id","localvar":"my"},{"line":318,"kind":13,"name":"$feat","containerName":"_write_feature"},{"kind":12,"line":318,"containerName":"_write_feature","name":"primary_tag"},{"kind":13,"line":319,"containerName":"_write_feature","name":"$id"},{"name":"$self","containerName":"_write_feature","line":319,"kind":13},{"containerName":"_write_feature","name":"_find_name","kind":12,"line":319},{"containerName":"_write_feature","name":"$feat","line":319,"kind":13},{"line":320,"kind":13,"name":"$id","containerName":"_write_feature"},{"line":323,"kind":13,"name":"$id","containerName":"_write_feature"},{"name":"$feat","containerName":"_write_feature","line":323,"kind":13},{"kind":12,"line":323,"containerName":"_write_feature","name":"primary_tag"},{"containerName":"_write_feature","name":"$self","kind":13,"line":323},{"kind":13,"line":323,"containerName":"_write_feature","name":"$feat"},{"containerName":"_write_feature","name":"primary_tag","line":323,"kind":12},{"containerName":"_write_feature","name":"$bare","line":325,"kind":13},{"containerName":"_write_feature","name":"$writer","line":326,"kind":13},{"line":326,"kind":12,"containerName":"_write_feature","name":"startTag"},{"name":"$id","containerName":"_write_feature","line":326,"kind":13},{"name":"$self","containerName":"_write_feature","kind":13,"line":327},{"name":"_element","containerName":"_write_feature","kind":12,"line":327},{"containerName":"_write_feature","name":"$id","kind":13,"line":327},{"name":"$self","containerName":"_write_feature","line":328,"kind":13},{"line":328,"kind":12,"name":"_element","containerName":"_write_feature"},{"line":328,"kind":13,"containerName":"_write_feature","name":"$feat"},{"containerName":"_write_feature","name":"primary_tag","kind":12,"line":328},{"line":331,"kind":13,"name":"$writer","containerName":"_write_feature"},{"containerName":"_write_feature","name":"startTag","kind":12,"line":331},{"containerName":"_write_feature","name":"$id","line":331,"kind":13},{"line":332,"kind":13,"containerName":"_write_feature","name":"$self"},{"containerName":"_write_feature","name":"_element","line":332,"kind":12},{"name":"$id","containerName":"_write_feature","line":332,"kind":13},{"kind":13,"line":333,"containerName":"_write_feature","name":"$self"},{"containerName":"_write_feature","name":"_element","kind":12,"line":333},{"containerName":"_write_feature","name":"$feat","kind":13,"line":333},{"containerName":"_write_feature","name":"primary_tag","kind":12,"line":333},{"containerName":"_write_feature","name":"$self","line":334,"kind":13},{"name":"_render_tags","containerName":"_write_feature","kind":12,"line":334},{"name":"$feat","containerName":"_write_feature","line":334,"kind":13},{"kind":13,"line":339,"containerName":"_write_feature","name":"$self"},{"line":339,"kind":12,"name":"_feature_span","containerName":"_write_feature"},{"name":"$id","containerName":"_write_feature","line":339,"kind":13},{"containerName":"_write_feature","name":"$feat","kind":13,"line":339},{"kind":13,"line":340,"containerName":"_write_feature","name":"$writer"},{"kind":12,"line":340,"name":"endTag","containerName":"_write_feature"},{"name":"$writer","containerName":"_write_feature","kind":13,"line":341},{"line":341,"kind":12,"containerName":"_write_feature","name":"endTag"},{"line":341,"kind":13,"containerName":"_write_feature","name":"$bare"}],"line":313,"kind":12,"range":{"start":{"character":0,"line":313},"end":{"character":9999,"line":342}},"name":"_write_feature"},{"line":315,"kind":12,"name":"writer"},{"kind":12,"line":323,"name":"id"},{"kind":12,"line":326,"name":"id"},{"kind":12,"line":331,"name":"id"},{"line":335,"kind":12,"name":"_render_date_tags"},{"name":"_render_comment_tags","kind":12,"line":336},{"line":338,"kind":12,"name":"_render_tags_as_properties"},{"name":"_write_gene","range":{"end":{"line":585,"character":9999},"start":{"character":0,"line":359}},"containerName":"main::","definition":"sub","detail":"($self,$feat)","signature":{"label":"_write_gene($self,$feat)","parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier"},"kind":12,"line":359,"children":[{"kind":13,"line":360,"definition":"my","name":"$self","containerName":"_write_gene","localvar":"my"},{"containerName":"_write_gene","name":"$feat","kind":13,"line":360},{"kind":13,"line":361,"definition":"my","name":"$writer","containerName":"_write_gene","localvar":"my"},{"kind":13,"line":361,"name":"$self","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$str","definition":"my","localvar":"my","kind":13,"line":362},{"line":362,"kind":13,"containerName":"_write_gene","name":"$feat"},{"name":"strand","containerName":"_write_gene","kind":12,"line":362},{"kind":13,"line":363,"name":"$id","definition":"my","containerName":"_write_gene","localvar":"my"},{"kind":13,"line":363,"name":"$self","containerName":"_write_gene"},{"kind":12,"line":363,"containerName":"_write_gene","name":"_find_name"},{"name":"$feat","containerName":"_write_gene","line":363,"kind":13},{"kind":13,"line":364,"containerName":"_write_gene","name":"$self"},{"kind":12,"line":364,"name":"_find_name","containerName":"_write_gene"},{"kind":13,"line":364,"name":"$feat","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$self","line":365,"kind":13},{"line":365,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"containerName":"_write_gene","name":"$feat","line":365,"kind":13},{"containerName":"_write_gene","name":"$feat","kind":13,"line":365},{"name":"primary_tag","containerName":"_write_gene","line":365,"kind":12},{"name":"$self","containerName":"_write_gene","line":366,"kind":13},{"line":366,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"kind":13,"line":366,"name":"$feat","containerName":"_write_gene"},{"line":367,"kind":13,"containerName":"_write_gene","name":"$self"},{"line":367,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"kind":13,"line":367,"name":"$feat","containerName":"_write_gene"},{"kind":13,"line":368,"name":"$self","containerName":"_write_gene"},{"line":368,"kind":12,"name":"throw","containerName":"_write_gene"},{"name":"$feat","containerName":"_write_gene","kind":13,"line":368},{"containerName":"_write_gene","name":"display_name","line":368,"kind":12},{"line":372,"kind":13,"localvar":"my","containerName":"_write_gene","definition":"my","name":"$gid"},{"line":372,"kind":13,"name":"$self","containerName":"_write_gene"},{"name":"_find_name","containerName":"_write_gene","kind":12,"line":372},{"containerName":"_write_gene","name":"$feat","line":372,"kind":13},{"line":372,"kind":13,"name":"$id","containerName":"_write_gene"},{"name":"$writer","containerName":"_write_gene","kind":13,"line":374},{"line":374,"kind":12,"containerName":"_write_gene","name":"startTag"},{"line":374,"kind":13,"name":"$id","containerName":"_write_gene"},{"line":375,"kind":13,"containerName":"_write_gene","name":"$self"},{"containerName":"_write_gene","name":"_element","line":375,"kind":12},{"containerName":"_write_gene","name":"$gid","kind":13,"line":375},{"name":"$self","containerName":"_write_gene","kind":13,"line":376},{"kind":12,"line":376,"containerName":"_write_gene","name":"_element"},{"kind":13,"line":376,"name":"$feat","containerName":"_write_gene"},{"line":376,"kind":12,"containerName":"_write_gene","name":"primary_tag"},{"line":377,"kind":13,"containerName":"_write_gene","name":"$self"},{"containerName":"_write_gene","name":"_render_tags","kind":12,"line":377},{"line":377,"kind":13,"name":"$feat","containerName":"_write_gene"},{"localvar":"my","containerName":"_write_gene","definition":"my","name":"@genes","line":384,"kind":13},{"kind":13,"line":386,"name":"$feat","containerName":"_write_gene"},{"name":"primary_tag","containerName":"_write_gene","kind":12,"line":386},{"name":"@genes","containerName":"_write_gene","kind":13,"line":387},{"containerName":"_write_gene","name":"$feat","kind":13,"line":387},{"name":"@genes","containerName":"_write_gene","kind":13,"line":391},{"containerName":"_write_gene","name":"primary_tag","line":391,"kind":12},{"line":391,"kind":13,"name":"$feat","containerName":"_write_gene"},{"kind":12,"line":391,"name":"get_SeqFeatures","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$g","definition":"my","localvar":"my","kind":13,"line":394},{"containerName":"_write_gene","name":"@genes","kind":13,"line":394},{"containerName":"_write_gene","name":"$id","definition":"my","localvar":"my","kind":13,"line":395},{"line":395,"kind":13,"containerName":"_write_gene","name":"$self"},{"containerName":"_write_gene","name":"_find_name","line":395,"kind":12},{"kind":13,"line":395,"name":"$g","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$self","kind":13,"line":396},{"containerName":"_write_gene","name":"_find_name","line":396,"kind":12},{"containerName":"_write_gene","name":"$g","kind":13,"line":396},{"containerName":"_write_gene","name":"$self","line":397,"kind":13},{"name":"_find_name","containerName":"_write_gene","line":397,"kind":12},{"line":397,"kind":13,"containerName":"_write_gene","name":"$feat"},{"name":"$self","containerName":"_write_gene","line":398,"kind":13},{"containerName":"_write_gene","name":"_find_name","kind":12,"line":398},{"line":398,"kind":13,"name":"$feat","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$self","line":399,"kind":13},{"line":399,"kind":12,"name":"throw","containerName":"_write_gene"},{"line":400,"kind":13,"localvar":"my","containerName":"_write_gene","name":"$gid","definition":"my"},{"line":400,"kind":13,"name":"$self","containerName":"_write_gene"},{"containerName":"_write_gene","name":"_find_name","line":400,"kind":12},{"line":400,"kind":13,"containerName":"_write_gene","name":"$g"},{"kind":13,"line":400,"containerName":"_write_gene","name":"$self"},{"name":"_find_name","containerName":"_write_gene","line":400,"kind":12},{"containerName":"_write_gene","name":"$g","kind":13,"line":400},{"containerName":"_write_gene","name":"$writer","line":402,"kind":13},{"containerName":"_write_gene","name":"startTag","line":402,"kind":12},{"kind":13,"line":403,"name":"$self","containerName":"_write_gene"},{"containerName":"_write_gene","name":"_element","kind":12,"line":403},{"line":403,"kind":13,"name":"$gid","containerName":"_write_gene"},{"kind":13,"line":404,"containerName":"_write_gene","name":"$writer"},{"name":"endTag","containerName":"_write_gene","kind":12,"line":404},{"definition":"my","name":"$proteins","containerName":"_write_gene","localvar":"my","kind":13,"line":406},{"line":407,"kind":13,"localvar":"my","name":"@mRNAs","definition":"my","containerName":"_write_gene"},{"containerName":"_write_gene","name":"primary_tag","line":407,"kind":12},{"name":"$g","containerName":"_write_gene","line":407,"kind":13},{"containerName":"_write_gene","name":"get_SeqFeatures","line":407,"kind":12},{"line":408,"kind":13,"localvar":"my","definition":"my","name":"@other_stuff","containerName":"_write_gene"},{"line":408,"kind":12,"containerName":"_write_gene","name":"primary_tag"},{"name":"$g","containerName":"_write_gene","kind":13,"line":408},{"containerName":"_write_gene","name":"get_SeqFeatures","line":408,"kind":12},{"localvar":"my","name":"@variants","definition":"my","containerName":"_write_gene","line":409,"kind":13},{"localvar":"my","containerName":"_write_gene","definition":"my","name":"$mRNA","line":411,"kind":13},{"name":"@mRNAs","containerName":"_write_gene","kind":13,"line":411},{"name":"$sn","definition":"my","containerName":"_write_gene","localvar":"my","kind":13,"line":412},{"name":"@units","containerName":"_write_gene","kind":13,"line":412},{"line":416,"kind":13,"name":"$mRNA","containerName":"_write_gene"},{"line":416,"kind":12,"name":"primary_tag","containerName":"_write_gene"},{"line":417,"kind":13,"localvar":"my","name":"$exon","definition":"my","containerName":"_write_gene"},{"containerName":"_write_gene","name":"new","line":417,"kind":12},{"kind":13,"line":418,"name":"$exon","containerName":"_write_gene"},{"kind":12,"line":418,"name":"location","containerName":"_write_gene"},{"kind":13,"line":418,"containerName":"_write_gene","name":"$mRNA"},{"name":"location","containerName":"_write_gene","line":418,"kind":12},{"name":"$mRNA","containerName":"_write_gene","line":419,"kind":13},{"line":419,"kind":12,"containerName":"_write_gene","name":"add_SeqFeature"},{"name":"$exon","containerName":"_write_gene","line":419,"kind":13},{"containerName":"_write_gene","name":"$mRNA","line":423,"kind":13},{"name":"get_SeqFeatures","containerName":"_write_gene","kind":12,"line":423},{"kind":13,"line":424,"name":"$self","containerName":"_write_gene"},{"name":"_write_feature","containerName":"_write_gene","line":424,"kind":12},{"name":"$mRNA","containerName":"_write_gene","line":424,"kind":13},{"localvar":"my","name":"$name","definition":"my","containerName":"_write_gene","line":429,"kind":13},{"kind":13,"line":429,"containerName":"_write_gene","name":"$self"},{"kind":12,"line":429,"containerName":"_write_gene","name":"_find_name"},{"name":"$mRNA","containerName":"_write_gene","kind":13,"line":429},{"name":"$mRNA","containerName":"_write_gene","line":429,"kind":13},{"line":429,"kind":12,"containerName":"_write_gene","name":"primary_tag"},{"line":430,"kind":13,"name":"$self","containerName":"_write_gene"},{"name":"_find_name","containerName":"_write_gene","line":430,"kind":12},{"line":430,"kind":13,"name":"$mRNA","containerName":"_write_gene"},{"line":432,"kind":13,"localvar":"my","containerName":"_write_gene","definition":"my","name":"%attributes"},{"name":"$cds","definition":"my","containerName":"_write_gene","localvar":"my","kind":13,"line":433},{"line":433,"kind":12,"name":"primary_tag","containerName":"_write_gene"},{"line":433,"kind":13,"containerName":"_write_gene","name":"$mRNA"},{"containerName":"_write_gene","name":"get_SeqFeatures","kind":12,"line":433},{"containerName":"_write_gene","name":"$cds","line":438,"kind":13},{"kind":13,"line":438,"containerName":"_write_gene","name":"@mRNAs"},{"name":"$name","containerName":"_write_gene","line":438,"kind":13},{"name":"$cds","containerName":"_write_gene","line":439,"kind":13},{"line":439,"kind":13,"containerName":"_write_gene","name":"$self"},{"name":"_check_cds","containerName":"_write_gene","line":439,"kind":12},{"containerName":"_write_gene","name":"$cds","line":439,"kind":13},{"name":"$name","containerName":"_write_gene","line":439,"kind":13},{"containerName":"_write_gene","name":"$cds","line":441,"kind":13},{"kind":13,"line":441,"containerName":"_write_gene","name":"@mRNAs"},{"kind":13,"line":443,"containerName":"_write_gene","name":"$cds"},{"name":"has_tag","containerName":"_write_gene","kind":12,"line":443},{"kind":13,"line":444,"name":"$name","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$cds","line":444,"kind":13},{"kind":12,"line":444,"containerName":"_write_gene","name":"get_tag_values"},{"line":448,"kind":13,"containerName":"_write_gene","name":"$name"},{"containerName":"_write_gene","name":"$name","line":450,"kind":13},{"line":450,"kind":13,"name":"$id","containerName":"_write_gene"},{"line":450,"kind":13,"containerName":"_write_gene","name":"@variants"},{"line":453,"kind":13,"localvar":"my","definition":"my","name":"$pname","containerName":"_write_gene"},{"kind":13,"line":455,"containerName":"_write_gene","name":"$cds"},{"name":"$sn","containerName":"_write_gene","kind":13,"line":456},{"containerName":"_write_gene","name":"$cds","kind":13,"line":456},{"containerName":"_write_gene","name":"get_tag_values","kind":12,"line":456},{"name":"$cds","containerName":"_write_gene","kind":13,"line":457},{"name":"has_tag","containerName":"_write_gene","line":457,"kind":12},{"containerName":"_write_gene","name":"$sn","line":458,"kind":13},{"kind":13,"line":458,"containerName":"_write_gene","name":"$cds"},{"line":458,"kind":12,"name":"get_tag_values","containerName":"_write_gene"},{"line":459,"kind":13,"containerName":"_write_gene","name":"$cds"},{"kind":12,"line":459,"name":"has_tag","containerName":"_write_gene"},{"containerName":"_write_gene","definition":"my","name":"$psn","localvar":"my","kind":13,"line":462},{"name":"$self","containerName":"_write_gene","line":462,"kind":13},{"name":"protein_id","containerName":"_write_gene","kind":12,"line":462},{"name":"$cds","containerName":"_write_gene","line":462,"kind":13},{"name":"$sn","containerName":"_write_gene","kind":13,"line":462},{"line":463,"kind":13,"name":"$self","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$psn","kind":13,"line":463},{"containerName":"_write_gene","name":"$feat","line":466,"kind":13},{"line":466,"kind":12,"containerName":"_write_gene","name":"has_tag"},{"name":"$feat","containerName":"_write_gene","line":467,"kind":13},{"kind":12,"line":467,"name":"add_tag_value","containerName":"_write_gene"},{"line":467,"kind":13,"name":"$psn","containerName":"_write_gene"},{"line":471,"kind":13,"localvar":"my","definition":"my","name":"$c_start","containerName":"_write_gene"},{"name":"$c_end","containerName":"_write_gene","kind":13,"line":471},{"containerName":"_write_gene","name":"$cds","line":472,"kind":13},{"name":"has_tag","containerName":"_write_gene","kind":12,"line":472},{"kind":13,"line":473,"name":"$c_start","containerName":"_write_gene"},{"kind":13,"line":473,"name":"$cds","containerName":"_write_gene"},{"line":473,"kind":12,"containerName":"_write_gene","name":"get_tag_values"},{"containerName":"_write_gene","name":"$cds","line":474,"kind":13},{"kind":12,"line":474,"containerName":"_write_gene","name":"remove_tag"},{"name":"$c_start","containerName":"_write_gene","kind":13,"line":477},{"localvar":"my","name":"$cs","definition":"my","containerName":"_write_gene","line":479,"kind":13},{"kind":12,"line":479,"name":"new","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$c_start","kind":13,"line":480},{"line":481,"kind":13,"name":"$c_start","containerName":"_write_gene"},{"name":"$cds","containerName":"_write_gene","kind":13,"line":481},{"containerName":"_write_gene","name":"strand","kind":12,"line":481},{"kind":13,"line":481,"name":"$cds","containerName":"_write_gene"},{"kind":12,"line":481,"containerName":"_write_gene","name":"start"},{"kind":13,"line":481,"containerName":"_write_gene","name":"$cds"},{"kind":12,"line":481,"containerName":"_write_gene","name":"end"},{"line":483,"kind":13,"name":"$cds","containerName":"_write_gene"},{"containerName":"_write_gene","name":"strand","kind":12,"line":483},{"line":484,"kind":13,"containerName":"_write_gene","name":"$c_end"},{"line":484,"kind":13,"containerName":"_write_gene","name":"$c_start"},{"kind":13,"line":485,"containerName":"_write_gene","name":"$c_start"},{"line":485,"kind":13,"containerName":"_write_gene","name":"$c_start"},{"containerName":"_write_gene","name":"$c_end","line":488,"kind":13},{"line":488,"kind":13,"containerName":"_write_gene","name":"$c_start"},{"containerName":"_write_gene","name":"$cs","line":490,"kind":13},{"containerName":"_write_gene","name":"start","line":490,"kind":12},{"name":"$c_start","containerName":"_write_gene","line":490,"kind":13},{"kind":13,"line":491,"name":"$cs","containerName":"_write_gene"},{"line":491,"kind":12,"name":"end","containerName":"_write_gene"},{"name":"$c_end","containerName":"_write_gene","kind":13,"line":491},{"line":492,"kind":13,"name":"$cs","containerName":"_write_gene"},{"containerName":"_write_gene","name":"strand","line":492,"kind":12},{"line":492,"kind":13,"name":"$cds","containerName":"_write_gene"},{"kind":12,"line":492,"containerName":"_write_gene","name":"strand"},{"line":493,"kind":13,"name":"$cs","containerName":"_write_gene"},{"kind":12,"line":493,"name":"primary_tag","containerName":"_write_gene"},{"line":494,"kind":13,"containerName":"_write_gene","name":"$cs"},{"line":494,"kind":12,"containerName":"_write_gene","name":"add_tag_value"},{"line":494,"kind":13,"name":"$name","containerName":"_write_gene"},{"containerName":"_write_gene","name":"@units","line":495,"kind":13},{"line":495,"kind":13,"containerName":"_write_gene","name":"$cs"},{"name":"$cds","containerName":"_write_gene","kind":13,"line":498},{"containerName":"_write_gene","name":"has_tag","line":498,"kind":12},{"containerName":"_write_gene","name":"$val","definition":"my","localvar":"my","kind":13,"line":499},{"containerName":"_write_gene","name":"$cds","kind":13,"line":499},{"line":499,"kind":12,"name":"get_tag_values","containerName":"_write_gene"},{"name":"$cds","containerName":"_write_gene","kind":13,"line":500},{"kind":12,"line":500,"containerName":"_write_gene","name":"remove_tag"},{"line":501,"kind":13,"name":"$attributes","containerName":"_write_gene"},{"kind":13,"line":501,"name":"$val","containerName":"_write_gene"},{"definition":"my","name":"$aa","containerName":"_write_gene","localvar":"my","kind":13,"line":504},{"name":"$cds","containerName":"_write_gene","kind":13,"line":504},{"kind":12,"line":504,"containerName":"_write_gene","name":"get_tag_values"},{"containerName":"_write_gene","name":"$cds","line":505,"kind":13},{"containerName":"_write_gene","name":"has_tag","kind":12,"line":505},{"name":"$aa","containerName":"_write_gene","kind":13,"line":507},{"kind":13,"line":507,"name":"$psn","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$cds","line":508,"kind":13},{"name":"remove_tag","containerName":"_write_gene","kind":12,"line":508},{"name":"%add_seq","definition":"my","containerName":"_write_gene","localvar":"my","kind":13,"line":509},{"containerName":"_write_gene","name":"$add_seq","kind":13,"line":510},{"name":"$aa","containerName":"_write_gene","kind":13,"line":510},{"name":"$add_seq","containerName":"_write_gene","line":511,"kind":13},{"containerName":"_write_gene","name":"$psn","line":512,"kind":13},{"line":513,"kind":13,"name":"$aa","containerName":"_write_gene"},{"line":516,"kind":13,"name":"$cds","containerName":"_write_gene"},{"name":"has_tag","containerName":"_write_gene","kind":12,"line":516},{"line":517,"kind":13,"name":"$add_seq","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$cds","kind":13,"line":517},{"name":"get_tag_values","containerName":"_write_gene","line":517,"kind":12},{"line":518,"kind":13,"name":"$cds","containerName":"_write_gene"},{"containerName":"_write_gene","name":"remove_tag","kind":12,"line":518},{"containerName":"_write_gene","name":"$add_seq","kind":13,"line":521},{"name":"$add_seq","containerName":"_write_gene","kind":13,"line":521},{"containerName":"_write_gene","name":"$start","definition":"my","localvar":"my","kind":13,"line":522},{"containerName":"_write_gene","name":"$cds","kind":13,"line":522},{"kind":12,"line":522,"containerName":"_write_gene","name":"start"},{"line":523,"kind":13,"localvar":"my","containerName":"_write_gene","definition":"my","name":"$end"},{"name":"$cds","containerName":"_write_gene","kind":13,"line":523},{"containerName":"_write_gene","name":"end","line":523,"kind":12},{"line":524,"kind":13,"localvar":"my","definition":"my","name":"$str","containerName":"_write_gene"},{"name":"$cds","containerName":"_write_gene","kind":13,"line":524},{"name":"strand","containerName":"_write_gene","line":524,"kind":12},{"kind":13,"line":525,"name":"$acc","definition":"my","containerName":"_write_gene","localvar":"my"},{"kind":13,"line":525,"containerName":"_write_gene","name":"$self"},{"name":"accession","containerName":"_write_gene","kind":12,"line":525},{"name":"$self","containerName":"_write_gene","line":525,"kind":13},{"kind":12,"line":525,"name":"display_id","containerName":"_write_gene"},{"kind":13,"line":526,"containerName":"_write_gene","name":"$str"},{"kind":13,"line":526,"containerName":"_write_gene","name":"$str"},{"name":"$add_seq","containerName":"_write_gene","kind":13,"line":527},{"containerName":"_write_gene","name":"$acc","kind":13,"line":528},{"line":531,"kind":13,"name":"$self","containerName":"_write_gene"},{"name":"$self","containerName":"_write_gene","kind":13,"line":532},{"containerName":"_write_gene","name":"%add_seq","kind":13,"line":532},{"containerName":"_write_gene","name":"$writer","line":537,"kind":13},{"kind":12,"line":537,"containerName":"_write_gene","name":"startTag"},{"containerName":"_write_gene","name":"$name","line":537,"kind":13},{"containerName":"_write_gene","name":"$self","line":538,"kind":13},{"line":538,"kind":12,"containerName":"_write_gene","name":"_element"},{"containerName":"_write_gene","name":"$name","line":538,"kind":13},{"kind":13,"line":539,"name":"$self","containerName":"_write_gene"},{"line":539,"kind":12,"containerName":"_write_gene","name":"_element"},{"kind":13,"line":540,"containerName":"_write_gene","name":"$self"},{"line":540,"kind":12,"name":"_render_tags","containerName":"_write_gene"},{"name":"$mRNA","containerName":"_write_gene","kind":13,"line":544},{"line":544,"kind":13,"name":"$cds","containerName":"_write_gene"},{"line":547,"kind":13,"localvar":"my","containerName":"_write_gene","definition":"my","name":"$thing"},{"line":547,"kind":13,"name":"@other_stuff","containerName":"_write_gene"},{"kind":13,"line":548,"name":"$thing","containerName":"_write_gene"},{"line":548,"kind":12,"containerName":"_write_gene","name":"has_tag"},{"name":"$v","definition":"my","containerName":"_write_gene","localvar":"my","kind":13,"line":549},{"kind":13,"line":549,"name":"$thing","containerName":"_write_gene"},{"line":549,"kind":12,"containerName":"_write_gene","name":"get_tag_values"},{"containerName":"_write_gene","name":"$v","kind":13,"line":550},{"kind":13,"line":550,"containerName":"_write_gene","name":"$sn"},{"containerName":"_write_gene","name":"@units","line":551,"kind":13},{"kind":13,"line":551,"name":"$thing","containerName":"_write_gene"},{"kind":13,"line":557,"name":"@units","containerName":"_write_gene"},{"kind":12,"line":557,"name":"primary_tag","containerName":"_write_gene"},{"kind":13,"line":557,"containerName":"_write_gene","name":"$mRNA"},{"kind":12,"line":557,"name":"get_SeqFeatures","containerName":"_write_gene"},{"containerName":"_write_gene","name":"@units","line":558,"kind":13},{"name":"$a","containerName":"_write_gene","kind":13,"line":558},{"kind":12,"line":558,"name":"start","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$b","line":558,"kind":13},{"containerName":"_write_gene","name":"start","kind":12,"line":558},{"name":"@units","containerName":"_write_gene","kind":13,"line":558},{"kind":13,"line":560,"containerName":"_write_gene","name":"$count","definition":"my","localvar":"my"},{"line":562,"kind":13,"name":"$str","containerName":"_write_gene"},{"name":"@units","containerName":"_write_gene","kind":13,"line":563},{"containerName":"_write_gene","name":"@units","line":563,"kind":13},{"kind":13,"line":566,"definition":"my","name":"$unit","containerName":"_write_gene","localvar":"my"},{"kind":13,"line":566,"name":"@units","containerName":"_write_gene"},{"name":"$unit","containerName":"_write_gene","line":567,"kind":13},{"line":567,"kind":12,"containerName":"_write_gene","name":"primary_tag"},{"line":568,"kind":13,"localvar":"my","definition":"my","name":"$ename","containerName":"_write_gene"},{"kind":13,"line":568,"containerName":"_write_gene","name":"$id"},{"line":569,"kind":13,"name":"$ename","containerName":"_write_gene"},{"name":"$count","containerName":"_write_gene","kind":13,"line":569},{"containerName":"_write_gene","name":"$self","kind":13,"line":570},{"containerName":"_write_gene","name":"_feature_span","kind":12,"line":570},{"line":570,"kind":13,"name":"$ename","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$unit","line":570,"kind":13},{"containerName":"_write_gene","name":"$unit","line":572,"kind":13},{"containerName":"_write_gene","name":"primary_tag","line":572,"kind":12},{"line":573,"kind":13,"containerName":"_write_gene","name":"$self"},{"containerName":"_write_gene","name":"_feature_span","kind":12,"line":573},{"line":573,"kind":13,"containerName":"_write_gene","name":"$sn"},{"containerName":"_write_gene","name":"$gid","kind":13,"line":573},{"kind":13,"line":573,"containerName":"_write_gene","name":"$unit"},{"kind":13,"line":573,"containerName":"_write_gene","name":"$self"},{"kind":13,"line":576,"containerName":"_write_gene","definition":"my","name":"$uname","localvar":"my"},{"line":576,"kind":13,"name":"$unit","containerName":"_write_gene"},{"containerName":"_write_gene","name":"primary_tag","kind":12,"line":576},{"containerName":"_write_gene","name":"$self","line":577,"kind":13},{"line":577,"kind":12,"name":"_feature_span","containerName":"_write_gene"},{"containerName":"_write_gene","name":"$uname","kind":13,"line":577},{"kind":13,"line":577,"containerName":"_write_gene","name":"$unit"},{"line":580,"kind":13,"containerName":"_write_gene","name":"$self"},{"kind":13,"line":581,"containerName":"_write_gene","name":"$writer"},{"kind":12,"line":581,"name":"endTag","containerName":"_write_gene"},{"name":"$self","containerName":"_write_gene","line":584,"kind":13},{"containerName":"_write_gene","name":"@other_stuff","line":584,"kind":13}]},{"name":"writer","kind":12,"line":361},{"kind":12,"line":374,"name":"id"},{"name":"_render_date_tags","kind":12,"line":378},{"line":379,"kind":12,"name":"_render_dbxref_tags"},{"line":380,"kind":12,"name":"_render_comment_tags"},{"line":381,"kind":12,"name":"_render_tags_as_properties"},{"kind":12,"line":402,"name":"association"},{"line":417,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":463,"name":"curr_pname"},{"containerName":"SeqFeature::Generic","name":"Bio","line":479,"kind":12},{"line":501,"kind":12,"name":"problem"},{"name":"residues","line":510,"kind":12},{"kind":12,"line":511,"name":"header"},{"kind":12,"line":512,"name":"id"},{"name":"length","line":513,"kind":12},{"line":514,"kind":12,"name":"type"},{"name":"desc","line":517,"kind":12},{"kind":12,"line":521,"name":"desc"},{"name":"desc","line":521,"kind":12},{"name":"seq","line":525,"kind":12},{"line":525,"kind":12,"name":"seq"},{"line":527,"kind":12,"name":"desc"},{"kind":12,"line":531,"name":"add_seqs"},{"name":"add_seqs","line":532,"kind":12},{"name":"id","kind":12,"line":537},{"name":"_render_date_tags","line":541,"kind":12},{"kind":12,"line":542,"name":"_render_comment_tags"},{"name":"_render_tags_as_properties","line":543,"kind":12},{"kind":12,"line":573,"name":"curr_pname"},{"name":"curr_pname","kind":12,"line":580},{"name":"other_stuff","line":584,"kind":12},{"line":587,"kind":13,"containerName":null,"name":"$writer"},{"containerName":"main::","name":"endTag","line":587,"kind":12},{"kind":13,"line":590,"name":"%self","containerName":null},{"name":"add_seqs","line":590,"kind":12},{"kind":13,"line":591,"name":"%h","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":591,"name":"$_","containerName":null},{"containerName":null,"name":"$writer","line":592,"kind":13},{"line":592,"kind":12,"name":"startTag","containerName":"main::"},{"name":"%h","containerName":null,"line":592,"kind":13},{"name":"header","line":592,"kind":12},{"localvar":"my","name":"@desc","definition":"my","containerName":null,"line":593,"kind":13},{"name":"%h","containerName":null,"line":593,"kind":13},{"kind":12,"line":593,"name":"desc"},{"localvar":"my","containerName":null,"definition":"my","name":"$desc","line":594,"kind":13},{"containerName":null,"definition":"my","name":"$word","localvar":"my","kind":13,"line":595},{"containerName":null,"name":"@desc","kind":13,"line":595},{"kind":13,"line":596,"name":"$lastline","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$desc","line":596,"kind":13},{"name":"$lastline","containerName":null,"kind":13,"line":597},{"line":598,"kind":13,"name":"$desc","containerName":null},{"containerName":null,"name":"$lastline","kind":13,"line":598},{"kind":13,"line":600,"containerName":null,"name":"$self"},{"name":"_element","containerName":"main::","kind":12,"line":600},{"definition":"my","name":"$aa","containerName":null,"localvar":"my","kind":13,"line":602},{"containerName":null,"name":"%h","line":602,"kind":13},{"name":"residues","kind":12,"line":602},{"containerName":null,"name":"$aa","kind":13,"line":603},{"containerName":null,"name":"$aa","kind":13,"line":604},{"line":605,"kind":13,"containerName":null,"name":"$aa"},{"containerName":null,"name":"$aa","kind":13,"line":605},{"line":606,"kind":13,"name":"$self","containerName":null},{"name":"_element","containerName":"main::","kind":12,"line":606},{"name":"$aa","containerName":null,"kind":13,"line":606},{"line":607,"kind":13,"containerName":null,"name":"$writer"},{"name":"endTag","containerName":"main::","line":607,"kind":12},{"kind":13,"line":608,"name":"%self","containerName":null},{"name":"add_seqs","line":608,"kind":12},{"line":614,"kind":13,"localvar":"my","containerName":null,"name":"$thing","definition":"my"},{"line":614,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":614,"name":"other_stuff"},{"containerName":null,"name":"$thing","line":615,"kind":13},{"containerName":"main::","name":"has_tag","kind":12,"line":615},{"name":"$self","containerName":null,"kind":13,"line":616},{"line":616,"kind":12,"containerName":"main::","name":"_write_feature"},{"containerName":null,"name":"$thing","kind":13,"line":616},{"line":618,"kind":13,"containerName":null,"name":"%self"},{"name":"other_stuff","line":618,"kind":12},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$cds"},{"label":"$name"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.","label":"_check_cds($self,$cds,$name)"},"detail":"($self,$cds,$name)","kind":12,"children":[{"kind":13,"line":640,"definition":"my","name":"$self","containerName":"_check_cds","localvar":"my"},{"line":640,"kind":13,"name":"$cds","containerName":"_check_cds"},{"name":"$name","containerName":"_check_cds","line":640,"kind":13},{"line":641,"kind":13,"localvar":"my","containerName":"_check_cds","name":"$cname","definition":"my"},{"kind":13,"line":641,"containerName":"_check_cds","name":"$self"},{"name":"_find_name","containerName":"_check_cds","line":641,"kind":12},{"containerName":"_check_cds","name":"$cds","line":641,"kind":13},{"name":"$self","containerName":"_check_cds","line":642,"kind":13},{"name":"_find_name","containerName":"_check_cds","kind":12,"line":642},{"name":"$cds","containerName":"_check_cds","line":642,"kind":13},{"kind":13,"line":644,"containerName":"_check_cds","name":"$cname"},{"line":645,"kind":13,"containerName":"_check_cds","name":"$cname"},{"kind":13,"line":645,"name":"$name","containerName":"_check_cds"},{"name":"$cds","containerName":"_check_cds","line":646,"kind":13},{"kind":13,"line":649,"containerName":"_check_cds","name":"@CDS","definition":"my","localvar":"my"},{"kind":12,"line":649,"name":"primary_tag","containerName":"_check_cds"},{"name":"$self","containerName":"_check_cds","kind":13,"line":649},{"containerName":"_check_cds","name":"@CDS","kind":13,"line":650},{"kind":13,"line":651,"containerName":"_check_cds","definition":"my","name":"$sname","localvar":"my"},{"line":651,"kind":12,"name":"_find_name","containerName":"_check_cds"},{"line":652,"kind":12,"name":"_find_name","containerName":"_check_cds"},{"kind":12,"line":652,"containerName":"_check_cds","name":"primary_tag"},{"containerName":"_check_cds","name":"$sname","line":653,"kind":13},{"containerName":"_check_cds","name":"$name","line":653,"kind":13}],"line":639,"name":"_check_cds","range":{"end":{"line":657,"character":9999},"start":{"line":639,"character":0}}},{"line":649,"kind":12,"name":"feats"},{"line":659,"kind":13,"name":"$cds","containerName":null},{"definition":"sub","containerName":"main::","signature":{"label":"_comp_analysis($self,$feat)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"}]},"detail":"($self,$feat)","kind":12,"children":[{"kind":13,"line":676,"definition":"my","name":"$self","containerName":"_comp_analysis","localvar":"my"},{"line":676,"kind":13,"containerName":"_comp_analysis","name":"$feat"},{"line":677,"kind":13,"localvar":"my","definition":"my","name":"$writer","containerName":"_comp_analysis"},{"line":677,"kind":13,"containerName":"_comp_analysis","name":"$self"},{"kind":13,"line":679,"name":"$writer","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"startTag","line":679,"kind":12},{"containerName":"_comp_analysis","name":"$self","line":680,"kind":13},{"line":680,"kind":12,"name":"_element","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"$feat","line":680,"kind":13},{"kind":12,"line":680,"containerName":"_comp_analysis","name":"program_name"},{"line":681,"kind":13,"name":"$self","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"_element","line":681,"kind":12},{"name":"$feat","containerName":"_comp_analysis","kind":13,"line":681},{"kind":12,"line":681,"name":"database_name","containerName":"_comp_analysis"},{"line":681,"kind":13,"name":"$feat","containerName":"_comp_analysis"},{"name":"database_name","containerName":"_comp_analysis","kind":12,"line":681},{"name":"$self","containerName":"_comp_analysis","kind":13,"line":682},{"line":682,"kind":12,"containerName":"_comp_analysis","name":"_element"},{"containerName":"_comp_analysis","name":"$feat","kind":13,"line":682},{"containerName":"_comp_analysis","name":"program_version","kind":12,"line":682},{"line":682,"kind":13,"containerName":"_comp_analysis","name":"$feat"},{"line":682,"kind":12,"name":"program_version","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"$self","line":683,"kind":13},{"containerName":"_comp_analysis","name":"_element","line":683,"kind":12},{"line":683,"kind":13,"name":"$feat","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"primary_tag","kind":12,"line":683},{"name":"$feat","containerName":"_comp_analysis","line":683,"kind":13},{"name":"primary_tag","containerName":"_comp_analysis","kind":12,"line":683},{"name":"$self","containerName":"_comp_analysis","kind":13,"line":684},{"kind":12,"line":684,"name":"_render_tags","containerName":"_comp_analysis"},{"kind":13,"line":684,"name":"$feat","containerName":"_comp_analysis"},{"containerName":"_comp_analysis","name":"$self","kind":13,"line":688},{"containerName":"_comp_analysis","name":"_comp_result","line":688,"kind":12},{"name":"$feat","containerName":"_comp_analysis","kind":13,"line":688},{"kind":13,"line":689,"containerName":"_comp_analysis","name":"$writer"},{"name":"endTag","containerName":"_comp_analysis","line":689,"kind":12}],"line":675,"name":"_comp_analysis","range":{"start":{"character":0,"line":675},"end":{"line":690,"character":9999}}},{"kind":12,"line":677,"name":"writer"},{"line":685,"kind":12,"name":"_render_date_tags"},{"line":686,"kind":12,"name":"_render_tags_as_properties"},{"kind":12,"line":703,"children":[{"line":704,"kind":13,"localvar":"my","containerName":"_comp_result","name":"$self","definition":"my"},{"name":"$feat","containerName":"_comp_result","kind":13,"line":704},{"localvar":"my","containerName":"_comp_result","name":"@subfeats","definition":"my","line":711,"kind":13},{"line":711,"kind":13,"name":"$feat","containerName":"_comp_result"},{"kind":12,"line":711,"containerName":"_comp_result","name":"get_SeqFeatures"},{"line":711,"kind":13,"name":"$feat","containerName":"_comp_result"},{"line":711,"kind":12,"name":"get_all_tags","containerName":"_comp_result"},{"localvar":"my","definition":"my","name":"$writer","containerName":"_comp_result","line":712,"kind":13},{"name":"$self","containerName":"_comp_result","kind":13,"line":712},{"name":"$writer","containerName":"_comp_result","line":713,"kind":13},{"name":"startTag","containerName":"_comp_result","kind":12,"line":713},{"containerName":"_comp_result","name":"$feat","kind":13,"line":714},{"name":"can","containerName":"_comp_result","kind":12,"line":714},{"containerName":"_comp_result","name":"$feat","line":714,"kind":13},{"kind":12,"line":714,"containerName":"_comp_result","name":"computation_id"},{"line":715,"kind":13,"containerName":"_comp_result","name":"$feat"},{"name":"computation_id","containerName":"_comp_result","line":715,"kind":12},{"containerName":"_comp_result","name":"$fakename","definition":"my","localvar":"my","kind":13,"line":717},{"name":"$feat","containerName":"_comp_result","line":717,"kind":13},{"kind":12,"line":717,"name":"primary_tag","containerName":"_comp_result"},{"line":718,"kind":13,"containerName":"_comp_result","name":"$self"},{"name":"_element","containerName":"_comp_result","kind":12,"line":718},{"kind":13,"line":718,"containerName":"_comp_result","name":"$feat"},{"containerName":"_comp_result","name":"display_name","kind":12,"line":718},{"kind":13,"line":718,"name":"$fakename","containerName":"_comp_result"},{"kind":13,"line":718,"containerName":"_comp_result","name":"$self"},{"containerName":"_comp_result","name":"$fakename","line":718,"kind":13},{"kind":13,"line":719,"name":"$self","containerName":"_comp_result"},{"containerName":"_comp_result","name":"_seq_relationship","line":719,"kind":12},{"line":719,"kind":13,"name":"$feat","containerName":"_comp_result"},{"name":"$self","containerName":"_comp_result","kind":13,"line":720},{"containerName":"_comp_result","name":"_render_tags","line":720,"kind":12},{"name":"$feat","containerName":"_comp_result","kind":13,"line":720},{"kind":13,"line":723,"name":"@subfeats","containerName":"_comp_result"},{"name":"$self","containerName":"_comp_result","kind":13,"line":724},{"containerName":"_comp_result","name":"_comp_result","kind":12,"line":724},{"line":726,"kind":13,"containerName":"_comp_result","name":"$self"},{"line":726,"kind":12,"containerName":"_comp_result","name":"_comp_result_span"},{"kind":13,"line":726,"name":"$feat","containerName":"_comp_result"},{"line":727,"kind":13,"containerName":"_comp_result","name":"$writer"},{"containerName":"_comp_result","name":"endTag","kind":12,"line":727},{"line":730,"kind":13,"containerName":"_comp_result","name":"$self"},{"line":730,"kind":12,"containerName":"_comp_result","name":"_comp_result_span"},{"line":730,"kind":13,"name":"$feat","containerName":"_comp_result"}],"containerName":"main::","definition":"sub","detail":"($self,$feat)","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"_comp_result($self,$feat)"},"name":"_comp_result","range":{"start":{"character":0,"line":703},"end":{"line":732,"character":9999}}},{"line":712,"kind":12,"name":"writer"},{"kind":12,"line":715,"name":"id"},{"line":718,"kind":12,"name":"anon_result_set_counters"},{"kind":12,"line":722,"name":"_render_output_tags"},{"name":"_comp_result_span","range":{"end":{"line":767,"character":9999},"start":{"character":0,"line":747}},"kind":12,"line":747,"children":[{"kind":13,"line":749,"name":"$self","definition":"my","containerName":"_comp_result_span","localvar":"my"},{"line":749,"kind":13,"name":"$feat","containerName":"_comp_result_span"},{"line":750,"kind":13,"localvar":"my","containerName":"_comp_result_span","definition":"my","name":"$writer"},{"line":750,"kind":13,"containerName":"_comp_result_span","name":"$self"},{"containerName":"_comp_result_span","name":"$writer","line":752,"kind":13},{"containerName":"_comp_result_span","name":"startTag","kind":12,"line":752},{"kind":13,"line":753,"name":"$feat","containerName":"_comp_result_span"},{"kind":12,"line":753,"containerName":"_comp_result_span","name":"can"},{"line":753,"kind":13,"name":"$feat","containerName":"_comp_result_span"},{"containerName":"_comp_result_span","name":"computation_id","line":753,"kind":12},{"containerName":"_comp_result_span","name":"$feat","kind":13,"line":753},{"name":"computation_id","containerName":"_comp_result_span","kind":12,"line":753},{"kind":13,"line":755,"name":"$self","containerName":"_comp_result_span"},{"kind":12,"line":755,"containerName":"_comp_result_span","name":"_element"},{"kind":13,"line":755,"name":"$feat","containerName":"_comp_result_span"},{"name":"display_name","containerName":"_comp_result_span","line":755,"kind":12},{"name":"$feat","containerName":"_comp_result_span","line":755,"kind":13},{"line":755,"kind":12,"containerName":"_comp_result_span","name":"display_name"},{"kind":13,"line":756,"name":"$self","containerName":"_comp_result_span"},{"line":756,"kind":12,"containerName":"_comp_result_span","name":"_element"},{"kind":13,"line":756,"containerName":"_comp_result_span","name":"$feat"},{"containerName":"_comp_result_span","name":"primary_tag","kind":12,"line":756},{"name":"$feat","containerName":"_comp_result_span","kind":13,"line":756},{"line":756,"kind":12,"name":"primary_tag","containerName":"_comp_result_span"},{"line":757,"kind":13,"localvar":"my","name":"$has_score","definition":"my","containerName":"_comp_result_span"},{"containerName":"_comp_result_span","name":"$feat","kind":13,"line":757},{"kind":12,"line":757,"containerName":"_comp_result_span","name":"can"},{"kind":13,"line":757,"containerName":"_comp_result_span","name":"$feat"},{"kind":12,"line":757,"name":"has_score","containerName":"_comp_result_span"},{"name":"$feat","containerName":"_comp_result_span","line":757,"kind":13},{"line":757,"kind":12,"containerName":"_comp_result_span","name":"score"},{"name":"$self","containerName":"_comp_result_span","line":758,"kind":13},{"containerName":"_comp_result_span","name":"_element","line":758,"kind":12},{"line":758,"kind":13,"containerName":"_comp_result_span","name":"$feat"},{"line":758,"kind":12,"name":"score","containerName":"_comp_result_span"},{"kind":13,"line":758,"name":"$has_score","containerName":"_comp_result_span"},{"containerName":"_comp_result_span","name":"$self","kind":13,"line":759},{"kind":12,"line":759,"name":"_render_tags","containerName":"_comp_result_span"},{"kind":13,"line":759,"containerName":"_comp_result_span","name":"$feat"},{"kind":13,"line":762,"containerName":"_comp_result_span","name":"$self"},{"line":762,"kind":12,"name":"_seq_relationship","containerName":"_comp_result_span"},{"kind":13,"line":762,"containerName":"_comp_result_span","name":"$feat"},{"kind":13,"line":763,"name":"$self","containerName":"_comp_result_span"},{"containerName":"_comp_result_span","name":"_render_tags","kind":12,"line":763},{"kind":13,"line":763,"name":"$feat","containerName":"_comp_result_span"},{"line":766,"kind":13,"containerName":"_comp_result_span","name":"$writer"},{"line":766,"kind":12,"containerName":"_comp_result_span","name":"endTag"}],"containerName":"main::","definition":"sub","detail":"($self,$feat)","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"_comp_result_span($self,$feat)"}},{"line":750,"kind":12,"name":"writer"},{"name":"id","kind":12,"line":753},{"name":"_render_output_tags","line":761,"kind":12},{"name":"_render_target_tags","kind":12,"line":764},{"containerName":"main::","definition":"sub","detail":"($self,$feat,@render_funcs)","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@render_funcs"}],"label":"_render_tags($self,$feat,@render_funcs)"},"kind":12,"line":780,"children":[{"kind":13,"line":781,"definition":"my","name":"$self","containerName":"_render_tags","localvar":"my"},{"name":"$feat","containerName":"_render_tags","kind":13,"line":781},{"name":"@render_funcs","containerName":"_render_tags","line":781,"kind":13},{"kind":13,"line":783,"definition":"my","name":"@tagnames","containerName":"_render_tags","localvar":"my"},{"name":"$feat","containerName":"_render_tags","line":783,"kind":13},{"name":"get_all_tags","containerName":"_render_tags","line":783,"kind":12},{"line":788,"kind":13,"localvar":"my","containerName":"_render_tags","name":"$func","definition":"my"},{"line":788,"kind":13,"containerName":"_render_tags","name":"@render_funcs"},{"kind":13,"line":789,"name":"@tagnames","containerName":"_render_tags"},{"kind":13,"line":789,"name":"$self","containerName":"_render_tags"},{"line":789,"kind":13,"containerName":"_render_tags","name":"$func"},{"containerName":"_render_tags","name":"$feat","line":789,"kind":13},{"line":789,"kind":13,"containerName":"_render_tags","name":"@tagnames"}],"name":"_render_tags","range":{"start":{"character":0,"line":780},"end":{"character":9999,"line":791}}},{"signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"label":"_render_output_tags($self,$feat,@tagnames)"},"detail":"($self,$feat,@tagnames)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":807,"containerName":"_render_output_tags","definition":"my","name":"$self","localvar":"my"},{"name":"$feat","containerName":"_render_output_tags","line":807,"kind":13},{"name":"@tagnames","containerName":"_render_output_tags","line":807,"kind":13},{"containerName":"_render_output_tags","definition":"my","name":"$writer","localvar":"my","kind":13,"line":808},{"containerName":"_render_output_tags","name":"$self","line":808,"kind":13},{"kind":13,"line":809,"containerName":"_render_output_tags","definition":"my","name":"@passed_up","localvar":"my"},{"kind":13,"line":811,"containerName":"_render_output_tags","definition":"my","name":"$tag","localvar":"my"},{"name":"@tagnames","containerName":"_render_output_tags","line":811,"kind":13},{"name":"$tag","containerName":"_render_output_tags","line":812,"kind":13},{"localvar":"my","containerName":"_render_output_tags","definition":"my","name":"@outputs","line":813,"kind":13},{"name":"$feat","containerName":"_render_output_tags","kind":13,"line":813},{"containerName":"_render_output_tags","name":"get_tag_values","line":813,"kind":12},{"line":813,"kind":13,"containerName":"_render_output_tags","name":"$tag"},{"kind":13,"line":814,"name":"$type","definition":"my","containerName":"_render_output_tags","localvar":"my"},{"containerName":"_render_output_tags","name":"$val","kind":13,"line":814},{"kind":13,"line":814,"name":"@outputs","containerName":"_render_output_tags"},{"name":"$writer","containerName":"_render_output_tags","line":815,"kind":13},{"line":815,"kind":12,"containerName":"_render_output_tags","name":"startTag"},{"name":"$self","containerName":"_render_output_tags","line":816,"kind":13},{"containerName":"_render_output_tags","name":"_element","kind":12,"line":816},{"containerName":"_render_output_tags","name":"$type","kind":13,"line":816},{"line":817,"kind":13,"name":"$self","containerName":"_render_output_tags"},{"containerName":"_render_output_tags","name":"_element","line":817,"kind":12},{"kind":13,"line":817,"name":"$val","containerName":"_render_output_tags"},{"line":818,"kind":13,"containerName":"_render_output_tags","name":"$writer"},{"line":818,"kind":12,"name":"endTag","containerName":"_render_output_tags"},{"name":"@passed_up","containerName":"_render_output_tags","kind":13,"line":822},{"name":"$tag","containerName":"_render_output_tags","line":822,"kind":13},{"line":825,"kind":13,"containerName":"_render_output_tags","name":"@passed_up"}],"line":806,"kind":12,"range":{"start":{"character":0,"line":806},"end":{"character":9999,"line":826}},"name":"_render_output_tags"},{"name":"writer","kind":12,"line":808},{"range":{"start":{"line":842,"character":0},"end":{"line":851,"character":9999}},"name":"_render_tags_as_properties","line":842,"children":[{"line":843,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_render_tags_as_properties"},{"line":843,"kind":13,"name":"$feat","containerName":"_render_tags_as_properties"},{"name":"@tagnames","containerName":"_render_tags_as_properties","line":843,"kind":13},{"kind":13,"line":845,"containerName":"_render_tags_as_properties","definition":"my","name":"$tag","localvar":"my"},{"line":845,"kind":13,"name":"@tagnames","containerName":"_render_tags_as_properties"},{"kind":13,"line":846,"containerName":"_render_tags_as_properties","name":"$tag"},{"line":846,"kind":13,"name":"$feat","containerName":"_render_tags_as_properties"},{"name":"primary_tag","containerName":"_render_tags_as_properties","kind":12,"line":846},{"containerName":"_render_tags_as_properties","name":"$self","line":847,"kind":13},{"containerName":"_render_tags_as_properties","name":"_property","kind":12,"line":847},{"name":"$tag","containerName":"_render_tags_as_properties","kind":13,"line":847},{"containerName":"_render_tags_as_properties","name":"$feat","kind":13,"line":847},{"kind":12,"line":847,"containerName":"_render_tags_as_properties","name":"get_tag_values"},{"containerName":"_render_tags_as_properties","name":"$tag","kind":13,"line":847}],"kind":12,"detail":"($self,$feat,@tagnames)","signature":{"label":"_render_tags_as_properties($self,$feat,@tagnames)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties."},"containerName":"main::","definition":"sub"},{"name":"_render_comment_tags","range":{"end":{"line":887,"character":9999},"start":{"line":867,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"label":"_render_comment_tags($self,$feat,@tagnames)"},"detail":"($self,$feat,@tagnames)","kind":12,"children":[{"line":868,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_render_comment_tags"},{"kind":13,"line":868,"containerName":"_render_comment_tags","name":"$feat"},{"name":"@tagnames","containerName":"_render_comment_tags","kind":13,"line":868},{"line":869,"kind":13,"localvar":"my","containerName":"_render_comment_tags","name":"$writer","definition":"my"},{"name":"$self","containerName":"_render_comment_tags","kind":13,"line":869},{"localvar":"my","definition":"my","name":"@passed_up","containerName":"_render_comment_tags","line":870,"kind":13},{"definition":"my","name":"$tag","containerName":"_render_comment_tags","localvar":"my","kind":13,"line":871},{"kind":13,"line":871,"name":"@tagnames","containerName":"_render_comment_tags"},{"containerName":"_render_comment_tags","name":"$tag","line":872,"kind":13},{"name":"$val","definition":"my","containerName":"_render_comment_tags","localvar":"my","kind":13,"line":873},{"line":873,"kind":13,"containerName":"_render_comment_tags","name":"$feat"},{"kind":12,"line":873,"name":"get_tag_values","containerName":"_render_comment_tags"},{"containerName":"_render_comment_tags","name":"$tag","kind":13,"line":873},{"kind":13,"line":874,"name":"$val","containerName":"_render_comment_tags"},{"containerName":"_render_comment_tags","name":"$self","kind":13,"line":875},{"kind":12,"line":875,"name":"_unflatten_attribute","containerName":"_render_comment_tags"},{"kind":13,"line":875,"name":"$val","containerName":"_render_comment_tags"},{"kind":13,"line":877,"containerName":"_render_comment_tags","name":"$writer"},{"containerName":"_render_comment_tags","name":"startTag","line":877,"kind":12},{"name":"$self","containerName":"_render_comment_tags","kind":13,"line":878},{"containerName":"_render_comment_tags","name":"_element","kind":12,"line":878},{"name":"$val","containerName":"_render_comment_tags","line":878,"kind":13},{"containerName":"_render_comment_tags","name":"$writer","line":879,"kind":13},{"kind":12,"line":879,"containerName":"_render_comment_tags","name":"endTag"},{"line":883,"kind":13,"name":"@passed_up","containerName":"_render_comment_tags"},{"kind":13,"line":883,"name":"$tag","containerName":"_render_comment_tags"},{"containerName":"_render_comment_tags","name":"@passed_up","line":886,"kind":13}],"line":867},{"kind":12,"line":869,"name":"writer"},{"range":{"start":{"character":0,"line":904},"end":{"character":9999,"line":921}},"name":"_render_date_tags","signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.","label":"_render_date_tags($self,$feat,@tagnames)"},"detail":"($self,$feat,@tagnames)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_render_date_tags","name":"$self","definition":"my","line":905,"kind":13},{"kind":13,"line":905,"name":"$feat","containerName":"_render_date_tags"},{"containerName":"_render_date_tags","name":"@tagnames","kind":13,"line":905},{"containerName":"_render_date_tags","definition":"my","name":"@passed_up","localvar":"my","kind":13,"line":906},{"kind":13,"line":907,"definition":"my","name":"$date","containerName":"_render_date_tags","localvar":"my"},{"kind":13,"line":908,"containerName":"_render_date_tags","definition":"my","name":"%timestamp","localvar":"my"},{"line":909,"kind":13,"localvar":"my","definition":"my","name":"$tag","containerName":"_render_date_tags"},{"name":"@tagnames","containerName":"_render_date_tags","line":909,"kind":13},{"line":910,"kind":13,"name":"$tag","containerName":"_render_date_tags"},{"line":911,"kind":13,"name":"$date","containerName":"_render_date_tags"},{"kind":13,"line":911,"containerName":"_render_date_tags","name":"$feat"},{"containerName":"_render_date_tags","name":"get_tag_values","line":911,"kind":12},{"name":"$tag","containerName":"_render_date_tags","line":911,"kind":13},{"name":"$tag","containerName":"_render_date_tags","line":912,"kind":13},{"containerName":"_render_date_tags","name":"$timestamp","line":913,"kind":13},{"containerName":"_render_date_tags","name":"$feat","line":913,"kind":13},{"line":913,"kind":12,"containerName":"_render_date_tags","name":"get_tag_values"},{"name":"$tag","containerName":"_render_date_tags","line":913,"kind":13},{"kind":13,"line":916,"containerName":"_render_date_tags","name":"@passed_up"},{"line":916,"kind":13,"name":"$tag","containerName":"_render_date_tags"},{"name":"$self","containerName":"_render_date_tags","kind":13,"line":919},{"containerName":"_render_date_tags","name":"_element","line":919,"kind":12},{"name":"$date","containerName":"_render_date_tags","kind":13,"line":919},{"kind":13,"line":919,"containerName":"_render_date_tags","name":"%timestamp"},{"name":"$date","containerName":"_render_date_tags","kind":13,"line":919},{"name":"@passed_up","containerName":"_render_date_tags","kind":13,"line":920}],"line":904,"kind":12},{"line":937,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_render_dbxref_tags","line":938,"kind":13},{"kind":13,"line":938,"containerName":"_render_dbxref_tags","name":"$feat"},{"kind":13,"line":938,"name":"@tagnames","containerName":"_render_dbxref_tags"},{"containerName":"_render_dbxref_tags","definition":"my","name":"@passed_up","localvar":"my","kind":13,"line":939},{"line":940,"kind":13,"localvar":"my","containerName":"_render_dbxref_tags","name":"$tag","definition":"my"},{"containerName":"_render_dbxref_tags","name":"@tagnames","line":940,"kind":13},{"kind":13,"line":941,"name":"$tag","containerName":"_render_dbxref_tags"},{"containerName":"_render_dbxref_tags","definition":"my","name":"$writer","localvar":"my","kind":13,"line":942},{"name":"$self","containerName":"_render_dbxref_tags","kind":13,"line":942},{"containerName":"_render_dbxref_tags","name":"$val","definition":"my","localvar":"my","kind":13,"line":943},{"kind":13,"line":943,"name":"$feat","containerName":"_render_dbxref_tags"},{"line":943,"kind":12,"name":"get_all_tag_values","containerName":"_render_dbxref_tags"},{"name":"$tag","containerName":"_render_dbxref_tags","line":943,"kind":13},{"kind":13,"line":944,"name":"$db","definition":"my","containerName":"_render_dbxref_tags","localvar":"my"},{"kind":13,"line":944,"containerName":"_render_dbxref_tags","name":"$dbid"},{"name":"$val","containerName":"_render_dbxref_tags","line":944,"kind":13},{"containerName":"_render_dbxref_tags","name":"$writer","kind":13,"line":945},{"kind":12,"line":945,"containerName":"_render_dbxref_tags","name":"startTag"},{"containerName":"_render_dbxref_tags","name":"$self","kind":13,"line":946},{"kind":12,"line":946,"name":"_element","containerName":"_render_dbxref_tags"},{"line":946,"kind":13,"containerName":"_render_dbxref_tags","name":"$db"},{"kind":13,"line":947,"name":"$dbid","containerName":"_render_dbxref_tags"},{"kind":13,"line":947,"containerName":"_render_dbxref_tags","name":"$val"},{"name":"$db","containerName":"_render_dbxref_tags","kind":13,"line":947},{"kind":13,"line":948,"containerName":"_render_dbxref_tags","name":"$self"},{"containerName":"_render_dbxref_tags","name":"_element","kind":12,"line":948},{"kind":13,"line":948,"containerName":"_render_dbxref_tags","name":"$dbid"},{"containerName":"_render_dbxref_tags","name":"$writer","line":949,"kind":13},{"name":"endTag","containerName":"_render_dbxref_tags","line":949,"kind":12},{"containerName":"_render_dbxref_tags","name":"@passed_up","kind":13,"line":953},{"kind":13,"line":953,"name":"$tag","containerName":"_render_dbxref_tags"},{"line":956,"kind":13,"name":"@passed_up","containerName":"_render_dbxref_tags"}],"kind":12,"detail":"($self,$feat,@tagnames)","signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\nTODO: can't sequences also have database xrefs?  how to find those?","label":"_render_dbxref_tags($self,$feat,@tagnames)"},"containerName":"main::","definition":"sub","range":{"end":{"line":957,"character":9999},"start":{"character":0,"line":937}},"name":"_render_dbxref_tags"},{"name":"writer","line":942,"kind":12},{"kind":12,"children":[{"kind":13,"line":976,"definition":"my","name":"$self","containerName":"_render_target_tags","localvar":"my"},{"line":976,"kind":13,"name":"$feat","containerName":"_render_target_tags"},{"kind":13,"line":976,"name":"@tagnames","containerName":"_render_target_tags"},{"line":977,"kind":13,"localvar":"my","containerName":"_render_target_tags","definition":"my","name":"@passed_up"},{"containerName":"_render_target_tags","name":"$tag","definition":"my","localvar":"my","kind":13,"line":978},{"kind":13,"line":978,"containerName":"_render_target_tags","name":"@tagnames"},{"kind":13,"line":979,"containerName":"_render_target_tags","name":"$tag"},{"localvar":"my","name":"@alignment","definition":"my","containerName":"_render_target_tags","line":979,"kind":13},{"containerName":"_render_target_tags","name":"$feat","line":979,"kind":13},{"name":"get_tag_values","containerName":"_render_target_tags","kind":12,"line":979},{"name":"$self","containerName":"_render_target_tags","kind":13,"line":980},{"containerName":"_render_target_tags","name":"_seq_relationship","kind":12,"line":980},{"line":981,"kind":12,"name":"new","containerName":"_render_target_tags"},{"kind":13,"line":981,"name":"$alignment","containerName":"_render_target_tags"},{"containerName":"_render_target_tags","name":"$alignment","kind":13,"line":982},{"line":984,"kind":13,"name":"$alignment","containerName":"_render_target_tags"},{"kind":13,"line":985,"containerName":"_render_target_tags","name":"$alignment"},{"containerName":"_render_target_tags","name":"@passed_up","kind":13,"line":988},{"kind":13,"line":988,"containerName":"_render_target_tags","name":"$tag"},{"line":991,"kind":13,"name":"@passed_up","containerName":"_render_target_tags"}],"line":975,"definition":"sub","containerName":"main::","signature":{"label":"_render_target_tags($self,$feat,@tagnames)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation."},"detail":"($self,$feat,@tagnames)","name":"_render_target_tags","range":{"start":{"line":975,"character":0},"end":{"line":992,"character":9999}}},{"containerName":"Location::Simple","name":"Bio","line":981,"kind":12},{"kind":12,"children":[{"kind":13,"line":1006,"name":"$self","definition":"my","containerName":"_property","localvar":"my"},{"line":1006,"kind":13,"name":"$tag","containerName":"_property"},{"name":"$val","containerName":"_property","kind":13,"line":1006},{"localvar":"my","name":"$writer","definition":"my","containerName":"_property","line":1007,"kind":13},{"name":"$self","containerName":"_property","kind":13,"line":1007},{"name":"$val","containerName":"_property","line":1009,"kind":13},{"line":1010,"kind":13,"localvar":"my","name":"@val","definition":"my","containerName":"_property"},{"line":1010,"kind":13,"containerName":"_property","name":"$val"},{"kind":13,"line":1011,"containerName":"_property","name":"$val"},{"line":1013,"kind":13,"localvar":"my","containerName":"_property","definition":"my","name":"$word"},{"containerName":"_property","name":"@val","kind":13,"line":1013},{"localvar":"my","containerName":"_property","name":"$lastline","definition":"my","line":1014,"kind":13},{"line":1014,"kind":13,"name":"$val","containerName":"_property"},{"containerName":"_property","name":"$lastline","kind":13,"line":1015},{"line":1016,"kind":13,"name":"$val","containerName":"_property"},{"kind":13,"line":1016,"name":"$lastline","containerName":"_property"},{"kind":13,"line":1018,"name":"$val","containerName":"_property"},{"containerName":"_property","name":"$val","kind":13,"line":1019},{"line":1021,"kind":13,"name":"$writer","containerName":"_property"},{"line":1021,"kind":12,"name":"startTag","containerName":"_property"},{"containerName":"_property","name":"$self","kind":13,"line":1022},{"kind":12,"line":1022,"containerName":"_property","name":"_element"},{"line":1022,"kind":13,"containerName":"_property","name":"$tag"},{"containerName":"_property","name":"$self","line":1023,"kind":13},{"kind":12,"line":1023,"containerName":"_property","name":"_element"},{"name":"$val","containerName":"_property","kind":13,"line":1023},{"kind":13,"line":1024,"containerName":"_property","name":"$writer"},{"kind":12,"line":1024,"containerName":"_property","name":"endTag"}],"line":1005,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$val"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair","label":"_property($self,$tag,$val)"},"detail":"($self,$tag,$val)","name":"_property","range":{"end":{"character":9999,"line":1025},"start":{"line":1005,"character":0}}},{"kind":12,"line":1007,"name":"writer"},{"signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings","label":"_unflatten_attribute($self,$name,$val)"},"detail":"($self,$name,$val)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1038,"containerName":"_unflatten_attribute","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1038,"name":"$name","containerName":"_unflatten_attribute"},{"line":1038,"kind":13,"name":"$val","containerName":"_unflatten_attribute"},{"line":1039,"kind":13,"localvar":"my","definition":"my","name":"$writer","containerName":"_unflatten_attribute"},{"name":"$self","containerName":"_unflatten_attribute","line":1039,"kind":13},{"localvar":"my","definition":"my","name":"%pair","containerName":"_unflatten_attribute","line":1040,"kind":13},{"localvar":"my","name":"@pairs","definition":"my","containerName":"_unflatten_attribute","line":1041,"kind":13},{"kind":13,"line":1041,"containerName":"_unflatten_attribute","name":"$val"},{"line":1042,"kind":13,"localvar":"my","definition":"my","name":"$p","containerName":"_unflatten_attribute"},{"kind":13,"line":1042,"name":"@pairs","containerName":"_unflatten_attribute"},{"kind":13,"line":1043,"containerName":"_unflatten_attribute","name":"@pair","definition":"my","localvar":"my"},{"containerName":"_unflatten_attribute","name":"$p","kind":13,"line":1043},{"name":"$pair","containerName":"_unflatten_attribute","kind":13,"line":1044},{"line":1045,"kind":13,"containerName":"_unflatten_attribute","name":"$pair"},{"line":1046,"kind":13,"containerName":"_unflatten_attribute","name":"$pair"},{"line":1046,"kind":13,"name":"$pair","containerName":"_unflatten_attribute"},{"kind":13,"line":1046,"name":"$pair","containerName":"_unflatten_attribute"},{"line":1048,"kind":13,"containerName":"_unflatten_attribute","name":"$writer"},{"kind":12,"line":1048,"name":"startTag","containerName":"_unflatten_attribute"},{"kind":13,"line":1048,"containerName":"_unflatten_attribute","name":"$name"},{"containerName":"_unflatten_attribute","name":"%pair","kind":13,"line":1049},{"line":1050,"kind":13,"name":"$self","containerName":"_unflatten_attribute"},{"kind":12,"line":1050,"containerName":"_unflatten_attribute","name":"_element"},{"containerName":"_unflatten_attribute","name":"$pair","line":1050,"kind":13},{"name":"$writer","containerName":"_unflatten_attribute","kind":13,"line":1052},{"containerName":"_unflatten_attribute","name":"endTag","line":1052,"kind":12},{"name":"$name","containerName":"_unflatten_attribute","line":1052,"kind":13}],"line":1037,"kind":12,"range":{"end":{"character":9999,"line":1055},"start":{"line":1037,"character":0}},"name":"_unflatten_attribute"},{"name":"writer","kind":12,"line":1039},{"containerName":"main::","definition":"sub","detail":"($self,@xrefs)","signature":{"label":"_xref($self,@xrefs)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings","parameters":[{"label":"$self"},{"label":"@xrefs"}]},"kind":12,"line":1067,"children":[{"kind":13,"line":1068,"containerName":"_xref","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":1068,"containerName":"_xref","name":"@xrefs"},{"name":"$writer","definition":"my","containerName":"_xref","localvar":"my","kind":13,"line":1069},{"containerName":"_xref","name":"$self","kind":13,"line":1069},{"kind":13,"line":1070,"definition":"my","name":"$xref","containerName":"_xref","localvar":"my"},{"kind":13,"line":1070,"containerName":"_xref","name":"@xrefs"},{"line":1071,"kind":13,"localvar":"my","name":"$db","definition":"my","containerName":"_xref"},{"kind":13,"line":1071,"containerName":"_xref","name":"$acc"},{"kind":13,"line":1071,"containerName":"_xref","name":"$xref"},{"containerName":"_xref","name":"$writer","kind":13,"line":1072},{"name":"startTag","containerName":"_xref","kind":12,"line":1072},{"line":1073,"kind":13,"containerName":"_xref","name":"$self"},{"name":"_element","containerName":"_xref","kind":12,"line":1073},{"kind":13,"line":1073,"containerName":"_xref","name":"$db"},{"line":1074,"kind":13,"name":"$acc","containerName":"_xref"},{"line":1074,"kind":13,"name":"$xref","containerName":"_xref"},{"kind":13,"line":1074,"name":"$db","containerName":"_xref"},{"containerName":"_xref","name":"$self","kind":13,"line":1075},{"kind":12,"line":1075,"containerName":"_xref","name":"_element"},{"containerName":"_xref","name":"$acc","kind":13,"line":1075},{"kind":13,"line":1076,"name":"$writer","containerName":"_xref"},{"kind":12,"line":1076,"containerName":"_xref","name":"endTag"}],"name":"_xref","range":{"end":{"character":9999,"line":1078},"start":{"character":0,"line":1067}}},{"name":"writer","line":1069,"kind":12},{"range":{"end":{"character":9999,"line":1107},"start":{"line":1091,"character":0}},"name":"_feature_span","children":[{"line":1092,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_feature_span"},{"name":"$name","containerName":"_feature_span","line":1092,"kind":13},{"kind":13,"line":1092,"containerName":"_feature_span","name":"$feat"},{"kind":13,"line":1092,"containerName":"_feature_span","name":"$pname"},{"containerName":"_feature_span","name":"$type","definition":"my","localvar":"my","kind":13,"line":1093},{"containerName":"_feature_span","name":"$feat","line":1093,"kind":13},{"containerName":"_feature_span","name":"primary_tag","line":1093,"kind":12},{"localvar":"my","containerName":"_feature_span","name":"$writer","definition":"my","line":1094,"kind":13},{"name":"$self","containerName":"_feature_span","line":1094,"kind":13},{"line":1095,"kind":13,"localvar":"my","definition":"my","name":"%atts","containerName":"_feature_span"},{"name":"$name","containerName":"_feature_span","kind":13,"line":1095},{"kind":13,"line":1097,"name":"$pname","containerName":"_feature_span"},{"line":1098,"kind":13,"containerName":"_feature_span","name":"$pname"},{"kind":13,"line":1099,"containerName":"_feature_span","name":"$atts"},{"containerName":"_feature_span","name":"$pname","line":1099,"kind":13},{"kind":13,"line":1102,"containerName":"_feature_span","name":"$writer"},{"line":1102,"kind":12,"containerName":"_feature_span","name":"startTag"},{"line":1102,"kind":13,"containerName":"_feature_span","name":"%atts"},{"kind":13,"line":1103,"name":"$self","containerName":"_feature_span"},{"containerName":"_feature_span","name":"_element","kind":12,"line":1103},{"kind":13,"line":1103,"containerName":"_feature_span","name":"$name"},{"name":"$self","containerName":"_feature_span","kind":13,"line":1104},{"line":1104,"kind":12,"name":"_element","containerName":"_feature_span"},{"containerName":"_feature_span","name":"$type","kind":13,"line":1104},{"kind":13,"line":1105,"name":"$self","containerName":"_feature_span"},{"line":1105,"kind":12,"name":"_seq_relationship","containerName":"_feature_span"},{"line":1105,"kind":13,"containerName":"_feature_span","name":"$feat"},{"name":"$writer","containerName":"_feature_span","line":1106,"kind":13},{"line":1106,"kind":12,"containerName":"_feature_span","name":"endTag"}],"line":1091,"kind":12,"signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$feat"},{"label":"$pname"}],"label":"_feature_span($self,$name,$feat,$pname)"},"detail":"($self,$name,$feat,$pname)","definition":"sub","containerName":"main::"},{"kind":12,"line":1094,"name":"writer"},{"line":1095,"kind":12,"name":"id"},{"kind":12,"line":1099,"name":"produces_seq"},{"kind":12,"line":1121,"children":[{"line":1122,"kind":13,"localvar":"my","containerName":"_seq_relationship","definition":"my","name":"$self"},{"name":"$type","containerName":"_seq_relationship","line":1122,"kind":13},{"line":1122,"kind":13,"containerName":"_seq_relationship","name":"$loc"},{"line":1122,"kind":13,"name":"$seqname","containerName":"_seq_relationship"},{"containerName":"_seq_relationship","name":"$alignment","kind":13,"line":1122},{"kind":13,"line":1123,"containerName":"_seq_relationship","name":"$writer","definition":"my","localvar":"my"},{"line":1123,"kind":13,"name":"$self","containerName":"_seq_relationship"},{"name":"$seqname","containerName":"_seq_relationship","kind":13,"line":1125},{"kind":13,"line":1126,"containerName":"_seq_relationship","name":"$self"},{"kind":12,"line":1126,"name":"accession_number","containerName":"_seq_relationship"},{"name":"$self","containerName":"_seq_relationship","line":1126,"kind":13},{"kind":12,"line":1127,"name":"accession_number","containerName":"_seq_relationship"},{"containerName":"_seq_relationship","name":"$self","kind":13,"line":1127},{"kind":12,"line":1127,"name":"display_id","containerName":"_seq_relationship"},{"name":"$writer","containerName":"_seq_relationship","line":1128,"kind":13},{"line":1128,"kind":12,"containerName":"_seq_relationship","name":"startTag"},{"line":1130,"kind":13,"name":"$type","containerName":"_seq_relationship"},{"kind":13,"line":1131,"name":"$seqname","containerName":"_seq_relationship"},{"containerName":"_seq_relationship","name":"$self","line":1133,"kind":13},{"containerName":"_seq_relationship","name":"_span","line":1133,"kind":12},{"containerName":"_seq_relationship","name":"$loc","kind":13,"line":1133},{"kind":13,"line":1134,"containerName":"_seq_relationship","name":"$writer"},{"containerName":"_seq_relationship","name":"_element","line":1134,"kind":12},{"containerName":"_seq_relationship","name":"$alignment","line":1134,"kind":13},{"containerName":"_seq_relationship","name":"$alignment","line":1134,"kind":13},{"line":1135,"kind":13,"containerName":"_seq_relationship","name":"$writer"},{"containerName":"_seq_relationship","name":"endTag","line":1135,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$type,$loc,$seqname,$alignment)","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$loc"},{"label":"$seqname"},{"label":"$alignment"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string","label":"_seq_relationship($self,$type,$loc,$seqname,$alignment)"},"name":"_seq_relationship","range":{"end":{"line":1136,"character":9999},"start":{"line":1121,"character":0}}},{"kind":12,"line":1126,"name":"seq"},{"kind":12,"line":1126,"name":"seq"},{"name":"seq","kind":12,"line":1127},{"name":"type","kind":12,"line":1130},{"line":1131,"kind":12,"name":"seq"},{"detail":"($self,$name,$chars,$atts)","signature":{"label":"_element($self,$name,$chars,$atts)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$chars"},{"label":"$atts"}]},"containerName":"main::","definition":"sub","line":1154,"children":[{"kind":13,"line":1155,"name":"$self","definition":"my","containerName":"_element","localvar":"my"},{"line":1155,"kind":13,"containerName":"_element","name":"$name"},{"line":1155,"kind":13,"name":"$chars","containerName":"_element"},{"name":"$atts","containerName":"_element","kind":13,"line":1155},{"line":1156,"kind":13,"localvar":"my","definition":"my","name":"$writer","containerName":"_element"},{"name":"$self","containerName":"_element","kind":13,"line":1156},{"definition":"my","name":"%atts","containerName":"_element","localvar":"my","kind":13,"line":1157},{"kind":13,"line":1157,"name":"$atts","containerName":"_element"},{"name":"$atts","containerName":"_element","kind":13,"line":1157},{"line":1159,"kind":13,"name":"$writer","containerName":"_element"},{"name":"startTag","containerName":"_element","line":1159,"kind":12},{"containerName":"_element","name":"$name","kind":13,"line":1159},{"kind":13,"line":1159,"containerName":"_element","name":"%atts"},{"line":1160,"kind":13,"containerName":"_element","name":"$writer"},{"name":"characters","containerName":"_element","line":1160,"kind":12},{"line":1160,"kind":13,"containerName":"_element","name":"$chars"},{"containerName":"_element","name":"$writer","line":1161,"kind":13},{"line":1161,"kind":12,"name":"endTag","containerName":"_element"},{"containerName":"_element","name":"$name","line":1161,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":1162},"start":{"line":1154,"character":0}},"name":"_element"},{"name":"writer","line":1156,"kind":12},{"detail":"($self,@loc)","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object","parameters":[{"label":"$self"},{"label":"@loc"}],"label":"_span($self,@loc)"},"containerName":"main::","definition":"sub","line":1174,"children":[{"kind":13,"line":1175,"definition":"my","name":"$self","containerName":"_span","localvar":"my"},{"kind":13,"line":1175,"name":"@loc","containerName":"_span"},{"kind":13,"line":1176,"containerName":"_span","definition":"my","name":"$loc","localvar":"my"},{"kind":13,"line":1176,"name":"$start","containerName":"_span"},{"line":1176,"kind":13,"containerName":"_span","name":"$end"},{"kind":13,"line":1178,"name":"@loc","containerName":"_span"},{"line":1179,"kind":13,"containerName":"_span","name":"$loc"},{"line":1179,"kind":13,"containerName":"_span","name":"$loc"},{"line":1181,"kind":13,"name":"@loc","containerName":"_span"},{"line":1182,"kind":13,"name":"$start","containerName":"_span"},{"kind":13,"line":1182,"containerName":"_span","name":"$end"},{"line":1182,"kind":13,"name":"@loc","containerName":"_span"},{"line":1185,"kind":13,"name":"$loc","containerName":"_span"},{"kind":13,"line":1186,"containerName":"_span","name":"$start"},{"containerName":"_span","name":"$end","kind":13,"line":1186},{"containerName":"_span","name":"$loc","line":1186,"kind":13},{"line":1186,"kind":12,"containerName":"_span","name":"start"},{"kind":13,"line":1186,"containerName":"_span","name":"$loc"},{"name":"end","containerName":"_span","line":1186,"kind":12},{"containerName":"_span","name":"$start","line":1187,"kind":13},{"line":1187,"kind":13,"name":"$end","containerName":"_span"},{"kind":13,"line":1187,"containerName":"_span","name":"$end"},{"name":"$start","containerName":"_span","line":1187,"kind":13},{"kind":13,"line":1187,"name":"$loc","containerName":"_span"},{"kind":12,"line":1187,"containerName":"_span","name":"strand"},{"line":1189,"kind":13,"containerName":"_span","name":"$start"},{"kind":13,"line":1190,"name":"$start","containerName":"_span"},{"containerName":"_span","name":"$end","kind":13,"line":1190},{"name":"$self","containerName":"_span","line":1190,"kind":13},{"name":"length","containerName":"_span","line":1190,"kind":12},{"kind":13,"line":1193,"containerName":"_span","name":"$writer","definition":"my","localvar":"my"},{"kind":13,"line":1193,"name":"$self","containerName":"_span"},{"kind":13,"line":1194,"name":"$writer","containerName":"_span"},{"line":1194,"kind":12,"containerName":"_span","name":"startTag"},{"line":1195,"kind":13,"name":"$self","containerName":"_span"},{"kind":12,"line":1195,"containerName":"_span","name":"_element"},{"kind":13,"line":1195,"containerName":"_span","name":"$start"},{"containerName":"_span","name":"$self","line":1196,"kind":13},{"name":"_element","containerName":"_span","kind":12,"line":1196},{"line":1196,"kind":13,"name":"$end","containerName":"_span"},{"name":"$writer","containerName":"_span","line":1197,"kind":13},{"line":1197,"kind":12,"name":"endTag","containerName":"_span"}],"kind":12,"range":{"end":{"line":1198,"character":9999},"start":{"line":1174,"character":0}},"name":"_span"},{"name":"seq","kind":12,"line":1190},{"name":"writer","kind":12,"line":1193},{"signature":{"label":"_seq($self,$seq,$atts)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object\n\n\nsub _span {\n    my ($self, @loc) = @_;\n    my ($loc, $start, $end);\n\n    if ( @loc == 1 ) {\n\t$loc = $loc[0];\n    }\n    elsif ( @loc == 2 ) {\n\t($start, $end) = @loc;\n    }\n\n    if ( $loc ) {\n\t($start, $end) = ($loc->start, $loc->end);\n\t($start, $end) = ($end, $start) if $loc->strand < 0;\n    } \n    elsif ( !$start ) {\n\t($start, $end) = (1, $self->{seq}->length);\n    }\n    \n    my $writer = $self->{writer};\n    $writer->startTag('span');\n    $self->_element('start', $start);\n    $self->_element('end', $end);\n    $writer->endTag('span');\n}\n\n=head2 _seq\n\n Title   : _seq\n Usage   : $self->_seq($seq, $dna) \n Function: an internal method to print the 'sequence' element\n Returns : nothing\n Args    : and Bio::SeqI-compliant object and a reference to an attribute  hash","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$atts"}]},"detail":"($self,$seq,$atts)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_seq","localvar":"my","kind":13,"line":1211},{"kind":13,"line":1211,"containerName":"_seq","name":"$seq"},{"line":1211,"kind":13,"name":"$atts","containerName":"_seq"},{"line":1213,"kind":13,"localvar":"my","definition":"my","name":"$writer","containerName":"_seq"},{"line":1213,"kind":13,"containerName":"_seq","name":"$self"},{"kind":13,"line":1217,"name":"$alphabet","definition":"my","containerName":"_seq","localvar":"my"},{"name":"$seq","containerName":"_seq","kind":13,"line":1217},{"kind":12,"line":1217,"containerName":"_seq","name":"alphabet"},{"kind":13,"line":1218,"containerName":"_seq","name":"$alphabet"},{"line":1218,"kind":13,"name":"$seq","containerName":"_seq"},{"line":1218,"kind":12,"name":"mol_type","containerName":"_seq"},{"name":"$seq","containerName":"_seq","kind":13,"line":1218},{"line":1218,"kind":12,"name":"can","containerName":"_seq"},{"containerName":"_seq","name":"$alphabet","kind":13,"line":1219},{"name":"$alphabet","containerName":"_seq","kind":13,"line":1220},{"containerName":"_seq","definition":"my","name":"@seq","localvar":"my","kind":13,"line":1222},{"containerName":"_seq","name":"$atts","line":1223,"kind":13},{"kind":13,"line":1224,"name":"$seq","containerName":"_seq"},{"name":"length","containerName":"_seq","line":1224,"kind":12},{"kind":13,"line":1225,"containerName":"_seq","name":"$alphabet"},{"containerName":"_seq","name":"$atts","kind":13,"line":1229},{"containerName":"_seq","name":"@seq","kind":13,"line":1230},{"line":1230,"kind":13,"containerName":"_seq","name":"$atts"},{"name":"$atts","containerName":"_seq","kind":13,"line":1231},{"containerName":"_seq","name":"$writer","line":1233,"kind":13},{"name":"startTag","containerName":"_seq","line":1233,"kind":12},{"kind":13,"line":1233,"name":"@seq","containerName":"_seq"},{"localvar":"my","containerName":"_seq","name":"$k","definition":"my","line":1235,"kind":13},{"name":"$atts","containerName":"_seq","line":1235,"kind":13}],"line":1210,"kind":12,"range":{"start":{"character":0,"line":1210},"end":{"character":9999,"line":1235}},"name":"_seq"},{"name":"id","line":1223,"kind":12},{"name":"name","line":1223,"kind":12},{"name":"length","kind":12,"line":1224},{"name":"type","line":1225,"kind":12},{"name":"focus","kind":12,"line":1226},{"line":1229,"kind":12,"name":"md5checksum"},{"name":"md5checksum","kind":12,"line":1230},{"name":"md5checksum","line":1230,"kind":12},{"kind":12,"line":1231,"name":"md5checksum"},{"line":1236,"kind":13,"containerName":null,"name":"%k"},{"name":"$self","containerName":null,"line":1237,"kind":13},{"line":1237,"kind":12,"name":"_xref","containerName":"main::"},{"name":"%atts","containerName":null,"line":1237,"kind":13},{"containerName":null,"name":"%k","kind":13,"line":1237},{"kind":13,"line":1240,"name":"$self","containerName":null},{"containerName":"main::","name":"_element","kind":12,"line":1240},{"line":1240,"kind":13,"name":"$k","containerName":null},{"name":"%atts","containerName":null,"kind":13,"line":1240},{"name":"$k","containerName":null,"kind":13,"line":1240},{"localvar":"my","containerName":null,"name":"$sp","definition":"my","line":1246,"kind":13},{"kind":13,"line":1247,"containerName":null,"name":"$dna","definition":"my","localvar":"my"},{"containerName":null,"name":"$seq","kind":13,"line":1247},{"containerName":"main::","name":"seq","line":1247,"kind":12},{"line":1248,"kind":13,"containerName":null,"name":"$dna"},{"containerName":null,"name":"$dna","kind":13,"line":1249},{"containerName":null,"name":"$dna","line":1249,"kind":13},{"name":"$seq","containerName":null,"line":1251,"kind":13},{"name":"species","containerName":"main::","line":1251,"kind":12},{"line":1251,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":1251,"name":"has_organism"},{"kind":13,"line":1252,"definition":"my","name":"$species","containerName":null,"localvar":"my"},{"line":1252,"kind":13,"containerName":null,"name":"$seq"},{"containerName":"main::","name":"species","line":1252,"kind":12},{"containerName":"main::","name":"binomial","line":1252,"kind":12},{"kind":13,"line":1253,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_element","kind":12,"line":1253},{"line":1253,"kind":13,"containerName":null,"name":"$species"},{"line":1256,"kind":13,"name":"$self","containerName":null},{"line":1256,"kind":12,"containerName":"main::","name":"_element"},{"line":1256,"kind":13,"name":"$dna","containerName":null},{"kind":13,"line":1257,"containerName":null,"name":"$writer"},{"containerName":"main::","name":"endTag","kind":12,"line":1257},{"name":"_find_name","range":{"end":{"character":9999,"line":1282},"start":{"character":0,"line":1270}},"containerName":"main::","definition":"sub","detail":"($self,$feat,$key)","signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$key"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object\n\n\nsub _span {\n    my ($self, @loc) = @_;\n    my ($loc, $start, $end);\n\n    if ( @loc == 1 ) {\n\t$loc = $loc[0];\n    }\n    elsif ( @loc == 2 ) {\n\t($start, $end) = @loc;\n    }\n\n    if ( $loc ) {\n\t($start, $end) = ($loc->start, $loc->end);\n\t($start, $end) = ($end, $start) if $loc->strand < 0;\n    } \n    elsif ( !$start ) {\n\t($start, $end) = (1, $self->{seq}->length);\n    }\n    \n    my $writer = $self->{writer};\n    $writer->startTag('span');\n    $self->_element('start', $start);\n    $self->_element('end', $end);\n    $writer->endTag('span');\n}\n\n=head2 _seq\n\n Title   : _seq\n Usage   : $self->_seq($seq, $dna) \n Function: an internal method to print the 'sequence' element\n Returns : nothing\n Args    : and Bio::SeqI-compliant object and a reference to an attribute  hash\n\n\nsub _seq {\n    my ($self, $seq, $atts) = @_;\n\n    my $writer = $self->{'writer'};\n\n   \n    # game moltypes\n    my $alphabet = $seq->alphabet;\n    $alphabet ||= $seq->mol_type if $seq->can('mol_type');\n    $alphabet =~ s/protein/aa/;\n    $alphabet =~ s/rna/cdna/;\n    \n    my @seq = ( 'seq',\n\t\tid     => $atts->{name},\n\t\tlength => $seq->length,\n\t\ttype   => $alphabet,\n\t       \tfocus  => \"true\"\t       \n\t      );\n\n    if ( $atts->{md5checksum} ) {\n\tpush @seq, (md5checksum => $atts->{md5checksum});\n\tdelete $atts->{md5checksum};\n    }\n    $writer->startTag(@seq);\n\n    for my $k ( keys %{$atts} ) {\n\tif ( $k =~ /xref/ ) {\n\t    $self->_xref($atts->{$k});\n\t}\n\telse {\n\t    $self->_element($k, $atts->{$k});\n\t}    \n    }\n    \n    # add leading spaces and line breaks for \n    # nicer xml formatting/indentation\n    my $sp  = (' ' x 6);\n    my $dna = $seq->seq;\n    $dna =~ s/(\\w{60})/$1\\n$sp/g;\n    $dna = \"\\n$sp\" . $dna . \"\\n    \";\n    \n    if ( $seq->species && !$self->{has_organism}) {\n        my $species = $seq->species->binomial;\n\t$self->_element('organism', $species);\n    }\n    \n    $self->_element('residues', $dna);\n    $writer->endTag('seq');\n}\n\n=head2 _find_name\n\n Title   : _find_name\n Usage   : my $name = $self->_find_name($feature)\n Function: an internal method to look for a gene name\n Returns : a string \n Args    : a Bio::SeqFeatureI-compliant object","label":"_find_name($self,$feat,$key)"},"kind":12,"line":1270,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_find_name","line":1271,"kind":13},{"name":"$feat","containerName":"_find_name","kind":13,"line":1271},{"name":"$key","containerName":"_find_name","kind":13,"line":1271},{"line":1272,"kind":13,"localvar":"my","containerName":"_find_name","definition":"my","name":"$name"},{"containerName":"_find_name","name":"$key","kind":13,"line":1274},{"line":1274,"kind":13,"containerName":"_find_name","name":"$feat"},{"name":"has_tag","containerName":"_find_name","line":1274,"kind":12},{"name":"$key","containerName":"_find_name","line":1274,"kind":13},{"line":1275,"kind":13,"name":"$name","containerName":"_find_name"},{"name":"$feat","containerName":"_find_name","kind":13,"line":1275},{"line":1275,"kind":12,"containerName":"_find_name","name":"get_tag_values"},{"line":1275,"kind":13,"name":"$key","containerName":"_find_name"},{"kind":13,"line":1276,"containerName":"_find_name","name":"$name"}]}]}