{"version":5,"vars":[{"containerName":"","name":"vars","line":79,"kind":2},{"containerName":null,"name":"$dumper","definition":"my","localvar":"my","kind":13,"line":86},{"containerName":"","name":"Dumpvalue","kind":2,"line":86},{"name":"new","line":86,"kind":12},{"name":"Dumpvalue","line":86,"kind":12},{"name":"$dumper","containerName":null,"line":87,"kind":13},{"kind":12,"line":87,"containerName":"main::","name":"veryCompact"},{"containerName":null,"name":"$DEFAULT_QUALITY","kind":13,"line":90},{"name":"base","containerName":"","kind":2,"line":93},{"range":{"end":{"line":104,"character":9999},"start":{"character":0,"line":95}},"name":"_initialize","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":96,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"@args","line":96,"kind":13},{"kind":13,"line":97,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"@args","line":97,"kind":13},{"containerName":"_initialize","name":"$self","line":98,"kind":13},{"name":"sequence_factory","containerName":"_initialize","kind":12,"line":98},{"line":99,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"sequence_factory","containerName":"_initialize","line":99,"kind":12},{"containerName":"_initialize","name":"new","line":100,"kind":12},{"kind":13,"line":100,"name":"$self","containerName":"_initialize"},{"kind":12,"line":100,"containerName":"_initialize","name":"verbose"},{"name":"$self","containerName":"_initialize","kind":13,"line":103},{"containerName":"_initialize","name":"_fh","kind":12,"line":103}],"line":95,"kind":12},{"line":97,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":99,"kind":12,"containerName":"Seq::SeqFactory","name":"Bio"},{"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n'","parameters":[{"label":"$self"}],"label":"next_seq($self)"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":125,"name":"$self","definition":"my","containerName":"next_seq","localvar":"my"},{"containerName":"next_seq","definition":"my","name":"$seq","localvar":"my","kind":13,"line":126},{"containerName":"next_seq","name":"$seqc","line":126,"kind":13},{"name":"$fh","containerName":"next_seq","kind":13,"line":126},{"kind":13,"line":126,"containerName":"next_seq","name":"$buffer"},{"line":126,"kind":13,"name":"$offset","containerName":"next_seq"},{"line":126,"kind":13,"containerName":"next_seq","name":"$length"},{"name":"$read_bytes","containerName":"next_seq","line":126,"kind":13},{"kind":13,"line":126,"containerName":"next_seq","name":"@read"},{"name":"%names","containerName":"next_seq","line":127,"kind":13},{"name":"$self","containerName":"next_seq","kind":13,"line":129},{"containerName":"next_seq","name":"$fh","kind":13,"line":130},{"name":"$self","containerName":"next_seq","line":130,"kind":13},{"kind":12,"line":130,"name":"_fh","containerName":"next_seq"},{"kind":13,"line":131,"containerName":"next_seq","name":"$fh"},{"kind":13,"line":133,"containerName":"next_seq","name":"$ARGV","definition":"my","localvar":"my"},{"kind":13,"line":134,"name":"$ARGV","containerName":"next_seq"},{"line":135,"kind":13,"name":"$self","containerName":"next_seq"},{"line":135,"kind":12,"containerName":"next_seq","name":"throw"},{"containerName":"next_seq","name":"$fh","kind":13,"line":137},{"containerName":"next_seq","name":"$fh","kind":13,"line":139},{"line":139,"kind":13,"name":"$buffer","containerName":"next_seq"},{"name":"$creator","definition":"my","containerName":"next_seq","localvar":"my","kind":13,"line":141},{"kind":13,"line":147,"name":"$creator","containerName":"next_seq"},{"kind":13,"line":147,"name":"$self","containerName":"next_seq"},{"line":147,"kind":12,"containerName":"next_seq","name":"_get_header"},{"kind":13,"line":147,"name":"$buffer","containerName":"next_seq"},{"name":"$creator","containerName":"next_seq","kind":13,"line":148},{"name":"$self","containerName":"next_seq","line":149,"kind":13},{"name":"debug","containerName":"next_seq","line":149,"kind":12},{"containerName":"next_seq","name":"$length","line":151,"kind":13},{"kind":13,"line":151,"containerName":"next_seq","name":"$creator"},{"kind":13,"line":152,"containerName":"next_seq","name":"$creator"},{"kind":13,"line":153,"name":"$buffer","containerName":"next_seq"},{"kind":13,"line":153,"containerName":"next_seq","name":"$self"},{"name":"read_from_buffer","containerName":"next_seq","kind":12,"line":153},{"containerName":"next_seq","name":"$fh","line":153,"kind":13},{"line":153,"kind":13,"containerName":"next_seq","name":"$buffer"},{"line":153,"kind":13,"containerName":"next_seq","name":"$length"},{"name":"$creator","containerName":"next_seq","kind":13,"line":154},{"kind":13,"line":158,"name":"$creator","containerName":"next_seq"},{"containerName":"next_seq","name":"$self","line":158,"kind":13},{"line":158,"kind":12,"containerName":"next_seq","name":"_parse_v2_traces"},{"containerName":"next_seq","name":"$buffer","kind":13,"line":159},{"kind":13,"line":159,"name":"$creator","containerName":"next_seq"},{"line":161,"kind":13,"containerName":"next_seq","name":"$offset"},{"kind":13,"line":161,"containerName":"next_seq","name":"$creator"},{"name":"$length","containerName":"next_seq","kind":13,"line":162},{"name":"$creator","containerName":"next_seq","line":162,"kind":13},{"line":163,"kind":13,"containerName":"next_seq","name":"$fh"},{"name":"$offset","containerName":"next_seq","kind":13,"line":163},{"line":164,"kind":13,"name":"$buffer","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","line":164,"kind":13},{"containerName":"next_seq","name":"read_from_buffer","line":164,"kind":12},{"line":164,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":164,"kind":13,"name":"$buffer","containerName":"next_seq"},{"line":164,"kind":13,"name":"$length","containerName":"next_seq"},{"containerName":"next_seq","name":"$creator","kind":13,"line":164},{"containerName":"next_seq","name":"$creator","line":168,"kind":13},{"name":"$creator","containerName":"next_seq","line":169,"kind":13},{"kind":13,"line":170,"containerName":"next_seq","name":"$creator"},{"containerName":"next_seq","name":"$creator","line":171,"kind":13},{"containerName":"next_seq","name":"$self","kind":13,"line":171},{"line":171,"kind":12,"containerName":"next_seq","name":"_parse_v2_bases"},{"containerName":"next_seq","name":"$buffer","line":171,"kind":13},{"line":174,"kind":13,"containerName":"next_seq","name":"$self"},{"containerName":"next_seq","name":"debug","line":174,"kind":12},{"name":"$transformed_read","definition":"my","containerName":"next_seq","localvar":"my","kind":13,"line":175},{"line":176,"kind":13,"localvar":"my","name":"$current_read_position","definition":"my","containerName":"next_seq"},{"name":"$creator","containerName":"next_seq","kind":13,"line":176},{"containerName":"next_seq","name":"$length","kind":13,"line":177},{"line":177,"kind":13,"containerName":"next_seq","name":"$creator"},{"kind":13,"line":178,"containerName":"next_seq","name":"$creator"},{"containerName":"next_seq","name":"$buffer","kind":13,"line":181},{"containerName":"next_seq","name":"$self","line":181,"kind":13},{"line":181,"kind":12,"containerName":"next_seq","name":"read_from_buffer"},{"containerName":"next_seq","name":"$fh","line":181,"kind":13},{"containerName":"next_seq","name":"$buffer","line":181,"kind":13},{"containerName":"next_seq","name":"$length","line":181,"kind":13},{"containerName":"next_seq","name":"$current_read_position","line":181,"kind":13},{"definition":"my","name":"$byte","containerName":"next_seq","localvar":"my","kind":13,"line":182},{"name":"$creator","containerName":"next_seq","kind":13,"line":183},{"kind":13,"line":184,"containerName":"next_seq","name":"$byte"},{"line":186,"kind":13,"name":"@read","containerName":"next_seq"},{"containerName":"next_seq","name":"$buffer","line":186,"kind":13},{"containerName":"next_seq","name":"@read","line":195,"kind":13},{"containerName":"next_seq","name":"$transformed_read","line":200,"kind":13},{"line":200,"kind":13,"containerName":"next_seq","name":"$self"},{"containerName":"next_seq","name":"_delta","line":200,"kind":12},{"kind":13,"line":200,"containerName":"next_seq","name":"@read"},{"name":"$creator","containerName":"next_seq","kind":13,"line":203},{"containerName":"next_seq","name":"$transformed_read","kind":13,"line":204},{"name":"$current_read_position","containerName":"next_seq","line":208,"kind":13},{"containerName":"next_seq","name":"$length","kind":13,"line":208},{"kind":13,"line":209,"name":"$creator","containerName":"next_seq"},{"kind":13,"line":209,"name":"$transformed_read","containerName":"next_seq"}],"line":124,"name":"next_seq","range":{"start":{"line":124,"character":0},"end":{"line":210,"character":9999}}},{"name":"_readfile","kind":12,"line":129},{"line":132,"kind":12,"name":"ARGV"},{"line":132,"kind":12,"name":"ARGV"},{"kind":12,"line":134,"name":"ARGV"},{"line":147,"kind":12,"name":"header"},{"kind":12,"line":148,"name":"header"},{"kind":12,"line":151,"name":"header"},{"name":"header","kind":12,"line":152},{"kind":12,"line":152,"name":"sample_size"},{"kind":12,"line":154,"name":"header"},{"name":"samples_offset","line":154,"kind":12},{"line":158,"kind":12,"name":"traces"},{"line":159,"kind":12,"name":"header"},{"name":"sample_size","kind":12,"line":159},{"kind":12,"line":161,"name":"header"},{"kind":12,"line":161,"name":"bases_offset"},{"name":"header","line":162,"kind":12},{"line":162,"kind":12,"name":"bases"},{"name":"header","kind":12,"line":164},{"line":164,"kind":12,"name":"bases_offset"},{"name":"peak_indices","kind":12,"line":168},{"line":169,"kind":12,"name":"qualities"},{"name":"sequence","line":170,"kind":12},{"name":"accuracies","line":171,"kind":12},{"line":176,"kind":12,"name":"header"},{"name":"sample_offset","kind":12,"line":176},{"name":"header","kind":12,"line":177},{"name":"header","line":178,"kind":12},{"name":"sample_size","kind":12,"line":178},{"name":"header","kind":12,"line":183},{"name":"sample_size","kind":12,"line":183},{"kind":12,"line":203,"name":"header"},{"name":"sample_size","kind":12,"line":203},{"line":213,"kind":13,"containerName":null,"name":"$offset"},{"name":"%creator","containerName":null,"kind":13,"line":213},{"name":"header","line":213,"kind":12},{"name":"bases_offset","kind":12,"line":213},{"kind":13,"line":214,"containerName":null,"name":"$length"},{"containerName":null,"name":"%creator","kind":13,"line":214},{"name":"header","kind":12,"line":214},{"name":"bases","kind":12,"line":214},{"line":215,"kind":13,"containerName":null,"name":"$buffer"},{"name":"$self","containerName":null,"kind":13,"line":215},{"line":215,"kind":12,"name":"read_from_buffer","containerName":"main::"},{"name":"$fh","containerName":null,"line":215,"kind":13},{"name":"$buffer","containerName":null,"line":215,"kind":13},{"name":"$length","containerName":null,"kind":13,"line":215},{"containerName":null,"name":"$offset","kind":13,"line":215},{"kind":13,"line":216,"name":"%creator","containerName":null},{"name":"peak_indices","line":216,"kind":12},{"containerName":null,"name":"$self","line":216,"kind":13},{"kind":12,"line":216,"containerName":"main::","name":"_get_v3_peak_indices"},{"kind":13,"line":216,"containerName":null,"name":"$buffer"},{"name":"$offset","containerName":null,"line":217,"kind":13},{"containerName":null,"name":"$length","line":217,"kind":13},{"kind":13,"line":219,"containerName":null,"name":"$buffer"},{"kind":13,"line":219,"containerName":null,"name":"$self"},{"name":"read_from_buffer","containerName":"main::","kind":12,"line":219},{"kind":13,"line":219,"name":"$fh","containerName":null},{"line":219,"kind":13,"name":"$buffer","containerName":null},{"containerName":null,"name":"$length","line":219,"kind":13},{"kind":13,"line":219,"name":"$offset","containerName":null},{"kind":13,"line":220,"containerName":null,"name":"%creator"},{"kind":12,"line":220,"name":"accuracies"},{"name":"$self","containerName":null,"line":220,"kind":13},{"kind":12,"line":220,"containerName":"main::","name":"_get_v3_base_accuracies"},{"containerName":null,"name":"$buffer","kind":13,"line":220},{"kind":13,"line":222,"name":"$offset","containerName":null},{"name":"$length","containerName":null,"kind":13,"line":222},{"kind":13,"line":223,"name":"$length","containerName":null},{"kind":13,"line":223,"containerName":null,"name":"%creator"},{"kind":12,"line":223,"name":"header"},{"kind":12,"line":223,"name":"bases"},{"containerName":null,"name":"$buffer","line":224,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":224},{"containerName":"main::","name":"read_from_buffer","kind":12,"line":224},{"name":"$fh","containerName":null,"kind":13,"line":224},{"name":"$buffer","containerName":null,"line":224,"kind":13},{"containerName":null,"name":"$length","line":224,"kind":13},{"containerName":null,"name":"$offset","kind":13,"line":224},{"name":"%creator","containerName":null,"kind":13,"line":225},{"name":"$buffer","containerName":null,"kind":13,"line":225},{"name":"%creator","containerName":null,"kind":13,"line":227},{"name":"qualities","line":227,"kind":12},{"name":"$self","containerName":null,"line":227,"kind":13},{"name":"_get_v3_quality","containerName":"main::","kind":12,"line":227},{"name":"%creator","containerName":null,"kind":13,"line":228},{"kind":13,"line":228,"name":"%creator","containerName":null},{"kind":12,"line":228,"name":"accuracies"},{"containerName":null,"name":"$offset","line":231,"kind":13},{"name":"%creator","containerName":null,"kind":13,"line":231},{"name":"header","line":231,"kind":12},{"kind":12,"line":231,"name":"comments_offset"},{"kind":13,"line":232,"containerName":null,"name":"$fh"},{"containerName":null,"name":"$offset","line":232,"kind":13},{"name":"$length","containerName":null,"line":233,"kind":13},{"name":"%creator","containerName":null,"kind":13,"line":233},{"name":"header","kind":12,"line":233},{"line":233,"kind":12,"name":"comment_size"},{"name":"$buffer","containerName":null,"kind":13,"line":234},{"line":234,"kind":13,"containerName":null,"name":"$self"},{"name":"read_from_buffer","containerName":"main::","kind":12,"line":234},{"line":234,"kind":13,"name":"$fh","containerName":null},{"line":234,"kind":13,"name":"$buffer","containerName":null},{"containerName":null,"name":"$length","kind":13,"line":234},{"name":"%creator","containerName":null,"kind":13,"line":235},{"name":"comments","line":235,"kind":12},{"containerName":null,"name":"$self","line":235,"kind":13},{"containerName":"main::","name":"_get_comments","line":235,"kind":12},{"line":235,"kind":13,"name":"$buffer","containerName":null},{"line":236,"kind":13,"localvar":"my","containerName":null,"name":"@name_comments","definition":"my"},{"kind":12,"line":236,"name":"tagname","containerName":"main::"},{"kind":13,"line":237,"containerName":null,"name":"%creator"},{"line":237,"kind":12,"name":"comments"},{"containerName":"main::","name":"get_Annotations","kind":12,"line":237},{"line":238,"kind":13,"localvar":"my","containerName":null,"name":"$name_comment","definition":"my"},{"kind":13,"line":239,"name":"@name_comments","containerName":null},{"name":"$name_comment","containerName":null,"kind":13,"line":240},{"containerName":null,"name":"@name_comments","kind":13,"line":240},{"line":240,"kind":12,"name":"as_text","containerName":"main::"},{"containerName":null,"name":"$name_comment","line":241,"kind":13},{"localvar":"my","name":"$swq","definition":"my","containerName":null,"line":244,"kind":13},{"kind":12,"line":244,"name":"Bio","containerName":"Seq::Quality"},{"name":"new","containerName":"main::","kind":12,"line":244},{"name":"%creator","containerName":null,"kind":13,"line":245},{"containerName":null,"name":"%creator","line":246,"kind":13},{"name":"$name_comment","containerName":null,"line":248,"kind":13},{"line":249,"kind":13,"localvar":"my","name":"$returner","definition":"my","containerName":null},{"kind":12,"line":249,"name":"Bio","containerName":"Seq::SequenceTrace"},{"name":"new","containerName":"main::","kind":12,"line":249},{"name":"$swq","containerName":null,"line":250,"kind":13},{"kind":13,"line":251,"name":"%creator","containerName":null},{"kind":13,"line":252,"name":"%creator","containerName":null},{"kind":13,"line":253,"name":"%creator","containerName":null},{"line":254,"kind":13,"name":"%creator","containerName":null},{"name":"%creator","containerName":null,"kind":13,"line":255},{"containerName":null,"name":"%creator","line":256,"kind":13},{"containerName":null,"name":"%creator","kind":13,"line":257},{"line":258,"kind":13,"containerName":null,"name":"%creator"},{"line":259,"kind":13,"name":"%creator","containerName":null},{"kind":13,"line":262,"name":"$returner","containerName":null},{"containerName":"main::","name":"annotation","line":262,"kind":12},{"kind":13,"line":262,"containerName":null,"name":"%creator"},{"line":263,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":264,"name":"$returner","containerName":null},{"signature":{"parameters":[{"label":"$self"},{"label":"$sequence"},{"label":"$accuracies"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n'","label":"_get_v3_quality($self,$sequence,$accuracies)"},"detail":"($self,$sequence,$accuracies)","definition":"sub","containerName":"main::","children":[{"line":281,"kind":13,"localvar":"my","containerName":"_get_v3_quality","definition":"my","name":"$self"},{"kind":13,"line":281,"name":"$sequence","containerName":"_get_v3_quality"},{"containerName":"_get_v3_quality","name":"$accuracies","line":281,"kind":13},{"kind":13,"line":282,"definition":"my","name":"@bases","containerName":"_get_v3_quality","localvar":"my"},{"name":"$sequence","containerName":"_get_v3_quality","kind":13,"line":282},{"kind":13,"line":283,"containerName":"_get_v3_quality","name":"@qualities","definition":"my","localvar":"my"},{"line":283,"kind":13,"name":"$currbase","containerName":"_get_v3_quality"},{"kind":13,"line":283,"name":"$currqual","containerName":"_get_v3_quality"},{"kind":13,"line":283,"containerName":"_get_v3_quality","name":"$counter"},{"line":284,"kind":13,"containerName":"_get_v3_quality","name":"$counter"},{"line":284,"kind":13,"containerName":"_get_v3_quality","name":"$counter"},{"line":284,"kind":13,"name":"$counter","containerName":"_get_v3_quality"},{"kind":13,"line":285,"containerName":"_get_v3_quality","name":"$currbase"},{"name":"$bases","containerName":"_get_v3_quality","line":285,"kind":13},{"kind":13,"line":285,"containerName":"_get_v3_quality","name":"$counter"},{"name":"$currbase","containerName":"_get_v3_quality","line":286,"kind":13},{"name":"$currqual","containerName":"_get_v3_quality","line":286,"kind":13},{"line":286,"kind":13,"name":"$accuracies","containerName":"_get_v3_quality"},{"name":"$counter","containerName":"_get_v3_quality","line":286,"kind":13},{"line":287,"kind":13,"name":"$currbase","containerName":"_get_v3_quality"},{"kind":13,"line":287,"containerName":"_get_v3_quality","name":"$currqual"},{"line":287,"kind":13,"name":"$accuracies","containerName":"_get_v3_quality"},{"name":"$counter","containerName":"_get_v3_quality","line":287,"kind":13},{"name":"$currbase","containerName":"_get_v3_quality","line":288,"kind":13},{"line":288,"kind":13,"name":"$currqual","containerName":"_get_v3_quality"},{"line":288,"kind":13,"name":"$accuracies","containerName":"_get_v3_quality"},{"name":"$counter","containerName":"_get_v3_quality","kind":13,"line":288},{"name":"$currbase","containerName":"_get_v3_quality","kind":13,"line":289},{"name":"$currqual","containerName":"_get_v3_quality","line":289,"kind":13},{"name":"$accuracies","containerName":"_get_v3_quality","kind":13,"line":289},{"containerName":"_get_v3_quality","name":"$counter","line":289,"kind":13},{"kind":13,"line":290,"containerName":"_get_v3_quality","name":"$currqual"},{"line":291,"kind":13,"name":"@qualities","containerName":"_get_v3_quality"},{"kind":13,"line":291,"containerName":"_get_v3_quality","name":"$currqual"},{"line":293,"kind":13,"containerName":"_get_v3_quality","name":"@qualities"}],"line":280,"kind":12,"range":{"start":{"line":280,"character":0},"end":{"line":294,"character":9999}},"name":"_get_v3_quality"},{"kind":12,"line":284,"name":"bases"},{"kind":12,"line":307,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_get_v3_peak_indices","line":308,"kind":13},{"kind":13,"line":308,"containerName":"_get_v3_peak_indices","name":"$buffer"},{"line":309,"kind":13,"localvar":"my","name":"$length","definition":"my","containerName":"_get_v3_peak_indices"},{"containerName":"_get_v3_peak_indices","name":"$buffer","line":309,"kind":13},{"localvar":"my","definition":"my","name":"@read","containerName":"_get_v3_peak_indices","line":310,"kind":13},{"line":310,"kind":13,"containerName":"_get_v3_peak_indices","name":"$buffer"},{"containerName":"_get_v3_peak_indices","name":"@read","kind":13,"line":311}],"containerName":"main::","definition":"sub","detail":"($self,$buffer)","signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :","parameters":[{"label":"$self"},{"label":"$buffer"}],"label":"_get_v3_peak_indices($self,$buffer)"},"name":"_get_v3_peak_indices","range":{"end":{"line":312,"character":9999},"start":{"character":0,"line":307}}},{"signature":{"parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n'","label":"_get_v3_base_accuracies($self,$buffer)"},"detail":"($self,$buffer)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_get_v3_base_accuracies","localvar":"my","kind":13,"line":327},{"kind":13,"line":327,"containerName":"_get_v3_base_accuracies","name":"$buffer"},{"line":328,"kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","name":"$length","definition":"my"},{"line":328,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$buffer"},{"containerName":"_get_v3_base_accuracies","definition":"my","name":"$qlength","localvar":"my","kind":13,"line":329},{"containerName":"_get_v3_base_accuracies","name":"$length","kind":13,"line":329},{"line":330,"kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","definition":"my","name":"$offset"},{"line":331,"kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","definition":"my","name":"@qualities"},{"containerName":"_get_v3_base_accuracies","name":"@sorter","line":331,"kind":13},{"kind":13,"line":331,"containerName":"_get_v3_base_accuracies","name":"$counter"},{"name":"$round","containerName":"_get_v3_base_accuracies","line":331,"kind":13},{"containerName":"_get_v3_base_accuracies","name":"$last_base","line":331,"kind":13},{"name":"$accuracies","containerName":"_get_v3_base_accuracies","line":331,"kind":13},{"name":"$currbase","containerName":"_get_v3_base_accuracies","line":331,"kind":13},{"containerName":"_get_v3_base_accuracies","name":"$currbase","line":332,"kind":13},{"kind":13,"line":333,"definition":"my","name":"@read","containerName":"_get_v3_base_accuracies","localvar":"my"},{"containerName":"_get_v3_base_accuracies","name":"$last_base","line":334,"kind":13},{"kind":13,"line":334,"name":"$offset","containerName":"_get_v3_base_accuracies"},{"containerName":"_get_v3_base_accuracies","name":"$qlength","kind":13,"line":334},{"line":335,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$offset"},{"kind":13,"line":335,"name":"$last_base","containerName":"_get_v3_base_accuracies"},{"line":335,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$offset"},{"name":"$qlength","containerName":"_get_v3_base_accuracies","kind":13,"line":335},{"line":338,"kind":13,"containerName":"_get_v3_base_accuracies","name":"@read"},{"kind":13,"line":338,"containerName":"_get_v3_base_accuracies","name":"$buffer"},{"kind":13,"line":338,"containerName":"_get_v3_base_accuracies","name":"$offset"},{"name":"$qlength","containerName":"_get_v3_base_accuracies","kind":13,"line":338},{"name":"$accuracies","containerName":"_get_v3_base_accuracies","kind":13,"line":339},{"line":339,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$currbase"},{"kind":13,"line":339,"name":"@read","containerName":"_get_v3_base_accuracies"},{"name":"$accuracies","containerName":"_get_v3_base_accuracies","line":342,"kind":13}],"line":326,"kind":12,"range":{"start":{"character":0,"line":326},"end":{"character":9999,"line":343}},"name":"_get_v3_base_accuracies"},{"range":{"end":{"line":382,"character":9999},"start":{"character":0,"line":360}},"name":"_get_comments","children":[{"line":361,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_comments"},{"name":"$buffer","containerName":"_get_comments","line":361,"kind":13},{"localvar":"my","containerName":"_get_comments","name":"$comments","definition":"my","line":362,"kind":13},{"name":"new","containerName":"_get_comments","line":362,"kind":12},{"kind":13,"line":363,"definition":"my","name":"$size","containerName":"_get_comments","localvar":"my"},{"containerName":"_get_comments","name":"$buffer","kind":13,"line":363},{"line":364,"kind":13,"localvar":"my","name":"$comments_retrieved","definition":"my","containerName":"_get_comments"},{"containerName":"_get_comments","name":"$buffer","line":364,"kind":13},{"kind":13,"line":365,"containerName":"_get_comments","name":"$comments_retrieved"},{"line":366,"kind":13,"localvar":"my","definition":"my","name":"@comments_split","containerName":"_get_comments"},{"line":366,"kind":13,"name":"$comments_retrieved","containerName":"_get_comments"},{"containerName":"_get_comments","name":"@comments_split","kind":13,"line":367},{"name":"@comments_split","containerName":"_get_comments","line":368,"kind":13},{"definition":"my","name":"$tagname","containerName":"_get_comments","localvar":"my","kind":13,"line":371},{"name":"$text","containerName":"_get_comments","kind":13,"line":371},{"kind":13,"line":372,"definition":"my","name":"$comment_obj","containerName":"_get_comments","localvar":"my"},{"containerName":"_get_comments","name":"new","line":372,"kind":12},{"kind":13,"line":373,"name":"$text","containerName":"_get_comments"},{"name":"$tagname","containerName":"_get_comments","kind":13,"line":374},{"containerName":"_get_comments","name":"$comments","kind":13,"line":376},{"line":376,"kind":12,"containerName":"_get_comments","name":"add_Annotation"},{"kind":13,"line":376,"name":"$comment_obj","containerName":"_get_comments"},{"containerName":"_get_comments","name":"$self","kind":13,"line":380},{"line":380,"kind":13,"containerName":"_get_comments","name":"$comments"},{"line":381,"kind":13,"name":"$comments","containerName":"_get_comments"}],"line":360,"kind":12,"signature":{"label":"_get_comments($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :"},"detail":"($self,$buffer)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Annotation::Collection","kind":12,"line":362},{"name":"Bio","containerName":"Annotation::Comment","kind":12,"line":372},{"range":{"start":{"character":0,"line":398},"end":{"line":413,"character":9999}},"name":"_get_header","line":398,"children":[{"line":399,"kind":13,"localvar":"my","containerName":"_get_header","definition":"my","name":"$self"},{"containerName":"_get_header","name":"$buffer","kind":13,"line":399},{"kind":13,"line":400,"containerName":"_get_header","name":"$header","definition":"my","localvar":"my"},{"kind":13,"line":401,"name":"$header","containerName":"_get_header"},{"line":402,"kind":13,"containerName":"_get_header","name":"$header"},{"kind":13,"line":403,"name":"$header","containerName":"_get_header"},{"containerName":"_get_header","name":"$header","kind":13,"line":404},{"containerName":"_get_header","name":"$header","kind":13,"line":405},{"kind":13,"line":406,"name":"$header","containerName":"_get_header"},{"name":"$header","containerName":"_get_header","line":407,"kind":13},{"name":"$header","containerName":"_get_header","line":408,"kind":13},{"kind":13,"line":409,"containerName":"_get_header","name":"$header"},{"kind":13,"line":410,"containerName":"_get_header","name":"$header"},{"kind":13,"line":411,"name":"$header","containerName":"_get_header"},{"line":412,"kind":13,"name":"$header","containerName":"_get_header"},{"kind":13,"line":413,"containerName":"_get_header","name":"$header"}],"kind":12,"detail":"($self,$buffer)","signature":{"label":"_get_header($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None."},"containerName":"main::","definition":"sub"},{"name":"$buffer","containerName":null,"kind":13,"line":413},{"kind":13,"line":415,"name":"%self","containerName":null},{"name":"$header","containerName":null,"kind":13,"line":415},{"line":416,"kind":13,"containerName":null,"name":"$header"},{"range":{"start":{"character":0,"line":433},"end":{"line":448,"character":9999}},"name":"_parse_v2_bases","children":[{"containerName":"_parse_v2_bases","definition":"my","name":"$self","localvar":"my","kind":13,"line":434},{"containerName":"_parse_v2_bases","name":"$buffer","line":434,"kind":13},{"containerName":"_parse_v2_bases","definition":"my","name":"$length","localvar":"my","kind":13,"line":435},{"containerName":"_parse_v2_bases","name":"$buffer","kind":13,"line":435},{"localvar":"my","containerName":"_parse_v2_bases","definition":"my","name":"$offset2","line":436,"kind":13},{"line":436,"kind":13,"containerName":"_parse_v2_bases","name":"$currbuff"},{"kind":13,"line":436,"name":"$currbase","containerName":"_parse_v2_bases"},{"containerName":"_parse_v2_bases","name":"$currqual","kind":13,"line":436},{"containerName":"_parse_v2_bases","name":"$sequence","kind":13,"line":436},{"containerName":"_parse_v2_bases","name":"@qualities","line":436,"kind":13},{"kind":13,"line":436,"containerName":"_parse_v2_bases","name":"@indices"},{"name":"@read","definition":"my","containerName":"_parse_v2_bases","localvar":"my","kind":13,"line":437},{"name":"$harvester","containerName":"_parse_v2_bases","line":437,"kind":13},{"kind":13,"line":437,"containerName":"_parse_v2_bases","name":"$accuracies"},{"kind":13,"line":438,"containerName":"_parse_v2_bases","name":"$offset2"},{"name":"$offset2","containerName":"_parse_v2_bases","kind":13,"line":438},{"name":"$length","containerName":"_parse_v2_bases","line":438,"kind":13},{"containerName":"_parse_v2_bases","name":"$offset2","line":438,"kind":13},{"line":439,"kind":13,"name":"@read","containerName":"_parse_v2_bases"},{"line":439,"kind":13,"containerName":"_parse_v2_bases","name":"$buffer"},{"name":"$offset2","containerName":"_parse_v2_bases","kind":13,"line":439},{"name":"$length","containerName":"_parse_v2_bases","line":439,"kind":13},{"containerName":"_parse_v2_bases","name":"@indices","kind":13,"line":440},{"name":"$read","containerName":"_parse_v2_bases","line":440,"kind":13},{"containerName":"_parse_v2_bases","name":"$currbase","kind":13,"line":441},{"name":"$read","containerName":"_parse_v2_bases","line":441,"kind":13},{"name":"$currbase","containerName":"_parse_v2_bases","kind":13,"line":442},{"kind":13,"line":442,"containerName":"_parse_v2_bases","name":"$currqual"},{"name":"$read","containerName":"_parse_v2_bases","line":442,"kind":13},{"name":"$currbase","containerName":"_parse_v2_bases","kind":13,"line":443},{"kind":13,"line":443,"containerName":"_parse_v2_bases","name":"$currqual"},{"containerName":"_parse_v2_bases","name":"$read","line":443,"kind":13},{"line":444,"kind":13,"name":"$currbase","containerName":"_parse_v2_bases"},{"line":444,"kind":13,"name":"$currqual","containerName":"_parse_v2_bases"},{"containerName":"_parse_v2_bases","name":"$read","kind":13,"line":444},{"kind":13,"line":445,"name":"$currbase","containerName":"_parse_v2_bases"},{"name":"$currqual","containerName":"_parse_v2_bases","line":445,"kind":13},{"line":445,"kind":13,"name":"$read","containerName":"_parse_v2_bases"},{"line":446,"kind":13,"containerName":"_parse_v2_bases","name":"$currqual"},{"line":447,"kind":13,"name":"$accuracies","containerName":"_parse_v2_bases"},{"kind":13,"line":447,"name":"$read","containerName":"_parse_v2_bases"},{"containerName":"_parse_v2_bases","name":"$accuracies","line":448,"kind":13}],"line":433,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.","label":"_parse_v2_bases($self,$buffer)"},"detail":"($self,$buffer)","definition":"sub","containerName":"main::"},{"line":448,"kind":13,"name":"@read","containerName":null},{"line":449,"kind":13,"containerName":null,"name":"%accuracies"},{"containerName":null,"name":"@read","line":449,"kind":13},{"kind":13,"line":450,"name":"%accuracies","containerName":null},{"name":"@read","containerName":null,"kind":13,"line":450},{"containerName":null,"name":"$sequence","line":452,"kind":13},{"containerName":null,"name":"$currbase","line":452,"kind":13},{"name":"@qualities","containerName":null,"line":453,"kind":13},{"name":"$currqual","containerName":null,"line":453,"kind":13},{"line":455,"kind":13,"name":"@indices","containerName":null},{"kind":13,"line":455,"containerName":null,"name":"@qualities"},{"line":455,"kind":13,"name":"$sequence","containerName":null},{"line":455,"kind":13,"name":"$accuracies","containerName":null},{"signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.","parameters":[{"label":"$self"},{"label":"$buffer"},{"label":"$sample_size"}],"label":"_parse_v2_traces($self,$buffer,$sample_size)"},"detail":"($self,$buffer,$sample_size)","definition":"sub","containerName":"main::","children":[{"line":470,"kind":13,"localvar":"my","containerName":"_parse_v2_traces","name":"$self","definition":"my"},{"line":470,"kind":13,"name":"$buffer","containerName":"_parse_v2_traces"},{"name":"$sample_size","containerName":"_parse_v2_traces","kind":13,"line":470},{"kind":13,"line":471,"containerName":"_parse_v2_traces","definition":"my","name":"$byte","localvar":"my"},{"containerName":"_parse_v2_traces","name":"$sample_size","line":472,"kind":13},{"line":472,"kind":13,"name":"$byte","containerName":"_parse_v2_traces"},{"containerName":"_parse_v2_traces","name":"$byte","line":473,"kind":13},{"containerName":"_parse_v2_traces","definition":"my","name":"$length","localvar":"my","kind":13,"line":474},{"kind":13,"line":474,"containerName":"_parse_v2_traces","name":"$buffer"},{"localvar":"my","containerName":"_parse_v2_traces","name":"@read","definition":"my","line":475,"kind":13},{"containerName":"_parse_v2_traces","name":"$buffer","line":475,"kind":13},{"containerName":"_parse_v2_traces","name":"$traces","definition":"my","localvar":"my","kind":13,"line":477},{"kind":13,"line":478,"containerName":"_parse_v2_traces","definition":"my","name":"$array","localvar":"my"},{"kind":13,"line":479,"containerName":"_parse_v2_traces","name":"$offset2","definition":"my","localvar":"my"},{"line":479,"kind":13,"containerName":"_parse_v2_traces","name":"$offset2"},{"kind":13,"line":479,"name":"@read","containerName":"_parse_v2_traces"},{"line":479,"kind":13,"containerName":"_parse_v2_traces","name":"$offset2"},{"name":"$traces","containerName":"_parse_v2_traces","line":480,"kind":13},{"containerName":"_parse_v2_traces","name":"$read","line":480,"kind":13},{"name":"$offset2","containerName":"_parse_v2_traces","kind":13,"line":480},{"kind":13,"line":481,"containerName":"_parse_v2_traces","name":"$traces"}],"line":469,"kind":12,"range":{"end":{"line":481,"character":9999},"start":{"line":469,"character":0}},"name":"_parse_v2_traces"},{"line":474,"kind":12,"containerName":"length","name":"CORE"},{"containerName":null,"name":"@read","kind":13,"line":481},{"name":"$offset2","containerName":null,"line":481,"kind":13},{"line":482,"kind":13,"containerName":null,"name":"%traces"},{"kind":13,"line":482,"containerName":null,"name":"@read"},{"containerName":null,"name":"$offset2","kind":13,"line":482},{"line":483,"kind":13,"name":"%traces","containerName":null},{"containerName":null,"name":"@read","line":483,"kind":13},{"name":"$offset2","containerName":null,"line":483,"kind":13},{"line":485,"kind":13,"name":"$traces","containerName":null},{"line":489,"children":[],"kind":12,"range":{"start":{"character":0,"line":489},"end":{"character":9999,"line":498}},"containerName":"main::","definition":"sub","name":"get_trace_deprecated_use_the_sequencetrace_object_instead"},{"kind":12,"line":500,"children":[{"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","definition":"my","name":"$self","localvar":"my","kind":13,"line":501},{"definition":"my","name":"@temp","containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","localvar":"my","kind":13,"line":502},{"kind":13,"line":502,"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","name":"$self"},{"line":503,"kind":13,"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","name":"@temp"}],"containerName":"main::","name":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","definition":"sub","range":{"start":{"line":500,"character":0},"end":{"line":504,"character":9999}}},{"definition":"sub","name":"get_header","containerName":"main::","range":{"start":{"line":518,"character":0},"end":{"character":9999,"line":521}},"kind":12,"children":[{"kind":13,"line":519,"name":"$self","definition":"my","containerName":"get_header","localvar":"my"},{"containerName":"get_header","name":"$self","line":520,"kind":13}],"line":518},{"kind":12,"children":[{"kind":13,"line":535,"containerName":"get_comments","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"get_comments","kind":13,"line":536}],"line":534,"name":"get_comments","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":537},"start":{"character":0,"line":534}}},{"definition":"sub","containerName":"main::","signature":{"label":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object($self,$transformed)","parameters":[{"label":"$self"},{"label":"$transformed"}],"documentation":""},"detail":"($self,$transformed)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","localvar":"my","kind":13,"line":540},{"line":540,"kind":13,"name":"$transformed","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object"},{"line":541,"kind":13,"localvar":"my","definition":"my","name":"@sA","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object"},{"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"@sT","line":541,"kind":13},{"name":"@sG","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13,"line":541},{"kind":13,"line":541,"name":"@sC","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object"},{"line":542,"kind":13,"name":"$transformed","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object"},{"line":543,"kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"@sA"},{"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"$self","kind":13,"line":543},{"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"@sC","line":544,"kind":13},{"name":"$self","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","line":544,"kind":13}],"line":539,"name":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","range":{"end":{"line":544,"character":9999},"start":{"character":0,"line":539}}},{"line":545,"kind":13,"containerName":null,"name":"@sG"},{"containerName":null,"name":"%self","kind":13,"line":545},{"kind":13,"line":546,"containerName":null,"name":"@sT"},{"kind":13,"line":546,"containerName":null,"name":"%self"},{"name":"@sA","containerName":null,"kind":13,"line":549},{"kind":13,"line":549,"containerName":null,"name":"%self"},{"kind":13,"line":550,"name":"@sC","containerName":null},{"line":550,"kind":13,"containerName":null,"name":"%self"},{"name":"@sG","containerName":null,"line":551,"kind":13},{"line":551,"kind":13,"name":"%self","containerName":null},{"name":"@sT","containerName":null,"line":552,"kind":13},{"kind":13,"line":552,"containerName":null,"name":"%self"},{"line":555,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$curr"},{"containerName":null,"name":"$curr","kind":13,"line":555},{"line":555,"kind":13,"containerName":null,"name":"@sG"},{"containerName":null,"name":"%curr","kind":13,"line":555},{"children":[],"line":561,"kind":12,"range":{"end":{"character":9999,"line":577},"start":{"character":0,"line":561}},"name":"_dump_traces_incoming_deprecated_use_the_sequencetrace_object","definition":"sub","containerName":"main::"},{"name":"write_seq","range":{"end":{"character":9999,"line":660},"start":{"character":0,"line":609}},"definition":"sub","containerName":"main::","signature":{"label":"write_seq($self,%args)","parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you."},"detail":"($self,%args)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"write_seq","line":610,"kind":13},{"kind":13,"line":610,"name":"%args","containerName":"write_seq"},{"line":611,"kind":13,"localvar":"my","containerName":"write_seq","name":"%comments","definition":"my"},{"kind":13,"line":612,"name":"$label","definition":"my","containerName":"write_seq","localvar":"my"},{"name":"$arg","containerName":"write_seq","line":612,"kind":13},{"line":613,"kind":13,"localvar":"my","containerName":"write_seq","name":"$swq","definition":"my"},{"line":613,"kind":13,"name":"$self","containerName":"write_seq"},{"name":"_rearrange","containerName":"write_seq","line":613,"kind":12},{"name":"%args","containerName":"write_seq","kind":13,"line":613},{"kind":13,"line":614,"name":"$writer_fodder","definition":"my","containerName":"write_seq","localvar":"my"},{"containerName":"write_seq","name":"$swq","kind":13,"line":615},{"kind":13,"line":616,"name":"$swq","containerName":"write_seq"},{"name":"$swq","containerName":"write_seq","kind":13,"line":619},{"line":619,"kind":12,"containerName":"write_seq","name":"new"},{"name":"$swq","containerName":"write_seq","line":621,"kind":13},{"containerName":"write_seq","name":"$self","kind":13,"line":625},{"name":"throw","containerName":"write_seq","line":625,"kind":12},{"containerName":"write_seq","name":"$arg","kind":13,"line":628},{"name":"%args","containerName":"write_seq","line":628,"kind":13},{"name":"$arg","containerName":"write_seq","kind":13,"line":629},{"kind":13,"line":630,"name":"$label","containerName":"write_seq"},{"kind":13,"line":630,"containerName":"write_seq","name":"$arg"},{"line":631,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"name":"$label","containerName":"write_seq","kind":13,"line":631},{"kind":13,"line":631,"containerName":"write_seq","name":"$args"},{"containerName":"write_seq","name":"$arg","line":631,"kind":13},{"containerName":"write_seq","name":"$comments","line":633,"kind":13},{"name":"$comments","containerName":"write_seq","kind":13,"line":633},{"containerName":"write_seq","name":"$swq","kind":13,"line":633},{"name":"id","containerName":"write_seq","line":633,"kind":12},{"kind":13,"line":635,"containerName":"write_seq","name":"$writer_fodder"},{"containerName":"write_seq","name":"$comments","kind":13,"line":635},{"kind":13,"line":637,"name":"$writer_fodder","containerName":"write_seq"},{"kind":13,"line":638,"containerName":"write_seq","name":"$writer_fodder"},{"line":638,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"containerName":"write_seq","name":"$self","kind":13,"line":639},{"containerName":"write_seq","name":"warn","line":639,"kind":12},{"containerName":"write_seq","name":"$writer_fodder","line":640,"kind":13},{"name":"$writer_fodder","containerName":"write_seq","kind":13,"line":642},{"kind":13,"line":643,"name":"$writer_fodder","containerName":"write_seq"},{"containerName":"write_seq","name":"$writer_fodder","kind":13,"line":646},{"kind":13,"line":650,"containerName":"write_seq","name":"$writer_fodder"},{"containerName":"write_seq","name":"$writer_fodder","kind":13,"line":653},{"name":"$writer_fodder","containerName":"write_seq","line":654,"kind":13},{"name":"$writer_fodder","containerName":"write_seq","kind":13,"line":655},{"name":"$swq","containerName":"write_seq","line":655,"kind":13},{"line":655,"kind":12,"name":"seq","containerName":"write_seq"},{"containerName":"write_seq","name":"$writer_fodder","kind":13,"line":656},{"containerName":"write_seq","name":"$writer_fodder","kind":13,"line":657},{"kind":13,"line":658,"containerName":"write_seq","name":"$writer_fodder"},{"kind":13,"line":659,"name":"$writer_fodder","containerName":"write_seq"},{"name":"$writer_fodder","containerName":"write_seq","line":660,"kind":13}],"line":609},{"kind":12,"line":619,"containerName":"Seq::SequenceTrace","name":"Bio"},{"name":"comments","kind":12,"line":631},{"name":"comments","kind":12,"line":635},{"kind":12,"line":637,"name":"comments"},{"name":"version","kind":12,"line":637},{"kind":12,"line":638,"name":"comments"},{"name":"version","kind":12,"line":638},{"name":"comments","kind":12,"line":638},{"name":"version","line":638,"kind":12},{"name":"header","kind":12,"line":640},{"line":640,"kind":12,"name":"version"},{"name":"comments","line":642,"kind":12},{"name":"header","kind":12,"line":643},{"line":646,"kind":12,"name":"header"},{"name":"version","line":646,"kind":12},{"name":"header","kind":12,"line":650},{"name":"%writer_fodder","containerName":null,"line":662,"kind":13},{"line":663,"kind":13,"name":"%writer_fodder","containerName":null},{"line":663,"kind":13,"name":"$swq","containerName":null},{"kind":12,"line":663,"containerName":"main::","name":"trace_length"},{"kind":13,"line":665,"name":"%writer_fodder","containerName":null},{"name":"comments","line":665,"kind":12},{"kind":13,"line":665,"containerName":null,"name":"$self"},{"kind":12,"line":665,"containerName":"main::","name":"_get_binary_comments"},{"containerName":null,"name":"%writer_fodder","kind":13,"line":666},{"name":"comments","line":666,"kind":12},{"name":"%writer_fodder","containerName":null,"line":669,"kind":13},{"name":"traces","kind":12,"line":669},{"kind":13,"line":669,"name":"$self","containerName":null},{"containerName":"main::","name":"_get_binary_traces","kind":12,"line":669},{"containerName":null,"name":"%writer_fodder","line":670,"kind":13},{"name":"$swq","containerName":null,"kind":13,"line":671},{"name":"%writer_fodder","containerName":null,"kind":13,"line":671},{"containerName":null,"name":"$b_base_offsets","definition":"my","localvar":"my","kind":13,"line":672},{"containerName":null,"name":"$b_base_accuracies","line":672,"kind":13},{"line":672,"kind":13,"containerName":null,"name":"$samples_size"},{"name":"$bases_size","containerName":null,"kind":13,"line":672},{"kind":13,"line":676,"name":"%writer_fodder","containerName":null},{"line":677,"kind":13,"name":"%writer_fodder","containerName":null},{"name":"bases","kind":12,"line":677},{"line":677,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":677,"containerName":"main::","name":"_get_binary_bases"},{"line":679,"kind":13,"containerName":null,"name":"$swq"},{"name":"%writer_fodder","containerName":null,"line":680,"kind":13},{"kind":13,"line":681,"containerName":null,"name":"$samples_size"},{"containerName":"length","name":"CORE","kind":12,"line":681},{"containerName":null,"name":"%writer_fodder","kind":13,"line":681},{"name":"traces","kind":12,"line":681},{"name":"$bases_size","containerName":null,"kind":13,"line":682},{"name":"CORE","containerName":"length","line":682,"kind":12},{"line":682,"kind":13,"containerName":null,"name":"%writer_fodder"},{"line":682,"kind":12,"name":"bases"},{"name":"binary","kind":12,"line":682},{"kind":13,"line":683,"name":"%writer_fodder","containerName":null},{"kind":13,"line":683,"name":"$samples_size","containerName":null},{"containerName":null,"name":"%writer_fodder","kind":13,"line":684},{"kind":13,"line":685,"containerName":null,"name":"$samples_size"},{"kind":13,"line":685,"containerName":null,"name":"$bases_size"},{"name":"%writer_fodder","containerName":null,"kind":13,"line":686},{"kind":13,"line":687,"name":"%writer_fodder","containerName":null},{"kind":12,"line":687,"name":"binary"},{"containerName":null,"name":"%writer_fodder","kind":13,"line":688},{"containerName":null,"name":"%writer_fodder","line":689,"kind":13},{"line":690,"kind":13,"containerName":null,"name":"$samples_size"},{"kind":13,"line":690,"name":"$bases_size","containerName":null},{"name":"%writer_fodder","containerName":null,"kind":13,"line":691},{"containerName":null,"name":"%writer_fodder","line":692,"kind":13},{"line":693,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":693,"name":"_get_binary_header","containerName":"main::"},{"containerName":null,"name":"%writer_fodder","kind":13,"line":693},{"name":"header","line":693,"kind":12},{"containerName":null,"name":"$dumper","line":694,"kind":13},{"kind":12,"line":694,"containerName":"main::","name":"dumpValue"},{"line":694,"kind":13,"containerName":null,"name":"$writer_fodder"},{"containerName":null,"name":"$self","kind":13,"line":694},{"kind":12,"line":694,"name":"verbose","containerName":"main::"},{"line":695,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_print","line":695,"kind":12},{"containerName":null,"name":"%writer_fodder","kind":13,"line":695},{"name":"$self","containerName":null,"kind":13,"line":697},{"line":697,"kind":12,"name":"_print","containerName":"main::"},{"containerName":null,"name":"%writer_fodder","kind":13,"line":697},{"name":"$self","containerName":null,"kind":13,"line":699},{"line":699,"kind":12,"name":"_print","containerName":"main::"},{"containerName":null,"name":"%writer_fodder","line":699,"kind":13},{"line":701,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":701,"containerName":"main::","name":"_print"},{"line":701,"kind":13,"containerName":null,"name":"%writer_fodder"},{"kind":13,"line":705,"containerName":null,"name":"%writer_fodder"},{"kind":12,"line":705,"name":"peak_indices"},{"containerName":null,"name":"%writer_fodder","kind":13,"line":706},{"name":"accuracies","kind":12,"line":706},{"line":707,"kind":13,"name":"%writer_fodder","containerName":null},{"name":"bases","kind":12,"line":707},{"kind":13,"line":708,"containerName":null,"name":"%writer_fodder"},{"name":"reserved","kind":12,"line":708},{"name":"$self","containerName":null,"line":709,"kind":13},{"kind":12,"line":709,"name":"_get_binary_bases","containerName":"main::"},{"name":"$swq","containerName":null,"line":711,"kind":13},{"name":"%writer_fodder","containerName":null,"kind":13,"line":712},{"containerName":null,"name":"%writer_fodder","kind":13,"line":714},{"line":715,"kind":13,"containerName":null,"name":"%writer_fodder"},{"name":"%writer_fodder","containerName":null,"kind":13,"line":716},{"line":717,"kind":13,"name":"%writer_fodder","containerName":null},{"name":"%writer_fodder","containerName":null,"line":721,"kind":13},{"line":723,"kind":13,"containerName":null,"name":"%writer_fodder"},{"name":"%writer_fodder","containerName":null,"line":724,"kind":13},{"line":725,"kind":13,"containerName":null,"name":"%writer_fodder"},{"line":726,"kind":13,"name":"%writer_fodder","containerName":null},{"kind":13,"line":727,"name":"%writer_fodder","containerName":null},{"containerName":null,"name":"%writer_fodder","kind":13,"line":728},{"kind":13,"line":729,"name":"%writer_fodder","containerName":null},{"line":730,"kind":13,"name":"%writer_fodder","containerName":null},{"name":"%writer_fodder","containerName":null,"kind":13,"line":731},{"kind":13,"line":732,"containerName":null,"name":"%writer_fodder"},{"line":733,"kind":13,"containerName":null,"name":"%writer_fodder"},{"name":"%writer_fodder","containerName":null,"line":734,"kind":13},{"line":735,"kind":13,"name":"%writer_fodder","containerName":null},{"kind":12,"line":735,"name":"header"},{"line":735,"kind":12,"name":"binary"},{"name":"$self","containerName":null,"kind":13,"line":736},{"line":736,"kind":12,"name":"_get_binary_header","containerName":"main::"},{"kind":13,"line":736,"name":"%writer_fodder","containerName":null},{"line":736,"kind":12,"name":"header"},{"name":"$self","containerName":null,"line":737,"kind":13},{"kind":12,"line":737,"containerName":"main::","name":"_print"},{"containerName":null,"name":"%writer_fodder","line":737,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":739},{"kind":12,"line":739,"containerName":"main::","name":"_print"},{"containerName":null,"name":"%writer_fodder","line":739,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":741},{"line":741,"kind":12,"name":"_print","containerName":"main::"},{"line":741,"kind":13,"containerName":null,"name":"%writer_fodder"},{"line":743,"kind":13,"containerName":null,"name":"$self"},{"line":743,"kind":12,"containerName":"main::","name":"_print"},{"kind":13,"line":743,"name":"%writer_fodder","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":745},{"name":"_print","containerName":"main::","line":745,"kind":12},{"line":745,"kind":13,"name":"%writer_fodder","containerName":null},{"kind":13,"line":747,"name":"$self","containerName":null},{"name":"_print","containerName":"main::","line":747,"kind":12},{"line":747,"kind":13,"name":"%writer_fodder","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":749},{"containerName":"main::","name":"_print","kind":12,"line":749},{"line":749,"kind":13,"name":"%writer_fodder","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":755},{"containerName":"main::","name":"flush","line":755,"kind":12},{"line":755,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_flush_on_write","kind":12,"line":755},{"name":"$self","containerName":null,"kind":13,"line":755},{"kind":12,"line":755,"name":"_fh","containerName":"main::"},{"kind":13,"line":757,"containerName":null,"name":"$self"},{"name":"close","containerName":"main::","line":757,"kind":12},{"range":{"end":{"line":794,"character":9999},"start":{"character":0,"line":778}},"name":"_get_binary_header","detail":"($self,$header)","signature":{"label":"_get_binary_header($self,$header)","parameters":[{"label":"$self"},{"label":"$header"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :"},"containerName":"main::","definition":"sub","line":778,"children":[{"containerName":"_get_binary_header","name":"$self","definition":"my","localvar":"my","kind":13,"line":779},{"containerName":"_get_binary_header","name":"$header","kind":13,"line":779},{"localvar":"my","definition":"my","name":"$binary","containerName":"_get_binary_header","line":780,"kind":13},{"line":782,"kind":13,"name":"$header","containerName":"_get_binary_header"},{"name":"$header","containerName":"_get_binary_header","line":783,"kind":13},{"kind":13,"line":784,"containerName":"_get_binary_header","name":"$header"},{"line":785,"kind":13,"name":"$header","containerName":"_get_binary_header"},{"line":786,"kind":13,"containerName":"_get_binary_header","name":"$header"},{"name":"$header","containerName":"_get_binary_header","line":787,"kind":13},{"line":788,"kind":13,"containerName":"_get_binary_header","name":"$header"},{"containerName":"_get_binary_header","name":"$header","kind":13,"line":789},{"line":790,"kind":13,"name":"$header","containerName":"_get_binary_header"},{"containerName":"_get_binary_header","name":"$header","line":791,"kind":13},{"containerName":"_get_binary_header","name":"$header","kind":13,"line":792},{"line":793,"kind":13,"containerName":"_get_binary_header","name":"$header"},{"containerName":"_get_binary_header","name":"$header","kind":13,"line":794}],"kind":12},{"containerName":null,"name":"$binary","kind":13,"line":796},{"range":{"start":{"line":813,"character":0},"end":{"character":9999,"line":854}},"name":"_get_binary_traces","children":[{"kind":13,"line":814,"containerName":"_get_binary_traces","name":"$self","definition":"my","localvar":"my"},{"name":"$version","containerName":"_get_binary_traces","kind":13,"line":814},{"kind":13,"line":814,"name":"$ref","containerName":"_get_binary_traces"},{"kind":13,"line":814,"containerName":"_get_binary_traces","name":"$sample_size"},{"localvar":"my","definition":"my","name":"$returner","containerName":"_get_binary_traces","line":817,"kind":13},{"localvar":"my","definition":"my","name":"$sequence","containerName":"_get_binary_traces","line":818,"kind":13},{"kind":13,"line":818,"name":"$ref","containerName":"_get_binary_traces"},{"name":"seq","containerName":"_get_binary_traces","kind":12,"line":818},{"kind":13,"line":819,"containerName":"_get_binary_traces","name":"$sequence_length","definition":"my","localvar":"my"},{"containerName":"_get_binary_traces","name":"$sequence","kind":13,"line":819},{"definition":"my","name":"$traceobj","containerName":"_get_binary_traces","localvar":"my","kind":13,"line":822},{"name":"@traces","containerName":"_get_binary_traces","line":822,"kind":13},{"kind":13,"line":822,"name":"$current","containerName":"_get_binary_traces"},{"containerName":"_get_binary_traces","name":"$ref","kind":13,"line":823},{"kind":13,"line":824,"containerName":"_get_binary_traces","name":"$traceobj"},{"kind":12,"line":824,"containerName":"_get_binary_traces","name":"new"},{"containerName":"_get_binary_traces","name":"$ref","kind":13,"line":826},{"containerName":"_get_binary_traces","name":"$traceobj","line":827,"kind":13},{"line":827,"kind":12,"containerName":"_get_binary_traces","name":"_synthesize_traces"},{"containerName":"_get_binary_traces","name":"$traceobj","kind":13,"line":830},{"name":"$ref","containerName":"_get_binary_traces","kind":13,"line":830},{"line":831,"kind":13,"containerName":"_get_binary_traces","name":"$version"},{"localvar":"my","containerName":"_get_binary_traces","definition":"my","name":"$trace_length","line":832,"kind":13},{"name":"$traceobj","containerName":"_get_binary_traces","line":832,"kind":13},{"name":"trace_length","containerName":"_get_binary_traces","line":832,"kind":12},{"line":833,"kind":13,"containerName":"_get_binary_traces","name":"$current"},{"containerName":"_get_binary_traces","name":"$current","kind":13,"line":833},{"containerName":"_get_binary_traces","name":"$trace_length","line":833,"kind":13},{"line":833,"kind":13,"containerName":"_get_binary_traces","name":"$current"},{"line":835,"kind":13,"name":"@traces","containerName":"_get_binary_traces"},{"line":835,"kind":13,"containerName":"_get_binary_traces","name":"$traceobj"},{"name":"trace_value_at","containerName":"_get_binary_traces","line":835,"kind":12},{"containerName":"_get_binary_traces","name":"$current","kind":13,"line":835},{"containerName":"_get_binary_traces","name":"$version","kind":13,"line":839},{"kind":13,"line":840,"definition":"my","name":"$current_trace","containerName":"_get_binary_traces","localvar":"my"},{"kind":13,"line":841,"containerName":"_get_binary_traces","name":"@trace","definition":"my","localvar":"my"},{"line":841,"kind":13,"name":"$traceobj","containerName":"_get_binary_traces"},{"kind":12,"line":841,"containerName":"_get_binary_traces","name":"trace"},{"kind":13,"line":841,"name":"$current_trace","containerName":"_get_binary_traces"},{"line":842,"kind":13,"name":"@trace","containerName":"_get_binary_traces"},{"kind":13,"line":847,"containerName":"_get_binary_traces","definition":"my","name":"$transformed","localvar":"my"},{"name":"$self","containerName":"_get_binary_traces","kind":13,"line":847},{"name":"_delta","containerName":"_get_binary_traces","line":847,"kind":12},{"containerName":"_get_binary_traces","name":"@trace","kind":13,"line":847},{"line":848,"kind":13,"containerName":"_get_binary_traces","name":"$sample_size"},{"kind":13,"line":849,"containerName":"_get_binary_traces","name":"$transformed"},{"containerName":"_get_binary_traces","name":"@traces","line":853,"kind":13},{"containerName":"_get_binary_traces","name":"$transformed","line":853,"kind":13}],"line":813,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$version"},{"label":"$ref"},{"label":"$sample_size"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.","label":"_get_binary_traces($self,$version,$ref,$sample_size)"},"detail":"($self,$version,$ref,$sample_size)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Seq::Quality","line":824,"kind":12},{"name":"%returner","containerName":null,"line":857,"kind":13},{"line":857,"kind":12,"name":"version"},{"line":857,"kind":13,"containerName":null,"name":"$version"},{"line":858,"kind":13,"name":"%returner","containerName":null},{"line":858,"kind":12,"name":"string"},{"name":"@traces","containerName":null,"kind":13,"line":858},{"kind":13,"line":859,"containerName":null,"name":"$length_of_traces","definition":"my","localvar":"my"},{"containerName":null,"name":"@traces","line":859,"kind":13},{"localvar":"my","definition":"my","name":"$byte","containerName":null,"line":860,"kind":13},{"containerName":null,"name":"%sample_size","kind":13,"line":861},{"name":"%byte","containerName":null,"kind":13,"line":861},{"kind":13,"line":861,"containerName":null,"name":"$byte"},{"kind":13,"line":864,"name":"%returner","containerName":null},{"name":"binary","line":864,"kind":12},{"name":"@traces","containerName":null,"line":864,"kind":13},{"name":"%returner","containerName":null,"line":865,"kind":13},{"name":"length","kind":12,"line":865},{"line":865,"kind":12,"containerName":"length","name":"CORE"},{"containerName":null,"name":"%returner","kind":13,"line":865},{"name":"binary","kind":12,"line":865},{"line":866,"kind":13,"containerName":null,"name":"$returner"},{"line":870,"children":[{"localvar":"my","containerName":"_get_binary_bases","name":"$self","definition":"my","line":871,"kind":13},{"containerName":"_get_binary_bases","name":"$version","line":871,"kind":13},{"line":871,"kind":13,"containerName":"_get_binary_bases","name":"$trace"},{"name":"$sample_size","containerName":"_get_binary_bases","kind":13,"line":871},{"localvar":"my","containerName":"_get_binary_bases","name":"$byte","definition":"my","line":872,"kind":13},{"containerName":"_get_binary_bases","name":"$sample_size","kind":13,"line":873},{"containerName":"_get_binary_bases","name":"$byte","line":873,"kind":13},{"line":873,"kind":13,"name":"$byte","containerName":"_get_binary_bases"},{"line":874,"kind":13,"localvar":"my","containerName":"_get_binary_bases","name":"$returner","definition":"my"},{"name":"@current_row","containerName":"_get_binary_bases","kind":13,"line":874},{"line":874,"kind":13,"containerName":"_get_binary_bases","name":"$current_base"},{"containerName":"_get_binary_bases","name":"$string","line":874,"kind":13},{"name":"$binary","containerName":"_get_binary_bases","kind":13,"line":874},{"line":875,"kind":13,"localvar":"my","name":"$length","definition":"my","containerName":"_get_binary_bases"},{"name":"$trace","containerName":"_get_binary_bases","line":875,"kind":13},{"line":875,"kind":12,"name":"length","containerName":"_get_binary_bases"},{"containerName":"_get_binary_bases","name":"$version","line":876,"kind":13},{"name":"$returner","containerName":"_get_binary_bases","kind":13,"line":877},{"kind":13,"line":878,"name":"$current_base","definition":"my","containerName":"_get_binary_bases","localvar":"my"},{"name":"$current_base","containerName":"_get_binary_bases","kind":13,"line":878},{"line":878,"kind":13,"containerName":"_get_binary_bases","name":"$length"},{"name":"$current_base","containerName":"_get_binary_bases","kind":13,"line":878},{"containerName":"_get_binary_bases","name":"@current_row","definition":"my","localvar":"my","kind":13,"line":879},{"line":880,"kind":13,"containerName":"_get_binary_bases","name":"@current_row"},{"name":"$trace","containerName":"_get_binary_bases","kind":13,"line":880},{"name":"peak_index_at","containerName":"_get_binary_bases","line":880,"kind":12},{"line":880,"kind":13,"name":"$current_base","containerName":"_get_binary_bases"},{"kind":13,"line":881,"name":"@current_row","containerName":"_get_binary_bases"},{"containerName":"_get_binary_bases","name":"$trace","line":881,"kind":13},{"name":"accuracy_at","containerName":"_get_binary_bases","kind":12,"line":881},{"line":881,"kind":13,"containerName":"_get_binary_bases","name":"$current_base"},{"kind":13,"line":882,"containerName":"_get_binary_bases","name":"@current_row"},{"kind":13,"line":882,"name":"$trace","containerName":"_get_binary_bases"},{"name":"accuracy_at","containerName":"_get_binary_bases","kind":12,"line":882},{"containerName":"_get_binary_bases","name":"$current_base","kind":13,"line":882},{"name":"@current_row","containerName":"_get_binary_bases","line":883,"kind":13},{"name":"$trace","containerName":"_get_binary_bases","line":883,"kind":13},{"kind":12,"line":883,"containerName":"_get_binary_bases","name":"accuracy_at"},{"line":883,"kind":13,"name":"$current_base","containerName":"_get_binary_bases"},{"name":"@current_row","containerName":"_get_binary_bases","line":884,"kind":13},{"line":884,"kind":13,"containerName":"_get_binary_bases","name":"$trace"},{"name":"accuracy_at","containerName":"_get_binary_bases","line":884,"kind":12},{"kind":13,"line":884,"name":"$current_base","containerName":"_get_binary_bases"},{"name":"@current_row","containerName":"_get_binary_bases","line":885,"kind":13},{"containerName":"_get_binary_bases","name":"$trace","line":885,"kind":13},{"containerName":"_get_binary_bases","name":"baseat","kind":12,"line":885},{"containerName":"_get_binary_bases","name":"$current_base","line":885,"kind":13},{"name":"@current_row","containerName":"_get_binary_bases","kind":13,"line":886},{"kind":13,"line":887,"containerName":"_get_binary_bases","name":"$returner"},{"name":"@current_row","containerName":"_get_binary_bases","line":887,"kind":13},{"kind":13,"line":888,"name":"$returner","containerName":"_get_binary_bases"},{"kind":13,"line":888,"name":"@current_row","containerName":"_get_binary_bases"},{"line":890,"kind":13,"containerName":"_get_binary_bases","name":"$returner"}],"kind":12,"detail":"($self,$version,$trace,$sample_size)","signature":{"label":"_get_binary_bases($self,$version,$trace,$sample_size)","parameters":[{"label":"$self"},{"label":"$version"},{"label":"$trace"},{"label":"$sample_size"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"end":{"line":891,"character":9999},"start":{"character":0,"line":870}},"name":"_get_binary_bases"},{"kind":12,"line":887,"name":"string"},{"line":888,"kind":12,"name":"binary"},{"name":"%returner","containerName":null,"line":893,"kind":13},{"line":894,"kind":13,"name":"%returner","containerName":null},{"name":"peak_indices","line":894,"kind":12},{"name":"string","line":894,"kind":12},{"containerName":null,"name":"$trace","line":894,"kind":13},{"kind":12,"line":894,"name":"peak_indices","containerName":"main::"},{"localvar":"my","containerName":null,"name":"$length","definition":"my","line":895,"kind":13},{"line":895,"kind":13,"name":"%returner","containerName":null},{"name":"peak_indices","kind":12,"line":895},{"line":895,"kind":12,"name":"string"},{"name":"%returner","containerName":null,"kind":13,"line":896},{"name":"peak_indices","kind":12,"line":896},{"line":896,"kind":12,"name":"binary"},{"name":"%returner","containerName":null,"kind":13,"line":897},{"line":897,"kind":12,"name":"peak_indices"},{"name":"string","line":897,"kind":12},{"line":898,"kind":13,"name":"%returner","containerName":null},{"name":"peak_indices","line":898,"kind":12},{"name":"length","line":898,"kind":12},{"containerName":"length","name":"CORE","line":899,"kind":12},{"containerName":null,"name":"%returner","kind":13,"line":899},{"name":"peak_indices","kind":12,"line":899},{"name":"binary","kind":12,"line":899},{"line":900,"kind":13,"localvar":"my","containerName":null,"name":"@accuracies","definition":"my"},{"kind":13,"line":901,"definition":"my","name":"%base","containerName":null,"localvar":"my"},{"line":902,"kind":13,"containerName":null,"name":"%returner"},{"name":"accuracies","line":902,"kind":12},{"containerName":null,"name":"$base","line":902,"kind":13},{"name":"$trace","containerName":null,"line":902,"kind":13},{"containerName":"main::","name":"accuracies","line":902,"kind":12},{"line":902,"kind":13,"containerName":null,"name":"$base"},{"containerName":null,"name":"@accuracies","line":903,"kind":13},{"containerName":null,"name":"$trace","kind":13,"line":903},{"line":903,"kind":12,"name":"accuracies","containerName":"main::"},{"kind":13,"line":903,"name":"$base","containerName":null},{"containerName":null,"name":"%returner","kind":13,"line":905},{"line":905,"kind":12,"name":"sequence"},{"name":"$trace","containerName":null,"line":905,"kind":13},{"kind":12,"line":905,"name":"seq","containerName":"main::"},{"name":"$length","containerName":null,"kind":13,"line":906},{"containerName":null,"name":"@accuracies","kind":13,"line":906},{"name":"%returner","containerName":null,"kind":13,"line":908},{"name":"accuracies","kind":12,"line":908},{"line":908,"kind":12,"name":"binary"},{"kind":13,"line":908,"containerName":null,"name":"@accuracies"},{"line":909,"kind":13,"containerName":null,"name":"%returner"},{"name":"accuracies","kind":12,"line":909},{"kind":12,"line":909,"name":"length"},{"line":910,"kind":12,"containerName":"length","name":"CORE"},{"line":910,"kind":13,"containerName":null,"name":"%returner"},{"line":910,"kind":12,"name":"accuracies"},{"name":"binary","line":910,"kind":12},{"name":"$length","containerName":null,"line":911,"kind":13},{"name":"$trace","containerName":null,"kind":13,"line":911},{"kind":12,"line":911,"name":"seq_obj","containerName":"main::"},{"kind":12,"line":911,"name":"length","containerName":"main::"},{"kind":13,"line":912,"containerName":null,"definition":"my","name":"$count","localvar":"my"},{"kind":13,"line":912,"name":"$count","containerName":null},{"name":"$length","containerName":null,"kind":13,"line":912},{"line":912,"kind":13,"name":"%count","containerName":null},{"name":"%returner","containerName":null,"line":913,"kind":13},{"kind":12,"line":913,"name":"reserved"},{"line":913,"kind":12,"name":"string"},{"containerName":null,"name":"$length","line":916,"kind":13},{"containerName":null,"name":"%returner","line":916,"kind":13},{"name":"reserved","kind":12,"line":916},{"name":"string","kind":12,"line":916},{"line":918,"kind":13,"containerName":null,"name":"%returner"},{"containerName":null,"name":"%returner","kind":13,"line":919},{"kind":12,"line":919,"name":"reserved"},{"kind":12,"line":919,"name":"string"},{"kind":13,"line":920,"name":"%returner","containerName":null},{"line":921,"kind":12,"name":"CORE","containerName":"length"},{"containerName":null,"name":"%returner","kind":13,"line":921},{"line":923,"kind":13,"localvar":"my","name":"@bases","definition":"my","containerName":null},{"containerName":null,"name":"$trace","line":923,"kind":13},{"name":"seq","containerName":"main::","line":923,"kind":12},{"kind":13,"line":924,"containerName":null,"name":"$length"},{"name":"$trace","containerName":null,"kind":13,"line":924},{"containerName":"main::","name":"length","kind":12,"line":924},{"line":925,"kind":13,"name":"%returner","containerName":null},{"line":925,"kind":13,"name":"$trace","containerName":null},{"containerName":"main::","name":"seq","line":925,"kind":12},{"name":"%returner","containerName":null,"line":928,"kind":13},{"line":928,"kind":12,"name":"peak_indices"},{"name":"%returner","containerName":null,"line":929,"kind":13},{"line":929,"kind":12,"name":"accuracies"},{"kind":13,"line":930,"name":"%returner","containerName":null},{"kind":12,"line":930,"name":"bases"},{"line":931,"kind":13,"name":"%returner","containerName":null},{"line":931,"kind":12,"name":"reserved"},{"name":"_make_trace_string","range":{"start":{"line":948,"character":0},"end":{"character":9999,"line":952}},"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :","parameters":[{"label":"$self"},{"label":"$version"}],"label":"_make_trace_string($self,$version)"},"detail":"($self,$version)","kind":12,"children":[{"line":949,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_make_trace_string"},{"name":"$version","containerName":"_make_trace_string","kind":13,"line":949},{"containerName":"_make_trace_string","name":"@traces","definition":"my","localvar":"my","kind":13,"line":950},{"kind":13,"line":951,"containerName":"_make_trace_string","name":"@traces_view","definition":"my","localvar":"my"},{"kind":13,"line":952,"name":"@as","definition":"my","containerName":"_make_trace_string","localvar":"my"},{"name":"$self","containerName":"_make_trace_string","line":952,"kind":13}],"line":948},{"line":953,"kind":13,"localvar":"my","definition":"my","name":"@cs","containerName":null},{"name":"%self","containerName":null,"line":953,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"@gs","line":954,"kind":13},{"name":"%self","containerName":null,"line":954,"kind":13},{"line":955,"kind":13,"localvar":"my","name":"@ts","definition":"my","containerName":null},{"line":955,"kind":13,"name":"%self","containerName":null},{"line":956,"kind":13,"containerName":null,"name":"%version"},{"kind":13,"line":957,"definition":"my","name":"$curr","containerName":null,"localvar":"my"},{"kind":13,"line":957,"name":"$curr","containerName":null},{"line":957,"kind":13,"containerName":null,"name":"@as"},{"line":957,"kind":13,"name":"%curr","containerName":null},{"kind":13,"line":958,"name":"@as","containerName":null},{"line":958,"kind":13,"name":"$curr","containerName":null},{"kind":13,"line":958,"name":"$DEFAULT_QUALITY","containerName":null},{"containerName":null,"name":"@as","kind":13,"line":958},{"line":958,"kind":13,"containerName":null,"name":"$curr"},{"name":"@cs","containerName":null,"line":959,"kind":13},{"kind":13,"line":959,"containerName":null,"name":"$curr"},{"line":959,"kind":13,"containerName":null,"name":"$DEFAULT_QUALITY"},{"kind":13,"line":959,"containerName":null,"name":"@cs"},{"line":959,"kind":13,"name":"$curr","containerName":null},{"name":"@gs","containerName":null,"line":960,"kind":13},{"containerName":null,"name":"$curr","line":960,"kind":13},{"kind":13,"line":960,"name":"$DEFAULT_QUALITY","containerName":null},{"line":960,"kind":13,"containerName":null,"name":"@gs"},{"containerName":null,"name":"$curr","kind":13,"line":960},{"kind":13,"line":961,"name":"@ts","containerName":null},{"kind":13,"line":961,"containerName":null,"name":"$curr"},{"line":961,"kind":13,"name":"$DEFAULT_QUALITY","containerName":null},{"containerName":null,"name":"@ts","kind":13,"line":961},{"line":961,"kind":13,"name":"$curr","containerName":null},{"name":"@traces","containerName":null,"line":962,"kind":13},{"name":"@as","containerName":null,"line":962,"kind":13},{"line":962,"kind":13,"containerName":null,"name":"$curr"},{"name":"@cs","containerName":null,"kind":13,"line":962},{"containerName":null,"name":"$curr","kind":13,"line":962},{"kind":13,"line":962,"containerName":null,"name":"@gs"},{"containerName":null,"name":"$curr","kind":13,"line":962},{"name":"@ts","containerName":null,"line":962,"kind":13},{"kind":13,"line":962,"name":"$curr","containerName":null},{"name":"%version","containerName":null,"line":965,"kind":13},{"name":"@traces","containerName":null,"kind":13,"line":966},{"containerName":null,"name":"@as","kind":13,"line":966},{"containerName":null,"name":"@cs","kind":13,"line":966},{"kind":13,"line":966,"name":"@gs","containerName":null},{"containerName":null,"name":"@ts","line":966,"kind":13},{"line":969,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"throw","line":969,"kind":12},{"containerName":null,"definition":"my","name":"$length","localvar":"my","kind":13,"line":971},{"kind":13,"line":971,"name":"@traces","containerName":null},{"line":972,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":972,"name":"@traces","containerName":null},{"kind":12,"line":990,"children":[{"line":991,"kind":13,"localvar":"my","containerName":"_get_binary_comments","name":"$self","definition":"my"},{"containerName":"_get_binary_comments","name":"$rcomments","line":991,"kind":13},{"line":992,"kind":13,"localvar":"my","name":"$returner","definition":"my","containerName":"_get_binary_comments"},{"localvar":"my","definition":"my","name":"$comments_string","containerName":"_get_binary_comments","line":993,"kind":13},{"line":994,"kind":13,"localvar":"my","containerName":"_get_binary_comments","definition":"my","name":"%comments"},{"kind":13,"line":994,"containerName":"_get_binary_comments","name":"$rcomments"},{"localvar":"my","containerName":"_get_binary_comments","definition":"my","name":"$key","line":995,"kind":13},{"kind":13,"line":995,"containerName":"_get_binary_comments","name":"%comments"},{"name":"$comments","containerName":"_get_binary_comments","line":996,"kind":13},{"containerName":"_get_binary_comments","name":"$key","line":996,"kind":13},{"line":997,"kind":13,"containerName":"_get_binary_comments","name":"$comments_string"},{"kind":13,"line":999,"name":"$comments_string","containerName":"_get_binary_comments"},{"definition":"my","name":"$length","containerName":"_get_binary_comments","localvar":"my","kind":13,"line":1000},{"name":"$comments_string","containerName":"_get_binary_comments","kind":13,"line":1000},{"containerName":"_get_binary_comments","name":"$returner","kind":13,"line":1001},{"name":"$length","containerName":"_get_binary_comments","kind":13,"line":1001},{"containerName":"_get_binary_comments","name":"$returner","line":1002,"kind":13},{"line":1002,"kind":13,"name":"$comments_string","containerName":"_get_binary_comments"},{"name":"$returner","containerName":"_get_binary_comments","kind":13,"line":1003},{"name":"$comments_string","containerName":"_get_binary_comments","kind":13,"line":1003},{"containerName":"_get_binary_comments","name":"$returner","line":1004,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$rcomments)","signature":{"parameters":[{"label":"$self"},{"label":"$rcomments"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.","label":"_get_binary_comments($self,$rcomments)"},"name":"_get_binary_comments","range":{"end":{"character":9999,"line":1005},"start":{"character":0,"line":990}}},{"containerName":"length","name":"CORE","kind":12,"line":1000},{"name":"length","kind":12,"line":1001},{"line":1002,"kind":12,"name":"string"},{"line":1003,"kind":12,"name":"binary"},{"name":"_delta","range":{"start":{"character":0,"line":1051},"end":{"character":9999,"line":1117}},"definition":"sub","containerName":"main::","signature":{"label":"_delta($self,$rsamples,$direction)","documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html","parameters":[{"label":"$self"},{"label":"$rsamples"},{"label":"$direction"}]},"detail":"($self,$rsamples,$direction)","kind":12,"children":[{"containerName":"_delta","name":"$self","definition":"my","localvar":"my","kind":13,"line":1052},{"name":"$rsamples","containerName":"_delta","line":1052,"kind":13},{"name":"$direction","containerName":"_delta","kind":13,"line":1052},{"kind":13,"line":1053,"definition":"my","name":"@samples","containerName":"_delta","localvar":"my"},{"kind":13,"line":1053,"name":"$rsamples","containerName":"_delta"},{"localvar":"my","containerName":"_delta","name":"$i","definition":"my","line":1065,"kind":13},{"kind":13,"line":1065,"containerName":"_delta","name":"$num_samples"},{"containerName":"_delta","name":"$p_delta","kind":13,"line":1065},{"name":"$p_sample","containerName":"_delta","kind":13,"line":1065},{"name":"@samples_converted","containerName":"_delta","kind":13,"line":1065},{"kind":13,"line":1065,"name":"$p_sample1","containerName":"_delta"},{"kind":13,"line":1065,"containerName":"_delta","name":"$p_sample2"},{"line":1066,"kind":13,"localvar":"my","containerName":"_delta","definition":"my","name":"$SLOW_BUT_CLEAR"},{"kind":13,"line":1067,"containerName":"_delta","name":"$num_samples"},{"line":1067,"kind":13,"containerName":"_delta","name":"@samples"},{"containerName":"_delta","name":"$direction","line":1070,"kind":13},{"kind":13,"line":1071,"name":"$SLOW_BUT_CLEAR","containerName":"_delta"},{"containerName":"_delta","name":"$p_delta","kind":13,"line":1072},{"containerName":"_delta","name":"$i","kind":13,"line":1073},{"containerName":"_delta","name":"$i","line":1073,"kind":13},{"kind":13,"line":1073,"name":"$num_samples","containerName":"_delta"},{"kind":13,"line":1073,"name":"$i","containerName":"_delta"},{"kind":13,"line":1074,"containerName":"_delta","name":"$p_sample"},{"line":1074,"kind":13,"name":"$samples","containerName":"_delta"},{"containerName":"_delta","name":"$i","line":1074,"kind":13},{"name":"$samples","containerName":"_delta","kind":13,"line":1075},{"name":"$i","containerName":"_delta","kind":13,"line":1075},{"containerName":"_delta","name":"$samples","kind":13,"line":1075},{"kind":13,"line":1075,"containerName":"_delta","name":"$i"},{"containerName":"_delta","name":"$p_delta","kind":13,"line":1075},{"line":1076,"kind":13,"containerName":"_delta","name":"$p_delta"},{"containerName":"_delta","name":"$p_sample","line":1076,"kind":13},{"kind":13,"line":1078,"containerName":"_delta","name":"$p_delta"},{"containerName":"_delta","name":"$i","line":1079,"kind":13},{"kind":13,"line":1079,"containerName":"_delta","name":"$i"},{"line":1079,"kind":13,"name":"$num_samples","containerName":"_delta"},{"containerName":"_delta","name":"$i","line":1079,"kind":13},{"line":1080,"kind":13,"name":"$p_sample","containerName":"_delta"},{"name":"$samples","containerName":"_delta","kind":13,"line":1080},{"name":"$i","containerName":"_delta","kind":13,"line":1080},{"containerName":"_delta","name":"$samples","line":1081,"kind":13},{"line":1081,"kind":13,"containerName":"_delta","name":"$i"},{"kind":13,"line":1081,"name":"$samples","containerName":"_delta"},{"containerName":"_delta","name":"$i","line":1081,"kind":13},{"kind":13,"line":1081,"containerName":"_delta","name":"$p_delta"},{"name":"$p_delta","containerName":"_delta","kind":13,"line":1082},{"kind":13,"line":1082,"name":"$p_sample","containerName":"_delta"},{"name":"$i","containerName":"_delta","line":1085,"kind":13},{"line":1085,"kind":13,"name":"$num_samples","containerName":"_delta"},{"kind":13,"line":1085,"name":"$i","containerName":"_delta"},{"kind":13,"line":1085,"name":"$i","containerName":"_delta"},{"name":"$samples","containerName":"_delta","line":1086,"kind":13},{"name":"$i","containerName":"_delta","line":1086,"kind":13},{"kind":13,"line":1086,"name":"$samples","containerName":"_delta"},{"containerName":"_delta","name":"$i","line":1086,"kind":13},{"name":"$samples","containerName":"_delta","kind":13,"line":1086},{"name":"$i","containerName":"_delta","line":1086,"kind":13},{"name":"$samples","containerName":"_delta","line":1086,"kind":13},{"name":"$i","containerName":"_delta","kind":13,"line":1086},{"name":"$samples","containerName":"_delta","line":1088,"kind":13},{"containerName":"_delta","name":"$samples","line":1088,"kind":13},{"containerName":"_delta","name":"$samples","line":1088,"kind":13},{"name":"$direction","containerName":"_delta","kind":13,"line":1091},{"name":"$SLOW_BUT_CLEAR","containerName":"_delta","line":1092,"kind":13},{"name":"$p_sample","containerName":"_delta","kind":13,"line":1093},{"kind":13,"line":1094,"name":"$i","containerName":"_delta"},{"kind":13,"line":1094,"name":"$i","containerName":"_delta"},{"containerName":"_delta","name":"$num_samples","kind":13,"line":1094},{"containerName":"_delta","name":"$i","kind":13,"line":1094},{"line":1095,"kind":13,"containerName":"_delta","name":"$samples"},{"containerName":"_delta","name":"$i","line":1095,"kind":13},{"name":"$samples","containerName":"_delta","line":1095,"kind":13},{"line":1095,"kind":13,"name":"$i","containerName":"_delta"},{"line":1095,"kind":13,"name":"$p_sample","containerName":"_delta"},{"name":"$p_sample","containerName":"_delta","line":1096,"kind":13},{"kind":13,"line":1096,"containerName":"_delta","name":"$samples"},{"kind":13,"line":1096,"containerName":"_delta","name":"$i"},{"line":1098,"kind":13,"name":"$p_sample","containerName":"_delta"},{"containerName":"_delta","name":"$i","kind":13,"line":1099},{"line":1099,"kind":13,"containerName":"_delta","name":"$i"},{"kind":13,"line":1099,"name":"$num_samples","containerName":"_delta"},{"kind":13,"line":1099,"containerName":"_delta","name":"$i"},{"line":1100,"kind":13,"containerName":"_delta","name":"$samples"},{"kind":13,"line":1100,"containerName":"_delta","name":"$i"},{"containerName":"_delta","name":"$samples","line":1100,"kind":13},{"name":"$i","containerName":"_delta","kind":13,"line":1100},{"name":"$p_sample","containerName":"_delta","kind":13,"line":1100},{"containerName":"_delta","name":"$p_sample","kind":13,"line":1101},{"kind":13,"line":1101,"containerName":"_delta","name":"$samples"},{"line":1101,"kind":13,"name":"$i","containerName":"_delta"},{"containerName":"_delta","name":"$p_sample1","line":1104,"kind":13},{"name":"$p_sample2","containerName":"_delta","kind":13,"line":1104},{"name":"$i","containerName":"_delta","line":1105,"kind":13},{"kind":13,"line":1105,"name":"$i","containerName":"_delta"},{"containerName":"_delta","name":"$num_samples","kind":13,"line":1105},{"line":1105,"kind":13,"name":"$i","containerName":"_delta"},{"line":1106,"kind":13,"name":"$p_sample1","containerName":"_delta"},{"line":1106,"kind":13,"containerName":"_delta","name":"$p_sample1"},{"name":"$samples","containerName":"_delta","kind":13,"line":1106},{"kind":13,"line":1106,"containerName":"_delta","name":"$i"},{"kind":13,"line":1107,"containerName":"_delta","name":"$samples"},{"line":1107,"kind":13,"containerName":"_delta","name":"$i"},{"containerName":"_delta","name":"$p_sample1","kind":13,"line":1107},{"containerName":"_delta","name":"$p_sample2","kind":13,"line":1107},{"kind":13,"line":1108,"name":"$p_sample2","containerName":"_delta"},{"kind":13,"line":1108,"name":"$samples","containerName":"_delta"},{"containerName":"_delta","name":"$i","line":1108,"kind":13},{"kind":13,"line":1114,"containerName":"_delta","name":"$self"},{"name":"warn","containerName":"_delta","line":1114,"kind":12},{"name":"@samples","containerName":"_delta","line":1116,"kind":13}],"line":1051},{"name":"_unpack_magik","range":{"start":{"line":1131,"character":0},"end":{"character":9999,"line":1141}},"kind":12,"line":1131,"children":[{"localvar":"my","containerName":"_unpack_magik","name":"$self","definition":"my","line":1132,"kind":13},{"containerName":"_unpack_magik","name":"$buffer","line":1132,"kind":13},{"definition":"my","name":"$length","containerName":"_unpack_magik","localvar":"my","kind":13,"line":1133},{"containerName":"_unpack_magik","name":"$buffer","line":1133,"kind":13},{"containerName":"_unpack_magik","name":"@read","definition":"my","localvar":"my","kind":13,"line":1134},{"containerName":"_unpack_magik","name":"$counter","kind":13,"line":1134},{"kind":13,"line":1136,"containerName":"_unpack_magik","name":"@read"},{"line":1136,"kind":13,"name":"$buffer","containerName":"_unpack_magik"},{"line":1137,"kind":13,"containerName":"_unpack_magik","name":"$counter"},{"kind":13,"line":1137,"name":"$counter","containerName":"_unpack_magik"},{"line":1137,"kind":13,"containerName":"_unpack_magik","name":"$counter"}],"containerName":"main::","definition":"sub","detail":"($self,$buffer)","signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.","parameters":[{"label":"$self"},{"label":"$buffer"}],"label":"_unpack_magik($self,$buffer)"}},{"kind":12,"children":[{"containerName":"read_from_buffer","name":"$self","definition":"my","localvar":"my","kind":13,"line":1156},{"containerName":"read_from_buffer","name":"$fh","line":1156,"kind":13},{"containerName":"read_from_buffer","name":"$buffer","line":1156,"kind":13},{"name":"$length","containerName":"read_from_buffer","line":1156,"kind":13},{"containerName":"read_from_buffer","name":"$start_position","line":1156,"kind":13},{"name":"$start_position","containerName":"read_from_buffer","kind":13,"line":1158},{"line":1162,"kind":13,"name":"$start_position","containerName":"read_from_buffer"},{"line":1164,"kind":13,"containerName":"read_from_buffer","name":"$fh"},{"line":1164,"kind":13,"containerName":"read_from_buffer","name":"$start_position"},{"line":1170,"kind":13,"name":"$fh","containerName":"read_from_buffer"},{"kind":13,"line":1170,"containerName":"read_from_buffer","name":"$buffer"},{"name":"$length","containerName":"read_from_buffer","kind":13,"line":1170},{"containerName":"read_from_buffer","name":"$buffer","kind":13,"line":1171},{"containerName":"read_from_buffer","name":"$length","kind":13,"line":1171},{"containerName":"read_from_buffer","name":"$self","kind":13,"line":1172},{"kind":12,"line":1172,"containerName":"read_from_buffer","name":"warn"},{"line":1173,"kind":13,"localvar":"my","containerName":"read_from_buffer","definition":"my","name":"$missing_length"},{"kind":13,"line":1173,"name":"$length","containerName":"read_from_buffer"},{"name":"$buffer","containerName":"read_from_buffer","line":1173,"kind":13},{"localvar":"my","definition":"my","name":"$buffer2","containerName":"read_from_buffer","line":1174,"kind":13},{"line":1175,"kind":13,"containerName":"read_from_buffer","name":"$fh"},{"line":1175,"kind":13,"containerName":"read_from_buffer","name":"$buffer2"},{"kind":13,"line":1175,"name":"$missing_length","containerName":"read_from_buffer"},{"line":1176,"kind":13,"containerName":"read_from_buffer","name":"$buffer"},{"name":"$buffer2","containerName":"read_from_buffer","line":1176,"kind":13},{"line":1177,"kind":13,"name":"$buffer","containerName":"read_from_buffer"},{"kind":13,"line":1177,"name":"$length","containerName":"read_from_buffer"},{"containerName":"read_from_buffer","name":"$self","line":1178,"kind":13},{"line":1178,"kind":12,"containerName":"read_from_buffer","name":"throw"},{"kind":13,"line":1178,"name":"$buffer","containerName":"read_from_buffer"},{"containerName":"read_from_buffer","name":"$fh","kind":13,"line":1178},{"containerName":"read_from_buffer","name":"$buffer","line":1182,"kind":13}],"line":1155,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$fh"},{"label":"$buffer"},{"label":"$length"},{"label":"$start_position"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.\n\n\nsub _unpack_magik {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my (@read,$counter);\n    foreach (qw(c C s S i I l L n N v V)) {\n        @read = unpack \"$_$length\", $buffer;\n        for ($counter=0; $counter < 20; $counter++) {\n            print(\"$read[$counter]\\n\");\n        }\n    }\n}\n\n=head2 read_from_buffer($filehandle,$buffer,$length)\n\n Title   : read_from_buffer($filehandle,$buffer,$length)\n Usage   : $self->read_from_buffer($filehandle,$buffer,$length);\n Function: Read from the buffer.\n Returns : $buffer, containing a read of $length\n Args    : a filehandle, a buffer, and a read length\n Notes   : I just got tired of typing\n       \"unless (length($buffer) == $length)\" so I put it here.","label":"read_from_buffer($self,$fh,$buffer,$length,$start_position)"},"detail":"($self,$fh,$buffer,$length,$start_position)","name":"read_from_buffer","range":{"start":{"line":1155,"character":0},"end":{"line":1183,"character":9999}}},{"line":1196,"children":[{"kind":13,"line":1197,"definition":"my","name":"$rhash","containerName":"_dump_keys","localvar":"my"},{"name":"$rhash","containerName":"_dump_keys","line":1198,"kind":13},{"kind":13,"line":1199,"name":"$rhash","containerName":"_dump_keys"},{"name":"$rhash","containerName":"_dump_keys","kind":13,"line":1203}],"kind":12,"range":{"start":{"line":1196,"character":0},"end":{"character":9999,"line":1206}},"containerName":"main::","name":"_dump_keys","definition":"sub"},{"children":[{"localvar":"my","containerName":"_dump_base_accuracies","name":"$self","definition":"my","line":1220,"kind":13},{"containerName":"_dump_base_accuracies","name":"$self","line":1223,"kind":13}],"line":1219,"kind":12,"range":{"end":{"line":1223,"character":9999},"start":{"character":0,"line":1219}},"definition":"sub","name":"_dump_base_accuracies","containerName":"main::"},{"name":"%self","containerName":null,"line":1223,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1223},{"line":1223,"kind":13,"name":"%self","containerName":null},{"localvar":"my","containerName":null,"name":"$number_traces","definition":"my","line":1224,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":1224},{"kind":13,"line":1225,"name":"$counter","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$counter","kind":13,"line":1225},{"containerName":null,"name":"$number_traces","kind":13,"line":1225},{"name":"%counter","containerName":null,"line":1225,"kind":13},{"kind":13,"line":1227,"name":"%self","containerName":null},{"line":1227,"kind":13,"name":"$counter","containerName":null},{"kind":13,"line":1228,"containerName":null,"name":"%self"},{"name":"$counter","containerName":null,"line":1228,"kind":13},{"kind":13,"line":1229,"name":"%self","containerName":null},{"kind":13,"line":1229,"containerName":null,"name":"$counter"},{"containerName":null,"name":"%self","line":1230,"kind":13},{"name":"$counter","containerName":null,"kind":13,"line":1230},{"range":{"end":{"character":9999,"line":1254},"start":{"character":0,"line":1246}},"containerName":"main::","definition":"sub","name":"_dump_peak_indices_incoming","line":1246,"children":[{"line":1247,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_dump_peak_indices_incoming"},{"localvar":"my","definition":"my","name":"$length","containerName":"_dump_peak_indices_incoming","line":1249,"kind":13},{"containerName":"_dump_peak_indices_incoming","name":"$self","kind":13,"line":1249},{"definition":"my","name":"$count","containerName":"_dump_peak_indices_incoming","localvar":"my","kind":13,"line":1251},{"line":1251,"kind":13,"name":"$count","containerName":"_dump_peak_indices_incoming"},{"line":1251,"kind":13,"containerName":"_dump_peak_indices_incoming","name":"$length"},{"kind":13,"line":1251,"containerName":"_dump_peak_indices_incoming","name":"$count"}],"kind":12},{"children":[{"line":1268,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_dump_base_accuracies_incoming"},{"localvar":"my","name":"$number_traces","definition":"my","containerName":"_dump_base_accuracies_incoming","line":1272,"kind":13},{"containerName":"_dump_base_accuracies_incoming","name":"$self","line":1272,"kind":13},{"containerName":"_dump_base_accuracies_incoming","name":"$counter","definition":"my","localvar":"my","kind":13,"line":1273},{"line":1273,"kind":13,"name":"$counter","containerName":"_dump_base_accuracies_incoming"},{"line":1273,"kind":13,"containerName":"_dump_base_accuracies_incoming","name":"$number_traces"},{"kind":13,"line":1273,"containerName":"_dump_base_accuracies_incoming","name":"$counter"},{"kind":13,"line":1276,"containerName":"_dump_base_accuracies_incoming","name":"$self"},{"line":1276,"kind":13,"name":"$counter","containerName":"_dump_base_accuracies_incoming"}],"line":1267,"kind":12,"range":{"end":{"character":9999,"line":1280},"start":{"character":0,"line":1267}},"name":"_dump_base_accuracies_incoming","definition":"sub","containerName":"main::"},{"line":1294,"children":[{"name":"$self","definition":"my","containerName":"_dump_comments","localvar":"my","kind":13,"line":1295},{"localvar":"my","containerName":"_dump_comments","definition":"my","name":"$k","line":1297,"kind":13},{"containerName":"_dump_comments","name":"$self","line":1297,"kind":13}],"kind":12,"detail":"($self)","signature":{"label":"_dump_comments($self)","parameters":[{"label":"$self"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.\n\n\nsub _unpack_magik {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my (@read,$counter);\n    foreach (qw(c C s S i I l L n N v V)) {\n        @read = unpack \"$_$length\", $buffer;\n        for ($counter=0; $counter < 20; $counter++) {\n            print(\"$read[$counter]\\n\");\n        }\n    }\n}\n\n=head2 read_from_buffer($filehandle,$buffer,$length)\n\n Title   : read_from_buffer($filehandle,$buffer,$length)\n Usage   : $self->read_from_buffer($filehandle,$buffer,$length);\n Function: Read from the buffer.\n Returns : $buffer, containing a read of $length\n Args    : a filehandle, a buffer, and a read length\n Notes   : I just got tired of typing\n       \"unless (length($buffer) == $length)\" so I put it here.\n\n\nsub read_from_buffer {\n    my ($self,$fh,$buffer,$length,$start_position) = @_;\n          # print(\"Reading from a buffer!!! length($length) \");\n     if ($start_position) {\n               # print(\" startposition($start_position)(\".sprintf(\"%X\", $start_position).\")\\n\");\n     }\n          # print(\"\\n\");\n     if ($start_position) {\n               # print(\"seeking to this position in the file: (\".$start_position.\")\\n\");\n          seek ($fh,$start_position,0);\n               # print(\"done. here is where I am now: (\".tell($fh).\")\\n\");\n     }\n     else {\n          # print(\"You did not specify a start position. Going from this position (the current position) (\".tell($fh).\")\\n\");\n     }\n    read $fh, $buffer, $length;\n    unless (length($buffer) == $length) {\n        $self->warn(\"The read was incomplete! Trying harder.\");\n        my $missing_length = $length - length($buffer);\n        my $buffer2;\n        read $fh,$buffer2,$missing_length;\n        $buffer .= $buffer2;\n        if (length($buffer) != $length) {\n            $self->throw(\"Unexpected end of file while reading from SCF file. I should have read $length but instead got \".length($buffer).\"! Current file position is \".tell($fh).\".\");\n        }\n    }\n\n    return $buffer;\n}\n\n=head2 _dump_keys()\n\n Title   : _dump_keys()\n Usage   : &_dump_keys($a_reference_to_some_hash)\n Function: Dump out the keys in a hash.\n Returns : Nothing.\n Args    : A reference to a hash.\n Notes   : A debugging method.\n\n\nsub _dump_keys {\n    my $rhash = shift;\n    if ($rhash !~ /HASH/) {\n        print(\"_dump_keys: that was not a hash.\\nIt was #$rhash# which was this reference:\".ref($rhash).\"\\n\");\n        return;\n    }\n    print(\"_dump_keys: The keys for $rhash are:\\n\");\n    foreach (sort keys %$rhash) {\n        print(\"$_\\n\");\n    }\n}\n\n=head2 _dump_base_accuracies()\n\n Title   : _dump_base_accuracies()\n Usage   : $self->_dump_base_accuracies();\n Function: Dump out the v3 base accuracies in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_base_accuracies {\n    my $self = shift;\n    print(\"Dumping base accuracies! for v3\\n\");\n    print(\"There are this many elements in a,c,g,t:\\n\");\n    print(scalar(@{$self->{'text'}->{'v3_base_accuracy_a'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_c'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_g'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_t'}}).\"\\n\");\n    my $number_traces = scalar(@{$self->{'text'}->{'v3_base_accuracy_a'}});\n    for (my $counter=0; $counter < $number_traces; $counter++ ) {\n        print(\"$counter\\t\");\n        print $self->{'text'}->{'v3_base_accuracy_a'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_c'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_g'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_t'}->[$counter].\"\\t\";\n        print(\"\\n\");\n    }\n}\n\n=head2 _dump_peak_indices_incoming()\n\n Title   : _dump_peak_indices_incoming()\n Usage   : $self->_dump_peak_indices_incoming();\n Function: Dump out the v3 peak indices in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_peak_indices_incoming {\n    my $self = shift;\n    print(\"Dump peak indices incoming!\\n\");\n    my $length = $self->{'bases'};\n    print(\"The length is $length\\n\");\n    for (my $count=0; $count < $length; $count++) {\n        print(\"$count\\t$self->{parsed}->{peak_indices}->[$count]\\n\");\n    }\n}\n\n=head2 _dump_base_accuracies_incoming()\n\n Title   : _dump_base_accuracies_incoming()\n Usage   : $self->_dump_base_accuracies_incoming();\n Function: Dump out the v3 base accuracies in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_base_accuracies_incoming {\n    my $self = shift;\n    print(\"Dumping base accuracies! for v3\\n\");\n        # print(\"There are this many elements in a,c,g,t:\\n\");\n        # print(scalar(@{$self->{'parsed'}->{'v3_base_accuracy_a'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_c'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_g'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_t'}}).\"\\n\");\n    my $number_traces = $self->{'bases'};\n    for (my $counter=0; $counter < $number_traces; $counter++ ) {\n        print(\"$counter\\t\");\n        foreach (qw(A T G C)) {\n            print $self->{'parsed'}->{'base_accuracies'}->{$_}->[$counter].\"\\t\";\n        }\n        print(\"\\n\");\n    }\n}\n\n\n=head2 _dump_comments()\n\n Title   : _dump_comments()\n Usage   : $self->_dump_comments();\n Function: Debug dump the comments section from the scf.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : None."},"containerName":"main::","definition":"sub","range":{"end":{"line":1297,"character":9999},"start":{"character":0,"line":1294}},"name":"_dump_comments"},{"containerName":null,"name":"%self","line":1298,"kind":13},{"kind":13,"line":1298,"name":"$k","containerName":null}]}