{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":86},{"containerName":"","name":"base","line":88,"kind":2},{"kind":13,"line":92,"name":"%ATTMAP","containerName":null},{"name":"TSeq_sequence","kind":12,"line":92},{"kind":12,"line":92,"name":"Data"},{"name":"TSeq_gi","line":93,"kind":12},{"name":"Data","kind":12,"line":93},{"kind":12,"line":94,"name":"TSeq_defline"},{"name":"Data","line":94,"kind":12},{"kind":12,"line":95,"name":"TSeq_sid"},{"name":"Data","line":95,"kind":12},{"name":"TSeq_accver","line":96,"kind":12},{"kind":12,"line":96,"name":"Data"},{"kind":12,"line":97,"name":"TSeq_taxid"},{"name":"Data","line":97,"kind":12},{"name":"TSeq_orgname","line":98,"kind":12},{"name":"Data","line":98,"kind":12},{"kind":12,"line":112,"children":[{"kind":13,"line":113,"containerName":"new","definition":"my","name":"$proto","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":113},{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":114,"kind":13},{"line":114,"kind":13,"containerName":"new","name":"$proto"},{"line":114,"kind":13,"name":"$proto","containerName":"new"},{"line":116,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","line":116,"kind":13},{"line":118,"kind":13,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($proto,@args)","signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE","parameters":[{"label":"$proto"},{"label":"@args"}],"label":"new($proto,@args)"},"name":"new","range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":119}}},{"containerName":"main::","definition":"sub","detail":"($self,$doctype)","signature":{"label":"doctype_decl($self,$doctype)","documentation":" Event hadling methods for PerlSax   #","parameters":[{"label":"$self"},{"label":"$doctype"}]},"kind":12,"line":125,"children":[{"kind":13,"line":126,"containerName":"doctype_decl","definition":"my","name":"$self","localvar":"my"},{"containerName":"doctype_decl","name":"$doctype","kind":13,"line":126},{"line":128,"kind":13,"containerName":"doctype_decl","name":"$doctype"},{"line":129,"kind":13,"containerName":"doctype_decl","name":"$self"},{"name":"throw","containerName":"doctype_decl","line":129,"kind":12},{"line":129,"kind":13,"name":"$doctype","containerName":"doctype_decl"}],"name":"doctype_decl","range":{"end":{"character":9999,"line":132},"start":{"character":0,"line":125}}},{"name":"start_document","range":{"start":{"character":0,"line":144},"end":{"line":149,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"}],"label":"start_document($self)"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":145,"containerName":"start_document","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":147,"name":"$self","containerName":"start_document"},{"kind":13,"line":148,"containerName":"start_document","name":"$self"}],"line":144},{"name":"end_document","range":{"start":{"character":0,"line":161},"end":{"line":164,"character":9999}},"kind":12,"line":161,"children":[{"definition":"my","name":"$self","containerName":"end_document","localvar":"my","kind":13,"line":162},{"containerName":"end_document","name":"$self","kind":13,"line":163}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"end_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE"}},{"range":{"start":{"character":0,"line":176},"end":{"line":179,"character":9999}},"name":"start_element","signature":{"label":"start_element($self,$starting)","documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"},{"label":"$starting"}]},"detail":"($self,$starting)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_element","line":177,"kind":13},{"line":177,"kind":13,"containerName":"start_element","name":"$starting"},{"containerName":"start_element","name":"$self","line":179,"kind":13}],"line":176,"kind":12},{"containerName":null,"name":"$starting","line":179,"kind":13},{"name":"end_element","range":{"end":{"character":9999,"line":198},"start":{"line":192,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$ending)","signature":{"label":"end_element($self,$ending)","documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"},{"label":"$ending"}]},"kind":12,"line":192,"children":[{"line":193,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"end_element"},{"kind":13,"line":193,"containerName":"end_element","name":"$ending"},{"localvar":"my","definition":"my","name":"$ename","containerName":"end_element","line":196,"kind":13},{"kind":13,"line":196,"containerName":"end_element","name":"$ending"},{"kind":13,"line":197,"name":"$self","containerName":"end_element"},{"containerName":"end_element","name":"$ename","kind":13,"line":197},{"containerName":"end_element","name":"$self","line":197,"kind":13},{"line":197,"kind":12,"containerName":"end_element","name":"can"},{"line":197,"kind":13,"containerName":"end_element","name":"$ename"}]},{"range":{"end":{"character":9999,"line":219},"start":{"line":210,"character":0}},"name":"characters","children":[{"line":211,"kind":13,"localvar":"my","containerName":"characters","definition":"my","name":"$self"},{"kind":13,"line":211,"containerName":"characters","name":"$characters"},{"kind":13,"line":213,"containerName":"characters","name":"$data","definition":"my","localvar":"my"},{"kind":13,"line":213,"name":"$characters","containerName":"characters"},{"containerName":"characters","name":"$data","kind":13,"line":215},{"name":"$data","containerName":"characters","line":215,"kind":13},{"line":217,"kind":13,"localvar":"my","definition":"my","name":"$current","containerName":"characters"},{"name":"$self","containerName":"characters","kind":13,"line":217},{"containerName":"characters","name":"_current_element","line":217,"kind":12},{"containerName":"characters","name":"$current","kind":13,"line":218},{"kind":13,"line":218,"containerName":"characters","name":"$data"}],"line":210,"kind":12,"signature":{"label":"characters($self,$characters)","parameters":[{"label":"$self"},{"label":"$characters"}],"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE"},"detail":"($self,$characters)","definition":"sub","containerName":"main::"},{"name":"TSeq","range":{"start":{"line":237,"character":0},"end":{"character":9999,"line":243}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub characters {\n    my ($self, $characters) = @_;\n\n    my $data = $characters->{'Data'};\n\n    return unless (defined($data) and $data =~ /\\S/);\n\n    my $current = $self->_current_element;\n    $current->{'Data'} = $data;\n}\n\n\n###########################################\n# Element-specific handlers\n# called at END of element name\n##########################################\n\n=head2 TSeq\n\n  Title\t\t: TSeq\n  Usage\t\t: NONE\n  Function\t: event handler for END of a TSeq element\n  Returns\t: loh of parsed sequence atts for Bio::SeqIO::tinyseq\n  Args\t\t: NONE","parameters":[{"label":"$self"}],"label":"TSeq($self)"},"kind":12,"line":237,"children":[{"kind":13,"line":238,"containerName":"TSeq","definition":"my","name":"$self","localvar":"my"},{"line":240,"kind":13,"localvar":"my","definition":"my","name":"%seqatts","containerName":"TSeq"},{"kind":13,"line":243,"definition":"my","name":"$element","containerName":"TSeq","localvar":"my"},{"name":"$self","containerName":"TSeq","kind":13,"line":243}]},{"containerName":null,"name":"$element_name","definition":"my","localvar":"my","kind":13,"line":244},{"name":"%element","containerName":null,"line":244,"kind":13},{"kind":13,"line":245,"name":"$element_name","containerName":null},{"localvar":"my","containerName":null,"name":"$conversion","definition":"my","line":247,"kind":13},{"name":"%ATTMAP","containerName":null,"kind":13,"line":247},{"line":247,"kind":13,"name":"$element_name","containerName":null},{"kind":13,"line":249,"definition":"my","name":"$element_att","containerName":null,"localvar":"my"},{"name":"$pseq_att","containerName":null,"kind":13,"line":249},{"name":"%conversion","containerName":null,"line":249,"kind":13},{"kind":13,"line":250,"name":"%seqatts","containerName":null},{"containerName":null,"name":"$pseq_att","kind":13,"line":250},{"containerName":null,"name":"%element","kind":13,"line":250},{"containerName":null,"name":"$element_att","kind":13,"line":250},{"line":254,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":254,"containerName":null,"name":"%seqatts"},{"line":272,"children":[{"line":273,"kind":13,"localvar":"my","containerName":"_current_element","definition":"my","name":"$self"},{"kind":13,"line":274,"containerName":"_current_element","name":"$self"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub characters {\n    my ($self, $characters) = @_;\n\n    my $data = $characters->{'Data'};\n\n    return unless (defined($data) and $data =~ /\\S/);\n\n    my $current = $self->_current_element;\n    $current->{'Data'} = $data;\n}\n\n\n###########################################\n# Element-specific handlers\n# called at END of element name\n##########################################\n\n=head2 TSeq\n\n  Title\t\t: TSeq\n  Usage\t\t: NONE\n  Function\t: event handler for END of a TSeq element\n  Returns\t: loh of parsed sequence atts for Bio::SeqIO::tinyseq\n  Args\t\t: NONE\n\n\nsub TSeq {\n    my ($self) = @_;\n\n    my %seqatts;\n\n    # map elements onto PrimarySeq keys\n    while (my $element = pop @{ $self->{'_elements'} }) {\n\tmy $element_name = $element->{'Name'};\n\tlast if ($element_name eq 'TSeq');\n\n\tmy $conversion = $ATTMAP{$element_name} or next;\n\n\twhile(my($element_att, $pseq_att) = each %$conversion) {\n\t    $seqatts{$pseq_att} = $element->{$element_att};\n\t}\n    }\n\n    push(@{ $self->{'_seqatts'} }, \\%seqatts);\n\n}\n\n#############################################\n# Utility method to return current element info\n##############################################\n\n=head2 _current_element\n\n  Title\t\t: _current_element\n  Usage\t\t: Internal method\n  Function\t: Utility method to return current element info\n  Returns\t: XML::Parser::PerlSAX hash for current element\n  Args\t\t: NONE","parameters":[{"label":"$self"}],"label":"_current_element($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":272},"end":{"character":9999,"line":275}},"name":"_current_element"}]}