{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":116},{"line":126,"kind":13,"localvar":"my","name":"%MODE","definition":"my","containerName":null},{"containerName":"URI::HTTP::Request::Bio::Root","name":"IO","line":126,"kind":2},{"line":175,"kind":13,"localvar":"my","containerName":null,"name":"@PARAMS","definition":"my"},{"line":180,"kind":13,"containerName":null,"name":"@PARAMS"},{"kind":13,"line":184,"name":"$method","definition":"my","containerName":null,"localvar":"my"},{"line":184,"kind":13,"containerName":null,"name":"@PARAMS"},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub","line":201,"children":[{"kind":13,"line":202,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":202},{"kind":13,"line":203,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":203,"kind":13,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":203},{"definition":"my","name":"$retmode","containerName":"new","localvar":"my","kind":13,"line":204},{"line":204,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":204,"containerName":"new","name":"_rearrange"},{"kind":13,"line":204,"containerName":"new","name":"@args"},{"line":205,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":205,"containerName":"new","name":"_set_from_args"},{"kind":13,"line":205,"name":"@args","containerName":"new"},{"name":"@PARAMS","containerName":"new","line":206,"kind":13},{"kind":13,"line":207,"name":"$self","containerName":"new"},{"kind":12,"line":207,"containerName":"new","name":"eutil"},{"name":"$self","containerName":"new","kind":13,"line":207},{"kind":12,"line":207,"name":"eutil","containerName":"new"},{"containerName":"new","name":"$self","line":208,"kind":13},{"kind":12,"line":208,"name":"tool","containerName":"new"},{"kind":13,"line":208,"name":"$self","containerName":"new"},{"kind":12,"line":208,"containerName":"new","name":"tool"},{"line":210,"kind":13,"containerName":"new","name":"$self"},{"line":210,"kind":12,"name":"set_default_retmode","containerName":"new"},{"name":"$retmode","containerName":"new","kind":13,"line":210},{"name":"$self","containerName":"new","line":211,"kind":13},{"name":"$self","containerName":"new","line":212,"kind":13}],"kind":12,"range":{"start":{"line":201,"character":0},"end":{"character":9999,"line":213}},"name":"new"},{"kind":12,"line":203,"containerName":"new","name":"SUPER"},{"signature":{"label":"set_parameters($self,@args)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":240,"kind":13,"localvar":"my","containerName":"set_parameters","definition":"my","name":"$self"},{"kind":13,"line":240,"name":"@args","containerName":"set_parameters"},{"line":242,"kind":13,"localvar":"my","containerName":"set_parameters","name":"$newmode","definition":"my"},{"line":242,"kind":13,"name":"$file","containerName":"set_parameters"},{"containerName":"set_parameters","name":"$self","line":242,"kind":13},{"line":242,"kind":12,"name":"_rearrange","containerName":"set_parameters"},{"name":"@args","containerName":"set_parameters","kind":13,"line":242},{"line":243,"kind":13,"containerName":"set_parameters","name":"$self"},{"line":243,"kind":12,"name":"_set_from_args","containerName":"set_parameters"},{"containerName":"set_parameters","name":"@args","line":243,"kind":13},{"name":"@PARAMS","containerName":"set_parameters","line":243,"kind":13},{"line":245,"kind":13,"name":"$self","containerName":"set_parameters"},{"name":"set_default_retmode","containerName":"set_parameters","kind":12,"line":245},{"name":"$newmode","containerName":"set_parameters","line":245,"kind":13},{"name":"$file","containerName":"set_parameters","kind":13,"line":246},{"line":246,"kind":13,"containerName":"set_parameters","name":"$self"},{"name":"id_file","containerName":"set_parameters","line":246,"kind":12},{"line":246,"kind":13,"containerName":"set_parameters","name":"$file"}],"line":239,"kind":12,"range":{"start":{"character":0,"line":239},"end":{"character":9999,"line":248}},"name":"set_parameters"},{"name":"reset_parameters","range":{"end":{"line":282,"character":9999},"start":{"line":272,"character":0}},"kind":12,"line":272,"children":[{"kind":13,"line":273,"name":"$self","definition":"my","containerName":"reset_parameters","localvar":"my"},{"containerName":"reset_parameters","name":"@args","line":273,"kind":13},{"line":275,"kind":13,"localvar":"my","containerName":"reset_parameters","name":"$retmode","definition":"my"},{"containerName":"reset_parameters","name":"$file","kind":13,"line":275},{"line":275,"kind":13,"containerName":"reset_parameters","name":"$self"},{"kind":12,"line":275,"containerName":"reset_parameters","name":"_rearrange"},{"containerName":"reset_parameters","name":"@args","kind":13,"line":275},{"containerName":"reset_parameters","name":"$self","kind":13,"line":276},{"kind":13,"line":276,"name":"$self","containerName":"reset_parameters"},{"name":"@PARAMS","containerName":"reset_parameters","line":276,"kind":13},{"name":"$self","containerName":"reset_parameters","line":277,"kind":13},{"line":277,"kind":12,"containerName":"reset_parameters","name":"_set_from_args"},{"line":277,"kind":13,"containerName":"reset_parameters","name":"@args"},{"line":277,"kind":13,"containerName":"reset_parameters","name":"@PARAMS"},{"name":"$self","containerName":"reset_parameters","kind":13,"line":278},{"name":"eutil","containerName":"reset_parameters","kind":12,"line":278},{"kind":13,"line":278,"containerName":"reset_parameters","name":"$self"},{"containerName":"reset_parameters","name":"eutil","kind":12,"line":278},{"line":279,"kind":13,"containerName":"reset_parameters","name":"$self"},{"kind":12,"line":279,"containerName":"reset_parameters","name":"set_default_retmode"},{"line":279,"kind":13,"containerName":"reset_parameters","name":"$retmode"},{"containerName":"reset_parameters","name":"$file","kind":13,"line":280},{"kind":13,"line":280,"name":"$self","containerName":"reset_parameters"},{"kind":12,"line":280,"containerName":"reset_parameters","name":"id_file"},{"containerName":"reset_parameters","name":"$file","line":280,"kind":13},{"kind":13,"line":281,"containerName":"reset_parameters","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"reset_parameters($self,@args)"}},{"range":{"end":{"character":9999,"line":297},"start":{"line":294,"character":0}},"name":"parameters_changed","detail":"($self)","signature":{"label":"parameters_changed($self)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":294,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"parameters_changed","line":295,"kind":13},{"line":296,"kind":13,"name":"$self","containerName":"parameters_changed"}],"kind":12},{"range":{"start":{"line":310,"character":0},"end":{"character":9999,"line":318}},"name":"available_parameters","children":[{"kind":13,"line":311,"containerName":"available_parameters","name":"$self","definition":"my","localvar":"my"},{"line":311,"kind":13,"name":"$type","containerName":"available_parameters"},{"kind":13,"line":312,"containerName":"available_parameters","name":"$type"},{"name":"$type","containerName":"available_parameters","line":313,"kind":13},{"name":"@PARAMS","containerName":"available_parameters","kind":13,"line":314},{"kind":13,"line":316,"name":"$self","containerName":"available_parameters"},{"kind":12,"line":316,"containerName":"available_parameters","name":"throw"},{"line":316,"kind":13,"containerName":"available_parameters","name":"$MODE"},{"line":316,"kind":13,"containerName":"available_parameters","name":"$type"},{"containerName":"available_parameters","name":"$MODE","line":317,"kind":13},{"kind":13,"line":317,"name":"$type","containerName":"available_parameters"}],"line":310,"kind":12,"signature":{"label":"available_parameters($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)"},"detail":"($self,$type)","definition":"sub","containerName":"main::"},{"line":317,"kind":12,"name":"params"},{"range":{"start":{"character":0,"line":338},"end":{"line":343,"character":9999}},"name":"get_parameters","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)","label":"get_parameters($self,@args)"},"containerName":"main::","definition":"sub","line":338,"children":[{"name":"$self","definition":"my","containerName":"get_parameters","localvar":"my","kind":13,"line":339},{"containerName":"get_parameters","name":"@args","kind":13,"line":339},{"kind":13,"line":340,"containerName":"get_parameters","definition":"my","name":"$type","localvar":"my"},{"name":"$list","containerName":"get_parameters","line":340,"kind":13},{"line":340,"kind":13,"containerName":"get_parameters","name":"$join"},{"line":340,"kind":13,"containerName":"get_parameters","name":"$self"},{"line":340,"kind":12,"containerName":"get_parameters","name":"_rearrange"},{"kind":13,"line":340,"containerName":"get_parameters","name":"@args"},{"containerName":"get_parameters","name":"$self","kind":13,"line":341},{"containerName":"get_parameters","name":"throw","line":341,"kind":12},{"name":"$list","containerName":"get_parameters","line":341,"kind":13},{"line":341,"kind":13,"containerName":"get_parameters","name":"$list"},{"name":"$type","containerName":"get_parameters","kind":13,"line":342},{"localvar":"my","definition":"my","name":"@final","containerName":"get_parameters","line":343,"kind":13},{"line":343,"kind":13,"containerName":"get_parameters","name":"$list"},{"kind":13,"line":343,"containerName":"get_parameters","name":"$self"},{"kind":12,"line":343,"containerName":"get_parameters","name":"can"},{"name":"$list","containerName":"get_parameters","kind":13,"line":343}],"kind":12},{"name":"$self","containerName":null,"kind":13,"line":343},{"name":"available_parameters","containerName":"main::","kind":12,"line":343},{"containerName":null,"name":"$type","kind":13,"line":343},{"kind":13,"line":344,"containerName":null,"name":"@p","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$param","containerName":null,"line":345,"kind":13},{"line":345,"kind":13,"name":"@final","containerName":null},{"containerName":null,"name":"$param","kind":13,"line":346},{"line":346,"kind":13,"name":"$self","containerName":null},{"name":"id","containerName":"main::","line":346,"kind":12},{"kind":13,"line":346,"containerName":null,"name":"%join"},{"line":347,"kind":13,"localvar":"my","name":"$id","definition":"my","containerName":null},{"line":347,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"id","kind":12,"line":347},{"kind":13,"line":348,"containerName":null,"name":"$self"},{"containerName":"main::","name":"correspondence","kind":12,"line":348},{"name":"$self","containerName":null,"line":348,"kind":13},{"kind":12,"line":348,"name":"eutil","containerName":"main::"},{"localvar":"my","definition":"my","name":"$id_group","containerName":null,"line":349,"kind":13},{"name":"%id","containerName":null,"line":349,"kind":13},{"line":350,"kind":13,"containerName":null,"name":"%id_group"},{"containerName":null,"name":"@p","kind":13,"line":351},{"kind":13,"line":351,"containerName":null,"name":"$id_group"},{"kind":13,"line":353,"name":"%id_group","containerName":null},{"kind":13,"line":354,"name":"@p","containerName":null},{"name":"%id_group","containerName":null,"kind":13,"line":354},{"name":"$self","containerName":null,"line":357,"kind":13},{"name":"throw","containerName":"main::","line":357,"kind":12},{"name":"@p","containerName":null,"line":361,"kind":13},{"kind":13,"line":361,"name":"$id","containerName":null},{"containerName":null,"name":"$param","kind":13,"line":362},{"name":"$id","containerName":null,"line":362,"kind":13},{"name":"$param","containerName":null,"kind":13,"line":363},{"line":363,"kind":13,"name":"$id","containerName":null},{"containerName":null,"name":"$param","kind":13,"line":366},{"containerName":null,"name":"$self","line":366,"kind":13},{"line":366,"kind":12,"name":"db","containerName":"main::"},{"line":366,"kind":13,"containerName":null,"name":"%join"},{"definition":"my","name":"$db","containerName":null,"localvar":"my","kind":13,"line":367},{"name":"$self","containerName":null,"line":367,"kind":13},{"name":"db","containerName":"main::","kind":12,"line":367},{"containerName":null,"name":"@p","line":368,"kind":13},{"line":368,"kind":13,"name":"$db","containerName":null},{"name":"$param","containerName":null,"line":369,"kind":13},{"name":"$db","containerName":null,"line":369,"kind":13},{"name":"$param","containerName":null,"kind":13,"line":370},{"containerName":null,"name":"%db","line":370,"kind":13},{"kind":13,"line":373,"containerName":null,"name":"@p"},{"containerName":null,"name":"$param","kind":13,"line":373},{"containerName":null,"name":"%self","line":373,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":373},{"name":"@p","containerName":null,"kind":13,"line":376},{"name":"to_string","range":{"end":{"line":403,"character":9999},"start":{"line":394,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"to_string($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":395,"definition":"my","name":"$self","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"@args","kind":13,"line":395},{"line":397,"kind":13,"containerName":"to_string","name":"$self"},{"name":"parameters_changed","containerName":"to_string","line":397,"kind":12},{"containerName":"to_string","name":"$self","kind":13,"line":397},{"kind":13,"line":398,"containerName":"to_string","definition":"my","name":"$string","localvar":"my"},{"containerName":"to_string","name":"$self","line":398,"kind":13},{"line":398,"kind":12,"name":"to_request","containerName":"to_string"},{"kind":13,"line":398,"name":"@args","containerName":"to_string"},{"line":398,"kind":12,"name":"uri","containerName":"to_string"},{"kind":12,"line":398,"containerName":"to_string","name":"as_string"},{"line":399,"kind":13,"containerName":"to_string","name":"$self"},{"kind":13,"line":400,"containerName":"to_string","name":"$self"},{"line":400,"kind":13,"name":"$string","containerName":"to_string"},{"line":402,"kind":13,"name":"$self","containerName":"to_string"}],"line":394},{"range":{"start":{"line":418,"character":0},"end":{"line":445,"character":9999}},"name":"to_request","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"to_request","line":419,"kind":13},{"containerName":"to_request","name":"$type","kind":13,"line":419},{"line":420,"kind":13,"name":"$self","containerName":"to_request"},{"line":420,"kind":12,"containerName":"to_request","name":"parameters_changed"},{"containerName":"to_request","name":"$self","kind":13,"line":420},{"line":421,"kind":13,"localvar":"my","definition":"my","name":"$eutil","containerName":"to_request"},{"containerName":"to_request","name":"$self","line":421,"kind":13},{"containerName":"to_request","name":"eutil","line":421,"kind":12},{"line":422,"kind":13,"containerName":"to_request","name":"$self"},{"name":"throw","containerName":"to_request","kind":12,"line":422},{"line":422,"kind":13,"containerName":"to_request","name":"$eutil"},{"line":424,"kind":13,"name":"$type","containerName":"to_request"},{"line":424,"kind":13,"containerName":"to_request","name":"$eutil"},{"kind":13,"line":425,"name":"$location","definition":"my","containerName":"to_request","localvar":"my"},{"containerName":"to_request","name":"$mode","line":425,"kind":13},{"name":"$MODE","containerName":"to_request","kind":13,"line":425},{"line":425,"kind":13,"name":"$eutil","containerName":"to_request"},{"containerName":"to_request","name":"$MODE","kind":13,"line":425},{"kind":13,"line":425,"containerName":"to_request","name":"$eutil"},{"name":"$request","definition":"my","containerName":"to_request","localvar":"my","kind":13,"line":426},{"kind":13,"line":427,"definition":"my","name":"$uri","containerName":"to_request","localvar":"my"},{"containerName":"to_request","name":"new","kind":12,"line":427},{"containerName":"to_request","name":"$self","line":427,"kind":13},{"containerName":"to_request","name":"url_base_address","line":427,"kind":12},{"containerName":"to_request","name":"$location","kind":13,"line":427},{"name":"$mode","containerName":"to_request","line":428,"kind":13},{"kind":13,"line":429,"name":"$uri","containerName":"to_request"},{"kind":12,"line":429,"name":"query_form","containerName":"to_request"},{"containerName":"to_request","name":"$self","kind":13,"line":429},{"line":429,"kind":12,"name":"get_parameters","containerName":"to_request"},{"name":"$type","containerName":"to_request","line":429,"kind":13},{"line":430,"kind":13,"containerName":"to_request","name":"$request"},{"name":"new","containerName":"to_request","line":430,"kind":12},{"kind":13,"line":430,"containerName":"to_request","name":"$mode"},{"name":"$uri","containerName":"to_request","kind":13,"line":430},{"name":"$self","containerName":"to_request","kind":13,"line":431},{"containerName":"to_request","name":"$request","kind":13,"line":431},{"line":432,"kind":13,"name":"$mode","containerName":"to_request"},{"name":"$request","containerName":"to_request","line":433,"kind":13},{"kind":12,"line":433,"name":"new","containerName":"to_request"},{"containerName":"to_request","name":"$mode","line":433,"kind":13},{"name":"$uri","containerName":"to_request","line":433,"kind":13},{"name":"as_string","containerName":"to_request","kind":12,"line":433},{"containerName":"to_request","name":"$uri","line":434,"kind":13},{"kind":12,"line":434,"name":"query_form","containerName":"to_request"},{"containerName":"to_request","name":"$self","kind":13,"line":434},{"kind":12,"line":434,"name":"get_parameters","containerName":"to_request"},{"kind":13,"line":434,"name":"$type","containerName":"to_request"},{"name":"$request","containerName":"to_request","kind":13,"line":435},{"containerName":"to_request","name":"content_type","kind":12,"line":435},{"containerName":"to_request","name":"$request","kind":13,"line":436},{"line":436,"kind":12,"containerName":"to_request","name":"content"},{"name":"$uri","containerName":"to_request","line":436,"kind":13},{"containerName":"to_request","name":"query","line":436,"kind":12},{"line":437,"kind":13,"name":"$self","containerName":"to_request"},{"kind":13,"line":437,"name":"$request","containerName":"to_request"},{"name":"$self","containerName":"to_request","kind":13,"line":439},{"kind":12,"line":439,"name":"throw","containerName":"to_request"},{"line":441,"kind":13,"containerName":"to_request","name":"$self"},{"name":"$self","containerName":"to_request","kind":13,"line":442},{"name":"$request","containerName":"to_request","kind":13,"line":442},{"containerName":"to_request","name":"$self","kind":13,"line":444}],"line":418,"kind":12,"signature":{"label":"to_request($self,$type)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST","parameters":[{"label":"$self"},{"label":"$type"}]},"detail":"($self,$type)","definition":"sub","containerName":"main::"},{"name":"location","line":425,"kind":12},{"name":"mode","line":425,"kind":12},{"kind":12,"line":427,"name":"URI"},{"line":430,"kind":12,"containerName":"Request","name":"HTTP"},{"kind":12,"line":433,"name":"HTTP","containerName":"Request"},{"line":461,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"eutil","line":462,"kind":13},{"kind":13,"line":462,"name":"$eutil","containerName":"eutil"},{"line":463,"kind":13,"containerName":"eutil","name":"$eutil"},{"kind":13,"line":464,"containerName":"eutil","name":"$self"},{"containerName":"eutil","name":"throw","line":464,"kind":12},{"line":464,"kind":13,"containerName":"eutil","name":"$MODE"},{"name":"$eutil","containerName":"eutil","line":464,"kind":13},{"line":465,"kind":13,"name":"$self","containerName":"eutil"},{"name":"$self","containerName":"eutil","kind":13,"line":465},{"containerName":"eutil","name":"$self","kind":13,"line":465},{"kind":13,"line":465,"containerName":"eutil","name":"$eutil"},{"containerName":"eutil","name":"$self","line":466,"kind":13},{"containerName":"eutil","name":"$eutil","kind":13,"line":466},{"line":467,"kind":13,"name":"$self","containerName":"eutil"},{"kind":13,"line":470,"containerName":"eutil","name":"$self"}],"kind":12,"detail":"($self,$eutil)","signature":{"label":"eutil($self,$eutil)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.","parameters":[{"label":"$self"},{"label":"$eutil"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":471},"start":{"line":461,"character":0}},"name":"eutil"},{"signature":{"label":"history($self,$history)","parameters":[{"label":"$self"},{"label":"$history"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set"},"detail":"($self,$history)","definition":"sub","containerName":"main::","children":[{"line":487,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"history"},{"kind":13,"line":487,"containerName":"history","name":"$history"},{"kind":13,"line":488,"name":"$history","containerName":"history"},{"containerName":"history","name":"$self","line":489,"kind":13},{"line":489,"kind":12,"containerName":"history","name":"throw"},{"containerName":"history","name":"$history","line":490,"kind":13},{"line":490,"kind":12,"containerName":"history","name":"isa"},{"containerName":"history","definition":"my","name":"$webenv","localvar":"my","kind":13,"line":491},{"name":"$qkey","containerName":"history","line":491,"kind":13},{"name":"$history","containerName":"history","line":491,"kind":13},{"kind":12,"line":491,"containerName":"history","name":"history"},{"name":"$self","containerName":"history","kind":13,"line":492},{"name":"WebEnv","containerName":"history","line":492,"kind":12},{"kind":13,"line":492,"containerName":"history","name":"$webenv"},{"line":493,"kind":13,"containerName":"history","name":"$self"},{"name":"query_key","containerName":"history","line":493,"kind":12},{"name":"$qkey","containerName":"history","line":493,"kind":13},{"name":"$self","containerName":"history","line":494,"kind":13},{"kind":13,"line":495,"containerName":"history","name":"$self"},{"line":495,"kind":13,"containerName":"history","name":"$history"},{"kind":13,"line":497,"containerName":"history","name":"$self"}],"line":486,"kind":12,"range":{"end":{"character":9999,"line":498},"start":{"line":486,"character":0}},"name":"history"},{"signature":{"label":"correspondence($self,$corr)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set\n\n\nsub history {\n    my ($self, $history) = @_;\n    if ($history) {\n        $self->throw('Not a Bio::Tools::EUtilities::HistoryI object!') if\n            !$history->isa('Bio::Tools::EUtilities::HistoryI');\n        my ($webenv, $qkey) = $history->history;\n        $self->WebEnv($webenv);\n        $self->query_key($qkey);\n        $self->{'_statechange'} = 1;\n        $self->{'_history_cache'} = $history;\n    }\n    return $self->{'_history_cache'};\n}\n\n=head2 correspondence\n\n Title   : correspondence\n Usage   : $p->correspondence(1);\n Function: Sets flag for posting IDs for one-to-one correspondence\n Returns : Boolean\n Args    : [optional] boolean value","parameters":[{"label":"$self"},{"label":"$corr"}]},"detail":"($self,$corr)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":511,"containerName":"correspondence","name":"$self","definition":"my","localvar":"my"},{"name":"$corr","containerName":"correspondence","line":511,"kind":13},{"name":"$corr","containerName":"correspondence","line":512,"kind":13},{"name":"$self","containerName":"correspondence","line":513,"kind":13},{"kind":13,"line":513,"name":"$corr","containerName":"correspondence"},{"containerName":"correspondence","name":"$self","line":514,"kind":13},{"kind":13,"line":516,"name":"$self","containerName":"correspondence"}],"line":510,"kind":12,"range":{"end":{"character":9999,"line":517},"start":{"line":510,"character":0}},"name":"correspondence"},{"signature":{"label":"id_file($self,$file)","parameters":[{"label":"$self"},{"label":"$file"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set\n\n\nsub history {\n    my ($self, $history) = @_;\n    if ($history) {\n        $self->throw('Not a Bio::Tools::EUtilities::HistoryI object!') if\n            !$history->isa('Bio::Tools::EUtilities::HistoryI');\n        my ($webenv, $qkey) = $history->history;\n        $self->WebEnv($webenv);\n        $self->query_key($qkey);\n        $self->{'_statechange'} = 1;\n        $self->{'_history_cache'} = $history;\n    }\n    return $self->{'_history_cache'};\n}\n\n=head2 correspondence\n\n Title   : correspondence\n Usage   : $p->correspondence(1);\n Function: Sets flag for posting IDs for one-to-one correspondence\n Returns : Boolean\n Args    : [optional] boolean value\n\n\nsub correspondence {\n    my ($self, $corr) = @_;\n    if (defined $corr) {\n        $self->{'_correspondence'} = $corr;\n        $self->{'_statechange'} = 1;\n    }\n    return $self->{'_correspondence'};\n}\n\n=head2 id_file\n\n Title   : id_file\n Usage   : $p->id_file('<foo');\n Function: convenience method; passes in file containing a list of IDs for\n           searches (one per line), sets id() to list\n Returns : none\n Args    : either string indicating file to use, a file handle, or an IO::Handle\n           object\n Note    : use of this overrides concurrent use of the '-id' parameter when both\n           are passed.  The filename is not retained, merely parsed for IDs."},"detail":"($self,$file)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"id_file","name":"$self","definition":"my","line":534,"kind":13},{"line":534,"kind":13,"containerName":"id_file","name":"$file"},{"line":535,"kind":13,"containerName":"id_file","name":"$file"},{"line":537,"kind":13,"localvar":"my","name":"$io","definition":"my","containerName":"id_file"},{"containerName":"id_file","name":"$self","line":537,"kind":13},{"line":537,"kind":12,"containerName":"id_file","name":"_io"},{"name":"$io","containerName":"id_file","line":538,"kind":13},{"line":538,"kind":12,"containerName":"id_file","name":"_initialize_io"},{"containerName":"id_file","name":"$file","line":538,"kind":13},{"kind":13,"line":539,"definition":"my","name":"@ids","containerName":"id_file","localvar":"my"},{"kind":13,"line":540,"definition":"my","name":"$line","containerName":"id_file","localvar":"my"},{"containerName":"id_file","name":"$io","kind":13,"line":540},{"name":"_readline","containerName":"id_file","line":540,"kind":12},{"containerName":"id_file","name":"$line","kind":13,"line":541},{"name":"@ids","containerName":"id_file","line":542,"kind":13},{"name":"$line","containerName":"id_file","kind":13,"line":542},{"line":544,"kind":13,"containerName":"id_file","name":"$self"},{"name":"_io","containerName":"id_file","kind":12,"line":544},{"line":544,"kind":12,"name":"close","containerName":"id_file"},{"kind":13,"line":545,"name":"$self","containerName":"id_file"},{"kind":12,"line":545,"name":"id","containerName":"id_file"},{"line":545,"kind":13,"name":"@ids","containerName":"id_file"}],"line":533,"kind":12,"range":{"start":{"character":0,"line":533},"end":{"character":9999,"line":547}},"name":"id_file"},{"containerName":null,"name":"$HOSTBASE","definition":"my","localvar":"my","kind":13,"line":560},{"name":"url_base_address","range":{"start":{"character":0,"line":562},"end":{"line":565,"character":9999}},"kind":12,"children":[{"line":563,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"url_base_address"},{"name":"$address","containerName":"url_base_address","line":563,"kind":13},{"line":564,"kind":13,"name":"$HOSTBASE","containerName":"url_base_address"}],"line":562,"definition":"sub","containerName":"main::","signature":{"label":"url_base_address($self,$address)","documentation":"","parameters":[{"label":"$self"},{"label":"$address"}]},"detail":"($self,$address)"},{"line":581,"kind":13,"localvar":"my","name":"%NCBI_DATABASE","definition":"my","containerName":null},{"line":593,"children":[{"kind":13,"line":594,"definition":"my","name":"$self","containerName":"set_default_retmode","localvar":"my"},{"line":595,"kind":13,"containerName":"set_default_retmode","name":"$self"},{"name":"eutil","containerName":"set_default_retmode","line":595,"kind":12},{"line":596,"kind":13,"localvar":"my","containerName":"set_default_retmode","definition":"my","name":"$db"},{"line":596,"kind":13,"containerName":"set_default_retmode","name":"$self"},{"name":"db","containerName":"set_default_retmode","kind":12,"line":596},{"name":"$mode","definition":"my","containerName":"set_default_retmode","localvar":"my","kind":13,"line":597},{"name":"$NCBI_DATABASE","containerName":"set_default_retmode","line":597,"kind":13},{"line":597,"kind":13,"name":"$db","containerName":"set_default_retmode"},{"containerName":"set_default_retmode","name":"$NCBI_DATABASE","line":597,"kind":13},{"containerName":"set_default_retmode","name":"$db","line":597,"kind":13},{"containerName":"set_default_retmode","name":"$self","kind":13,"line":598},{"line":598,"kind":12,"containerName":"set_default_retmode","name":"retmode"},{"kind":13,"line":598,"containerName":"set_default_retmode","name":"$mode"},{"name":"$self","containerName":"set_default_retmode","kind":13,"line":600},{"containerName":"set_default_retmode","name":"retmode","line":600,"kind":12}],"kind":12,"range":{"start":{"character":0,"line":593},"end":{"line":602,"character":9999}},"containerName":"main::","definition":"sub","name":"set_default_retmode"},{"range":{"end":{"character":9999,"line":611},"start":{"line":605,"character":0}},"containerName":"main::","name":"_io","definition":"sub","line":605,"children":[{"line":606,"kind":13,"localvar":"my","containerName":"_io","name":"$self","definition":"my"},{"line":607,"kind":13,"name":"$self","containerName":"_io"},{"name":"$self","containerName":"_io","kind":13,"line":608},{"line":608,"kind":12,"name":"new","containerName":"_io"},{"line":610,"kind":13,"containerName":"_io","name":"$self"}],"kind":12},{"containerName":"Root::IO","name":"Bio","line":608,"kind":12}]}