{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":97},{"name":"_initialize_state","range":{"end":{"line":111,"character":9999},"start":{"character":0,"line":99}},"kind":12,"children":[{"kind":13,"line":100,"containerName":"_initialize_state","name":"$self","definition":"my","localvar":"my"},{"containerName":"_initialize_state","name":"@args","kind":13,"line":100},{"line":103,"kind":13,"localvar":"my","definition":"my","name":"$make","containerName":"_initialize_state"},{"line":103,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"@args","containerName":"_initialize_state","kind":13,"line":103},{"line":108,"kind":13,"containerName":"_initialize_state","name":"$self"},{"line":110,"kind":13,"name":"$self","containerName":"_initialize_state"}],"line":99,"definition":"sub","containerName":"main::","signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)"},{"line":103,"kind":12,"name":"SUPER","containerName":"_initialize_state"},{"range":{"start":{"line":124,"character":0},"end":{"character":9999,"line":131}},"name":"analysis_method","line":124,"children":[{"line":126,"kind":13,"localvar":"my","containerName":"analysis_method","name":"$self","definition":"my"},{"kind":13,"line":126,"containerName":"analysis_method","name":"$method"},{"line":127,"kind":13,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","line":127,"kind":13},{"containerName":"analysis_method","name":"$self","line":128,"kind":13},{"containerName":"analysis_method","name":"throw","line":128,"kind":12},{"line":128,"kind":13,"name":"$self","containerName":"analysis_method"},{"kind":13,"line":130,"name":"$self","containerName":"analysis_method"},{"kind":13,"line":130,"containerName":"analysis_method","name":"$method"}],"kind":12,"detail":"($self,$method)","signature":{"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"analysis_method","line":130,"kind":12},{"name":"next_feature","range":{"end":{"line":162,"character":9999},"start":{"character":0,"line":156}},"definition":"sub","containerName":"main::","signature":{"label":"next_feature($self,@args)","documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":157,"name":"$self","definition":"my","containerName":"next_feature","localvar":"my"},{"name":"@args","containerName":"next_feature","line":157,"kind":13},{"containerName":"next_feature","name":"$self","kind":13,"line":161},{"kind":12,"line":161,"containerName":"next_feature","name":"next_prediction"},{"name":"@args","containerName":"next_feature","kind":13,"line":161}],"line":156},{"line":182,"children":[{"kind":13,"line":183,"name":"$self","definition":"my","containerName":"next_prediction","localvar":"my"},{"localvar":"my","containerName":"next_prediction","name":"$gene","definition":"my","line":184,"kind":13},{"containerName":"next_prediction","name":"$self","line":187,"kind":13},{"name":"_parse_predictions","containerName":"next_prediction","line":187,"kind":12},{"containerName":"next_prediction","name":"$self","kind":13,"line":187},{"kind":12,"line":187,"name":"_predictions_parsed","containerName":"next_prediction"},{"kind":13,"line":190,"containerName":"next_prediction","name":"$self"},{"line":190,"kind":12,"name":"_prediction","containerName":"next_prediction"}],"kind":12,"detail":"($self)","signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":191}},"name":"next_prediction"},{"range":{"start":{"character":0,"line":204},"end":{"line":228,"character":9999}},"name":"_parse_predictions","line":204,"children":[{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$self","line":205,"kind":13},{"line":207,"kind":13,"name":"$self","containerName":"_parse_predictions"},{"kind":12,"line":207,"name":"_readline","containerName":"_parse_predictions"},{"kind":13,"line":210,"containerName":"_parse_predictions","name":"@element","definition":"my","localvar":"my"},{"line":211,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"%feature","definition":"my"},{"name":"$feature","containerName":"_parse_predictions","kind":13,"line":212},{"line":212,"kind":13,"containerName":"_parse_predictions","name":"$element"},{"name":"$feature","containerName":"_parse_predictions","kind":13,"line":213},{"kind":13,"line":213,"containerName":"_parse_predictions","name":"$element"},{"line":214,"kind":13,"containerName":"_parse_predictions","name":"$feature"},{"line":214,"kind":13,"containerName":"_parse_predictions","name":"$element"},{"containerName":"_parse_predictions","name":"$feature","line":215,"kind":13},{"name":"$element","containerName":"_parse_predictions","kind":13,"line":215},{"containerName":"_parse_predictions","name":"$feature","kind":13,"line":216},{"line":216,"kind":13,"containerName":"_parse_predictions","name":"$element"},{"line":217,"kind":13,"containerName":"_parse_predictions","name":"$feature"},{"line":218,"kind":13,"containerName":"_parse_predictions","name":"$feature"},{"kind":13,"line":219,"name":"$feature","containerName":"_parse_predictions"},{"line":220,"kind":13,"containerName":"_parse_predictions","name":"$feature"},{"name":"$self","containerName":"_parse_predictions","line":222,"kind":13},{"containerName":"_parse_predictions","name":"create_feature","kind":12,"line":222},{"containerName":"_parse_predictions","name":"%feature","kind":13,"line":222},{"name":"$self","containerName":"_parse_predictions","line":227,"kind":13},{"kind":12,"line":227,"name":"_predictions_parsed","containerName":"_parse_predictions"}],"kind":12,"detail":"($self)","signature":{"label":"_parse_predictions($self)","documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"kind":12,"line":212,"name":"name"},{"name":"score","kind":12,"line":213},{"name":"start","line":214,"kind":12},{"name":"end","line":215,"kind":12},{"kind":12,"line":216,"name":"strand"},{"line":217,"kind":12,"name":"source"},{"name":"primary","line":218,"kind":12},{"kind":12,"line":219,"name":"program"},{"kind":12,"line":220,"name":"program_version"},{"detail":"($self,$feat)","signature":{"parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none","label":"create_feature($self,$feat)"},"containerName":"main::","definition":"sub","line":240,"children":[{"kind":13,"line":241,"containerName":"create_feature","definition":"my","name":"$self","localvar":"my"},{"containerName":"create_feature","name":"$feat","line":241,"kind":13},{"line":244,"kind":13,"localvar":"my","containerName":"create_feature","definition":"my","name":"$tss"},{"name":"new","containerName":"create_feature","kind":12,"line":245},{"containerName":"create_feature","name":"$feat","line":245,"kind":13},{"line":246,"kind":13,"name":"$feat","containerName":"create_feature"},{"line":247,"kind":13,"containerName":"create_feature","name":"$feat"},{"line":248,"kind":13,"name":"$feat","containerName":"create_feature"},{"kind":13,"line":249,"containerName":"create_feature","name":"$feat"},{"line":250,"kind":13,"containerName":"create_feature","name":"$feat"},{"line":251,"kind":13,"containerName":"create_feature","name":"$feat"},{"kind":13,"line":255,"name":"$tss","containerName":"create_feature"},{"line":257,"kind":13,"name":"$self","containerName":"create_feature"},{"name":"$tss","containerName":"create_feature","line":257,"kind":13}],"kind":12,"range":{"start":{"line":240,"character":0},"end":{"character":9999,"line":258}},"name":"create_feature"},{"line":244,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"_prediction","range":{"end":{"line":281,"character":9999},"start":{"character":0,"line":278}},"kind":12,"line":278,"children":[{"line":279,"kind":13,"localvar":"my","containerName":"_prediction","name":"$self","definition":"my"},{"line":281,"kind":13,"name":"$self","containerName":"_prediction"},{"kind":13,"line":281,"name":"$self","containerName":"_prediction"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_prediction($self)","documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n     #create and fill Bio::EnsEMBL::Seqfeature object\n\n      my $tss = Bio::SeqFeature::Generic->new\n                    (   -seq_id  => $feat->{'name'},\n                        -start   => $feat->{'start'},\n                        -end     => $feat->{'end'},\n                        -strand  => $feat->{'strand'},\n            \t\t-score   => $feat->{'score'},\n                        -source_tag  => $feat->{'source'},\n\t\t        -primary_tag => $feat->{'primary'});\n\n\t\t\n\n  if ($tss) {\n         # add to _flist\n      push(@{$self->{'_flist'}}, $tss);\n   }\n\n   #print $tss->gff_string;\n}\n\t\t\t    \n\n\n\n\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"}]}},{"kind":13,"line":282,"name":"%self","containerName":null},{"line":295,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_predictions_parsed","line":296,"kind":13},{"name":"$val","containerName":"_predictions_parsed","line":296,"kind":13},{"line":298,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"line":298,"kind":13,"name":"$val","containerName":"_predictions_parsed"},{"containerName":"_predictions_parsed","name":"$val","line":298,"kind":13},{"line":300,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"containerName":"_predictions_parsed","name":"$self","kind":13,"line":301},{"kind":13,"line":303,"containerName":"_predictions_parsed","name":"$self"}],"kind":12,"detail":"($self,$val)","signature":{"label":"_predictions_parsed($self,$val)","documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n     #create and fill Bio::EnsEMBL::Seqfeature object\n\n      my $tss = Bio::SeqFeature::Generic->new\n                    (   -seq_id  => $feat->{'name'},\n                        -start   => $feat->{'start'},\n                        -end     => $feat->{'end'},\n                        -strand  => $feat->{'strand'},\n            \t\t-score   => $feat->{'score'},\n                        -source_tag  => $feat->{'source'},\n\t\t        -primary_tag => $feat->{'primary'});\n\n\t\t\n\n  if ($tss) {\n         # add to _flist\n      push(@{$self->{'_flist'}}, $tss);\n   }\n\n   #print $tss->gff_string;\n}\n\t\t\t    \n\n\n\n\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_flist'}) && @{$self->{'_flist'}});\n    return shift(@{$self->{'_flist'}});\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":295,"character":0},"end":{"line":304,"character":9999}},"name":"_predictions_parsed"}]}