{"version":5,"vars":[{"containerName":"","name":"Clone","line":132,"kind":2},{"line":134,"kind":2,"containerName":"","name":"vars"},{"line":137,"kind":13,"containerName":null,"name":"@PRIMER3_PARAMS"},{"name":"$attr","definition":"my","containerName":null,"localvar":"my","kind":13,"line":139},{"name":"@PRIMER3_PARAMS","containerName":null,"kind":13,"line":139},{"containerName":null,"name":"%OK_FIELD","line":139,"kind":13},{"kind":13,"line":139,"containerName":null,"name":"$attr"},{"kind":2,"line":143,"name":"base","containerName":""},{"line":146,"children":[{"containerName":"AUTOLOAD","name":"$self","definition":"my","localvar":"my","kind":13,"line":147},{"localvar":"my","containerName":"AUTOLOAD","definition":"my","name":"$attr","line":148,"kind":13},{"name":"$AUTOLOAD","containerName":"AUTOLOAD","line":148,"kind":13},{"line":149,"kind":13,"name":"$attr","containerName":"AUTOLOAD"},{"line":150,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"kind":12,"line":150,"containerName":"AUTOLOAD","name":"throw"},{"kind":13,"line":150,"name":"$OK_FIELD","containerName":"AUTOLOAD"},{"containerName":"AUTOLOAD","name":"$attr","kind":13,"line":150},{"line":151,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"kind":13,"line":151,"name":"$attr","containerName":"AUTOLOAD"},{"line":152,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"kind":13,"line":152,"containerName":"AUTOLOAD","name":"$attr"}],"kind":12,"range":{"end":{"line":153,"character":9999},"start":{"character":0,"line":146}},"containerName":"main::","definition":"sub","name":"AUTOLOAD"},{"name":"$ID","containerName":null,"line":155,"kind":13},{"detail":"($class,%args)","signature":{"label":"new($class,%args)","documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :","parameters":[{"label":"$class"},{"label":"%args"}]},"containerName":"main::","definition":"sub","line":172,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":173,"kind":13},{"name":"%args","containerName":"new","line":173,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":174,"kind":13},{"name":"$class","containerName":"new","line":174,"kind":13},{"name":"%args","containerName":"new","line":174,"kind":13},{"line":176,"kind":13,"name":"$args","containerName":"new"},{"name":"$self","containerName":"new","line":176,"kind":13},{"line":176,"kind":12,"containerName":"new","name":"_readfile"},{"line":176,"kind":13,"containerName":"new","name":"$args"},{"line":177,"kind":13,"name":"$args","containerName":"new"},{"name":"$self","containerName":"new","line":177,"kind":13},{"line":178,"kind":13,"containerName":"new","name":"$self"}],"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":172}},"name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":174},{"range":{"end":{"line":199,"character":9999},"start":{"line":196,"character":0}},"definition":"sub","name":"number_of_results","containerName":"main::","children":[{"kind":13,"line":197,"name":"$self","definition":"my","containerName":"number_of_results","localvar":"my"},{"line":198,"kind":13,"containerName":"number_of_results","name":"$self"}],"line":196,"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"@results"}],"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve","label":"all_results($self,@results)"},"detail":"($self,@results)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"all_results","line":215,"kind":13},{"line":215,"kind":13,"containerName":"all_results","name":"@results"},{"kind":13,"line":216,"containerName":"all_results","definition":"my","name":"%hash","localvar":"my"},{"name":"@results","containerName":"all_results","line":217,"kind":13},{"line":219,"kind":13,"localvar":"my","containerName":"all_results","definition":"my","name":"$result"},{"line":219,"kind":13,"name":"@results","containerName":"all_results"},{"containerName":"all_results","name":"$hash","line":219,"kind":13},{"containerName":"all_results","name":"$result","kind":13,"line":219},{"name":"$self","containerName":"all_results","kind":13,"line":219},{"line":219,"kind":13,"containerName":"all_results","name":"$result"},{"kind":13,"line":221,"containerName":"all_results","definition":"my","name":"$result","localvar":"my"},{"kind":13,"line":221,"name":"$self","containerName":"all_results"},{"containerName":"all_results","name":"$hash","kind":13,"line":222},{"kind":13,"line":222,"containerName":"all_results","name":"$result"},{"name":"$self","containerName":"all_results","kind":13,"line":222},{"line":222,"kind":13,"name":"$result","containerName":"all_results"}],"line":214,"kind":12,"range":{"start":{"character":0,"line":214},"end":{"line":224,"character":9999}},"name":"all_results"},{"containerName":null,"name":"%hash","kind":13,"line":226},{"range":{"start":{"character":0,"line":241},"end":{"line":249,"character":9999}},"name":"primer_results","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"primer_results","line":242,"kind":13},{"line":242,"kind":13,"name":"$toget","containerName":"primer_results"},{"line":243,"kind":13,"name":"$toget","containerName":"primer_results"},{"name":"$self","containerName":"primer_results","line":243,"kind":13},{"line":244,"kind":13,"containerName":"primer_results","name":"$self"},{"line":244,"kind":12,"containerName":"primer_results","name":"warn"},{"containerName":"primer_results","name":"$self","line":248,"kind":13},{"containerName":"primer_results","name":"$toget","kind":13,"line":248}],"line":241,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$toget"}],"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve","label":"primer_results($self,$toget)"},"detail":"($self,$toget)","definition":"sub","containerName":"main::"},{"name":"_readfile","range":{"start":{"line":263,"character":0},"end":{"line":285,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$file)","signature":{"label":"_readfile($self,$file)","documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve\n\n\nsub primer_results {\n\tmy ($self, $toget) = @_;\n\tif ($toget > $self->{'maximum_primers_returned'}) {\n\t\t$self->warn(\"Didn't get any results for $toget\");\n\t\treturn 0;\n\t}\n\telse {\n\t\treturn \\%{$self->{'results_by_number'}->{$toget}};\n\t}\n}\n\n=head2 _readfile\n\n  Title   : _readfile()\n  Usage   : $self->_readfile();\n  Function: An internal function that reads a file and sets up the results\n  Returns : Nothing.\n  Args    : None\n  Notes   :","parameters":[{"label":"$self"},{"label":"$file"}]},"kind":12,"line":263,"children":[{"kind":13,"line":264,"containerName":"_readfile","name":"$self","definition":"my","localvar":"my"},{"name":"$file","containerName":"_readfile","kind":13,"line":264},{"line":265,"kind":13,"name":"$self","containerName":"_readfile"},{"kind":12,"line":265,"containerName":"_readfile","name":"_initialize_io"},{"line":265,"kind":13,"name":"$file","containerName":"_readfile"},{"line":266,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_readfile"},{"kind":13,"line":267,"containerName":"_readfile","name":"$id","definition":"my","localvar":"my"},{"containerName":"_readfile","name":"$line","line":268,"kind":13},{"containerName":"_readfile","name":"$self","line":268,"kind":13},{"name":"_readline","containerName":"_readfile","kind":12,"line":268},{"line":269,"kind":13,"containerName":"_readfile","name":"$line"},{"name":"$line","containerName":"_readfile","line":270,"kind":13},{"line":271,"kind":13,"localvar":"my","containerName":"_readfile","definition":"my","name":"$return"},{"containerName":"_readfile","name":"$value","kind":13,"line":271},{"kind":13,"line":271,"name":"$line","containerName":"_readfile"},{"containerName":"_readfile","name":"$return","kind":13,"line":272},{"containerName":"_readfile","name":"$self","line":273,"kind":13},{"kind":12,"line":273,"name":"new","containerName":"_readfile"},{"name":"$value","containerName":"_readfile","line":273,"kind":13},{"containerName":"_readfile","name":"$id","line":273,"kind":13},{"name":"$id","containerName":"_readfile","kind":13,"line":273},{"line":276,"kind":13,"name":"$return","containerName":"_readfile"},{"kind":13,"line":277,"name":"$self","containerName":"_readfile"},{"kind":13,"line":277,"containerName":"_readfile","name":"$self"},{"containerName":"_readfile","name":"id","kind":12,"line":277},{"name":"$value","containerName":"_readfile","line":277,"kind":13},{"line":277,"kind":13,"name":"$id","containerName":"_readfile"},{"name":"$value","containerName":"_readfile","kind":13,"line":277},{"containerName":"_readfile","name":"$self","kind":13,"line":280},{"name":"$return","containerName":"_readfile","line":280,"kind":13},{"name":"$value","containerName":"_readfile","kind":13,"line":280},{"name":"$self","containerName":"_readfile","kind":13,"line":284},{"containerName":"_readfile","name":"_separate","kind":12,"line":284}]},{"line":273,"kind":12,"name":"seqobject"},{"name":"Bio","containerName":"Seq","line":273,"kind":12},{"name":"seqobject","kind":12,"line":277},{"kind":12,"line":277,"name":"seqobject"},{"children":[{"line":300,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_primer"},{"name":"$self","containerName":"next_primer","kind":13,"line":307},{"kind":12,"line":307,"containerName":"next_primer","name":"warn"},{"kind":13,"line":307,"containerName":"next_primer","name":"$self"},{"containerName":"next_primer","name":"$self","kind":13,"line":308},{"kind":12,"line":308,"name":"number_of_results","containerName":"next_primer"},{"containerName":"next_primer","name":"$self","kind":13,"line":310},{"containerName":"next_primer","name":"$self","line":310,"kind":13},{"name":"$self","containerName":"next_primer","kind":13,"line":311},{"name":"$self","containerName":"next_primer","kind":13,"line":311},{"kind":12,"line":311,"containerName":"next_primer","name":"number_of_results"},{"kind":13,"line":312,"containerName":"next_primer","definition":"my","name":"$results","localvar":"my"},{"kind":13,"line":312,"containerName":"next_primer","name":"$self"},{"line":312,"kind":12,"name":"primer_results","containerName":"next_primer"},{"containerName":"next_primer","name":"$self","kind":13,"line":312},{"name":"$self","containerName":"next_primer","kind":13,"line":314},{"name":"throw","containerName":"next_primer","kind":12,"line":314},{"kind":13,"line":314,"name":"$results","containerName":"next_primer"}],"line":299,"kind":12,"range":{"start":{"character":0,"line":299},"end":{"character":9999,"line":314}},"name":"next_primer","definition":"sub","containerName":"main::"},{"kind":13,"line":315,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":315},{"line":315,"kind":13,"name":"%results","containerName":null},{"kind":13,"line":316,"name":"$self","containerName":null},{"line":316,"kind":12,"name":"throw","containerName":"main::"},{"line":316,"kind":13,"name":"%self","containerName":null},{"line":318,"kind":13,"localvar":"my","definition":"my","name":"$left_seq","containerName":null},{"kind":12,"line":318,"containerName":"SeqFeature::Primer","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":318},{"name":"%results","containerName":null,"kind":13,"line":320},{"containerName":null,"name":"%self","kind":13,"line":321},{"localvar":"my","name":"$right_seq","definition":"my","containerName":null,"line":322,"kind":13},{"line":322,"kind":12,"containerName":"SeqFeature::Primer","name":"Bio"},{"containerName":"main::","name":"new","line":322,"kind":12},{"kind":13,"line":324,"name":"%results","containerName":null},{"name":"%self","containerName":null,"line":325,"kind":13},{"localvar":"my","containerName":null,"name":"$key","definition":"my","line":328,"kind":13},{"line":328,"kind":13,"containerName":null,"name":"%results"},{"name":"$key","containerName":null,"kind":13,"line":330},{"name":"%key","containerName":null,"line":331,"kind":13},{"containerName":null,"name":"$left_seq","line":332,"kind":13},{"containerName":"main::","name":"add_tag_value","line":332,"kind":12},{"name":"$key","containerName":null,"kind":13,"line":332},{"name":"results","line":332,"kind":12},{"containerName":null,"name":"$key","line":332,"kind":13},{"containerName":null,"name":"%key","kind":13,"line":333},{"kind":13,"line":334,"name":"$right_seq","containerName":null},{"name":"add_tag_value","containerName":"main::","line":334,"kind":12},{"name":"$key","containerName":null,"kind":13,"line":334},{"name":"results","line":334,"kind":12},{"containerName":null,"name":"$key","line":334,"kind":13},{"kind":13,"line":338,"definition":"my","name":"$primed_seq","containerName":null,"localvar":"my"},{"kind":12,"line":338,"name":"Bio","containerName":"Seq::PrimedSeq"},{"name":"new","containerName":"main::","kind":12,"line":338},{"name":"clone","kind":12,"line":338},{"containerName":null,"name":"%self","line":338,"kind":13},{"containerName":null,"name":"$left_seq","line":339,"kind":13},{"name":"$right_seq","containerName":null,"kind":13,"line":340},{"line":343,"kind":13,"localvar":"my","containerName":null,"name":"$key","definition":"my"},{"line":343,"kind":13,"containerName":null,"name":"%results"},{"name":"$key","containerName":null,"kind":13,"line":344},{"kind":13,"line":345,"name":"$primed_seq","containerName":null},{"containerName":"main::","name":"add_tag_value","kind":12,"line":345},{"line":345,"kind":13,"name":"$key","containerName":null},{"line":345,"kind":12,"name":"results"},{"kind":13,"line":345,"name":"$key","containerName":null},{"line":348,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"$primed_seq","line":349,"kind":13},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"primer_stream","line":365,"kind":13},{"kind":13,"line":366,"containerName":"primer_stream","definition":"my","name":"$primedseq","localvar":"my"},{"kind":13,"line":366,"name":"$self","containerName":"primer_stream"},{"kind":12,"line":366,"name":"next_primer","containerName":"primer_stream"},{"line":367,"kind":13,"containerName":"primer_stream","name":"$primedseq"}],"line":364,"definition":"sub","name":"primer_stream","containerName":"main::","range":{"end":{"line":368,"character":9999},"start":{"character":0,"line":364}}},{"name":"_separate","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":382},"end":{"line":386,"character":9999}},"kind":12,"children":[{"line":383,"kind":13,"localvar":"my","containerName":"_separate","name":"$self","definition":"my"},{"line":384,"kind":13,"localvar":"my","containerName":"_separate","name":"%results","definition":"my"},{"localvar":"my","containerName":"_separate","name":"$maxlocation","definition":"my","line":385,"kind":13},{"line":386,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"_separate"},{"kind":13,"line":386,"containerName":"_separate","name":"$self"}],"line":382},{"kind":13,"line":387,"containerName":null,"name":"%self"},{"name":"$key","containerName":null,"kind":13,"line":387},{"kind":13,"line":389,"name":"$location","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":393,"name":"$tempkey","definition":"my","containerName":null,"localvar":"my"},{"name":"$key","containerName":null,"line":393,"kind":13},{"containerName":null,"name":"%tempkey","line":394,"kind":13},{"containerName":null,"name":"$location","kind":13,"line":395},{"kind":13,"line":396,"name":"$location","containerName":null},{"containerName":null,"name":"%maxlocation","kind":13,"line":396},{"containerName":null,"name":"$maxlocation","line":396,"kind":13},{"name":"$location","containerName":null,"line":396,"kind":13},{"line":397,"kind":13,"containerName":null,"name":"%tempkey"},{"kind":13,"line":399,"containerName":null,"name":"$location"},{"kind":13,"line":400,"name":"$location","containerName":null},{"containerName":null,"name":"%maxlocation","kind":13,"line":400},{"kind":13,"line":400,"name":"$maxlocation","containerName":null},{"containerName":null,"name":"%location","kind":13,"line":400},{"kind":13,"line":402,"containerName":null,"name":"$location"},{"name":"%results","containerName":null,"line":405,"kind":13},{"containerName":null,"name":"%location","line":405,"kind":13},{"kind":13,"line":405,"containerName":null,"name":"$tempkey"},{"kind":13,"line":405,"name":"%self","containerName":null},{"line":405,"kind":13,"name":"$key","containerName":null},{"kind":13,"line":407,"name":"%self","containerName":null},{"name":"%results","containerName":null,"kind":13,"line":407},{"line":408,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":408,"name":"$maxlocation","containerName":null},{"children":[{"kind":13,"line":423,"name":"$self","definition":"my","containerName":"_set_variable","localvar":"my"},{"name":"$name","containerName":"_set_variable","line":423,"kind":13},{"name":"$value","containerName":"_set_variable","kind":13,"line":423},{"name":"$name","containerName":"_set_variable","line":424,"kind":13},{"name":"$self","containerName":"_set_variable","line":425,"kind":13},{"containerName":"_set_variable","name":"$name","kind":13,"line":425},{"line":425,"kind":13,"containerName":"_set_variable","name":"$value"}],"line":422,"kind":12,"signature":{"label":"_set_variable($self,$name,$value)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}],"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve\n\n\nsub primer_results {\n\tmy ($self, $toget) = @_;\n\tif ($toget > $self->{'maximum_primers_returned'}) {\n\t\t$self->warn(\"Didn't get any results for $toget\");\n\t\treturn 0;\n\t}\n\telse {\n\t\treturn \\%{$self->{'results_by_number'}->{$toget}};\n\t}\n}\n\n=head2 _readfile\n\n  Title   : _readfile()\n  Usage   : $self->_readfile();\n  Function: An internal function that reads a file and sets up the results\n  Returns : Nothing.\n  Args    : None\n  Notes   :\n\n\nsub _readfile {\n\tmy ($self, $file) = @_;\n\t$self->_initialize_io(-file=>$file);\n\tmy $line;\n\tmy $id='primer 3 parsed results'; # hopefully we'll get this, but we can set a temp id in case not.\n\twhile (defined($line=$self->_readline()) ) {\n\t\tchomp $line;\n\t\tnext unless ($line);\n\t\tmy ($return, $value) = split /=/, $line;\n\t\tif (uc($return) eq \"SEQUENCE\") {\n\t\t\t$self->{seqobject}=Bio::Seq->new(-seq=>$value, $id=>$id);\n\t\t\tnext;\n\t\t}\n\t\tif (uc($return) eq \"PRIMER_SEQUENCE_ID\") {\n\t\t\tif ($self->{seqobject}) {$self->{seqobject}->id($value)} else {$id=$value}\n\t\t}\n\n\t\t$self->{'results'}->{$return} = $value;\n\t}\n\n\t# convert the results to individual results\n\t$self->_separate();\n}\n\n=head2 next_primer\n\n  Title   : next_primer()\n  Usage   : while (my $primed_seq  = $primer3->next_primer()) {\n  Function: Retrieve the primed sequence and a primer pair, one at a time\n  Returns : Returns a Bio::Seq::PrimedSeq feature, one at a time\n  Args    : None\n  Notes   : Use $primed_seq->annotated_seq to get an annotated sequence\n            object you can write out.\n\n\nsub next_primer {\n\tmy $self = shift;\n\t# here we are going to convert the primers to Bio::SeqFeature::Primer objects\n\t# and the primer/sequence to Bio::Seq::PrimedSeq objects\n\t# the problem at the moment is that PrimedSeq can only take one sequence/primer pair, and\n\t# yet for each sequence we can have lots of primer pairs. We need a way to overcome this.\n\t# at the moment we can do this as a stream, I guess.\n\n\t$self->warn(\"No primers were found for: \".$self->{'seqobject'}->{'primary_id'})\n\t  if (! $self->number_of_results);\n\n\t$self->{'next_to_return'} = 0 unless ($self->{'next_to_return'});\n\treturn if ($self->{'next_to_return'} >= $self->number_of_results);\n\tmy $results = $self->primer_results($self->{'next_to_return'});\n\n\t$self->throw(\"No left primer sequence\") unless (${$results}{'PRIMER_LEFT_SEQUENCE'});\n\t$self->throw(\"No right primer sequence\") unless (${$results}{'PRIMER_RIGHT_SEQUENCE'});\n\t$self->throw(\"No target sequence\") unless ($self->{'seqobject'});\n\n\tmy $left_seq  = Bio::SeqFeature::Primer->new(\n                                   -primer_sequence_id => \"left_primer\",\n\t\t\t\t\t\t\t\t\t\t\t  -sequence => ${$results}{'PRIMER_LEFT_SEQUENCE'},\n\t\t\t\t\t\t\t\t\t\t\t  -display_id => ($self->{'next_to_return'} + 1) );\n\tmy $right_seq = Bio::SeqFeature::Primer->new(\n\t\t\t\t\t\t\t\t\t\t\t  -primer_sequence_id => \"right_primer\",\n\t\t\t\t\t\t\t\t\t\t\t  -sequence => ${$results}{'PRIMER_RIGHT_SEQUENCE'},\n\t\t\t\t\t\t\t\t\t\t\t  -display_id => ($self->{'next_to_return'} + 1) );\n\n\t# add data to the Primer objects\n\tfor my $key (%$results) {\n\t\t# skip the primer sequence data, already added above\n\t\tnext if ($key =~ /PRIMER_(LEFT|RIGHT)_SEQUENCE/i );\n\t\tif ($key =~ /PRIMER_LEFT/i) {\n\t\t\t$left_seq->add_tag_value($key, $$results{$key});\n\t\t} elsif ($key =~ /PRIMER_RIGHT/i) {\n\t\t\t$right_seq->add_tag_value($key, $$results{$key});\n\t\t}\n\t}\n\n\tmy $primed_seq = Bio::Seq::PrimedSeq->new(-target_sequence => clone($self->{'seqobject'}),\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-left_primer => $left_seq,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-right_primer => $right_seq);\n\n\t# add data to the the PrimedSeq object that's not specific to the Primers\n\tfor my $key (%$results) {\n\t\tnext if ($key =~ /PRIMER_(LEFT|RIGHT)/i );\n\t\t\t$primed_seq->add_tag_value($key, $$results{$key});\n\t}\n\n\t$self->{'next_to_return'}++;\n\treturn $primed_seq;\n}\n\n\n=head2 primer_stream\n\n  Title   : primer_stream()\n  Usage   : while (my $primed_seq  = $primer3->primer_stream()) {\n  Function: Retrieve the primer/sequences one at a time\n  Returns : Returns a Bio::Seq::PrimedSeq feature, one at a time\n  Args    : None\n  Notes   : Deprecated, just a link to next_primer\n\n\nsub primer_stream {\n\tmy $self=shift;\n\tmy $primedseq = $self->next_primer;\n\treturn $primedseq;\n}\n\n=head2 _separate\n\n  Title   : _separate()\n  Usage   : $self->_separate();\n  Function: An internal function that groups the results by number\n            (e.g. primer pair 1, etc)\n  Returns : Nothing.\n  Args    : None\n  Notes   :\n\n\nsub _separate {\n\tmy $self = shift;\n\tmy %results; # the results that we find\n\tmy $maxlocation = -1; # the maximum number of primers returned\n\tforeach my $key (keys %{$self->{'results'}}) {\n\t\tnext if (${$self->{'input_options'}}{$key}); # don't process it if it is an input key\n\n\t\tmy $location; # the number of the primer pair\n\t\t# names will have values like\n\t\t# PRIMER_RIGHT_SEQUENCE, PRIMER_RIGHT_2_SEQUENCE, PRIMER_PRODUCT_SIZE, and\n\t\t# PRIMER_PRODUCT_SIZE_3 hence we need to find and remove the number\n\t\tmy $tempkey=$key;\n\t\tif ($tempkey =~ s/_(\\d+)//) {\n\t\t\t$location=$1;\n\t\t\tif ($location > $maxlocation) {$maxlocation = $location}\n\t\t} elsif ( $tempkey =~ /PRIMER_(RIGHT|LEFT)_SEQUENCE/ ) {\n\t\t\t# first primers reported without a number, therefore set $location to 0\n\t\t\t$location = 0;\n\t\t\tif ($location > $maxlocation) {$maxlocation = $location}\n\t\t} else {\n\t\t\t$location = 0;\n\t\t}\n\t\t# we will hash the results by number, and then by name\n\t\t${$results{$location}}{$tempkey}=${$self->{'results'}}{$key};\n\t}\n\t$self->{'results_by_number'}=\\%results;\n\t$self->{'maximum_primers_returned'}=$maxlocation;\n}\n\n=head2 _set_variable\n\n  Title   : _set_variable()\n  Usage   : $self->_set_variable('variable name', 'value');\n  Function: An internal function that sets a variable\n  Returns : Nothing.\n  Args    : None\n  Notes   : Used to set $self->{results} and $self->seqobject"},"detail":"($self,$name,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":426,"character":9999},"start":{"character":0,"line":422}},"name":"_set_variable"}]}