{"version":5,"vars":[{"kind":2,"line":99,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":122,"character":9999},"start":{"character":0,"line":112}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Promoterwise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Promoterwise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Promoterwise - parser for Promoterwise tab format output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Promoterwise;\n\n  my $pw = Bio::Tools::Promoterwise->new(-file=>\"out\",\n                                         -query1_seq=>$seq1,\n                                         -query2_seq=>$seq2);\n  while (my $fp = $pw->next_result){\n    print \"Hit Length: \".$fp->feature1->length.\"\\n\";\n    print \"Hit Start: \".$fp->feature1->start.\"\\n\";\n    print \"Hit End: \".$fp->feature1->end.\"\\n\";\n    print \"Hsps: \\n\";\n    my @first_hsp = $fp->feature1->sub_SeqFeature;\n    my @second_hsp = $fp->feature2->sub_SeqFeature;\n    foreach my $i (0..$#first_hsp){\n      print $first_hsp[$i]->start. \" \".$first_hsp[$i]->end.\" \".\n            $second_hsp[$i]->start. \" \".$second_hsp[$i]->end.\"\\n\";\n    }\n  }\n\n=head1 DESCRIPTION\n\nPromoteriwise is an alignment algorithm that relaxes the constraint\nthat local alignments have to be co-linear. Otherwise it provides a\nsimilar model to DBA, which is designed for promoter sequence\nalignments.  Promoterwise is written by Ewan Birney.  It is part of\nthe wise2 package available at\nL<ftp://ftp.ebi.ac.uk/pub/software/unix/wise2/>\n\nThis module is the parser for the Promoterwise output in tab format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Promoterwise;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Promoterwise->new();\n Function: Builds a new Bio::Tools::Promoterwise object\n Returns : L<Bio::Tools::Promoterwise>\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO","label":"new($class,@args)"},"kind":12,"line":112,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":113},{"containerName":"new","name":"@args","line":113,"kind":13},{"line":115,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"kind":13,"line":115,"containerName":"new","name":"$class"},{"line":115,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":116,"name":"$self","containerName":"new"},{"line":116,"kind":12,"name":"_initialize_io","containerName":"new"},{"line":116,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","definition":"my","name":"$query1","containerName":"new","line":117,"kind":13},{"line":117,"kind":13,"name":"$query2","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":117},{"name":"_rearrange","containerName":"new","line":117,"kind":12},{"kind":13,"line":117,"containerName":"new","name":"@args"},{"line":118,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"query1_seq","kind":12,"line":118},{"line":118,"kind":13,"name":"$query1","containerName":"new"},{"containerName":"new","name":"$query1","kind":13,"line":118},{"name":"$self","containerName":"new","line":119,"kind":13},{"kind":12,"line":119,"name":"query2_seq","containerName":"new"},{"containerName":"new","name":"$query2","kind":13,"line":119},{"line":119,"kind":13,"containerName":"new","name":"$query2"},{"kind":13,"line":121,"containerName":"new","name":"$self"}]},{"line":115,"kind":12,"name":"SUPER","containerName":"new"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Promoterwise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Promoterwise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Promoterwise - parser for Promoterwise tab format output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Promoterwise;\n\n  my $pw = Bio::Tools::Promoterwise->new(-file=>\"out\",\n                                         -query1_seq=>$seq1,\n                                         -query2_seq=>$seq2);\n  while (my $fp = $pw->next_result){\n    print \"Hit Length: \".$fp->feature1->length.\"\\n\";\n    print \"Hit Start: \".$fp->feature1->start.\"\\n\";\n    print \"Hit End: \".$fp->feature1->end.\"\\n\";\n    print \"Hsps: \\n\";\n    my @first_hsp = $fp->feature1->sub_SeqFeature;\n    my @second_hsp = $fp->feature2->sub_SeqFeature;\n    foreach my $i (0..$#first_hsp){\n      print $first_hsp[$i]->start. \" \".$first_hsp[$i]->end.\" \".\n            $second_hsp[$i]->start. \" \".$second_hsp[$i]->end.\"\\n\";\n    }\n  }\n\n=head1 DESCRIPTION\n\nPromoteriwise is an alignment algorithm that relaxes the constraint\nthat local alignments have to be co-linear. Otherwise it provides a\nsimilar model to DBA, which is designed for promoter sequence\nalignments.  Promoterwise is written by Ewan Birney.  It is part of\nthe wise2 package available at\nL<ftp://ftp.ebi.ac.uk/pub/software/unix/wise2/>\n\nThis module is the parser for the Promoterwise output in tab format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Promoterwise;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Promoterwise->new();\n Function: Builds a new Bio::Tools::Promoterwise object\n Returns : L<Bio::Tools::Promoterwise>\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  my ($query1,$query2) = $self->_rearrange([qw(QUERY1_SEQ QUERY2_SEQ)],@args);\n  $self->query1_seq($query1) if ($query1);\n  $self->query2_seq($query2) if ($query2);\n\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $rpt_masker->next_result\n Function: Get the next result set from parser data\n Returns : an  L<Bio::SeqFeature::FeaturePair>\n Args    : none","label":"next_result($self)"},"kind":12,"line":135,"children":[{"line":136,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_result"},{"kind":13,"line":137,"containerName":"next_result","name":"$self"},{"kind":12,"line":137,"containerName":"next_result","name":"_parse"},{"line":137,"kind":13,"containerName":"next_result","name":"$self"},{"line":137,"kind":12,"containerName":"next_result","name":"_parsed"},{"name":"$self","containerName":"next_result","line":138,"kind":13},{"containerName":"next_result","name":"_next_result","kind":12,"line":138}],"name":"next_result","range":{"end":{"character":9999,"line":139},"start":{"line":135,"character":0}}},{"kind":12,"children":[{"containerName":"_parse","definition":"my","name":"$self","localvar":"my","kind":13,"line":142},{"kind":13,"line":143,"definition":"my","name":"%hash","containerName":"_parse","localvar":"my"},{"containerName":"_parse","name":"@fp","kind":13,"line":143},{"containerName":"_parse","name":"$self","kind":13,"line":144},{"line":144,"kind":12,"containerName":"_parse","name":"_readline"},{"line":146,"kind":13,"localvar":"my","name":"@array","definition":"my","containerName":"_parse"},{"name":"$hash","containerName":"_parse","line":147,"kind":13},{"name":"$array","containerName":"_parse","kind":13,"line":147},{"line":147,"kind":13,"name":"@array","containerName":"_parse"}],"line":141,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse($self)"},"detail":"($self)","name":"_parse","range":{"start":{"character":0,"line":141},"end":{"line":148,"character":9999}}},{"localvar":"my","containerName":null,"name":"$key","definition":"my","line":149,"kind":13},{"containerName":null,"name":"%hash","line":149,"kind":13},{"containerName":null,"name":"$sf1","definition":"my","localvar":"my","kind":13,"line":150},{"kind":12,"line":150,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"new","containerName":"main::","line":150,"kind":12},{"containerName":null,"name":"$sf1","kind":13,"line":152},{"containerName":"main::","name":"attach_seq","kind":12,"line":152},{"name":"$self","containerName":null,"kind":13,"line":152},{"name":"query1_seq","containerName":"main::","line":152,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":152},{"line":152,"kind":12,"containerName":"main::","name":"query1_seq"},{"definition":"my","name":"$sf2","containerName":null,"localvar":"my","kind":13,"line":153},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":153},{"kind":12,"line":153,"containerName":"main::","name":"new"},{"containerName":null,"name":"$sf2","line":155,"kind":13},{"line":155,"kind":12,"containerName":"main::","name":"attach_seq"},{"kind":13,"line":155,"name":"$self","containerName":null},{"containerName":"main::","name":"query2_seq","kind":12,"line":155},{"line":155,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":155,"containerName":"main::","name":"query2_seq"},{"kind":13,"line":156,"definition":"my","name":"$info","containerName":null,"localvar":"my"},{"line":156,"kind":13,"containerName":null,"name":"%hash"},{"name":"%key","containerName":null,"kind":13,"line":156},{"line":158,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$score"},{"line":158,"kind":13,"containerName":null,"name":"$id1"},{"containerName":null,"name":"$start_1","line":158,"kind":13},{"line":158,"kind":13,"containerName":null,"name":"$end_1"},{"kind":13,"line":158,"containerName":null,"name":"$strand_1"},{"kind":13,"line":158,"containerName":null,"name":"$s1_len"},{"kind":13,"line":159,"name":"$id2","containerName":null},{"line":159,"kind":13,"name":"$start_2","containerName":null},{"containerName":null,"name":"$end_2","line":159,"kind":13},{"line":159,"kind":13,"containerName":null,"name":"$strand_2"},{"kind":13,"line":159,"name":"$s2_len","containerName":null},{"containerName":null,"name":"$group","line":159,"kind":13},{"containerName":null,"name":"%info","kind":13,"line":160},{"line":161,"kind":13,"name":"$score","containerName":null},{"kind":13,"line":161,"name":"$id1","containerName":null},{"containerName":null,"name":"$start_1","kind":13,"line":161},{"kind":13,"line":161,"name":"$end_1","containerName":null},{"line":161,"kind":13,"containerName":null,"name":"$strand_1"},{"name":"$s1_len","containerName":null,"kind":13,"line":161},{"name":"$id2","containerName":null,"line":162,"kind":13},{"kind":13,"line":162,"name":"$start_2","containerName":null},{"line":162,"kind":13,"name":"$end_2","containerName":null},{"name":"$strand_2","containerName":null,"kind":13,"line":162},{"kind":13,"line":162,"containerName":null,"name":"$s2_len"},{"name":"$group","containerName":null,"line":162,"kind":13},{"containerName":null,"name":"$info","line":162,"kind":13},{"name":"%info","containerName":null,"kind":13,"line":163},{"line":164,"kind":13,"name":"$score","containerName":null},{"name":"$id1","containerName":null,"kind":13,"line":164},{"containerName":null,"name":"$start_1","kind":13,"line":164},{"containerName":null,"name":"$end_1","line":164,"kind":13},{"containerName":null,"name":"$strand_1","line":164,"kind":13},{"line":165,"kind":13,"name":"$id2","containerName":null},{"kind":13,"line":165,"name":"$start_2","containerName":null},{"containerName":null,"name":"$end_2","line":165,"kind":13},{"containerName":null,"name":"$s2_len","kind":13,"line":165},{"line":165,"kind":13,"containerName":null,"name":"$group"},{"name":"%info","containerName":null,"kind":13,"line":165},{"line":167,"kind":13,"containerName":null,"name":"$self"},{"line":167,"kind":12,"containerName":"main::","name":"throw"},{"name":"$info","containerName":null,"kind":13,"line":167},{"name":"$sf1","containerName":null,"line":170,"kind":13},{"kind":12,"line":170,"containerName":"main::","name":"strand"},{"line":170,"kind":13,"containerName":null,"name":"$sf2"},{"containerName":"main::","name":"strand","kind":12,"line":170},{"containerName":null,"name":"$sf1","kind":13,"line":171},{"kind":12,"line":171,"name":"strand","containerName":"main::"},{"containerName":null,"name":"$strand_1","line":171,"kind":13},{"name":"$sf2","containerName":null,"kind":13,"line":172},{"name":"strand","containerName":"main::","kind":12,"line":172},{"name":"$strand_2","containerName":null,"kind":13,"line":172},{"kind":13,"line":173,"containerName":null,"name":"$sf1"},{"line":173,"kind":12,"containerName":"main::","name":"seq_id"},{"name":"$id1","containerName":null,"kind":13,"line":173},{"name":"$sf2","containerName":null,"line":174,"kind":13},{"kind":12,"line":174,"name":"seq_id","containerName":"main::"},{"line":174,"kind":13,"name":"$id2","containerName":null},{"line":175,"kind":13,"containerName":null,"name":"$sf1"},{"containerName":"main::","name":"score","line":175,"kind":12},{"name":"$score","containerName":null,"kind":13,"line":175},{"kind":13,"line":176,"containerName":null,"name":"$sf2"},{"line":176,"kind":12,"name":"score","containerName":"main::"},{"containerName":null,"name":"$score","kind":13,"line":176},{"line":179,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$sub1"},{"line":179,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"new","containerName":"main::","line":179,"kind":12},{"line":179,"kind":13,"name":"$start_1","containerName":null},{"containerName":null,"name":"$id1","line":180,"kind":13},{"line":181,"kind":13,"containerName":null,"name":"$end_1"},{"kind":13,"line":182,"containerName":null,"name":"$strand_1"},{"name":"$score","containerName":null,"kind":13,"line":185},{"name":"$sub1","containerName":null,"line":186,"kind":13},{"kind":12,"line":186,"name":"attach_seq","containerName":"main::"},{"line":186,"kind":13,"containerName":null,"name":"$self"},{"name":"query1_seq","containerName":"main::","kind":12,"line":186},{"line":186,"kind":13,"containerName":null,"name":"$self"},{"name":"query1_seq","containerName":"main::","line":186,"kind":12},{"containerName":null,"name":"$sub2","definition":"my","localvar":"my","kind":13,"line":188},{"containerName":"SeqFeature::Generic","name":"Bio","line":188,"kind":12},{"line":188,"kind":12,"containerName":"main::","name":"new"},{"line":188,"kind":13,"containerName":null,"name":"$start_2"},{"line":189,"kind":13,"containerName":null,"name":"$id2"},{"containerName":null,"name":"$end_2","line":190,"kind":13},{"name":"$strand_2","containerName":null,"kind":13,"line":191},{"containerName":null,"name":"$score","kind":13,"line":194},{"kind":13,"line":195,"name":"$sub2","containerName":null},{"containerName":"main::","name":"attach_seq","kind":12,"line":195},{"name":"$self","containerName":null,"kind":13,"line":195},{"containerName":"main::","name":"query2_seq","line":195,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":195},{"line":195,"kind":12,"containerName":"main::","name":"query2_seq"},{"line":196,"kind":13,"containerName":null,"name":"$sf1"},{"line":196,"kind":12,"name":"add_SeqFeature","containerName":"main::"},{"containerName":null,"name":"$sub1","line":196,"kind":13},{"kind":13,"line":197,"name":"$sf2","containerName":null},{"name":"add_SeqFeature","containerName":"main::","line":197,"kind":12},{"containerName":null,"name":"$sub2","line":197,"kind":13},{"kind":13,"line":200,"containerName":null,"definition":"my","name":"$fp","localvar":"my"},{"name":"Bio","containerName":"SeqFeature::FeaturePair","kind":12,"line":200},{"kind":12,"line":200,"containerName":"main::","name":"new"},{"name":"$sf1","containerName":null,"line":200,"kind":13},{"kind":13,"line":201,"name":"$sf2","containerName":null},{"containerName":null,"name":"@fp","kind":13,"line":202},{"containerName":null,"name":"$fp","line":202,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":204},{"name":"_feature_pairs","containerName":"main::","kind":12,"line":204},{"name":"@fp","containerName":null,"kind":13,"line":204},{"kind":13,"line":205,"name":"$self","containerName":null},{"line":205,"kind":12,"name":"_parsed","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"_feature_pairs($self,$fp)","documentation":"","parameters":[{"label":"$self"},{"label":"$fp"}]},"detail":"($self,$fp)","kind":12,"children":[{"line":210,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_feature_pairs"},{"containerName":"_feature_pairs","name":"$fp","kind":13,"line":210},{"line":211,"kind":13,"name":"$fp","containerName":"_feature_pairs"},{"name":"$self","containerName":"_feature_pairs","line":212,"kind":13},{"name":"$fp","containerName":"_feature_pairs","line":212,"kind":13},{"name":"$self","containerName":"_feature_pairs","kind":13,"line":214}],"line":209,"name":"_feature_pairs","range":{"end":{"character":9999,"line":215},"start":{"line":209,"character":0}}},{"name":"_next_result","range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":219}},"kind":12,"children":[{"line":218,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_next_result"},{"containerName":"_next_result","name":"$self","kind":13,"line":219},{"kind":13,"line":219,"name":"$self","containerName":"_next_result"}],"line":217,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_next_result($self)"},"detail":"($self)"},{"containerName":null,"name":"%self","kind":13,"line":220},{"name":"_parsed","range":{"start":{"character":0,"line":222},"end":{"line":228,"character":9999}},"kind":12,"line":222,"children":[{"localvar":"my","containerName":"_parsed","definition":"my","name":"$self","line":223,"kind":13},{"kind":13,"line":223,"containerName":"_parsed","name":"$flag"},{"line":224,"kind":13,"containerName":"_parsed","name":"$flag"},{"kind":13,"line":225,"name":"$self","containerName":"_parsed"},{"kind":13,"line":227,"name":"$self","containerName":"_parsed"}],"containerName":"main::","definition":"sub","detail":"($self,$flag)","signature":{"parameters":[{"label":"$self"},{"label":"$flag"}],"documentation":"","label":"_parsed($self,$flag)"}},{"range":{"end":{"line":236,"character":9999},"start":{"line":230,"character":0}},"name":"query1_seq","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"","label":"query1_seq($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"query1_seq","localvar":"my","kind":13,"line":231},{"kind":13,"line":231,"name":"$val","containerName":"query1_seq"},{"kind":13,"line":232,"name":"$val","containerName":"query1_seq"},{"line":233,"kind":13,"name":"$self","containerName":"query1_seq"},{"kind":13,"line":233,"name":"$val","containerName":"query1_seq"},{"containerName":"query1_seq","name":"$self","kind":13,"line":235}],"line":230,"kind":12},{"detail":"($self,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"","label":"query2_seq($self,$val)"},"containerName":"main::","definition":"sub","line":237,"children":[{"containerName":"query2_seq","name":"$self","definition":"my","localvar":"my","kind":13,"line":238},{"kind":13,"line":238,"name":"$val","containerName":"query2_seq"},{"line":239,"kind":13,"containerName":"query2_seq","name":"$val"},{"containerName":"query2_seq","name":"$self","kind":13,"line":240},{"kind":13,"line":240,"name":"$val","containerName":"query2_seq"},{"containerName":"query2_seq","name":"$self","line":242,"kind":13}],"kind":12,"range":{"start":{"line":237,"character":0},"end":{"line":243,"character":9999}},"name":"query2_seq"}]}