{"vars":[{"line":89,"kind":2,"name":"base","containerName":""},{"definition":"sub","containerName":"main::","signature":{"documentation":"# $Id: Protparam.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Tools::Protparam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Dobson, r.j.dobson at qmul dot ac dot uk\n#\n# Copyright Richard Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Protparam - submit to and parse output from protparam ;\n\n=head1 SYNOPSIS\n\n  my $gb = new Bio::DB::GenBank(-retrievaltype => 'tempfile' , \n                                -format => 'Fasta');\n  my @ids=qw(O14521 O43709 O43826);\n  my $seqio = $gb->get_Stream_by_acc(\\@ids );\n\n  while( my $seq =  $seqio->next_seq ) {\n\n\tmy $pp = Protparam->new(seq=>$seq->seq);\n\n\tprint \n\t\"ID : \", $seq->display_id,\"\\n\",\n\t\"Amino acid number : \",$pp->amino_acid_number(),\"\\n\",\n\t\"Number of negative amino acids : \",$pp->num_neg(),\"\\n\",\n\t\"Number of positive amino acids : \",$pp->num_pos(),\"\\n\",\n\t\"Molecular weight : \",$pp->molecular_weight(),\"\\n\",\n\t\"Theoretical pI : \",$pp->theoretical_pI(),\"\\n\",\n\t\"Total number of atoms : \", $pp->total_atoms(),\"\\n\",\n\t\"Number of carbon atoms : \",$pp->num_carbon(),\"\\n\",\n\t\"Number of hydrogen atoms : \",$pp->num_hydrogen(),\"\\n\",\n\t\"Number of nitrogen atoms : \",$pp->num_nitro(),\"\\n\",\n\t\"Number of oxygen atoms : \",$pp->num_oxygen(),\"\\n\",\n\t\"Number of sulphur atoms : \",$pp->num_sulphur(),\"\\n\",\n\t\"Half life : \", $pp->half_life(),\"\\n\",\n\t\"Instability Index : \", $pp->instability_index(),\"\\n\",\n\t\"Stability class : \", $pp->stability(),\"\\n\",\n\t\"Aliphatic_index : \",$pp->aliphatic_index(),\"\\n\",\n\t\"Gravy : \", $pp->gravy(),\"\\n\",\n\t\"Composition of A : \", $pp->AA_comp('A'),\"\\n\",\n\t\"Composition of R : \", $pp->AA_comp('R'),\"\\n\",\n\t\"Composition of N : \", $pp->AA_comp('N'),\"\\n\",\n\t\"Composition of D : \", $pp->AA_comp('D'),\"\\n\",\n\t\"Composition of C : \", $pp->AA_comp('C'),\"\\n\",\n\t\"Composition of Q : \", $pp->AA_comp('Q'),\"\\n\",\n\t\"Composition of E : \", $pp->AA_comp('E'),\"\\n\",\n\t\"Composition of G : \", $pp->AA_comp('G'),\"\\n\",\n\t\"Composition of H : \", $pp->AA_comp('H'),\"\\n\",\n\t\"Composition of I : \", $pp->AA_comp('I'),\"\\n\",\n\t\"Composition of L : \", $pp->AA_comp('L'),\"\\n\",\n\t\"Composition of K : \", $pp->AA_comp('K'),\"\\n\",\n\t\"Composition of M : \", $pp->AA_comp('M'),\"\\n\",\n\t\"Composition of F : \", $pp->AA_comp('F'),\"\\n\",\n\t\"Composition of P : \", $pp->AA_comp('P'),\"\\n\",\n\t\"Composition of S : \", $pp->AA_comp('S'),\"\\n\",\n\t\"Composition of T : \", $pp->AA_comp('T'),\"\\n\",\n\t\"Composition of W : \", $pp->AA_comp('W'),\"\\n\",\n\t\"Composition of Y : \", $pp->AA_comp('Y'),\"\\n\",\n\t\"Composition of V : \", $pp->AA_comp('V'),\"\\n\",\n\t\"Composition of B : \", $pp->AA_comp('B'),\"\\n\",\n\t\"Composition of Z : \", $pp->AA_comp('Z'),\"\\n\",\n\t\"Composition of X : \", $pp->AA_comp('X'),\"\\n\";\n}\n\n=head1 DESCRIPTION\n\nThis module takes an amino acid sequence and submits it to the\nProtparam program at www.expasy.org/cgi-bin/protparam.  Many\nproperties of the submitted sequence are returned.\n\n=head1 AUTHOR\n\nRichard Dobson, r.j.dobson at qmul dot ac dot uk\n\n\n# Let the code begin...\n\npackage Bio::Tools::Protparam;\n\nuse strict;\nuse base qw(Bio::Root::Root);\nuse LWP 5.64;\n\n=head2 new\n\n  Title    : new\n  Usage    : $pp = Protparam->new(seq=>$seq->seq);\n  Function : Creates a new Protparam object\n  Returns  : A Protparam object\n  Args     : A sequence","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"line":107,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":107,"kind":13,"name":"@args","containerName":"new"},{"line":110,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"@args","line":110,"kind":13},{"kind":13,"line":112,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"name":"$class","containerName":"new","line":112,"kind":13},{"line":112,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$url","containerName":"new","line":114,"kind":13},{"kind":13,"line":114,"name":"$seq","containerName":"new"},{"kind":13,"line":114,"containerName":"new","name":"$form"},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":114,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":114},{"containerName":"new","definition":"my","name":"$browser","localvar":"my","kind":13,"line":116},{"name":"new","containerName":"new","line":116,"kind":12},{"containerName":"new","definition":"my","name":"$response","localvar":"my","kind":13,"line":117},{"kind":13,"line":120,"name":"$response","containerName":"new"},{"name":"$browser","containerName":"new","line":120,"kind":13},{"name":"post","containerName":"new","line":120,"kind":12},{"containerName":"new","name":"$url","kind":13,"line":120},{"containerName":"new","name":"$form","kind":13,"line":122},{"kind":13,"line":123,"containerName":"new","name":"$seq"},{"containerName":"new","name":"$self","line":128,"kind":13},{"kind":12,"line":128,"name":"throw","containerName":"new"},{"line":128,"kind":13,"containerName":"new","name":"$response"},{"kind":12,"line":128,"name":"status_line","containerName":"new"},{"line":128,"kind":13,"containerName":"new","name":"$response"},{"name":"is_success","containerName":"new","line":128,"kind":12},{"kind":13,"line":129,"name":"$self","containerName":"new"},{"line":129,"kind":12,"name":"throw","containerName":"new"},{"name":"$response","containerName":"new","kind":13,"line":129},{"containerName":"new","name":"content_type","line":129,"kind":12},{"containerName":"new","name":"$response","kind":13,"line":129},{"name":"content_type","containerName":"new","line":129,"kind":12},{"localvar":"my","definition":"my","name":"$protParamOutput","containerName":"new","line":131,"kind":13},{"name":"$response","containerName":"new","line":131,"kind":13},{"line":131,"kind":12,"containerName":"new","name":"decoded_content"},{"line":133,"kind":13,"name":"$self","containerName":"new"},{"name":"$protParamOutput","containerName":"new","kind":13,"line":133},{"line":135,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":135,"name":"$class","containerName":"new"}],"line":104,"name":"new","range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":104}}},{"containerName":"","name":"LWP","kind":2,"line":107},{"name":"SUPER","containerName":"new","kind":12,"line":112},{"name":"LWP","containerName":"UserAgent","kind":12,"line":116},{"range":{"end":{"character":9999,"line":160},"start":{"line":151,"character":0}},"containerName":"main::","definition":"sub","name":"num_neg","line":151,"children":[{"kind":13,"line":153,"containerName":"num_neg","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":155,"containerName":"num_neg","name":"$self"},{"line":155,"kind":13,"containerName":"num_neg","name":"$self"},{"name":"$self","containerName":"num_neg","line":157,"kind":13}],"kind":12},{"definition":"sub","name":"num_pos","containerName":"main::","range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":182}},"kind":12,"children":[{"line":175,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"num_pos"},{"containerName":"num_pos","name":"$self","kind":13,"line":177},{"kind":13,"line":177,"name":"$self","containerName":"num_pos"},{"line":179,"kind":13,"name":"$self","containerName":"num_pos"}],"line":173},{"children":[{"line":195,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"amino_acid_number"},{"line":197,"kind":13,"containerName":"amino_acid_number","name":"$self"},{"containerName":"amino_acid_number","name":"$self","line":197,"kind":13},{"name":"$self","containerName":"amino_acid_number","kind":13,"line":199}],"line":194,"kind":12,"range":{"end":{"line":200,"character":9999},"start":{"line":194,"character":0}},"name":"amino_acid_number","definition":"sub","containerName":"main::"},{"line":213,"children":[{"localvar":"my","containerName":"total_atoms","name":"$self","definition":"my","line":214,"kind":13},{"line":216,"kind":13,"containerName":"total_atoms","name":"$self"},{"containerName":"total_atoms","name":"$self","line":216,"kind":13},{"line":218,"kind":13,"containerName":"total_atoms","name":"$self"}],"kind":12,"range":{"start":{"line":213,"character":0},"end":{"line":219,"character":9999}},"containerName":"main::","name":"total_atoms","definition":"sub"},{"range":{"end":{"line":237,"character":9999},"start":{"character":0,"line":232}},"definition":"sub","name":"molecular_weight","containerName":"main::","children":[{"line":233,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"molecular_weight"},{"kind":13,"line":234,"name":"$self","containerName":"molecular_weight"},{"line":234,"kind":13,"containerName":"molecular_weight","name":"$self"},{"kind":13,"line":235,"name":"$self","containerName":"molecular_weight"}],"line":232,"kind":12},{"range":{"start":{"character":0,"line":250},"end":{"line":254,"character":9999}},"containerName":"main::","definition":"sub","name":"theoretical_pI","line":250,"children":[{"localvar":"my","containerName":"theoretical_pI","definition":"my","name":"$self","line":251,"kind":13},{"name":"$self","containerName":"theoretical_pI","line":252,"kind":13},{"name":"$self","containerName":"theoretical_pI","kind":13,"line":252},{"containerName":"theoretical_pI","name":"$self","line":253,"kind":13}],"kind":12},{"line":267,"children":[{"kind":13,"line":268,"definition":"my","name":"$self","containerName":"num_carbon","localvar":"my"},{"line":270,"kind":13,"containerName":"num_carbon","name":"$self"},{"name":"$self","containerName":"num_carbon","line":270,"kind":13},{"name":"$self","containerName":"num_carbon","line":272,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":267},"end":{"line":274,"character":9999}},"containerName":"main::","name":"num_carbon","definition":"sub"},{"name":"num_hydrogen","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":294},"start":{"character":0,"line":287}},"kind":12,"children":[{"containerName":"num_hydrogen","definition":"my","name":"$self","localvar":"my","kind":13,"line":288},{"containerName":"num_hydrogen","name":"$self","line":290,"kind":13},{"name":"$self","containerName":"num_hydrogen","line":290,"kind":13},{"line":292,"kind":13,"name":"$self","containerName":"num_hydrogen"}],"line":287},{"range":{"end":{"character":9999,"line":315},"start":{"character":0,"line":307}},"definition":"sub","name":"num_nitro","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"num_nitro","localvar":"my","kind":13,"line":308},{"kind":13,"line":310,"name":"$self","containerName":"num_nitro"},{"containerName":"num_nitro","name":"$self","kind":13,"line":310},{"name":"$self","containerName":"num_nitro","kind":13,"line":313}],"line":307,"kind":12},{"definition":"sub","name":"num_oxygen","containerName":"main::","range":{"start":{"character":0,"line":328},"end":{"line":335,"character":9999}},"kind":12,"children":[{"line":329,"kind":13,"localvar":"my","containerName":"num_oxygen","definition":"my","name":"$self"},{"containerName":"num_oxygen","name":"$self","line":331,"kind":13},{"kind":13,"line":331,"name":"$self","containerName":"num_oxygen"},{"line":333,"kind":13,"containerName":"num_oxygen","name":"$self"}],"line":328},{"kind":12,"children":[{"kind":13,"line":349,"containerName":"num_sulphur","definition":"my","name":"$self","localvar":"my"},{"line":351,"kind":13,"containerName":"num_sulphur","name":"$self"},{"line":351,"kind":13,"containerName":"num_sulphur","name":"$self"},{"containerName":"num_sulphur","name":"$self","kind":13,"line":353}],"line":348,"definition":"sub","name":"num_sulphur","containerName":"main::","range":{"start":{"line":348,"character":0},"end":{"line":354,"character":9999}}},{"line":367,"children":[{"definition":"my","name":"$self","containerName":"half_life","localvar":"my","kind":13,"line":368},{"name":"$self","containerName":"half_life","kind":13,"line":370},{"kind":13,"line":370,"containerName":"half_life","name":"$self"},{"line":372,"kind":13,"containerName":"half_life","name":"$self"}],"kind":12,"range":{"start":{"line":367,"character":0},"end":{"line":373,"character":9999}},"containerName":"main::","definition":"sub","name":"half_life"},{"range":{"start":{"line":386,"character":0},"end":{"line":391,"character":9999}},"containerName":"main::","name":"instability_index","definition":"sub","line":386,"children":[{"kind":13,"line":387,"containerName":"instability_index","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"instability_index","line":389,"kind":13},{"line":389,"kind":13,"name":"$self","containerName":"instability_index"},{"name":"$self","containerName":"instability_index","line":390,"kind":13}],"kind":12},{"range":{"end":{"character":9999,"line":411},"start":{"character":0,"line":404}},"name":"stability","definition":"sub","containerName":"main::","children":[{"line":405,"kind":13,"localvar":"my","containerName":"stability","name":"$self","definition":"my"},{"containerName":"stability","name":"$self","kind":13,"line":407},{"name":"$self","containerName":"stability","kind":13,"line":407},{"containerName":"stability","name":"$self","line":409,"kind":13}],"line":404,"kind":12},{"line":424,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"aliphatic_index","line":426,"kind":13},{"kind":13,"line":427,"containerName":"aliphatic_index","name":"$self"},{"line":427,"kind":13,"name":"$self","containerName":"aliphatic_index"},{"containerName":"aliphatic_index","name":"$self","line":428,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":430},"start":{"character":0,"line":424}},"containerName":"main::","name":"aliphatic_index","definition":"sub"},{"line":443,"children":[{"name":"$self","definition":"my","containerName":"gravy","localvar":"my","kind":13,"line":444},{"line":446,"kind":13,"containerName":"gravy","name":"$self"},{"line":446,"kind":13,"name":"$self","containerName":"gravy"},{"kind":13,"line":447,"name":"$self","containerName":"gravy"}],"kind":12,"range":{"end":{"character":9999,"line":448},"start":{"character":0,"line":443}},"containerName":"main::","name":"gravy","definition":"sub"},{"children":[{"kind":13,"line":463,"containerName":"AA_comp","name":"$self","definition":"my","localvar":"my"},{"definition":"my","name":"$aa","containerName":"AA_comp","localvar":"my","kind":13,"line":464},{"line":466,"kind":13,"containerName":"AA_comp","name":"$aa"},{"name":"$aa","containerName":"AA_comp","line":466,"kind":13},{"line":468,"kind":13,"localvar":"my","definition":"my","name":"$AA","containerName":"AA_comp"},{"name":"$self","containerName":"AA_comp","kind":13,"line":470},{"line":470,"kind":13,"containerName":"AA_comp","name":"$aa"},{"line":470,"kind":13,"name":"$self","containerName":"AA_comp"},{"containerName":"AA_comp","name":"$self","kind":13,"line":472},{"containerName":"AA_comp","name":"$aa","kind":13,"line":472}],"line":461,"kind":12,"range":{"start":{"character":0,"line":461},"end":{"character":9999,"line":473}},"name":"AA_comp","definition":"sub","containerName":"main::"}],"version":5}