{"vars":[{"kind":2,"line":127,"containerName":"","name":"vars"},{"kind":2,"line":133,"name":"base","containerName":""},{"name":"@Models","containerName":null,"kind":13,"line":134},{"range":{"start":{"character":0,"line":158},"end":{"line":160,"character":9999}},"name":"next_feature","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: QRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::QRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::QRNA - A Parser for qrna output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::QRNA;\n  my $parser = Bio::Tools::QRNA->new(-file => $qrnaoutput);\n  while( my $feature = $parser->next_feature ) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses QRNA output (E.Rivas:\nhttp://selab.janelia.org/software.html\nftp://selab.janelia.org/pub/software/qrna/).\n\nThis module is not complete, but currently it packs information from\neach QRNA alignment into a single Bio::SeqFeature::Generic object.\n\nNot all options for QRNA output have been tested or tried.  It has\nbeen tested on sliding window output (-w -x) and shuffled output (-b\nor -B).\n\nSee t/QRNA.t for example usage.\n\nAt some point we may have more complicated feature object which will\nsupport this data rather than forcing most of the information into\ntag/value pairs in a SeqFeature::Generic.\n\nRunning with -verbose =E<gt> 1 will store extra data in the feature.  The\nentire unparsed entry for a particular feature will be stored as a\nstring in the tag 'entry' it is accessible via:\n\n  my ($entry) = $f->each_tag_value('entry');\n\nThe winning model for any given alignment test will be the name stored\nin the primary_tag field of feature.  The bit score will stored in the\nscore field.  The logoddpost is availble via the a tag/value pair.\nThis example code will show how to print out the score and log odds\npost for each model.\n\n  # assuming you got a feature already\n  print \"model score logoddspost\\n\";\n  foreach my $model ( qw(OTH COD RNA) ) {\n    my ($score)       = $f->get_tag_values(\"$model\\_score\");\n    my ($logoddspost) = $f->get_tag_values(\"$model\\_logoddspost\");\n    print \"$model $score $logoddspost\\n\";\n  }\n\nThe start and end of the alignment for both the query and hit sequence\nare available through the L<Bio::SeqFeature::FeaturePair> interface,\nspecifically L<Bio::SeqFeature::FeaturePair::feature1> and\nL<Bio::SeqFeature::FeaturePair::feature2>.  Additionally if you have\nrun QRNA with an input file which has the location of the alignment\nstored in the FASTA filename as in (ID/START-END) which is the default\noutput format from L<Bio::AlignIO::fasta> produced alignment output,\nthis module will re-number start/end for the two sequences so they are\nin the actual coordinates of the sequence rather than the relative\ncoordinates of the alignment.  You may find the bioperl utillity\nscript search2alnblocks useful in creating your input files for QRNA.\n\nSome other words of warning, QRNA uses a 0 based numbering system for\nsequence locations, Bioperl uses a 1 based system.  You'll notice that\nlocations will be +1 they are reported in the raw QRNA output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::QRNA;\nuse vars qw(@Models);\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::IO Bio::SeqAnalysisParserI);\n@Models = qw(OTH COD RNA);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::QRNA->new();\n Function: Builds a new Bio::Tools::QRNA object \n Returns : an instance of Bio::Tools::QRNA\n Args    : -fh/-file filehandle/filename standard input for \n                     Bio::Root:IO objects\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feature = $parser->next_feature\n Function: Get the next QRNA feature\n Returns : \n Args    :","label":"next_feature($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"next_feature","definition":"my","name":"$self","localvar":"my","kind":13,"line":159},{"line":160,"kind":13,"localvar":"my","containerName":"next_feature","name":"$f","definition":"my"},{"name":"$self","containerName":"next_feature","kind":13,"line":160}],"line":158,"kind":12},{"kind":13,"line":161,"containerName":null,"name":"$f"},{"kind":13,"line":161,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_parse_pair","line":161,"kind":12},{"kind":13,"line":162,"containerName":null,"name":"$f"},{"containerName":null,"name":"%self","line":162,"kind":13},{"containerName":null,"name":"$f","line":164,"kind":13},{"name":"_parse_pair","range":{"start":{"character":0,"line":167},"end":{"character":9999,"line":200}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_parse_pair","line":168,"kind":13},{"kind":13,"line":168,"containerName":"_parse_pair","name":"@args"},{"containerName":"_parse_pair","name":"@features","definition":"my","localvar":"my","kind":13,"line":169},{"name":"%data","containerName":"_parse_pair","kind":13,"line":169},{"localvar":"my","containerName":"_parse_pair","definition":"my","name":"$seenstart","line":170,"kind":13},{"containerName":"_parse_pair","name":"$self","kind":13,"line":171},{"containerName":"_parse_pair","name":"_readline","kind":12,"line":171},{"name":"$self","containerName":"_parse_pair","kind":13,"line":174},{"kind":12,"line":174,"containerName":"_parse_pair","name":"program_name"},{"kind":13,"line":175,"name":"$self","containerName":"_parse_pair"},{"containerName":"_parse_pair","name":"program_version","kind":12,"line":175},{"line":176,"kind":13,"containerName":"_parse_pair","name":"$self"},{"name":"program_date","containerName":"_parse_pair","line":176,"kind":12},{"line":178,"kind":13,"containerName":"_parse_pair","name":"$self"},{"line":178,"kind":12,"name":"PAM_model","containerName":"_parse_pair"},{"name":"$self","containerName":"_parse_pair","line":180,"kind":13},{"name":"RNA_model","containerName":"_parse_pair","kind":12,"line":180},{"kind":13,"line":182,"name":"$self","containerName":"_parse_pair"},{"name":"seq_file","containerName":"_parse_pair","kind":12,"line":182},{"containerName":"_parse_pair","name":"$seenstart","line":184,"kind":13},{"line":185,"kind":13,"containerName":"_parse_pair","name":"$data"},{"kind":13,"line":186,"containerName":"_parse_pair","name":"@features"},{"kind":13,"line":186,"containerName":"_parse_pair","name":"$self"},{"line":186,"kind":12,"name":"_make_feature","containerName":"_parse_pair"},{"containerName":"_parse_pair","name":"%data","line":186,"kind":13},{"containerName":"_parse_pair","name":"$self","line":188,"kind":13},{"containerName":"_parse_pair","name":"_pushback","line":188,"kind":12},{"line":191,"kind":13,"containerName":"_parse_pair","name":"$seenstart"},{"line":195,"kind":13,"name":"$data","containerName":"_parse_pair"},{"kind":13,"line":196,"containerName":"_parse_pair","name":"$self"},{"name":"warn","containerName":"_parse_pair","line":196,"kind":12},{"containerName":"_parse_pair","name":"$data","kind":13,"line":197},{"kind":13,"line":199,"name":"$data","containerName":"_parse_pair"}],"line":167,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_parse_pair($self,@args)"},"detail":"($self,@args)"},{"containerName":null,"name":"%data","kind":13,"line":203},{"containerName":null,"name":"@features","kind":13,"line":204},{"containerName":null,"name":"$self","kind":13,"line":204},{"kind":12,"line":204,"containerName":"main::","name":"_make_feature"},{"line":204,"kind":13,"containerName":null,"name":"%data"},{"name":"%data","containerName":null,"kind":13,"line":206},{"name":"%data","containerName":null,"kind":13,"line":206},{"name":"%data","containerName":null,"line":210,"kind":13},{"name":"%data","containerName":null,"line":212,"kind":13},{"kind":13,"line":213,"containerName":null,"name":"%data"},{"name":"%data","containerName":null,"line":216,"kind":13},{"containerName":null,"name":"%data","line":217,"kind":13},{"containerName":null,"name":"%data","kind":13,"line":219},{"kind":13,"line":223,"name":"%data","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$model","line":226,"kind":13},{"containerName":null,"name":"$score","line":226,"kind":13},{"line":227,"kind":13,"name":"%model","containerName":null},{"containerName":null,"name":"%data","line":228,"kind":13},{"line":228,"kind":13,"name":"$model","containerName":null},{"name":"%score","containerName":null,"kind":13,"line":228},{"kind":13,"line":230,"name":"%data","containerName":null},{"line":230,"kind":13,"name":"$model","containerName":null},{"name":"$score","containerName":null,"kind":13,"line":230},{"containerName":null,"name":"%data","kind":13,"line":234},{"name":"@features","containerName":null,"kind":13,"line":236},{"containerName":null,"name":"%self","kind":13,"line":237},{"containerName":null,"name":"@features","kind":13,"line":237},{"kind":13,"line":238,"containerName":null,"name":"@features"},{"range":{"end":{"character":9999,"line":259},"start":{"line":255,"character":0}},"name":"PAM_model","definition":"sub","containerName":"main::","children":[{"line":256,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"PAM_model"},{"kind":13,"line":257,"containerName":"PAM_model","name":"$self"},{"name":"$self","containerName":"PAM_model","line":258,"kind":13}],"line":255,"kind":12},{"line":273,"children":[{"line":274,"kind":13,"localvar":"my","containerName":"RNA_model","name":"$self","definition":"my"},{"name":"$self","containerName":"RNA_model","line":276,"kind":13},{"kind":13,"line":277,"name":"$self","containerName":"RNA_model"}],"kind":12,"range":{"start":{"line":273,"character":0},"end":{"character":9999,"line":278}},"containerName":"main::","name":"RNA_model","definition":"sub"},{"kind":12,"line":292,"children":[{"localvar":"my","containerName":"seq_file","name":"$self","definition":"my","line":293,"kind":13},{"kind":13,"line":295,"name":"$self","containerName":"seq_file"},{"line":296,"kind":13,"name":"$self","containerName":"seq_file"}],"containerName":"main::","definition":"sub","name":"seq_file","range":{"end":{"character":9999,"line":297},"start":{"line":292,"character":0}}},{"kind":12,"line":312,"children":[{"localvar":"my","containerName":"program_name","definition":"my","name":"$self","line":313,"kind":13},{"kind":13,"line":315,"containerName":"program_name","name":"$self"},{"line":316,"kind":13,"containerName":"program_name","name":"$self"}],"containerName":"main::","name":"program_name","definition":"sub","range":{"end":{"line":317,"character":9999},"start":{"line":312,"character":0}}},{"kind":12,"line":331,"children":[{"line":332,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"program_version"},{"kind":13,"line":334,"containerName":"program_version","name":"$self"},{"line":335,"kind":13,"containerName":"program_version","name":"$self"}],"containerName":"main::","definition":"sub","name":"program_version","range":{"end":{"character":9999,"line":336},"start":{"line":331,"character":0}}},{"name":"program_date","definition":"sub","containerName":"main::","range":{"start":{"line":350,"character":0},"end":{"character":9999,"line":354}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"program_date","localvar":"my","kind":13,"line":351},{"containerName":"program_date","name":"$self","line":352,"kind":13},{"kind":13,"line":353,"containerName":"program_date","name":"$self"}],"line":350},{"kind":12,"line":356,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_make_feature","line":357,"kind":13},{"line":357,"kind":13,"containerName":"_make_feature","name":"$data"},{"containerName":"_make_feature","definition":"my","name":"$qoffset","localvar":"my","kind":13,"line":358},{"line":358,"kind":13,"name":"$hoffset","containerName":"_make_feature"},{"kind":13,"line":364,"definition":"my","name":"$qid","containerName":"_make_feature","localvar":"my"},{"name":"$hid","containerName":"_make_feature","kind":13,"line":364},{"kind":13,"line":364,"name":"$data","containerName":"_make_feature"},{"kind":13,"line":365,"name":"$data","containerName":"_make_feature"},{"kind":13,"line":366,"containerName":"_make_feature","name":"$qid"},{"containerName":"_make_feature","name":"$qid","line":367,"kind":13},{"kind":13,"line":367,"name":"$qoffset","containerName":"_make_feature"},{"line":369,"kind":13,"name":"$hid","containerName":"_make_feature"},{"name":"$hid","containerName":"_make_feature","line":370,"kind":13},{"containerName":"_make_feature","name":"$hoffset","line":370,"kind":13},{"kind":13,"line":373,"name":"$f","definition":"my","containerName":"_make_feature","localvar":"my"},{"line":373,"kind":12,"containerName":"_make_feature","name":"new"},{"name":"$s","definition":"my","containerName":"_make_feature","localvar":"my","kind":13,"line":375},{"kind":13,"line":375,"name":"$e","containerName":"_make_feature"},{"line":375,"kind":13,"name":"$data","containerName":"_make_feature"},{"name":"$data","containerName":"_make_feature","line":375,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"_make_feature($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":""},"name":"_make_feature","range":{"end":{"character":9999,"line":375},"start":{"line":356,"character":0}}},{"containerName":"SeqFeature::FeaturePair","name":"Bio","line":373,"kind":12},{"definition":"my","name":"$qf","containerName":null,"localvar":"my","kind":13,"line":376},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":376},{"kind":12,"line":377,"containerName":"main::","name":"new"},{"kind":13,"line":377,"name":"%data","containerName":null},{"name":"$self","containerName":null,"line":378,"kind":13},{"name":"program_name","containerName":"main::","line":378,"kind":12},{"kind":13,"line":379,"name":"%data","containerName":null},{"containerName":null,"name":"%data","kind":13,"line":379},{"name":"$s","containerName":null,"line":380,"kind":13},{"kind":13,"line":380,"containerName":null,"name":"$qoffset"},{"name":"$e","containerName":null,"line":381,"kind":13},{"containerName":null,"name":"$qoffset","line":381,"kind":13},{"name":"$qid","containerName":null,"kind":13,"line":382},{"containerName":null,"name":"$s","kind":13,"line":383},{"kind":13,"line":383,"containerName":null,"name":"$e"},{"localvar":"my","containerName":null,"definition":"my","name":"$hf","line":386,"kind":13},{"name":"Bio","containerName":"SeqFeature::Generic","line":386,"kind":12},{"containerName":"main::","name":"new","kind":12,"line":387},{"kind":13,"line":387,"containerName":null,"name":"$qf"},{"containerName":"main::","name":"primary_tag","line":387,"kind":12},{"kind":13,"line":388,"name":"$qf","containerName":null},{"name":"source_tag","containerName":"main::","kind":12,"line":388},{"kind":13,"line":389,"name":"$qf","containerName":null},{"kind":12,"line":389,"name":"score","containerName":"main::"},{"line":390,"kind":13,"containerName":null,"name":"$hid"},{"containerName":null,"name":"$s","kind":13,"line":391},{"kind":13,"line":391,"name":"$hoffset","containerName":null},{"kind":13,"line":392,"containerName":null,"name":"$e"},{"containerName":null,"name":"$hoffset","kind":13,"line":392},{"containerName":null,"name":"$qf","kind":13,"line":393},{"kind":12,"line":393,"name":"strand","containerName":"main::"},{"name":"$f","containerName":null,"line":395,"kind":13},{"kind":12,"line":395,"containerName":"main::","name":"feature1"},{"line":395,"kind":13,"name":"$qf","containerName":null},{"kind":13,"line":396,"name":"$f","containerName":null},{"kind":12,"line":396,"name":"feature2","containerName":"main::"},{"kind":13,"line":396,"name":"$hf","containerName":null},{"containerName":null,"name":"$f","line":397,"kind":13},{"kind":12,"line":397,"containerName":"main::","name":"add_tag_value"},{"name":"%data","containerName":null,"kind":13,"line":397},{"kind":13,"line":398,"name":"$f","containerName":null},{"name":"add_tag_value","containerName":"main::","kind":12,"line":398},{"kind":13,"line":398,"name":"%data","containerName":null},{"definition":"my","name":"$model","containerName":null,"localvar":"my","kind":13,"line":400},{"kind":13,"line":400,"containerName":null,"name":"@Models"},{"kind":13,"line":401,"containerName":null,"name":"$f"},{"kind":12,"line":401,"name":"add_tag_value","containerName":"main::"},{"name":"%data","containerName":null,"kind":13,"line":401},{"kind":13,"line":401,"containerName":null,"name":"$model"},{"containerName":null,"name":"$f","line":402,"kind":13},{"name":"add_tag_value","containerName":"main::","kind":12,"line":402},{"name":"%data","containerName":null,"line":402,"kind":13},{"line":402,"kind":13,"name":"$model","containerName":null},{"kind":13,"line":403,"containerName":null,"name":"%data"},{"containerName":null,"name":"%model","line":403,"kind":13},{"containerName":null,"name":"$self","line":404,"kind":13},{"name":"verbose","containerName":"main::","kind":12,"line":404},{"containerName":null,"name":"$self","line":405,"kind":13},{"kind":12,"line":405,"name":"debug","containerName":"main::"},{"name":"%data","containerName":null,"kind":13,"line":405},{"line":407,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":407},{"kind":13,"line":408,"name":"$_","containerName":null},{"name":"%data","containerName":null,"kind":13,"line":408},{"kind":13,"line":408,"containerName":null,"name":"$f"},{"containerName":"main::","name":"start","kind":12,"line":408},{"containerName":null,"name":"$f","line":408,"kind":13},{"name":"end","containerName":"main::","kind":12,"line":408},{"kind":13,"line":410,"containerName":null,"name":"$f"},{"containerName":"main::","name":"add_tag_value","line":410,"kind":12},{"name":"%data","containerName":null,"kind":13,"line":411},{"name":"$model","containerName":null,"line":411,"kind":13},{"name":"$f","containerName":null,"kind":13,"line":416},{"line":416,"kind":12,"name":"add_tag_value","containerName":"main::"},{"line":416,"kind":13,"containerName":null,"name":"%data"},{"name":"$f","containerName":null,"line":417,"kind":13},{"line":417,"kind":12,"name":"add_tag_value","containerName":"main::"},{"containerName":null,"name":"%data","line":417,"kind":13},{"kind":13,"line":418,"containerName":null,"name":"$f"},{"name":"add_tag_value","containerName":"main::","line":418,"kind":12},{"line":418,"kind":13,"containerName":null,"name":"%data"},{"name":"$self","containerName":null,"kind":13,"line":418},{"name":"verbose","containerName":"main::","kind":12,"line":418},{"kind":13,"line":419,"containerName":null,"name":"%data"},{"name":"$f","containerName":null,"kind":13,"line":420},{"name":"add_tag_value","containerName":"main::","line":420,"kind":12},{"kind":13,"line":420,"containerName":null,"name":"%data"},{"kind":13,"line":422,"name":"$f","containerName":null}],"version":5}