{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":80},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: RepeatMasker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RepeatMasker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RepeatMasker - a parser for RepeatMasker output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::RepeatMasker;\n    my $parser = Bio::Tools::RepeatMasker->new(-file => 'seq.fa.out');\n    while( my $result = $parser->next_result ) {\n      # get some value\n    }\n\n=head1 DESCRIPTION\n\nA parser for RepeatMasker output\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RepeatMasker;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RepeatMasker->new();\n Function: Builds a new Bio::Tools::RepeatMasker object\n Returns : Bio::Tools::RepeatMasker\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":93,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"kind":13,"line":93,"containerName":"new","name":"@args"},{"kind":13,"line":95,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":95,"containerName":"new","name":"$class"},{"kind":13,"line":95,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":96,"kind":13},{"line":96,"kind":12,"name":"_initialize_io","containerName":"new"},{"line":96,"kind":13,"containerName":"new","name":"@args"},{"line":98,"kind":13,"containerName":"new","name":"$self"}],"line":92,"name":"new","range":{"end":{"line":99,"character":9999},"start":{"character":0,"line":92}}},{"kind":12,"line":95,"name":"SUPER","containerName":"new"},{"name":"next_result","range":{"end":{"character":9999,"line":165},"start":{"character":0,"line":112}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RepeatMasker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RepeatMasker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RepeatMasker - a parser for RepeatMasker output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::RepeatMasker;\n    my $parser = Bio::Tools::RepeatMasker->new(-file => 'seq.fa.out');\n    while( my $result = $parser->next_result ) {\n      # get some value\n    }\n\n=head1 DESCRIPTION\n\nA parser for RepeatMasker output\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RepeatMasker;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RepeatMasker->new();\n Function: Builds a new Bio::Tools::RepeatMasker object\n Returns : Bio::Tools::RepeatMasker\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $rpt_masker->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::FeaturePair\n           Feature1 is the Query coordinates and Feature2 is the Hit\n Args    : none"},"kind":12,"line":112,"children":[{"kind":13,"line":113,"containerName":"next_result","definition":"my","name":"$self","localvar":"my"},{"containerName":"next_result","name":"$self","line":114,"kind":13},{"line":114,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"line":116,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"warn","kind":12,"line":116},{"name":"@element","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":121},{"name":"$element","containerName":"next_result","line":123,"kind":13},{"kind":13,"line":124,"definition":"my","name":"%feat1","containerName":"next_result","localvar":"my"},{"name":"%feat2","containerName":"next_result","line":124,"kind":13},{"line":125,"kind":13,"localvar":"my","definition":"my","name":"@line","containerName":"next_result"},{"name":"$score","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":126},{"name":"$query_name","containerName":"next_result","kind":13,"line":126},{"line":126,"kind":13,"containerName":"next_result","name":"$query_start"},{"kind":13,"line":126,"name":"$query_end","containerName":"next_result"},{"line":126,"kind":13,"containerName":"next_result","name":"$strand"},{"line":127,"kind":13,"name":"$repeat_name","containerName":"next_result"},{"line":127,"kind":13,"containerName":"next_result","name":"$repeat_class"},{"line":127,"kind":13,"containerName":"next_result","name":"@line"},{"definition":"my","name":"$hit_start","containerName":"next_result","localvar":"my","kind":13,"line":129},{"name":"$hit_end","containerName":"next_result","line":129,"kind":13},{"name":"$strand","containerName":"next_result","kind":13,"line":131},{"kind":13,"line":132,"containerName":"next_result","name":"$hit_start"},{"containerName":"next_result","name":"$hit_end","kind":13,"line":132},{"kind":13,"line":132,"containerName":"next_result","name":"@line"},{"line":133,"kind":13,"containerName":"next_result","name":"$strand"},{"containerName":"next_result","name":"$strand","kind":13,"line":134},{"name":"$hit_start","containerName":"next_result","kind":13,"line":135},{"line":135,"kind":13,"name":"$hit_end","containerName":"next_result"},{"line":135,"kind":13,"name":"@line","containerName":"next_result"},{"name":"$strand","containerName":"next_result","line":136,"kind":13},{"localvar":"my","containerName":"next_result","name":"$rf","definition":"my","line":138,"kind":13},{"line":139,"kind":12,"name":"new","containerName":"next_result"},{"name":"$query_name","containerName":"next_result","line":139,"kind":13},{"kind":13,"line":140,"name":"$score","containerName":"next_result"},{"name":"$query_start","containerName":"next_result","kind":13,"line":141},{"containerName":"next_result","name":"$query_end","line":142,"kind":13},{"name":"$strand","containerName":"next_result","kind":13,"line":143},{"name":"$repeat_class","containerName":"next_result","line":145,"kind":13},{"kind":13,"line":146,"name":"$repeat_name","containerName":"next_result"},{"name":"$hit_start","containerName":"next_result","kind":13,"line":146},{"containerName":"next_result","name":"$hit_end","kind":13,"line":146},{"line":149,"kind":13,"localvar":"my","name":"$rf2","definition":"my","containerName":"next_result"},{"containerName":"next_result","name":"new","line":150,"kind":12},{"line":150,"kind":13,"containerName":"next_result","name":"$repeat_name"},{"kind":13,"line":151,"containerName":"next_result","name":"$score"},{"kind":13,"line":152,"name":"$hit_start","containerName":"next_result"},{"line":153,"kind":13,"name":"$hit_end","containerName":"next_result"},{"line":154,"kind":13,"containerName":"next_result","name":"$strand"},{"kind":13,"line":156,"name":"$repeat_class","containerName":"next_result"},{"line":157,"kind":13,"containerName":"next_result","name":"$query_name"},{"line":157,"kind":13,"name":"$query_start","containerName":"next_result"},{"line":157,"kind":13,"name":"$query_end","containerName":"next_result"},{"localvar":"my","containerName":"next_result","name":"$fp","definition":"my","line":160,"kind":13},{"containerName":"next_result","name":"new","kind":12,"line":160},{"containerName":"next_result","name":"$rf","line":160,"kind":13},{"name":"$rf2","containerName":"next_result","line":161,"kind":13},{"containerName":"next_result","name":"$fp","kind":13,"line":162}]},{"name":"Bio","containerName":"SeqFeature::Generic","line":138,"kind":12},{"containerName":"SeqFeature::Generic","name":"Bio","line":149,"kind":12},{"name":"Bio","containerName":"SeqFeature::FeaturePair","line":160,"kind":12}]}