{"version":5,"vars":[{"line":258,"kind":2,"name":"base","containerName":""},{"line":260,"kind":13,"name":"$AUTOLOAD","definition":"our","containerName":"main::"},{"containerName":"main::","name":"$DEFAULTBLASTTYPE","definition":"our","line":261,"kind":13},{"containerName":"main::","definition":"our","name":"$DEFAULTREADMETHOD","kind":13,"line":262},{"definition":"our","name":"$DATADIR","containerName":"main::","kind":13,"line":267},{"name":"%ENV","containerName":null,"line":267,"kind":13},{"line":267,"kind":13,"containerName":null,"name":"%ENV"},{"name":"$DATADIR","containerName":null,"line":268,"kind":13},{"kind":13,"line":268,"containerName":null,"name":"%ENV"},{"kind":13,"line":269,"name":"$dir","definition":"my","containerName":null,"localvar":"my"},{"containerName":"Root::IO","name":"Bio","kind":12,"line":269},{"kind":12,"line":269,"containerName":"main::","name":"catfile"},{"kind":13,"line":269,"containerName":null,"name":"%ENV"},{"name":"%dir","containerName":null,"kind":13,"line":270},{"line":271,"kind":13,"name":"$DATADIR","containerName":null},{"name":"$dir","containerName":null,"kind":13,"line":271},{"containerName":null,"name":"%ENV","line":273,"kind":13},{"containerName":null,"name":"$dir","kind":13,"line":274},{"line":274,"kind":13,"name":"%ENV","containerName":null},{"name":"$dir","containerName":null,"line":275,"kind":13},{"kind":13,"line":276,"name":"$DATADIR","containerName":null},{"name":"$dir","containerName":null,"line":276,"kind":13},{"line":276,"kind":13,"containerName":null,"name":"$dir"},{"line":354,"children":[{"containerName":"new","definition":"my","name":"$caller","localvar":"my","kind":13,"line":355},{"name":"@args","containerName":"new","line":355,"kind":13},{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":356},{"line":356,"kind":13,"containerName":"new","name":"$caller"},{"containerName":"new","name":"$caller","line":356,"kind":13},{"line":365,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":366,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","line":366,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"%args","line":369,"kind":13},{"kind":13,"line":369,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$blasttype","definition":"my","line":370,"kind":13},{"containerName":"new","name":"$DEFAULTBLASTTYPE","kind":13,"line":370},{"line":371,"kind":13,"localvar":"my","definition":"my","name":"$attr","containerName":"new"},{"line":371,"kind":13,"name":"$value","containerName":"new"},{"line":371,"kind":13,"containerName":"new","name":"%args"},{"kind":13,"line":372,"name":"$attr","containerName":"new"},{"kind":13,"line":373,"name":"$value","containerName":"new"},{"containerName":"new","name":"$blasttype","line":374,"kind":13},{"containerName":"new","definition":"my","name":"$module","localvar":"my","kind":13,"line":379},{"line":380,"kind":12,"containerName":"new","name":"_load_module"},{"kind":13,"line":380,"name":"$module","containerName":"new"},{"kind":13,"line":381,"containerName":"new","name":"$module"},{"line":381,"kind":12,"containerName":"new","name":"new"},{"kind":13,"line":381,"name":"@args","containerName":"new"}],"kind":12,"detail":"($caller,@args)","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: StandAloneBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneBlast - Object for the local execution \nof the NCBI BLAST program suite (blastall, blastpgp, bl2seq). \nThere is experimental support for WU-Blast and NCBI rpsblast.\n\n=head1 SYNOPSIS\n\n # Local-blast \"factory object\" creation and blast-parameter\n # initialization:\n @params = (-database => 'swissprot', -outfile => 'blast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\n # Blast a sequence against a database:\n $str = Bio::SeqIO->new(-file=>'t/amino.fa', -format => 'Fasta');\n $input = $str->next_seq();\n $input2 = $str->next_seq();\n $blast_report = $factory->blastall($input);\n\n # Run an iterated Blast (psiblast) of a sequence against a database:\n $factory->j(3);    # 'j' is blast parameter for # of iterations\n $factory->outfile('psiblast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n $blast_report = $factory->blastpgp($input);\n\n # Use blast to align 2 sequences against each other:\n $factory = Bio::Tools::Run::StandAloneBlast->new(-outfile => 'bl2seq.out');\n $factory->bl2seq($input, $input2);\n\n # Experimental support for WU-Blast 2.0\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-program =>\"wublastp\",\n                                                     -database =>\"swissprot\",\n                                                     -e => 1e-20); \n my $blast_report = $factory->wublast($seq);\n\n # Experimental support for NCBI rpsblast\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-db => 'CDD/Cog', \n                                                     -expect => 0.001);\n $factory->F('T'); # turn on SEG filtering of query sequence\n my $blast_report = $factory->rpsblast($seq);\n\n # Use the experimental fast Blast parser, 'blast_pull'\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-_READMETHOD =>'blast_pull',\n                                                     @other_params);\n\n # Various additional options and input formats are available,\n # see the DESCRIPTION section for details.\n\n=head1 DESCRIPTION\n\nThis DESCRIPTION only documents Bio::Tools::Run::StandAloneBlast: - a\nBioperl object for running the NCBI standAlone BLAST package. Blast\nitself, is a large & complex program - for more information regarding\nBLAST, please see the BLAST documentation which accompanies the BLAST\ndistribution. BLAST is available from ftp://ncbi.nlm.nih.gov/blast/.\n\nA source of confusion in documenting a BLAST interface is that the\nterm \"program\" is used in - at least - three different ways in the\nBLAST documentation. In this DESCRIPTION, \"program\" will refer to the\nBLAST routine set by the BLAST C<-p> parameter that can be set to blastn,\nblastp, tblastx etc. We will use the term Blast \"executable\" to refer\nto the various different executable files that may be called - ie.\nblastall, blastpgp or bl2seq. In addition, there are several BLAST\ncapabilities, which are also referred to as \"programs\", and are\nimplemented by using specific combinations of BLAST executables,\nprograms and parameters. They will be referred by their specific\nnames - eg PSIBLAST and PHIBLAST.\n\nBefore running StandAloneBlast it is necessary: to install BLAST \non your system, to edit set the environmental variable $BLASTDIR \nor your $PATH variable to point to the BLAST directory, and to \nensure that users have execute privileges for the BLAST program.  \n\nIf the databases which will be searched by BLAST are located in the \ndata subdirectory of the blast program directory (the default \ninstallation location), StandAloneBlast will find them; however, \nif the database files are located in any other location, environmental \nvariable $BLASTDATADIR will need to be set to point to that directory.\n\nThe use of the StandAloneBlast module is as follows: Initially, a\nlocal blast \"factory object\" is created. The constructor may be passed\nan optional array of (non-default) parameters to be used by the\nfactory, eg:\n\n @params = (-program => 'blastn', -database => 'ecoli.nt');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\nAny parameters not explicitly set will remain as the defaults of the\nBLAST executable. Note each BLAST executable has somewhat different\nparameters and options. See the BLAST Documentation for a description\nor run the BLAST executable from the command line followed solely with\na \"-\" to see a list of options and default values for that executable;\neg E<gt>blastall -.\n\nBLAST parameters can be changed and/or examined at any time after the\nfactory has been created. The program checks that any\nparameter/switch being set/read is valid. Except where specifically\nnoted, StandAloneBlast uses the same single-letter, case-sensitive\nparameter names as the actual blast program. Currently no checks are\nincluded to verify that parameters are of the proper type (e.g. string\nor numeric) or that their values are within the proper range.\n\nAs an example, to change the value of the Blast parameter 'e' ('e' is\nthe parameter for expectation-value cutoff) \n\n  $expectvalue = 0.01;\n  $factory->e($expectvalue);\n\nNote that for improved script readibility one can modify the name of\nthe (ncbi) BLAST parameters as desired as long as the initial letter (and\ncase) of the parameter are preserved, e.g.:\n\n  $factory->expectvalue($expectvalue);\n\nUnfortunately, some of the BLAST parameters are not the single \nletter one might expect (eg \"iteration round\" in blastpgp is 'j'). \nAgain one can check by using, for example:\n\n  > blastpgp -\n\nWublast parameters need to be complete (ie. don't truncate them to their\nfirst letter), but are case-insensitive.\n\nOnce the factory has been created and the appropriate parameters set,\none can call one of the supported blast executables. The input\nsequence(s) to these executables may be fasta file(s) as described in\nthe BLAST documentation.\n\n  $inputfilename = 't/testquery.fa';\n  $blast_report = $factory->blastall($inputfilename);\n\nIn addition, sequence input may be in the form of either a Bio::Seq\nobject or (a reference to) an array of Bio::Seq objects, e.g.:\n\n  $input = Bio::Seq->new(-id => \"test query\",\n                         -seq => \"ACTACCCTTTAAATCAGTGGGGG\");\n  $blast_report = $factory->blastall($input);\n\nNOTE: Use of the BPlite method has been deprecated and is no longer supported.\n\nFor blastall and non-psiblast blastpgp runs, report object is aL<Bio::SearchIO>\nobject, selected by the user with the parameter _READMETHOD. The leading\nunderscore is needed to distinguish this option from options which are passed to\nthe BLAST executable. The default parser is Bio::SearchIO::blast. In any case,\nthe \"raw\" blast report is also available. The filename is set by the 'outfile'\nparameter and has the default value of \"blastreport.out\".\n\nFor psiblast execution in the BLAST \"jumpstart\" mode, the program must\nbe passed (in addition to the query sequence itself) an alignment\ncontaining the query sequence (in the form of a SimpleAlign object) as\nwell as a \"mask\" specifying at what residues position-specific scoring\nmatrices (PSSMs) are to used and at what residues default scoring\nmatrices (eg BLOSUM) are to be used. See psiblast documentation for\nmore details. The mask itself is a string of 0's and 1's which is the\nsame length as each sequence in the alignment and has a \"1\" at\nlocations where (PSSMs) are to be used and a \"0\" at all other\nlocations. So for example:\n\n  $str = Bio::AlignIO->new(-file => \"cysprot.msf\", \n                           -format => 'msf');\n  $aln = $str->next_aln();\n  $len = $aln->length_aln();\n  $mask = '1' x $len;\n  # simple case where PSSM's to be used at all residues\n  $report = $factory->blastpgp(\"cysprot1.fa\", $aln, $mask);\n\nFor bl2seq execution, StandAloneBlast.pm can be combined with\nAlignIO.pm to directly produce a SimpleAlign object from the alignment\nof the two sequences produced by bl2seq as in:\n\n  # Get 2 sequences\n  $str = Bio::SeqIO->new(-file=>'t/amino.fa' , -format => 'Fasta');\n  my $seq3 = $str->next_seq();\n  my $seq4 = $str->next_seq();\n\n  # Run bl2seq on them\n  $factory = Bio::Tools::Run::StandAloneBlast->new(-program => 'blastp',\n                                                   -outfile => 'bl2seq.out');\n  my $bl2seq_report = $factory->bl2seq($seq3, $seq4);\n\n  # Use AlignIO.pm to create a SimpleAlign object from the bl2seq report\n  $str = Bio::AlignIO->new(-file=> 'bl2seq.out',-format => 'bl2seq');\n  $aln = $str->next_aln();\n\nFor more examples of syntax and use of StandAloneBlast.pm, the user is\nencouraged to run the scripts standaloneblast.pl in the bioperl\nexamples/tools directory and StandAloneBlast.t in the bioperl t/ \ndirectory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneBlast;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Seq;\nuse Bio::SeqIO;\nuse Bio::SearchIO;\nuse File::Spec;\n\nuse base qw(Bio::Tools::Run::WrapperBase Bio::Factory::ApplicationFactoryI);\n\nour $AUTOLOAD;\nour $DEFAULTBLASTTYPE = 'NCBI';\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $ENV{'BLASTDATADIR'} || $ENV{'BLASTDB'};\nif (! defined $DATADIR && defined $ENV{'BLASTDIR'}) {\n    my $dir = Bio::Root::IO->catfile($ENV{'BLASTDIR'}, 'data');\n    if (-d $dir) {\n        $DATADIR = $dir;\n    }\n    elsif ($ENV{'BLASTDIR'} =~ /bin/) {\n        $dir = $ENV{'BLASTDIR'};\n        $dir =~ s/bin/data/;\n        $DATADIR = $dir if -d $dir;\n    }\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneNCBIBlast or StandAloneWUBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p in those programs that\nhave it. For a complete listing of settable parameters, run the relevant\nexecutable BLAST program with the option \"-\" as in blastall -\nNote that the input paramters (-i, -j, -input) should not be set directly by\nyou: this module sets them when you call one of the executable methods.\n\nBlastall\n\n  -p  Program Name [String]\n        Input should be one of \"blastp\", \"blastn\", \"blastx\", \n        \"tblastn\", or \"tblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"nr est\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n  -S  Query strands to search against database (for blast[nx], and tblastx). 3 is both, 1 is top, 2 is bottom [Integer]\n\t    default = 3\n\nBlastpgp (including Psiblast)\n\n  -j  is the maximum number of rounds (default 1; i.e., regular BLAST)\n  -h  is the e-value threshold for including sequences in the\n\t    score matrix model (default 0.001)\n  -c  is the \"constant\" used in the pseudocount formula specified in the paper (default 10)\n  -B  Multiple alignment file for PSI-BLAST \"jump start mode\"  Optional\n  -Q  Output File for PSI-BLAST Matrix in ASCII [File Out]  Optional\n\nrpsblast\n\n  -d  Database [String] default = (none - you must specify a database)\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"Cog Smart\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\nBl2seq\n\n  -p  Program name: blastp, blastn, blastx. For blastx 1st argument should be nucleotide [String]\n    default = blastp\n  -o  alignment output file [File Out] default = stdout\n  -e  Expectation value (E) [Real]  default = 10.0\n  -S  Query strands to search against database (blastn only).  3 is both, 1 is top, 2 is bottom [Integer]\n    default = 3\n\nWU-Blast\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t","label":"new($caller,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":354},"end":{"character":9999,"line":382}},"name":"new"},{"line":366,"kind":12,"containerName":"new","name":"SUPER"},{"line":380,"kind":12,"containerName":"Root::Root","name":"Bio"},{"name":"executable","range":{"start":{"line":395,"character":0},"end":{"line":421,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$exename,$exe,$warn)","signature":{"parameters":[{"label":"$self"},{"label":"$exename"},{"label":"$exe"},{"label":"$warn"}],"documentation":"1;\n# $Id: StandAloneBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneBlast - Object for the local execution \nof the NCBI BLAST program suite (blastall, blastpgp, bl2seq). \nThere is experimental support for WU-Blast and NCBI rpsblast.\n\n=head1 SYNOPSIS\n\n # Local-blast \"factory object\" creation and blast-parameter\n # initialization:\n @params = (-database => 'swissprot', -outfile => 'blast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\n # Blast a sequence against a database:\n $str = Bio::SeqIO->new(-file=>'t/amino.fa', -format => 'Fasta');\n $input = $str->next_seq();\n $input2 = $str->next_seq();\n $blast_report = $factory->blastall($input);\n\n # Run an iterated Blast (psiblast) of a sequence against a database:\n $factory->j(3);    # 'j' is blast parameter for # of iterations\n $factory->outfile('psiblast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n $blast_report = $factory->blastpgp($input);\n\n # Use blast to align 2 sequences against each other:\n $factory = Bio::Tools::Run::StandAloneBlast->new(-outfile => 'bl2seq.out');\n $factory->bl2seq($input, $input2);\n\n # Experimental support for WU-Blast 2.0\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-program =>\"wublastp\",\n                                                     -database =>\"swissprot\",\n                                                     -e => 1e-20); \n my $blast_report = $factory->wublast($seq);\n\n # Experimental support for NCBI rpsblast\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-db => 'CDD/Cog', \n                                                     -expect => 0.001);\n $factory->F('T'); # turn on SEG filtering of query sequence\n my $blast_report = $factory->rpsblast($seq);\n\n # Use the experimental fast Blast parser, 'blast_pull'\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-_READMETHOD =>'blast_pull',\n                                                     @other_params);\n\n # Various additional options and input formats are available,\n # see the DESCRIPTION section for details.\n\n=head1 DESCRIPTION\n\nThis DESCRIPTION only documents Bio::Tools::Run::StandAloneBlast: - a\nBioperl object for running the NCBI standAlone BLAST package. Blast\nitself, is a large & complex program - for more information regarding\nBLAST, please see the BLAST documentation which accompanies the BLAST\ndistribution. BLAST is available from ftp://ncbi.nlm.nih.gov/blast/.\n\nA source of confusion in documenting a BLAST interface is that the\nterm \"program\" is used in - at least - three different ways in the\nBLAST documentation. In this DESCRIPTION, \"program\" will refer to the\nBLAST routine set by the BLAST C<-p> parameter that can be set to blastn,\nblastp, tblastx etc. We will use the term Blast \"executable\" to refer\nto the various different executable files that may be called - ie.\nblastall, blastpgp or bl2seq. In addition, there are several BLAST\ncapabilities, which are also referred to as \"programs\", and are\nimplemented by using specific combinations of BLAST executables,\nprograms and parameters. They will be referred by their specific\nnames - eg PSIBLAST and PHIBLAST.\n\nBefore running StandAloneBlast it is necessary: to install BLAST \non your system, to edit set the environmental variable $BLASTDIR \nor your $PATH variable to point to the BLAST directory, and to \nensure that users have execute privileges for the BLAST program.  \n\nIf the databases which will be searched by BLAST are located in the \ndata subdirectory of the blast program directory (the default \ninstallation location), StandAloneBlast will find them; however, \nif the database files are located in any other location, environmental \nvariable $BLASTDATADIR will need to be set to point to that directory.\n\nThe use of the StandAloneBlast module is as follows: Initially, a\nlocal blast \"factory object\" is created. The constructor may be passed\nan optional array of (non-default) parameters to be used by the\nfactory, eg:\n\n @params = (-program => 'blastn', -database => 'ecoli.nt');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\nAny parameters not explicitly set will remain as the defaults of the\nBLAST executable. Note each BLAST executable has somewhat different\nparameters and options. See the BLAST Documentation for a description\nor run the BLAST executable from the command line followed solely with\na \"-\" to see a list of options and default values for that executable;\neg E<gt>blastall -.\n\nBLAST parameters can be changed and/or examined at any time after the\nfactory has been created. The program checks that any\nparameter/switch being set/read is valid. Except where specifically\nnoted, StandAloneBlast uses the same single-letter, case-sensitive\nparameter names as the actual blast program. Currently no checks are\nincluded to verify that parameters are of the proper type (e.g. string\nor numeric) or that their values are within the proper range.\n\nAs an example, to change the value of the Blast parameter 'e' ('e' is\nthe parameter for expectation-value cutoff) \n\n  $expectvalue = 0.01;\n  $factory->e($expectvalue);\n\nNote that for improved script readibility one can modify the name of\nthe (ncbi) BLAST parameters as desired as long as the initial letter (and\ncase) of the parameter are preserved, e.g.:\n\n  $factory->expectvalue($expectvalue);\n\nUnfortunately, some of the BLAST parameters are not the single \nletter one might expect (eg \"iteration round\" in blastpgp is 'j'). \nAgain one can check by using, for example:\n\n  > blastpgp -\n\nWublast parameters need to be complete (ie. don't truncate them to their\nfirst letter), but are case-insensitive.\n\nOnce the factory has been created and the appropriate parameters set,\none can call one of the supported blast executables. The input\nsequence(s) to these executables may be fasta file(s) as described in\nthe BLAST documentation.\n\n  $inputfilename = 't/testquery.fa';\n  $blast_report = $factory->blastall($inputfilename);\n\nIn addition, sequence input may be in the form of either a Bio::Seq\nobject or (a reference to) an array of Bio::Seq objects, e.g.:\n\n  $input = Bio::Seq->new(-id => \"test query\",\n                         -seq => \"ACTACCCTTTAAATCAGTGGGGG\");\n  $blast_report = $factory->blastall($input);\n\nNOTE: Use of the BPlite method has been deprecated and is no longer supported.\n\nFor blastall and non-psiblast blastpgp runs, report object is aL<Bio::SearchIO>\nobject, selected by the user with the parameter _READMETHOD. The leading\nunderscore is needed to distinguish this option from options which are passed to\nthe BLAST executable. The default parser is Bio::SearchIO::blast. In any case,\nthe \"raw\" blast report is also available. The filename is set by the 'outfile'\nparameter and has the default value of \"blastreport.out\".\n\nFor psiblast execution in the BLAST \"jumpstart\" mode, the program must\nbe passed (in addition to the query sequence itself) an alignment\ncontaining the query sequence (in the form of a SimpleAlign object) as\nwell as a \"mask\" specifying at what residues position-specific scoring\nmatrices (PSSMs) are to used and at what residues default scoring\nmatrices (eg BLOSUM) are to be used. See psiblast documentation for\nmore details. The mask itself is a string of 0's and 1's which is the\nsame length as each sequence in the alignment and has a \"1\" at\nlocations where (PSSMs) are to be used and a \"0\" at all other\nlocations. So for example:\n\n  $str = Bio::AlignIO->new(-file => \"cysprot.msf\", \n                           -format => 'msf');\n  $aln = $str->next_aln();\n  $len = $aln->length_aln();\n  $mask = '1' x $len;\n  # simple case where PSSM's to be used at all residues\n  $report = $factory->blastpgp(\"cysprot1.fa\", $aln, $mask);\n\nFor bl2seq execution, StandAloneBlast.pm can be combined with\nAlignIO.pm to directly produce a SimpleAlign object from the alignment\nof the two sequences produced by bl2seq as in:\n\n  # Get 2 sequences\n  $str = Bio::SeqIO->new(-file=>'t/amino.fa' , -format => 'Fasta');\n  my $seq3 = $str->next_seq();\n  my $seq4 = $str->next_seq();\n\n  # Run bl2seq on them\n  $factory = Bio::Tools::Run::StandAloneBlast->new(-program => 'blastp',\n                                                   -outfile => 'bl2seq.out');\n  my $bl2seq_report = $factory->bl2seq($seq3, $seq4);\n\n  # Use AlignIO.pm to create a SimpleAlign object from the bl2seq report\n  $str = Bio::AlignIO->new(-file=> 'bl2seq.out',-format => 'bl2seq');\n  $aln = $str->next_aln();\n\nFor more examples of syntax and use of StandAloneBlast.pm, the user is\nencouraged to run the scripts standaloneblast.pl in the bioperl\nexamples/tools directory and StandAloneBlast.t in the bioperl t/ \ndirectory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneBlast;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Seq;\nuse Bio::SeqIO;\nuse Bio::SearchIO;\nuse File::Spec;\n\nuse base qw(Bio::Tools::Run::WrapperBase Bio::Factory::ApplicationFactoryI);\n\nour $AUTOLOAD;\nour $DEFAULTBLASTTYPE = 'NCBI';\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $ENV{'BLASTDATADIR'} || $ENV{'BLASTDB'};\nif (! defined $DATADIR && defined $ENV{'BLASTDIR'}) {\n    my $dir = Bio::Root::IO->catfile($ENV{'BLASTDIR'}, 'data');\n    if (-d $dir) {\n        $DATADIR = $dir;\n    }\n    elsif ($ENV{'BLASTDIR'} =~ /bin/) {\n        $dir = $ENV{'BLASTDIR'};\n        $dir =~ s/bin/data/;\n        $DATADIR = $dir if -d $dir;\n    }\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneNCBIBlast or StandAloneWUBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p in those programs that\nhave it. For a complete listing of settable parameters, run the relevant\nexecutable BLAST program with the option \"-\" as in blastall -\nNote that the input paramters (-i, -j, -input) should not be set directly by\nyou: this module sets them when you call one of the executable methods.\n\nBlastall\n\n  -p  Program Name [String]\n        Input should be one of \"blastp\", \"blastn\", \"blastx\", \n        \"tblastn\", or \"tblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"nr est\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n  -S  Query strands to search against database (for blast[nx], and tblastx). 3 is both, 1 is top, 2 is bottom [Integer]\n\t    default = 3\n\nBlastpgp (including Psiblast)\n\n  -j  is the maximum number of rounds (default 1; i.e., regular BLAST)\n  -h  is the e-value threshold for including sequences in the\n\t    score matrix model (default 0.001)\n  -c  is the \"constant\" used in the pseudocount formula specified in the paper (default 10)\n  -B  Multiple alignment file for PSI-BLAST \"jump start mode\"  Optional\n  -Q  Output File for PSI-BLAST Matrix in ASCII [File Out]  Optional\n\nrpsblast\n\n  -d  Database [String] default = (none - you must specify a database)\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"Cog Smart\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\nBl2seq\n\n  -p  Program name: blastp, blastn, blastx. For blastx 1st argument should be nucleotide [String]\n    default = blastp\n  -o  alignment output file [File Out] default = stdout\n  -e  Expectation value (E) [Real]  default = 10.0\n  -S  Query strands to search against database (blastn only).  3 is both, 1 is top, 2 is bottom [Integer]\n    default = 3\n\nWU-Blast\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $class = ref($caller) || $caller;\n    \n    # Because of case-sensitivity issues, ncbi and wublast methods are\n    # mutually exclusive. We can't load ncbi methods if we start with wublast\n    # (and vice versa) since wublast e() and E() should be the same thing,\n    # whilst they must be different things in ncbi blast.\n    #\n    # Solution: split StandAloneBlast out into two more modules for NCBI and WU\n    \n    if ($class =~ /NCBI|WU/) {\n        return $class->SUPER::new(@args);\n    }\n    \n    my %args = @args;\n    my $blasttype = $DEFAULTBLASTTYPE;\n    while (my ($attr, $value) = each %args) {\n        if ($attr =~/^-?\\s*program\\s*$|^-?p$/) {\n            if ($value =~ /^wu*/) {\n                $blasttype = 'WU';\n            }\n        }\n    }\n    \n    my $module = \"Bio::Tools::Run::StandAlone${blasttype}Blast\";\n    Bio::Root::Root->_load_module($module);\n    return $module->new(@args);\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $blastfactory->executable('blastall');\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to \n           [optional] boolean flag whether or not warn when exe is not found","label":"executable($self,$exename,$exe,$warn)"},"kind":12,"line":395,"children":[{"line":396,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"executable"},{"kind":13,"line":396,"name":"$exename","containerName":"executable"},{"line":396,"kind":13,"name":"$exe","containerName":"executable"},{"name":"$warn","containerName":"executable","kind":13,"line":396},{"kind":13,"line":397,"containerName":"executable","name":"$exename"},{"kind":13,"line":397,"name":"$exename","containerName":"executable"},{"name":"$self","containerName":"executable","kind":13,"line":397},{"line":398,"kind":13,"containerName":"executable","name":"$self"},{"name":"program_name","containerName":"executable","line":398,"kind":12},{"kind":13,"line":398,"name":"$exename","containerName":"executable"},{"kind":13,"line":400,"name":"$exe","containerName":"executable"},{"line":400,"kind":13,"containerName":"executable","name":"$exe"},{"containerName":"executable","name":"$self","kind":13,"line":401},{"name":"$exename","containerName":"executable","line":401,"kind":13},{"containerName":"executable","name":"$exe","line":401,"kind":13},{"name":"$self","containerName":"executable","kind":13,"line":403},{"name":"$exename","containerName":"executable","kind":13,"line":403},{"line":404,"kind":13,"localvar":"my","definition":"my","name":"$f","containerName":"executable"},{"kind":13,"line":404,"name":"$self","containerName":"executable"},{"line":404,"kind":12,"containerName":"executable","name":"program_path"},{"line":404,"kind":13,"containerName":"executable","name":"$exename"},{"kind":13,"line":405,"name":"$exe","containerName":"executable"},{"kind":13,"line":405,"containerName":"executable","name":"$self"},{"containerName":"executable","name":"$exename","kind":13,"line":405},{"kind":13,"line":405,"containerName":"executable","name":"$f"},{"name":"$f","containerName":"executable","kind":13,"line":405},{"line":405,"kind":13,"containerName":"executable","name":"$f"},{"containerName":"executable","name":"$exe","line":410,"kind":13},{"name":"$exe","containerName":"executable","line":411,"kind":13},{"line":411,"kind":13,"containerName":"executable","name":"$self"},{"containerName":"executable","name":"io","kind":12,"line":411},{"containerName":"executable","name":"exists_exe","line":411,"kind":12},{"kind":13,"line":411,"containerName":"executable","name":"$exename"},{"line":411,"kind":13,"containerName":"executable","name":"$exe"},{"containerName":"executable","name":"$self","kind":13,"line":412},{"line":412,"kind":13,"containerName":"executable","name":"$exename"},{"kind":13,"line":412,"name":"$exe","containerName":"executable"},{"kind":13,"line":415,"name":"$self","containerName":"executable"},{"line":415,"kind":12,"name":"warn","containerName":"executable"},{"containerName":"executable","name":"$warn","kind":13,"line":415},{"name":"$self","containerName":"executable","line":416,"kind":13},{"containerName":"executable","name":"$exename","line":416,"kind":13},{"name":"$self","containerName":"executable","kind":13,"line":420},{"line":420,"kind":13,"name":"$exename","containerName":"executable"}]},{"name":"program_dir","definition":"sub","containerName":"main::","range":{"end":{"line":436,"character":9999},"start":{"line":433,"character":0}},"kind":12,"children":[{"line":434,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"program_dir"},{"kind":13,"line":435,"containerName":"program_dir","name":"$self"},{"line":435,"kind":13,"containerName":"program_dir","name":"$ENV"},{"kind":13,"line":435,"name":"$ENV","containerName":"program_dir"}],"line":433},{"line":438,"children":[{"localvar":"my","containerName":"program_name","name":"$self","definition":"my","line":439,"kind":13},{"containerName":"program_name","name":"$self","kind":13,"line":440},{"containerName":"program_name","name":"$self","kind":13,"line":441}],"kind":12,"range":{"end":{"character":9999,"line":442},"start":{"line":438,"character":0}},"containerName":"main::","definition":"sub","name":"program_name"},{"line":440,"kind":12,"name":"program_name"},{"name":"program_name","kind":12,"line":441},{"line":444,"children":[{"kind":13,"line":445,"definition":"my","name":"$self","containerName":"program","localvar":"my"},{"line":447,"kind":13,"name":"$self","containerName":"program"},{"name":"executable","containerName":"program","line":447,"kind":12},{"containerName":"program","name":"$self","line":447,"kind":13},{"name":"p","containerName":"program","kind":12,"line":447},{"name":"$self","containerName":"program","kind":13,"line":449},{"kind":12,"line":449,"containerName":"program","name":"executable"}],"kind":12,"range":{"end":{"line":451,"character":9999},"start":{"line":444,"character":0}},"containerName":"main::","name":"program","definition":"sub"},{"name":"_setinput","range":{"start":{"character":0,"line":464},"end":{"line":565,"character":9999}},"kind":12,"line":464,"children":[{"containerName":"_setinput","name":"$self","definition":"my","localvar":"my","kind":13,"line":465},{"line":465,"kind":13,"name":"$executable","containerName":"_setinput"},{"line":465,"kind":13,"containerName":"_setinput","name":"$input1"},{"containerName":"_setinput","name":"$input2","line":465,"kind":13},{"definition":"my","name":"$seq","containerName":"_setinput","localvar":"my","kind":13,"line":466},{"containerName":"_setinput","name":"$temp","kind":13,"line":466},{"kind":13,"line":466,"containerName":"_setinput","name":"$infilename1"},{"kind":13,"line":466,"name":"$infilename2","containerName":"_setinput"},{"name":"$fh","containerName":"_setinput","kind":13,"line":466},{"kind":13,"line":469,"containerName":"_setinput","name":"$self"},{"line":469,"kind":12,"name":"io","containerName":"_setinput"},{"line":469,"kind":12,"name":"_io_cleanup","containerName":"_setinput"},{"containerName":"_setinput","name":"$input1","kind":13,"line":472},{"name":"$infilename1","containerName":"_setinput","line":473,"kind":13},{"name":"$input1","containerName":"_setinput","kind":13,"line":473},{"name":"$input1","containerName":"_setinput","kind":13,"line":473},{"containerName":"_setinput","name":"$input1","kind":13,"line":478},{"line":479,"kind":13,"name":"$fh","containerName":"_setinput"},{"containerName":"_setinput","name":"$infilename1","kind":13,"line":479},{"kind":13,"line":479,"containerName":"_setinput","name":"$self"},{"name":"io","containerName":"_setinput","kind":12,"line":479},{"kind":12,"line":479,"containerName":"_setinput","name":"tempfile"},{"kind":13,"line":480,"containerName":"_setinput","name":"$temp"},{"name":"new","containerName":"_setinput","line":480,"kind":12},{"containerName":"_setinput","name":"$fh","kind":13,"line":480},{"line":481,"kind":13,"name":"$seq","containerName":"_setinput"},{"line":481,"kind":13,"containerName":"_setinput","name":"$input1"},{"line":482,"kind":13,"name":"$seq","containerName":"_setinput"},{"line":482,"kind":12,"name":"isa","containerName":"_setinput"},{"containerName":"_setinput","name":"$seq","line":483,"kind":13},{"line":483,"kind":12,"name":"display_id","containerName":"_setinput"},{"kind":13,"line":483,"name":"$seq","containerName":"_setinput"},{"containerName":"_setinput","name":"display_id","kind":12,"line":483},{"kind":13,"line":484,"name":"$temp","containerName":"_setinput"},{"name":"write_seq","containerName":"_setinput","line":484,"kind":12},{"line":484,"kind":13,"name":"$seq","containerName":"_setinput"},{"line":486,"kind":13,"name":"$fh","containerName":"_setinput"},{"containerName":"_setinput","name":"$fh","kind":13,"line":487},{"kind":13,"line":492,"containerName":"_setinput","name":"$input1"},{"line":492,"kind":12,"name":"isa","containerName":"_setinput"},{"line":493,"kind":13,"name":"$fh","containerName":"_setinput"},{"containerName":"_setinput","name":"$infilename1","kind":13,"line":493},{"containerName":"_setinput","name":"$self","kind":13,"line":493},{"name":"io","containerName":"_setinput","line":493,"kind":12},{"name":"tempfile","containerName":"_setinput","line":493,"kind":12},{"kind":13,"line":498,"name":"$seq_string","definition":"my","containerName":"_setinput","localvar":"my"},{"name":"$input1","containerName":"_setinput","line":498,"kind":13},{"line":498,"kind":12,"name":"seq","containerName":"_setinput"},{"kind":13,"line":499,"name":"$seq_string","containerName":"_setinput"},{"kind":13,"line":500,"containerName":"_setinput","name":"$input1"},{"kind":12,"line":500,"name":"seq","containerName":"_setinput"},{"containerName":"_setinput","name":"$seq_string","kind":13,"line":500},{"line":501,"kind":13,"name":"$temp","containerName":"_setinput"},{"containerName":"_setinput","name":"new","line":501,"kind":12},{"name":"$fh","containerName":"_setinput","line":501,"kind":13},{"line":502,"kind":13,"containerName":"_setinput","name":"$temp"},{"line":502,"kind":12,"containerName":"_setinput","name":"write_seq"},{"name":"$input1","containerName":"_setinput","line":502,"kind":13},{"line":503,"kind":13,"name":"$fh","containerName":"_setinput"},{"kind":13,"line":504,"containerName":"_setinput","name":"$fh"},{"containerName":"_setinput","name":"$infilename1","kind":13,"line":508},{"line":511,"kind":13,"name":"$input2","containerName":"_setinput"},{"name":"$infilename1","containerName":"_setinput","line":511,"kind":13},{"containerName":"_setinput","name":"$input2","line":514,"kind":13},{"kind":13,"line":515,"name":"$infilename2","containerName":"_setinput"},{"name":"$input2","containerName":"_setinput","line":515,"kind":13},{"containerName":"_setinput","name":"$input2","line":515,"kind":13},{"name":"$input2","containerName":"_setinput","kind":13,"line":518},{"line":518,"kind":12,"containerName":"_setinput","name":"isa"},{"name":"$executable","containerName":"_setinput","kind":13,"line":518},{"kind":13,"line":519,"containerName":"_setinput","name":"$fh"},{"kind":13,"line":519,"name":"$infilename2","containerName":"_setinput"},{"kind":13,"line":519,"containerName":"_setinput","name":"$self"},{"name":"io","containerName":"_setinput","line":519,"kind":12},{"containerName":"_setinput","name":"tempfile","kind":12,"line":519},{"line":521,"kind":13,"name":"$temp","containerName":"_setinput"},{"containerName":"_setinput","name":"new","kind":12,"line":521},{"kind":13,"line":521,"containerName":"_setinput","name":"$fh"},{"name":"$temp","containerName":"_setinput","line":522,"kind":13},{"containerName":"_setinput","name":"write_seq","kind":12,"line":522},{"name":"$input2","containerName":"_setinput","line":522,"kind":13},{"name":"$fh","containerName":"_setinput","kind":13,"line":523},{"containerName":"_setinput","name":"$fh","line":524,"kind":13},{"line":529,"kind":13,"containerName":"_setinput","name":"$input2"},{"line":529,"kind":12,"containerName":"_setinput","name":"isa"},{"kind":13,"line":529,"name":"$executable","containerName":"_setinput"},{"kind":13,"line":531,"containerName":"_setinput","name":"$fh"},{"containerName":"_setinput","name":"$infilename2","kind":13,"line":531},{"name":"$self","containerName":"_setinput","line":531,"kind":13},{"kind":12,"line":531,"containerName":"_setinput","name":"io"},{"kind":12,"line":531,"name":"tempfile","containerName":"_setinput"},{"localvar":"my","name":"@mask","definition":"my","containerName":"_setinput","line":536,"kind":13},{"containerName":"_setinput","name":"$seq","kind":13,"line":541},{"kind":13,"line":541,"containerName":"_setinput","name":"$input2"},{"containerName":"_setinput","name":"each_seq","line":541,"kind":12},{"line":542,"kind":13,"localvar":"my","definition":"my","name":"@seqstringlist","containerName":"_setinput"},{"containerName":"_setinput","name":"$seq","kind":13,"line":542},{"kind":12,"line":542,"containerName":"_setinput","name":"seq"},{"line":543,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"_setinput"},{"name":"$i","containerName":"_setinput","line":543,"kind":13},{"kind":13,"line":543,"name":"@mask","containerName":"_setinput"},{"name":"$i","containerName":"_setinput","line":543,"kind":13},{"name":"$seqstringlist","containerName":"_setinput","kind":13,"line":544},{"kind":13,"line":544,"containerName":"_setinput","name":"$i"},{"kind":13,"line":545,"name":"$seqstringlist","containerName":"_setinput"},{"kind":13,"line":545,"containerName":"_setinput","name":"$i"},{"kind":13,"line":545,"containerName":"_setinput","name":"$mask"},{"kind":13,"line":545,"containerName":"_setinput","name":"$i"},{"name":"$seqstringlist","containerName":"_setinput","line":545,"kind":13},{"name":"$i","containerName":"_setinput","line":545,"kind":13},{"line":545,"kind":13,"name":"$seqstringlist","containerName":"_setinput"},{"containerName":"_setinput","name":"$i","kind":13,"line":545},{"kind":13,"line":547,"containerName":"_setinput","name":"$newseqstring","definition":"my","localvar":"my"},{"containerName":"_setinput","name":"@seqstringlist","line":547,"kind":13},{"kind":13,"line":548,"containerName":"_setinput","name":"$seq"},{"name":"seq","containerName":"_setinput","line":548,"kind":12},{"kind":13,"line":548,"containerName":"_setinput","name":"$newseqstring"},{"containerName":"_setinput","name":"$input2","kind":13,"line":553},{"name":"map_chars","containerName":"_setinput","kind":12,"line":553},{"name":"$temp","containerName":"_setinput","line":554,"kind":13},{"kind":12,"line":554,"name":"new","containerName":"_setinput"},{"kind":13,"line":554,"name":"$fh","containerName":"_setinput"},{"kind":13,"line":555,"name":"$temp","containerName":"_setinput"},{"containerName":"_setinput","name":"write_aln","kind":12,"line":555},{"line":555,"kind":13,"containerName":"_setinput","name":"$input2"},{"line":556,"kind":13,"name":"$fh","containerName":"_setinput"},{"line":557,"kind":13,"name":"$fh","containerName":"_setinput"},{"name":"$infilename2","containerName":"_setinput","line":561,"kind":13},{"kind":13,"line":564,"containerName":"_setinput","name":"$infilename1"},{"containerName":"_setinput","name":"$infilename2","line":564,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$executable,$input1,$input2)","signature":{"label":"_setinput($self,$executable,$input1,$input2)","documentation":"1;\n# $Id: StandAloneBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneBlast - Object for the local execution \nof the NCBI BLAST program suite (blastall, blastpgp, bl2seq). \nThere is experimental support for WU-Blast and NCBI rpsblast.\n\n=head1 SYNOPSIS\n\n # Local-blast \"factory object\" creation and blast-parameter\n # initialization:\n @params = (-database => 'swissprot', -outfile => 'blast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\n # Blast a sequence against a database:\n $str = Bio::SeqIO->new(-file=>'t/amino.fa', -format => 'Fasta');\n $input = $str->next_seq();\n $input2 = $str->next_seq();\n $blast_report = $factory->blastall($input);\n\n # Run an iterated Blast (psiblast) of a sequence against a database:\n $factory->j(3);    # 'j' is blast parameter for # of iterations\n $factory->outfile('psiblast1.out');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n $blast_report = $factory->blastpgp($input);\n\n # Use blast to align 2 sequences against each other:\n $factory = Bio::Tools::Run::StandAloneBlast->new(-outfile => 'bl2seq.out');\n $factory->bl2seq($input, $input2);\n\n # Experimental support for WU-Blast 2.0\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-program =>\"wublastp\",\n                                                     -database =>\"swissprot\",\n                                                     -e => 1e-20); \n my $blast_report = $factory->wublast($seq);\n\n # Experimental support for NCBI rpsblast\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-db => 'CDD/Cog', \n                                                     -expect => 0.001);\n $factory->F('T'); # turn on SEG filtering of query sequence\n my $blast_report = $factory->rpsblast($seq);\n\n # Use the experimental fast Blast parser, 'blast_pull'\n my $factory = Bio::Tools::Run::StandAloneBlast->new(-_READMETHOD =>'blast_pull',\n                                                     @other_params);\n\n # Various additional options and input formats are available,\n # see the DESCRIPTION section for details.\n\n=head1 DESCRIPTION\n\nThis DESCRIPTION only documents Bio::Tools::Run::StandAloneBlast: - a\nBioperl object for running the NCBI standAlone BLAST package. Blast\nitself, is a large & complex program - for more information regarding\nBLAST, please see the BLAST documentation which accompanies the BLAST\ndistribution. BLAST is available from ftp://ncbi.nlm.nih.gov/blast/.\n\nA source of confusion in documenting a BLAST interface is that the\nterm \"program\" is used in - at least - three different ways in the\nBLAST documentation. In this DESCRIPTION, \"program\" will refer to the\nBLAST routine set by the BLAST C<-p> parameter that can be set to blastn,\nblastp, tblastx etc. We will use the term Blast \"executable\" to refer\nto the various different executable files that may be called - ie.\nblastall, blastpgp or bl2seq. In addition, there are several BLAST\ncapabilities, which are also referred to as \"programs\", and are\nimplemented by using specific combinations of BLAST executables,\nprograms and parameters. They will be referred by their specific\nnames - eg PSIBLAST and PHIBLAST.\n\nBefore running StandAloneBlast it is necessary: to install BLAST \non your system, to edit set the environmental variable $BLASTDIR \nor your $PATH variable to point to the BLAST directory, and to \nensure that users have execute privileges for the BLAST program.  \n\nIf the databases which will be searched by BLAST are located in the \ndata subdirectory of the blast program directory (the default \ninstallation location), StandAloneBlast will find them; however, \nif the database files are located in any other location, environmental \nvariable $BLASTDATADIR will need to be set to point to that directory.\n\nThe use of the StandAloneBlast module is as follows: Initially, a\nlocal blast \"factory object\" is created. The constructor may be passed\nan optional array of (non-default) parameters to be used by the\nfactory, eg:\n\n @params = (-program => 'blastn', -database => 'ecoli.nt');\n $factory = Bio::Tools::Run::StandAloneBlast->new(@params);\n\nAny parameters not explicitly set will remain as the defaults of the\nBLAST executable. Note each BLAST executable has somewhat different\nparameters and options. See the BLAST Documentation for a description\nor run the BLAST executable from the command line followed solely with\na \"-\" to see a list of options and default values for that executable;\neg E<gt>blastall -.\n\nBLAST parameters can be changed and/or examined at any time after the\nfactory has been created. The program checks that any\nparameter/switch being set/read is valid. Except where specifically\nnoted, StandAloneBlast uses the same single-letter, case-sensitive\nparameter names as the actual blast program. Currently no checks are\nincluded to verify that parameters are of the proper type (e.g. string\nor numeric) or that their values are within the proper range.\n\nAs an example, to change the value of the Blast parameter 'e' ('e' is\nthe parameter for expectation-value cutoff) \n\n  $expectvalue = 0.01;\n  $factory->e($expectvalue);\n\nNote that for improved script readibility one can modify the name of\nthe (ncbi) BLAST parameters as desired as long as the initial letter (and\ncase) of the parameter are preserved, e.g.:\n\n  $factory->expectvalue($expectvalue);\n\nUnfortunately, some of the BLAST parameters are not the single \nletter one might expect (eg \"iteration round\" in blastpgp is 'j'). \nAgain one can check by using, for example:\n\n  > blastpgp -\n\nWublast parameters need to be complete (ie. don't truncate them to their\nfirst letter), but are case-insensitive.\n\nOnce the factory has been created and the appropriate parameters set,\none can call one of the supported blast executables. The input\nsequence(s) to these executables may be fasta file(s) as described in\nthe BLAST documentation.\n\n  $inputfilename = 't/testquery.fa';\n  $blast_report = $factory->blastall($inputfilename);\n\nIn addition, sequence input may be in the form of either a Bio::Seq\nobject or (a reference to) an array of Bio::Seq objects, e.g.:\n\n  $input = Bio::Seq->new(-id => \"test query\",\n                         -seq => \"ACTACCCTTTAAATCAGTGGGGG\");\n  $blast_report = $factory->blastall($input);\n\nNOTE: Use of the BPlite method has been deprecated and is no longer supported.\n\nFor blastall and non-psiblast blastpgp runs, report object is aL<Bio::SearchIO>\nobject, selected by the user with the parameter _READMETHOD. The leading\nunderscore is needed to distinguish this option from options which are passed to\nthe BLAST executable. The default parser is Bio::SearchIO::blast. In any case,\nthe \"raw\" blast report is also available. The filename is set by the 'outfile'\nparameter and has the default value of \"blastreport.out\".\n\nFor psiblast execution in the BLAST \"jumpstart\" mode, the program must\nbe passed (in addition to the query sequence itself) an alignment\ncontaining the query sequence (in the form of a SimpleAlign object) as\nwell as a \"mask\" specifying at what residues position-specific scoring\nmatrices (PSSMs) are to used and at what residues default scoring\nmatrices (eg BLOSUM) are to be used. See psiblast documentation for\nmore details. The mask itself is a string of 0's and 1's which is the\nsame length as each sequence in the alignment and has a \"1\" at\nlocations where (PSSMs) are to be used and a \"0\" at all other\nlocations. So for example:\n\n  $str = Bio::AlignIO->new(-file => \"cysprot.msf\", \n                           -format => 'msf');\n  $aln = $str->next_aln();\n  $len = $aln->length_aln();\n  $mask = '1' x $len;\n  # simple case where PSSM's to be used at all residues\n  $report = $factory->blastpgp(\"cysprot1.fa\", $aln, $mask);\n\nFor bl2seq execution, StandAloneBlast.pm can be combined with\nAlignIO.pm to directly produce a SimpleAlign object from the alignment\nof the two sequences produced by bl2seq as in:\n\n  # Get 2 sequences\n  $str = Bio::SeqIO->new(-file=>'t/amino.fa' , -format => 'Fasta');\n  my $seq3 = $str->next_seq();\n  my $seq4 = $str->next_seq();\n\n  # Run bl2seq on them\n  $factory = Bio::Tools::Run::StandAloneBlast->new(-program => 'blastp',\n                                                   -outfile => 'bl2seq.out');\n  my $bl2seq_report = $factory->bl2seq($seq3, $seq4);\n\n  # Use AlignIO.pm to create a SimpleAlign object from the bl2seq report\n  $str = Bio::AlignIO->new(-file=> 'bl2seq.out',-format => 'bl2seq');\n  $aln = $str->next_aln();\n\nFor more examples of syntax and use of StandAloneBlast.pm, the user is\nencouraged to run the scripts standaloneblast.pl in the bioperl\nexamples/tools directory and StandAloneBlast.t in the bioperl t/ \ndirectory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneBlast;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Seq;\nuse Bio::SeqIO;\nuse Bio::SearchIO;\nuse File::Spec;\n\nuse base qw(Bio::Tools::Run::WrapperBase Bio::Factory::ApplicationFactoryI);\n\nour $AUTOLOAD;\nour $DEFAULTBLASTTYPE = 'NCBI';\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $ENV{'BLASTDATADIR'} || $ENV{'BLASTDB'};\nif (! defined $DATADIR && defined $ENV{'BLASTDIR'}) {\n    my $dir = Bio::Root::IO->catfile($ENV{'BLASTDIR'}, 'data');\n    if (-d $dir) {\n        $DATADIR = $dir;\n    }\n    elsif ($ENV{'BLASTDIR'} =~ /bin/) {\n        $dir = $ENV{'BLASTDIR'};\n        $dir =~ s/bin/data/;\n        $DATADIR = $dir if -d $dir;\n    }\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneNCBIBlast or StandAloneWUBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p in those programs that\nhave it. For a complete listing of settable parameters, run the relevant\nexecutable BLAST program with the option \"-\" as in blastall -\nNote that the input paramters (-i, -j, -input) should not be set directly by\nyou: this module sets them when you call one of the executable methods.\n\nBlastall\n\n  -p  Program Name [String]\n        Input should be one of \"blastp\", \"blastn\", \"blastx\", \n        \"tblastn\", or \"tblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"nr est\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n  -S  Query strands to search against database (for blast[nx], and tblastx). 3 is both, 1 is top, 2 is bottom [Integer]\n\t    default = 3\n\nBlastpgp (including Psiblast)\n\n  -j  is the maximum number of rounds (default 1; i.e., regular BLAST)\n  -h  is the e-value threshold for including sequences in the\n\t    score matrix model (default 0.001)\n  -c  is the \"constant\" used in the pseudocount formula specified in the paper (default 10)\n  -B  Multiple alignment file for PSI-BLAST \"jump start mode\"  Optional\n  -Q  Output File for PSI-BLAST Matrix in ASCII [File Out]  Optional\n\nrpsblast\n\n  -d  Database [String] default = (none - you must specify a database)\n        The database specified must first be formatted with formatdb.\n        Multiple database names (bracketed by quotations) will be accepted.\n        An example would be -d \"Cog Smart\"\n  -e  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\nBl2seq\n\n  -p  Program name: blastp, blastn, blastx. For blastx 1st argument should be nucleotide [String]\n    default = blastp\n  -o  alignment output file [File Out] default = stdout\n  -e  Expectation value (E) [Real]  default = 10.0\n  -S  Query strands to search against database (blastn only).  3 is both, 1 is top, 2 is bottom [Integer]\n    default = 3\n\nWU-Blast\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $class = ref($caller) || $caller;\n    \n    # Because of case-sensitivity issues, ncbi and wublast methods are\n    # mutually exclusive. We can't load ncbi methods if we start with wublast\n    # (and vice versa) since wublast e() and E() should be the same thing,\n    # whilst they must be different things in ncbi blast.\n    #\n    # Solution: split StandAloneBlast out into two more modules for NCBI and WU\n    \n    if ($class =~ /NCBI|WU/) {\n        return $class->SUPER::new(@args);\n    }\n    \n    my %args = @args;\n    my $blasttype = $DEFAULTBLASTTYPE;\n    while (my ($attr, $value) = each %args) {\n        if ($attr =~/^-?\\s*program\\s*$|^-?p$/) {\n            if ($value =~ /^wu*/) {\n                $blasttype = 'WU';\n            }\n        }\n    }\n    \n    my $module = \"Bio::Tools::Run::StandAlone${blasttype}Blast\";\n    Bio::Root::Root->_load_module($module);\n    return $module->new(@args);\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $blastfactory->executable('blastall');\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to \n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exename, $exe, $warn) = @_;\n    $exename = 'blastall' unless (defined $exename || $self =~ /WUBlast/);\n    $self->program_name($exename);\n    \n    if( defined $exe && -x $exe ) {\n        $self->{'_pathtoexe'}->{$exename} = $exe;\n    }\n    unless( defined $self->{'_pathtoexe'}->{$exename} ) {\n        my $f = $self->program_path($exename);\t    \n        $exe = $self->{'_pathtoexe'}->{$exename} = $f if(-e $f && -x $f );\n        \n        # This is how I meant to split up these conditionals --jason\n        # if exe is null we will execute this (handle the case where\n        # PROGRAMDIR pointed to something invalid)\n        unless( $exe )  {  # we didn't find it in that last conditional\n            if( ($exe = $self->io->exists_exe($exename)) && -x $exe ) {\n                $self->{'_pathtoexe'}->{$exename} = $exe;\n            }\n            else { \n                $self->warn(\"Cannot find executable for $exename\") if $warn;\n                $self->{'_pathtoexe'}->{$exename} = undef;\n            }\n        }\n   }\n   return $self->{'_pathtoexe'}->{$exename};\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. \n Returns : string representing program directory \n Args    : none \n\n\nsub program_dir {\n    my $self = shift;\n    $self =~ /NCBIBlast/? $ENV{'BLASTDIR'}: $ENV{'WUBLASTDIR'};\n}\n\nsub program_name {\n    my $self = shift;\n    if (@_) { $self->{program_name} = shift }\n    return $self->{program_name} || '';\n}\n\nsub program {\n    my $self = shift;\n    if( wantarray ) {\n\treturn ($self->executable, $self->p());\n    } else {\n\treturn $self->executable(@_);\n    }\n}\n\n=head2  _setinput\n\n Title   :  _setinput\n Usage   :  Internal function, not to be called directly\t\n Function:   Create input file(s) for Blast executable\n Example :\n Returns : name of file containing Blast data input\n Args    : Seq object reference or input file name","parameters":[{"label":"$self"},{"label":"$executable"},{"label":"$input1"},{"label":"$input2"}]}},{"name":"SWITCH","line":471,"kind":12},{"line":474,"kind":12,"name":"SWITCH"},{"containerName":"SeqIO","name":"Bio","kind":12,"line":480},{"kind":12,"line":488,"name":"SWITCH"},{"containerName":"SeqIO","name":"Bio","line":501,"kind":12},{"kind":12,"line":505,"name":"SWITCH"},{"name":"SWITCH2","kind":12,"line":513},{"kind":12,"line":516,"name":"SWITCH2"},{"kind":12,"line":521,"name":"Bio","containerName":"SeqIO"},{"name":"SWITCH2","line":525,"kind":12},{"kind":12,"line":544,"name":"next"},{"containerName":"AlignIO","name":"Bio","line":554,"kind":12},{"name":"SWITCH2","line":558,"kind":12}]}