{"vars":[{"name":"base","containerName":"","line":76,"kind":2},{"kind":13,"line":78,"definition":"our","name":"$AUTOLOAD","containerName":"main::"},{"line":79,"kind":13,"definition":"our","name":"$DEFAULTREADMETHOD","containerName":"main::"},{"definition":"our","name":"$DATADIR","containerName":"main::","kind":13,"line":84},{"line":84,"kind":13,"containerName":null,"name":"$Bio"},{"kind":13,"line":86,"containerName":"main::","name":"%GENERAL_PARAMS","definition":"our"},{"kind":12,"line":86,"containerName":"Run::StandAloneBlast::DATADIR","name":"Tools"},{"definition":"our","name":"@WUBLAST_PARAMS","containerName":"main::","kind":13,"line":90},{"line":97,"kind":13,"containerName":"main::","name":"@WUBLAST_SWITCH","definition":"our"},{"line":104,"kind":13,"containerName":"main::","name":"@OTHER_PARAMS","definition":"our"},{"containerName":"main::","definition":"sub","detail":"($caller,@args)","signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: StandAloneWUBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneWUBlast - Object for the local execution \nof WU-Blast.\n\n=head1 SYNOPSIS\n\n # Do not use directly; use Bio::Tools::Run::StandAloneBlast\n\n=head1 DESCRIPTION\n\nSee Bio::Tools::Run::StandAloneBlast\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneWUBlast;\n\nuse strict;\n\nuse base qw(Bio::Tools::Run::StandAloneBlast);\n\nour $AUTOLOAD;\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $Bio::Tools::Run::StandAloneBlast::DATADIR;\n\nour %GENERAL_PARAMS  = (i => 'input',\n                        o => 'outfile',\n                        p => 'program',\n                        d => 'database');\nour @WUBLAST_PARAMS  = qw(e s e2 s2 w t x m y z l k h v b q r\n    matrix filter wordmask filter maskextra  hitdist wink ctxfactor gape\n    gaps gape2 gaps2 gapw gapx olf golf  olmax golmax gapdecayrate\n    topcombon topcomboe sumstatsmethod hspsepqmax hspsepsmax gapsepqmax\n    gapsepsmax altscore hspmax gspmax qoffset nwstart nwlen qrecmin qrecmax \n    dbrecmin dbrecmax vdbdescmax dbchunks sort_by_pvalue  cpus putenv\n    getenv progress);\nour @WUBLAST_SWITCH = qw(kap sump poissonp lcfilter lcmask echofilter\n    stats nogap gapall pingpong nosegs postsw span2 span1 span prune\n    consistency links ucdb gi noseqs qtype qres sort_by_pvalue\n    sort_by_count sort_by_highscore sort_by_totalscore\n    sort_by_subjectlength mmio nonnegok novalidctxok shortqueryok notes\n    warnings errors endputenv getenv endgetenv abortonerror abortonfatal);\n\nour @OTHER_PARAMS = qw(_READMETHOD);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p.\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t","parameters":[{"label":"$caller"},{"label":"@args"}]},"kind":12,"line":132,"children":[{"containerName":"new","name":"$caller","definition":"my","localvar":"my","kind":13,"line":133},{"name":"@args","containerName":"new","kind":13,"line":133},{"line":134,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$caller","containerName":"new","line":134,"kind":13},{"containerName":"new","name":"@args","line":134,"kind":13},{"kind":13,"line":136,"containerName":"new","name":"$self"},{"name":"_set_from_args","containerName":"new","kind":12,"line":136},{"name":"@args","containerName":"new","kind":13,"line":136},{"name":"$GENERAL_PARAMS","containerName":"new","kind":13,"line":136},{"containerName":"new","name":"%GENERAL_PARAMS","kind":13,"line":136},{"containerName":"new","name":"@OTHER_PARAMS","line":137,"kind":13},{"name":"@WUBLAST_PARAMS","containerName":"new","line":138,"kind":13},{"kind":13,"line":139,"name":"@WUBLAST_SWITCH","containerName":"new"},{"kind":13,"line":143,"containerName":"new","definition":"my","name":"$tfh","localvar":"my"},{"line":143,"kind":13,"name":"$tempfile","containerName":"new"},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":143,"name":"io","containerName":"new"},{"name":"tempfile","containerName":"new","kind":12,"line":143},{"containerName":"new","name":"$outfile","definition":"my","localvar":"my","kind":13,"line":144},{"kind":13,"line":144,"containerName":"new","name":"$self"},{"kind":12,"line":144,"name":"o","containerName":"new"},{"line":144,"kind":13,"name":"$self","containerName":"new"},{"line":144,"kind":12,"name":"outfile","containerName":"new"},{"kind":13,"line":144,"containerName":"new","name":"$tempfile"},{"name":"$self","containerName":"new","kind":13,"line":145},{"line":145,"kind":12,"name":"o","containerName":"new"},{"name":"$outfile","containerName":"new","line":145,"kind":13},{"name":"$tfh","containerName":"new","line":146,"kind":13},{"kind":13,"line":148,"containerName":"new","name":"$self"},{"name":"_READMETHOD","containerName":"new","line":148,"kind":12},{"kind":13,"line":148,"containerName":"new","name":"$DEFAULTREADMETHOD"},{"name":"$self","containerName":"new","kind":13,"line":148},{"kind":12,"line":148,"name":"_READMETHOD","containerName":"new"},{"line":150,"kind":13,"containerName":"new","name":"$self"}],"name":"new","range":{"end":{"line":151,"character":9999},"start":{"line":132,"character":0}}},{"line":134,"kind":12,"name":"SUPER","containerName":"new"},{"kind":12,"children":[{"line":155,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"AUTOLOAD"},{"kind":13,"line":156,"containerName":"AUTOLOAD","name":"$attr","definition":"my","localvar":"my"},{"name":"$AUTOLOAD","containerName":"AUTOLOAD","line":156,"kind":13},{"kind":13,"line":157,"name":"$attr","containerName":"AUTOLOAD"},{"definition":"my","name":"$orig","containerName":"AUTOLOAD","localvar":"my","kind":13,"line":159},{"kind":13,"line":159,"name":"$attr","containerName":"AUTOLOAD"},{"containerName":"AUTOLOAD","name":"$attr","line":161,"kind":13},{"name":"$attr","containerName":"AUTOLOAD","kind":13,"line":161},{"line":163,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"kind":12,"line":163,"containerName":"AUTOLOAD","name":"can"},{"name":"$attr","containerName":"AUTOLOAD","line":163,"kind":13},{"line":163,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"kind":12,"line":163,"containerName":"AUTOLOAD","name":"throw"},{"name":"$self","containerName":"AUTOLOAD","line":165,"kind":13},{"containerName":"AUTOLOAD","name":"$attr","kind":13,"line":165}],"line":154,"definition":"sub","name":"AUTOLOAD","containerName":"main::","range":{"start":{"character":0,"line":154},"end":{"character":9999,"line":166}}},{"name":"wublast","range":{"start":{"character":0,"line":190},"end":{"character":9999,"line":200}},"kind":12,"line":190,"children":[{"containerName":"wublast","definition":"my","name":"$self","localvar":"my","kind":13,"line":191},{"kind":13,"line":191,"containerName":"wublast","name":"$input1"},{"name":"$self","containerName":"wublast","line":192,"kind":13},{"kind":12,"line":192,"containerName":"wublast","name":"io"},{"line":192,"kind":12,"containerName":"wublast","name":"_io_cleanup"},{"kind":13,"line":193,"containerName":"wublast","name":"$executable","definition":"my","localvar":"my"},{"kind":13,"line":196,"containerName":"wublast","name":"$infilename1","definition":"my","localvar":"my"},{"kind":13,"line":196,"name":"$self","containerName":"wublast"},{"line":196,"kind":12,"containerName":"wublast","name":"_setinput"},{"kind":13,"line":196,"containerName":"wublast","name":"$executable"},{"name":"$input1","containerName":"wublast","line":196,"kind":13},{"kind":13,"line":196,"name":"$self","containerName":"wublast"},{"containerName":"wublast","name":"throw","kind":12,"line":196},{"containerName":"wublast","name":"$self","line":197,"kind":13},{"containerName":"wublast","name":"i","line":197,"kind":12},{"containerName":"wublast","name":"$infilename1","line":197,"kind":13},{"kind":13,"line":199,"definition":"my","name":"$blast_report","containerName":"wublast","localvar":"my"},{"name":"$self","containerName":"wublast","kind":13,"line":199},{"name":"_generic_local_wublast","containerName":"wublast","line":199,"kind":12},{"line":199,"kind":13,"name":"$executable","containerName":"wublast"}],"containerName":"main::","definition":"sub","detail":"($self,$input1)","signature":{"documentation":"1;\n# $Id: StandAloneWUBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneWUBlast - Object for the local execution \nof WU-Blast.\n\n=head1 SYNOPSIS\n\n # Do not use directly; use Bio::Tools::Run::StandAloneBlast\n\n=head1 DESCRIPTION\n\nSee Bio::Tools::Run::StandAloneBlast\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneWUBlast;\n\nuse strict;\n\nuse base qw(Bio::Tools::Run::StandAloneBlast);\n\nour $AUTOLOAD;\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $Bio::Tools::Run::StandAloneBlast::DATADIR;\n\nour %GENERAL_PARAMS  = (i => 'input',\n                        o => 'outfile',\n                        p => 'program',\n                        d => 'database');\nour @WUBLAST_PARAMS  = qw(e s e2 s2 w t x m y z l k h v b q r\n    matrix filter wordmask filter maskextra  hitdist wink ctxfactor gape\n    gaps gape2 gaps2 gapw gapx olf golf  olmax golmax gapdecayrate\n    topcombon topcomboe sumstatsmethod hspsepqmax hspsepsmax gapsepqmax\n    gapsepsmax altscore hspmax gspmax qoffset nwstart nwlen qrecmin qrecmax \n    dbrecmin dbrecmax vdbdescmax dbchunks sort_by_pvalue  cpus putenv\n    getenv progress);\nour @WUBLAST_SWITCH = qw(kap sump poissonp lcfilter lcmask echofilter\n    stats nogap gapall pingpong nosegs postsw span2 span1 span prune\n    consistency links ucdb gi noseqs qtype qres sort_by_pvalue\n    sort_by_count sort_by_highscore sort_by_totalscore\n    sort_by_subjectlength mmio nonnegok novalidctxok shortqueryok notes\n    warnings errors endputenv getenv endgetenv abortonerror abortonfatal);\n\nour @OTHER_PARAMS = qw(_READMETHOD);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p.\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    \n    $self->_set_from_args(\\@args, -methods => {(map { $_ => $GENERAL_PARAMS{$_} } keys %GENERAL_PARAMS),\n                                               (map { $_ => $_ } (@OTHER_PARAMS,\n                                                                  @WUBLAST_PARAMS,\n                                                                  @WUBLAST_SWITCH))},\n                                  -create => 1,\n                                  -force => 1);\n    \n    my ($tfh, $tempfile) = $self->io->tempfile();\n    my $outfile = $self->o || $self->outfile || $tempfile;\n    $self->o($outfile);\n    close($tfh);\n    \n    $self->_READMETHOD($DEFAULTREADMETHOD) unless $self->_READMETHOD;\n    \n    return $self;\n}\n\n# We let get/setter method names be case-insensitve\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    \n    my $orig = $attr;\n    \n    $attr = lc($attr);\n    \n    $self->can($attr) || $self->throw(\"Unallowed parameter: $orig !\");\n    \n    return $self->$attr(@_);\n}\n\n=head2  wublast\n\n Title   : wublast\n Usage   :  $blast_report = $factory->wublast('t/testquery.fa');\n\tor\n\t       $input = Bio::Seq->new(-id=>\"test query\",\n\t\t\t\t      -seq=>\"ACTACCCTTTAAATCAGTGGGGG\");\n\t       $blast_report = $factory->wublast($input);\n\tor \n\t      $seq_array_ref = \\@seq_array;  # where @seq_array is an array of Bio::Seq objects\n\t      $blast_report = $factory->wublast(\\@seq_array);\n Returns :  Reference to a Blast object \n Args    : Name of a file or Bio::Seq object or an array of \n           Bio::Seq object containing the query sequence(s). \n           Throws an exception if argument is not either a string \n           (eg a filename) or a reference to a Bio::Seq object \n           (or to an array of Seq objects).  If argument is string, \n           throws exception if file corresponding to string name can \n           not be found.","parameters":[{"label":"$self"},{"label":"$input1"}],"label":"wublast($self,$input1)"}},{"containerName":"main::","name":"_generic_local_wublast","definition":"sub","range":{"end":{"character":9999,"line":221},"start":{"character":0,"line":211}},"kind":12,"line":211,"children":[{"kind":13,"line":212,"name":"$self","definition":"my","containerName":"_generic_local_wublast","localvar":"my"},{"kind":13,"line":213,"name":"$executable","definition":"my","containerName":"_generic_local_wublast","localvar":"my"},{"kind":13,"line":216,"definition":"my","name":"$param_string","containerName":"_generic_local_wublast","localvar":"my"},{"name":"$self","containerName":"_generic_local_wublast","kind":13,"line":216},{"kind":12,"line":216,"containerName":"_generic_local_wublast","name":"_setparams"},{"kind":13,"line":216,"name":"$executable","containerName":"_generic_local_wublast"},{"name":"$param_string","containerName":"_generic_local_wublast","line":217,"kind":13},{"kind":13,"line":217,"containerName":"_generic_local_wublast","name":"$self"},{"name":"database","containerName":"_generic_local_wublast","kind":12,"line":217},{"name":"$self","containerName":"_generic_local_wublast","kind":13,"line":217},{"containerName":"_generic_local_wublast","name":"input","kind":12,"line":217},{"containerName":"_generic_local_wublast","name":"$param_string","line":217,"kind":13},{"localvar":"my","definition":"my","name":"$blast_report","containerName":"_generic_local_wublast","line":220,"kind":13},{"containerName":"_generic_local_wublast","name":"$self","line":220,"kind":13},{"kind":12,"line":220,"name":"_runwublast","containerName":"_generic_local_wublast"},{"kind":13,"line":220,"containerName":"_generic_local_wublast","name":"$executable"},{"kind":13,"line":220,"containerName":"_generic_local_wublast","name":"$param_string"}]},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: StandAloneWUBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneWUBlast - Object for the local execution \nof WU-Blast.\n\n=head1 SYNOPSIS\n\n # Do not use directly; use Bio::Tools::Run::StandAloneBlast\n\n=head1 DESCRIPTION\n\nSee Bio::Tools::Run::StandAloneBlast\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneWUBlast;\n\nuse strict;\n\nuse base qw(Bio::Tools::Run::StandAloneBlast);\n\nour $AUTOLOAD;\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $Bio::Tools::Run::StandAloneBlast::DATADIR;\n\nour %GENERAL_PARAMS  = (i => 'input',\n                        o => 'outfile',\n                        p => 'program',\n                        d => 'database');\nour @WUBLAST_PARAMS  = qw(e s e2 s2 w t x m y z l k h v b q r\n    matrix filter wordmask filter maskextra  hitdist wink ctxfactor gape\n    gaps gape2 gaps2 gapw gapx olf golf  olmax golmax gapdecayrate\n    topcombon topcomboe sumstatsmethod hspsepqmax hspsepsmax gapsepqmax\n    gapsepsmax altscore hspmax gspmax qoffset nwstart nwlen qrecmin qrecmax \n    dbrecmin dbrecmax vdbdescmax dbchunks sort_by_pvalue  cpus putenv\n    getenv progress);\nour @WUBLAST_SWITCH = qw(kap sump poissonp lcfilter lcmask echofilter\n    stats nogap gapall pingpong nosegs postsw span2 span1 span prune\n    consistency links ucdb gi noseqs qtype qres sort_by_pvalue\n    sort_by_count sort_by_highscore sort_by_totalscore\n    sort_by_subjectlength mmio nonnegok novalidctxok shortqueryok notes\n    warnings errors endputenv getenv endgetenv abortonerror abortonfatal);\n\nour @OTHER_PARAMS = qw(_READMETHOD);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p.\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    \n    $self->_set_from_args(\\@args, -methods => {(map { $_ => $GENERAL_PARAMS{$_} } keys %GENERAL_PARAMS),\n                                               (map { $_ => $_ } (@OTHER_PARAMS,\n                                                                  @WUBLAST_PARAMS,\n                                                                  @WUBLAST_SWITCH))},\n                                  -create => 1,\n                                  -force => 1);\n    \n    my ($tfh, $tempfile) = $self->io->tempfile();\n    my $outfile = $self->o || $self->outfile || $tempfile;\n    $self->o($outfile);\n    close($tfh);\n    \n    $self->_READMETHOD($DEFAULTREADMETHOD) unless $self->_READMETHOD;\n    \n    return $self;\n}\n\n# We let get/setter method names be case-insensitve\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    \n    my $orig = $attr;\n    \n    $attr = lc($attr);\n    \n    $self->can($attr) || $self->throw(\"Unallowed parameter: $orig !\");\n    \n    return $self->$attr(@_);\n}\n\n=head2  wublast\n\n Title   : wublast\n Usage   :  $blast_report = $factory->wublast('t/testquery.fa');\n\tor\n\t       $input = Bio::Seq->new(-id=>\"test query\",\n\t\t\t\t      -seq=>\"ACTACCCTTTAAATCAGTGGGGG\");\n\t       $blast_report = $factory->wublast($input);\n\tor \n\t      $seq_array_ref = \\@seq_array;  # where @seq_array is an array of Bio::Seq objects\n\t      $blast_report = $factory->wublast(\\@seq_array);\n Returns :  Reference to a Blast object \n Args    : Name of a file or Bio::Seq object or an array of \n           Bio::Seq object containing the query sequence(s). \n           Throws an exception if argument is not either a string \n           (eg a filename) or a reference to a Bio::Seq object \n           (or to an array of Seq objects).  If argument is string, \n           throws exception if file corresponding to string name can \n           not be found.\n\n\nsub wublast {\n    my ($self, $input1) = @_;\n    $self->io->_io_cleanup();\n    my $executable = 'wublast';\n    \n    # Create input file pointer\n    my $infilename1 = $self->_setinput($executable, $input1) || $self->throw(\"$input1 not Bio::Seq object or array of Bio::Seq objects or file name!\");\n    $self->i($infilename1);\n    \n    my $blast_report = $self->_generic_local_wublast($executable);\n}\n\n=head2  _generic_local_wublast\n\n Title   : _generic_local_wublast\n Usage   :  internal function not called directly\n Returns :  Blast object\n Args    :   Reference to calling object and name of BLAST executable \n\n\nsub _generic_local_wublast {\n    my $self = shift;\n    my $executable = shift;\n    \n    # Create parameter string to pass to Blast program\n    my $param_string = $self->_setparams($executable);\n    $param_string = \" \".$self->database.\" \".$self->input.\" \".$param_string;\n    \n    # run Blast\n    my $blast_report = $self->_runwublast($executable, $param_string);\n}\n\n=head2  _runwublast\n\n Title   :  _runwublast\n Usage   :  Internal function, not to be called directly\t\n Function:   makes actual system call to WU-Blast program\n Example :\n Returns : Report Blast object\n Args    : Reference to calling object, name of BLAST executable, \n           and parameter string for executable ","parameters":[{"label":"$self"},{"label":"$executable"},{"label":"$param_string"}],"label":"_runwublast($self,$executable,$param_string)"},"detail":"($self,$executable,$param_string)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_runwublast","line":236,"kind":13},{"containerName":"_runwublast","name":"$executable","kind":13,"line":236},{"name":"$param_string","containerName":"_runwublast","line":236,"kind":13},{"definition":"my","name":"$blast_obj","containerName":"_runwublast","localvar":"my","kind":13,"line":237},{"containerName":"_runwublast","name":"$exe","kind":13,"line":237},{"kind":13,"line":238,"containerName":"_runwublast","name":"$exe"},{"name":"$self","containerName":"_runwublast","kind":13,"line":238},{"containerName":"_runwublast","name":"executable","line":238,"kind":12},{"line":238,"kind":13,"containerName":"_runwublast","name":"$self"},{"kind":12,"line":238,"containerName":"_runwublast","name":"p"},{"line":239,"kind":13,"name":"$self","containerName":"_runwublast"},{"containerName":"_runwublast","name":"warn","line":239,"kind":12},{"line":243,"kind":13,"localvar":"my","containerName":"_runwublast","name":"$commandstring","definition":"my"},{"kind":13,"line":243,"name":"$exe","containerName":"_runwublast"},{"containerName":"_runwublast","name":"$param_string","line":243,"kind":13},{"name":"$self","containerName":"_runwublast","line":245,"kind":13},{"name":"debug","containerName":"_runwublast","line":245,"kind":12},{"line":246,"kind":13,"containerName":"_runwublast","name":"$commandstring"},{"kind":13,"line":246,"containerName":"_runwublast","name":"$self"},{"kind":12,"line":246,"containerName":"_runwublast","name":"throw"},{"localvar":"my","containerName":"_runwublast","name":"$outfile","definition":"my","line":249,"kind":13},{"kind":13,"line":249,"containerName":"_runwublast","name":"$self"},{"kind":12,"line":249,"containerName":"_runwublast","name":"o"},{"name":"$blast_obj","containerName":"_runwublast","kind":13,"line":250},{"kind":12,"line":250,"name":"new","containerName":"_runwublast"},{"name":"$outfile","containerName":"_runwublast","kind":13,"line":250},{"line":252,"kind":13,"containerName":"_runwublast","name":"$blast_obj"}],"line":235,"name":"_runwublast","range":{"start":{"character":0,"line":235},"end":{"line":253,"character":9999}}},{"name":"Bio","containerName":"SearchIO","line":250,"kind":12},{"line":266,"children":[{"definition":"my","name":"$self","containerName":"_setparams","localvar":"my","kind":13,"line":267},{"kind":13,"line":267,"name":"$executable","containerName":"_setparams"},{"localvar":"my","definition":"my","name":"$attr","containerName":"_setparams","line":268,"kind":13},{"line":268,"kind":13,"name":"$value","containerName":"_setparams"},{"containerName":"_setparams","name":"@execparams","kind":13,"line":268},{"name":"@execparams","containerName":"_setparams","line":270,"kind":13},{"name":"@WUBLAST_PARAMS","containerName":"_setparams","kind":13,"line":270},{"containerName":"_setparams","name":"@execparams","kind":13,"line":274},{"definition":"my","name":"$tmp","containerName":"_setparams","localvar":"my","kind":13,"line":279},{"name":"$self","containerName":"_setparams","line":279,"kind":13},{"line":279,"kind":12,"containerName":"_setparams","name":"o"},{"line":280,"kind":13,"name":"$self","containerName":"_setparams"},{"kind":12,"line":280,"containerName":"_setparams","name":"o"},{"name":"$tmp","containerName":"_setparams","kind":13,"line":280},{"name":"$tmp","containerName":"_setparams","line":280,"kind":13},{"kind":13,"line":282,"containerName":"_setparams","definition":"my","name":"$param_string","localvar":"my"},{"name":"$self","containerName":"_setparams","line":282,"kind":13},{"line":282,"kind":13,"name":"@execparams","containerName":"_setparams"},{"line":283,"kind":13,"containerName":"_setparams","name":"@WUBLAST_SWITCH"},{"kind":13,"line":286,"name":"$self","containerName":"_setparams"},{"name":"o","containerName":"_setparams","kind":12,"line":286},{"containerName":"_setparams","name":"$tmp","line":286,"kind":13},{"line":286,"kind":13,"name":"$tmp","containerName":"_setparams"},{"line":288,"kind":13,"containerName":"_setparams","name":"$self"},{"kind":12,"line":288,"containerName":"_setparams","name":"quiet"},{"containerName":"_setparams","name":"$param_string","kind":13,"line":289},{"name":"devnull","containerName":"_setparams","kind":12,"line":289},{"kind":13,"line":292,"name":"$param_string","containerName":"_setparams"}],"kind":12,"detail":"($self,$executable)","signature":{"label":"_setparams($self,$executable)","parameters":[{"label":"$self"},{"label":"$executable"}],"documentation":"1;\n# $Id: StandAloneWUBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::StandAloneBlast\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::StandAloneWUBlast - Object for the local execution \nof WU-Blast.\n\n=head1 SYNOPSIS\n\n # Do not use directly; use Bio::Tools::Run::StandAloneBlast\n\n=head1 DESCRIPTION\n\nSee Bio::Tools::Run::StandAloneBlast\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail schattner at alum.mit.edu\n\n=head1 MAINTAINER - Torsten Seemann\n\nEmail torsten at infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk (reimplementation)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::StandAloneWUBlast;\n\nuse strict;\n\nuse base qw(Bio::Tools::Run::StandAloneBlast);\n\nour $AUTOLOAD;\nour $DEFAULTREADMETHOD = 'BLAST';\n\n# If local BLAST databases are not stored in the standard\n# /data directory, the variable BLASTDATADIR will need to be \n# set explicitly \nour $DATADIR = $Bio::Tools::Run::StandAloneBlast::DATADIR;\n\nour %GENERAL_PARAMS  = (i => 'input',\n                        o => 'outfile',\n                        p => 'program',\n                        d => 'database');\nour @WUBLAST_PARAMS  = qw(e s e2 s2 w t x m y z l k h v b q r\n    matrix filter wordmask filter maskextra  hitdist wink ctxfactor gape\n    gaps gape2 gaps2 gapw gapx olf golf  olmax golmax gapdecayrate\n    topcombon topcomboe sumstatsmethod hspsepqmax hspsepsmax gapsepqmax\n    gapsepsmax altscore hspmax gspmax qoffset nwstart nwlen qrecmin qrecmax \n    dbrecmin dbrecmax vdbdescmax dbchunks sort_by_pvalue  cpus putenv\n    getenv progress);\nour @WUBLAST_SWITCH = qw(kap sump poissonp lcfilter lcmask echofilter\n    stats nogap gapall pingpong nosegs postsw span2 span1 span prune\n    consistency links ucdb gi noseqs qtype qres sort_by_pvalue\n    sort_by_count sort_by_highscore sort_by_totalscore\n    sort_by_subjectlength mmio nonnegok novalidctxok shortqueryok notes\n    warnings errors endputenv getenv endgetenv abortonerror abortonfatal);\n\nour @OTHER_PARAMS = qw(_READMETHOD);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Run::StandAloneBlast->new();\n Function: Builds a newBio::Tools::Run::StandAloneBlast object \n Returns : Bio::Tools::Run::StandAloneBlast\n Args    : -quiet => boolean # make program execution quiet\n           -_READMETHOD => 'BLAST' (default, synonym 'SearchIO') || 'blast_pull'\n                           # the parsing method, case insensitive\n\nEssentially all BLAST parameters can be set via StandAloneBlast.pm.\nSome of the most commonly used parameters are listed below. All\nparameters have defaults and are optional except for -p.\n\n  -p Program Name [String] \n        Input should be one of \"wublastp\", \"wublastn\", \"wublastx\", \n        \"wutblastn\", or \"wutblastx\".\n  -d  Database [String] default = nr\n        The database specified must first be formatted with xdformat.\n  -E  Expectation value (E) [Real] default = 10.0\n  -o  BLAST report Output File [File Out]  Optional,\n\t    default = ./blastreport.out ; set by StandAloneBlast.pm\t\t\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    \n    $self->_set_from_args(\\@args, -methods => {(map { $_ => $GENERAL_PARAMS{$_} } keys %GENERAL_PARAMS),\n                                               (map { $_ => $_ } (@OTHER_PARAMS,\n                                                                  @WUBLAST_PARAMS,\n                                                                  @WUBLAST_SWITCH))},\n                                  -create => 1,\n                                  -force => 1);\n    \n    my ($tfh, $tempfile) = $self->io->tempfile();\n    my $outfile = $self->o || $self->outfile || $tempfile;\n    $self->o($outfile);\n    close($tfh);\n    \n    $self->_READMETHOD($DEFAULTREADMETHOD) unless $self->_READMETHOD;\n    \n    return $self;\n}\n\n# We let get/setter method names be case-insensitve\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    \n    my $orig = $attr;\n    \n    $attr = lc($attr);\n    \n    $self->can($attr) || $self->throw(\"Unallowed parameter: $orig !\");\n    \n    return $self->$attr(@_);\n}\n\n=head2  wublast\n\n Title   : wublast\n Usage   :  $blast_report = $factory->wublast('t/testquery.fa');\n\tor\n\t       $input = Bio::Seq->new(-id=>\"test query\",\n\t\t\t\t      -seq=>\"ACTACCCTTTAAATCAGTGGGGG\");\n\t       $blast_report = $factory->wublast($input);\n\tor \n\t      $seq_array_ref = \\@seq_array;  # where @seq_array is an array of Bio::Seq objects\n\t      $blast_report = $factory->wublast(\\@seq_array);\n Returns :  Reference to a Blast object \n Args    : Name of a file or Bio::Seq object or an array of \n           Bio::Seq object containing the query sequence(s). \n           Throws an exception if argument is not either a string \n           (eg a filename) or a reference to a Bio::Seq object \n           (or to an array of Seq objects).  If argument is string, \n           throws exception if file corresponding to string name can \n           not be found.\n\n\nsub wublast {\n    my ($self, $input1) = @_;\n    $self->io->_io_cleanup();\n    my $executable = 'wublast';\n    \n    # Create input file pointer\n    my $infilename1 = $self->_setinput($executable, $input1) || $self->throw(\"$input1 not Bio::Seq object or array of Bio::Seq objects or file name!\");\n    $self->i($infilename1);\n    \n    my $blast_report = $self->_generic_local_wublast($executable);\n}\n\n=head2  _generic_local_wublast\n\n Title   : _generic_local_wublast\n Usage   :  internal function not called directly\n Returns :  Blast object\n Args    :   Reference to calling object and name of BLAST executable \n\n\nsub _generic_local_wublast {\n    my $self = shift;\n    my $executable = shift;\n    \n    # Create parameter string to pass to Blast program\n    my $param_string = $self->_setparams($executable);\n    $param_string = \" \".$self->database.\" \".$self->input.\" \".$param_string;\n    \n    # run Blast\n    my $blast_report = $self->_runwublast($executable, $param_string);\n}\n\n=head2  _runwublast\n\n Title   :  _runwublast\n Usage   :  Internal function, not to be called directly\t\n Function:   makes actual system call to WU-Blast program\n Example :\n Returns : Report Blast object\n Args    : Reference to calling object, name of BLAST executable, \n           and parameter string for executable \n\n\nsub _runwublast {\n\tmy ($self, $executable, $param_string) = @_;\n\tmy ($blast_obj, $exe);\n\tif (! ($exe = $self->executable($self->p))){\n        $self->warn(\"cannot find path to $executable\");\n        return;\n\t}\n    \n\tmy $commandstring = $exe.$param_string;\n    \n\t$self->debug(\"$commandstring\\n\");\n\tsystem($commandstring) && $self->throw(\"$executable call crashed: $? | $! | $commandstring\\n\");\n    \n    # get outputfilename\n\tmy $outfile = $self->o();\t\n\t$blast_obj = Bio::SearchIO->new(-file => $outfile, -format => 'blast');\n    \n\treturn $blast_obj;\n}\n\n=head2  _setparams\n\n Title   : _setparams\n Usage   : Internal function, not to be called directly\t\n Function: Create parameter inputs for Blast program\n Example :\n Returns : parameter string to be passed to Blast \n Args    : Reference to calling object and name of BLAST executable"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":266},"end":{"line":293,"character":9999}},"name":"_setparams"},{"name":"SUPER","containerName":"_setparams","line":282,"kind":12},{"name":"File","containerName":"Spec","line":289,"kind":12}],"version":5}