{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":113},{"localvar":"my","definition":"my","name":"%MAPLOC","containerName":null,"line":117,"kind":13},{"detail":"($self,$method)","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"containerName":"main::","definition":"sub","line":136,"children":[{"line":138,"kind":13,"localvar":"my","containerName":"analysis_method","definition":"my","name":"$self"},{"kind":13,"line":138,"containerName":"analysis_method","name":"$method"},{"line":140,"kind":13,"name":"$method","containerName":"analysis_method"},{"line":140,"kind":13,"containerName":"analysis_method","name":"$method"},{"line":141,"kind":13,"name":"$self","containerName":"analysis_method"},{"containerName":"analysis_method","name":"throw","kind":12,"line":141},{"line":141,"kind":13,"containerName":"analysis_method","name":"$self"},{"kind":13,"line":144,"containerName":"analysis_method","name":"$self"},{"kind":13,"line":144,"name":"$method","containerName":"analysis_method"}],"kind":12,"range":{"start":{"line":136,"character":0},"end":{"character":9999,"line":145}},"name":"analysis_method"},{"line":144,"kind":12,"name":"SUPER","containerName":"analysis_method"},{"containerName":"main::","definition":"sub","detail":"($self,$net)","signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used","parameters":[{"label":"$self"},{"label":"$net"}],"label":"network($self,$net)"},"kind":12,"line":158,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"network","line":160,"kind":13},{"containerName":"network","name":"$net","line":160,"kind":13},{"line":162,"kind":13,"containerName":"network","name":"$net"},{"containerName":"network","name":"$self","kind":13,"line":163},{"line":163,"kind":13,"containerName":"network","name":"$net"},{"name":"$self","containerName":"network","line":166,"kind":13}],"name":"network","range":{"end":{"character":9999,"line":168},"start":{"character":0,"line":158}}},{"kind":12,"children":[{"line":184,"kind":13,"localvar":"my","containerName":"cleavage","definition":"my","name":"$self"},{"line":184,"kind":13,"containerName":"cleavage","name":"$cleavage"},{"line":186,"kind":13,"containerName":"cleavage","name":"$cleavage"},{"kind":13,"line":187,"name":"$self","containerName":"cleavage"},{"containerName":"cleavage","name":"$cleavage","line":187,"kind":13},{"name":"$self","containerName":"cleavage","line":190,"kind":13}],"line":182,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not","parameters":[{"label":"$self"},{"label":"$cleavage"}],"label":"cleavage($self,$cleavage)"},"detail":"($self,$cleavage)","name":"cleavage","range":{"end":{"character":9999,"line":192},"start":{"line":182,"character":0}}},{"range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":213}},"name":"next_prediction","children":[{"containerName":"next_prediction","definition":"my","name":"$self","localvar":"my","kind":13,"line":206},{"name":"$self","containerName":"next_prediction","kind":13,"line":208},{"name":"_parsed","containerName":"next_prediction","line":208,"kind":12},{"line":209,"kind":13,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":209,"name":"_parse_results","containerName":"next_prediction"},{"line":210,"kind":13,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":210,"containerName":"next_prediction","name":"_parsed"},{"kind":13,"line":213,"containerName":"next_prediction","name":"$self"}],"line":204,"kind":12,"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":229,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"create_feature"},{"kind":13,"line":229,"containerName":"create_feature","name":"$feat"},{"line":231,"kind":13,"name":"$self","containerName":"create_feature"},{"name":"throw","containerName":"create_feature","line":231,"kind":12},{"kind":13,"line":231,"name":"$feat","containerName":"create_feature"},{"kind":13,"line":231,"name":"$feat","containerName":"create_feature"},{"localvar":"my","definition":"my","name":"$feature","containerName":"create_feature","line":233,"kind":13},{"name":"new","containerName":"create_feature","kind":12,"line":233},{"containerName":"create_feature","name":"$feat","kind":13,"line":234},{"kind":13,"line":235,"containerName":"create_feature","name":"$self"},{"kind":12,"line":235,"containerName":"create_feature","name":"analysis_method"},{"name":"$feat","containerName":"create_feature","kind":13,"line":240},{"line":241,"kind":13,"name":"$feature","containerName":"create_feature"},{"line":241,"kind":12,"containerName":"create_feature","name":"start"},{"kind":13,"line":242,"name":"$feature","containerName":"create_feature"},{"name":"end","containerName":"create_feature","line":242,"kind":12},{"containerName":"create_feature","name":"$feat","line":242,"kind":13},{"kind":13,"line":244,"containerName":"create_feature","name":"$feature"},{"kind":12,"line":244,"name":"add_tag_value","containerName":"create_feature"},{"kind":13,"line":244,"name":"$MAPLOC","containerName":"create_feature"},{"name":"$feat","containerName":"create_feature","line":244,"kind":13},{"line":244,"kind":13,"name":"$MAPLOC","containerName":"create_feature"},{"kind":13,"line":244,"containerName":"create_feature","name":"$feat"},{"containerName":"create_feature","name":"$feature","line":245,"kind":13},{"line":245,"kind":12,"name":"add_tag_value","containerName":"create_feature"},{"name":"$feat","containerName":"create_feature","line":245,"kind":13},{"kind":13,"line":245,"name":"$feat","containerName":"create_feature"},{"kind":13,"line":246,"containerName":"create_feature","name":"$feature"},{"name":"add_tag_value","containerName":"create_feature","line":246,"kind":12},{"kind":13,"line":246,"name":"$feat","containerName":"create_feature"},{"name":"$feat","containerName":"create_feature","line":246,"kind":13},{"containerName":"create_feature","name":"$feature","kind":13,"line":247},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":247},{"containerName":"create_feature","name":"$feat","kind":13,"line":247},{"name":"$feat","containerName":"create_feature","line":247,"kind":13},{"name":"$feature","containerName":"create_feature","kind":13,"line":248},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":248},{"kind":13,"line":248,"name":"$feat","containerName":"create_feature"},{"line":248,"kind":13,"containerName":"create_feature","name":"$feat"},{"kind":13,"line":249,"containerName":"create_feature","name":"$feature"},{"line":249,"kind":12,"name":"add_tag_value","containerName":"create_feature"},{"line":249,"kind":13,"name":"$feat","containerName":"create_feature"},{"kind":13,"line":249,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feature","kind":13,"line":250},{"kind":12,"line":250,"containerName":"create_feature","name":"add_tag_value"},{"containerName":"create_feature","name":"$feat","kind":13,"line":250},{"name":"$feat","containerName":"create_feature","line":250,"kind":13},{"kind":13,"line":252,"name":"$feature","containerName":"create_feature"},{"name":"add_tag_value","containerName":"create_feature","line":252,"kind":12},{"line":252,"kind":13,"name":"$self","containerName":"create_feature"},{"kind":12,"line":252,"name":"network","containerName":"create_feature"},{"line":254,"kind":13,"name":"$feature","containerName":"create_feature"}],"line":227,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"create_feature($self,$feat)"},"detail":"($self,$feat)","name":"create_feature","range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":227}}},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":233},{"kind":12,"line":234,"name":"seqid"},{"kind":12,"line":240,"name":"seqlen"},{"line":242,"kind":12,"name":"seqlen"},{"line":244,"kind":12,"name":"loc"},{"name":"loc","kind":12,"line":244},{"line":245,"kind":12,"name":"cTP"},{"name":"cTP","line":245,"kind":12},{"name":"mTP","line":246,"kind":12},{"kind":12,"line":246,"name":"mTP"},{"kind":12,"line":247,"name":"SP"},{"name":"SP","kind":12,"line":247},{"name":"other","line":248,"kind":12},{"line":248,"kind":12,"name":"other"},{"name":"RC","kind":12,"line":249},{"line":249,"kind":12,"name":"RC"},{"line":250,"kind":12,"name":"TPLen"},{"name":"TPLen","kind":12,"line":250},{"children":[{"kind":13,"line":288,"name":"$self","definition":"my","containerName":"_initialize_state","localvar":"my"},{"name":"@args","containerName":"_initialize_state","line":288,"kind":13},{"name":"$self","containerName":"_initialize_state","line":290,"kind":13},{"kind":13,"line":290,"name":"@args","containerName":"_initialize_state"},{"kind":13,"line":293,"containerName":"_initialize_state","name":"$self"},{"line":294,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$self","containerName":"_initialize_state","kind":13,"line":295},{"line":296,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$self","containerName":"_initialize_state","kind":13,"line":297},{"name":"$self","containerName":"_initialize_state","line":298,"kind":13},{"containerName":"_initialize_state","name":"$self","line":300,"kind":13},{"name":"analysis_method","containerName":"_initialize_state","line":300,"kind":12}],"line":286,"kind":12,"signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":303,"character":9999},"start":{"line":286,"character":0}},"name":"_initialize_state"},{"kind":12,"line":290,"containerName":"_initialize_state","name":"SUPER"},{"detail":"($self)","signature":{"label":"_predictions($self)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":314,"children":[{"kind":13,"line":316,"definition":"my","name":"$self","containerName":"_predictions","localvar":"my"},{"kind":13,"line":318,"name":"$self","containerName":"_predictions"}],"kind":12,"range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":314}},"name":"_predictions"},{"range":{"end":{"line":343,"character":9999},"start":{"character":0,"line":334}},"name":"_parsed","signature":{"label":"_parsed($self,$value)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"containerName":"_parsed","name":"$self","definition":"my","localvar":"my","kind":13,"line":336},{"containerName":"_parsed","name":"$value","kind":13,"line":336},{"containerName":"_parsed","name":"$value","kind":13,"line":338},{"name":"$self","containerName":"_parsed","kind":13,"line":339},{"line":339,"kind":13,"containerName":"_parsed","name":"$value"},{"name":"$self","containerName":"_parsed","line":342,"kind":13}],"line":334,"kind":12},{"range":{"end":{"line":411,"character":9999},"start":{"character":0,"line":359}},"name":"_parse_results","line":359,"children":[{"name":"$self","definition":"my","containerName":"_parse_results","localvar":"my","kind":13,"line":361},{"line":376,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"_parse_results"},{"kind":13,"line":376,"containerName":"_parse_results","name":"$self"},{"kind":12,"line":376,"name":"_readline","containerName":"_parse_results"},{"name":"$line","containerName":"_parse_results","kind":13,"line":378},{"name":"$self","containerName":"_parse_results","line":380,"kind":13},{"containerName":"_parse_results","name":"analysis_method_version","kind":12,"line":380},{"kind":13,"line":382,"containerName":"_parse_results","name":"$line"},{"line":384,"kind":13,"name":"$self","containerName":"_parse_results"},{"kind":12,"line":384,"containerName":"_parse_results","name":"cleavage"},{"name":"$line","containerName":"_parse_results","line":386,"kind":13},{"containerName":"_parse_results","name":"$self","line":388,"kind":13},{"kind":12,"line":388,"name":"network","containerName":"_parse_results"},{"kind":13,"line":390,"name":"$line","containerName":"_parse_results"},{"containerName":"_parse_results","name":"$self","line":393,"kind":13},{"line":393,"kind":12,"containerName":"_parse_results","name":"_readline"},{"definition":"my","name":"$hash","containerName":"_parse_results","localvar":"my","kind":13,"line":395},{"containerName":"_parse_results","name":"$line","definition":"my","localvar":"my","kind":13,"line":397},{"kind":13,"line":397,"containerName":"_parse_results","name":"$self"},{"line":397,"kind":12,"name":"_readline","containerName":"_parse_results"},{"line":399,"kind":13,"name":"$line","containerName":"_parse_results"},{"kind":13,"line":401,"containerName":"_parse_results","definition":"my","name":"$hash","localvar":"my"},{"name":"$self","containerName":"_parse_results","line":401,"kind":13},{"kind":12,"line":401,"containerName":"_parse_results","name":"_parse_line"},{"kind":13,"line":401,"containerName":"_parse_results","name":"$line"},{"kind":13,"line":403,"definition":"my","name":"$new_feature","containerName":"_parse_results","localvar":"my"},{"line":403,"kind":13,"name":"$self","containerName":"_parse_results"},{"line":403,"kind":12,"containerName":"_parse_results","name":"create_feature"},{"kind":13,"line":403,"name":"$hash","containerName":"_parse_results"},{"kind":13,"line":405,"containerName":"_parse_results","name":"$self"},{"kind":12,"line":405,"name":"_add_feature","containerName":"_parse_results"},{"name":"$new_feature","containerName":"_parse_results","line":405,"kind":13}],"kind":12,"detail":"($self)","signature":{"label":"_parse_results($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none"},"containerName":"main::","definition":"sub"},{"detail":"($self,$line)","signature":{"label":"_parse_line($self,$line)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse","parameters":[{"label":"$self"},{"label":"$line"}]},"containerName":"main::","definition":"sub","line":425,"children":[{"kind":13,"line":427,"containerName":"_parse_line","name":"$self","definition":"my","localvar":"my"},{"line":427,"kind":13,"name":"$line","containerName":"_parse_line"},{"containerName":"_parse_line","name":"$self","kind":13,"line":429},{"line":429,"kind":12,"containerName":"_parse_line","name":"throw"},{"line":429,"kind":13,"name":"$line","containerName":"_parse_line"},{"kind":13,"line":431,"containerName":"_parse_line","definition":"my","name":"$hash","localvar":"my"},{"definition":"my","name":"$seqid","containerName":"_parse_line","localvar":"my","kind":13,"line":432},{"line":432,"kind":13,"containerName":"_parse_line","name":"$seqlen"},{"containerName":"_parse_line","name":"$cTP","line":432,"kind":13},{"containerName":"_parse_line","name":"$mTP","line":432,"kind":13},{"name":"$SP","containerName":"_parse_line","line":432,"kind":13},{"kind":13,"line":432,"containerName":"_parse_line","name":"$other"},{"name":"$loc","containerName":"_parse_line","kind":13,"line":432},{"kind":13,"line":432,"containerName":"_parse_line","name":"$RC"},{"containerName":"_parse_line","name":"$TPlen","kind":13,"line":432},{"kind":13,"line":434,"name":"$self","containerName":"_parse_line"},{"containerName":"_parse_line","name":"network","line":434,"kind":12},{"name":"$seqid","containerName":"_parse_line","line":436,"kind":13},{"kind":13,"line":436,"containerName":"_parse_line","name":"$seqlen"},{"kind":13,"line":436,"name":"$mTP","containerName":"_parse_line"},{"line":436,"kind":13,"containerName":"_parse_line","name":"$SP"},{"containerName":"_parse_line","name":"$other","kind":13,"line":436},{"line":436,"kind":13,"name":"$loc","containerName":"_parse_line"},{"kind":13,"line":436,"containerName":"_parse_line","name":"$RC"},{"containerName":"_parse_line","name":"$TPlen","line":436,"kind":13},{"kind":13,"line":436,"name":"$line","containerName":"_parse_line"},{"kind":13,"line":440,"containerName":"_parse_line","name":"$seqid"},{"containerName":"_parse_line","name":"$seqlen","kind":13,"line":440},{"line":440,"kind":13,"containerName":"_parse_line","name":"$cTP"},{"kind":13,"line":440,"name":"$mTP","containerName":"_parse_line"},{"containerName":"_parse_line","name":"$SP","line":440,"kind":13},{"name":"$other","containerName":"_parse_line","line":440,"kind":13},{"kind":13,"line":440,"containerName":"_parse_line","name":"$loc"},{"name":"$RC","containerName":"_parse_line","kind":13,"line":440},{"name":"$TPlen","containerName":"_parse_line","line":440,"kind":13},{"line":440,"kind":13,"containerName":"_parse_line","name":"$line"},{"containerName":"_parse_line","name":"$hash","line":444,"kind":13},{"containerName":"_parse_line","name":"$seqid","kind":13,"line":444},{"line":445,"kind":13,"containerName":"_parse_line","name":"$hash"},{"name":"$seqlen","containerName":"_parse_line","kind":13,"line":445},{"kind":13,"line":446,"containerName":"_parse_line","name":"$hash"},{"name":"$cTP","containerName":"_parse_line","line":446,"kind":13},{"name":"$hash","containerName":"_parse_line","kind":13,"line":447},{"kind":13,"line":447,"name":"$mTP","containerName":"_parse_line"},{"containerName":"_parse_line","name":"$hash","line":448,"kind":13},{"name":"$SP","containerName":"_parse_line","kind":13,"line":448},{"containerName":"_parse_line","name":"$hash","kind":13,"line":449},{"name":"$other","containerName":"_parse_line","kind":13,"line":449},{"name":"$hash","containerName":"_parse_line","line":450,"kind":13},{"name":"$loc","containerName":"_parse_line","kind":13,"line":450},{"line":451,"kind":13,"containerName":"_parse_line","name":"$hash"},{"name":"$RC","containerName":"_parse_line","line":451,"kind":13},{"kind":13,"line":452,"containerName":"_parse_line","name":"$hash"},{"kind":13,"line":452,"name":"$TPlen","containerName":"_parse_line"},{"name":"$TPlen","containerName":"_parse_line","line":452,"kind":13},{"name":"$TPlen","containerName":"_parse_line","kind":13,"line":452},{"line":454,"kind":13,"containerName":"_parse_line","name":"$hash"}],"kind":12,"range":{"start":{"line":425,"character":0},"end":{"line":456,"character":9999}},"name":"_parse_line"},{"line":444,"kind":12,"name":"seqid"},{"line":445,"kind":12,"name":"seqlen"},{"name":"cTP","line":446,"kind":12},{"kind":12,"line":447,"name":"mTP"},{"name":"SP","kind":12,"line":448},{"name":"other","kind":12,"line":449},{"kind":12,"line":450,"name":"loc"},{"name":"RC","line":451,"kind":12},{"name":"TPLen","line":452,"kind":12},{"kind":12,"line":470,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_add_feature","line":472,"kind":13},{"containerName":"_add_feature","name":"$feature","kind":13,"line":472},{"kind":13,"line":474,"name":"$self","containerName":"_add_feature"},{"containerName":"_add_feature","name":"throw","kind":12,"line":474},{"kind":13,"line":474,"name":"$feature","containerName":"_add_feature"},{"name":"isa","containerName":"_add_feature","kind":12,"line":474},{"line":476,"kind":13,"containerName":"_add_feature","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$feature)","signature":{"label":"_add_feature($self,$feature)","parameters":[{"label":"$self"},{"label":"$feature"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse\n\n\nsub _parse_line {\n\n    my($self, $line) = @_;\n\n    $self->throw(\"No line to parse given\") unless($line);\n\n    my $hash = { };\n    my ($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen);\n\n    if($self->network() eq 'NON-PLANT'){\n\n\t($seqid, $seqlen, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }else{\n\n\t($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }\n\n    $hash->{seqid}  = $seqid;\n    $hash->{seqlen} = $seqlen;\n    $hash->{cTP}    = $cTP || undef;\n    $hash->{mTP}    = $mTP;\n    $hash->{SP}     = $SP;\n    $hash->{other}  = $other;\n    $hash->{loc}    = $loc;\n    $hash->{RC}     = $RC;\n    $hash->{TPLen}  = ($TPlen && $TPlen =~ /\\d+/) ? $TPlen : undef;\n\n    return $hash;\n\n}\n\n=head2 _add_feature\n\n Title    : _add_feature\n Usage    : $self->_add_feature($feature)\n Function : This method stores a feature object\n            For internal use only\n Example  :\n Returns  : n/a\n Arguments: Bio::SeqFeature::Generic"},"name":"_add_feature","range":{"end":{"character":9999,"line":476},"start":{"line":470,"character":0}}},{"kind":13,"line":476,"containerName":null,"name":"$feature"},{"line":495,"children":[{"line":497,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_toString_location"},{"kind":13,"line":497,"containerName":"_toString_location","name":"$key"},{"line":499,"kind":13,"name":"$key","containerName":"_toString_location"},{"containerName":"_toString_location","name":"$MAPLOC","line":499,"kind":13},{"line":499,"kind":13,"containerName":"_toString_location","name":"$key"},{"kind":13,"line":500,"name":"$MAPLOC","containerName":"_toString_location"},{"containerName":"_toString_location","name":"$key","line":500,"kind":13}],"kind":12,"detail":"($self,$key)","signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse\n\n\nsub _parse_line {\n\n    my($self, $line) = @_;\n\n    $self->throw(\"No line to parse given\") unless($line);\n\n    my $hash = { };\n    my ($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen);\n\n    if($self->network() eq 'NON-PLANT'){\n\n\t($seqid, $seqlen, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }else{\n\n\t($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }\n\n    $hash->{seqid}  = $seqid;\n    $hash->{seqlen} = $seqlen;\n    $hash->{cTP}    = $cTP || undef;\n    $hash->{mTP}    = $mTP;\n    $hash->{SP}     = $SP;\n    $hash->{other}  = $other;\n    $hash->{loc}    = $loc;\n    $hash->{RC}     = $RC;\n    $hash->{TPLen}  = ($TPlen && $TPlen =~ /\\d+/) ? $TPlen : undef;\n\n    return $hash;\n\n}\n\n=head2 _add_feature\n\n Title    : _add_feature\n Usage    : $self->_add_feature($feature)\n Function : This method stores a feature object\n            For internal use only\n Example  :\n Returns  : n/a\n Arguments: Bio::SeqFeature::Generic\n\n\nsub _add_feature {\n\n    my($self, $feature) = @_;\n\n    $self->throw(\"Need a Bio::SeqFeature::Generic object\") unless $feature->isa(\"Bio::SeqFeature::Generic\");\n\n    push(@{$self->{'_features'}}, $feature);\n\n    return;\n\n}\n\n=head2 _toString_location\n\n Title    : _toString_location\n Usage    : $self->_toString_location($key)\n Function : This method convert the 'one letter code' location to \n            the corresponding definition\n            For internal use only\n Example  :\n Returns  : Location or undef\n Arguments: String","label":"_toString_location($self,$key)"},"containerName":"main::","definition":"sub","range":{"start":{"line":495,"character":0},"end":{"character":9999,"line":504}},"name":"_toString_location"}]}