{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":86},{"containerName":"","name":"vars","line":88,"kind":2},{"name":"$GeneTag","containerName":null,"line":89,"kind":13},{"line":89,"kind":13,"containerName":null,"name":"$SrcTag"},{"name":"$ExonTag","containerName":null,"line":89,"kind":13},{"kind":12,"line":105,"children":[{"kind":13,"line":106,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"@args","kind":13,"line":106},{"line":107,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","kind":13,"line":107},{"localvar":"my","definition":"my","name":"$genetag","containerName":"_initialize","line":108,"kind":13},{"name":"$exontag","containerName":"_initialize","line":108,"kind":13},{"kind":13,"line":108,"containerName":"_initialize","name":"$srctag"},{"containerName":"_initialize","name":"$self","kind":13,"line":108},{"name":"@args","containerName":"_initialize","line":111,"kind":13},{"kind":13,"line":112,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"gene_tag","line":112,"kind":12},{"kind":13,"line":112,"containerName":"_initialize","name":"$genetag"},{"name":"$genetag","containerName":"_initialize","line":112,"kind":13},{"containerName":"_initialize","name":"$GeneTag","line":112,"kind":13},{"line":113,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"source_tag","kind":12,"line":113},{"name":"$srctag","containerName":"_initialize","line":113,"kind":13},{"line":113,"kind":13,"containerName":"_initialize","name":"$srctag"},{"containerName":"_initialize","name":"$SrcTag","line":113,"kind":13},{"kind":13,"line":114,"name":"$self","containerName":"_initialize"},{"name":"exon_tag","containerName":"_initialize","kind":12,"line":114},{"kind":13,"line":114,"name":"$exontag","containerName":"_initialize"},{"line":114,"kind":13,"containerName":"_initialize","name":"$exontag"},{"containerName":"_initialize","name":"$ExonTag","kind":13,"line":114},{"line":115,"kind":13,"containerName":"_initialize","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"_initialize","range":{"start":{"character":0,"line":105},"end":{"line":116,"character":9999}}},{"containerName":"_initialize","name":"SUPER","kind":12,"line":107},{"name":"SUPER","containerName":"_rearrange","line":108,"kind":12},{"range":{"start":{"line":130,"character":0},"end":{"line":135,"character":9999}},"containerName":"main::","definition":"sub","name":"gene_tag","line":130,"children":[{"containerName":"gene_tag","name":"$self","definition":"my","localvar":"my","kind":13,"line":131},{"name":"$self","containerName":"gene_tag","line":133,"kind":13},{"name":"$self","containerName":"gene_tag","line":134,"kind":13}],"kind":12},{"definition":"sub","name":"source_tag","containerName":"main::","range":{"start":{"line":149,"character":0},"end":{"line":154,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"source_tag","line":150,"kind":13},{"kind":13,"line":152,"containerName":"source_tag","name":"$self"},{"containerName":"source_tag","name":"$self","line":153,"kind":13}],"line":149},{"range":{"end":{"character":9999,"line":173},"start":{"character":0,"line":168}},"name":"exon_tag","definition":"sub","containerName":"main::","children":[{"line":169,"kind":13,"localvar":"my","containerName":"exon_tag","definition":"my","name":"$self"},{"kind":13,"line":171,"containerName":"exon_tag","name":"$self"},{"line":172,"kind":13,"name":"$self","containerName":"exon_tag"}],"line":168,"kind":12},{"name":"analysis_method","range":{"start":{"line":187,"character":0},"end":{"character":9999,"line":194}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"analysis_method","line":189,"kind":13},{"name":"$method","containerName":"analysis_method","line":189,"kind":13},{"name":"$method","containerName":"analysis_method","line":190,"kind":13},{"containerName":"analysis_method","name":"$method","kind":13,"line":190},{"containerName":"analysis_method","name":"$self","kind":13,"line":191},{"name":"throw","containerName":"analysis_method","line":191,"kind":12},{"containerName":"analysis_method","name":"$self","kind":13,"line":191},{"kind":13,"line":193,"containerName":"analysis_method","name":"$self"},{"containerName":"analysis_method","name":"$method","line":193,"kind":13}],"line":187,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"detail":"($self,$method)"},{"name":"SUPER","containerName":"analysis_method","line":193,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /tRNAscan-SE/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_feature($self,@args)"},"kind":12,"line":217,"children":[{"localvar":"my","containerName":"next_feature","definition":"my","name":"$self","line":218,"kind":13},{"line":218,"kind":13,"containerName":"next_feature","name":"@args"},{"containerName":"next_feature","name":"$self","kind":13,"line":222},{"containerName":"next_feature","name":"next_prediction","kind":12,"line":222},{"name":"@args","containerName":"next_feature","kind":13,"line":222}],"name":"next_feature","range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":223}}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /tRNAscan-SE/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>"},"kind":12,"line":241,"children":[{"line":242,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_prediction"},{"name":"$genetag","definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"line":243},{"kind":13,"line":243,"containerName":"next_prediction","name":"$srctag"},{"containerName":"next_prediction","name":"$exontag","kind":13,"line":243},{"containerName":"next_prediction","name":"$self","line":243,"kind":13},{"line":243,"kind":12,"containerName":"next_prediction","name":"gene_tag"},{"containerName":"next_prediction","name":"$self","kind":13,"line":244},{"kind":12,"line":244,"name":"source_tag","containerName":"next_prediction"},{"line":245,"kind":13,"containerName":"next_prediction","name":"$self"},{"kind":12,"line":245,"containerName":"next_prediction","name":"exon_tag"},{"kind":13,"line":247,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":247,"containerName":"next_prediction","name":"_readline"},{"localvar":"my","definition":"my","name":"$seqid","containerName":"next_prediction","line":257,"kind":13},{"containerName":"next_prediction","name":"$tRNAnum","line":257,"kind":13},{"kind":13,"line":257,"containerName":"next_prediction","name":"$start"},{"line":257,"kind":13,"containerName":"next_prediction","name":"$end"},{"kind":13,"line":257,"name":"$type","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$codon","kind":13,"line":258},{"containerName":"next_prediction","name":"$intron_start","line":258,"kind":13},{"kind":13,"line":258,"name":"$intron_end","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$score","line":259,"kind":13},{"localvar":"my","name":"$strand","definition":"my","containerName":"next_prediction","line":261,"kind":13},{"kind":13,"line":262,"name":"$start","containerName":"next_prediction"},{"name":"$end","containerName":"next_prediction","line":262,"kind":13},{"kind":13,"line":263,"containerName":"next_prediction","name":"$start"},{"line":263,"kind":13,"name":"$end","containerName":"next_prediction"},{"kind":13,"line":263,"name":"$strand","containerName":"next_prediction"},{"line":263,"kind":13,"containerName":"next_prediction","name":"$end"},{"kind":13,"line":263,"name":"$start","containerName":"next_prediction"},{"kind":13,"line":265,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"$type","kind":13,"line":265},{"kind":13,"line":266,"name":"$type","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","line":266,"kind":13},{"kind":13,"line":266,"containerName":"next_prediction","name":"$type"},{"kind":13,"line":268,"name":"$gene","definition":"my","containerName":"next_prediction","localvar":"my"},{"line":269,"kind":12,"containerName":"next_prediction","name":"new"},{"line":269,"kind":13,"name":"$seqid","containerName":"next_prediction"},{"kind":13,"line":270,"name":"$start","containerName":"next_prediction"},{"line":271,"kind":13,"name":"$end","containerName":"next_prediction"},{"line":272,"kind":13,"containerName":"next_prediction","name":"$strand"},{"kind":13,"line":273,"containerName":"next_prediction","name":"$score"},{"kind":13,"line":274,"name":"$genetag","containerName":"next_prediction"},{"name":"$srctag","containerName":"next_prediction","line":275,"kind":13},{"name":"$type","containerName":"next_prediction","kind":13,"line":279},{"kind":13,"line":280,"name":"$codon","containerName":"next_prediction"},{"name":"$intron_start","containerName":"next_prediction","line":282,"kind":13},{"name":"$intron_start","containerName":"next_prediction","kind":13,"line":283},{"kind":13,"line":283,"name":"$intron_end","containerName":"next_prediction"},{"line":284,"kind":13,"name":"$intron_start","containerName":"next_prediction"},{"kind":13,"line":284,"containerName":"next_prediction","name":"$intron_end"},{"name":"$intron_end","containerName":"next_prediction","line":284,"kind":13},{"line":284,"kind":13,"name":"$intron_start","containerName":"next_prediction"},{"name":"$gene","containerName":"next_prediction","kind":13,"line":286},{"name":"add_SeqFeature","containerName":"next_prediction","line":286,"kind":12},{"line":287,"kind":12,"name":"new","containerName":"next_prediction"},{"line":287,"kind":13,"containerName":"next_prediction","name":"$seqid"},{"containerName":"next_prediction","name":"$start","kind":13,"line":288},{"containerName":"next_prediction","name":"$intron_start","kind":13,"line":289},{"containerName":"next_prediction","name":"$strand","kind":13,"line":290},{"line":291,"kind":13,"name":"$exontag","containerName":"next_prediction"},{"name":"$srctag","containerName":"next_prediction","kind":13,"line":292},{"kind":13,"line":296,"name":"$gene","containerName":"next_prediction"},{"name":"add_SeqFeature","containerName":"next_prediction","line":296,"kind":12},{"kind":12,"line":297,"containerName":"next_prediction","name":"new"},{"kind":13,"line":297,"containerName":"next_prediction","name":"$seqid"},{"line":298,"kind":13,"containerName":"next_prediction","name":"$intron_end"},{"name":"$end","containerName":"next_prediction","line":299,"kind":13},{"containerName":"next_prediction","name":"$strand","line":300,"kind":13},{"containerName":"next_prediction","name":"$exontag","kind":13,"line":301},{"containerName":"next_prediction","name":"$srctag","line":302,"kind":13},{"kind":13,"line":307,"name":"$gene","containerName":"next_prediction"},{"name":"add_SeqFeature","containerName":"next_prediction","line":307,"kind":12},{"name":"new","containerName":"next_prediction","kind":12,"line":308},{"kind":13,"line":308,"name":"$seqid","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$start","kind":13,"line":309},{"kind":13,"line":310,"name":"$end","containerName":"next_prediction"},{"name":"$strand","containerName":"next_prediction","kind":13,"line":311},{"name":"$exontag","containerName":"next_prediction","kind":13,"line":312},{"line":313,"kind":13,"name":"$srctag","containerName":"next_prediction"},{"kind":13,"line":318,"containerName":"next_prediction","name":"$gene"}],"name":"next_prediction","range":{"start":{"character":0,"line":241},"end":{"character":9999,"line":321}}},{"line":268,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":286},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":296},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":307}]}