{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":154},{"name":"postorder_traversal","range":{"end":{"character":9999,"line":199},"start":{"character":0,"line":185}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"postorder_traversal","localvar":"my","kind":13,"line":186},{"definition":"my","name":"@stack","containerName":"postorder_traversal","localvar":"my","kind":13,"line":187},{"kind":13,"line":188,"containerName":"postorder_traversal","name":"@queue","definition":"my","localvar":"my"},{"name":"@stack","containerName":"postorder_traversal","kind":13,"line":189},{"line":189,"kind":13,"containerName":"postorder_traversal","name":"$self"},{"name":"get_root_node","containerName":"postorder_traversal","line":189,"kind":12},{"containerName":"postorder_traversal","name":"@stack","kind":13,"line":190},{"kind":13,"line":191,"name":"$node","definition":"my","containerName":"postorder_traversal","localvar":"my"},{"containerName":"postorder_traversal","name":"@stack","line":191,"kind":13},{"line":192,"kind":13,"name":"@queue","containerName":"postorder_traversal"},{"kind":13,"line":192,"containerName":"postorder_traversal","name":"$node"},{"localvar":"my","definition":"my","name":"$child","containerName":"postorder_traversal","line":193,"kind":13},{"line":193,"kind":13,"name":"$node","containerName":"postorder_traversal"},{"name":"each_Descendent","containerName":"postorder_traversal","kind":12,"line":193},{"name":"@stack","containerName":"postorder_traversal","line":194,"kind":13},{"containerName":"postorder_traversal","name":"$child","line":194,"kind":13},{"kind":13,"line":197,"containerName":"postorder_traversal","name":"@postorder","definition":"my","localvar":"my"},{"line":197,"kind":13,"containerName":"postorder_traversal","name":"@queue"},{"line":198,"kind":13,"name":"@postorder","containerName":"postorder_traversal"}],"line":185,"definition":"sub","containerName":"main::","signature":{"label":"postorder_traversal($self)","documentation":"1;\n# $Id: Compatible.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Compatible\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Compatible - Testing compatibility of phylogenetic trees\nwith nested taxa.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Compatible;\n  use Bio::TreeIO;\n  my $input = Bio::TreeIO->new('-format' => 'newick',\n                               '-file'   => 'input.tre');\n  my $t1 = $input->next_tree;\n  my $t2 = $input->next_tree;\n\n  my ($incompat, $ilabels, $inodes) = Bio::Tree::Compatible::is_compatible($t1,$t2);\n  if ($incompat) {\n    my %cluster1 = %{ Bio::Tree::Compatible::cluster_representation($t1) };\n    my %cluster2 = %{ Bio::Tree::Compatible::cluster_representation($t2) };\n    print \"incompatible trees\\n\";\n    if (scalar(@$ilabels)) {\n      foreach my $label (@$ilabels) {\n        my $node1 = $t1->find_node(-id => $label);\n        my $node2 = $t2->find_node(-id => $label);\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"label $label\";\n        print \" cluster\"; map { print \" \",$_ } @c1;\n        print \" cluster\"; map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n    if (scalar(@$inodes)) {\n      while (@$inodes) {\n        my $node1 = shift @$inodes;\n        my $node2 = shift @$inodes;\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"cluster\"; map { print \" \",$_ } @c1;\n        print \" properly intersects cluster\";\n        map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n  } else {\n    print \"compatible trees\\n\";\n  }\n\n=head1 DESCRIPTION\n\nNB: This module has exclusively class methods that work on Bio::Tree::TreeI\nobjects. An instance of Bio::Tree::Compatible cannot itself represent a tree,\nand so typically there is no need to create one.\n\nBio::Tree::Compatible is a Perl tool for testing compatibility of\nphylogenetic trees with nested taxa represented as Bio::Tree::Tree\nobjects. It is based on a recent characterization of ancestral\ncompatibility of semi-labeled trees in terms of their cluster\nrepresentations.\n\nA semi-labeled tree is a phylogenetic tree with some of its internal\nnodes labeled, and it can represent a classification tree as well as a\nphylogenetic tree with nested taxa, with labeled internal nodes\ncorresponding to taxa at a higher level of aggregation or nesting than\nthat of their descendents.\n\nTwo semi-labeled trees are compatible if their topological\nrestrictions to the common labels are such that for each node label,\nthe smallest clusters containing it in each of the trees coincide and,\nfurthermore, no cluster in one of the trees properly intersects a\ncluster of the other tree.\n\nFuture extensions of Bio::Tree::Compatible include a\nBio::Tree::Supertree module for combining compatible phylogenetic\ntrees with nested taxa into a common supertree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\n\n* * Philip Daniel and Charles Semple. Supertree Algorithms for\nNested Taxa. In: Olaf R. P. Bininda-Emonds (ed.) Phylogenetic\nSupertrees: Combining Information to Reveal the Tree of Life,\nI<Computational Biology>, vol. 4, chap. 7, pp. 151-171. Kluwer (2004).\n\n* * Charles Semple, Philip Daniel, Wim Hordijk, Roderic\nD. M. Page, and Mike Steel: Supertree Algorithms for Ancestral\nDivergence Dates and Nested Taxa. Bioinformatics B<20>(15), 2355-2360\n(2004).\n\n* * Merce Llabres, Jairo Rocha, Francesc Rossello, and Gabriel\nValiente: On the Ancestral Compatibility of Two Phylogenetic Trees\nwith Nested Taxa. J. Math. Biol. B<53>(3), 340-364 (2006).\n\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::Tree::Compatible;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Set::Scalar;\n\nuse base qw(Bio::Root::Root);\n\n=head2 postorder_traversal\n\n Title   : postorder_traversal\n Usage   : my @nodes = @{ $tree->postorder_traversal }\n Function: Return list of nodes in postorder\n Returns : reference to array of Bio::Tree::Node\n Args    : none\n\nFor example, the postorder traversal of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to an array of nodes with\ninternal_id 0 through 9, because the Newick standard representation\nfor phylogenetic trees is based on a postorder traversal.\n\n          +---A                    +---0\n          |                        |\n  +---+---C                +---4---2\n  |   |   |                |   |   |\n  |   |   +---B            |   |   +---1\n  |   |                    |   |\n  +   +-------D            9   +-------3\n  |                        |\n  |     +-----E            |     +-----5\n  |     |                  |     |\n  +-----+-----F            +-----8-----6\n        |                        |\n        +-----G                  +-----7","parameters":[{"label":"$self"}]},"detail":"($self)"},{"line":227,"children":[{"line":228,"kind":13,"localvar":"my","name":"$tree","definition":"my","containerName":"cluster_representation"},{"line":229,"kind":13,"localvar":"my","name":"%cluster","definition":"my","containerName":"cluster_representation"},{"kind":13,"line":230,"definition":"my","name":"@postorder","containerName":"cluster_representation","localvar":"my"},{"containerName":"cluster_representation","name":"$tree","line":230,"kind":13}],"kind":12,"detail":"($tree)","signature":{"label":"cluster_representation($tree)","documentation":"1;\n# $Id: Compatible.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Compatible\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Compatible - Testing compatibility of phylogenetic trees\nwith nested taxa.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Compatible;\n  use Bio::TreeIO;\n  my $input = Bio::TreeIO->new('-format' => 'newick',\n                               '-file'   => 'input.tre');\n  my $t1 = $input->next_tree;\n  my $t2 = $input->next_tree;\n\n  my ($incompat, $ilabels, $inodes) = Bio::Tree::Compatible::is_compatible($t1,$t2);\n  if ($incompat) {\n    my %cluster1 = %{ Bio::Tree::Compatible::cluster_representation($t1) };\n    my %cluster2 = %{ Bio::Tree::Compatible::cluster_representation($t2) };\n    print \"incompatible trees\\n\";\n    if (scalar(@$ilabels)) {\n      foreach my $label (@$ilabels) {\n        my $node1 = $t1->find_node(-id => $label);\n        my $node2 = $t2->find_node(-id => $label);\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"label $label\";\n        print \" cluster\"; map { print \" \",$_ } @c1;\n        print \" cluster\"; map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n    if (scalar(@$inodes)) {\n      while (@$inodes) {\n        my $node1 = shift @$inodes;\n        my $node2 = shift @$inodes;\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"cluster\"; map { print \" \",$_ } @c1;\n        print \" properly intersects cluster\";\n        map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n  } else {\n    print \"compatible trees\\n\";\n  }\n\n=head1 DESCRIPTION\n\nNB: This module has exclusively class methods that work on Bio::Tree::TreeI\nobjects. An instance of Bio::Tree::Compatible cannot itself represent a tree,\nand so typically there is no need to create one.\n\nBio::Tree::Compatible is a Perl tool for testing compatibility of\nphylogenetic trees with nested taxa represented as Bio::Tree::Tree\nobjects. It is based on a recent characterization of ancestral\ncompatibility of semi-labeled trees in terms of their cluster\nrepresentations.\n\nA semi-labeled tree is a phylogenetic tree with some of its internal\nnodes labeled, and it can represent a classification tree as well as a\nphylogenetic tree with nested taxa, with labeled internal nodes\ncorresponding to taxa at a higher level of aggregation or nesting than\nthat of their descendents.\n\nTwo semi-labeled trees are compatible if their topological\nrestrictions to the common labels are such that for each node label,\nthe smallest clusters containing it in each of the trees coincide and,\nfurthermore, no cluster in one of the trees properly intersects a\ncluster of the other tree.\n\nFuture extensions of Bio::Tree::Compatible include a\nBio::Tree::Supertree module for combining compatible phylogenetic\ntrees with nested taxa into a common supertree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\n\n* * Philip Daniel and Charles Semple. Supertree Algorithms for\nNested Taxa. In: Olaf R. P. Bininda-Emonds (ed.) Phylogenetic\nSupertrees: Combining Information to Reveal the Tree of Life,\nI<Computational Biology>, vol. 4, chap. 7, pp. 151-171. Kluwer (2004).\n\n* * Charles Semple, Philip Daniel, Wim Hordijk, Roderic\nD. M. Page, and Mike Steel: Supertree Algorithms for Ancestral\nDivergence Dates and Nested Taxa. Bioinformatics B<20>(15), 2355-2360\n(2004).\n\n* * Merce Llabres, Jairo Rocha, Francesc Rossello, and Gabriel\nValiente: On the Ancestral Compatibility of Two Phylogenetic Trees\nwith Nested Taxa. J. Math. Biol. B<53>(3), 340-364 (2006).\n\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::Tree::Compatible;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Set::Scalar;\n\nuse base qw(Bio::Root::Root);\n\n=head2 postorder_traversal\n\n Title   : postorder_traversal\n Usage   : my @nodes = @{ $tree->postorder_traversal }\n Function: Return list of nodes in postorder\n Returns : reference to array of Bio::Tree::Node\n Args    : none\n\nFor example, the postorder traversal of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to an array of nodes with\ninternal_id 0 through 9, because the Newick standard representation\nfor phylogenetic trees is based on a postorder traversal.\n\n          +---A                    +---0\n          |                        |\n  +---+---C                +---4---2\n  |   |   |                |   |   |\n  |   |   +---B            |   |   +---1\n  |   |                    |   |\n  +   +-------D            9   +-------3\n  |                        |\n  |     +-----E            |     +-----5\n  |     |                  |     |\n  +-----+-----F            +-----8-----6\n        |                        |\n        +-----G                  +-----7\n\n\nsub postorder_traversal {\n  my($self) = @_;\n  my @stack;\n  my @queue;\n  push @stack, $self->get_root_node;\n  while (@stack) {\n    my $node = pop @stack;\n    push @queue, $node;\n    foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n      push @stack, $child;\n    }\n  }\n  my @postorder = reverse @queue;\n  return \\@postorder;\n}\n\n=head2 cluster_representation\n\n Title   : cluster_representation\n Usage   : my %cluster = %{ $tree->cluster_representation }\n Function: Compute the cluster representation of a tree\n Returns : reference to hash of array of string indexed by\n           Bio::Tree::Node\n Args    : none\n\nFor example, the cluster representation of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to a hash associating an array\nof string (descendent labels) to each node, as follows:\n\n  0 --> [A]\n  1 --> [B]\n  2 --> [A,B,C]\n  3 --> [D]\n  4 --> [A,B,C,D]\n  5 --> [E]\n  6 --> [F]\n  7 --> [G]\n  8 --> [E,F,G]\n  9 --> [A,B,C,D,E,F,G]","parameters":[{"label":"$tree"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":230,"character":9999},"start":{"character":0,"line":227}},"name":"cluster_representation"},{"localvar":"my","definition":"my","name":"$node","containerName":null,"line":231,"kind":13},{"containerName":null,"name":"@postorder","kind":13,"line":231},{"kind":13,"line":232,"containerName":null,"name":"@labeled","definition":"my","localvar":"my"},{"line":232,"kind":12,"name":"id","containerName":"main::"},{"name":"id","containerName":"main::","kind":12,"line":232},{"line":232,"kind":13,"name":"$node","containerName":null},{"line":232,"kind":12,"name":"get_Descendents","containerName":"main::"},{"kind":13,"line":233,"containerName":null,"name":"@labeled"},{"line":233,"kind":13,"containerName":null,"name":"$node"},{"kind":12,"line":233,"name":"id","containerName":"main::"},{"containerName":null,"name":"$node","line":233,"kind":13},{"line":233,"kind":12,"containerName":"main::","name":"id"},{"line":234,"kind":13,"name":"%cluster","containerName":null},{"kind":13,"line":234,"containerName":null,"name":"$node"},{"kind":13,"line":234,"name":"@labeled","containerName":null},{"containerName":null,"name":"%cluster","kind":13,"line":236},{"kind":12,"children":[{"line":267,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"common_labels"},{"containerName":"common_labels","name":"$arg","kind":13,"line":267},{"localvar":"my","name":"@labels1","definition":"my","containerName":"common_labels","line":268,"kind":13},{"line":268,"kind":12,"name":"id","containerName":"common_labels"},{"name":"id","containerName":"common_labels","kind":12,"line":268},{"kind":13,"line":268,"containerName":"common_labels","name":"$self"},{"name":"get_nodes","containerName":"common_labels","line":268,"kind":12},{"line":269,"kind":13,"localvar":"my","definition":"my","name":"$common","containerName":"common_labels"},{"kind":12,"line":269,"name":"new","containerName":"common_labels"},{"name":"@labels1","containerName":"common_labels","line":269,"kind":13},{"definition":"my","name":"@labels2","containerName":"common_labels","localvar":"my","kind":13,"line":270},{"line":270,"kind":12,"containerName":"common_labels","name":"id"},{"containerName":"common_labels","name":"id","line":270,"kind":12},{"line":270,"kind":13,"containerName":"common_labels","name":"$arg"},{"line":270,"kind":12,"containerName":"common_labels","name":"get_nodes"},{"line":271,"kind":13,"localvar":"my","containerName":"common_labels","name":"$temp","definition":"my"},{"containerName":"common_labels","name":"new","kind":12,"line":271},{"line":271,"kind":13,"containerName":"common_labels","name":"@labels2"},{"name":"$common","containerName":"common_labels","kind":13,"line":272},{"name":"intersection","containerName":"common_labels","line":272,"kind":12},{"line":272,"kind":13,"containerName":"common_labels","name":"$temp"}],"line":266,"definition":"sub","containerName":"main::","signature":{"label":"common_labels($self,$arg)","documentation":"1;\n# $Id: Compatible.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Compatible\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Compatible - Testing compatibility of phylogenetic trees\nwith nested taxa.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Compatible;\n  use Bio::TreeIO;\n  my $input = Bio::TreeIO->new('-format' => 'newick',\n                               '-file'   => 'input.tre');\n  my $t1 = $input->next_tree;\n  my $t2 = $input->next_tree;\n\n  my ($incompat, $ilabels, $inodes) = Bio::Tree::Compatible::is_compatible($t1,$t2);\n  if ($incompat) {\n    my %cluster1 = %{ Bio::Tree::Compatible::cluster_representation($t1) };\n    my %cluster2 = %{ Bio::Tree::Compatible::cluster_representation($t2) };\n    print \"incompatible trees\\n\";\n    if (scalar(@$ilabels)) {\n      foreach my $label (@$ilabels) {\n        my $node1 = $t1->find_node(-id => $label);\n        my $node2 = $t2->find_node(-id => $label);\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"label $label\";\n        print \" cluster\"; map { print \" \",$_ } @c1;\n        print \" cluster\"; map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n    if (scalar(@$inodes)) {\n      while (@$inodes) {\n        my $node1 = shift @$inodes;\n        my $node2 = shift @$inodes;\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"cluster\"; map { print \" \",$_ } @c1;\n        print \" properly intersects cluster\";\n        map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n  } else {\n    print \"compatible trees\\n\";\n  }\n\n=head1 DESCRIPTION\n\nNB: This module has exclusively class methods that work on Bio::Tree::TreeI\nobjects. An instance of Bio::Tree::Compatible cannot itself represent a tree,\nand so typically there is no need to create one.\n\nBio::Tree::Compatible is a Perl tool for testing compatibility of\nphylogenetic trees with nested taxa represented as Bio::Tree::Tree\nobjects. It is based on a recent characterization of ancestral\ncompatibility of semi-labeled trees in terms of their cluster\nrepresentations.\n\nA semi-labeled tree is a phylogenetic tree with some of its internal\nnodes labeled, and it can represent a classification tree as well as a\nphylogenetic tree with nested taxa, with labeled internal nodes\ncorresponding to taxa at a higher level of aggregation or nesting than\nthat of their descendents.\n\nTwo semi-labeled trees are compatible if their topological\nrestrictions to the common labels are such that for each node label,\nthe smallest clusters containing it in each of the trees coincide and,\nfurthermore, no cluster in one of the trees properly intersects a\ncluster of the other tree.\n\nFuture extensions of Bio::Tree::Compatible include a\nBio::Tree::Supertree module for combining compatible phylogenetic\ntrees with nested taxa into a common supertree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\n\n* * Philip Daniel and Charles Semple. Supertree Algorithms for\nNested Taxa. In: Olaf R. P. Bininda-Emonds (ed.) Phylogenetic\nSupertrees: Combining Information to Reveal the Tree of Life,\nI<Computational Biology>, vol. 4, chap. 7, pp. 151-171. Kluwer (2004).\n\n* * Charles Semple, Philip Daniel, Wim Hordijk, Roderic\nD. M. Page, and Mike Steel: Supertree Algorithms for Ancestral\nDivergence Dates and Nested Taxa. Bioinformatics B<20>(15), 2355-2360\n(2004).\n\n* * Merce Llabres, Jairo Rocha, Francesc Rossello, and Gabriel\nValiente: On the Ancestral Compatibility of Two Phylogenetic Trees\nwith Nested Taxa. J. Math. Biol. B<53>(3), 340-364 (2006).\n\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::Tree::Compatible;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Set::Scalar;\n\nuse base qw(Bio::Root::Root);\n\n=head2 postorder_traversal\n\n Title   : postorder_traversal\n Usage   : my @nodes = @{ $tree->postorder_traversal }\n Function: Return list of nodes in postorder\n Returns : reference to array of Bio::Tree::Node\n Args    : none\n\nFor example, the postorder traversal of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to an array of nodes with\ninternal_id 0 through 9, because the Newick standard representation\nfor phylogenetic trees is based on a postorder traversal.\n\n          +---A                    +---0\n          |                        |\n  +---+---C                +---4---2\n  |   |   |                |   |   |\n  |   |   +---B            |   |   +---1\n  |   |                    |   |\n  +   +-------D            9   +-------3\n  |                        |\n  |     +-----E            |     +-----5\n  |     |                  |     |\n  +-----+-----F            +-----8-----6\n        |                        |\n        +-----G                  +-----7\n\n\nsub postorder_traversal {\n  my($self) = @_;\n  my @stack;\n  my @queue;\n  push @stack, $self->get_root_node;\n  while (@stack) {\n    my $node = pop @stack;\n    push @queue, $node;\n    foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n      push @stack, $child;\n    }\n  }\n  my @postorder = reverse @queue;\n  return \\@postorder;\n}\n\n=head2 cluster_representation\n\n Title   : cluster_representation\n Usage   : my %cluster = %{ $tree->cluster_representation }\n Function: Compute the cluster representation of a tree\n Returns : reference to hash of array of string indexed by\n           Bio::Tree::Node\n Args    : none\n\nFor example, the cluster representation of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to a hash associating an array\nof string (descendent labels) to each node, as follows:\n\n  0 --> [A]\n  1 --> [B]\n  2 --> [A,B,C]\n  3 --> [D]\n  4 --> [A,B,C,D]\n  5 --> [E]\n  6 --> [F]\n  7 --> [G]\n  8 --> [E,F,G]\n  9 --> [A,B,C,D,E,F,G]\n\n\nsub cluster_representation {\n  my ($tree) = @_;\n  my %cluster;\n  my @postorder = @{ postorder_traversal($tree) };\n  foreach my $node ( @postorder ) {\n    my @labeled = map { $_->id } grep { $_->id } $node->get_Descendents;\n    push @labeled, $node->id if $node->id;\n    $cluster{$node} = \\@labeled;\n  }\n  return \\%cluster;\n}\n\n=head2 common_labels\n\n Title   : common_labels\n Usage   : my $labels = $tree1->common_labels($tree2);\n Function: Return set of common node labels\n Returns : Set::Scalar\n Args    : Bio::Tree::Tree\n\nFor example, the common labels of the tree C<(((A,B)C,D),(E,F,G));>\nand the tree C<((A,B)H,E,(J,(K)G)I);> are: C<[A,B,E,G]>.\n\n          +---A                 +---A\n          |                     |\n  +---+---C             +-------H\n  |   |   |             |       |\n  |   |   +---B         |       +---B\n  |   |                 |\n  +   +-------D         +-----------E\n  |                     |\n  |     +-----E         |   +-------J\n  |     |               |   |\n  +-----+-----F         +---I\n        |                   |\n        +-----G             +---G---K","parameters":[{"label":"$self"},{"label":"$arg"}]},"detail":"($self,$arg)","name":"common_labels","range":{"end":{"character":9999,"line":273},"start":{"character":0,"line":266}}},{"name":"Set","containerName":"Scalar","kind":12,"line":269},{"name":"Set","containerName":"Scalar","line":271,"kind":12},{"line":302,"children":[{"localvar":"my","name":"$tree","definition":"my","containerName":"topological_restriction","line":303,"kind":13},{"kind":13,"line":303,"containerName":"topological_restriction","name":"$labels"},{"localvar":"my","name":"$node","definition":"my","containerName":"topological_restriction","line":304,"kind":13},{"name":"$tree","containerName":"topological_restriction","kind":13,"line":304}],"kind":12,"detail":"($tree,$labels)","signature":{"documentation":"1;\n# $Id: Compatible.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Compatible\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Compatible - Testing compatibility of phylogenetic trees\nwith nested taxa.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Compatible;\n  use Bio::TreeIO;\n  my $input = Bio::TreeIO->new('-format' => 'newick',\n                               '-file'   => 'input.tre');\n  my $t1 = $input->next_tree;\n  my $t2 = $input->next_tree;\n\n  my ($incompat, $ilabels, $inodes) = Bio::Tree::Compatible::is_compatible($t1,$t2);\n  if ($incompat) {\n    my %cluster1 = %{ Bio::Tree::Compatible::cluster_representation($t1) };\n    my %cluster2 = %{ Bio::Tree::Compatible::cluster_representation($t2) };\n    print \"incompatible trees\\n\";\n    if (scalar(@$ilabels)) {\n      foreach my $label (@$ilabels) {\n        my $node1 = $t1->find_node(-id => $label);\n        my $node2 = $t2->find_node(-id => $label);\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"label $label\";\n        print \" cluster\"; map { print \" \",$_ } @c1;\n        print \" cluster\"; map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n    if (scalar(@$inodes)) {\n      while (@$inodes) {\n        my $node1 = shift @$inodes;\n        my $node2 = shift @$inodes;\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"cluster\"; map { print \" \",$_ } @c1;\n        print \" properly intersects cluster\";\n        map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n  } else {\n    print \"compatible trees\\n\";\n  }\n\n=head1 DESCRIPTION\n\nNB: This module has exclusively class methods that work on Bio::Tree::TreeI\nobjects. An instance of Bio::Tree::Compatible cannot itself represent a tree,\nand so typically there is no need to create one.\n\nBio::Tree::Compatible is a Perl tool for testing compatibility of\nphylogenetic trees with nested taxa represented as Bio::Tree::Tree\nobjects. It is based on a recent characterization of ancestral\ncompatibility of semi-labeled trees in terms of their cluster\nrepresentations.\n\nA semi-labeled tree is a phylogenetic tree with some of its internal\nnodes labeled, and it can represent a classification tree as well as a\nphylogenetic tree with nested taxa, with labeled internal nodes\ncorresponding to taxa at a higher level of aggregation or nesting than\nthat of their descendents.\n\nTwo semi-labeled trees are compatible if their topological\nrestrictions to the common labels are such that for each node label,\nthe smallest clusters containing it in each of the trees coincide and,\nfurthermore, no cluster in one of the trees properly intersects a\ncluster of the other tree.\n\nFuture extensions of Bio::Tree::Compatible include a\nBio::Tree::Supertree module for combining compatible phylogenetic\ntrees with nested taxa into a common supertree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\n\n* * Philip Daniel and Charles Semple. Supertree Algorithms for\nNested Taxa. In: Olaf R. P. Bininda-Emonds (ed.) Phylogenetic\nSupertrees: Combining Information to Reveal the Tree of Life,\nI<Computational Biology>, vol. 4, chap. 7, pp. 151-171. Kluwer (2004).\n\n* * Charles Semple, Philip Daniel, Wim Hordijk, Roderic\nD. M. Page, and Mike Steel: Supertree Algorithms for Ancestral\nDivergence Dates and Nested Taxa. Bioinformatics B<20>(15), 2355-2360\n(2004).\n\n* * Merce Llabres, Jairo Rocha, Francesc Rossello, and Gabriel\nValiente: On the Ancestral Compatibility of Two Phylogenetic Trees\nwith Nested Taxa. J. Math. Biol. B<53>(3), 340-364 (2006).\n\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::Tree::Compatible;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Set::Scalar;\n\nuse base qw(Bio::Root::Root);\n\n=head2 postorder_traversal\n\n Title   : postorder_traversal\n Usage   : my @nodes = @{ $tree->postorder_traversal }\n Function: Return list of nodes in postorder\n Returns : reference to array of Bio::Tree::Node\n Args    : none\n\nFor example, the postorder traversal of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to an array of nodes with\ninternal_id 0 through 9, because the Newick standard representation\nfor phylogenetic trees is based on a postorder traversal.\n\n          +---A                    +---0\n          |                        |\n  +---+---C                +---4---2\n  |   |   |                |   |   |\n  |   |   +---B            |   |   +---1\n  |   |                    |   |\n  +   +-------D            9   +-------3\n  |                        |\n  |     +-----E            |     +-----5\n  |     |                  |     |\n  +-----+-----F            +-----8-----6\n        |                        |\n        +-----G                  +-----7\n\n\nsub postorder_traversal {\n  my($self) = @_;\n  my @stack;\n  my @queue;\n  push @stack, $self->get_root_node;\n  while (@stack) {\n    my $node = pop @stack;\n    push @queue, $node;\n    foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n      push @stack, $child;\n    }\n  }\n  my @postorder = reverse @queue;\n  return \\@postorder;\n}\n\n=head2 cluster_representation\n\n Title   : cluster_representation\n Usage   : my %cluster = %{ $tree->cluster_representation }\n Function: Compute the cluster representation of a tree\n Returns : reference to hash of array of string indexed by\n           Bio::Tree::Node\n Args    : none\n\nFor example, the cluster representation of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to a hash associating an array\nof string (descendent labels) to each node, as follows:\n\n  0 --> [A]\n  1 --> [B]\n  2 --> [A,B,C]\n  3 --> [D]\n  4 --> [A,B,C,D]\n  5 --> [E]\n  6 --> [F]\n  7 --> [G]\n  8 --> [E,F,G]\n  9 --> [A,B,C,D,E,F,G]\n\n\nsub cluster_representation {\n  my ($tree) = @_;\n  my %cluster;\n  my @postorder = @{ postorder_traversal($tree) };\n  foreach my $node ( @postorder ) {\n    my @labeled = map { $_->id } grep { $_->id } $node->get_Descendents;\n    push @labeled, $node->id if $node->id;\n    $cluster{$node} = \\@labeled;\n  }\n  return \\%cluster;\n}\n\n=head2 common_labels\n\n Title   : common_labels\n Usage   : my $labels = $tree1->common_labels($tree2);\n Function: Return set of common node labels\n Returns : Set::Scalar\n Args    : Bio::Tree::Tree\n\nFor example, the common labels of the tree C<(((A,B)C,D),(E,F,G));>\nand the tree C<((A,B)H,E,(J,(K)G)I);> are: C<[A,B,E,G]>.\n\n          +---A                 +---A\n          |                     |\n  +---+---C             +-------H\n  |   |   |             |       |\n  |   |   +---B         |       +---B\n  |   |                 |\n  +   +-------D         +-----------E\n  |                     |\n  |     +-----E         |   +-------J\n  |     |               |   |\n  +-----+-----F         +---I\n        |                   |\n        +-----G             +---G---K\n\n\nsub common_labels {\n  my($self,$arg) = @_;\n  my @labels1 = map { $_->id } grep { $_->id } $self->get_nodes;\n  my $common = Set::Scalar->new( @labels1 );\n  my @labels2 = map { $_->id } grep { $_->id } $arg->get_nodes;\n  my $temp = Set::Scalar->new( @labels2 );\n  return $common->intersection($temp);\n}\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : $tree->topological_restriction($labels)\n Function: Compute the topological restriction of a tree to a subset\n           of node labels\n Returns : Bio::Tree::Tree\n Args    : Set::Scalar\n\nFor example, the topological restrictions of each of the trees\nC<(((A,B)C,D),(E,F,G));> and C<((A,B)H,E,(J,(K)G)I);> to the labels\nC<[A,B,E,G]> are as follows:\n\n          +---A             +---A\n          |                 |\n  +---+---+             +---+\n  |       |             |   |\n  |       +---B         |   +---B\n  +                     |\n  |       +---E         +-------E\n  |       |             |\n  +-------+             +---+---G\n          |\n          +---G","parameters":[{"label":"$tree"},{"label":"$labels"}],"label":"topological_restriction($tree,$labels)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":304},"start":{"line":302,"character":0}},"name":"topological_restriction"},{"name":"%node","containerName":null,"line":305,"kind":13},{"line":306,"kind":13,"localvar":"my","containerName":null,"name":"@cluster","definition":"my"},{"line":306,"kind":12,"containerName":"main::","name":"id"},{"containerName":"main::","name":"id","kind":12,"line":306},{"containerName":null,"name":"$node","kind":13,"line":306},{"line":306,"kind":12,"name":"get_Descendents","containerName":"main::"},{"name":"@cluster","containerName":null,"line":307,"kind":13},{"kind":13,"line":307,"containerName":null,"name":"$node"},{"name":"id","containerName":"main::","kind":12,"line":307},{"kind":13,"line":307,"name":"$node","containerName":null},{"line":307,"kind":12,"containerName":"main::","name":"id"},{"line":308,"kind":13,"localvar":"my","containerName":null,"name":"$cluster","definition":"my"},{"kind":12,"line":308,"name":"Set","containerName":"Scalar"},{"kind":12,"line":308,"name":"new","containerName":"main::"},{"containerName":null,"name":"@cluster","line":308,"kind":13},{"containerName":null,"name":"$cluster","line":309,"kind":13},{"kind":12,"line":309,"containerName":"main::","name":"is_disjoint"},{"line":309,"kind":13,"containerName":null,"name":"%labels"},{"kind":13,"line":310,"name":"$tree","containerName":null},{"name":"remove_Node","containerName":"main::","kind":12,"line":310},{"containerName":null,"name":"%node","line":310,"kind":13},{"name":"$node","containerName":null,"line":312,"kind":13},{"kind":12,"line":312,"containerName":"main::","name":"id"},{"name":"$labels","containerName":null,"line":312,"kind":13},{"line":312,"kind":12,"containerName":"main::","name":"has"},{"kind":13,"line":312,"containerName":null,"name":"$node"},{"kind":12,"line":312,"name":"id","containerName":"main::"},{"kind":13,"line":313,"name":"%node","containerName":null},{"children":[{"definition":"my","name":"$tree1","containerName":"is_compatible","localvar":"my","kind":13,"line":386},{"line":386,"kind":13,"name":"$tree2","containerName":"is_compatible"},{"containerName":"is_compatible","definition":"my","name":"$common","localvar":"my","kind":13,"line":387},{"kind":13,"line":387,"containerName":"is_compatible","name":"$tree1"},{"name":"$tree2","containerName":"is_compatible","kind":13,"line":387},{"kind":13,"line":388,"containerName":"is_compatible","name":"$tree1"},{"kind":13,"line":388,"name":"$common","containerName":"is_compatible"},{"kind":13,"line":389,"containerName":"is_compatible","name":"$tree2"},{"name":"$common","containerName":"is_compatible","line":389,"kind":13},{"localvar":"my","containerName":"is_compatible","definition":"my","name":"@postorder1","line":390,"kind":13},{"containerName":"is_compatible","name":"$tree1","line":390,"kind":13}],"line":385,"kind":12,"signature":{"parameters":[{"label":"$tree1"},{"label":"$tree2"}],"documentation":"1;\n# $Id: Compatible.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Compatible\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Compatible - Testing compatibility of phylogenetic trees\nwith nested taxa.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Compatible;\n  use Bio::TreeIO;\n  my $input = Bio::TreeIO->new('-format' => 'newick',\n                               '-file'   => 'input.tre');\n  my $t1 = $input->next_tree;\n  my $t2 = $input->next_tree;\n\n  my ($incompat, $ilabels, $inodes) = Bio::Tree::Compatible::is_compatible($t1,$t2);\n  if ($incompat) {\n    my %cluster1 = %{ Bio::Tree::Compatible::cluster_representation($t1) };\n    my %cluster2 = %{ Bio::Tree::Compatible::cluster_representation($t2) };\n    print \"incompatible trees\\n\";\n    if (scalar(@$ilabels)) {\n      foreach my $label (@$ilabels) {\n        my $node1 = $t1->find_node(-id => $label);\n        my $node2 = $t2->find_node(-id => $label);\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"label $label\";\n        print \" cluster\"; map { print \" \",$_ } @c1;\n        print \" cluster\"; map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n    if (scalar(@$inodes)) {\n      while (@$inodes) {\n        my $node1 = shift @$inodes;\n        my $node2 = shift @$inodes;\n        my @c1 = sort @{ $cluster1{$node1} };\n        my @c2 = sort @{ $cluster2{$node2} };\n        print \"cluster\"; map { print \" \",$_ } @c1;\n        print \" properly intersects cluster\";\n        map { print \" \",$_ } @c2; print \"\\n\";\n      }\n    }\n  } else {\n    print \"compatible trees\\n\";\n  }\n\n=head1 DESCRIPTION\n\nNB: This module has exclusively class methods that work on Bio::Tree::TreeI\nobjects. An instance of Bio::Tree::Compatible cannot itself represent a tree,\nand so typically there is no need to create one.\n\nBio::Tree::Compatible is a Perl tool for testing compatibility of\nphylogenetic trees with nested taxa represented as Bio::Tree::Tree\nobjects. It is based on a recent characterization of ancestral\ncompatibility of semi-labeled trees in terms of their cluster\nrepresentations.\n\nA semi-labeled tree is a phylogenetic tree with some of its internal\nnodes labeled, and it can represent a classification tree as well as a\nphylogenetic tree with nested taxa, with labeled internal nodes\ncorresponding to taxa at a higher level of aggregation or nesting than\nthat of their descendents.\n\nTwo semi-labeled trees are compatible if their topological\nrestrictions to the common labels are such that for each node label,\nthe smallest clusters containing it in each of the trees coincide and,\nfurthermore, no cluster in one of the trees properly intersects a\ncluster of the other tree.\n\nFuture extensions of Bio::Tree::Compatible include a\nBio::Tree::Supertree module for combining compatible phylogenetic\ntrees with nested taxa into a common supertree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\n\n* * Philip Daniel and Charles Semple. Supertree Algorithms for\nNested Taxa. In: Olaf R. P. Bininda-Emonds (ed.) Phylogenetic\nSupertrees: Combining Information to Reveal the Tree of Life,\nI<Computational Biology>, vol. 4, chap. 7, pp. 151-171. Kluwer (2004).\n\n* * Charles Semple, Philip Daniel, Wim Hordijk, Roderic\nD. M. Page, and Mike Steel: Supertree Algorithms for Ancestral\nDivergence Dates and Nested Taxa. Bioinformatics B<20>(15), 2355-2360\n(2004).\n\n* * Merce Llabres, Jairo Rocha, Francesc Rossello, and Gabriel\nValiente: On the Ancestral Compatibility of Two Phylogenetic Trees\nwith Nested Taxa. J. Math. Biol. B<53>(3), 340-364 (2006).\n\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::Tree::Compatible;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Set::Scalar;\n\nuse base qw(Bio::Root::Root);\n\n=head2 postorder_traversal\n\n Title   : postorder_traversal\n Usage   : my @nodes = @{ $tree->postorder_traversal }\n Function: Return list of nodes in postorder\n Returns : reference to array of Bio::Tree::Node\n Args    : none\n\nFor example, the postorder traversal of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to an array of nodes with\ninternal_id 0 through 9, because the Newick standard representation\nfor phylogenetic trees is based on a postorder traversal.\n\n          +---A                    +---0\n          |                        |\n  +---+---C                +---4---2\n  |   |   |                |   |   |\n  |   |   +---B            |   |   +---1\n  |   |                    |   |\n  +   +-------D            9   +-------3\n  |                        |\n  |     +-----E            |     +-----5\n  |     |                  |     |\n  +-----+-----F            +-----8-----6\n        |                        |\n        +-----G                  +-----7\n\n\nsub postorder_traversal {\n  my($self) = @_;\n  my @stack;\n  my @queue;\n  push @stack, $self->get_root_node;\n  while (@stack) {\n    my $node = pop @stack;\n    push @queue, $node;\n    foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n      push @stack, $child;\n    }\n  }\n  my @postorder = reverse @queue;\n  return \\@postorder;\n}\n\n=head2 cluster_representation\n\n Title   : cluster_representation\n Usage   : my %cluster = %{ $tree->cluster_representation }\n Function: Compute the cluster representation of a tree\n Returns : reference to hash of array of string indexed by\n           Bio::Tree::Node\n Args    : none\n\nFor example, the cluster representation of the tree\nC<(((A,B)C,D),(E,F,G));> is a reference to a hash associating an array\nof string (descendent labels) to each node, as follows:\n\n  0 --> [A]\n  1 --> [B]\n  2 --> [A,B,C]\n  3 --> [D]\n  4 --> [A,B,C,D]\n  5 --> [E]\n  6 --> [F]\n  7 --> [G]\n  8 --> [E,F,G]\n  9 --> [A,B,C,D,E,F,G]\n\n\nsub cluster_representation {\n  my ($tree) = @_;\n  my %cluster;\n  my @postorder = @{ postorder_traversal($tree) };\n  foreach my $node ( @postorder ) {\n    my @labeled = map { $_->id } grep { $_->id } $node->get_Descendents;\n    push @labeled, $node->id if $node->id;\n    $cluster{$node} = \\@labeled;\n  }\n  return \\%cluster;\n}\n\n=head2 common_labels\n\n Title   : common_labels\n Usage   : my $labels = $tree1->common_labels($tree2);\n Function: Return set of common node labels\n Returns : Set::Scalar\n Args    : Bio::Tree::Tree\n\nFor example, the common labels of the tree C<(((A,B)C,D),(E,F,G));>\nand the tree C<((A,B)H,E,(J,(K)G)I);> are: C<[A,B,E,G]>.\n\n          +---A                 +---A\n          |                     |\n  +---+---C             +-------H\n  |   |   |             |       |\n  |   |   +---B         |       +---B\n  |   |                 |\n  +   +-------D         +-----------E\n  |                     |\n  |     +-----E         |   +-------J\n  |     |               |   |\n  +-----+-----F         +---I\n        |                   |\n        +-----G             +---G---K\n\n\nsub common_labels {\n  my($self,$arg) = @_;\n  my @labels1 = map { $_->id } grep { $_->id } $self->get_nodes;\n  my $common = Set::Scalar->new( @labels1 );\n  my @labels2 = map { $_->id } grep { $_->id } $arg->get_nodes;\n  my $temp = Set::Scalar->new( @labels2 );\n  return $common->intersection($temp);\n}\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : $tree->topological_restriction($labels)\n Function: Compute the topological restriction of a tree to a subset\n           of node labels\n Returns : Bio::Tree::Tree\n Args    : Set::Scalar\n\nFor example, the topological restrictions of each of the trees\nC<(((A,B)C,D),(E,F,G));> and C<((A,B)H,E,(J,(K)G)I);> to the labels\nC<[A,B,E,G]> are as follows:\n\n          +---A             +---A\n          |                 |\n  +---+---+             +---+\n  |       |             |   |\n  |       +---B         |   +---B\n  +                     |\n  |       +---E         +-------E\n  |       |             |\n  +-------+             +---+---G\n          |\n          +---G\n\n\nsub topological_restriction {\n  my ($tree, $labels) = @_;\n  for my $node ( @{ postorder_traversal($tree) } ) {\n    unless (ref($node)) { # skip $node if already removed\n      my @cluster = map { $_->id } grep { $_->id } $node->get_Descendents;\n      push @cluster, $node->id if $node->id;\n      my $cluster = Set::Scalar->new(@cluster);\n      if ($cluster->is_disjoint($labels)) {\n        $tree->remove_Node($node);\n      } else {\n        if ($node->id and not $labels->has($node->id)) {\n          $node->{'_id'} = undef;\n        }\n      }\n    }\n  }\n}\n\n=head2 is_compatible\n\n Title   : is_compatible\n Usage   : $tree1->is_compatible($tree2)\n Function: Test compatibility of two trees\n Returns : boolean\n Args    : Bio::Tree::Tree\n\nFor example, the topological restrictions of the trees\nC<(((A,B)C,D),(E,F,G));> and C<((A,B)H,E,(J,(K)G)I);> to their common\nlabels, C<[A,B,E,G]>, are compatible. The respective cluster\nrepresentations are as follows:\n\n  [A]                  [A]\n  [B]                  [B]\n  [E]                  [E]\n  [G]                  [G]\n  [A,B]                [A,B]\n  [E,G]                [A,B,E,G]\n  [A,B,E,G]\n\nAs a second example, the trees C<(A,B);> and C<((B)A);> are\nincompatible. Their respective cluster representations are as follows:\n\n  [A]                  [B]\n  [B]                  [A,B]\n  [A,B]\n\nThe reason is, the smallest cluster containing label C<A> is C<[A]> in\nthe first tree but C<[A,B]> in the second tree.\n\n +---A         A---B\n |\n +\n |\n +---B\n\nAs a second example, the trees C<(((B,A),C),D);> and C<((A,(D,B)),C);>\nare also incompatible. Their respective cluster representations are as\nfollows:\n\n  [A]                  [A]\n  [B]                  [B]\n  [C]                  [C]\n  [D]                  [D]\n  [A,B]                [B,D]\n  [A,B,C]              [A,B,D]\n  [A,B,C,D]            [A,B,C,D]\n\nThe reason is, cluster C<[A,B]> properly intersects cluster\nC<[B,D]>. There are further incompatibilities between these trees:\nC<[A,B,C]> properly intersects both C<[B,D]> and C<[A,B,D]>.\n\n          +---B             +-------A\n          |                 |\n      +---+             +---+   +---D\n      |   |             |   |   |\n  +---+   +---A         |   +---+\n  |   |                 +       |\n  +   +-------C         |       +---B\n  |                     |\n  +-----------D         +-----------C","label":"is_compatible($tree1,$tree2)"},"detail":"($tree1,$tree2)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":385},"end":{"character":9999,"line":390}},"name":"is_compatible"},{"line":387,"kind":12,"name":"Bio","containerName":"Tree::Compatible::common_labels"},{"kind":12,"line":388,"name":"Bio","containerName":"Tree::Compatible::topological_restriction"},{"containerName":"Tree::Compatible::topological_restriction","name":"Bio","kind":12,"line":389},{"localvar":"my","containerName":null,"name":"@postorder2","definition":"my","line":391,"kind":13},{"containerName":null,"name":"$tree2","line":391,"kind":13},{"kind":13,"line":392,"containerName":null,"definition":"my","name":"%cluster1","localvar":"my"},{"containerName":null,"name":"$tree1","line":392,"kind":13},{"name":"%cluster2","definition":"my","containerName":null,"localvar":"my","kind":13,"line":393},{"name":"$tree2","containerName":null,"line":393,"kind":13},{"kind":13,"line":394,"containerName":null,"definition":"my","name":"$incompat","localvar":"my"},{"kind":13,"line":395,"containerName":null,"definition":"my","name":"@labels","localvar":"my"},{"line":396,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$label"},{"containerName":null,"name":"$common","kind":13,"line":396},{"kind":12,"line":396,"name":"elements","containerName":"main::"},{"localvar":"my","definition":"my","name":"$node1","containerName":null,"line":397,"kind":13},{"line":397,"kind":13,"name":"$tree1","containerName":null},{"containerName":"main::","name":"find_node","kind":12,"line":397},{"containerName":null,"name":"$label","kind":13,"line":397},{"containerName":null,"definition":"my","name":"@labels1","localvar":"my","kind":13,"line":398},{"name":"%cluster1","containerName":null,"kind":13,"line":398},{"line":398,"kind":13,"containerName":null,"name":"$node1"},{"kind":13,"line":399,"containerName":null,"definition":"my","name":"$cluster1","localvar":"my"},{"kind":12,"line":399,"name":"Set","containerName":"Scalar"},{"name":"new","containerName":"main::","kind":12,"line":399},{"name":"@labels1","containerName":null,"kind":13,"line":399},{"definition":"my","name":"$node2","containerName":null,"localvar":"my","kind":13,"line":400},{"name":"$tree2","containerName":null,"line":400,"kind":13},{"name":"find_node","containerName":"main::","line":400,"kind":12},{"line":400,"kind":13,"name":"$label","containerName":null},{"definition":"my","name":"@labels2","containerName":null,"localvar":"my","kind":13,"line":401},{"name":"%cluster2","containerName":null,"kind":13,"line":401},{"kind":13,"line":401,"name":"$node2","containerName":null},{"localvar":"my","containerName":null,"name":"$cluster2","definition":"my","line":402,"kind":13},{"name":"Set","containerName":"Scalar","line":402,"kind":12},{"containerName":"main::","name":"new","kind":12,"line":402},{"name":"@labels2","containerName":null,"kind":13,"line":402},{"kind":13,"line":403,"containerName":null,"name":"$cluster1"},{"name":"is_equal","containerName":"main::","line":403,"kind":12},{"name":"%cluster2","containerName":null,"line":403,"kind":13},{"line":404,"kind":13,"containerName":null,"name":"$incompat"},{"containerName":null,"name":"@labels","line":405,"kind":13},{"line":405,"kind":13,"containerName":null,"name":"$label"},{"line":408,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@nodes"},{"localvar":"my","containerName":null,"definition":"my","name":"$node1","line":409,"kind":13},{"name":"@postorder1","containerName":null,"line":409,"kind":13},{"localvar":"my","name":"@labels1","definition":"my","containerName":null,"line":410,"kind":13},{"kind":13,"line":410,"name":"%cluster1","containerName":null},{"line":410,"kind":13,"name":"$node1","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$cluster1","line":411,"kind":13},{"line":411,"kind":12,"containerName":"Scalar","name":"Set"},{"name":"new","containerName":"main::","kind":12,"line":411},{"kind":13,"line":411,"name":"@labels1","containerName":null},{"kind":13,"line":412,"containerName":null,"definition":"my","name":"$node2","localvar":"my"},{"containerName":null,"name":"@postorder2","line":412,"kind":13},{"kind":13,"line":413,"name":"@labels2","definition":"my","containerName":null,"localvar":"my"},{"name":"%cluster2","containerName":null,"kind":13,"line":413},{"line":413,"kind":13,"containerName":null,"name":"$node2"},{"name":"$cluster2","definition":"my","containerName":null,"localvar":"my","kind":13,"line":414},{"line":414,"kind":12,"name":"Set","containerName":"Scalar"},{"containerName":"main::","name":"new","line":414,"kind":12},{"name":"@labels2","containerName":null,"kind":13,"line":414},{"line":415,"kind":13,"name":"$cluster1","containerName":null},{"name":"is_properly_intersecting","containerName":"main::","kind":12,"line":415},{"line":415,"kind":13,"containerName":null,"name":"%cluster2"},{"name":"$incompat","containerName":null,"kind":13,"line":416},{"line":417,"kind":13,"containerName":null,"name":"@nodes"},{"containerName":null,"name":"$node1","kind":13,"line":417},{"name":"$node2","containerName":null,"kind":13,"line":417},{"containerName":null,"name":"$incompat","kind":13,"line":421},{"containerName":null,"name":"@labels","line":421,"kind":13},{"line":421,"kind":13,"containerName":null,"name":"@nodes"}]}